#!/bin/sh
# MetaCard 2.4 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                   Personal Organiser  )?local timer_list, titles_list

on mouseup
end mouseup

on preopenstack
  --send "mouseup" to btn "today" --uncomment this to go to today at startup
  hiliteday 4 --sets up the variables with June 4th which has sample appointment
  --swap comments on last two lines for a more useful calendar when you've explored the
  --sample appointments
  --commented to allow you to view the "sample" appointments at the beginning of June 97
  --+292,-250
  global dissection_mode, current_record
  put 1 into current_record --prevent bug with finding records
  click at 14,41
  if there is a button "image_button" then hide btn "image_button"
  if dissection_mode is true then
    go cd 1
    show group "other_dissection_group"
    show group "diary_dissection_group"
    if the lookandfeel is "motif" then
      hide control "close_dissection"
      hide control "resize_dissection"
      hide image "arrow1"
      hide image "arrow2"
    else
      show control "close_dissection"
      show control "resize_dissection"
      show image "arrow1"
      show image "arrow2"
    end if
  else
    hide group "other_dissection_group"
    hide group "diary_dissection_group"
    hide image "arrow2"
    hide image "arrow1"
  end if
  hide group "contacts_dissection_group"
end preopenstack

on createrecord
  global field_changed, current_day, current_record, var_name, do_me, record_exists, record_id, search_var, endline, the_var
  local n_start_line, start_line
  put false into field_changed
  if fld "title" is empty then put "Title?" into fld "title"
  --current_record will be this record number, check if it exists and alter it or create it
  if current_day is in the customkeys of group "diary" then
    --the day exists
    put "times"&current_day into var_name
    put "put the " & var_name & " of group " & quote & "diary" & quote & " into timer_list" into do_me
    do do_me
    if line current_record of timer_list is empty then put false into record_exists else put true into record_exists
  else
    --the day does not exist
    put false into record_exists
  end if
  if record_exists is false then
    put "times"&current_day into var_name
    if var_name is in the customkeys of group "diary" then
      put "get the " & var_name & " of group " & quote & "diary" & quote into do_me
      do do_me
      put item_one_max(it) + 1 into record_id
    else
      get the customkeys of group "diary"
      put var_name after it
      set the customkeys of group "diary" to it
      put 1 into record_id
      put "" into it
    end if
    put record_id&","& fld "timer" into line current_record of it
    sort lines of it by word 1 of item 2 of each
    sort lines of it by word 2 of item 2 of each
    put 0 into start_line
    repeat
      -- put lineoffset(record_id,it) into current_record
      put lineoffset(record_id,it,start_line) into n_start_line
      if item 1 of line (n_start_line+start_line) of it is record_id then
        put (n_start_line+start_line) into current_record
        exit repeat
      end if
      add n_start_line to start_line
    end repeat
    put "Appointment " & current_record & " of " & the num of lines in it & "." into fld "record_title"
    put "set the " & var_name & " of group " & quote & "diary" & quote & " to it" into do_me
    do do_me
    
    put "titles"&current_day into var_name
    if var_name is in the customkeys of group "diary" then
      put "get the " & var_name & " of group " & quote & "diary" & quote into do_me
      do do_me
    else
      get the customkeys of group "diary"
      put var_name after it
      set the customkeys of group "diary" to it
      put "" into it
    end if
    put record_id&","& fld "title" into line current_record of it
    put "set the " & var_name & " of group " & quote & "diary" & quote & " to it" into do_me
    do do_me
    
    put "notes"&current_day&record_id into var_name
    do "set the " & var_name & " of group " & quote & "diary" & quote & " to fld " & quote & "notes" & quote
  else
    put item 1 of line current_record of timer_list into record_id
    put record_id&"," & fld "timer" into line current_record of timer_list
    sort lines of timer_list by word 1 of item 2 of each
    sort lines of timer_list by word 2 of item 2 of each
    -- put lineoffset(record_id,timer_list) into current_record
    put 0 into start_line
    repeat
      -- put lineoffset(record_id,it) into current_record
      put lineoffset(record_id,timer_list,start_line) into n_start_line
      if item 1 of line (n_start_line+start_line) of timer_list is record_id then
        put (n_start_line+start_line) into current_record
        exit repeat
      end if
      add n_start_line to start_line
    end repeat
    put "Appointment " & current_record & " of " & the num of lines in timer_list & "." into fld "record_title"
    put "set the " & var_name & " of group " & quote & "diary" & quote & " to timer_list" into do_me
    do do_me
    
    put "titles"&current_day into var_name
    put "put the " & var_name & " of group " & quote & "diary" & quote & " into titles_list" into do_me
    do do_me
    get lineoffset(record_id,titles_list)
    put record_id&","& fld "title" into line it of titles_list
    put "set the " & var_name & " of group " & quote & "diary" & quote & " to titles_list" into do_me
    do do_me
    
    put "notes"&current_day&record_id into search_var
    put "set the " & search_var & " of group " & quote & "diary" & quote & " to fld " & quote & "notes" & quote into do_me
    do do_me
  end if
end createrecord

on hiliteday the_day, the_button
  global prev_day, current_day, current_record, the_var, field_changed
  put false into field_changed
  put 1 into current_record
  get the month of group "calendar"
  convert it to dateitems
  put the_day into item 3 of it
  convert it to abbreviated date
  put it into fld "date"
  convert it to seconds
  put it into current_day
  if prev_day is empty then
    repeat with i = 1 to the num of btns in group "calendar"
      set the hilite of btn i of group "calendar" to false
    end repeat
  else
    set the hilite of btn prev_day of group "calendar" to false
  end if
  if the_button is not empty then
    set the hilite of btn the_button of group "calendar" to true
    put the_button into prev_day
  else
    put the_day into the_var
    repeat
      get the label of btn the_var of group "calendar"
      if it = the_day then exit repeat
      add 1 to the_var
    end repeat
    set the hilite of btn the_var of group "calendar" to true
    put the_var into prev_day
  end if
end hiliteday

on displayrecord
  global field_changed, current_day, current_record, var_name, do_me, record_exists, the_record, record_id, search_var, endline
  lock screen
  put false into field_changed
  if current_day is in the customkeys of group "diary" then
    put "times"&current_day into var_name
    put "put the " & var_name & " of group " & quote & "diary" & quote & " into timer_list" into do_me
    do do_me
    if line current_record of timer_list is empty then put false into record_exists else put true into record_exists
  else
    --the day does not exist
    put false into record_exists
  end if
  if record_exists is false then
    put "01:00 PM" into fld "timer"
    put empty into fld "notes"
    put empty into fld "title"
    put "Appointment 1 of 1." into fld "record_title"
  else
    
    put "Appointment " & current_record & " of " & the num of lines in timer_list & "." into fld "record_title"
    
    put line current_record of timer_list into the_record
    put item 1 the_record into record_id
    delete item 1 of the_record
    put the_record into fld "timer"
    
    put "titles"&current_day into var_name
    put "get the " & var_name & " of group " & quote & "diary" & quote into do_me
    do do_me
    put it into titles_list
    get lineoffset(record_id,titles_list)
    put line it of titles_list into the_record
    delete item 1 of the_record
    put the_record into fld "title"
    
    put "notes"&current_day&record_id into search_var
    put "put the " & search_var & " of group " & quote & "diary" & quote & " into fld " & quote & "notes" & quote into do_me
    do do_me
  end if
end displayrecord

function item_one_max list
  local final_l
  put "" into final_l
  repeat for each line l in list
    put item 1 of l & "," after final_l
  end repeat
  return max(final_l)
end item_one_max

on arrowkey direction
  if the selectedfield is not empty then pass arrowkey
  if the vis of group "contacts" is false then exit arrowkey
  if direction is in "updown" then exit arrowkey
  click at the loc of btn direction
end arrowkey

on closestack
  open stack "MetaCard Demo2"
end closestack

on resizestack
  repeat with i = 1 to the num of controls
    if "geo" is not in the customkeys of control i then next repeat
    if "geowidth" is in the customkeys of control i then
      set the width of control i to round(the geowidth of control i * the width of this stack)
    end if
    if "geoheight" is in the customkeys of control i then
      set the height of control i to round(the geoheight of control i * the height of this stack)
    end if
    if "geopercent" is in the customkeys of control i then
      get the geopercent of control i
      put round(item 1 of it * the width of this stack) into item 1 of it
      put round(item 2 of it * the height of this stack) into item 2 of it
      set the loc of control i to it
    end if
  end repeat
  repeat with i = 1 to the num of cds
    if there is a button "image_button" of cd i then set the rect of btn "image_button" of cd i to the rect of control "image_rect" of cd i
  end repeat
end resizestack

on geosetup
  repeat with i = 1 to the num of controls
    get the loc of control i
    put item 1 of it/the width of this stack into item 1 of it
    put item 2 of it/the height of this stack into item 2 of it
    set the geopercent of control i to it
    get the width of control i
    set the geowidth of control i to it/the width of this stack
    get the height of control i
    set the geoheight of control i to it/the height of this stack
  end repeat
end geosetup

on preopencard
  put "Record " & the num of this cd & " of " & the num of cds & "." into fld "r_number"
  if the menuhistory of btn "tab" is "2" then
    if there is a button "image_button" then
      show btn "image_button"
    end if
  else
    if there is a button "image_button" then
      hide btn "image_button"
    end if
  end if
end preopencard

on mouseEnter
end mouseEnter

on mouseLeave
end mouseLeave
          Black   ffffff      white     white       	darkgray   z         Personal Organizer Example      X     U 
Helvetica   W 
Helvetica   U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica  U 
Helvetica   W 
Helvetica   U 
Helvetica   U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  W 
Helvetica  W 
Helvetica  !W 
Helvetica  W 
Helvetica  	W 
Helvetica   U 
Helvetica  U 
Helvetica   U Times       	P on openCard
  
end openCard
           z                  V          	@          u                  	@          u                    	@          u                  	@          z                  	P on openCard
  
end openCard
                                       	@                         	contacts   a function get_fields
  return fld "name" & cr & fld "email" & cr & fld "address" & cr & fld "phone" & cr & fld "fax" & cr & fld "other"
end get_fields
       3|   	geowidth  1.003125
geoheight  0.895833geopercent  0.498437,0.554167  i   @`    33      ff    33     8q   	geowidth  0.985938
geoheight  0.875geopercent  0.498437,0.554167         	   	   	   	   	   	   	     k    K@       9l   	geowidth  0.978125
geoheight  0.864583geopercent  0.498437,0.552083   
  ;  h         ff      x [    	geowidth  0.14375
geoheight  0.05geopercent  0.09375,0.279167           Name: 
  <  h         ff       [    	geowidth  0.14375
geoheight  0.05geopercent  0.09375,0.341667           Email:   o    K@      ff  ffffff         	geowidth  0.304688
geoheight  0.410417geopercent  0.820313,0.51875   
  =  h         ff       [    	geowidth  0.14375
geoheight  0.05geopercent  0.09375,0.529167           	Address: 
  >  h         ff       [    	geowidth  0.14375
geoheight  0.05geopercent  0.09375,0.404167           Telephone: 
  ?  h         ff       [    	geowidth  0.14375
geoheight  0.05geopercent  0.09375,0.466667           Fax: 
  @  h    	     ff            [    	geowidth  0.14375
geoheight  0.05geopercent  0.09375,0.63125           Notes: 
  A name  )`      o x)    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.279167         Floppet    Sam Globetrotter    Penny & Margaret    	Penelope    
Mr. Plank    The Climbing Executioner    The Beaver     
  B email  )`      o )    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.341667         floppers@netventure.org    snappysam@metacard.com    pen&marg@citrusfun.co.SA    Penelephant@metacard.com    plankcares@metacard.com     weedstrangler@organics.alt.net.    thebeaver@nethiker.com     
  C address  )`      o ) *   	geowidth  0.46875
geoheight  0.089583geopercent  0.407813,0.547917         8101 Fluffysnozzle Drive, The Woods, Edinburgh, Scotland    U"Anywhere in the whole wide world my friend" he says, inside The Brangebox (his van)    #The Jive Hut, Buenes Aires, Brazil    QTheatrics and Multimedia, MetaCard corp, 4710 Shoup pl. Boulder, CO 80303, U.S.A    QTheatrics and Multimedia, MetaCard corp, 4710 Shoup pl. Boulder, CO 80303, U.S.A    UA nomadic species originally from thailand; reputedly last headed for Boulder, U.S.A    The Den, Somewhere In Alaska     
  D phone  )`      o )    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.404167         petrified of telephones    ,"Merely think and I will be there", he says    
not owned    
303-447-3936    
303-477-3936    0alternative chemosecretively oriented reception    not a social creature     
  E fax  )`      o )    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.466667         scared of fax machines    in - car fax:  0191-321-0911    2squashy fruits fervently avoid rotating machinery    
303-499-9855    
303-499-9855    -make no mistake; this plant will contact YOU    +long since gnawed to utter dysfuctionality     
  F other  )`      o ) O   	geowidth  0.46875
geoheight  0.166667geopercent  0.407813,0.689583         extremely timid creature..quite well behaved except in the company of peers..does NOT wash frequently (is phobic of overly abrasive sponges)..father is the chief of police..   _..claims to be considered the 4th emergency service by government authorities..fiercely competitive..recruited by MetaCard Corp. for his undeniable efficiency in postal delivery..when alone on the road he will usually drive in the middle of it..has been observed to run traffic lights on occasion..Sam is a very strange combination of good and evil..    Particularly good exotic dancers..have grand plans to temporarily become commercial produce for the exposure to preservative drugs in order to extend life expectancy..    ..delightful soul acquired by MetaCard corp for her unusual talent in the art of multimedia production..cute but quick tempered (known to bite)..likes email, hates programming and caretakers..    ..the official MetaCard caretaker and handyman..phobic of large colorful mammals..is  a cynic of Penelopes creative advances..bitten frequently by a large pink member of staff..    ..ferocious herbacious carnivore..believes in 16 full hours of photosynthesis daily to promote the development of strong (and sharp) teeth..    aloof and strong willed..likes to knaw through furniture..very intelligent..expert at maintaining statuesque positions for long periods of time..left Spain for the solitude of Alaska for "time to think"           	`      !  M  G Right Cp Hon mouseup
  visual effect push left
  go to the next card
end mouseUp
       [ L   	geowidth  0.14375
geoheight  0.160417geopercent  0.901563,0.8875 Next Record                            	       H Left Cp Kon mouseup
visual effect push right
  go to the previous card
end mouseUp
        [ L   	geowidth  0.14375
geoheight  0.160417geopercent  0.09375,0.8875 Previous Record                            	       I 
Sort records ex    ]on mouseUp
  show group "sort"
  insert script of btn "sort control" into front
end mouseUp
  ww        	  %   	geowidth  0.2375
geoheight  0.077083geopercent  0.535937,0.929167 
Sort records  
Sort Records          	       J Search records ex    5on mouseUp
  modeless "contacts search"
end mouseUp
  ww        	  &   	geowidth  0.2375
geoheight  0.079167geopercent  0.535937,0.847917 Search Records  Search Records          	       K Copy Record Ex     on mouseUp
  put get_fields() into fld "copy me"
  select text of fld "copy me"
  copy
  put empty into fld "copy me"
end mouseUp
       b &   	geowidth  0.154688
geoheight  0.079167geopercent  0.742188,0.847917 Copy text to clipboard          	       l    K@      ff  ffffff    A  0   	geowidth  0.304688
geoheight  0.102083geopercent  0.820313,0.1875     L Export Record Ex     on mouseUp
  ask file "Export record as:" with "Record.txt" with filter "txt"
  if it is empty then exit mouseup
  open file it for write
  write get_fields() to file it
  close file it
end mouseUp
       b %   	geowidth  0.154688
geoheight  0.077083geopercent  0.742188,0.929167 Export record to file          	       M New record ex    #on mouseUp
  new card
end mouseUp
  ww         n  &   	geowidth  0.239063
geoheight  0.079167geopercent  0.29375,0.847917 Create new record  New Record          	       N Delete record ex   5on mouseUp
  if the number of cards in this stack is not 1 then
    answer "Really delete this record?" with "No" or "Yes"
    if it is "yes" then
      lock screen
      delete this card
      preopencard
      unlock screen
    end if
  else
    answer "Can't delete the last record."
  end if
end mouseUp
  ww         n  %   	geowidth  0.239063
geoheight  0.077083geopercent  0.29375,0.929167 Erase this record  Delete Record          	     
  P  h         ff     x     	geowidth  0.301563
geoheight  0.05geopercent  0.820313,0.279167           Photograph / Representation:   ] sort  a     on mouseup
  lock screen
  sort cards by fld (word 1 of the short name of the target)
  remove the script of btn "sort control" from front
  hide group "sort"
go cd 1
  preopencard
  unlock screen
end mouseup
       k t1    	geowidth  0.48125
geoheight  0.535417geopercent  0.407813,0.5125
  W 
name sort  `        Red   o x)    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.279167           #Click Here to Sort Records by Name 
  X email sort  `        Red   o )    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.341667           ,Click Here to Sort Records by Email Address 
  Y 
address sort  `        Red   o ) *   	geowidth  0.46875
geoheight  0.089583geopercent  0.407813,0.547917           &Click Here to Sort Records by Address 
  Z phone sort  `        Red   o )    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.404167           +Click Here to Sort Records by Phone Number 
  [ 	fax sort  `        Red   o )    	geowidth  0.46875
geoheight  0.05geopercent  0.407813,0.466667           )Click Here to Sort Records by Fax Number 
  \ other sort  `        Red   o ) O   	geowidth  0.46875
geoheight  0.166667geopercent  0.407813,0.689583           $Click Here to Sort Records by Notes   ^ 
sort control Ep on mousedown
  if "sort" is not in the short name of the target then
    hide group "sort"
    remove the script of me from front
    beep
  end if
end mousedown
       H 1    	geowidth  0.076563
geoheight  0.047917geopercent  0.851563,0.175         	     
  b copy me  `       
 D    	geowidth  0.107813
geoheight  0.04375geopercent  0.360938,0.041667            
  g 	r_number h  !     ff     C  ,   	geowidth  0.298438
geoheight  0.09375geopercent  0.820313,0.1875 Record number            Record 1 of 7.   j    K   eeeeee     7t   	geowidth  0.990625
geoheight  0.879167geopercent  0.498437,0.554167     m    K@      ff  ffffff    
 A 0   	geowidth  0.635938
geoheight  0.102083geopercent  
0.3375,0.1875     p    K@           	geowidth  0.298438
geoheight  0.402083geopercent  0.820313,0.51875     O image_rect   K@                         	geowidth  0.285938
geoheight  0.385417geopercent  0.820313,0.51875     q    K            	geowidth  0.295312
geoheight  0.397917geopercent  0.820313,0.51875     w Import ex    qon mouseUp
  answer file "Select a graphic to import:"
  if it is empty then exit mouseup --if they don't select a file then exit
  if there is an image "image_image" then delete image "image_image"
  --we call all imported images this to make them easy to find
  if there is a btn "image_button" then delete btn "image_button"
  --we're going to create a new button to hold the new image (the card might not have an image
  --in the first place)
  set cursor to watch
  lock screen
  lock messages
  import paint from file it
  hide last image
  --the most recently imported image will be the last one
  set the name of last image to "image_image"
  --so we can find it again
  set the rect of the templatebutton to the rect of control "image_rect"
  set the geopercent of the templatebutton to the geopercent of control "image_rect"
  set the geoheight of the templatebutton to the geoheight of control "image_rect"
  set the geowidth of the templatebutton to the geowidth of control "image_rect"
  --so that the button will be resized correctly if the stack is resized
  set the name of the templatebutton to "image_button"
  set the showname of the templatebutton to false
  set the icon of the templatebutton to (the id of last image)
  set the autohilite of the templatebutton to false
  set the traversalon of the templatebutton to false
  set the showborder of the templatebutton to false
  set the opaque of the templatebutton to false
  new button
  reset the templatebutton
  unlock screen
  unlock messages
end mouseUp

on scripterror thestr
  answer "There was an error during this opperation:"&cr&thestr with "Cancel"
end scripterror
         Black   \ ^    	geowidth  0.148438
geoheight  0.039583geopercent  0.745313,0.754167 Import new photo  Import          	       x Clear ex    won mouseUp
  if there is not a button "image_button" and there is not an image "image_image" then
    beep
    exit mouseup
  end if
  answer "Really delete this image?" with "No" or "Yes"
  if it is "yes" then
    if there is a button "image_button" then delete btn "image_button"
    if there is an image "image_image" then delete image "image_image"
  end if
end mouseUp
      \ [    	geowidth  0.14375
geoheight  0.039583geopercent  0.901563,0.754167 Erase this photo  Clear          	       z    K@      ff  ffffff    tZ    	geowidth  0.95
geoheight  0.00625geopercent  0.496875,0.7875     {    K@      33  ffffff    x     	geowidth  0.004687
geoheight  0.520833geopercent  0.654687,0.5125     ~    K@      ff  ffffff    o    	geowidth  0.645312
geoheight  0.00625geopercent  0.496875,0.8875         K@      ff  ffffff     K   	geowidth  0.004687
geoheight  0.158333geopercent  0.654687,0.8875         K@      ff  ffffff     K   	geowidth  0.004687
geoheight  0.158333geopercent  0.414063,0.8875         K   ffffff         	geowidth  0.315625
geoheight  0.002083geopercent  
0.5125,0.8875      
diary.gif  @         _   	geowidth  0.217188
geoheight  0.197917geopercent  0.440625,0.566667  	iGIF89a _   f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,     _  H*\ȰÇ#JHŋ3jthoǏ 1ګɓDɲz0;
鲦͆0Iϟa'Ј9u<Pz%JdPիK.9TeԩT*JVֆHt՘V {aڵRK3(ݺz
4-\osV(j#u;6N덌ĉ9b}|Y`f}ޕN%G]oiH@Eߝ6f\w5	'6~ۯnk}.\yVi_wi=3ǫԍiZ9spQ'xm,mGwai4 ${D0vHqDG'jX_1Y{/Te0R%fT#Gb
>W=BVY%\ERtd(Fc
h]FވY&W	@^{^~.B	`xI%fވ`s!VVPBU{ZNן2dO%䝌JP]nIiEt&tU:\NzR:YޚlQڒrZg }$g#HzZQcֺrۮ+
kL2/jVLoUϥ\B.Ì=()/f|LW찮B#DÎ3eJ"3Hs6,%)%p2wH޼rAƂ1:eݥ(G/IT1w5'ݕGQ-'[}ortr2oEط mݘCmZ{/Ku|KxJ9͹UcQ
BJ!A᮹zn;EX2b-ӜS]{wc<x/	V҃4ţQY\><Rj~ѕ&h[5EXr 3Mf~H}9$?OЀ*'7! q6Axp;DJZO:b)Pd#2Ѕ!BC8R8j>!C9=Ntψy"xN`fJ?W޼dJ]2ǹ$$KP7-mt$  \ب[E{XQ!F~H$ګ 餋&l^G5%ؓb(\QR>TJ*SJ/t	E2#VTVreU'am 	ȻkO.&	J*>C)j/)YJfGr%kf08Knb-$\3I{V01	Y1ẙ	UHhs2,lsY$*
jіc,[-?G-%.+ĔIRNYU"OV>I%']e'˵.H9S&	uO\4<fU1Me#T4mԜef̾iO]/zGQ~fiVUЂ{
3T:.0EdA󊞿x+Hc%n2Ee31:4-CEY8d:cP1:k'+mkPu15Z:Ѝt듀  !clip2gif 0.7.2 by Yves Piguet ;         phone pattern.gif  @       i  _   	geowidth  0.217188
geoheight  0.197917geopercent  0.489063,0.322917  GIF89a _   f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,     _  H*\ȰÇ(ŋ3bǏ CIɓDɲeHVI̘*ɓL8s:^=&
@SP?-S`ΪQZtң b:},çdaHHRmK)V.ފj*JM_.P{lx!Ę3=Ԋ+s4flڻXE6M;c	?TiơE}:giQ N/nTƣ?}Μ/V?Aa]tx㱃GLyʴ/{*_E~
x_@_r{Y)iZa܁
աuvxbN
bBb}(:hpԵ"qrUf#?`3a(u|?$i/.ɣr&"b"gO	HWNG#(RDb%1dԄY6e69\kɝX{x>&R ez&'#y~NYt٥WN)TuR:'Ub\
YjrVB
_~R|ږ8YDv]N]V
V)Jk4z-8جij%=fףa~ `FKI}mcIoD]]1ZFLJ؂Kh^:MղG"^n4)t#Oܗ\
ZEvߚM|}s!\KR5V=Er!v6l'ǙE8$B{noGd\ uM՛q[Bbf}1xNuQYE.9Zvoce_NQпCx,jϲ4{Djթr=2	Z-h>/\Sޏ=ofnvռA=\
tcd?[gI
|M% g,E%D|
nU=.# 52)!
ǒA	s@H́M3arBR+" "	K8D	>V~$UzKDHܨ6'6+CY'C)2
BŁe#)v0M#T	Vd-U}WѣMr&V,!<=oiFqyte-Vr£.8HL2f: !clip2gif 0.7.2 by Yves Piguet ;         phone pattern.gif  @         f   	geowidth  0.234375
geoheight  0.214583geopercent  
0.15,0.464583  GIF89a g   dF    dV,q:@@@   ,     g I8ͻ`(dihlp,tmx|@G,NqJN4$ǩ6fЭ8T}ZӵV:/%
+zft IlX|uz|^duoY_~B%fVv'a`hwh}`OkmNUϳntgպGñؠFe~rz
߱?5O ux|ZnR^/jFHŉ	V촒e~ࡓvٻc2N꧛FrN]&d$,6ˮ߆H+t`ff;g5)^1IK?Z/jEϜ5hMGQ.5%lɆ兆yc_XUBHH5F|95?ׅHL{/grnՔ~j-YZsl}wc-J""<VӍתZKFój^%el5VPLZOw	@P!̍ƠDW^zA1LBXZ%Y]b^v43,ۘV<P90Q8E&(b	RpSPtјL)`+[I)KuQ}RA|ة֐Ar65?b297BFhCdjҠJF
d	蟒8%7hDIƥ 7h7j';U j/㨢}(itTڷGVmR["0/bNCn*rɮ< +.5pz/1#^^*|hSm[2C ƍraX[3	sonҪ_\nA *2ә1Q4<W@ ytN`{4
h-S=t  (6y.Ŗ-aWo<2?@҅8
Y:a{<7?9A8^<_vjr.;O|}/G  !clip2gif 0.7.2 by Yves Piguet ;            K@               C ,   	geowidth  0.629687
geoheight  0.09375geopercent  
0.3375,0.1875     n    K@       E (   	geowidth  0.623437
geoheight  0.085417geopercent  
0.3375,0.1875      
menuGroup  I      ~ %   	geowidth  1.00625
geoheight  0.077083geopercent  0.5,0.035417  6 menuButton A`       v    	geowidth  0.99375
geoheight  0.060417geopercent  0.5,0.035417         	       7 File ŋU on menuPick which
  switch which
  case "Exit"
    close this stack
    break
  case "save"
    set cursor to clock
    save this stack
    exit switch
  end switch
end menuPick
         %    	geowidth  0.057813
geoheight  0.047917geopercent  0.034375,0.035417   &Save
-
&Exit      	       8 Edit ŋU on menuPick which
  switch which
  case "Undo"
    undo
    break
  case "Paste"
    paste
    break
  case "cut"
    cut
    break
  case "copy"
    copy
    break
  end switch
end menuPick
       )  '    	geowidth  0.060937
geoheight  0.047917geopercent  0.095312,0.035417   &Undo
-
&Cut
C&opy
&Paste      	       9 Navigation ŋU on menuPick which
  switch which
  case "Diary"
    click at 33,53
    break
  case "Contacts"
    click at 86,53
    break
  case "calculator"
    palette "calculator"
    break
  end switch
end menuPick
       Q  J    	geowidth  0.117188
geoheight  0.047917geopercent  0.185938,0.035417   &Diary
&Contacts
-
C&alculator      	           K       ff     q    	geowidth  0.985938
geoheight  0.047917geopercent  0.5,0.035417         K        o    	geowidth  0.982812
geoheight  0.04375geopercent  0.5,0.035417         K        r    	geowidth  0.9875
geoheight  0.052083geopercent  0.5,0.035417      diary  i       3|   titles866070000  
1,Pen & Marg
	geowidth  1.003125
geoheight  0.895833times865638000  
1,10:00 AMnotes8658972001  I said I'd arbitrate for them in their latest disagreement - this time over MetaCards advertising slogan.  Round at Penelope's place.times865897200  
1,01:00 AMtitles865638000  1,Birthday Beavertitles865897200  1,Penelope v Planknotes8660700001  'Should invite them round for the Summernotes8655516001  ZIt's my turn to buy for Sam this year.  Just off Rose Street at the Weary Travellers Inn..times865465200   times865724400   notes8658108001  }Must try and persuade the old plant to keep taking those vitamin supplements the doctor prescribed him to promote root growthtitles865465200   titles865724400   times865551600  
1,08:30 PMtimes865810800  
1,03:10 PMtimes865378800  
2,11:00 AMnotes8653788002  Emust remember to take Floppet to the dentist for that root canal worktitles865551600  1,A pint with the Globetrottertitles865810800  1,Execution pillstitles865378800  2,Dentist for Floppetgeopercent  0.498437,0.554167times866070000  
1,01:00 PMnotes8656380001  Nget a card for old Beavsy and a large book of postage stamps to get it there

      K   eeeeee     7t   	geowidth  0.990625
geoheight  0.879167geopercent  0.498437,0.554167   
    H          D     	geowidth  0.259375
geoheight  0.05geopercent  0.153125,0.16875           	Calendar      @`    33      ff    33     8q   	geowidth  0.985938
geoheight  0.875geopercent  0.498437,0.554167         	   	   	   	   	   	   	         K@       9l   	geowidth  0.978125
geoheight  0.864583geopercent  0.498437,0.552083      prev_ap Cp on mouseUp
  lock screen
  global current_record
  if current_record > 1 then
    subtract 1 from current_record
    send "displayrecord" to this cd
  else
    beep
  end if
  unlock screen
end mouseUp
        [ L   	geowidth  0.14375
geoheight  0.160417geopercent  0.901563,0.466667 Previous appointment                            	        next_ap Cpon mouseUp
  global current_record
  lock screen
  get word 4 of fld "record_title"
  delete last char of it
  if current_record < it then
    add 1 to current_record
    send "displayrecord" to this cd
  else
    beep
  end if
  unlock screen
end mouseUp
       [ L   	geowidth  0.14375
geoheight  0.160417geopercent  0.901563,0.8875 Next appointment                            	     
   timer pzlocal old_fld


on exitfield
  global last_char
  put the word 2 of the selectedchunk into last_char
end exitfield

on arrowkey
  selectionChanged
  pass arrowkey
end arrowkey

on closefield
  global last_char
  put the word 2 of the selectedchunk into last_char
  send "createrecord" to this cd
end closefield

on selectionChanged
  global last_char
  put word 2 of the selectedChunk into last_char
end selectionChanged

on rawkeydown
  global field_changed
  put true into field_changed
  put me into old_fld
  pass rawkeydown
end rawkeydown

on keyup
  if me is not a date then
    beep
    put old_fld into me
  end if
end keyup
         O    	geowidth  0.125
geoheight  0.05geopercent  0.339062,0.345833 Appointment time            	11:00 AM       K@       >   	geowidth  0.501563
geoheight  0.58125geopercent  0.528125,0.677083      	time_bar  Iplocal mouseUp_do

on mouseDown
  global field_changed
  if field_changed is true then send "closefield" to the selectedField
  put false into field_changed
  pass mouseDown
end mouseDown

on scrollbarDrag direction
  global field_changed
  put true into field_changed
  local tempvar
  --direction will be either 1 or 2 because of settings in palette
  global last_char
  repeat while the mouse is down
    switch last_char
    case 1
    case 2
    case 3
      put char 1 to 2 of fld "timer" into tempvar
      if direction is 1 then add 1 to tempvar else subtract 1 from tempvar
      if the num of chars in tempvar is 1 then put 0 before tempvar
      if tempvar is 13 then put "01" into tempvar
      else if tempvar is 0 then put 12 into tempvar
      --   if tempvar > 0 and tempvar < 13 then
      put tempvar into char 1 to 2 of fld "timer"
      put "select char 1 to 2 of fld timer" into mouseUp_do
      exit switch
    case 4
    case 5
    case 6
      put char 4 to 5 of fld "timer" into tempvar
      if direction is 1 then add 1 to tempvar else subtract 1 from tempvar
      if the num of chars in tempvar is 1 then put 0 before tempvar
      --  if tempvar > 0 and tempvar < 60 then put tempvar into char 4 to 5 of fld "timer"
      if tempvar is 60 then put "00" into tempvar
      else if tempvar is "-1" then put 59 into tempvar
      put tempvar into char 4 to 5 of fld "timer"
      put "select char 4 to 5 of fld timer" into mouseUp_do
      exit switch
    case 7
    case 8
    case 9
    case default
      if direction is 1 then put "A" into char 7 of fld "timer" else put "P" into char 7 of fld "timer"
      put "select char 7 to 8 of fld timer" into mouseup_do
      exit switch
    end switch
  end repeat
  send "createrecord" to this cd
  do mouseUp_do
end scrollbarDrag
            	geowidth  0.025
geoheight  0.05geopercent  0.420312,0.345833 Change time    1  2       
   title  pon closefield
  --make sure there is only 1 line (someone might paste in more text)
  if the num of lines in me > 1 then put line 1 of me into me
  send "createrecord" to this cd
end closefield

on returninfield --don't allow creating a new line
  beep
end returninfield

on enterinfield
  beep
end enterinfield

on rawkeydown
  global field_changed
  put true into field_changed
  pass rawkeyDown
end rawkeydown
            	geowidth  0.3625
geoheight  0.05geopercent  0.632813,0.345833 Appointment title            Dentist for Floppet 
   notes  0 on closefield
  send "createrecord" to this cd
end closefield

on rawkeydown
  global field_changed
  put true into field_changed
  pass rawkeydown
end rawkeydown
            U   	geowidth  0.5375
geoheight  0.58125geopercent  0.545312,0.677083 Appointment notes            Fmust remember to take Floppet to the dentist for that root canal work       	            New Appointment Ep8local it

on mouseUp
  global current_record, current_day, var_name, do_me
  if current_day is not in the customkeys of group "diary" then exit mouseup
  put "times" & current_day into var_name
  put "get the number of lines in the " & var_name & " of group " & quote & "diary" & quote into do_me
  do do_me
  put it+1 into current_record
  lock screen
  put "Appointment " & current_record & " of " & current_record & "." into fld "record_title"
  put "01:00 PM" into fld "timer"
  put empty into fld "notes"
  put empty into fld "title"
  unlock screen
end mouseUp
         &   	geowidth  0.240625
geoheight  0.079167geopercent  0.14375,0.847917 Create appointment          	         Delete Appointment Epelocal it

on mouseUp
  global current_record, current_day, var_name, do_me, record_id, search_var, startline, endline
  lock screen
  if current_day is not in the customkeys of group "diary" then exit mouseup
  put "times"&current_day into var_name
  put "get the " & var_name & " of group " & quote & "diary" & quote into do_me
  do do_me
  put item 1 of line current_record of it into record_id
  delete line current_record of it
  put "set the " & var_name & " of group " & quote & "diary" & quote & " to it" into do_me
  do do_me
  
  put "titles"&current_day into var_name
  put "get the " & var_name & " of group " & quote & "diary" & quote into do_me
  do do_me
  delete line lineoffset(record_id,it) of it
  put "set the " & var_name & " of group " & quote & "diary" & quote & " to it" into do_me
  do do_me
  
  put "notes"&current_day&record_id into search_var
  get the customkeys of group "diary"
  delete line lineoffset(search_var,it) of it
  set the customkeys of group "diary" to it
  
  if current_record > 1 then subtract 1 from current_record
  send "displayrecord" to this cd
  unlock screen
end mouseUp
         %   	geowidth  0.240625
geoheight  0.077083geopercent  0.14375,0.927083 Delete this appointment          	     
   
record_title h           xT    	geowidth  0.535937
geoheight  0.05geopercent  0.54375,0.279167 Appointment number            Appointment 1 of 1. 
   month `            	geowidth  0.210938
geoheight  0.05geopercent  0.15625,0.627083           June 
   year `       :     	geowidth  0.210938
geoheight  0.05geopercent  0.15625,0.6875           1997    
month_bar  Ipon scrollbarDrag direction
  --direction will be either 1 or 2 because of settings in palette
  lock screen
  get itemoffset(fld "month","January,February,March,April,May,June,July,August,September,October,November,December")
  if direction is 2 then add 1 to it else subtract 1 from it
  if it is 0 then put 12 into it
  if it is 13 then put 1 into it
  put item it of "January,February,March,April,May,June,July,August,September,October,November,December" into fld "month"
  set the month of group "calendar" to (fld "year" & "," & it & ",01,0,0,0,0")
  unlock screen
end scrollbarDrag

on mouseDown
  global field_changed
  if field_changed is true then send "closefield" to the selectedField
  put false into field_changed
  pass mouseDown
end mouseDown
            	geowidth  0.021875
geoheight  0.05geopercent  0.032813,0.627083 
Change month    1  2            Ipon scrollbarDrag direction
  local month_num
  --direction will be either 1 or 2 because of settings in palette
  lock screen
  get fld "year"
  if direction is 2 then add 1 to it else subtract 1 from it
  if it > 2040 then put 2040 into it
  if it < 1992 then put 1992 into it
  put it into fld "year"
  put itemoffset(fld "month","January,February,March,April,May,June,July,August,September,October,November,December") into month_num
  set the month of group "calendar" to (fld "year" & "," & month_num & ",01,0,0,0,0")
  unlock screen
end scrollbarDrag

on mouseDown
  global field_changed
  if field_changed is true then send "closefield" to the selectedField
  put false into field_changed
  pass mouseDown
end mouseDown
       :     	geowidth  0.021875
geoheight  0.05geopercent  0.032813,0.6875 Change Year      1  2          New Button  @`      
      	geowidth  0.24375
geoheight  0.270833geopercent  0.142187,0.45625         	   	   	   	   	   	   	   	      	calendar   i
setprop month which
  local the_month, repeat_for, i
  put which into the_month
  convert the_month to short date
  convert the_month to dateitems
  put "01" into item 3 of the_month
  convert the_month to seconds
  set the month of group "calendar" to the_month
  convert the_month to long date
  get itemoffset(word 1 of the_month,"Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,")
  otherdays the_month,it
  put month_length(the_month) into repeat_for
  repeat with i = 1 to repeat_for
    set the label of btn it of group "calendar" to i
    if the disabled of btn it of group "calendar" is true then enable btn it of group "calendar"
    add 1 to it
  end repeat
  hiliteday 1
  displayrecord
end month

function month_length which
  local which_month
  put which into which_month
  convert which_month to short date
  convert which_month to dateitems
  put "31" into item 3 of which_month
  if which_month is a date then return "31"
  put "30" into item 3 of which_month
  if which_month is a date then return "30"
  put "29" into item 3 of which_month
  if which_month is a date then return "29"
  put "28" into item 3 of which_month
  if which_month is a date then return "28"
end month_length

on otherdays current_month, daystart
  local the_month, daycounter, month_ends, remaining_days, counter
  put current_month into the_month
  convert the_month to dateitems
  if item 2 of the_month > 1 then
    subtract 1 from item 2 of the_month
  else
    put 12 into item 2 of the_month
    subtract 1 from item 1 of the_month
  end if
  get month_length(the_month)
  put daystart into daycounter
  if daycounter is not 0 then
    repeat (daystart-1)
      subtract 1 from daycounter
      if exists(btn daycounter of group "calendar") is false then answer daycounter
      set the label of btn daycounter of group "calendar" to it
      disable btn daycounter of group "calendar"
      subtract 1 from it
    end repeat
  end if
  get month_length(current_month)
  put it into month_ends
  put ((42-month_ends)-daystart)+1 into remaining_days
  if remaining_days < 1 then exit otherdays
  --otherwise we need to do 1 or more remaining_days
  add daystart to month_ends
  subtract 1 from month_ends
  
  put 1 into counter
  repeat remaining_days
    add 1 to month_ends
    set the label of btn month_ends of group "calendar" to counter
    disable btn month_ends of group "calendar"
    add 1 to counter
  end repeat
  
end otherdays

on mouseup the_button
  global field_changed
  lock screen
  if field_changed is true then send "closefield" to the selectedField
  hiliteday the label of the target,the short name of the target
  if the_button is not 1 then
    popup "calendar popup"
  else
    displayrecord
  end if
end mouseup
          z   	geowidth  0.232813
geoheight  0.25625geopercent  0.140625,0.454167month  	865119600 SClick to select a day.  Hold the mouse down for a list of all records in that day.   	 1 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.046875,0.35625 1          	       
 2 eh           black     white ss      33    (      	geowidth  0.032813
geoheight  0.041667geopercent  0.078125,0.35625 2          	        3 
h           black     white ss      33    ;      	geowidth  0.032813
geoheight  0.041667geopercent  0.109375,0.35625 3    eh
oe       	        4 eh           black     white ss      33    O      	geowidth  0.032813
geoheight  0.041667geopercent  0.140625,0.35625 4          	      
 5 eh           black     white ss      33    c      	geowidth  0.032813
geoheight  0.041667geopercent  0.171875,0.35625 5          	        6 eh           black     white ss      33    w      	geowidth  0.032813
geoheight  0.041667geopercent  0.203125,0.35625 6          	        7 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.234375,0.35625 7          	        8 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.046875,0.395833 8          	        9 eh           black     white ss      33    (      	geowidth  0.032813
geoheight  0.041667geopercent  0.078125,0.395833 9          	        10 eh           black     white ss      33    ;      	geowidth  0.032813
geoheight  0.041667geopercent  0.109375,0.395833 10          	        11 eh           black     white ss      33    O      	geowidth  0.032813
geoheight  0.041667geopercent  0.140625,0.395833 11          	        12 eh           black     white ss      33    c      	geowidth  0.032813
geoheight  0.041667geopercent  0.171875,0.395833 12          	        13 eh           black     white ss      33    w      	geowidth  0.032813
geoheight  0.041667geopercent  0.203125,0.395833 13          	        14 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.234375,0.395833 14          	        15 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.046875,0.435417 15          	        16 eh           black     white ss      33    (      	geowidth  0.032813
geoheight  0.041667geopercent  0.078125,0.435417 16          	        17 eh           black     white ss      33    ;      	geowidth  0.032813
geoheight  0.041667geopercent  0.109375,0.435417 17          	        18 eh           black     white ss      33    O      	geowidth  0.032813
geoheight  0.041667geopercent  0.140625,0.435417 18          	        19 eh           black     white ss      33    c      	geowidth  0.032813
geoheight  0.041667geopercent  0.171875,0.435417 19          	        20 eh           black     white ss      33    w      	geowidth  0.032813
geoheight  0.041667geopercent  0.203125,0.435417 20          	        21 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.234375,0.435417 21          	        22 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.046875,0.475 22          	        23 eh           black     white ss      33    (      	geowidth  0.032813
geoheight  0.041667geopercent  0.078125,0.475 23          	         24 eh           black     white ss      33    ;      	geowidth  0.032813
geoheight  0.041667geopercent  0.109375,0.475 24          	       ! 25 eh           black     white ss      33    O      	geowidth  0.032813
geoheight  0.041667geopercent  0.140625,0.475 25          	       " 26 eh           black     white ss      33    c      	geowidth  0.032813
geoheight  0.041667geopercent  0.171875,0.475 26          	       # 27 eh           black     white ss      33    w      	geowidth  0.032813
geoheight  0.041667geopercent  0.203125,0.475 27          	       $ 28 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.234375,0.475 28          	       % 29 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.046875,0.514583 29          	       & 30 eh           black     white ss      33    (      	geowidth  0.032813
geoheight  0.041667geopercent  0.078125,0.514583 30          	       ' 31 eh           black     white ss      33    ;      	geowidth  0.032813
geoheight  0.041667geopercent  0.109375,0.514583 1          	       ( 32 eh           black     white ss      33    O      	geowidth  0.032813
geoheight  0.041667geopercent  0.140625,0.514583 2          	       ) 33 eh           black     white ss      33    c      	geowidth  0.032813
geoheight  0.041667geopercent  0.171875,0.514583 3          	       * 34 eh           black     white ss      33    w      	geowidth  0.032813
geoheight  0.041667geopercent  0.203125,0.514583 4          	       + 35 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.234375,0.514583 5          	       , 36 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.046875,0.554167 6          	       - 37 eh           black     white ss      33    (      	geowidth  0.032813
geoheight  0.041667geopercent  0.078125,0.554167 7          	       . 38 eh           black     white ss      33    ;      	geowidth  0.032813
geoheight  0.041667geopercent  0.109375,0.554167 8          	       / 39 eh           black     white ss      33    O      	geowidth  0.032813
geoheight  0.041667geopercent  0.140625,0.554167 9          	       0 40 eh           black     white ss      33    c      	geowidth  0.032813
geoheight  0.041667geopercent  0.171875,0.554167 10          	       1 41 eh           black     white ss      33    w      	geowidth  0.032813
geoheight  0.041667geopercent  0.203125,0.554167 11          	       2 42 eh           black     white ss      33          	geowidth  0.032813
geoheight  0.041667geopercent  0.234375,0.554167 12          	     
  3  h 
       
 x     	geowidth  0.24375
geoheight  0.05geopercent  0.142187,0.279167           $S    M    T     W     T     F     S   4 Today Epon mouseUp
local var
  lock screen
  if the selectedfield is not empty then
    if the short name of the selectedfield contains "notes" then select char 0 fld "title" else select char 0 of fld "notes"
  end if
  put word 2 of the long date into fld "month"
  put word 4 of the long date into fld "year"
  set the month of group "calendar" to the long date
  get the long date
  put word 3 of it into var
  if last char of var is "," then delete last char of var
  hiliteday var
  displayrecord
  unlock screen
end mouseUp
       W I    	geowidth  0.115625
geoheight  0.039583geopercent  0.079687,0.741667 Go to Today          	       5 Tomorow EpMon mouseUp
local var
  lock screen
  if the selectedfield is not empty then
    if the short name of the selectedfield contains "notes" then select char 0 fld "title" else select char 0 of fld "notes"
  end if
  get the long date
  convert it to seconds
  add (60*60*24) to it
  convert it to long date
  put word 2 of it into fld "month"
  put word 4 of it into fld "year"
  set the month of group "calendar" to it
  convert it to long date
  put word 3 of it into var
  if last char of var is "," then delete last char of var
  hiliteday var
  displayrecord
  unlock screen
end mouseUp
       _W I    	geowidth  0.115625
geoheight  0.039583geopercent  0.20625,0.741667 Go to Tommorow          	           K@      ff     q A  0   	geowidth  0.390625
geoheight  0.102083geopercent  0.778125,0.1875         K@      ff       A^ 0   	geowidth  0.551562
geoheight  0.102083geopercent  0.295312,0.1875         K@               CY ,   	geowidth  0.54375
geoheight  0.09375geopercent  0.295312,0.1875   
   date h        s C  ,   	geowidth  0.384375
geoheight  0.09375geopercent  0.778125,0.1875 ,Date of appointments currently being viewed            Sun, May 4, 1997       K@       EU (   	geowidth  0.5375
geoheight  0.085417geopercent  0.295312,0.1875         K@      ff           	geowidth  0.240625
geoheight  0.00625geopercent  0.14375,0.8875         K          t   	geowidth  0.223438
geoheight  0.24375geopercent  0.140625,0.454167         i          	geowidth  1.010938
geoheight  0.947917geopercent  0.496875,0.53125   tab } 
 on menupick this_choice, old_choice
  global dissection_mode
  lock screen
  hide group old_choice
  
  --dissection stuff - ignore this
  if old_choice is "diary" then
    if there is a btn "image_button" then
      show btn "image_button"
    end if
    if dissection_mode is true then
      hide group "diary_dissection_group"
      show group "contacts_dissection_group"
    end if
  else
    if there is a btn "image_button" then
      hide btn "image_button"
    end if
    if dissection_mode is true then
      hide group "contacts_dissection_group"
      show group "diary_dissection_group"
    end if
  end if


  show group this_choice
  unlock screen
end menupick
       33     y   	geowidth  0.998437
geoheight  0.93125geopercent  0.496875,0.53125   Diary
Contacts        	        image_image  @           	geowidth  0.276562
geoheight  0.375geopercent  0.571875,0.591667  <GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,       t	$ "DG0@}	rWd\d2>: I1<rbɒ@ äɚY8dϏ1Zbȡ eXa%#F?Ać1Yz [zJ֫t
Ł
B0 }w'#_ƌLC	ЕhiElz *Ţ3u	:b3^dƤkW޶j=hIƊTy܆'Nt[EÃCLUg~Gxɒ8r>+VxoХ!iv)لmՁU}`b%rc 
	B[~!gFEty1G%&Ce&9(hM)]aJ]~CYEKQQ
I3YUUUUl[Z
Hg!pr
"4WA]x]YgvKmQ{[p%SU
x28PӋ)TH^uKWVF]WRlX5WjYEjV0ERysq)xdK̀O@4٧T#L-TRZg'BK$`y]PڵБ(j\m*m,4Xyj5]qi(HC^@$D37v/7 K.6U(hb쩛g_ډdN4$SRS*@o]5\o[PE5	s^ED'u],	)4#]MVhU'U0ٙK
R]GB3SOP
.G
vwޕ:)hr??/&)m؞ϖRz2@+7hʬ&-2*6e>Zг[_6
GsP-`V+E
E6DUZExS=ޠX̔dbts|<8FFe<T_X-4Hu}+>+)Rt?:R 4!?sHe	H{IGFsEh1%yBX}(HM#O2'lP ѐ6
hE+a
~ LQ*ґĤJ0>1&H>@49"ԡP G&V|Ip#z9@Hs"ì#=iLɇ $7Z~"HG+N

:XpQ;9[85}FvD3IMt1/yPH҆؊JřKjth=-H@zBMfNTDG?IP"Raxdb%P'[Tt	F6YN#)7
Jq)}qȜDi
{]4kNlfMxi:ґV"3PPY#Bb'@L$
,u>lhb&	b%.	$XCi&hLc}7ᔚg+	u3MGgHU'\a@"A[\VvgQ8E&\@"$:Vz9,ÈK#fI:Wm]RQ,2}%B^|URIҟޒ,=sT2L=4ԕdH4uyӐk#"	P7J߶7qW	3q`Z XKdG4tT2fDEeC[:FSE&V$	Vдn=ZD0C̶5Hcc^
̽[ ոyk??ikX2$ɗ$w5<ԻMN&o6oeӦǚ#"<_uzr+W1~Q?jCȇ"rtH 1
lbPRF 6uwn{{(_mDhM}^!3Ԭ	~76GaN'vC8?LVyXP:4EnkudU{uS,oɽ61MLYjL1`kF3mR<9/#?ң|#*\6Il|Gd-ldLLK5z#XAxxU'?z(*T_sg5
(Ȑ$l(aS/IC5;[S\XSặY߯;5%ǯ7ιN&,cvr}ZzBBG+I'h?Gh`#w[4^Zڵk^[Yz+AZRu6bKv',P6C$tDr jm1Tu@m|ԥؙ^^rևIFbv~1/4ݼm?~N~dKL֞=<析YSܣ?(#-,iV6KZfEn^1vS~nE}o+@ ',K1Ys{ <e
tFA9OM9 "] |#Z!ob^$7&1r=6Vwwg+&I] {Yr bC,@7*!5m\6Zq8$A\%qсWrfgfvHvoXMFo3vspX^@'':aT)9)N$VxEM\K)q5x)JuI2_CfjML( XVc2g9cd&TrsUwg?4aHa{LCQ"f+dx?|zXb6/nՁ8^fz_>3dHy#{W!,H2G'7]HT8)EI$oPnu4o|eejDncgfyrdm)wt5VBӨdSk_Q#B(hg"uhXn%-&MuHcلn,^t~8~uje)>!.e2?5L"$x:&Z/AQb,VB8'o\)mvVgSrg6}c=Dg:dgC&Hњs`)D7+3^0")^L5^vƖ9v^h5zׁng{ @ZbC7l͆9]lt)DRj_3X'm(^Wh2v}fbre)nabaytuu#i/$$RFqU?KC@}'95șkffHd
 ^iXH$.H9RZJ2H厃+Y| xke}cm3v2y6&QnWn$`:?ti]?:PE9ץtcf3F5k:'j&hYihd6nfU&	7DskZx<?d)8#/bn6xyx14AX'""ZYhZdHȄnڷ;^aVb?A^wg]$Gֆ|A:zlMuQZf~6QP )gTyX(<5!RL{H:S-XLƫ\ӓKS;_5,HvUy2R'$b@C5Dvi{!<;0V&uI!k!SalOFCqpaoL%_dѪrA`
Hfv\9b5@sC;?t9eU/gS13NΓTnwmfMٙ۶S6n
RE$g}UG^³'
lU*G2! 2L1U )(sf˩k&q
s$=avcGgQԁnBzTR9	xFՑS}(7mV ?6 "=6!oGj54L@y cqdF%R39"
<5ak6e.vGfgx)_I<녁=J_IB0:'ndI;QkO0U(ĮY]kBCcCUy5ک얶y]I
C1jyH($U]! PR,ǧxܵ5"p
Z+Ue%z=T_D,vIKAl} iǮ/$SolJ9|1*J+eeu'8놣ԛogu9jnY1%*(T|؆߂2#z*P1zwP%1V 8Ũ;FW.=q\B}.'5r(ׅt{TGu iakUQKF5w6
hizcnƙkc(.θ+L19#u@qUcDa'(]
s<:لbݜaVhM( f:H+sJi9ܹ' ͒B*m#92ٸZ^kS&X%fQbי)lo6
=i+-ΆeZFR41oX?*\}Z!6fG3oDm&cRǲ',q>C#ۂwU<a Ee/oE@q1@I<\fÚQR΢m)#*$4Z)djT7tN}4Xȃrka016rj'ni͙"T/15k*RN)L`Su^K^ޏ겆 @ʹGtq^9՛2م*39VK -Gi4RK{?5/aq1=]ZSITIP$WL+Q֠x	̒S(Ug+,-Zì]
;6yTWM+qĨ:]NqaPr@IdMnUnܢYx4
ST!73~z\C2"GA3ĊpApr[D|Dy.;`즃8	f3ho&B8]ƁU4|2%~9iJ:\Ł4aqq4nDKTwI &>MBdn- [@{wYQ(bO{61(_:Q]>-,"3\g}TiyUK4넺NIJDO>&gbG]S(V4'	P:"U\"=|B_pNDP?*YCg_ZyЋhA?7="#558!OjQZv,#;bNttW{N.@i!?,iFZ,0ߓ>^Quw}
KಆFfǃR潢#'}D0HK0c_Uޛh +< Z`!aD VB#,C@E%/J7#+3\ΰRL!`q)	B ]t1Df}/TjK<D3X$x Ō2Ж8@/ΒV `	Μx2H2hAp	j)Q3Ö284Y4^?"/?_ԨV&
E%-_g%.Kw`B(P {MWAM7Kؗe,ZDeKGϴfЇ(DXaB)Aq[pnb@\N*N:0EK .<\=,38@K ʈ DS	4ϮJ(QPAZ(d2TͷZQ×Zꥵt ć*FzFSh0AKdˎ+ /0ԯriK1B}6\;6AXMA_0Ų<|.W]>9+*DC;1##m2F*='ӄlJF?sȳւ.Y56rM)ذ3H50b6PUa[:Htس *o&+$Jyo$`Xf6ST;01kkg3D5~4e^.hURnkf!,ir~4	>(
"Z8w-+ܒr\j\fj;AVY
X)7[*Δ^;Я,KĳjzH1s!vT,MSB;@?O~gS
p4ph3}K"vCb
 (?Z,
HBuBzOm:T_A6AYSp>Sfst.gHO"jcE/tjX25@è "{0Ih{!Bٹp0ϖP Bj_9CJ27hÚӈ`!M9Fd*jϋXJ$ja11Hг$!av.L)&9~walH
0JBKpq`Ez[X
ZG+EtqIbN|$GF($
r5M=4oAQtx<
Cu⯪!>y)w PZl8ZjrQ5HA 8=!b=C`D|نM 
-hoJ9
B0/3A3HR9niX $djew o.욉4C\9Laj42Ls
B(l%DY$6IZjy2SNkr%PyѡAozGulp0DjEȐ29E6̤@P6ʯ*Q @+XXdKj!`
#jp<=|fA= B 輗F":/Ԯ=1R;
)Jy1%(ybAY	.Lt}Peg
EzۼD-HևNG\TG:{4
x=<_~]6/Dԑ#'mGXVbAL"rд=X8-#&@X'rPLi^SE!j5U\{Iˎ^]8t?de	OXSD+;η흡J(SXS A!v*
/F A)D<8ΥJ'5X+S2q/Hv
<cKi6AB,PPP)lȦ`/i"3G#CH*Ԙ6wŤ%YhUY4$Y4+1Ay%6UNDS<ctKX`ݼq	ڳr
pX{@"'KԘUďDA-̈́q5jP䩹&X^EsV
[#]MD?dǿ(xS*mRFM<CG(=RӜ"V̤"Q*Xoz5	bSo_x\Z="?E:y|49Qh^[/sj;J)rH!2rA4ˉ߶
TqA
N
HF/֌"Qu6'XڬI:)R zvEt%PPdl	1x
f@JWaxD:ӉeA@c:;G	C9`ɏ
?8!}(a"FZ'r&+<<> LKzqĬE9-!2y*b0	<D6)|Hśwpp*8A9:0l/.9	\;r8zCBOq%L¢%Z "ơ0`,11Cv'҈vّ.#!v+XE֓(<<ۺ(0,q(P9<YA<A(41̜[%	
ksiC6290!õ@P;/)}J78A,EF>/\ƒø.CN+F1k2˃E|	&[A 3B+!>b`a4ɑ?Pm
(iI0G <>k<3#|	u(l,*krDdɧGIK:=x18'`A;8=kEU|8Mc;k$Pz';Jq0 eGIgJ8Й
٩q3#tŽkҴ#ARBq\ɛdj\fDn@)P20r>GX|5d"
8<lȤ&(r ZIђ F-\!DHAJl/SAI3dHR, !
3;= .[ܾ9qDޜЪ¦<A~B[HC"'qCĲΈr=cżtJE$A8A>$C-y+B)LĹMIbۻ\JE0; %/Rt*"*yMkJ!DTASEC>	Dk+l_c"tNd˻(w3 ;pi,!&<{LS=}4RLƃ<%1%H䏇sPC${qt8Ũͬi@NlC=ɇK#\QZ? CW33ѝdJ B.M\Ñx̧}<8f'2؉{z8AD8]HfM7
IْXtJɔ,G"XSS5Tdĉu#ւ(ssw; eTCDbАA @H*暁(pL qrY7V	=
C@[3#9,STEX}ա
VҌu	XDVg9L(Gɳ}+8&s2sĸi퐕=IW=k0
%
]%Y梋;yM\L	RD3ASKVD@#R[/܌N)J$
TeTZژCeu<=UVP(ת_
3
BĕDdο	DE05P"#e(	>hSͼ?0eP	ȈHHBx]|I$]S].5)U&edQuC7q -ڈax*+LVO{,*iqiH>L$e$USt-\aVFڭ%Q9ue=e	x8liF'
sT0Zcc*2 Qu=X1$Hn}0y`S\NУ{8
WT|i$]d$9}ڨeXkC;#܌,e$(uX.	fjGњcѭ13%怙aCW퍺f
$aR
>@ߐc`/hEhX$ێ- ,g$~VLe&*
ON=!1SÊy
J0ёlS;
&91 >D2;u.
iN`ai/0,vZ	< Yp~2أ@L-滍8S[3כ|vR9˖9`C2`|1f=_
"LN@3k:iQ;
<J/M<<rS,%kt4Ya](5ΊCko<C]EDшJm^ )\A)O}JŏDơѼWnN01-"`	1>ʡv: p60KA. l
yԥZTUn	!ĪaRa^Mf31^jAW`82jYsRKQ<.X}'+r}ߚt	\Z%\!zq3A[5ByD{,,pJ*.CI `Nе%aEruVc$w}iʾd!fs,'j	0%6ROkF I`QCR}Y銽i2W$S%FX<s`_c94ـZGdL1Nt:q=C}(y17UsEVQlQ튣lI
F_L0VͨI92!{ɲk1Pڒ@/xiZXOr .B1=`R¡
$\y9=P6_eJ{i}GDɞfN yoHzF59V\,uϞ&"b\]!M0q92Dh
IRt U5]eSC,O#%k9bH9"_}q% .ْ?j50ƺmEurV LN稨>Lt8<cʱ\Ȏ>ٜ=	V pHHV`
uawO\潔,PwtgUVe-?lNݺc_AQ4ZCf"yhPէw01`w3$@H\7x*VE4-$~$HP B8P$:8Q{-fܓEP~\?A\q%ǌch̚2elf2
ͩ3}	),Z`̘9b4hZnZ[ <`ĉ>q%VFS_JAW8={	tj5ze>~XjU?V_I`[8tmˎ3킰&8 R9[*e$ay1Ұ.g,yfg7r3|D~sB@<4N
YXWǞlaV
U\]rQD,px@tҹQ?a"WcATXQfZJ	B`
8BjZp7VCFy45jparq8 ʀVDb:Cω!ȋ/~Sk<XQvu.(8%?N+Oc HN}V~Â|l	g[=D^&נ,Hv+I
wu֯WSnGJNhY?t5PNIUU jWqy[].]rȗy)_I(6Z_"t)^KW_V?Iu0(E6HzJƠ3ORD.mUVU܇tMdtDwE |'J-ӕV$N{Ï)5l+m;IBMSeկCE,1֛Lض&.6bdE$:p"+a4xxAVg]!H1{4dN4^M ē-C%CM2['ː x^Ŕ}(h/0zXFBvIߜ?Vؐ bQm)wEYA{[j!6b8f7VīFRhJQ	~&7aJlep$ڈwPiQ`iB1HB*T2nq4"~Pnx&UX':F<Ӆ}Hn2hV	bDDnWBg Ld0 eJo(YЀG3+y(
bbLb&!I*צoBXAv8p%
"R@q	ve
gr%.ej
A  *%&W#x+&DOBPxt,K(FwȢ I2J84bm3Uv1*xDu,hX^Sm"#E9b5RK?Q%^fld)"ѹU:uJP8Õ?V ꧨIrI	IfB1o:+AAdJ&	úɜq_ܲacX><Ci<F=ʝjz"D΢"(YImk	K^@E
T8C @)6UE:e	S\AQR%,ߺKNkkiŏD*DPRZ5fjȢtƣ_\#4Ѳ\`6~FM~Qu#M)ޟ틮N}+D-^}I.3d\}t.:pd"zIlLA>
 
W\Yhý&GD^u7Y{kfoy[[RgϺv^33=PAlͫq~$D&$7#I}~y׻#xuZk1űJя8Kz<	$Q'rs9>z3	 VR!`D>rX	F{ncg|,njE@5SaijReВH(6!td.^
?(]\X]6e6~ٙ+'<8̙mU;^E>s5a*]@=yfH!hҿR+APͱ;Am@XpB{e=D4Wn:ވTwΨ-C14!
ጅ8ϙ_l/~sߌʝR%'x;Zޢ䊺C452K2nQ)eb*#MXPh>_nIqq捡YK^"q\SyW_:bUFV>[(6dd
f4)ƅ6c{+ȲVhb-}̳BT7H:c&ШXݙA"bN~l X3cWtG)!?W­c`*u
$7ֈMՙjtڷe?01OpAl(1EhJBcH^yS-߱@U9S݊ FT]1 `	gM(1α^S
_9HI[YʄV:%7XRF{D8|C? 
GtLK̅G"	J!S=IYq_1S`=a`RV!-!.[`KQ2A`Y؃]D|,"W7yL9%byuж_:FFSL5Rm\m!Uo% yٞJ
 TEY6~9|HyG!V.q"5݄?PJ7)7r$U Ed%QheDH:96*#Sr$O%) BiFJ:}e6M]EyoEUDrY9 $$$c5r(G |bQ!DFUɠt:+JRbvF-?Х5\+#qI8:hFASRqUE$xTQK d9gNI__T._k6*&܎TUe"`df!bga 2D2NCM"DU\ gk] _&6ڃrN*rdib!r6 KV$ieiLVQ("cex^]Ys ^2^1FfȺ MsO5^Na(qn$c-"*Z*Zvd(|`VJi4e6ݤm_C|rsy*gz&#_:ǈC@}]']TJE
D`+"GJ	+c*s6[5Ť!JXZ BV&>t?MIJ=(s]*z|b]f
>b:@:(I_86,*i-!U1#i%"$)u^f!
2  &@D&Dd)s$J+" f1G8G@Khā FjE+UpO\)>]eNڤ5vÄB榤)s(s c"@vyJv+sIW5JѪ+k9FC!*(edr`:&ehA,jEԡ.
,GC]|*  Jj)x6m|nD0,~e_ةbkj'mkޫH[b_Lv:#z!D`hîhf~) _\䡉T
#*(,gl:-ɞmqRbUl|D^.GIfպRmfD@Ѳ|Ǫbca돮@CAZz" gh0.F,En+])E$2*]@  !clip2gif 0.7.2 by Yves Piguet ;         image_image  @            	geowidth  0.276562geopercent  0.498437,0.5
geoheight  0.375  :(GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,       	ԗ&,paC(pb/bHaDFaI%\Oeʖ*[>͘.e)P>@
>Hst@LЧAբUOU:gٱ%|	(e[}%ܵ2zWI)TrC940Y\0*Gz.S:A=kքKd\q	^jkf(7j8iT8otZ
J0u;)3Q?yۍbX!Wkc#[]7u%'c	TFʹm}Vk{mGX|ddEt|%vf&Z8VTEfE>dmHK	&~=&B'I[!IwÉԍUGQ#(j$dبf?	mqm2Z[{%dMRlWlz&[Uƙ="GBUAUJ	هY_gQbvIydUf fA):凕9]SiYXa&A&%JXmv%YJURv*ڟnlVHup`Eh[UY>jK5yj}
		Zx$gM%x Pj)if>\dyy`8Tڭ]l5k	&֫(j/w⠾Bm6F:N
@VSJYI۶aYv {$-k~S{`"{fZ_Trp&_lU-:
.>wTe΀VfHj˵Pmε8+ w>Kiկ#>ȶᾢ	S wJ+dåqB:nFuXfx\.SzUd4T[*Fga$h$lz(f݌5pRC-XԬཨ`+Lq*|cF@30BѦ?|kZy3$i/'g|b&y#C
7)opޣ
h@`8;g]kL*4#Pguә*<I{s)	`EяyO%и:^e*Eme2s#"̦@dG7-XՈQX,YABm|#|bm1L^P3L3nRc|U!Np&e>ѕc+x~4hE|K&Ď]HwfJLF6i0T	/N{QDw>YdE.!b$7_sdC-P1Td:OR)̉],a9Gm.9["ʆJe,]3{DAShg[ JBmyT߁ʌ!$}*oq*(ʣJI%:wW
Cpg:Z
wFQXS$Iţ> sQba&
D[AKl{uTXgJ}ϗC5KHQ@]Z{V.GXR\95UljWZ,}(RO
mQg&1iU&U1͑6ni\%5JY|fhUW%UGRݜ$
:T= ~c-եM[`FPk:unT[{שp^XX؇ E)Q	O43F_FRg}h,Q	Nձ%|4(0={}U\YLin2XA2
j,c{E3y4[aDs>܉EvYx}Qnz[v%砖=^e
a%眱WFkf^-l|LEG "
_ɮ+GϮj\ ᐆBH1RzmK84&[ewZD~pM3I[Ru+ӥ
TEB(1$nNڼ39wC{zpb:iU]*&>aE-
QDg.3SYėd
0{`78޷;}o4ӱf	R]'+JPl
͗*J#	j)Tl}m]O[9m)>x+Ѷ\{GUYCfbv66g:Y	{ lxαxŏ FW/|朗1
&:\3SsSP!1C=޽#?#L@XU(թ.aBƑkG~Բȁ-BPҬA}Us& 2x3+<%ugf`'oP{Q]F~"cndUpuW2R]VNe~3iTD=$#CAOgwWua]jfBV~0>!u
&$gH
qaHQya|ԅCC5lF4:r$ux}FT~W [`GLA~$8jA-b~(xPcgX]=\su=Ӂ"R3+~OhwE2Hh؀EwT;TApd&~PЋ m DH,OSDUWkDZ6Zh)=7+\4Xr}~Wr>@xV {`$Ei(uKN
0{dwi2WdZ7Pb#DsT$¸#H{W}S}{7n
 ֎iiʸ+׌crDdt|H7r%::7UWNՎ#x{cTY 	xؒ~W',AFx{eX%yPoTSQaƍ"kppA~F{Ǝ"~P0XxWFDTUDKG`]G),sT7`g׃2C45'yo4I`){W;xU AZiVyctv7AarɘiW!Hrɞ3OxəWfKTɁF,}G50=E(IxXP89Tx9iug8Q)|ch5pflh9Ny>8yJg玒y7)a+)+h,^K
4H[
,@jQ?>y|yJ=%5䈓٧^ix~^z+WfE]x4xmiNf6f7]p޴Pysq9&Gu x8꧘!8)*Z+P)
0ArPKcNlNwޥIdTV0GLw|~8)iciu'
ƥʢǚ _ګ, E,Ot[PfZ	&zxy68W.yyp8*ɛju!؞&:ڢzʙ+p1f
 E2+DӛX7&a
`YJZjٟ󊓌)JV	h) j)+ l
gЌ0@grF*Zw[nK"{W7$ 2KTUtgy{z{
a6Qpig)TPPJ/*`;-Ki1
EWXZ
P
 Q;Ns+,q2&Z4sWۢڢ;KȘJ)\ڨ 
0Ϋc=cNK*!BTc\f+cUv7f..:hF{Ŋ_˼'˙؎=A+A[~kv@IYN*1~楸ڨK+ʼpO nܫԌc'ycHpqtgYf6<;w_DWY,i:
(;c;mƹ[PXeUG[ ^p[ISw[`$C?Ɨ㹭Oh9J\[Z%˻w <_Ai+0΋ګtRrYlVDUWejf86J5̌hZK-$۵[먚ͼ*E-;VX(X>6Ƹ7Hod,%){Iif͸^5<	˨)*{|Vudc]%aKM$o^ 
'|vˊ'w	5ӱ>͙-ZZ:\:<k(+L]-c[%a<.Z،uKCi?}k޵ocm10::%^J\dR5d`p<gY'TE+GH^(m7HXgQG?b%ٍcی*Tk(_k+[:s,=*(d0 UNʛ-a}twKf|ޓ:=ڰ=,ݼlnv![(Hyk**۝^od@2cre{T+[&;ή\VV 
*UUǘ	˺[:am,6GNqZrJ۵.>ԣl *]׵]%-kgYƁюET;P+>\8
((J;RˏI	Kx'JȣcMk+ Ï}ڒVȼUcދp
ߛ)XE+M<1UYol$fLum,M޲yû;V~Xn}VOtUAp,+*2PωS{~ݬGxs4a--+|ۄ 
PK]蜡\؜0gD>'zƟ
nͿ>οΨ_\[с=؎-la"Yre
ĊoNK襤RſVo]wսᣭ}ӻ;Pl|p}~zXK$p
~%uVg[~N}_<>ZOuh,uD8ğ9|u-.cΟo+ZjTX0;.rWQZox[olƟ
 ޽U>d{1
x*+(Z0E|WQǐ"YyO?+({o_>|
$3kʔ
ԏ+:PFT+T]V|(q֖`[˵	b0Élm[-BU$X$I+җo߾[jwOe?ALӇ41RBJp ZB7#X%:VVx״Xo_=Ih BT`D3ǏEEȔ)G=%}IcO>VN,?rNEP*X귭h
.ȺM겏*lH"h)D
GZXA'g=X~i"̺a%|J\m"#'@T
nk +m𭼠jpÆ">sXiA+|IOSi>˄L4i@*Lb oR:R6cH Đ*Açd/B$iVNK"ҁf=us}!NrR
n(ow+AK.jmKDhԢ\MA䇕=NB30}xp|͔ҮDʰ̢\L[z5-R˾˨\CYl@\&>YǠ' ч	d
 9U-L DpI9frzӶ+QTם3Y]8#{=txcbѱY" L(ReԥBpRk'1ML}*b0KT7mX{X,[mTrUi+)<p(".,FKϵԊow7.re^\tdd&h֙WaOB^AwN&A݅Qw<e.SЀ*DlRa}h*öӿD
B>Jq|$w:#DQ{M~kcN>ש'VeU!H֑0vөF͌;I? Ә2c=&
u
 ɪAVDy@^{"ovNln[2=b.qy@ddVzZ">4ba#D9LGܦ©55T"t  qM[YجDA9ǡĸ2kؙDr)UN^~Aw료RхXs 5T3"E̜BP.vtŶ-/h
	>"Nm#W`e1${ /ki_朦hxb
D\A]<R[HGOPT=/k"bS*y:'+htVrtt'
g2Iq
>.Y*)G5g ػ2u	g+'iSI}k"
RGhTGw+\I0Om '?f@1Nk\|&usyjT,t^ײbh2;\<t!fv@_WW>T"eAKEH sv1!-0RÍW*R(!uoŇFqZ*lb|
fSb*
ttTF2E
|uadk*Iak')&f.w$tbc ]C'7~]kK,]ȮQbMװkb1m31f6iZʀͷ>AۀC.6xGb,AV4iֈزk-A	 Ybۿ-BD
S\{"7vzHgIK13KRǕWgl%fi5)߱p{yMdBk5!1Ӛė~/4ѸY=&o]94Hw3K[#wL]uC
$ƕ]@xbcFvh`TRkkM
\i=]Z!6N".lWFXBDkshKFyuEc
mIωLXov6_xDÞ8"U()3.n*UG| P<nld+nF,-OueGGĜ9d?waFQbjVpiwT#7W#]W;w߽tjc-?z#w.V1rGo}po%SM:bWWЉL\Go]6"#cի㭓أeTqq#IY`(9x[Hq6v@49{+;#z꧝Z7134Q:õ@>H'V@g<k
.cIN4Qñ|Z4QA5s!%83<+)H|.H:{( ۶I9&(5Pc:(@8	4[h(Y."L泇3DŚХ 9Gؘ`(=րiAAY:=#9SBEa>
x(:*/<U;m+y?p6+Kz>KJ.~(cZࢵ<C@	5',zYëH,Z7<;Q2Jr"ўi-x+j(#.1Tzr(3	q!8I p>A:uFq 2:ے˯FZS5q/IIr4G&CVc>Y!XژPIE~Cé\@PJ:E39#D'1trA;GCjA~؇ȟ01l.nKMk1`ş &`TK8xFzB,B8ns,4صl<@$Y0VXۑ-KIY3(LM0~#:8YCsGHIB&kJSD|؉m	G6Jj$J@H86ϯ;8)ߋ4FI3GI+!}lRH	;q&	+9FQBE
UJij	;ĭ?,È[Q{(@+>5DӺݢJa	!m>N(@8,@i+`,JD
FLBZ@c4-&j,"6FZ&`M2à +VEZ@+K,5;)ǯɔ+81/,8i)."k2d 56^Yi	_(hVR=Ж>	q;IBNɔ\MI(hOt:ճ28n1+HԳFA^A R	V8~ 8M8LR` OſB:V$Fb
(|hJLTfOiP28Xc5?lK5T*~Py(,Yۮ[hh`}icLR}M6<GM0٪3XԦ
$|yЉ0&U-ِFMM"%-u6II0<G@ͮ Q6[ջhvB
ӭQȬ@VC [uä`# 
'Tix|?Y3p:EvD8\cDS2.	r/*ư^z[Vy\ZLKt_<񡤬!ڠRQ%¯m#
A30mkÉL]E+@y{oM~aX	N`	5O/0\ iިLI
u9,[L.d9b:dcED!V6Va V^;Q{"hj)]~OEݞDíVlK4ƈěi~RfD8^oUR7ɇ!v_(iԠ03_gbԊ(TuKr6T;\Dˇ+@8q&eZU 9p	TPh^fI
ޜΚR<dιU=<L&3.45A	6_a&DV0Qa6ρNe
^RGO5ߊeZc=ՓeK^VT]]&˚tfs
n`8cYeR zMZ))gANT<_DT.iάjش;8F8@oYpco;VL&&ΜeE
,z^$*E>>İÏWe÷3HAjDi}ɛľVa掾♀Eb]fͰn]|]*l	F*@݅޻SmV2%hN9>PN݆~chfED|bj{|6V}D($~>Ufejf~r aÌ{\V8ݖ~=PZ7oq#ֳRF/-ii\
=OUZ KPu0DQjf
'mޞhƉY4JiPM
)^]jIqqV7~(Ynh!fɜ&?NKGo&C|Dg5Zk7gemѡU*PKճB mjfBHb:jF)Vd(||g{ַ5p}#
svU<Qs%l7M*󳨔Bܜ]~"s˾`+e]iڹ'h궋{FJuZ<sr(ee۫Vw}[Nל)PkdgO
=RcO*jgu֫$~ǾMI.	pHamnc!y d,Ǳ
w˖p]1O(QdT,rߵl˔K5׎R=?1t88b
U20fR%q_/ԝ+'G x޹[E8D͔s|@؇Rsh_zYcWϩl+z]eU[yg|TZJ'q+w=. Vq;vea6Wmv~T_(X}hU+]heF>22L(È=hE22NheFX,=|,d1r#1D0+VX߷VfmկѤ\:XAۗ/|+ʀ)(v!CZWrث(XPA+_ABFU1F#$d̿Qb@v~ϠN헴toQy7gc3Vtcv`%R[tIfLLq,Oo>oiD2M=@au]%KQGxyTmz@W$ Z-@qc՝c5G9&Xu
F,ĝM2cyE }<w}G?睇>W]Es^0k]h\o*^WUۗ=bqE!~!Y]Ibbn%&#w
Յ`wy K6]II5orteA&fu+1љ+vuEб]D]L!p An1a, M7J})]U
I喛jV\5V-&E$鵢Օbb#E0x"0TzU]V](^UYმ"K<aq*9RnA.mf46݈XvDK0)&	>b2yEY*G1BɬqQxէ׉um::-D
O',	c~/D: Itm%F*vцnN)Ɩ2;ZBeZh[vfî-zA3"JWyxu.9uաE`Eb1}Y~J<)r)8hɵb9ؐ|j5yMrޱ He=Pq飧/nIDD["ES.r+9X4q.x~'ЇyסYh'=^b[l12ZT,[	Жt	 0e,<{eA9D)#JF)`zsؤ~XH\%P^]#NhҤ*L+KLt-LmaE"ȊV
+QaW,T:>g(ak%<*FB,<-/OUÜӼw:|@m]n}Exj\d?хONEBF\)K0ZN9RKe֪v%Y
e#9Bh+WEek&ɦ%-miEN zV[
 {Ifһ LI*mE!3Ӗܪ6=?)̊b[սdK$hOJ8ɤQBQL2-1vTK>iҰ֐?rb%	 bsAZ}u6
uY
+ ePTP	yt|*b^Yb]G?Fho,i+1
t.AN
s0"fcGxUt$-S]9i?QMuK%lr5~P0Xj`'@=藁
SAmt,=hnޤ*iD47FI,~b~FxdR#?iXeZ\"D-jIR=DޘW-T^4gq
k)rF5B1J+8ItȽ3 t.ū?IY7c=O\[krlRͮ&8PǫY0
hTK b%LG8aRP)Mw#QIɺJ+ӖN>f2B*"$V:UMl')4#z y0rcڗ!3Yjۃ+}3	1V-`vàFLT|ܝUxc&"xl[!%G~h8
'9|㊿-skayܗf nmrJaN0A؛s_3;R+N.Q\H+=Ct?\Mpn|t8\<mW]^Zu;9˴c-KbM "ȉoɳ[y+ڝo]Hp41,5
4גp|yq1A 94KZj*C
gC<+x=盼Vdr7+=@݆zUiO	Vi{)e:<'/ |wdygF+.D$"(7&zop=E/\/i0O5T|Bk7`n\J)%D\D֍l[7]mR7x[ÄV 4
V`҄@ZZD^m.MIA ^ q[eV6=/i .PMVXݤ)aK!LIq9^H[aݕ]nRImP	ߡ}!^  +ANEL[K})թCܙYP Q<!a.B=	 =mJA_M
P
&_oP\i@iT ^޽ڛQL DbS7۾]٦!cy
 C

"ϵ4	\ΪYY]Pe͕]Z/f_َ=c'FtᲑ!V!LI5`z] QZ L8fAWHm^=͵["BJK#$<~LT߱l52c
ĥbIL*J;-,[l]"Y`"I.
0Am&*$2G
nWYI OInApf8ZYn	U*&9Wr U2&R\`UbQ\#6%$
GM`\y0$2[`vdK_^$w}M	OA|$VΝ/[;buVT~4Z߹dhgv.)B:NF#^'Z_*Z`<Hn^`{U$=|#`"g6=
RA#[j
$B !clip2gif 0.7.2 by Yves Piguet ;         
image_button C            	geowidth  0.285938geopercent  0.820313,0.51875
geoheight  0.385417                           	        image_image  @            	geowidth  0.276562geopercent  0.498437,0.5
geoheight  0.375  @^GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,       `!@
&4+5a
AVfTh ERh">3
 H.e||
rd>W|.
/QL@٥)PTJ5ThS+RxVZ=YQF[l`J^9mD)ͲpX0(eׂ=f+Fْxeb<7ޔthşR4Pꦰ"}:;!{wOI%*.cS܈gt>'DL7!eZiK:t׊N'>OAyj5uQ"1L
XA-puW@Sbfb#E2
$BE`e^+'z'Q]ȤOXRuSW uSOOÜ[.uo"PcaYMeNz
I
2'	6A(WYWDYESGuS3tNycaZ(	[ӥD=pF]Eyק'`1te6摪˙FEFgy$XF\/ATXBmEU<VբXĆVDVHXY-QDTF FZ4,\7tlqjt2XuŒ:iSuwg/*T]T>QUβui{`NA7ëF&XrmFǭ+C"Eӑʩb䥂IL.tV^7ӑG_l=m!If&D,+@s}]%Y؃[nFFaQhfBqWZ%ThIӪL[T@$UUtcX`bι2a2cnEvrD$g*Z-5Pzyk˼yo&QjɖpZ=KwޑrJ-PJחݖlјVj,AM*3HY.M1>9JMjs$.,܂tMEr!vF<h*?S<ЧqKV҈Eeе@S63Lځɸp0/,>D*#x!^Ĝq.Z=MGXp͠e,Mm3bK@X(:1s2`,dP Yq&g3l_^SҌ $OseR\(d-[o^v)uF"QJ̔t.A.%Vta
HK⎒#x5ԑsg{d֥"b0A+dRa@Q2/fQOd`20qM($1Q^$Xz|!,K֌Y3Z1D:$!dT>.Rz"T)4?(^VajXtd
93RJʴg-,jȓfГSC)۔r$Au5QP<HY 0}N	7Ie)KWVNu<"	:.usU"	02uȳ[,vi3._wM*`"VJAz^j,]yj.RiORBizSF̯D]i=dH4V="k!IDjQsZ>ХglmYi ڛV.Әܙ缺aGexQ#=x2 2-S{dR9_ܽ,;kNdJ&Z8'H$*7ѡ}ۍl /8i܀=w
WYmZs E"SpbT&%wAF| zR2F 2N!	}.I%l=3dD:2OjFz]bύxUHRh;:!]`礤Dhh?IE25,RWуfKG.,]h5S '+!	n(u7n|LsSL#D XxB6А0ArGK
0Ixbn*͸@Ӛ>4mOyE YJ-p1Ee?+qD#OX(Ik֩1$YI\<S|ψrIrc&9_2k6&09Ua
☖AFcl3Y:VTHD+E5NYmlhmxUǲ~8hfXpw, siafJR
G4AT[@bP&S(Ӝ>͊|-u.33\i||| լCcfja~XX0yp}0}r] rC$;zACd_3ea|CtA|_lZƷ.1w
aitPlE`?0J#Y'}ZWyRuNhyח$6YU$w"gxDWt7n.u)xVfiCjO_2F7nKZ3X#|ͷ7
Y}@Q!!re$#DV7
D{7txOCG` 2K|(x:h)0fs`K!HxhQ }rY؇%[tbQFaQ {@%=eF1DCDKԋ1OR/%mXV|7oƋ ?5@gjƋq	^hhYuy
0@h.9;5<5z9seie `+KDrDGg,1Pu8H)}Kr"@4y}K	(_y w}('BcyC&7?.Lw`1EI&|􃱸j#4t^!8ܷз˘uvp
@@C!CJ+zs{H|?7f5uXw|vp~wAɆf[_5nd_(}p
؄u`8VrFa1w1<vr+A`u]!X{CCtzYi/&P4y9H}y`[t'^۔CC'EcKAh~xfiӦ-/.ftu`6rRI	r
[WbVlu3?s\1u tI<7t&㏽=$>	iBtG4:	hևϨ	}my#!z|&<8
EȆ]K7YfwGOiEyx4:fJ%0Zffw3@ҹwu  [y/1Fr.D&ZDilGARJip?gHɋAt:9(Q4p
@|JyWJ}4a"F$W6>xi59Bȭ9Et	t{Oi8H9@I|yX4鄦շ؈Tbp3 25RBぴr8gch798=7Yc8L$-jZivYxi,>2Xנ[|}Б٫)roTqOfQGSt(iw@| K W;f)BX[J%$<Zc$XلNx}X}=;\F@8uCDq
p#` xd뱱XwO*9a44zp>:H}ֈaw*Nrov(	x;wI숹26O6)p2ț9Gp;.kg2쳍b3'ḡ&C idK&_{[AUV(t}] ݫC݋A.-;&<L|gjܑ(3b50{1FeiHw~sĦ8ǸtID0Wjd;I²*
^0W''Faa8"ˆW7(^TtRC{@gڥgK.Kx9yr+4p±:HKΈ؝{QAK4@<"Zz~Bw+́lK,[ϻD20ȥ;>|4c̾e|*|xܫ	[KhǤwsrCъKD6x~(A,ێ;},ʇ[ؑ)D".RQ"5+TA83ݞD@V΋ZֿwOGZ{d#>H,-
<5B(W!>3sDx*avf{֓Иwr ˱n* A|\kͱ*(y|[(ghXsFh&|ėdk-Nwzg{>rȬ{w,tȽb[Hl +,*}`gJUkv7}0_wZzњ7]<쉟-Kބ
לlxǾ$Pܾ~߬ $2V'vT[cӵ @BG|GȌ|l͈L/E{WC̪mБZ½u7:FB'0A*ԻDP\kʬ<|gSz^ڴlJȪbmݠM85~ɷ5%p\RQsj݀K܋_{N8gD
=b; ЗNi۾@gQ]qI<[+CVQ_E+MӗK `{0%F3?<wj=1[0`\fySg %zݐ^cNMnn{[ȃޜu
}wʧ
YwNf98+d/@+ӆ~+3-ЗD1>M?7_*AX.
c?"WBbsQ5tClNǊwDw_1Emhָt	Iz̧y`7P0U	dSq7.tn|ͻho7y1/(-K8E]O
]:\yh ѯ +2oWxxB+3⻘p|` pI$ %q4AP2΀cbģ"eQ'B!!P$"т-bIXEDZk*o+p}K*Ea6$ O$Ej}ҥH{-qr=Al3  "h Dħ2J$SA)X.f`i

W|E Dv_V2\hEC;6d12ڟS*˟Hw	.	zJN~лV0f!Mid*J*>Bj"ˋDy-/KA+V ̟记b.Ⱓ 1҈IJ3\J\L \*
CL"6~pBYgR0*UNSqȲqbF/O A1S!dǨ+fbP dAzJLdl(VEf0P4I6.K6G.*@rkܸcti%9(Jh>**H$,Qz*겮:^cVD⮌pKDۻ1d4
,*xCݮ.gpbEw5ml눅NӓKeG)2%Դ<VTdڋ/غiaMV1?,{24)>?k:iZ3F9$괾kOn r̔)5,
4"WP-P\Q8f$VSīϐCܺn\lZa~򩇌j72Sgr"*Bt:T TDJJ%w$(Zâ#	h8P!O
Ys2MxZ!]VȐC)Qb0NʪITe>'᱐R-\M?ĚFDeNDhrx 9d t` 8Oo,	l=/Ї!eD{h&7	M->v DEz~[]@!JވwNtX.#	L,۴|W
FhE
EXszB$HteA&"Ll'ЏM
D%{ę  WAh+2!aavIy5ꘫ9,[<K[ Q$-)Ãڔ,,$!,B
*+
yh?Ofj`4H@lt$эj/S)]ߝF*x]
uϥi$Hte(Q*1%RV?D@5GQDV+:0iVDk8QiV$EcX0ݑ'Y%iOx#"l.R2 Kw,+Qm\OӒCddp3:N"cp(Q;?nPٹ\H\4|WIUl}֣$$i2WdD|	jPB@9+GQ ~BJ6P[eѨEdzjm.]n<ZS}hsQσEJJD*ѮI^yZbSJi]r~ۂewzmRE,\VZؚ2oe icH̃@
0r'fZA|[Kb"4z3#c zQj&gmi. .@X\WC[ը~)>h.Ә(HCS
!U=mj52s'p:Ӏ{}@dBÕ^XO@[#lY/օx?$7r,a3H -)a)Ek}=R)&H{{>8i}mm{󢃀(*\Yq?1:$3Yvſ"-7FI%m1Ht㴙l(%,!5}38 N8Zǵ21&9G&1d -4ˮ6lo>*zӛdIf,ds)ʲS{} ׸NNg̀4nq̴Mi!"HL.aγ+N넯s<,ыMㅃArTgCqϐurtc۵LLG5 |94	N"%z$:tmIyQ?Щv9$蠤 VJC>,-1j:<FDm
 /P=0["m=)#A(6ʔ Q߻8$̏Q4`z+{A#+-^Zѳ=C-Gz/!"h좨,Ҹ嘕 %8CqڐVؕ5V/y1{,
"󠾋U{
8.+	5	{M>سثC!SB! 
U-4>49{'V pۛ;$ư0\;	-,P
H88a:۾A64)8`ޒ&]'oP`D9*0F#Yũ@	zB5u
 6D3pDj$96HJAȇqjѫP kC6I|%N;+Dr*#2*\ꥃJv3>P,b	R@<>^8G{Bհ+	z'TB%A
8D=RCF"q>®XΰR(Y3r+H0A:9A-JP {' .XIđoGy
`9;0I\*+ PYh(x(K:(6Q2ЁCa32J?qOA99DG6ħܫMPpS.2q{aЏF;Iz
mLL$?,ED8O8dOnWۑ~Oa;H!3(p`xAJh!Ϫ)A㻒N`m1@9yafaOhqkCCA$M,PBSK7<,JL錘X!(dLqҁ H)EC1KDH_L7eB檬r*lŁ9=!
U)T	;d8
N[pRd+3N<RԫL:tQ9E7s.FF;S@7SΎ<+[ɁBiFB%wҝy]l;Uvu0%s˞S%񡪭/킕ʸzAxAm1 lYOZH{ -J l%$8!
,D°j#D;6<P7?%ZE3~U/,ȁ.P+	kV8PՎR\S>~ϨOsU`^bS- ZzX]Q@BVZAa)Q{l[Ͱ*;z=ªM+WUe[isCB:U{s5:DURZXq K():3H6"HؽPMo0ߴ*H!q3$P:Td\()wGHʣA+ZA%^S(J?{{Pʑ(dϐۯu+y'r,ZY0+-^-Dr_mRDəFΐ	  :"
:	a<*{?~݁2vAȢv]Dx#,MQ)(\s	MΝND-	Eˮ*c(ڡżb9̛ϻA(,yPէ-DB $`$>ďHʗ	QĻՍLɌVFAk`.ݟn	a[U"}%01P:> ^B*fF2ۗ?3VR HB.3?
n%[%"iPAhY*eG*^X݈U 0 >2cI4V (!!=E "Z,-'[ۣOIP%<-m܄HͥBF*i.YG /i>Vw+l?9;;yOfF̏U~5κl(<~a&>&)(r&3\[6hj?au%͋'r0ͧHOeR3Rzx"6۪H.BߐmH|rRq~e	:g/>8
CO+§#,׃0NY5uɝ#E_Rc h'/£VA "VkrATz]48Epjhv⩝S:AdDӄ{mI|JJ^Г"$:*lM>TgƽэǶ$F 
JuZ23P"	i@hD̟ѣg	!):9dIHs$F%[q
)5`p
v/,0 nyUDs ԡ 1Q_qrګ'{
*@{ 
SD+fFaRs舺ӔX.Zj	>5S&h
?LvY힫j 6q.ωޞo}>sDn{ʎ	uS{*';
)\tSKDNb@
UhQK,CD~ȯ~B%-B< >T[ٙ؜溺z+tx*f9։TUˍr$R9N,EO.!
!&x
.iL6mWTl+	\Q	lu$[Xr.ypt<bF;lfg.q3%TBt;HJ }\n{5z7kp߹Qcz~InÍ..8
	P$s;v`b U!  /ʥs4^jf9]=58IB'ʔƛWi 2X7PgXBʕ2$"!Y\9 8`@VdrH#b̒N($VB,̘A#-:mᔆSWh`UAb֪+AymT@|tq:v$p
ed ɻVd+V
ݚ 1 JO%JFMAS3Z
XrՋA շ~AS\tcV Iu
thoAv\h߁fl;r3@]^LA	j g N1SPUU
4lWa%V"u ]uE @M+[{gFB-T>
Q5>;I"
UDd BfSLLnFHQt "Ȓk2_3X5.0uUYapeH"(Ǌ>p$^AW׊1Ģ-j4x3\Đ82dUF	Ic0ك{VReYWT:`T}9ei
 dᜬѝ)R"B\5^ZID
efJW-}<5vPIyeC	MMVyQƃhſ)\a&~}jgjwQA-`d޴fKb&Z!O%DYf`1{RRg2הz[+^X[gbfp),fz\{IFQu%F"70BX>EFqL#f%yB8tMdZyZ5V H"/p'Hϝ
$[V"0IK^dǃN֨GN)NP>%߷dUT"^i&WWbH?fÜ@"-L]s(JtB}l[A۾F	$qG|*7e%L䚟 'Д*BB=⼩gBҀ :[ca<x2j03֬ *J-L˰3	ͤ䭚e~*  0+[ Wv!$>0e/}: &k!HbN7hAlQ6"ÕY4$
}DvzJ%?D!4gFSSW!8)`·>0Xlr#pcDs-}ȹ7ڭ=;jىd/;Qv-+JhZEW)NТ|TmlA@4MfYd`1Y+
)b(K&RzasmZ} gH(" Y9LsY{
%QQ>4楅RaؾvQ"/u&cpDUQj JOPE6`rुJ7R$r/|aکhMMh!A52!)BojVNݰ>D{geo(-	 teVMC9pmz/*ƪцD*<G[~7&fv%ҺYLDe*1<`VX+ǋPE@Tcu}.XC]EVFFJҞĴ\7Rl$!XE 9%NW[~4D ȗ'Yt A:х$[KF5υՕHHY?̌<qh\FlY¶TT
A,зFXc	{G"z,l.b"ǑU[Th/0!g臷2s;}HL
5t7I_qoy]Nq3Nh#+O#q%?Z6W.|(({`v4Fs	&H2UlkE"f (Ǐ+4.8O PE)F*Ž?L8;d{ƺ [+$k@x u4pBܛ}4t,L=*bk0Ue>VH6^Xp4; E>J8`%L`+jdmn^CAS+ɻ
B~$ͅeEH
FUtٚbGgD|貥݉t]X%ݿlIJ&_t 

Euj 42N4 z{4	r0ydũF.DvcuU$D*%l	_KF\k$tqD|'?>i5""9zaWpElȒg78!3B;fK<ԤF*mʊ^">'>ɒ;Qco>AJ=>W9H,%`c]<NKURgtx8uo
;_W%ޅ]<)FUlNs!PEB_\A堝!qݛmH^E5q'Eu9<*1ל΅="UD@AljtDc8 ɰS4XؘBYYtaU
ȡ-]E0KDWítAAvWEqAxɅ"] d5umP%EkPꁅV3\a)"Xy^]=99\D&F>t 
-ؔYlO#wD!H(0`ut$2j83&B%LDEE!VuMIH9N
R`HVHL[MG	Eb%2ğ͗V|ٜTМBsğ\$ %IWWEJ%2\"!|L $u,?d(D|1%R#uaT
cO[<Ea1]EDt>a jDvHDa!]ѐtd1[dD}Z%IHT	E5}L'YT2uш!Ve,n%=cMd[٬-%D'܇u㉔i:@1WB%MAM	vAXFd=䑕ubt%ZaGVQxQcId`7)uYa[l%fE` یciYg!I/vG-+	`X)%gV6]HJ&V>@;h~Gu)̟xgdmvphKADOX$q >g
ä*Ĵ4˔ǵtn
Ef"f"㭅Nbr&樂T q"i~_$RTȿXXGZoDBEs5e_du;5]CLKt6DH£F6&ͅ^VU#	_zXJ+Z4UBDH˓Z*f
gq>'GSR;&grFd]U
uL!^R[NduD68Oś+tfiH C@^J)WբQKHn,:eeu"eWNď:ޑy./:!^|7uZM܋lV+v_'ݪcitSqYYAraqk$\Τ@_\]Vv~	+"ݟEEjp9
 b6,&߷VW\
^FaMջ֬,(f.L8Ϝ%p+@jyp&qXX
]ΌrUcCam;~eF ,G\JՏIL+Tfo|@o
Z-,zqmri-X~r^&9n!TEE~-MQ 5XUܞq͂U(y|ne>J!.ZVnNi4vBLfStq`Ġ|ZD^̮D6qXtǢM9jWJQJ'e.6YV@fQIl'qTج|NiRBt)XxX"DSj=_XT9U,(vGƩ.--wo;}>H]?Jd2^cFX'Bì
SrGGd
[Fړ<֠F4sĖWB$_HOadDAΥ\RGOWm.Ȣ_wUsDVMkrZBD Dt  Հ?!tXEEj go>\YF"wbg-Z%~/n%XRd(&l\~Gu؅`(u )1YG1&`Cdbe}*ADC
%m`Ad~kN-ɢ^oRt7I
IBϙa yvpUr$\WnP'*btzj'+(}Ta,lN+ih
]lcNnMOSXf/e"*#Jц
LOtCA [J
PY%tTDFP/"[Ɯ95 P>teC@'tfrb0Ĩ08|ᡌ,5H	]HAꅡ}p)dqPԄ:aQ<PSoy*#!SVFu4DC\rob+
AJ'ODmws+ىt
g/AK^%-SDj9m"3ŠC)}:yDc8Qw_4jQ7sЄw,G
Hm:+Kpjdnb͢ !clip2gif 0.7.2 by Yves Piguet ;         
image_button C            	geowidth  0.285938geopercent  0.820313,0.51875
geoheight  0.385417                           	        image_image  @            	geowidth  0.276562geopercent  0.498437,0.5
geoheight  0.375  {GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,       H*\ȰÇ#JHŋ3jȱǏ CIɓ(S\ɲ˗0c,͙8s2yϛ:BgOPW2uJiԫ"yRZ׍5雺鿱VxVزMۊMNn׮_|w[x, S2]v-S&2浊Mut?Ά?tOEaf:sؼ%Zs_9p wxRÉYrћ;+W:Q{	}ڃ=;w_}|L}3{
HR%MTXӄ5sEa הe U %$ )V}-[S1Xx5
Q)`K5efF
I$L	O-ԏP:UeeRBդUr%rYNIW&Hy&iU?&Vq5Wv'7gܞlW	yПe$ȣ[]ʈUeCi1"ynY6y
IY@jkHe+ZQ.d1NZX+Dfa?n+R쯑EҴRkm>ӥަldVnrʫ[w
E 'pO	/pȟN1Sp.b5m[$+\02387%A34tKr	5mTC5cIZuXs7=枍j6`'q4YvsS-Cၛm4ɋx'5agQ呏mmug9GP-Ӫ#:K^oLww^3mӞE>u/Nx;{|KG4'A:ok=[;M/7D󓦟Rl{?G}+]7Mx
HA:h	y^nZ 'UpQ< SI["cƏ.)<
sBpz6@ڐ[!W,sVnKLb׽lrՊ"`;bElZ{)'פsC6%V;6K"Fb^De; !AGz8m$I9IEҐear>Hp#T#%DJ<`vN`'ˀQ.̥08JVdWH?̨͘Z"6C-ҩ&&բYnzN~x:'DiӖ<'zR>&*O5ΓtD/(Nh-))ᡏ@iz6jjhAߘ;'?
RZԞ$f%FthKARpL?t8esvSuJԧS|*T:IͩT>=*U/Pԫ4+Wӧ>p S=V]tMm[OV֕x+[Jز9͢Z!:vMlZVڑWs5͠_*Xz+[km^;W:v@um[[}~[6I}q/[\?\-Ze~֨5.fֳu]Vm[^غI,k^ϏHա|y{ڇW=+_nM퀣[D૞{~\a^paīUpu["pxokOl.1s\b6%>?|L.ɐeK{)?\&I#792.sG2
iy=g[dZ9+1֒#l8wSsi,g@o'|&,;wI(LW>y͒γjXh8vцM,gι"v3H&ԫ[[j	14>^o'ׇuJ3j;ؘ05ZFpCl=~6
@Q}m嫱l"'_fi!VMYG;N2G˽w[84q
{?7cOo8ok-ԥN=XNKܿq~ܹwqtY&xfd<ĸiUD	6}${2̒  !clip2gif 0.7.2 by Yves Piguet ;         
image_button C            	geowidth  0.285938geopercent  0.820313,0.51875
geoheight  0.385417                           	        button icon down.gif  @     <      	geowidth  0.045312geopercent  0.5,0.5
geoheight  0.060417  ,GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   !    ,       \ڟx!"Tłi1Pɒ)lc? W
tR#Ibʬh͚`ώ9'GJy4*S@5BZ-S:WxRkؐRPxLք  %;[1y Flz{YtxZ*a*Tlf賓I7xZ⎠E.GEֳ­w{
p#:  !clip2gif 0.7.2 by Yves Piguet ;         button icon left.gif  @            	geowidth  0.045312geopercent  0.371875,0.554167
geoheight  0.060417  GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   !    ,       H`*Pr"|
+VGEF#ȈT*I@*WkH͖aWO>@TebA<W*]tI)&mԤ@<N#RJ]jXh6NYNp$XMظJvlۧI}70N$nK]՜3P{#iMСv	9Pe;>mkږWwH !clip2gif 0.7.2 by Yves Piguet ;         button icon right.gif  @     	      	geowidth  0.045312geopercent  0.423438,0.477083
geoheight  0.060417  GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   !    ,       H`*X	r"YPşx6tŐGR1Qa×0cV&˓%V'_ϟ>}Vf˔Ck*]ʴfћHJ%jΡERuŤ\fݪёcrڬEᒍk%Ya<+]ie_)+VjI9i*wA Re0hkF}jMF88oY !clip2gif 0.7.2 by Yves Piguet ;         button icon up.gif  @            	geowidth  0.045312geopercent  0.457813,0.583333
geoheight  0.060417  "GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   !    ,       H`*P
Vaċbx4hѣD$dƑ0Sr40ʑ+Ghϕ;LI&NB{Sşx	<4н?$RQiN:Wl٩_ƶm1ZOܸQM](˹^au._']:8^9vd
w)9být/{3mg4GĨzu*elwM !clip2gif 0.7.2 by Yves Piguet ;         calc 3.gif  @         u   	geowidth  0.304688geopercent  0.465625,0.545833
geoheight  0.24375  GIF89a u   f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,     u  H*\ȰÇ#JHA
,2Ə C)0 H
')RUʜI3dJ 
@LP	Ryj<p@ц939r = Pzp 'di˲\-
 kѴpq8)Ը
tkN2+Ѫl@w"`!3
yw*5<arĤ3l01iUHU"ϊט3/PZO:ID;DI<D{TYʲ
^e-Y?]ѼM7xl1
k'|56H8o'yXRd`K T'T )d߄e n!XaV%e0It`g_NTAGt!]}oAx_DkA
T@"SRb6cr1@'KfLp nfhf՘Gn[N%sxBYS	]H
ЏFևUg6@xДggrDGҞyTĖ$ydAj(( )	eX㚈Gmjf-wTRP*IjvEifE[tpEjewXqEHfǪDJa>g|9:&#DiA{jB>\0UU\bTE6K2<UUsI2gW	՚BNa{3CĬ*v)JBw`.ta[FwRu̐PWBCˆ5*@wWaGpftىFRU1(бUԹ]6sƛprW4=\vRadk5J*Ň-X7iZr-9zTZԭ5Uvl*iyKBZk.c
YaZj}o6I&8׉uIJD5)XY*ռ+Ť}:2I.2[n[j`wd}L U"9/)'H
Z̠7zp,8~p!$Q!+T
Y&u( DC 1J D	FHNN!+0
Q1-H_!JDV(F h5PjG`aIF)AFP H=F^ paWD: &5Dэ5Ҕ@IT2$+qh ,̡G(6  ˁ(4,XSzɕpeq$l K|QJs(Ί0ECMPe
#p
 if#Hh#Y8#×(Ë!;됞;S15Lt5Җ2
5I_rYa2EM~q8 pNШ %"5:$b@!"˄l; 
x8Ж!mzQQ&QK=逓r AFz$A.:
P?6a&oYq-2yl(F9B!%XviD9FQBL V%(RVer&gKviw[H6DdJl^a-qkH6SCWCטj y B4vmTۓʐN:DJ[֣+j
^4+z:
;bӣF&*4/u-xW6/Ea3[
ךpD,
󘶔rw@L"s8FITd
^MxMV e.,U L/`
2Ab1$i\Np&Ɯ"TF
}Մ1כf!Jr!が$Xl!M",<qzrh ҉ c3_D~nypk \K䕇|gNf97r4iLR]XrfM
d|3BÔˈ2OBla؞|jïzwp2tBJkF4C
Jrՙ}K)S)u!]pq NaXA~p
ז8BP3 SG$1Ԗ:o2C}DyI*{)TJd0;'W5螞tff^:5nbhO;v&Go{ISvO49Ѻf@]e^U&H	g
g&ϖɔYX"9"j/
{W1 
^Wz
 !clip2gif 0.7.2 by Yves Piguet ;         image_image  @            	geowidth  0.276562geopercent  0.498437,0.5
geoheight  0.375  
GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,       H*\ȰÇ#JHŋ3jȱǏ CIɓ(S\ɲ˗0cʜI͛8sɳϟ@
JѣH*]ʴӧPJJիXjʵׯ`ÊKٳhvǖڊmwѕv! 	nqpL/Kem߲/͜C_v{軤>:g1h:mĳڽ
`mSm`/f5\^t!]ħ~;trkݭx o=Ҹ{z>lG^RX^%(Z!W!"^l7V`mz!x u"k'`wH<[#`Y'Ԍ	i㐖iOJ6XQ2Y"mHq)%5V<y^U2uOdhAd^?9mބhjg{&jo&C>}$iewk^)Ӧ9	r4**o5եt&ێ[
9IX?	,p>%JШ (-Ӛm+a}'z-Am
T([[6ʪsk.F\ڇ
p_IHz1fs!u!.,bJ*;t{sK3z3m,4NsJ	 @g
nV=6[hm&_?-7t@=7َ,C#=h&*yenޠ^>O䫍G-8ߒ jn䕹(
$j+[\c[j]z`M]'oh8&cSCv@Kc}ޚ`ɽI\@|G/kW&?Jy{*h'{_j' (ے!y}s9
!XN{üplZ i wAI!)!Ap@<Nn"mك G{$B\XLG=MDLQ7ET{'.}A"1c x*31A\.<i/ę8E1"ј$V,^DFcH0uVqdpTR$|%)"YƑT%H("-o4%FNz
v͋tfB2#'0IGr*0׹35N+wLo3OӄkYXFms&Ɋ6.T"/AqGށ5+׼xQ8K4JE˄f&u͚HP:7,rt$JB82Iؓ(lҪLU"6<Xi:*RE*Vu|"ZZuELUÇUUÚNu᝙wF ѥjC
aZ9TߪS8 ,ӒhR! Zpj#'fBKEi[ZnFĺrխjk[Sj-u;ކwAz78k)-o=4"=ui䲦kv;"m|0oK]$#_N1R.awXwQ}
{Gy͋|#Ʊٲ[)gD~d]M-S*LvIdJ%%0+;pbe/]{lsx~۬<v/χ1] wu0F;ѐ'MJ[Ҙδ7N{ӠGMR !clip2gif 0.7.2 by Yves Piguet ;         
image_button C            	geowidth  0.285938geopercent  0.820313,0.51875
geoheight  0.385417                           	        
image_button C            	geowidth  0.285938
geoheight  0.385417geopercent  0.820313,0.51875                           	        image_image  @            	geowidth  0.276562
geoheight  0.375geopercent  0.498437,0.5  GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,       IH*\ȰÇ#JHŋ3jȱǏ CIɓ(S\ɲ˗0cʜI͗nyO@m'gУ*QP1*UOjׯXsn*Uaɪx6ڷfK7ܺxi߿ޚLÈ+	qc縲˘3k̹gΔ r`5Rװc˞M۰;mpVf ȓ#rp{+Nq(Gʸ5Ã.WMj~߈լXZ~|;>ݷ؀`h	fϹff({W !kdEI 0(4hψѕ"޽bDi72ȢFIף@ι$B©nGO<.*\f)OWh&Bgu%9C*+O> ܓ d&
n&"Y/=VH>THFz ~A
hmz@xd=2)^z	6XYe#棫JθʧȺBvJg(ۚ
+djb<F#Vf҉9ijYvfؖSNHy	H=o{ZQ	0. >|d^.ŚY{*׼1PT, *i-_#5 q<~\# O=UπTHxL;R?B5
S.&\ r=C/Lnԓj4f_2+sc'm`6\+ 4ˉ/_7㗧&пRn5*]v>O0&@m~;>.36҃7,/:tS_VkO$8Xkǳ
 a@.Ff*)yY4r?GI	짽o3ߜu:S6p\J*AZ ,,*#*qţ[ լW2 
kC;r$l"66a0BJƩhl+DR9ĊX̢Uvk~#<?U@tJc|,ٖb$Q"xԣtÏ /'닗QS( G(1CMnҋ09k+U@'l/\,*O@Џ~䲛yD&}?:DfBזеL Ĳq1(D5NrvP
A':MOVûX<]!pX 89#MBHc̇> g.KV;с{<
	IOC&t,ujO^*#VGO_W{\5Oj,",6iը)EƖT2
mj/ci0V>ʍs@@KR	mݣT׸u,'},K̔|tY
Z9 ɵ,fW?yJG*tj}` 2D [fmZq۩fv\z'O=*.W}>~L }lz,2uwu4^j+ Mct<K3%i$-`͗
DA_^^$*k♷RxVFF&Z}'{[Bn !wD/9W0\2ȾjOa֎cXA&G9.Y$p2s&#{
&>Cw榤%1k=a_~cs9[ųckO.K̙Ї~nQvqPғ2hSrERUV2T#XmִvhP"?%{݌A;+.+5&vIҒiX~ܚ<7KM݃*CJFeaYZZm'NSMQ2w(\ 2oK^%WV1I$h<!'xǅ)
pY4ZF弑9#bs\{;9]	# +щU!} !ɽ{|1u8x`
Ӡq3tۙh`MoSN2AEx_C#מFz3K 3C(wS_d<2.=h--Tǟ~׻[~i2zSobEXx"/壞yMw
-9Z"~Ngd_ԛuƀg]bVJwWE&@'4jL~G ybAv w|	xZUZ<T6uz0=7;ƁFDD+$7.'W&Xwg4rI6T(00hk'3K$~vs:9AExrk~&7.3V1t s!" XhZ5 DpLGq?y`rl=oq[ `8aF){~x"k47W2Ք0+k{9vgxXΦS$RgE~+g-wzĊ0%cm8}Rxz6$vY]Q7g?x$cuH tIKLEMq#M՘~ŘxPhPuxȇУx26+m!:}/o
"H#9x%C\9^!xA*!T(Y*	Ӓ.0/IN1۷sb:!T<J#0[#i"ѓA)+9[4I#JILyXI[RyTyYi_QXag1ؕg	i	OI1[7ҌEHYKyXzl|Rً& )ٔ(y9xYxI)\əIINi@9wyqKiMyLagYxiNiIA1>7bPʦl &N`dia	ۉҞu)z4yyP)izٛY].99yɚ9
ڗB*) *Q}g')ٜ:z%Z|r׉Ii ImOɋ$!a!9Xx#z$Ag3
e?ڤAlJPZ3A 'RyT\oJh}*axq٥OZ65*qZ(ry
ک_ E

"E8'٤W:[ʪ0yJq!KJ:O
jz]ʫ8B$z1Z߁Jqj fi*_`TzX::  JSa>zZ*Pʯ;zq˩*A[%K'˱+B&;Z,Ư2ڱ6kƳhMHKUZ˳RT
4?۵nj8lq; f1k+[pK~KKZ5Zsun۷۶˸Z}Mc;'a빉v%%:񥺰Mk{;+N{{țʻ̋+fѼ;{ϻ[ڻ۽0|T˼˻Q껾Kʱ컾G0[J[˭ y
ܼY{[(,
"1&*00ܽ2<6|8:"<B<	ALHJk+8KRS+\ZObL-۪Cc1#Dir\Op<x\p|~ǀȂ<Ȅ\Ȇ|ȈȊȌȎȐɒ<ɔ\ɖ|ɘɚɜɞ<ʢ<ʤ\ʡlʪʬʮʰ˲<˴\˶|˸˺˼˾<\|Ȝʼ̾ !clip2gif 0.7.2 by Yves Piguet ;         
image_button C            	geowidth  0.285938
geoheight  0.385417geopercent  0.820313,0.51875                           	        image_image  @            DGIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,      G e`!P+
ć!|3Xqe">&l@]wEI+<rJ*c2.*I+vgr(@&#J4REͧO 55i%PI:g2W,eD)+2֭P.{YXeʼk0b)]&7!ވs'+8ArE}eg몧>/8m{
np!Z9Np(#_>	YEbFgAy`~rwx'Vv~S?M۞Yk4`juTԀr }uu@baTaAPZ [RrCAr8e)Tt3\tYbe7kY6Q9TՅAd{(g.CJ32=,\X@pa`	h l8_e%[i1&Wx9 ᕉO2rIfs9
z}|G_^hdD.U֤) !WE]WP\׀@y8ky=k@]r٥@2 @[@eiɵCGEx&EwЍ
B6fE'
qbzPvY嗟9ꀛ<pk&"+ m @Yxkmk݈` Q[7C͋y_3ܣ_=OF"/۳,"PO@=T*ki'l@5L0n^ " r]{TEʷE]8AA$ph:0mkTK-5Fo1[,Vc M3lV|lt#
""]NrB^cl0[0l]eO S}hnSKq*PumqsqӢ;Vo]]HpHDƊ%
]PpT`G>]r#j"2J: h΄(La
B <-aXUH^G IyA	N7O[Ka4e-$(q]?Xъ~XL>uq۝a
"A5@ uq#GX0#Ar0,T	i~*Y囚"HNn^   qcH/w]|QяRH`?;nnP6/Udˁ;(@
򘃬u,Ә#.hOJ@ܨxݙ,Zq/$^`M{&).2#t|č*uȥ
KH@j&0bd=XץD0|LV)r`B";ݎ(*~GMzD)n b!pv;vw["KjWV4UUB'^/Tgz4U  "K[1sԔF+zJ,v\IarD0^MuJqь-*kQ=4̪ȳfCT	W5Z÷Q^lii\!ED5|)8Jν4Ku``#ID`OF$.Iq*9#.߅x]]
 "-60ҝuk-#7z1xbM=U[Х^
Ss';Vsq.?ZDQ#Cx
웢$NIHh2'$Z=;3Oos0=pZ+qźnLXaAp*F\R$K]dv@z0nn{hf|IhP1O;qƍ})\@G#6 8Fÿ~t:IȌMXpI<MAnD๑
,@{HOz>'M:Ur6}w epQXocǥ3-i<n7}KSܐQ1.vQp6e~M~!/qе N2 F8&rFd*ʴ1J׺Vilmk{[0W
ni?є6QP^8n=;"|9k)
{N<accpGԔD,M
FGݧ&ֽX2Rt7FY]c:W۵)qjE7ߨoD}<A,\9쟵hwq~x%O'^ϲqX{x1.Ѷ{O/|h=š'oC[}{w#}Q_,c9/^>}KO_pP<(]_y|}Q3$8OQ=aY I"SYqC7"H)!E8}76r'R!!Q#<!r9f!"a69#q"2A@V D  -!28er#1'B#A<v77B&V@(eFfw/L$)Ae]gh%JGr8 $
2.Ar<}P B'svR]jE&d"t_
8eҌ%m!q7])%G+Q)1Yb)b!-u-S'85^#&ar'#Vw,dD@6 1sDrQ-"s2"~#"F2(a"W t!CGfvJ^NLSHO%L(53:Ȓ1K:SH4&!"w*BbrR3]%q`cw9vƁ +
"KLH4Qk"EI25" S S3::~!Tf!-# 	A/}3i9k[3{l1+&Y`S9U//2&1`&r^81,C=JbTN
J'7z(7$SG Bt2#3ObSls:="9dU*{2CTC5^^>y2=teMg@A6|O$TbF!ku1=>Eh8!*(Z$V5HMgVn2Cˢ^QY!
D^SC(;TOa6SEo<QuCQ!r$2&,uq=PZb&QGr=PeB3Lr&LcCe5@rC;[HICS|78ItR/eKE
A\D@K#7 C %8
Kq/&Q4g*"&16,QcM
WpQHC_dSN?@jz1SXtsT6S5orgM)PnͺѺ]j>T_CULSZ1d;ptJTĮ4S{gEd6\AXB%@A;@&^pvB"]{'
[=(ď+d*9T0dUg0g4kEkRīr2~GVJ&\[u;CcX<T:$ND@֮U%PH%IŴN }Ay0Me>bR^0!}[$W&S官W7
@XII9D'eR[Gu/i2)B[2)-C+TSQU@51HRV%9:+r(r SHt0Ndj.heB<AyC{$SRKzvrr!UH#>/FHUcl& 5t}uWdJUE*ժ %7#@};E]=tVWdtjPۿ#V$wI5O<
\UW%`.SFE
_*WcֽLDX<Ex<UTR`%R0"2HjktVıSZVq&0ɂ/;;t6m+h:rӶiFVi/%h&S;l*TCICt3aFEdx!jr3\;uUoۇq7RWW
Vdi_mEhTr@2gm[|mEhs9jI{]EMdlq5\dnuusv
Ǆ3ofF&oWxpe~P+q}n@T_SsT,n2Wp߶hFi݇J{EWާWVzWj,@LN@_@X;oGuTwvv
]Љ}d
m{hxgкgv
$znwT:zn~zѿoGqrp}SsC]pwLN%h'up}~gvh*.pwzQD8.&%	h1"ԫ_&{OF<Nc

CI A׻A^IձQ4+$re2	>K&r&3(gA*!I9QZ{A%$+9S!<}O:%s%EC}!98gVڹ85ڍ!.۽3A#Wq(SXM#J1<aHAM5&?HM>Q_r'b(!pB)2j9(JQH6H lmhs0wW,H	!'	7"j0AA
#8
~23C8=AZ17Q8jщW
BeUGC9zH
x3$=axCّb-fHx\3	b֭08G!
Ƚ"C*!0g"\Kڠ;"z'F
zlt.6qSTSn%VթMnKq]1XCj4U /5&!A]sY>'#-8^vሃ!K|>x\-'5)x+u8}%x5&ˢ!
3U80'5r
a،8bfwsK2 XnRL0 ***P^! 140/asHG"r4:
	,3,BY!b,jc-'O#ANAɮᮘ݂C< 192kNk
j50n4 c?Sd*DW!*>qG)+pZip!/	p.L# VIöjf j9++;'+o5W, X}
38Τ8"
qyZ)AA33@V !FT` qށ+  {Pa `Pƌ96p Aȅ%P0 E+K$@#2 9RdH5qr|3caER+3u>Vⓑo芬ZkޓJM.횑Repy^IqeGĽ(q.]t AQ}Ӥ!qvGCC,,"A+4ּ5F5m {[Oem232`^:<R)ude6/QhhI:vPcX8:+~Kk6-9[is+$	;$: !皫KJ\HDډ0VXIAO+sͩj**jj7lJ1ʫ2\ /ɶkFr;>Q'ۺi¼VGVHQD+jжYM |j(f߀
&1sz^]Q""5o+*fN& ><r CnXo-3цϔDH+ɢaaAJ:
+a0ިdw^;	5Jq__"L-KrybL?il-lLL3AxTkI[DJ5(q+-Y'J5r2^)gG:<i|ջdXhhKmIbh,'Tlht@#_e6daVZFY4u\|b73Ij"w(bS+Oz_$7fGBȁY}yϬ2KYB*PBt6SZf[IC4yV'.wS{IeaC%i!Nk֥)},茿KQ_3I[ں-٭֢"͇HQ(A#aiVù#7LuȘ@'[j!VӅ]._ @b\鶵-VcQR#o^ C 7"yٰKrA0Ơ],ZH>9Njߚ6½Dg/S"fP* !#~~Ǫe$fzdHՇou#/ `LAuJbA9)0!)!sP:jSsqD~ێ9I!GC揺-oXrR:z?XāpB1>ȅq418
BG6ɤiVb ˱{Ȋ"bGp3h%L-$i~#oRLDApX	5ǍtIS긂4#&ei,[y9xB-ܾ:\HtaϐoQGdUjnƄj,fHXhȰGLlUfEkZWB_tIJ_"HK⊦@nǢxԦ8"ݖ:cO7SPfG?&и3iS2iaZ5A`Dǹ
hxz:+
EȨkMdܹ/G!ˑ@ԥi E&nˊG&Y=UND/ۖ׽moFZb
e+XZREmL
U=b:JQ#^"ƻCXM>QE'&-kQkZQUy)QV(n/%Sq
`fC*n#cb-j~z_阨6BՌ-<
F4Qy$ͬf;g2dE[IdM\TZTrM1TIn?YdǉbDnuMerT7,&UU z5Qն-URY GL<22QT4i"$7c(E6bNU,x̅67]nv{;I9{fE?r#Mt8.E2drs$&?x-~WhB.Õ$yM>r{ֳ3ゔqhqL
۸=.pbjtV٬ 6ҝ}J4hGZ@V^	v`G\d"3w.bvڪ҉m7ltn(aݸ':{oDMg&?ضMNX-}	hB39;(J <!ݶnfe,-ɊA@<ZtS(:3M_<GEwܼmu E9!j̣GID">/ME8Yn>R+x/:S4JkQYtH.c<˛c<zP#<k	";D-{$&ڲsIa6cJE.e:
2#W#9
p
LoQo#"r	>uh>ļX<1
$CǛ@<˛~PY 9L%DS`ёj29!p
9Ah*!2@J$
&DniinH0Y*T4,f¼T$ţtCT.
\E*G̲!:C"GyDxDb*@J.	 oD(LAhD2!$E*G8Bb".Jo@YdYCz@[+tFK
L8mcr @A3*/PA.2(D*gllQInB4Dr&DHb*rnH'tQ2&VÞL<~o0Jp)VDMܪs̐J^|b#>uGf?1DfIC,&i"&JJ)FJTɘ$ID8M*0Jd)dJtndo)Bꂒ!	2*=dLS~t4ˎT,IiHoHED?'ȷDDEoMh)IdNkjY OcBNMƷ\MLDAoHϗ|N(EMH!^H4IBPbtϻd]OgQDz]{+*I
+
+ӳS;ͨQ'AR~kѭӌթҼ[,-(ӠҝK|(
|@л3}6@6!6uS@6 0p
蔥p+(Y!US	NR&
'mRRRY#Uز,e)
޲2,|hS,RYع3u[
\Uس
&%HE
QhpGEf%FԯkFER5LR7Ż-*
S/;S	"֡(7
}|&]Uw5>}`zبoRؐѯ{
%IѦX
p
KuhV*ا`QK%5&>*%UOVNR|(|XUvŨ+p ڬQ)%Sү
JIhўa ]Y%YX>Vp
%H-YeX!eY t,PEZTNxuW U,PYVv#98 R
*)\
V$E`
xZ5[-[h*XHXU
N]H #Wʝ,@2]]}0S$&"}ԃ
Ry$!@+֚8Գ YۀV-׮aԩxRYցW֍״XeR@@S}ݭ#q~R͸U^8/
Tp֒P
H^ +R69[=YV' ШNRs?_e+au׭]Mߴ.Z-%qP07}N
 ! nM] M]bue#_9VMx]3/Q*s@'ǩQc[ F*^.aeXM%_S_LM6XwQ|}5̅# pUȍ¹e w?8JԐeXS]#} }}TЌ؈V|fDo&Q`1c̥	;v	=.2B%	fSgzFaN&ذ%
rTlV%TlFZNbqhhhm(Vȇo9V`-ay.ZiXΔ&\M

|X؀.suҦ8
!.AMF;1EҦ.j|hj}H  +AQXEf{ᕄ"\lv{p"aR	]_ѵ`&
\Ȋh`Jj&J	-07A鱠czf&#=FXQޞ(&
7fчxZ0] ̔]
.2i<9kXđ/YR|9}	)Ik8cQrݵbTf
.}ER|Q%ч{|8p޶1!
 n #{س(瘡
P	PYqc&%AdVVJQivf]YI !ςAQ
"oaR'eBi	_Mi0#Pو` 	1[o.,*YrAѬxM
*ч&*@Ǎw
ȥ=#ֆ p>q>CĠAа.gm[%!5T	n%uh)Ł{/下D*72
s`ahGJ_0;X-`ua$|.)(@ݜ`If5ѽ]"y
O	Yx&sSxri(/!yqKu^sG]XVVF
e5w ܀r#-x8Ki}ZlW  	$QR/d?ojMV͍,
w ˅ᰂug&BK,)	~C1ixy2x 3l.928	61~
/.T-9ͮ	I&)p$
	p8v3'θVQc'ْ>RЍM h^i
'_Y"F/ȕ3/9
Е]	(@zL	jcigU⎭#
,dȰ" ,%A2D ("qƎi<   I4<@ƅ9.ubOBu`ƌHepF,t:)]70W2`e|
ͧoS{h	v9kA+	ޥܗ+h "KZX%z'Y~$2]fuԩ,[f$sZ9Ue:õܮe	+VȊ55,<P!sٛqOv\r,%$Y$,li~O(?hgUօRL \p=n8("^\aA\V\ ,\ ]tψePSisFt{+tRF*
MeZe iDQ8m5H&>BXq]y'PD]B*9aM5@Yr@.x{c IeH,ZH "h!{ @h!TNF90 ]@ȏ %"@ "WiXsCg\CjD)f	B8G=)&t @yi"UԒ-dAVK
JN	Z^8?^/avg@(m"5+x1H;>Fo1e2P6PѩPRU͋H+x%?ZV"XaC61BB]\V wyW@=*Q==ڞM3䔴rW %ҏ:{a\VC,XQ\_uP VGΐc_wK$q˞n4wQTwH<:C
#J??x E+xu|!
D}Cf4+E$ pۨO%JEm6FGNA);̔ Z߼
Cx;kMr4Z%q^tX
PÉr4 $$5#FGu
()4ڑXreJPfQ@MVzuxG|![5VU$,RP7
!-zSwGCNg: [%юH ғ$)CR4!
B,ъ_abʤ=IJK%=`HIg>4|ldܓ$:zcZ 9MFeP
ew3R[(7
a%$I0i
iV'Ȉrce)ˉ$A 0/$@HfaN"+Aj,t
AB {,hӍ7vL"B'4H;2C؈NtR\1hdD%SfBHiMStI. :թD
Y!7XQY>|0kgMlMs9uWwIt;Vr5]a˂ Їpr
xGidm/)I03E3Zy"Ж5zY[@PyXQ-\*۸JyTnm}裸pK &	N|h&
CgUUmB[E!Jx<B7|x^5-mdD +Ș9QX5 MDf,Rp] U?2Lٜ1#+'
B:"
X"->5Rw+lK|g[>>FX>VC} *)5M+
ɤfC;/_/>י@vD	bcV	}.->=$ъ9=\ĴC셏hk\C@t_K,q"L1D j+{ւisEgzRP#fףJpWrm^wE3f6˭h%"BShcR[jF':=p4}99]hh7Retǐ;=' !ꆠ^*7<|E6WZUW;٬֒өBb=>c|f7jd
XK;{$NyȳR 0b;,`vLj Sib X5ёk=zGu,,'{FӼcWV6rQĥJՠTq/`SDHJ9EB(<#lsdIM'ח1B|-; SLYH$/L vAh|<<QX)rc1Ⱦl옹b$= q9W:CuiZku2{ekg >BE%)%xxExzHB ]{R-m41"
]?Ϭ B0Z!!` "-R`TTx-B!&(aJzěJPj_,ߩ B7 `=ќ`W` 
KU-\UH*D"*G"zH#
D"Z9Dz:AI	ч 	C%
.P% Q

Ї=Q=u
0#1z1rԺ|ʁ!˙QƌOF@ t$!*^2"J+_AW`MEfU(F?
$@^1MF
[
9O0DQ?!#a$
O=!mu]	
#
xC1
KN$Oe$MĝQDVJ[ЈhF uc?(A=U!82Tv"kOTX!P=a+taT%]"1Ex
HC<%Ph!,B
^:i 
$}
C̄R$CLD]1	T^ttDlx&m&K\ELEVnaݰDE7<7)eRf$uT"eMhFpW
Q&`fEt#'z'a z'{+5c@x٨}5Hprzde)*VreIR$@Hҵv>ܽvMZi[G@=(l((#FdXȨK(lWtAUQ8neV8FT$MfL
!%YB֗d]\M+܃vĹ)闖~ie̟
RNi܅Oep1?i7$:VfXsfVBmD!+u)QD醓yO1A$\ijLJt'VOWAr>gr
OjQe#G䠚$:ȡ6Z-=4MD;]d^ߥǣHd,ʵ,RF{BlS9hfS-rz%G""ѝdN3	M->{v`&,.l>,5h:QHdb2ie:8n$XQ EE,^DE-zjˌ5ΎС{(6C4kGMµ\?@=jưv$<_uʗ	RKLD RUC*.W$evcea,L%kT+ڕ10N{ޒlYQzMO(_DGv"nS᪃P"I=
eS DTD-nVm:.Q#	+5XkgkrV^Y:*Tbe_Tkdꌇ"?Duxҭek^qXn|.b<$kQK>)U,ᝫVFBB
^<57:UvxnD靣+D<OGX01~G_,ȀRIAt $.a))ZV2Ue?G+֊&'eg)aU(:eZ	UIpXx`.Hi`a	k)Bdh18d2?d>+R&e0-?	JHy	HBdjDrH`MٌHoOnE"+?i+r-dqr?<J72u	-k+C""/uXi16늮,y-Sr+''8S)2Tm--:C+t-q:%1`U	gA-
&[AȕlM{HȰ-#ˉLڰHFqE9/74;'&r::?K*S;d&g48i.vք	ERu%ŠDHbvCbP|Ad3ZBL82-+r*5;t+/'+Y[ՒtDʈMe"5"(6" >IB$t|a$K$JOpL\ x68"WlϠYg$s[3:v\C[4k?8v),;JMOC=ƽaIM>B"xa]%B1`!1,~CTurkj\rK4{[1JS:pWn2iΈmwP{7.9߂/W41BcdgsY@]m7kw};S&M1Ӹ}7{5{?<<r-g
2
rRdfufA K+rVtYU75AbPwCБ7&S۲sJq{s|5𙤫A⺤i\
x8Vm-:Ta38bSYTXk:Q#<H#ʢaM7×#ς7.U?pU+4TӃ7=t[3X7lʀ!^!'9fmd22j6|eSc{${O(6g>F-?ᆥ_{+v[;{H6vqUJܣJ
5~29/#<BbGV2uCcq7Q?ɧ# IzgS8 
̫<߻r:.R6ߙ0i1x`TK-gRas=#v%Bh}Anhy38?^<έf=w?PI
,=w;a2yJ<Rn/PW-sj]z_IK\{ݧ;rwG':B9|7~/">:wrH+
@DFD!AXr%"A/"DԊU"V8FzK`D\PK
޼)!L5E\xp!j" ?}/QH!C"Q"<2YƤL4aB㶕HUofa-((΃e\v͚0LmRFEReaEtS/sMlKӂ&jVm bNUtў1܅BdҶ=KFįKY}EzmlМD$}Kwl_&4kS
$7֛1D(m)ӈ1=[i.'hg;ڲBb*.%2Ө`(c6

kS(`!.[.2A@.E6g2on*ȍZI<4oS
(5C5G##T3$GCǼL뭡͔ɲ|K<3KAn)8rQ2VR5ƚ !clip2gif 0.7.2 by Yves Piguet ;         
image_button C            	geowidth  0.285938
geoheight  0.385417geopercent  0.820313,0.51875                           	        
!organiz.gif  @       J   /  
@GIF89a /   f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,     /  	H*\ȰÇ#JHŋ3jȱǏ CIɓ(S 㾃 &[I͉-XA}dCK 7*# OyZdG(A$FhQl-Lfk҉F0mܺP[JHO4HW_i>!|*'nҪ%xA
<iӃVYIв_G!}&x!PfFX?	6V(9䌬`K\+0-~qiv;x
#_h\aqf_8
>8TZuA]Lņt
wk_WnUBaUPQ-f'@ F,$YN-1s]Bu7PN!AVЇgl+Hd{z㋼fVqaG57?:g{"geNԅ?TGP?YWyGS"_B
oWF
7s*ף@uڲIh䦻
R>bFhB6~i
픞zT|jA	{-*ar&UTgruu~&l l  ʐԍO8hGEqP$?3e[Vz[aZŪ.4, 
fCA
JgIO{]t`1O%ǎ?тxSzTG ' ua0?[9)A;!Ӵuǻ]"\zngrolY	 @H>><uMj4szOCF<;
18a.$Uʔ?tt'tiKGvPϖB%{5?;ܷxv;s?#@(fBEGsAo!ub`haMѱAWDt?&e82³(L
W0gHڰ5.LnCiVPp$a\";N
'Bpv\JF20Jh#q.xNb&f(cUC#G0;fEIjB"R6G!bpXТ*G&<yiȂG7-
H 	gV Q-9!
qR!Zަb1!CA^V̑b
WKX,HYG
`o6m4r)N!$[s(̦AOdq%H٥L
6,6HdT0aV9\=SAjÜ	_k[͠qaqܺ$/Z-f
qnp6-99F%cg=+x0ai~w-fiL7
[`ⓚ+8ͩ-9WK)6mo3H[92cڏN7q,6TsՂ"Q 
k4HOi7#9W!&($^Cڕ&"9s]G*кEޞV kgnt<O
H~:Vx︙;H.\=	ZJN&t 淺aMۛ&NhV"mf _5(IW9u}z y+Ě@6OsRL1l>6$boK8 k(XAy3'B7 G$.K\W)!TmD]uWB5/`XPAQAߐ2dfYd#Z"2hN60 !clip2gif 0.7.2 by Yves Piguet ;        V diary_dissection_group   i on mouseUp
  global glabs, current_target
  put the labs of the target into glabs
  put the current_target_name of the target into current_target
  popup "dissection_menu"
end mouseUp
        =f   	geowidth  0.96875geopercent  0.496875,0.560417
geoheight  0.864583   New Button  @J        EW   	geowidth  0.945313geopercent  0.495312,0.564583
geoheight  0.839583         	   	       v new_appointment_dissection A   ff      '   current_target_name  btn "New Appointment"labs  Buttons
Images	geowidth  0.245312geopercent  0.142187,0.847917
geoheight  0.08125         	        days_of_week_dissection A   ff     x     current_target_name  days_of_weeklabs  
Fields
Images	geowidth  0.245312geopercent  0.142187,0.279167
geoheight  0.052083         	        date_dissection A   ff   q A  0   current_target_name  
fld "date"labs  Fields
Images
	geowidth  0.390625geopercent  0.778125,0.1875
geoheight  0.102083         	        delete_appointment_dissection A   ff      '   current_target_name  btn "delete appointment"labs  Buttons
Images	geowidth  0.245312geopercent  0.142187,0.927083
geoheight  0.08125         	        year_bar_dissection A   ff    :     current_target_name  scrollbar "year_bar"labs  Scrollbars
Fields	geowidth  0.026562geopercent  0.03125,0.6875
geoheight  0.052083         	        pattern_dissection A  	   ff     B^ 1   current_target_name  org_patternlabs  Images	geowidth  0.551562
geoheight  0.104167geopercent  0.295312,0.189583         	        prev_ap_dissection A   ff     \ M   current_target_name  
btn "prev_ap"labs  Buttons
Images	geowidth  0.145313geopercent  0.901563,0.46875
geoheight  0.1625         	        month_bar_dissection A   ff         current_target_name  scrollbar "month_bar"labs  Scrollbars
Fields	geowidth  0.026562geopercent  0.03125,0.627083
geoheight  0.052083         	        today_dissection A   ff    W I    current_target_name  btn "today"labs  Buttons
Images	geowidth  0.115625geopercent  0.079687,0.741667
geoheight  0.039583         	        dissection_record_title A   ff     xV    current_target_name  fld "record_title"labs  
Fields
Images	geowidth  0.539063geopercent  0.545312,0.279167
geoheight  0.052083         	        month_year_dissection A   ff       4   current_target_name  
month_yearlabs  
Fields
Images	geowidth  0.214062geopercent  0.157812,0.65625
geoheight  0.110417         	        calendar_dissection A   ff          current_target_name  group "calendar"labs  Buttons
Groups
Fields	geowidth  0.245312geopercent  0.142187,0.45625
geoheight  0.272917         	        next_ap_dissection A   ff    \ M   current_target_name  
btn "next_ap"labs  Buttons
Images	geowidth  0.145313geopercent  0.901563,0.889583
geoheight  0.1625         	       e fld3 A   ff     U   current_target_name  fld "notes"labs  
Fields
Images	geowidth  0.5375geopercent  0.545312,0.677083
geoheight  0.58125         	        fld2 A   ff         current_target_name  fld "title"labs  
Fields
Images	geowidth  0.3625geopercent  0.632813,0.345833
geoheight  0.05         	        timer_dissection A   ff      O    current_target_name  fld "timer"labs  
Fields
Images	geowidth  0.125geopercent  0.339062,0.345833
geoheight  0.05         	        New Button  @B on mouseEnter
  send "mouseEnter" to btn "fld1"
end mouseEnter

on mouseLeave
  send "mouseLeave" to btn "fld1"
end mouseLeave
        U6   	geowidth  0.5375geopercent  0.5375,0.666667
geoheight  0.654167         	   	        time_bar_dissection A   ff         current_target_name  scrollbar "time_bar"labs  Fields
Scrollbars	geowidth  0.026562geopercent  0.420312,0.345833
geoheight  0.052083         	        tomorow_dissection A   ff    _W I    current_target_name  
btn "tomorow"labs  Buttons
Images	geowidth  0.115625geopercent  0.20625,0.741667
geoheight  0.039583         	        other_dissection_group    on mouseUp
  global glabs, current_target
  put the labs of the target into glabs
  put the current_target_name of the target into current_target
  popup "dissection_menu"
end mouseUp
          7   	geowidth  1.001562geopercent  0.50625,0.05625
geoheight  0.135417   tab_dissection A  	   ff      D    current_target_name  	btn "tab"labs  Buttons
Groups	geowidth  0.107813
geoheight  0.05geopercent  0.096875,0.091667         	        navigation_dissection A  	   ff    S  J    current_target_name  btn "navigation"labs  Buttons
Groups
Menus	geowidth  0.117188
geoheight  0.039583geopercent  0.189062,0.035417         	        edit_dissection A  	   ff    *  *    current_target_name  
btn "edit"labs  Buttons
Groups
Fields
Menus	geowidth  0.065625
geoheight  0.039583geopercent  0.1,0.035417         	        file_dissector A  	   ff          current_target_name  
btn "file"labs  Buttons
Groups
Menus	geowidth  0.048438
geoheight  0.039583geopercent  0.035937,0.035417         	        close_dissection A   ff   d     current_target_name  close_boxeslabs   	geowidth  0.035937
geoheight  0.0625geopercent  0.982812,0.029167         	        resize_dissection A   ff   N     current_target_name  resize_boxeslabs   	geowidth  0.035937
geoheight  0.0625geopercent  0.948438,0.029167         	        contacts_dissection_group   a on mouseUp
  global glabs, current_target
  put the labs of the target into glabs
  put the current_target_name of the target into current_target
  popup "dissection_menu"
end mouseUp
        <f   	geowidth  0.96875geopercent  0.496875,0.554167
geoheight  0.854167   org_pattern_dissection A   ff     A 1   current_target_name  org_patternlabs  Images	geowidth  0.6375
geoheight  0.104167geopercent  
0.3375,0.1875         	        record_labels_dissection A   ff     x [    current_target_name  
record_labelslabs  
Fields
Images	geowidth  0.14375geopercent  0.09375,0.45625
geoheight  0.404167         	        record_fields_dissection A   ff    o y)    current_target_name  
record_fieldslabs  
Fields
Images	geowidth  0.46875geopercent  0.407813,0.514583
geoheight  0.520833         	        r_number_dissection A   ff    @  2   current_target_name  fld "r_number"labs  
Fields
Images	geowidth  0.304688geopercent  0.820313,0.1875
geoheight  0.10625         	        photo_label_dissection A   ff    x     current_target_name  photo_labellabs  
Fields
Images	geowidth  0.301563geopercent  0.820313,0.279167
geoheight  0.05         	        photo_dissection A   ff         current_target_name  photolabs  Images
Buttons	geowidth  0.30625geopercent  0.821875,0.51875
geoheight  0.4125         	        import_dissection A   ff   \ ^    current_target_name  btn "import"labs  Buttons
Images	geowidth  0.148438geopercent  0.745313,0.754167
geoheight  0.039583         	        left_dissection A   ff    
 \ M   current_target_name  
btn "left"labs  Buttons
Images
Visual Effects	geowidth  0.145313geopercent  0.09375,0.8875
geoheight  0.1625         	        right_dissection A   ff    \ M   current_target_name  btn "right"labs  Buttons
Images
Visual Effects	geowidth  0.145313geopercent  0.901563,0.8875
geoheight  0.1625         	        new_record_dissection A   ff    n  '   current_target_name  btn "new record"labs  Buttons
Images	geowidth  0.242188
geoheight  0.083333geopercent  0.295312,0.847917         	        delete_record_dissection A   ff    n  '   current_target_name  btn "delete record"labs  Buttons
Images	geowidth  0.242188
geoheight  0.083333geopercent  0.295312,0.929167         	        search_records_dissection A   ff     '   current_target_name  btn "search records"labs  Buttons
Images
Fields	geowidth  0.242188
geoheight  0.083333geopercent  0.532813,0.847917         	        sort_records_dissection A   ff     '   current_target_name  btn "sort records"labs  Buttons
Images
Fields	geowidth  0.242188
geoheight  0.083333geopercent  0.532813,0.929167         	        copy_record_dissection A   ff    d '   current_target_name  btn "copy record"labs  Buttons
Images
Fields	geowidth  0.157812geopercent  
0.742188,0.85
geoheight  0.083333         	        export_record_dissection A   ff    d '   current_target_name  btn "export record"labs  Buttons
Images
Fields	geowidth  0.157812geopercent  0.742188,0.93125
geoheight  0.083333         	        clear_dissection A   ff   \ [    current_target_name  btn "clear"labs  Buttons
Images	geowidth  0.14375geopercent  0.901563,0.754167
geoheight  0.039583         	        arrow1  @     N     	geowidth  0.035937geopercent  0.948438,0.029167
geoheight  0.0625  GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   !    ,       AH*\Ȱ!}9,]'.Ō
91v(Ib\(eJ+r|%M ٯfJCh6gЃ@3r:
6Ϯ_;;6٤n%&M!:p+^̸ !clip2gif 0.7.2 by Yves Piguet ;         arrow2  @     d     	geowidth  0.035937geopercent  0.982812,0.029167
geoheight  0.0625  GIF89a    f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   !    ,       AH*\Ȱ!}9,]'.Ō
91v(Ib\(eJ+r|%M ٯfJCh6gЃ@3r:
6Ϯ_;;6٤n%&M!:p+^̸ !clip2gif 0.7.2 by Yves Piguet ;        	 Calculator                        X     U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica  U 
Helvetica  U 
Helvetica  "U 
Helvetica   U 
Helvetica   U 
Helvetica  U 
Helvetica   W 
Helvetica  U 
Helvetica   U 
Helvetica   W 
Helvetica       	PAon preOpenCard
  global first_number, replace_mode, operation
  put 0 into fld "calculator"
  put fld "calculator" into first_number
  put false into replace_mode
  put "" into operation
end preOpenCard

on keydown thekey
  if thekey is a number or thekey is "." then click at the loc of btn ("x"&thekey)
  else if thekey is in "=+-\*" then click at the loc of btn thekey
  else if thekey is "x" then click at the loc of btn "*"
end keydown

on enterkey
  click at the loc of btn "="
end enterkey

on returnkey
  enterkey
end returnkey

on deletekey
  click at the loc of btn "del"
end deletekey

on rawkeydown thekey
  if thekey is "65407" then click at the loc of btn "AC" --key pad clear
  pass rawkeydown
end rawkeydown

--stop the mainstack getting these messages
on preopenstack
end preopenstack

on closestack
end closestack
                                         	     @`    33      ff    33                 	      + ex 
  on mouseUp
  global first_number, replace_mode, operation, second_number
  put empty into second_number
  put fld "calculator" into first_number
  put true into replace_mode
  put "+" into operation
end mouseUp
        ~ e "  +          	        * ex 
  on mouseUp
  global first_number, replace_mode, operation, second_number
  put empty into second_number
  put fld "calculator" into first_number
  put true into replace_mode
  put "*" into operation
end mouseUp
        ~ H "  x          	        - ex 
  on mouseUp
  global first_number, replace_mode, operation, second_number
  put empty into second_number
  put fld "calculator" into first_number
  put true into replace_mode
  put "-" into operation
end mouseUp
         e "  -          	         Ex 
   on mouseUp
  global first_number, replace_mode, operation, second_number
  put empty into second_number
  put fld "calculator" into first_number
  put true into replace_mode
  put "/" into operation
end mouseUp
         H "          	        Del ex 
   on mouseUp
  global first_number
  if the num of chars in fld "calculator" > 1 then delete last char of fld "calculator" else put "0" into fld "calculator"
  put fld "calculator" into first_number
end mouseUp
        X  "  Del          	        AC ex 
  on mouseUp
  global first_number, operation, second_number
  put empty into second_number
  put empty into operation
  put 0 into first_number
  put 0 into fld "calculator"
end mouseUp
         * "  AC          	        = ex 
 Qon mouseUp
  global do_me, first_number, operation, second_number, replace_mode
  if operation is empty then exit mouseup
  if first_number is 0 then exit mouseup
  if second_number is not empty then put "put " & first_number && operation && second_number && "into fld " & quote & "calculator" & quote into do_me
else put "put " & first_number && operation && fld "calculator" && "into fld " & quote & "calculator" & quote into do_me
if second_number is empty then put fld "calculator" into second_number
do do_me
put fld "calculator" into first_number
put true into replace_mode
end mouseUp
        ~  H  =          	           K@                           K   eeeeee                 iGon mouseup
  global replace_mode
  if replace_mode is true then
    put the label of the target into fld "calculator"
    put false into replace_mode
    exit mouseup
  end if
  if fld "calculator" is 0 then put the label of the target into fld "calculator" else put the label of the target after fld "calculator"
end mouseup
         & v x     x1 eh          e "  1          	          x2 eh         2 e "  2          	          x3 eh         X e "  3          	          x4 eh          H "  4          	          x5 eh         2 H "  5          	          x6 eh         X H "  6          	          x7 eh   ffffff       + "  7          	          x8 eh         2 * "  8          	          x9 eh         X * "  9          	          x0 eh           "  0          	          x. eh         2  "  .          	        calculator pattern.gif  @        8  _  	GIF89a _   f3 ̙f3 f3 ffffff3f 3333f333     f 3  f3 ̙f3 ̙̙̙̙f̙3̙ ffffff3f 3333f333     f 3  ̙f3 ̙̙f3 ̙f3 ff̙ffff3f 33̙33f333   ̙  f 3  ffffff3f fff̙fff3f ffffff3f fffffffffff3ff f3f3f3f3ff33f3 f f f f ff 3f  3333f333 333̙3f333 3333f333 3f3f3f3ff3f33f 33333333f33333 3 3 3 3 f3 33      f 3     ̙ f 3      f 3   f f f ff f3 f  3 3 3 3f 33 3         f  3          w  U  D  "               w  U  D  "               w  U  D  "  ݻwwwUUUDDD"""   ,     _  H*\ȰÇ#JHŋ60'U2I  @4@<%#;3f7) Ir')k	QC{*ҀыUZRM`T>40pԺuT;6L)@V}X%
+n[PL``] 
24:z2U3)R0	F ao%"%Hǒik'q~m>'xl(^ؕC
d0}dOj(8*3&G9A<lBfuw TFoC9 W!P  @@}+qDP]e}ax$PB-!yuF5d8}B9PWH${3u{sRBuWE^2iMy
%!m)OJF' S-7YYB!afUYѠuPnjU
*c|EyPVZC_>jPP'zJRH.&B`hIaT*T{:Q*Sz$SN
!5t>N@Jjo=
a+eQ* 
N	׊ iQxc_D+EKr'XetDU-[iD9Y\".I
BeEYU "kBȩ{Ue:켝>q/,)C`2HS@B[TWmXg\D%t-B &c]ppYG=uRO-P	zI
8 QvPBuh@J
tsSyB< t3u(9C_'zIc^#dPq7{5俈>m/v/8 ;s^>i|nw	
|8hmyqճ }m7>}m4	kp
	=o kB*p^ A:#CHn'\A7L8

L!"4')apA`	_Mo 7*AD;NY\-uwI=`q$	/j(*G
>9Ay;4$򗵿)yZ44jLZ	6:M8@-tiQzj
7v6Nmԓ0iZ-Nu<5
vs<MmJ%nz8INbaI@FFUG,O)Ti~48[
T@׼,i`XMZ!Ӽj!9Rb /4bήzaAH/=˄lD̴4i+Փ
]"E^JZ.7%=heQ-*)(1by Qs?UjPVaP=XmU PUz!u;%2bU:-5+YCnE$aM+]Bf)V`-qbh/Y':7fgAXV!
p;ZYUXxՇmY+Rx݌L7mKs$dOT[h-ʠhT}W$42*Nڷ  !clip2gif 0.7.2 by Yves Piguet ;      
   calculator  	`       
     	geowidth  0.470313geopercent  0.40625,0.279167
geoheight  0.05         0   	    K@           &      Dissection_menu  @on preopenStack
  global glabs
  put glabs into fld 1
  set the height of fld 1 to the number of lines in fld 1 * 18 + 8
  set the topleft of fld 1 to 1,75
  set the height of this stack to the bottom of fld 1 + 2
end preopenStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closestack
end closestack
         y           y  y     W 
Helvetica   U 
helvetica       	`                       Properties of this object iP(on mouseUp
  local go_to, r_ex
  global current_target, advanced_user
  if the num of words in current_target is not 1 then
    get word 2 of current_target
    delete char 1 of it
    delete last char of it -- the quotes
    if advanced_user is true then put "advanced_properties_"&it into go_to
    else put "beginner_properties_"&it into go_to
    if there is not a card go_to of stack "object_information" then put false into r_ex else put true into r_ex
    go cd go_to of stack "object_information" as modeless
  else
    get current_target
    if advanced_user is true then put "advanced_properties_"&it into go_to
    else put "beginner_properties_"&it into go_to
    if there is not a card go_to of stack "object_information" then put false into r_ex else put true into r_ex
    go cd go_to of stack "object_information" as modeless
  end if
  if r_ex is false then
    toplevel "object_information"
    set the defaultStack to "object_information"
    new card
    set the name of this cd to go_to
    send "preopencard" to this cd
  end if
end mouseUp
                         	        Script of this object iPon mouseUp
  local go_to, r_ex
  global current_target, advanced_user
  if the num of words in current_target is not 1 then
    get word 2 of current_target
    delete char 1 of it
    delete last char of it -- the quotes
    if advanced_user is true then put "advanced_script_"&it into go_to
    else put "beginner_script_"&it into go_to
    if there is not a card go_to of stack "object_information" then put false into r_ex else put true into r_ex
    go cd go_to of stack "object_information" as modeless
  else
get current_target
    if advanced_user is true then put "advanced_script_"&it into go_to
    else put "beginner_script_"&it into go_to
    if there is not a card go_to of stack "object_information" then put false into r_ex else put true into r_ex
    go cd go_to of stack "object_information" as modeless
  end if
  if r_ex is false then
    toplevel "object_information"
    set the defaultStack to "object_information"
    new card
    set the name of this cd to go_to
    send "preopencard" to this cd
  end if
end mouseUp
                        	     
    7)Pon mouseLeave
  set the hilitedlines of me to empty
end mouseLeave

local tLab
on mouseDown
  put line (the hilitedlines of me) of me into tLab
end mouseDown

on mouseUp
  if there is a card tLab of stack "labs" then go cd tLab of stack "labs"
end mouseUp
         K  >           Buttons  Groups  Fields 
    	H             5             Relevant labs:    object_information  on mouseUp
  local it
  if word 1 of the target is not "field" then exit mouseup
  do "get the num of " & the target
  if it is not "1" then exit mouseUp
  if the textfont of the clickchunk is "courier" then
    if there is a card the clickText of stack "Concepts & Techniques"
    then go to card the clickText of stack "Concepts & Techniques"
    else if there is a card the clickText of stack "MetaTalk Reference"
    then go to card the clickText of stack "MetaTalk Reference"
    else if the clicktext is "custom property" then go cd 35 of stack "concepts & techniques"
    exit mouseup
  end if
  if the textstyle of the clickchunk is "bold" then
    if there is a card the clicktext of stack "labs" then go cd the clicktext of stack "labs"
    exit mouseup
  end if
end mouseUp

on preopenstack
  set the loc of this stack to the loc of stack "personal organiser"
end preopenstack

on preopencard
  put the name of this cd into fld "cd_name"
end preopencard
       6w              	  U courier   U 
Helvetica   U courier   W 
Helvetica  @U 
Helvetica  @U courier  U 
Helvetica  U 
Helvetica  
 U 
Helvetica    advanced_properties_notes   	P--on preopenCard
  -- format_field_one
end preopenCard

on format_field_one
  local start_char, end_char
  repeat
    get offset("#", fld 1)
    if it is 0 then exit repeat
    put it into start_char
    delete char start_char of fld 1
    get offset("#", fld 1)
    if it is 0 then exit repeat
    put it into end_char
    delete char end_char of fld 1
    set the textfont of char start_char to end_char of fld 1 to "courier"
  end repeat
  repeat
    get offset("$", fld 1)
    if it is 0 then exit repeat
    put it into start_char
    delete char start_char of fld 1
    get offset("$", fld 1)
    if it is 0 then exit repeat
    put it into end_char
    delete char end_char of fld 1
    set the textstyle of char start_char to end_char of fld 1 to "bold"
  end repeat
end format_field_one
           w      beginner_script_New Appointment   	@          w      advanced_script_New Appointment   	@          w       #beginner_script_delete appointment   	@          w     #advanced_script_delete appointment   	@          w       advanced_script_calendar   	@          w      C beginner_script_new record   	@          w    D beginner_script_left   	@          w    E beginner_script_right   	@          w    F advanced_script_left   	@          w      G advanced_script_right   	@          w       beginner_properties_r_number   	@          w     advanced_properties_r_number   	@          w     beginner_script_r_number   	@          w      beginner_properties_photo_label   	@          w      advanced_properties_photo_label   	@          w     "advanced_properties_record_labels   	@          w     advanced_script_record_labels   	@          w    ! beginner_script_record_labels   	@          w    " "beginner_properties_record_fields   	@          w    # "advanced_properties_record_fields   	@          w      "beginner_properties_record_labels   	@          w     advanced_script_photo_label   	@          w    $ advanced_script_record_fields   	@          w    % beginner_script_record_fields   	@          w    & beginner_properties_photo   	@          w    ( beginner_script_photo   	@          w    ) advanced_script_photo   	@          w    * advanced_properties_import   	@          w    . beginner_script_import   	@          w    / advanced_script_import   	@          w      1 beginner_script_clear   	@          w    3 advanced_properties_new record   	@          w    H advanced_script_new record   	@          w      I beginner_script_delete record   	@          w    9 beginner_properties_new record   	@          w    : "beginner_properties_delete record   	@          w    ; #beginner_properties_search records   	@          w    < !beginner_properties_sort records   	@          w    =  beginner_properties_copy record   	@          w    > "beginner_properties_export record   	@          w    2 advanced_script_clear   	@          w      J advanced_script_delete record   	@          w      K advanced_script_search records   	@          w      L beginner_script_search records   	@          w    M beginner_script_sort records   	@          w    N advanced_script_sort records   	@          w      O advanced_script_copy record   	@          w      P beginner_script_copy record   	@          w    Q beginner_script_export record   	@          w    R advanced_script_export record   	@          w      + beginner_properties_import   	@          w    f beginner_properties_today   	@          w    g beginner_properties_tomorow   	@          w    h $beginner_properties_New Appointment   	@          w    t  beginner_properties_close_boxes   	@          w    u !beginner_properties_resize_boxes   	@          w    v !advanced_properties_resize_boxes   	@          w    i 'beginner_properties_delete appointment   	@          w    j advanced_properties_today   	@          w    k advanced_properties_tomorow   	@          w    l $advanced_properties_New Appointment   	@          w    m 'advanced_properties_delete appointment   	@          w    , beginner_properties_clear   	@          w    - advanced_properties_clear   	@          w    4 "advanced_properties_delete record   	@          w    5 #advanced_properties_search records   	@          w    ? advanced_properties_left   	@          w    @ advanced_properties_right   	@          w    d advanced_properties_next_ap   	@          w    e advanced_properties_prev_ap   	@          w    A beginner_properties_left   	@          w    B beginner_properties_right   	@          w    b beginner_properties_prev_ap   	@          w    c beginner_properties_next_ap   	@          w    6 !advanced_properties_sort records   	@          w    7  advanced_properties_copy record   	@          w    8 "advanced_properties_export record   	@          w    ' advanced_properties_photo   	@          w     advanced_script_r_number   	@          w     beginner_script_title   	@          w     beginner_properties_title   	@          w     advanced_properties_title   	@          w    a beginner_properties_timer   	@          w    { beginner_script_timer   	@          w     advanced_script_timer   	@          w      | beginner_script_time_bar   	@          w     advanced_script_time_bar   	@          w       beginner_script_month_bar   	@          w     advanced_script_month_bar   	@          w       advanced_script_year_bar   	@          w       beginner_script_year_bar   	@          w     beginner_script_today   	@          w     beginner_script_tomorow   	@          w    ~ beginner_script_prev_ap   	@          w     advanced_script_prev_ap   	@          w       advanced_script_next_ap   	@          w       beginner_script_next_ap   	@          w    } beginner_script_month_year   	@          w     advanced_script_title   	@          w       advanced_script_notes   	@          w       beginner_properties_notes   	@          w    w beginner_script_calendar   	@          w     beginner_properties_file   	@          w     advanced_properties_file   	@          w     advanced_script_edit   	@          w       advanced_properties_navigation   	@          w     advanced_script_navigation   	@          w       beginner_script_resize_boxes   	@          w       beginner_script_close_boxes   	@          w      
 advanced_script_tab   	@          w      S advanced_script_date   	@          w    U  advanced_properties_close_boxes   	@          w    V advanced_properties_calendar   	@          w    X !advanced_properties_days_of_week   	@          w    Y !beginner_properties_days_of_week   	@          w    W beginner_properties_calendar   	@          w    Z !beginner_properties_record_title   	@          w    ` advanced_properties_timer   	@          w    n advanced_properties_time_bar   	@          w    r advanced_properties_month_bar   	@          w    s advanced_properties_year_bar   	@          w    o beginner_properties_time_bar   	@          w    p beginner_properties_month_bar   	@          w    q beginner_properties_year_bar   	@          w    [ !advanced_properties_record_title   	@          w    \ advanced_properties_date   	@          w    ] beginner_properties_date   	@          w    ^ beginner_properties_month_year   	@          w    _ advanced_properties_month_year   	@          w     advanced_properties_tab   	@          w    	 beginner_script_tab   	@          w     beginner_properties_tab   	@          w      beginner_properties_org_pattern   	@          w     beginner_script_org_pattern   	@          w     advanced_script_resize_boxes   	@          w       advanced_script_close_boxes   	@          w      x beginner_script_date   	@          w    y beginner_script_days_of_week   	@          w    z beginner_script_record_title   	@          w     advanced_script_org_pattern   	@          w     advanced_script_month_year   	@          w     advanced_script_days_of_week   	@          w     advanced_script_record_title   	@          w     beginner_script_photo_label   	@          w      advanced_properties_org_pattern   	@          w     beginner_script_navigation   	@          w     beginner_properties_navigation   	@          w     beginner_script_edit   	@          w     advanced_script_file   	@          w       beginner_properties_edit   	@          w      advanced_properties_edit   	@          w     beginner_script_file   	@          w     beginner_script_notes   	@          w     main_group   i       w
     	h                  I         This field has a closeField handler.   The closeField message is sent whenever a field *has* been changed and is loosing the keyboard focus. 
       
      

      
     + 

     5 W   This script calls a handler (located in the stack script) which stores any changes made. A seperate custom property is used to store information specific to each day. 
       d
     d 
     s 3   Note that if the field has not been changed, the exitField message is sent instead.  This message is not intercepted by this field (if no changes have been made there is no need to store them). 
       1
     1 	
     :   w These buttons have a single script which has been placed in the group that they are in.  It determines which button has been clicked on using the target function, and then looks up data for that day, displays it, and hilites the button. 
       @
     @ 
     E M
      
      A
      
      
         The data for each record is stored in a custom property attached to the diary group.  For each day that there is a record, a set of custom properties are created which store information on that day.   
       (
     ( 
     7    	Example:    The script in the group receives the mouseUp message when you click, and knows which button you clicked on by querying the target. 
       %
     % 
     , O
     { 
        It then puts together a date from the day clicked on, using the month and year (visible in the fields below).  This is displayed in the "date" field.  The convert function is then used to convert the date to a number.  Try typing "the date" into the message box to see the date, then clear the line and type "convert the date to seconds; put it" for an example of the same date represended numerically.  (You can get the message box at any time by typing CNTRL-M.) 
       
      
     .   This number is then used to access the correct custom property that holds the list of records for that day.  The records are displayed using by using the put command to put the custom property into the fields. 
       /
     / 
     > \
      
      4   Saving records does the same process in reverse.  The current date and record number being viewed are used to create a custom properties of the correct name to store the information.   The popUp menu which appears when you click the right mouse button on a day is created from the custom property which stores the list of appointment titles for the day selected.  The popUp menu is a seperate stack, which is resized dependant on the number of records saved in the day selected.  The popUp command is used to load this stack as a menu, at the position the user clicked.  The resizing is done during preOpenStack (a message which is sent before the stack is drawn on the screen). 
       
      
     	 W
     ` 
     o 
    + 
    0 n
     
     C   This field has a closeField handler.   The closeField message is sent whenever a field *has* been changed and is loosing the keyboard focus. 
       
      

      
     + 

     5 W   ~The closeField script first checks that there is only one line.  If there is more than one line, the extra lines are deleted. 
       
      

      o   Then a handler (located in the stack script) is called.  This stores any changes made. A seperate custom property is used to store information specific to each day. 
       b
     b 
     q 3   Note that if the field has not been changed, the exitField message is sent instead.  This message is not intercepted by this field (if no changes have been made there is no need to store them). 
       1
     1 	
     :    |The field also contains returnInField and enterInField messages, which are used to stop the user from creating a new line.  
       
      

     % 
     * 
     6 E   uThis button has a menuPick hander.  This handler determines which item was chosen, and runs the appropriate command. 
       
      
      Z   The Save command saves this stack, and the Exit command closes this stack.  If this were a standalone application, the quit command would be called. 
       
      
      o
     w 
     {      This is a pulldown menu button.    The text property has been set to contain the names of the menu items.  These are displayed as a menu panel automatically by MetaCard when the button is clicked on. 
       
      
         !The text property is as follows:    4&Undo        --The & symbol places the accelerator. 
       '
     ' 
     (  /-                    --This creates a divider.  &Cut  C&opy  &Paste     This is a pulldown menu button.    The text property has been set to contain the names of the menu items.  These are displayed as a menu panel automatically by MetaCard when the button is clicked on. 
       
      
         !The text property is as follows:    4&Undo        --The & symbol places the accelerator. 
       '
     ' 
     (  /-                    --This creates a divider.  &Cut  C&opy  &Paste    This button has a menuPick hander.  The name of the command chosen is sent as a parameter to the handler.  A switch structure is used to choose the appropriate course of action. 
       
      
      S
     m 
     s >   The Save command saves this stack, and the Exit command closes this stack.  If this were a standalone application, the quit command would be called. 
       
      
      o
     w 
     {    uThis button has a menuPick hander.  This handler determines which item was chosen, and runs the appropriate command. 
       
      
      Z   VEach command (undo, cut, copy, paste) executes the MetaCard command of the same name. 
       
      
      
      
      
      
      
      
     $ 1    This is a pulldown menu button.    The text property has been set to contain the names of the menu items.  These are displayed as a menu panel automatically by MetaCard when the button is clicked on. 
       
      
         !The text property is as follows:    :&Diary             --The & symbol places the accelerator. 
       -
     - 
     .  
&Contacts  3-                        --This creates a divider.  C&alculator    v
This button has a menuPick hander.  This handler determines which item was chosen, and runs the appropriate command. 
       
      
      Z   Diary: uses the MetaCard click command to click at the loc of the Diary tab.  This is equivalent to clicking at this point with the mouse. 
       
      
      
     7 
     : P   "Contacts: does the same as Diary.    GCalculator: this opens a palette window which contains the Calculator. 
       
      
       &  1The patterned image is done by setting the backgroundPattern of the a square graphic object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
     
       This is a static object which does not have a script.  The only script to affect it is the resizeStack handler which scales it when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
      
      	   $This object does not have a script.    The Appointment number is placed into it by a script in the stack (displayrecord) which is called every time the day is changed.   This is a static object which does not have a script.  The only script to affect it is the resizeStack handler which scales it when the Window is resized.  See the information for the close and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
      
      	   These fields do not have a script.  Their contents is set by the scrollbars on the left, or by the script of the stack (whenever the month or year being displayed is changed).   This is a static object which does not have a script.  The only script to affect it is the resizeStack handler which scales it when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
      
      	  z $This object does not have a script.    The Appointment number is placed into it by a script in the stack which is called every time the day is changed.  Note that field was designed to display the total number of Appointments for this day, not in the entire Diary.   yThis is a static object which does not have a script.  The only script to affect it is the resizeStack handler which scales it when the Window is resized.  See the information for the close and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
      
      	  x 8This is a static object which does not have a script.      The date is placed into it by a script in the stack which is called whenever the day being displayed is changed.  The date itself is created using the MetaCard date function. 
       
      
      
   This is not a real object, and therefore doesn't have a script.  However, when its used, a closeStackRequest message, and then a closeStack message is sent to the current stack. 
       [
     [ 
     l 
      

      &  If this were a real application, the closeStackRequest message could be used to check if the user wanted to save changes before closing.  If the handler is exited rather than passed, stack closing will be aborted (this can be used to create a "Really Quit?" cancel dialog). 
       %
     % 
     6    This is not a real object, and therefore doesn't have a script.  However, when its used, a resizeStack message is sent to the current stack. 
       [
     [ 
     f &   }This message is intercepted and used to resize all the controls in the stack to the correct sizes, relative to the new size.    SThere are a number of approaches you can take to this kind of geometry management. 
       >
     > 
     Q   The approach taken here has been to attach a custom property to each control on the card, which stores its width as a percentage of the card's width; its height as a percentage of the card's height; and its location as percent of its position on the card across and down.    |When the stack is resized, the width, height, and loc of each object is set to the percentage values of the new stack size. 
       
      
     $ 
     & 
     , 
     2 
     5 F   It would be possible to simply resize each control to a percentage of the stack size without using custom properties, but this would quickly lead to rounding off errors as the stack was resized up and down to uneven sizes.    A handler (geosetup) is present in the script of the Organizer.  It was used to assign custom properties to each control, and it should be possible to copy it and the resizeStack handler into your own stacks.    yA more complex geometry manager could have resized the text in each field too, but this is not usually worth the effort.   This is a static object which does not have a script.  The only script to affect it is the resizeStack handler which scales it when the Window is resized.  See the information for the close and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
      
      	  1The patterned image is done by setting the backgroundPattern of the a square graphic object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
     
        This a tabbed button.    >The text property of this button contains Diary and Contacts. 
       
      
      5   eThe textfont has been set to a larger size and dark blue color to improve the tab labels appearance. 
       
      
      X  	 This button has a menuPick hander.  This handler shows the group coresponding to the item chosen, and hides the other group.  See the Groups lab for more information on groups. 
       
      
      !
     ; 
     @ 6
     v 
     { 
      
      $   This a tabbed button.    >The text property of this button contains Diary and Contacts. 
       
      
      5   eThe textfont has been set to a larger size and dark blue color to improve the tab labels appearance. 
       
      
      X  _ _These are normal fields.  They have been named "Month" and "Year" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       ^ ^These are normal fields. They have been named "Month" and "Year" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       ] OThis is a normal field.  It has been named "Date" for easy referal in scripts.    2The textSize has been set to a larger point size. 
       
      
      %   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        The toolTip property has been set to "Date of appointments currently being viewed".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        \ OThis is a normal field.  It has been named "Date" for easy referal in scripts.    2The textSize has been set to a larger point size. 
       
      
      %   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        TThe toolTip property has been set to "Date of appointments currently being viewed". 
       
      
      H  [ WThis is a normal field.  It has been named "Record_title" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        <The toolTip property has been set to "Appointment number".  
       
      
      0  qThis a scrollbar object.  It has been sized very small.  The thumbSize has been set to 0.  The startValue and endValue have been set to 1 and 2 respectively.  This means that the scrollbar position will always be either 1 or 2 depending on direction of travel. 
       
      	
      -
     = 	
     F 
     _ 

     i 
     n 
     v    The toolTip property has been set to "Change Year".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        pThis a scrollbar object.  It has been sized very small.  The thumbSize has been set to 0.  The startValue and endValue have been set to 1 and 2 respectively.  This means that the scrollbar position will always be either 1 or 2 depending on direction of travel. 
       
      	
      -
     = 	
     F 
     _ 

     i 
     n 
     v    The toolTip property has been set to "Change Month".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        oThis a scrollbar object.  It has been sized very small.  The thumbSize has been set to 0.  The startValue and endValue have been set to 1 and 2 respectively.  This means that the scrollbar position will always be either 1 or 2 depending on direction of travel. 
       
      	
      -
     = 	
     F 
     _ 

     i 
     n 
     v    The toolTip property has been set to "Change Time".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        sThis a scrollbar object.  It has been sized very small.  The thumbSize has been set to 0.  The startValue and endValue have been set to 1 and 2 respectively.  This means that the scrollbar position will always be either 1 or 2 depending on direction of travel. 
       
      	
      -
     = 	
     F 
     _ 

     i 
     n 
     v    4The toolTip property has been set to "Change Year". 
       
      
      (  rThis a scrollbar object.  It has been sized very small.  The thumbSize has been set to 0.  The startValue and endValue have been set to 1 and 2 respectively.  This means that the scrollbar position will always be either 1 or 2 depending on direction of travel. 
       
      	
      -
     = 	
     F 
     _ 

     i 
     n 
     v    5The toolTip property has been set to "Change Month". 
       
      
      )  nThis a scrollbar object.  It has been sized very small.  The thumbSize has been set to 0.  The startValue and endValue have been set to 1 and 2 respectively.  This means that the scrollbar position will always be either 1 or 2 depending on direction of travel. 
       
      	
      -
     = 	
     F 
     _ 

     i 
     n 
     v    4The toolTip property has been set to "Change Time". 
       
      
      (  ` PThis is a normal field.  It has been named "Timer" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        9The toolTip property has been set to "Appointment time". 
       
      
      ,  Z WThis is a normal field.  It has been named "Record_title" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        The toolTip property has been set to "Appointment number".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        W This panel is made up of a group of buttons.  They were created by duplicating a single button.  The hilitecolor of the buttons has been set to a turquoise color.  The gray buttons at the start and finish are disabled. 
       
      
       E
     e 
     p a
      
        Y This is a normal field.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       X This is a normal field.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       VPThis panel is made up of a group of buttons.  They were created by duplicating a single button.  The hilitecolor of the buttons has been set to a turquoise color.  An alternative would have been to set the hilitecolor of the group.  The buttons would then have inherited this property from the group (if it was not set on each button). 
       
      
       E
     e 
     p ^
      
      
      
      i   7The gray buttons at the start and finish are disabled. 
       -
     - 
     5   U kWhen the Organizer is running, this is not an object, but rather part of the window frame drawn by the OS.    Its appearance is affected by the mode that the stack is opened in; and by the decorations stack property.  Depending on these properties, close boxes may be present or absent. 
       "
     " 
     & 

     0 
     5 
     O 
     Z V   eIt is also possible to set a stacks style property - a feature included for SuperCard compatibility. 
       $
     $ 
     ) ;  S 8This is a static object which does not have a script.      The date is placed into it by a script in the stack (displayrecord) which is called whenever the day being displayed is changed.  The date itself is created using the MetaCard date function. 
       
      
      
  
 This button has a menuPick hander.  The name of the tab chosen is sent as a parameter to the handler, together with the name of the tab that was previously selected. 
       
      
         These two parameters are used to hide the previously showing group and show the new group.  See the Groups lab for more information on groups. 
       =
     = 
     B 
     T 
     Y 
     d 
     j $   This is not a real object, and therefore doesn't have a script.  However, when its used, a closeStackRequest message, and then a closeStack message is sent to the current stack. 
       [
     [ 
     l 
      

      &  If this were a real application, the closeStackRequest message could be used to check if the user wanted to save changes before closing.  If the handler is exited rather than passed, stack closing will be aborted (this can be used to create a "Really Quit?" cancel dialog). 
       %
     % 
     6    This is not a real object, and therefore doesn't have a script.  However, when its used, a resizeStack message is sent to the current stack. 
       [
     [ 
     f &   }This message is intercepted and used to resize all the controls in the stack to the correct sizes, relative to the new size.    This button has a menuPick hander.  The name of the command chosen is sent as a parameter to the handler.  A switch structure is used to choose the appropriate course of action. 
       
      
      S
     m 
     s >  fDiary: uses the MetaCard click command to click at the location of the Diary tab.  This is equivalent to clicking at this point with the mouse.  An alternative would have been to set the menuHistory property of the tab, and then send a menuPick message to the tab to execute the commands needed to switch to the Diary.  Generally click at is a better technique, particularly with buttons - as it will show them hiliting.  However, the alternative may be used when objects are layered over other objects or an object with multiple hotspots is moved (when clicking directly at the loc of the object cannot be used). 
       
      
      
     * 
     / 
      
      &
      
      V
    J 
    O 
    C 
    F    "Contacts: does the same as Diary.    GCalculator: this opens a palette window which contains the Calculator. 
       
      
       &    This is a pulldown menu button.    The text property has been set to contain the names of the menu items.  These are displayed as a menu panel automatically by MetaCard when the button is clicked on. 
       
      
         !The text property is as follows:    :&Diary             --The & symbol places the accelerator. 
       -
     - 
     .  
&Contacts  3-                        --This creates a divider.  C&alculator    This button has a menuPick hander.  The name of the command chosen is sent as a parameter to the handler.  A switch structure is used to choose the appropriate course of action. 
       
      
      S
     m 
     s >   VEach command (undo, cut, copy, paste) executes the MetaCard command of the same name. 
       
      
      
      
      
      
      
      
     $ 1    This is a pulldown menu button.    The text property has been set to contain the names of the menu items.  These are displayed as a menu panel automatically by MetaCard when the button is clicked on. 
       
      
         !The text property is as follows:    3&Save       --The & symbol places the accelerator. 
       &
     & 
     '  ,-                 --This creates a divider.  6&Exit          --The & symbol places the accelerator. 
       )
     ) 
     *     This is a pulldown menu button.    The text property has been set to contain the names of the menu items.  These are displayed as a menu panel automatically by MetaCard when the button is clicked on. 
       
      
         !The text property is as follows:    3&Save       --The & symbol places the accelerator. 
       &
     & 
     '  ,-                 --This creates a divider.  6&Exit          --The & symbol places the accelerator. 
       )
     ) 
     *    ZThis is a normal scrolling field.  It has been named "Notes" for easy referal in scripts.   The patterned image is done by setting the backPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       '
     ' 
     6 
      
         The toolTip property has been set to "Appointment notes".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
         This field has a closeField handler.   The closeField message is sent whenever a field *has* been changed and is loosing the keyboard focus. 
       
      

      
     + 

     5 W   This script calls a handler (located in the stack script) which stores any changes made. A custom property is used to store information specific to each day.  See the Calendar panel for more details on how this information is stored. 
       [
     [ 
     j    Note that if the field has not been changed, the exitField message is sent instead.  (This message is not intercepted by this field.) 
       1
     1 	
     : K   This field has a closeField handler.   The closeField message is sent whenever a field *has* been changed and is loosing the keyboard focus. 
       
      

      
     + 

     5 W   ~The closeField handler checks to see if there is more than 1 line of script.  If there is, it deletes all but the first line. 
       
      

      o   It then calls a handler (located in the stack script) which stores any changes made. A custom property is used to store information specific to each day.  See the Calendar panel for more details on how this information is stored. 
       W
     W 
     f    Note that if the field has not been changed, the exitField message is sent instead.  (This message is not intercepted by this field.) 
       1
     1 	
     : K  The field also contains returnInField and enterInField messages, which are used to stop the user from creating a new line.  Both these handlers contain a single beep command.  The new line is not inserted because the handlers don't inclue a pass statement. 
       
      

     % 
     * 
     6 
      
        } These fields do not have a script.  Their contents is set by the scrollbars on the left, or by the script of the stack (whenever the month or year being displayed is changed).    This button checks the text placed in the field containing the number of appointments (above) to determine if there is another record.    If there is, it sends a message to the stack to display that record.  See the Calendar group for more information on how records are stored and displayed.    This button checks the text placed in the field containing the number of appointments (above) to determine if there is another record.    If there is, it sends a message to the stack to display that record (displayrecord).  See the Calendar group for more information on how records are stored and displayed.    This button checks the text placed in the field containing the number of appointments (above) to determine if there is a previous record.    If there is, it sends a message to the stack to display that record (displayrecord).  See the Calendar group for more information on how records are stored and displayed.   ~ This button checks the text placed in the field containing the number of appointments (above) to determine if there is a previous record.    If there is, it sends a message to the stack to display that record.  See the Calendar group for more information on how records are stored and displayed.    This uses the MetaCard date function to determine tomorow's date.  It then sends a message to the stack/Calendar to change which day is being displayed. 
       
      
      }   The date function only returns todays date.  To get tomorrow's, this is converted to seconds using the convert command.  The number of seconds in a day is then added to this (60*60*24), and then the number is converted back to a date. 
       
      
      M
     U 
     \ 
     g 
     n |   This uses the MetaCard date function to determine today's date.  It then sends a message to the stack/Calendar to change which day is being displayed. 
       
      
      {   ]This scrollbar contains a scrollBarDrag handler.  This is sent whenever the bar is scrolled. 
       
      

     ' 5   This handler adds or subtracts to the values in the field on the right, dependant on the direction of scrolling.  It then sends a message to the stack to alter the record being viewed (and update the Calendar).    ]This scrollbar contains a scrollBarDrag handler.  This is sent whenever the bar is scrolled. 
       
      

     ' 5   This handler adds or subtracts to the values in the field on the right, dependant on the direction of scrolling.  It then sends a message to the stack to alter the record being viewed (and update the Calendar).    ]This scrollbar contains a scrollBarDrag handler.  This is sent whenever the bar is scrolled. 
       
      

     ' 5   This handler adds or subtracts to the values in the field on the right, dependant on the direction of scrolling.  It then sends a message to the stack to alter the record being viewed (and update the Calendar).   As a month is textual not numerical, it must be converted to a number, the calculation done, and the result converted back to text.  This is done by using a list of months, seperated by commas: "January,Febuary,Mar...".  The itemOffset function is used to determine the number of the current text: e.g. itemOffset("Febuary","January,Febuary") would be 2.  The same principale is used in reverse to convert a number back to a month.  Its a little simpler though: item 3 of  "January,Febuary,March" would be March. 
       
      

      
     
     .   Note that MetaCard supports the array as a faster alternative which is suited to large or more complex sets of data.  For example, a variable could be created which contained 12 elements, one for each month.  Thus months[3] would be March. 
       
      
     &   +This is typically faster and easier to maintain than using items (known as chunk expressions) above.  The difference is particularly marked when manipulating large volumes of data, or data that contains a wide range of symbols (e.g. commas) that would be hard to deliminate using chunk expressions.    ]This scrollbar contains a scrollBarDrag handler.  This is sent whenever the bar is scrolled. 
       
      

     ' 5   This handler adds or subtracts to the values in the field on the right, dependant on the direction of scrolling.  It then sends a message to the stack to alter the record being viewed (and update the Calendar).   As a month is textual not numerical, it must be converted to a number, the calculation done, and the result converted back to text.  This is done by using a list of months, seperated by commas: "January,Febuary,Mar...".  The itemOffset function is used to determine the number of the current text: e.g. itemOffset("Febuary","January,Febuary") would be 2.  The same principale is used in reverse to convert a number back to a month.  Its a little simpler though: item 3 of  "January,Febuary,March" would be March. 
       
      

      
     
     .   uNote that MetaCard supports the array as a faster alternative which is suited to large or more complex sets of data. 
       
      
     & N   ]This scrollbar contains a scrollBarDrag handler.  This is sent whenever the bar is scrolled. 
       
      

     ' 5   pThis handler adds or subtracts to the values in the field on the left, dependant on the direction of scrolling.   !The scrollbar refers to a variable which is updated by the field each time it is edited.  The variable stores which part of the time was edited last (either hours, minutes or AM/PM).  If this value is empty (i.e. the "timer" field has not been clicked on) it defaults to the AM/PM values.   | ]This scrollbar contains a scrollBarDrag handler.  This is sent whenever the bar is scrolled. 
       
      

     ' 5   pThis handler adds or subtracts to the values in the field on the left, dependant on the direction of scrolling.   !The scrollbar refers to a variable which is updated by the field each time it is editid.  The variable stores which part of the time was edited last (either hours, minutes or AM/PM).  If this value is empty (i.e. the "timer" field has not been clicked on) it defaults to the AM/PM values.   VThis field has a selectionChanged handler.  This message is sent whenever the mouse is used to change the current selection.  This handler places information about which part of the field has been selected into a variable.  This variable is used by the scrollbar on the right to determine which part of the date to alter when it is scrolled. 
       
      
     !4   ^An arrowkey handler also uses the send command to send this field a selectionChanged message. 
       
      
      
     " 
     & 
     D 
     T 	   This field also has a closeField handler.   The closeField message is sent whenever a field *has* been changed and is loosing the keyboard focus. 
       
      

       
     0 

     : W   The closeField script calls a handler (located in the stack script.  This stores any changes made. A seperate custom property is used to store information specific to each day.  See the Calendar group for more information on how Appointments are stored. 
       
      

      `
     n 
     }    Note that if the field has not been changed, the exitField message is sent instead.  This message is used by this field to record which character was last selected (for use by the scrollbar). 
       1
     1 	
     :    vThe field contains returnInField and enterInField messages, which are used to stop the user from creating a new line. 
       
      

       
     % 
     1 D   Finally, the field contains rawKeyDown and keyUp handlers to validate that the text entered is a valid date.  The rawKeyDown handler (sent before the key is entered into the field) stores the current contents of the field in a variable. 
       
      

     & 
     + 
     0 7
     g 
     k 
     r 

     | p   The keyUp handler then checks to see if the contents of the field (with the key that has just been entered) is a date.  If it is not, the field is reset to the variable that was stored by the rawKeyDown handler. 
       
      
     	 h
     q 
     u K
      

      	  {VThis field has a selectionChanged handler.  This message is sent whenever the mouse is used to change the current selection.  This handler places information about which part of the field has been selected into a variable.  This variable is used by the scrollbar on the right to determine which part of the date to alter when it is scrolled. 
       
      
     !4   ^An arrowkey handler also uses the send command to send this field a selectionChanged message. 
       
      
      
     " 
     & 
     D 
     T 	   This field also has a closeField handler.   The closeField message is sent whenever a field *has* been changed and is loosing the keyboard focus. 
       
      

       
     0 

     : W   The closeField script calls a handler (located in the stack script.  This stores any changes made. A seperate custom property is used to store information specific to each day. 
       
      

      `
     n 
     } 3   Note that if the field has not been changed, the exitField message is sent instead.  This message is used by this field to record which character was last selected (for use by the scrollbar), but does not save changes. 
       1
     1 	
     :    vThe field contains returnInField and enterInField messages, which are used to stop the user from creating a new line. 
       
      

       
     % 
     1 D  	Finally, the field contains rawKeyDown and keyUp handlers to validate that the text entered is a valid time (or date in MetaTalk terms).  The rawKeyDown handler (sent before the key is entered into the field) stores the current contents of the field in a variable. 
       
      

     & 
     + 
     0 @
     p 
     t 
      

      p   The keyUp handler then check to see if the contents of the field (with the key that has just been entered) is a date.  If it is not, the field is reset to the variable that was stored by the rawKeyDown handler. 
       
      
     	 g
     p 
     t K
      

      	  a OThis is a normal field.  It has been named "Time" for easy referal in scripts.   The patterned image is done by setting the backPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       '
     ' 
     6 
      
         The toolTip property has been set to "Appointment Time".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
         PThis is a normal field.  It has been named "Title" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        :The toolTip property has been set to "Appointment title". 
       
      
      -   PThis is a normal field.  It has been named "Title" for easy referal in scripts.   The patterned image is done by setting the backPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       '
     ' 
     6 
      
         The toolTip property has been set to "Appointment title".  This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        This is a static object which does not have a script.  The contents are set during the preOpenCard handler (in the stack script), which puts the card number and the total number of cards into it when navigation takes place.  To view the script of this stack, type ALT-CNTRL-S. 
       W
     W 
     b   ' ;This is a button, with its icon set to the imported image. 
       
      
         _All the button's properties have been turned off, e.g. showName, showBorder, traversalOn, etc. 
       7
     7 
     ? 
     A 

     K 
     M 
     X    Placing the image in a button means that it can be cropped to any size required, and the button scaled to any size (when the stack is resized).   8 This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       7 This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       6 This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       c This is a normal button.    8Its icon has been set to an imported image of an arrow. 
       
      
      /   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       b This is a normal button.    8Its icon has been set to an imported image of an arrow. 
       
      
      /   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       B This is a normal button.    8Its icon has been set to an imported image of an arrow. 
       
      
      /   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       A This is a normal button.    8Its icon has been set to an imported image of an arrow. 
       
      
      /   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       e This is a normal button.    Its icon has been set to an imported image of an arrow.  The button's threeD property is true, so this image is automatically offset by 1 pixel when the button is depressed. 
       
      
      >
     F 
     L a   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       d This is a normal button.    Its icon has been set to an imported image of an arrow.  The button's threeD property is true, so this image is automatically offset by 1 pixel when the button is depressed. 
       
      
      >
     F 
     L a   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       @ This is a normal button.    Its icon has been set to an imported image of an arrow.  The button's threeD property is true, so this image is automatically offset by 1 pixel when the button is depressed. 
       
      
      >
     F 
     L a   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       ? This is a normal button.    Its icon has been set to an imported image of an arrow.  The button's threeD property is true, so this image is automatically offset by 1 pixel when the button is depressed. 
       
      
      >
     F 
     L a   The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       5 This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       4 This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       - This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       , This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       m This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       l This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       k This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       j This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       i This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       v kWhen the Organizer is running, this is not an object, but rather part of the window frame drawn by the OS.    Its appearance is affected by the mode that the stack is opened in; by the decorations stack property; and by the resizable stack property.  Depending on these properties, resize boxes may be present or absent, enabled or disabled. 
       "
     " 
     & 

     0 
     5 
     K 
     V 
     r 	
     { l   eIt is also possible to set a stacks style property - a feature included for SuperCard compatibility. 
       $
     $ 
     ) ;  u kWhen the Organizer is running, this is not an object, but rather part of the window frame drawn by the OS.    Its appearance is affected by the mode that the stack is opened in; by the decorations stack property; and by the resizable stack property.  Depending on these properties, resize boxes may be present or absent, enabled or disabled. 
       "
     " 
     & 

     0 
     5 
     K 
     V 
     r 	
     { l  t kWhen the Organizer is running, this is not an object, but rather part of the window frame drawn by the OS.    Its appearance is affected by the mode that the stack is opened in; and by the decorations stack property.  Depending on these properties, close boxes may be present or absent. 
       "
     " 
     & 

     0 
     5 
     O 
     Z V         hNote that the dissection must be closed by using the right mouse button in the middle of the title bar.   h This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       g This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       f This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       + This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       R This button uses a custom function to place the text from all the Contacts fields into a variable.  The same function is used to collect the text from all the fields by the Copy Record button.    It then uses the ask file command to allow the user to create a file to copy the record to.  The open command is used to open the file, and the write command is used to write the fields to that file.  Finally, the close command is used to close the file. 
       
      
      M
     a 
     e +
      
      A
      
      #  QDThis button places the text of each Contacts field into a variable.  It then uses the ask file command to allow the user to create a file to copy the record to.  The open command is used to open the file, and the write command is used to write the fields to that file.  Finally, the close command is used to close the file. 
       V
     V 
     Y M
      
      +
      
      A
     
      #  PThis button places the text of each Contacts field into a variable, and then places that variable on the clipboard.  Because a variable cannot be directly transfered to the clipboard, it is first placed in a hidden field, which is then copied (a field can be copied).   O This button uses a custom function to place the text from all the Contacts fields into a variable.  This is then copied to the clipboard.  The same function is used to collect the text from all the fields by the Export Record button.    Because a variable cannot be directly transfered to the clipboard, it is first placed in a hidden field, which is then copied (a field can be copied).   N This button shows a group of fields on top of the existing Contacts fields.  The group containing these fields has a script which checks the target and uses the sort command to sort the cards by whichever one has been clicked on. 
       Q
     Q 
     V 7
      
      
      
      @  BIn addition, a script is inserted in front of the message path (using the insert script command).  This receives mouseUp messages before any other controls on the card.  It checks if the object clicked on was one of the fields in the sort group, and if it is not, hides the sort group with a beep - i.e. cancels the sort. 
       J
     J 
     P !
     q 
     x 
    $ 
    (   M This button shows a group of fields on top of the existing Contacts fields.  These fields have a script which uses the sort command to sort the cards by whichever one is chosen. 
       
      
      ^
     w 
     { 6  LTThis script brings up a Search window.  The Search window is a copy of the Find stack included with MetaCard.  It uses variants of the find command to do searches, and has been redesigned to be in keeping with the style of the Personal Organizer stack.  You are free to use and redesign any of the stacks that are included in the MetaCard. 
       
      
        KThis script brings up a Search window using the modeless command (to open the stack in that mode).  The Search window is a copy of the Find stack included with MetaCard.  It uses variants of the find command to do searches, and has been redesigned to be in keeping with the style of the Personal Organizer stack.  You are free to use and redesign any of the stacks that are included in the MetaCard. 
       0
     0 
     8 
      
        J This button checks that there is more than 1 card.  If there is, it uses the answer command to ask if you really want to delete this record.  If you choose yes, it deletes the current card. 
       M
     M 
     S &
     y 
      >   Note that it is simple to design your own dialog box to ask a question if you want more control over the design than the answer dialog offers.   2 This button checks for the existance of an image on this card.  If one is found, it uses the answer command to bring up a dialog box asking if you really want to delete it.  If the answer is yes, the image (and button used to display it) is deleted.   
       ]
     ] 
     c    Note that it is simple to design your own dialog box to ask a question if if you want more control over the design than the answer dialog offers.   > This is a normal button.   *The patterned background was achieved by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       4
     4 
     G 
    	 
       = This is a normal button.   *The patterned background was achieved by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       4
     4 
     G 
    	 
       < This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       ; This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       : This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       9 This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       I This button checks that there is more than 1 card.  If there is, it uses the answer command to ask if you really want to delete this record.  If you choose yes, it deletes the current card. 
       M
     M 
     S &
     y 
      >   Note that it is simple to design your own dialog box to ask a question if you want more control over the design than the answer dialog offers.   H  This script creates a new card. 
       
      
        kMetaCard automatically places all the existing controls from this card onto the new card.  This is because all the controls are in groups (backgrounds).  The text in the Contact entries is different on each card because those fields have their sharedText properties set to false.  The image on each record is not part of a group, and so is specific to each card. 
       
      
      k
      

      l   eAll the components of the Diary group are placed onto the new card too, as they are also in a group. 
       ^
     ^ 
     c   The sharedText of the fields which display Diary appointments is true, so changing to from Contacts to Diary goes to the same set of appointments from any card in the Contacts section.  See the Calendar group in the Diary section for more information about how appointments are stored. 
       
      

       3 This is a normal button.    XThe foregroundColor has been set to a dark red, and the textStyle has been set to bold. 
       
      
      %
     8 	
     A    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       1 This button checks for the existance of an image on this card.  If one is found, it uses the answer command to bring up a dialog box asking if you really want to delete it.  If the answer is yes, the image is deleted.   
       ]
     ] 
     c x   Note that it is simple to design your own dialog box to ask a question if you want more control over the design than the answer dialog offers.   / bThis object uses the MetaCard answer file command to allow the user to select an image to import. 
       
      
     $ =   jProvided that a file is selected, the script then goes on to replace the existing image with the new one.    Firstly, the screen is locked using the lockscreen command.  This prevents the user from seeing images being deleted or imported whilst the changes are taking place. 
       (
     ( 

     2 s   NIf the exist, the old image and buttons are deleted using the delete command. 
       >
     > 
     D 	   :The import command is used import the file user selected. 
       
      
     
 
      
     !   rThe imported image is then hidden, and a new button is created to contain the image.  The properties of the templateButton are set to create a button of the correct size and with the correct icon.  The new button command then creates the button - which will have all the correct attributes set.  This is much faster than creating a new button and then resizing it, etc. 
       

     
 
      
     ) 
     , @
     l 
     z P
      
         SFinally, the screen is unlocked, which causes it to be redrawn with the new image.   . bThis object uses the MetaCard answer file command to allow the user to select an image to import. 
       
      
     $ =   jProvided that a file is selected, the script then goes on to replace the existing image with the new one.    Firstly, the screen is locked using the lockscreen command.  This prevents the user from seeing images being deleted or imported whilst the changes are taking place. 
       (
     ( 

     2 s   3The old image is deleted using the delete command. 
       #
     # 
     ) 	   :The import command is used import the file user selected. 
       
      
     
 
      
     !    aThe imported image is then hidden, and the icon of the button above is set to contain the image. 
       

     
 
      
     + 
     / 
     7 
     = #   SFinally, the screen is unlocked, which causes it to be redrawn with the new image.   * This is a normal button.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       ) WThis button does not have a script.  Its icon is set and deleted by the buttons below. 
       )
     ) 
     - )  ( WThis button does not have a script.  Its icon is set and deleted by the buttons below. 
       )
     ) 
     - )  & ;This is a button, with its icon set to the imported image. 
       
      
         _All the button's properties have been turned off, e.g. showName, showBorder, traversalOn, etc. 
       7
     7 
     ? 
     A 

     K 
     M 
     X    Placing the image in a button means that it can be cropped to any size required, and the button scaled to any size (when the stack is resized).   % cNone of these fields have scripts.  All text editing is done automatically by the MetaCard engine.    The only script to affect them is the resizeStack handler which scales all the card when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       &
     & 
     1 
      
      	  $None of these fields have scripts.  All text editing is done automatically by the MetaCard engine.  It might be desirable to add keyDown handlers in the Telephone and Fax fields to validate that a number was being entered, but this has not been done in this example.    The only script to affect them is the resizeStack handler which scales all the card when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       &
     & 
     1 
      
      	  This is a static object which does not have a script.  The only script to affect it is the resizeStack handler which scales it when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
      
      	    These are normal fields.    /The foregroundColor has been set to dark blue. 
       
      
         The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       # These are normal fields.  To allow editing of text, they have the following properties set differently from the other fields on this screen.    BLocktext - this is false, to allow text to be edited by the user. 
       
      9   uTraversalOn - this is true, to allow text the field to be focused (i.e. the insertion point moved into) by the user. 
       
      i   Sharedtext - this is false, which means that text entered on this card will not be the same as text entered into the field on another card.  This allows individual records to be stored on each card. 
       

     
    The patterned image is done by setting the backgroundPattern of each field to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       " These are normal fields.  To allow editing of text, they have the following properties set differently from the other fields on this screen.    BLocktext - this is false, to allow text to be edited by the user. 
       
      9   uTraversalOn - this is true, to allow text the field to be focused (i.e. the insertion point moved into) by the user. 
       
      i  %Sharedtext - this is false, which means that text entered on this card will not be the same as text entered into the field on another card.  This allows individual records to be stored on each card.  All the other fields have this set to true, and so appear as labels - the same on each card. 
       

     
   The patterned image is done by setting the backgroundPattern of each field to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
       !There are static objects which do not have scripts.  The only script to affect them is the resizeStack handler which scales them to be scaled when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
     
    
 	  There are static objects which do not have scripts.  The only script to affect them is the resizeStack handler which scales them to be scaled when the Window is resized.  See the information for the close box  and resize boxes for more information about the resizeStack handler. 
       [
     [ 
     f 
     
    
 	   These are normal fields.    /The foregroundColor has been set to dark blue. 
       
      
         The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        This is a normal field.    /The foregroundColor has been set to dark blue. 
       
      
         The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        This is a normal field.    /The foregroundColor has been set to dark blue. 
       
      
         The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        This is a static object which does not have a script.  The only script to affect it is the preOpenCard handler (in the stack script), which puts the card number and the total number of cards into it when navigation takes place. 
       [
     [ 
     f }   SThis is a normal field.  It has been named "r_number" for easy referal in scripts.    oThe textfont of the field has been set to a larger point size.  The foregroundColor has been set to dark blue. 
       
      
      8
     D 
     S    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        6The toolTip property has been set to "Record number". 
       
      
      )   SThis is a normal field.  It has been named "r_number" for easy referal in scripts.    oThe textfont of the field has been set to a larger point size.  The foreGroundColor has been set to dark blue. 
       
      
      8
     D 
     S    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        The toolTip property has been set to "Record number".    This causes MetaCard to display a yellow box containing this information when the mouse pauses over the object. 
       
      
        G IThis script does a visual effect (push left) then goes to the next card. 
       
      
      /  F NThis script does a visual effect (push right) then goes to the previous card. 
       
      
      4  E IThis script does a visual effect (push left) then goes to the next card. 
       
      
      /  D NThis script does a visual effect (push right) then goes to the previous card. 
       
      
      4  C  This script creates a new card. 
       
      
        kMetaCard automatically places all the existing controls from this card onto the new card.  This is because all the controls are in groups (backgrounds).  The text in the Contact entries is different on each card because those fields have their sharedText properties set to false.  The image on each record is not part of a group, and so is specific to each card. 
       
      
      k
      

      l   eAll the components of the Diary group are placed onto the new card too, as they are also in a group. 
       ^
     ^ 
     c    These buttons all use a single script that has been placed in the group containing them.  It determines which button has been clicked on using the target function, and then looks up data for that day, displays it, and hilites the button. 
       B
     B 
     G L
      
      A
      
      
         The data for each record is stored in a custom property attached to the diary group.  For each day that there is a record, a set of custom properties are created which store information on that day.   
       (
     ( 
     7    	Example:    The script in the group receives the mouseUp message when you click, and knows which button you clicked on by querying the target. 
       %
     % 
     , O
     { 
        It then puts together a date from the day clicked on, using the month and year (visible in the fields below).  This is displayed in the "date" field.  The convert function is then used to convert the date to seconds.  Try typing "the date" into the message box to see the date, then clear the line and type "convert the date to seconds; put it" for an example of the same date represended like this.  (You can get the message box at any time by typing CNTRL-M.) 
       
      
      .
      
         This number is then used to access the correct custom property that holds the list of records for that day.  The records are displayed using by using the put command to put the custom property into the fields. 
       /
     / 
     > \
      
      4  <Each day has a record called "titles"&day, where day is the date for that day represented as seconds.  This contains a list of the titles for the records stored on that day, one per line.  This is used to access each record, and to display the popUp menu when the Calendar is clicked on with the right mouse button. 
       <
     < 
     @    Similarly, each day has a record called "times"&day.  This contains a list of the times for each appointment.  This record is sorted so that Appointments appear in chronological order.   +In order that each title is linked to the correct line, an ID is attached to each record.  It is the first item on each line, and is stripped before the record is displayed.  This allows the times to be sorted (by item 2, the actual data), and item 1 (the ID) will still refer to the correct title.    Finally, the "notes" field is stored in a seperate custom property, one for each Appointment on each day.  The custom property name is built from "notes"&day&record_id.  Record_id is a variable which stores the record ID (as described above).    Here are the custom properties and contents set for Jun 4th, 1997 - the date the Calendar has been set to open at (because that date containts a sample appointment).      gtitles865378800  --the record holding the titles (remember the number is Jun 4th converted to seconds) 
       
      W   $              1,Dentist for Floppet 
       
         6times865378800 --the record holding the list of times 
       
      '                 1,11:00 AM 
       
      
   +notes8653788001 --notes, day and record_id 
       
         T              must remember to take Floppet to the dentist for that root canal work 
       
      E     bIf you want, you can try viewing these yourself.  Select the Personal Organizer stack, then type:    2palette "metacard menu bar"; select group "diary" 
       1   Then choose "Object properties" from the edit menu, click the "Extras" tab on the right, and click "Custom properties" to view them.      mSaving records uses the current date and record number being viewed to create the correct custom properties.   The popUp menu which appears when you click the right mouse button on a day is created from the titles list of the day selected.  The popUp menu is a seperate stack, which is resized dependant on the number of records saved in the day selected.  The popUp command is used to load this stack as a menu, at the position the user clicked.  The resizing is done during preOpenStack (a message which is sent before the stack is drawn on the screen). 
       
      
     	 
      
      n
    m 
    y C   ~This script creates deletes the current appointment.  See the Calendar group for more details on how appointments are stored.    ~This script creates deletes the current appointment.  See the Calendar group for more details on how appointments are stored.    pThis script creates a new appointment.  See the Calendar group for more details on how appointments are stored.    pThis script creates a new appointment.  See the Calendar group for more details on how appointments are stored.    ZThis is a normal scrolling field.  It has been named "Notes" for easy referal in scripts.    The patterned image is done by setting the backgroundPattern of the object to the ID of an imported image (consisting of one square of the pattern).  Note that this property must be set from the message box - it is not available in the palettes.  See the Images lab for more information. 
       *
     * 
     = 
      
        :The toolTip property has been set to "Appointment notes". 
       
      
      -           	`        G   OK Ep +on mouseUp
  close this stack
end mouseUp
       >U i          	     
   cd_name  h  
       	Q           card "beginner_script_notes"   w  card "beginner_script_calendar"    card "beginner_script_title"    card "beginner_script_file"      card "advanced_properties_edit"     card "beginner_properties_edit"    card "advanced_script_file"    card "beginner_script_edit"    &card "beginner_properties_navigation"    "card "beginner_script_navigation"    'card "advanced_properties_org_pattern"    #card "beginner_script_photo_label"    $card "advanced_script_record_title"    $card "advanced_script_days_of_week"    "card "advanced_script_month_year"    #card "advanced_script_org_pattern"   z $card "beginner_script_record_title"   y $card "beginner_script_days_of_week"   x card "beginner_script_date"    #card "advanced_script_close_boxes"    $card "advanced_script_resize_boxes"    #card "beginner_script_org_pattern"    'card "beginner_properties_org_pattern"    card "beginner_properties_tab"   	 card "beginner_script_tab"    card "advanced_properties_tab"   _ &card "advanced_properties_month_year"   ^ &card "beginner_properties_month_year"   ]  card "beginner_properties_date"   \  card "advanced_properties_date"   [ (card "advanced_properties_record_title"   q $card "beginner_properties_year_bar"   p %card "beginner_properties_month_bar"   o $card "beginner_properties_time_bar"   s $card "advanced_properties_year_bar"   r %card "advanced_properties_month_bar"   n $card "advanced_properties_time_bar"   ` !card "advanced_properties_timer"   Z (card "beginner_properties_record_title"   W $card "beginner_properties_calendar"   Y (card "beginner_properties_days_of_week"   X (card "advanced_properties_days_of_week"   V $card "advanced_properties_calendar"   U 'card "advanced_properties_close_boxes"   S card "advanced_script_date"   
 card "advanced_script_tab"    #card "beginner_script_close_boxes"    $card "beginner_script_resize_boxes"    "card "advanced_script_navigation"    &card "advanced_properties_navigation"    card "advanced_script_edit"     card "advanced_properties_file"     card "beginner_properties_file"    !card "beginner_properties_notes"    card "advanced_script_notes"    card "advanced_script_title"   } "card "beginner_script_month_year"    card "beginner_script_next_ap"    card "advanced_script_next_ap"    card "advanced_script_prev_ap"   ~ card "beginner_script_prev_ap"    card "beginner_script_tomorow"    card "beginner_script_today"     card "beginner_script_year_bar"     card "advanced_script_year_bar"    !card "advanced_script_month_bar"    !card "beginner_script_month_bar"     card "advanced_script_time_bar"   |  card "beginner_script_time_bar"    card "advanced_script_timer"   { card "beginner_script_timer"   a !card "beginner_properties_timer"    !card "advanced_properties_title"    !card "beginner_properties_title"     card "advanced_script_r_number"   ' !card "advanced_properties_photo"   8 )card "advanced_properties_export record"   7 'card "advanced_properties_copy record"   6 (card "advanced_properties_sort records"   c #card "beginner_properties_next_ap"   b #card "beginner_properties_prev_ap"   B !card "beginner_properties_right"   A  card "beginner_properties_left"   e #card "advanced_properties_prev_ap"   d #card "advanced_properties_next_ap"   @ !card "advanced_properties_right"   ?  card "advanced_properties_left"   5 *card "advanced_properties_search records"   4 )card "advanced_properties_delete record"   - !card "advanced_properties_clear"   , !card "beginner_properties_clear"   m .card "advanced_properties_delete appointment"   l +card "advanced_properties_New Appointment"   k #card "advanced_properties_tomorow"   j !card "advanced_properties_today"   i .card "beginner_properties_delete appointment"   v (card "advanced_properties_resize_boxes"   u (card "beginner_properties_resize_boxes"   t 'card "beginner_properties_close_boxes"   h +card "beginner_properties_New Appointment"   g #card "beginner_properties_tomorow"   f !card "beginner_properties_today"   + "card "beginner_properties_import"   R %card "advanced_script_export record"   Q %card "beginner_script_export record"   P #card "beginner_script_copy record"   O #card "advanced_script_copy record"   N $card "advanced_script_sort records"   M $card "beginner_script_sort records"   L &card "beginner_script_search records"   K &card "advanced_script_search records"   J %card "advanced_script_delete record"   2 card "advanced_script_clear"   > )card "beginner_properties_export record"   = 'card "beginner_properties_copy record"   < (card "beginner_properties_sort records"   ; *card "beginner_properties_search records"   : )card "beginner_properties_delete record"   9 &card "beginner_properties_new record"   I %card "beginner_script_delete record"   H "card "advanced_script_new record"   3 &card "advanced_properties_new record"   1 card "beginner_script_clear"   / card "advanced_script_import"   . card "beginner_script_import"   * "card "advanced_properties_import"   ) card "advanced_script_photo"   ( card "beginner_script_photo"   & !card "beginner_properties_photo"   % %card "beginner_script_record_fields"   $ %card "advanced_script_record_fields"    #card "advanced_script_photo_label"     )card "beginner_properties_record_labels"   # )card "advanced_properties_record_fields"   " )card "beginner_properties_record_fields"   ! %card "beginner_script_record_labels"    %card "advanced_script_record_labels"    )card "advanced_properties_record_labels"    'card "advanced_properties_photo_label"    'card "beginner_properties_photo_label"     card "beginner_script_r_number"    $card "advanced_properties_r_number"    $card "beginner_properties_r_number"   G card "advanced_script_right"   F card "advanced_script_left"   E card "beginner_script_right"   D card "beginner_script_left"   C "card "beginner_script_new record"     card "advanced_script_calendar"    *card "advanced_script_delete appointment"    *card "beginner_script_delete appointment"    'card "advanced_script_New Appointment"    'card "beginner_script_New Appointment"    !card "advanced_properties_notes"         New Button Ep %on mouseUp
  go next cd
end mouseUp
       O           	        New Button Ep %on mouseUp
  go prev cd
end mouseUp
       M           	        
script_group   i        Q  %     View actual script Ep on mouseUp
  global current_target
  do "edit script of " & current_target & " of stack " & quote & "personal organiser" & quote
end mouseUp
        U           	        View actual script Ep Don mouseUp
  edit script of stack "personal organiser"
end mouseUp
        U           	        View actual script Ep Don mouseUp
  edit script of stack "personal organiser"
end mouseUp
        U           	      