#!/bin/sh
# MetaCard 2.4 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  + MetaCard Menu Bar 
on mouseUp
end mouseUp

on mouseDoubleUp
  send "mouseUp" to the target
end mouseDoubleUp

on changeTool
  get word 1 of the tool
  if it is "graphic"
  then get the style of the templateGraphic
  set the hilitedButton of group "icons" to \
      itemOffset(it, "browse,pointer,button,field,scrollbar,image,player,polygon,curve,rectangle,oval,roundrect,regular")
end changeTool

on resizeStack
end resizeStack

on preOpenStack
  if the mode of the owner of the target > 5 and the lookAndFeel \
      is "Appearance Manager" or the lookAndFeel is "Macintosh" then
    set the threeD of the target to false
    set the borderWidth of the target to 1
  else
    set the threeD of the target to true
    set the borderWidth of the target to 2
  end if
end preOpenStack

on openStack
end openStack

on closeStack
end closeStack

on preOpenBackground
end preOpenBackground

on openBackground
end openBackground

on closeBackground
end closeBackground

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard

on downloadNgo which
  send "downloadNgo" && quote & which & quote to stack "Download Stack"
end downloadNgo

on help
  put word -4 of the long name of the target into cname
  delete first char of cname
  delete last char of cname
  if word 1 to 2 of cname is "Script Editor"
  then put word 1 to 2 of cname into cname
  if there is a card cname of stack "Dialog Box Help"
  then go to card cname of stack "Dialog Box Help"
  else modeless "Help Index"
end help

on escapeKey
  if there is a button "Cancel"
  then click at the loc of button "Cancel"
  else pass escapeKey
end escapeKey

function doClick
  switch
  case word 1 of the name of the target is "button" and the style of the target is not "menu" and not the autoArm of the target
    click at the loc of the target
    break
  case the defaultButton of this card is not empty
    click at the loc of the defaultButton of this card
    break
  default
    return false
  end switch
  return true
end doClick

on returnKey
  if not doClick() then pass returnKey
end returnKey

on returnInField
  if not doClick() then pass returnInField
end returnInField

on enterKey
  if not doClick() then pass enterKey
end enterKey

on enterInField
  if not doClick() and there is a field "OK"
  then click at the loc of button "OK"
  else pass enterInField
end enterInField

function additem oitem, nitem
  if oitem is empty
  then return nitem
  else return oitem & comma & nitem
end additem

function MCfixpath shortname
  local sname
  put tolower(shortname) & ".mc" into sname
  repeat with c = 1 to the length of sname
    if char c of sname is in " :?*<>/\()[]{}|'`" & quote & tab
    then put "_" into char c of sname
  end repeat
  return sname
end MCfixpath
      
  N   
mcversion  2.5             U 
Helvetica   U 
Helvetica   U 
helvetica   U 
helvetica  Help Directory,mchelp.mc
Dialog Box Help,mchelp.mc
MetaCard Tutorials,mchelp.mc
MetaTalk Reference,mchelp.mc
MetaTalk Examples,mchelp.mc
Concepts & Techniques,mchelp.mc
Help Index,mchelp.mc
MetaCard FAQ,mchelp.mc
Support,mchelp.mc
MetaCard Version,mchelp.mc
Licensing MetaCard,mchelp.mc
    Menu Bar card   	Pon help
  go to card "Menu Bar" of stack "Dialog Box Help" as modeless
end help

on resizeStack
  set the width of button "menuButton" to the width of me - 8
  set the left of button "menuButton" to 4
  set the right of button "Help" to the width of me - 8
end resizeStack

on preOpenStack
  local newx, newy
  put max(the top of the topStack - the height of this stack - 28, 2) into newy
  put the left of the topStack into newx
  set the topLeft of this stack to newx, newy
  insert script of button "menuButton" into front
  insert script of button "newobj" into back
  if the defaultMenubar is empty
  then set the defaultMenubar to "MetaCard Menu Bar"
  if the platform is "MacOS" and char 1 of the systemVersion is "1" then
    set the textFont of this stack to "Lucida Grande"
    set the textSize of this stack to 13
  end if
end preOpenStack

on closeStack
  if the platform is not "MacOS" then
    remove script of button "menuButton" from front
    remove script of button "newobj" from back
  end if
end closeStack
            N  %       Icons   Eon preOpenCard
  changeTool
end preOpenCard

on mouseUp
  local ostacks, nstacks
  put the openStacks into ostacks
  if "My Icons" is not in ostacks and "My Patterns" is not in ostacks then
    put the number of lines in ostacks into nstacks
    repeat with i = 1 to nstacks
      if the mode of stack (line i of ostacks) is 5 then
        beep 1
        changeTool
        exit to MetaCard
      end if
    end repeat
  end if
  if word 1 of the name of the target is "button" then
    if the short name of the target is in "pointer browse button field scrollbar image player"
    then choose (the short name of the target) tool
    else
      set the style of the templateGraphic to the short name of the target
      set the points of the templateGraphic to empty
      set the markerPoints of the templateGraphic to empty
      if the tool is "graphic tool"
      then send "newTool" to stack "Tools"
      else choose graphic tool
    end if
    if the tool is "browse tool" and the editBkgnd of the topStack
    then set the editBackground of the topStack to false
  end if
end mouseUp
          $ ,   browse Bton mouseUp which
  local i, ename
  if which is 3 then
    set the emacsKeyBindings to false
    send "doinit" to group "metacard menu bar"
    set the emacsKeyBindings to true
    put empty into menu "Text"
    put "&Group/G" into menuItem 9 of menu "Edit"
    set the customPropertySets of stack "Home" to empty
    set the customKeys of stack "Home" to empty
    set the mcvendor of stack "Home" to the "MetaCard Corporation"
    set the mcversion of stack "MetaCard Menu Bar" to the version
    set the mcversion of stack "Help Directory" to the version
    put empty into field "File Name" of card 2 of stack "Importer"
    put empty into field "Find" of stack "Find"
    put empty into field "Find Text" of stack "Script Find"
    put empty into field "Replace Text" of stack "Script Find"
    put empty into field "Name" of stack "Order Forms"
    put empty into field "Organization" of stack "Order Forms"
    put empty into field "Licenses" of card 1 of stack "Order Forms"
    put empty into field "Key" of card 1 of stack "Order Forms"
    set the height of stack "Message Box" to the minHeight of stack "Message Box"
    set the customPropertySets of stack "Script Editor" to empty
    set the customPropertySets of card 1 of stack "Standalone Builder" to empty
    repeat with i = 1 to 10
      put "Script Editor" && i into ename
      if there is a stack ename
      then delete stack ename
    end repeat
    set the debuggingScript of stack "Script Editor" to empty
    choose browse tool
    go "Properties"
    repeat with i = 1 to the number of cards in this stack - 1
      go to card i
      set the menuhistory of button 1 to 1
    end repeat
    close stack "Properties"
  else pass mouseUp
end mouseUp
        ( $ $ Browse tool               .            	     pointer Bd      ( ( $ $ Select controls               -            	     	 button Bd      L ( $ $ Button tool               /            	     
 field Bd      p ( $ $ Field tool               0            	      
scrollbar Bd       ( $ $ Scrollbar tool               1            	      image Bd       ( $ $ Image tool               _            	     ) player Bd       ( $ $ Player tool                           	     
 polygon Bd       ( $ $ Graphic tool (polygon)               =            	      curve Bd     $ ( $ $ Graphic tool (curve)               :            	      
rectangle Bd     H ( $ $ Graphic tool (rectangle)               <            	      oval Bd     l ( $ $ Graphic tool (oval)               9            	      
roundrect Bd      ( $ $ Graphic tool (round rect)               >            	      regular Bd      ( $ $ Graphic tool (regular polygon)               ;            	      newobj Ep0on errorDialog which
  set the executionerror of card 1 of stack "Execution Error" to which
  modeless "Execution Error"
  send "refresh" to card 1 of stack "Execution Error"
end errorDialog

on newButton
  choose pointer tool
  send "newTool" to stack "MetaCard Menu Bar"
end newButton

on newField
  choose pointer tool
  send "newTool" to stack "MetaCard Menu Bar"
end newField

on newScrollbar
  choose pointer tool
  send "newTool" to stack "MetaCard Menu Bar"
end newScrollbar

on newImage
  choose pointer tool
  send "newTool" to stack "MetaCard Menu Bar"
end newImage

on newGraphic
  choose pointer tool
  send "newTool" to stack "MetaCard Menu Bar"
end newGraphic

on newPlayer
  choose pointer tool
  send "newTool" to stack "MetaCard Menu Bar"
end newPlayer

on reloadStack sname, fname
  if the filename of stack sname is fname
  then toplevel sname
  else
    set the reloadname of stack "Reload Stack" to sname
    set the reloadfile of stack "Reload Stack" to fname
    modal "Reload Stack"
  end if
end reloadStack

on newTool
  -- backstop
end newTool
       2  &          	       % MetaCard Menu Bar   on menuPick which
  if which is "About MetaCard..."
  then modal "About MetaCard"
end menuPick

on resizeStack
  set the width of me to the width of stack "MetaCard Menu Bar"
  set the width of button "menuButton" of me to the width of me - 6
  set the left of button "menuButton" of me to 4
  set the right of button "Help" of me to the width of me - 6
end resizeStack

local fnames, fsizes, fstyles, fcolors, oldfont, oldsize, oldstyle, oldshift
local fontnum, sizenum, stylenum, colornum, subnum

on doinit
  if the emacsKeyBindings then
    put "&Close" into menuItem 7 of menu "File"
    put "&Paste/Y" into menuItem 5 of menu "Edit"
    put "Select A&ll" into menuItem 7 of menu "Edit"
    put "&Find..." into menuItem 1 of menu "Tools"
  else
    put "&Close/W" into menuItem 7 of menu "File"
    put "&Paste/V" into menuItem 5 of menu "Edit"
    put "Select A&ll/A" into menuItem 7 of menu "Edit"
    put "&Find.../F" into menuItem 1 of menu "Tools"
  end if
  put the fontNames into fnames
  sort lines of fnames
  put "none" & cr & "-" & cr before fnames
  local newtext
  put "Font" & cr into newtext
  put 1 into fontnum
  repeat for each line l in fnames
    if l is "-"
    then put tab & l & cr after newtext
    else put "!u" & tab & l & cr after newtext
  end repeat
  put "Size" & cr after newtext
  put the number of lines in newtext into sizenum
  put format("none\n-\n8\n10\n11\n12\n14\n17\n18\n20\n24\n25\n30\n-\nother...") into fsizes
  repeat for each line l in fsizes
    if l is "-"
    then put tab & l & cr after newtext
    else put "!u" & tab & l & cr after newtext
  end repeat
  put "Style" & cr after newtext
  put the number of lines in newtext into stylenum
  put format("Plain\n-\nBold\nItalic\nUnderline\nStrikeout\n3D Box\nBox\n-\nLink") into fstyles
  repeat for each line l in fstyles
    if l is "-"
    then put tab & l & cr after newtext
    else put "!n" & tab & l & cr after newtext
  end repeat
  put "Color" & cr after newtext
  put the number of lines in newtext into colornum
  put format("Black\nWhite\nRed\nGreen\nBlue\nYellow\n-\nPen Color\n-\nClear") into fcolors
  repeat for each line l in fcolors
    if l is "-"
    then put tab & l & cr after newtext
    else put "!u" & tab & l & cr after newtext
  end repeat
  put the number of lines in newtext + 1 into subnum
  put "!uSubscript" & cr & "!uSuperscript" after newtext
  put newtext into button "Text"
end doinit

on mouseDown
  if the short name of the target is "Help"
  then pass mouseDown
  local olddefault
  put the defaultmenubar into olddefault
  set the defaultmenubar to "MetaCard Menu Bar"
  lock menus
  if fnames is empty or button "Text" is empty then doinit
  setupedit
  setuptext
  set the defaultStack to value(the last word of olddefault)
  set the defaultmenubar to value(word 2 of olddefault)
  unlock menus
  pass mouseDown
end mouseDown

on setupedit
  local otype
  put word 1 to 2 of the selobjs into otype
  if word 1 of otype is "card" and word 2 of otype is among the items of "field,button,image,player,scrollbar,graphic"
  then delete word 1 of otype
  else delete word 2 of otype
  if otype is empty or otype is "card" or otype is "stack"
  then disable menuItem 9 of menu "Edit"
  else
    enable menuItem 9 of menu "Edit"
    if word 1 of the selobjs is "group" and the number of lines in (the selobjs) is 1
    then put "Un&group/G" into menuItem 9 of menu "Edit"
    else put "&Group/G" into menuItem 9 of menu "Edit"
  end if
  if the editBackground of the topStack
  then put "Stop Editing &BG/T" into menuItem 10 of menu "Edit"
  else put "&Backgrounds.../T" into menuItem 10 of menu "Edit"
end setupedit

on setuptext
  local newstate, i
  put the selectedChunk is empty and the selectedObject is empty into newstate
  set the wholeMatches to true
  repeat for each item i in fontnum,sizenum,stylenum,colornum
    if newstate
    then disable menuItem i of menu "Text"
    else enable menuItem i of menu "Text"
  end repeat
  if the selectedChunk is empty then
    unhilite menuItem subnum of menu "Text"
    unhilite menuItem subnum + 1 of menu "Text"
    disable menuItem subnum of menu "Text"
    disable menuItem subnum + 1 of menu "Text"
  else
    enable menuItem subnum of menu "Text"
    enable menuItem subnum + 1 of menu "Text"
  end if
  if newstate
  then exit setuptext
  local fname, fsize, fstyle, tshift
  if the selectedChunk is empty then
    put the textFont of the selectedObject into fname
    put the textSize of the selectedObject into fsize
    put the textStyle of the selectedObject into fstyle
    put empty into oldshift
  else
    put the textFont of the selectedChunk into fname
    put the textSize of the selectedChunk into fsize
    put the textStyle of the selectedChunk into fstyle
    put the textShift of the selectedChunk into tshift
    if tshift is empty then put 0 into tshift
    if tshift is not oldshift then
      if tshift > 0
      then hilite menuItem subnum of menu "Text"
      else unhilite menuItem subnum of menu "Text"
      if tshift < 0
      then hilite menuItem subnum + 1 of menu "Text"
      else unhilite menuItem subnum + 1 of menu "Text"
      put tshift into oldshift
    end if
  end if
  put lineOffset(fname, fnames) into i
  if i is not oldfont then
    if oldfont is 0
    then unhilite menuItem fontnum + 1 of menu "Text"
    else unhilite menuItem oldfont + fontnum of menu "Text"
    if i is 0
    then hilite menuItem fontnum + 1 of menu "Text"
    else hilite menuItem i + fontnum of menu "Text"
    put i into oldfont
  end if
  put lineOffset(fsize, fsizes) into i
  if i is 0 and fsize is not empty then put the number of lines in fsizes into i
  if i is not oldsize then
    if oldsize is 0
    then unhilite menuItem sizenum + 1 of menu "Text"
    else unhilite menuItem oldsize + sizenum of menu "Text"
    if i is 0
    then hilite menuItem sizenum + 1 of menu "Text"
    else hilite menuItem i + sizenum of menu "Text"
    put i into oldsize
  end if
  replace "threedbox" with "3D Box" in fstyle
  if fstyle is not oldstyle then
    repeat for each item tstyle in oldstyle,fstyle
      put lineOffset(tstyle, fstyles) into i
      if i is not 0 then
        if tstyle is among the items of oldstyle and tstyle is not among the items of fstyle
        then unhilite menuitem i + stylenum of menu "Text"
        if tstyle is among the items of fstyle and tstyle is not among the items of oldstyle
        then hilite menuitem i + stylenum of menu "Text"
      end if
    end repeat
    put fstyle into oldstyle
  end if
end setuptext
          (   menuButton Aw/local stackstatus, substacknames, theTR
constant Nscripteditors = 10

on messageHandled t, m
  send "recordMessage t, m, the long id of the target, true" to card 1 of stack "Message Watcher"
end messageHandled

on messageNotHandled t, m
  send "recordMessage t, m, the long id of the target, false" to card 1 of stack "Message Watcher"
end messageNotHandled

on MCdebugScript t, h, l, p
  editScript t, false
  send "startDebug t, h, l, p" to card 1 of stack the result
  send "refresh" to card 1 of stack "Execution Contexts"
  send "refresh" to card 1 of stack "Variable Watcher"
  set the title of stack "Message Box" to "Message Box (debug)"
end MCdebugScript

on trace h, l, p
  if char -11 to -2 of the long id of the target is "mctools.mc"
  then set the tracereturn to true
  else
    switch the tracemode of stack "Script Editor"
    case "Step Over"
      get the debuggingScript of stack "Script Editor"
      if the long id of the target is the scriptObject of it \
          and h is the debuggingHandler of stack "Script Editor"
      then MCdebugScript the long id of the target, h, l, p
      else set the traceReturn to true
      break
    case "Trace"
      MCdebugScript the long id of the target, h, l, p
      send "MCdoTR" to me in the traceDelay milliseconds
      put it into theTR
      break
    default
      MCdebugScript the long id of the target, h, l, p
    end switch
  end if
end trace

on MCdoTR
  set the traceReturn to true
end MCdoTR

on MCcancelTR
  cancel theTR
  set the tracemode of stack "Script Editor" to empty
end MCcancelTR

on traceBreak h, l, p
  MCdebugScript the long id of the target, h, l, p
end traceBreak

on traceError h, l, p, which
  set the executionerror of card 1 of stack "Execution Error" to which
  modeless "Execution Error"
  send "refresh" to card 1 of stack "Execution Error"
end traceError

on traceDone
  set the traceStack to empty
  set the tracemode of stack "Script Editor" to empty
  get the debuggingScript of stack "Script Editor"
  if it is not empty
  then send "stopDebug" to it
  send "refresh" to card 1 of stack "Execution Contexts"
  send "refresh" to card 1 of stack "Variable Watcher"
  set the title of stack "Message Box" to empty
  set the traceReturn to true
end traceDone

on updateVariable l, vname, vvalue
  MCdebugScript the long id of the target, empty, l, 0
end updateVariable

function MCtargetStack plongid
  local sname
  set the wholeMatches to true
  put word wordOffset("stack", plongid) + 1 of plongid into sname
  delete last char of sname
  delete first char of sname
  return sname
end MCtargetStack

function MCcheckEdit
  return the tool is not "browse tool" \
      and the mode of stack MCtargetStack(the long id of the target) is 1
end MCcheckEdit

on mouseMove
  if not MCcheckEdit()
  then pass mouseMove
end mouseMove

on mouseEnter
  if not MCcheckEdit()
  then pass mouseEnter
end mouseEnter

on mouseLeave
  if not MCcheckEdit()
  then pass mouseLeave
end mouseLeave

on mouseDown which
  if MCcheckEdit() then
    put "edited" into stackstatus[MCtargetStack(the long id of the target)]
    if the commandKey is down and the optionKey is down then
      select the target
      edit script of the target
    else
      if which is 3 then
        select the target
        popup "MC SelectedObject Menu"
      else exit to MetaCard
    end if
  else pass mouseDown
end mouseDown

on mouseUp which
  if MCcheckEdit() then
    switch which
    case 1
      break
    case 2
      pass mouseUp
    case 3
      if the long id of the target is the selectedObject
      then popup "MC SelectedObject Menu"
      else select the target
      break
    end switch
  else pass mouseUp
end mouseUp

on mouseDoubleDown
  if not MCcheckEdit()
  then pass mouseDoubleDown
end mouseDoubleDown

on mouseDoubleUp
  if MCcheckEdit()
  then palette "Properties"
  else pass mouseDoubleUp
end mouseDoubleUp

on tabKey
  if the commandKey is down then
    if the tool is "browse tool"
    then choose pointer tool
    else choose browse tool
  else pass tabKey
end tabKey

on commandKeyDown which
  if which is in "1234" then
    set the defaultStack to the topStack
    switch which
    case "1"
      go to first card
      break
    case "2"
      go to prev card
      break
    case "3"
      go to next card
      break
    case "4"
      go to last card
      break
    end switch
  else
    if the optionKey is down then
      switch which
      case "S"
        edit script of the topStack
        break
      case "C"
        edit script of this card of the topStack
        break
      default
        pass commandKeyDown
      end switch
    else pass commandKeyDown
  end if
end commandKeyDown

on selectedObjectChanged
  if the mode of stack "Properties" is not 0
  then send "refresh" to stack "Properties"
  if the mode of stack "Font Chooser" is not 0
  then send "refresh" to stack "Font Chooser"
  if the mode of stack "Color Chooser" is not 0
  then send "refresh" to stack "Color Chooser"
  if the mode of stack "Control Browser" is not 0
  then send "refresh" to card 1 of stack "Control Browser"
  if the menubar is empty
  then send "mouseDown" to group "MetaCard Menu Bar" of stack "MetaCard Menu Bar"
end selectedObjectChanged

on arrowKey which
  if (the selectedField) is not empty or the selectedObject is empty\
      or word 1 of the selectedObject is "stack"\
      or word 1 of the selectedObject is "card"\
      and word 2 of the selectedObject is not among the items of "field,button,image,player,scrollbar,graphic"
  then pass arrowKey
  lock screen
  local diff
  if the shiftkey is down
  then put 10 into diff
  else put 1 into diff
  repeat for each line l in the selectedObjects
    switch which
    case "left"
      set the left of l to the left of l - diff
      break
    case "right"
      set the left of l to the left of l + diff
      break
    case "up"
      set the top of l to the top of l - diff
      break
    case "down"
      set the top of l to the top of l + diff
      break
    end switch
  end repeat
  unlock screen
end arrowKey

function MCfindSE which
  local i, ds
  put the substacks of stack "MetaCard Menu Bar" into substacknames
  repeat with i = 1 to Nscripteditors
    get "Script Editor" && i
    if it is not among the lines of substacknames then return empty
    if the scriptObject of card 1 of stack it is which then
      if the mode of stack it is 0
      then modeless it
      else
        put the debuggingScript of stack "Script Editor" into ds
        if ds is not empty and ds is not the long id of card 1 of stack it then
          hide stack it
          show stack it
          send "openField true" to card 1 of stack it
        end if
      end if
      return it
    end if
  end repeat
  return empty
end MCfindSE

on editScript which, doclick
  local i, ename, foundone
  put MCfindSE(which) into ename
  if ename is not empty then
    go ename
    if doclick then get value("setscript(False)", card 1 of stack ename)
    return ename
  end if
  put false into foundone
  repeat with i = 1 to Nscripteditors
    put "Script Editor" && i into ename
    if ename is not among the lines of substacknames then
      set the visible of stack "Script Editor" to false
      clone stack "Script Editor" as ename
      set the mainStack of stack ename to "MetaCard Menu Bar"
      put true into foundone
      exit repeat
    end if
    if the mode of stack ename is 0 then
      put true into foundone
      exit repeat
    end if
  end repeat
  if not foundone then
    answer error "Too many script editors open!" with "I'll close one"
    exit to top
  end if
  set the scriptObject of card 1 of stack ename to which
  modeless ename
  set the visible of stack ename to true
  if doclick then get value("setscript(False)", card 1 of stack ename)
  return ename
end editScript

on scriptParsingError which
  if the mode of stack "Script Errors" is 0
  then modeless "Script Errors"
  send "refresh which" to card 1 of stack "Script Errors"
end scriptParsingError

on colorChanged
  send "refresh" to stack "Color Chooser"
end colorChanged

function MCcheckDelete
  if the selectedField is not empty then return true
  repeat for each line l in the selectedObjects
    if word 1 of l is "group" and the number of lines in the cardNames of l > 1 then
      answer "This group is placed on multiple cards," & cr & "really delete it" with "Yes" or "No"
      if it is "No" then return false
    end if
  end repeat
  return true
end MCcheckDelete

on backspaceKey
  if MCcheckDelete() then pass backspaceKey
end backspaceKey

on deleteKey
  if MCcheckDelete() then pass deleteKey
end deleteKey

function MCsaveCheck tstack
  if stackstatus[tstack] is "edited" then
    toplevel tstack
    answer "Save stack" && quote & tstack & quote && "before closing?" with "Yes" or "No" or "Cancel"
    switch it
    case "Yes"
      if the effective filename of the topStack is not empty
      then MCdoSave tstack
      else MCdoSaveAs tstack
      break
    case "No"
      put empty into stackstatus[tstack]
      break
    case "Cancel"
      return false
    end switch
  end if
  return true
end MCsaveCheck

on closeStackRequest
  if MCsaveCheck(MCtargetStack(the long id of the target))
  then pass closeStackRequest
end closeStackRequest

on shutdownRequest
  repeat for each line l in the openStacks
    if not MCsaveCheck(MCtargetStack(the long id of stack l))
    then exit to MetaCard
  end repeat
  pass shutdownRequest
end shutdownRequest

on MCdoSave sname
  local stime
  put the seconds into stime
  palette "Saving"
  wait 1 second
  set the cursor to watch
  compact stack sname
  save stack sname
  if the result is not empty
  then answer "Can't save stack, error was:" & cr & the result
  else
    put empty into stackstatus[MCtargetStack(sname)]
    wait until the seconds - stime > 2
  end if
  close stack "Saving"
end MCdoSave

on MCdoSaveAs shortname
  local makems, msname, sname
  put true into makems
  put the short name of stack shortname into shortname
  put the mainStack of stack shortname into msname
  if msname is not shortname and msname is not "Home" then
    modal "MainStack Option"
    if the retval of stack "MainStack Option" is "Cancel"
    then exit to MetaCard
    if the retval of stack "MainStack Option" is "No" then
      put false into makems
      put msname into shortname
    end if
  end if
  put MCfixpath(shortname) into sname
  local filterstring
  if the systemFileSelector then
    switch the platform
    case "Win32"
      put "MetaCard Stacks" & cr & "*.mc" & cr & "All Files" & cr & "*.*" into filterstring
      break
    case "MacOS"
      put "MSTK" into filterstring
      break
    default
      put "*.mc" into filterstring
    end switch
  else put "*.mc" into filterstring
  ask file "Save stack" && shortname && "as:" with sname with filter filterstring
  if it is empty
  then exit to MetaCard
  if makems and shortname is not msname then
    local tcolors, hcolors
    put the colors of stack shortname into tcolors
    put the colors of stack "Home" into hcolors
    repeat with i = 1 to 8
      if line i of tcolors is empty
      then put line i of hcolors into line i of tcolors
    end repeat
    set the colors of stack shortname to tcolors
    set mainStack stack shortname to shortname
    set the cursor to watch
    save stack msname
  end if
  set the cursor to watch
  save stack shortname as it
  put empty into stackstatus[MCtargetStack(shortname)]
end MCdoSaveAs

on newTool
  send "changeTool" to me
  send "changeTool" to stack "Tools"
  send "changeTool" to stack "Paint Tools"
  pass newTool
end newTool

on getCachedURLs
  start using "libUrl"
  pass getCachedURLs
end getCachedURLs

on getURLStatus
  start using "libUrl"
  pass getURLStatus
end getURLStatus

on loadURL
  start using "libUrl"
  pass loadURL
end loadURL

on getURL
  start using "libUrl"
  pass getURL
end getURL

on postURL
  start using "libUrl"
  pass postURL
end postURL

on putURL
  start using "libUrl"
  pass putURL
end putURL

on unloadURL
  start using "libUrl"
  pass unloadURL
end unloadURL

on deleteURL
  start using "libUrl"
  pass deleteURL
end deleteURL
                    	        File ŋU	on errorDialog
  close stack "Saving"
  unlock error dialogs
  pass errorDialog
end errorDialog

on menuPick which
  switch which
  case "New Stack"
    create stack
    select the topStack
    set the colors of the topStack to the colors of stack "Home"
    palette "Properties"
    break
  case "Open..."
    local filterstring
    if the systemFileSelector then
      switch the platform
      case "Win32"
        put "MetaCard Stacks" & cr & "*.mc" & cr & "All Files" & cr & "*.*" into filterstring
        break
      case "MacOS"
        put "MSTKSTAKRSTK" into filterstring
        break
      default
        put "*.mc" into filterstring
      end switch
    else put "*.mc" into filterstring
    answer file "Open stack:" with filter filterstring
    if it is not empty then
      set the cursor to watch
      topLevel it
      if the result is not empty
      then answer error "Can't open stack because" & cr & the result & "."
    end if
    break
  case "Save"
    if the effective filename of the topStack is not empty
    then MCdoSave the long id of the topStack
    else MCdoSaveAs the long id of the topStack
    break
  case "Save As..."
    MCdoSaveAs the long id of the topStack
    break
  case "Revert"
    if the short name of the topStack is "Home"\
        or the owner of the topStack is not empty\
        and the short name of stack (the owner of the topStack) is "Home" then
      answer "Can't revert Home stack, or substacks of Home stack"
      exit to MetaCard
    end if
    local dstring
    if the mainStack of the topStack is not the short name of the topStack then
      put "Discard all changes to substack" & return\
          & the short name of the topStack & return & "of main stack" & return\
          & the mainStack of the topStack & "?" into dstring
    else put "Discard all changes to main stack" & return &\
        the short name of the topStack & "?" into dstring
    answer dstring with "OK" or "Cancel"
    if it is "Cancel" then exit to MetaCard
    revert
    break
  case "Close"
    get the openStacks
    if line 1 of it is "MetaCard Menu Bar"
    then close stack line 2 of it
    else close stack line 1 of it
    break
  case "Import..."
    palette "Importer"
    break
  case "Print Card"
    set the defaultStack to the topStack
    print this card
    break
  case "Page Setup..."
    modeless "Page Setup"
    break
  case "Quit"
  case "Exit"
    quit
    break
  end switch
end menuPick
          (    p&New Stack
-
&Open.../O
&Save/S
Save &As...
&Revert
&Close
-
&Import...
-
Prin&t Card
Pa&ge Setup...
-
&Quit/Q
      	        Edit ŋUon menuPick which
  switch which
  case "Undo"
    undo
    break
  case "Cut"
    if the selectedField is not empty
    then if the lockText of the selectedField then exit to MetaCard
    if MCcheckDelete() then cut
    break
  case "Copy"
    copy
    break
  case "Paste"
    set the defaultStack to the topStack
    paste
    break
  case "Delete"
    if the selectedField is not empty
    then if the lockText of the selectedField then exit to MetaCard
    if MCcheckDelete() then delete
    break
  case "Select All"
    if the selectedField is not empty then
      if the lockText of the selectedField then exit to MetaCard
      select text of the selectedField
    else
      if the cantModify of the topStack then
        answer "This stack can't be modified"
        exit to MetaCard
      end if
      lock screen
      set the defaultStack to the topStack
      repeat with i = 1 to the number of layers
        if the visible of control i or the showInvisibles
        then set the selected of control i to true
        add the number of layers in control i to i
      end repeat
      unlock screen
    end if
    break
  case "Ungroup"
  case "Group"
    if word 1 of the selobj is "group" and the number of lines in (the selobjs) is 1
    then ungroup
    else
      group
      if the result is not empty
      then answer "Can't group unless all objects have the same owner."
    end if
    break
  case "Backgrounds..."
  case "Stop Editing BG"
    if the editBkgnd of the topStack
    then set the editBackground of the topStack to false
    else modal "Edit Backgrounds"
    break
  case "Menus"
    set the editMenus of the topStack to not the editMenus of the topStack
    break
  case "Create Card"
    set the defaultStack to the topStack
    create card
    break
  case "Delete Card"
    set the defaultStack to the topStack
    delete this card
    break
  case "Clone This Card"
    set the defaultStack to the topStack
    clone this card
    break
  case "Object Properties..."
    palette "Properties"
    break
  case "Card Properties..."
    select this card of the topStack
    palette "Properties"
    break
  case "Stack Properties..."
    select the topStack
    palette "Properties"
    break
  end switch
end menuPick
        0  (    &Undo/Z
-
Cu&t/X
&Copy/C
&Paste/Y
&Delete
Select A&ll
-
(&Group/G
&Backgrounds.../T
&Menus
-
C&reate Card
D&elete Card
Cl&one This Card
-
Ob&ject Properties...
Card Propert&ies...
Stac&k Properties...      	        Tools ŋUon menuPick which
  switch which
  case "Find..."
    modeless "Find"
    break
  case "Navigator"
    palette "Navigator"
    break
  case "Message Box"
    if the mode of stack "Message Box" is 0 \
        or line 1 of the openStacks is not "Message Box"then
      modeless "Message Box"
      select before char 1 of field 1 of stack "Message Box"
    else close stack "Message Box"
    break
  case "Tools Palette"
    palette "Tools"
    break
  case "Paint Tools"
    palette "Paint Tools"
    break
  case "Character Chooser"
    palette "Character Chooser"
    break
  case "Script Profiler"
    modeless "Script Profiler"
    break
  case "Control Browser"
    modeless "Control Browser"
    break
  case "Menu Builder..."
    modeless "Menu Builder"
    break
  case "Resource Mover..."
    modeless "Resource Mover"
    break
  case "Standalone Builder..."
    modeless "Standalone Builder"
    break
  case "Audio Settings"
    palette "Audio"
    break
  case "Preferences"
    modeless "Preferences"
    break
  case "Utilities"
    modeless "Utilities"
    break
  case "Print Field"
    modeless "Print Field"
    break
  case "tools.metacard.com"
    downloadNgo "http://www.metacard.com/stacks/tools.mc"
    break
  end switch
end menuPick
        X  0   &Find...
-
&Navigator
&Message Box/M
&Tools Palette
Pa&int Tools
-
&Character Chooser
&Script Profiler
Control Bro&wser
-
Menu &Builder...
Resource Mo&ver...
Standalone Builde&r...
-
&Audio Settings
&Preferences
&Utilities
Print Fiel&d
-
t&ools.metacard.com      	        Text ŋUon menuPick newatt
  if the selectedChunk is empty and the selectedObject is empty
  then exit to MetaCard
  set the itemDel to "|"
  switch item 1 of newatt
  case "Font"
    put item 2 of newatt into newatt
    if newatt is "none"
    then put empty into newatt
    if the selectedChunk is empty then
      repeat for each line l in the selectedObjects
        set the textFont of l to newatt
      end repeat
    else set the textFont of the selectedChunk to newatt
    break
  case "Size"
    put item 2 of newatt into newatt
    if newatt is "none"
    then put empty into newatt
    else
      if newatt is "Other..." then
        local f, c1, c2
        if the selectedChunk is empty then put empty into c1
        else
          put word 2 of (the selectedChunk) into c1
          put word 4 of (the selectedChunk) into c2
          put the long id of the selectedField into f
        end if
        ask "New font size?"
        if c1 is not empty then select char c1 to c2 of f
        if it is not a number then exit to MetaCard
        put it into newatt
      end if
    end if
    if the selectedChunk is empty then
      repeat for each line l in the selectedObjects
        set the textSize of l to newatt
      end repeat
    else
      set the textSize of the selectedChunk to newatt
      set the fixedLineHeight of the selectedField to false
    end if
    break
  case "Style"
    local tstyle
    put item 2 of newatt into newatt
    if newatt is "plain"
    then put "plain" into tstyle
    else
      if newatt is "3D Box" then put "threedbox" into newatt
      if the selectedChunk is empty
      then put the effective textStyle of the selectedObject into tstyle
      else put the effective textStyle of the selectedChunk into tstyle
      local toffset
      set the wholematches to true
      set the itemDel to comma
      put itemOffset(newatt, tstyle) into toffset
      if toffset is 0 then
        if tstyle is empty
        then put newatt into tstyle
        else put comma & newatt after tstyle
      else
        delete item toffset of tstyle
        if tstyle is empty then put "plain" into tstyle
      end if
    end if
    if newatt is "plain" and the selectedChunk is not empty\
        and the textShift of the selectedChunk is not 0 then
      set the textShift of the selectedChunk to 0
      set the textSize of the selectedChunk to empty
    end if
    if the selectedChunk is empty
    then set the textStyle of the selectedObject to tstyle
    else set the textStyle of the selectedChunk to tstyle
    break
  case "Color"
    switch item 2 of newatt
    case "Pen Color"
      put the penColor into newatt
      break
    case "Clear"
      put empty into newatt
      break
    default
      put item 2 of newatt into newatt
      break
    end switch
    if the selectedChunk is empty
    then set the textColor of the selectedObject to newatt
    else set the textColor of the selectedChunk to newatt
    break
  default
    local tshift, tsize
    put the textShift of the selectedChunk into tshift
    if tshift is not empty and tshift is not 0 then
      set the textSize of the selectedChunk to empty
      set the textShift of the selectedChunk to 0
    else
      put the effective textSize of the selectedChunk into tsize
      set the textSize of the selectedChunk to round(tsize * 3 / 5)
      if item 1 of newatt is "Subscript"
      then set the textShift of the selectedChunk to 4
      else set the textShift of the selectedChunk to -4
    end if
    set the fixedLineHeight of the selectedField to false
    break
  end switch
end menuPick
          (   (Font
!u	none
	-
!u	arial
!u	avantgarde
!u	bitstream charter
!u	bookman
!u	bookman l
!u	century schoolbook
!u	century schoolbook l
!u	chancery l
!u	charter
!u	courier
!u	courier new
!u	fixed
!u	goth
!u	gothic
!u	gothic l
!u	helvetic
!u	helvetica
!u	kochi gothic
!u	kochi mincho
!u	ledfixed
!u	lucida
!u	lucidabright
!u	lucidatypewriter
!u	lucidux mono
!u	lucidux sans
!u	lucidux serif
!u	mincho
!u	new century schoolbook
!u	nimbus mono
!u	nimbus mono l
!u	nimbus roman
!u	nimbus roman no9 l
!u	nimbus sans
!u	nimbus sans condensed
!u	nimbus sans l
!u	palatino
!u	palladio
!u	palladio l
!u	terminal
!u	times
!u	times new roman
!u	utopia
!u	zapf chancery
(Size
!u	none
	-
!u	8
!u	10
!u	11
!u	12
!u	14
!u	17
!u	18
!u	20
!u	24
!u	25
!u	30
	-
!u	other...
(Style
!n	Plain
	-
!n	Bold
!n	Italic
!n	Underline
!n	Strikeout
!n	3D Box
!n	Box
	-
!n	Link
(Color
!u	Black
!u	White
!u	Red
!u	Green
!u	Blue
!u	Yellow
	-
!u	Pen Color
	-
!u	Clear
(!uSubscript
(!uSuperscript      	        Help ŋUon menuPick which
  switch which
  case "help.metacard.com"
    downloadNgo "http://www.metacard.com/stacks/help.mc"
    break
  case "Directory"
    modeless "Help Directory"
    break
  case "Index"
    modeless "Help Index"
    break
  case "Tutorials"
    modeless "MetaCard Tutorials"
    break
  case "Concepts"
    topLevel "Concepts & Techniques"
    break
  case "Reference"
    topLevel "MetaTalk Reference"
    break
  case "Examples"
    topLevel "MetaTalk Examples"
    break
  case "FAQ"
    topLevel "MetaCard FAQ"
    break
  case "Licensing"
    modeless "Licensing MetaCard"
    break
  case "Support..."
    modeless "Support"
    break
  case "About MetaCard..."
    modeless "MetaCard Version"
    break
  end switch
end menuPick
         0    }&help.metacard.com
-
&Directory
&Index
&Tutorials
&Concepts
&Reference
&Examples
&Licensing
&Support...
-
&About MetaCard...      	        Message Box           cs  %go "/home/raney/cragg/liburl_1010.mc"color                 S  U 
Helvetica   U Clean   U 
Helvetica   W 
Helvetica   U 
Helvetica   U 
Helvetica   U 
Helvetica  W 
Helvetica  W 
Helvetica  U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica   U Courier   W Courier   U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica  U 
Helvetica  @U 
Helvetica  U 
Helvetica  AW 
Helvetica  W 
Helvetica  W 
Helvetica  PW 
Helvetica  TW 
Helvetica  U 
Helvetica  U 
Helvetica  
 U 
Helvetica  
 U Courier  
 U Courier   U Courier   U 
LucidaBright   U Symbol   U charter   U 
Helvetica   U Lucida   U Lucida   U Clean   U Courier   U fixed   U times   U 
Helvetica   U Font|clean   U Font   U Superscript   U Color|-   U Color   U charter   W Lucida  W Lucida  W clean   W 
Helvetica   U Clean   W Clean   W 
Helvetica   U 
Helvetica   W 
Helvetica  @U 
Helvetica  DU 
Helvetica  HU 
Helvetica   W charter  U charter   U 
Helvetica  U charter   W 
Helvetica   U nil   U charter   U 
Helvetica   U fixed   U fangsong ti  ! U 
Helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica    U 
helvetica    Message Box Card   	P,local initted
on resizeStack
  set the rect of field 1 to the rect of me
end resizeStack

on preOpenCard
  if not initted then
    set the topleft of this stack to max(0, the left of the topStack -\
        (the width of this stack - the width of the topStack) div 2), \
        min(the bottom of the topStack + 32, item 4 of the windowBoundingRect - 32)
    send "init" to field 1
    put true into initted
  end if
end preOpenCard

on closeCard
  put empty into field 1
end closeCard

on changed which, old, new
  put new into field 1 of me
end changed
              
   Message Field  )p.local MessageBoxHistory, MessageBoxIndex

on init
  put 1 into MessageBoxIndex
  put empty & return into MessageBoxHistory
  put empty into field 1
end init

on errorDialog eerror, perror
  if perror is not empty then
    set the scripterror of card 1 of stack "Script Error" to perror
    modeless "Script Error"
  else
    set the errorobject of card 1 of stack "Execution Error" to the long id of the target
    set the executionerror of card 1 of stack "Execution Error" to eerror
    modeless "Execution Error"
    send "refresh" to card 1 of stack "Execution Error"
  end if
end errorDialog

on returnInField
  lock error dialogs
  if me is empty
  then exit to MetaCard
  if the traceStack is not empty
  then set defaultStack to the traceStack
  else set defaultStack to the topStack
  set the cs of stack "Message Box" to me
  put return after MessageBoxHistory
  put the cs of stack "Message Box" into the last line of MessageBoxHistory
  if the number of lines in MessageBoxHistory > 20
  then delete line 1 of MessageBoxHistory
  put empty into msg
  put 1 into MessageBoxIndex
  if the number of lines in field 1 of stack "Execution Contexts" is not 0 then
    get the hilitedLine of field 1 of stack "Execution Contexts"
    if it is empty then get the number of lines of field 1 of stack "Execution Contexts"
    set the debugContext to line it of field 1 of stack "Execution Contexts"
  end if
  if word 1 of the cs of stack "Message Box" is not among the lines of the commandNames then
    if word 1 of the cs of stack "Message Box" is "the" \
        or word 1 of the cs of stack "Message Box" is a number \
        or token 2 of the cs of stack "Message Box" is "("
    then put value(the cs of stack "Message Box", this card)
    else send the cs of stack "Message Box" to this card
  else
    if the number of lines in field 1 of stack "Execution Contexts" is 0 then
      do "global" && the globals & return & the cs of stack "Message Box" \
          & return & "if the result is not empty then put the result"
    else debugdo the cs of stack "Message Box" & return & "if the result is not empty then put the result"
  end if
  unlock error dialogs
end returnInField

on prevline
  subtract 1 from MessageBoxIndex
  if MessageBoxIndex is 0
  then put the number of lines in MessageBoxHistory into MessageBoxIndex
  put line MessageBoxIndex of MessageBoxHistory into me
  exit to MetaCard
end prevline

on nextline
  add 1 to MessageBoxIndex
  if MessageBoxIndex > the number of lines in MessageBoxHistory
  then put 1 into MessageBoxIndex
  put line MessageBoxIndex of MessageBoxHistory into me
  exit to MetaCard
end nextline

on commandKeyDown which
  handleKey which
  pass commandKeyDown
end commandKeyDown

on controlKeyDown which
  handleKey which
  pass controlKeyDown
end controlKeyDown

on handleKey which
  if which is "P"
  then prevline
  if which is "N"
  then nextline
  if which is "U" then
    put empty into msg
    exit to MetaCard
  end if
end handleKey

on arrowKey which
  if which is "up"
  then prevline
  if which is "down"
  then nextline
  pass arrowKey
end arrowKey
     @                     Execution Error    on errorDialog which
  put which
  set the executionerror of card 1 of stack "Execution Error" to which
  modeless "Execution Error"
  send "refresh" to card 1 of stack "Execution Error"
end errorDialog
            z                	  U 
Helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica    e Execution Error Card   	p	local ee, ec, er, eo, ei, et

on returnInField
  send "mouseUp" to button "Ignore"
end returnInField

on returnKey
  send "mouseUp" to button "Ignore"
end returnKey

on closeCard
  set the errorobject of me to empty
  set the executionerror of me to empty
  put empty into ee
  put empty into field "Error Message"
  put empty into field "Object"
  put empty into field "Bad Token"
  put 0 into field "Line"
  put 0 into field "Column"
end closeCard

on preOpenCard
  set the loc of this stack to the screenLoc
end preOpenCard

on refresh
  local lc, em, tei, teo, ter, tec
  put empty into ei
  put empty into eo
  put empty into er
  put empty into ec
  put empty into et
  put empty into field "Error Message"
  put the executionerror of me & cr after ee
  put the number of lines in ee into lc
  if lc > 100
  then delete line 100 to lc of ee
  if lc < 2 or the number of items in ee < 6 then
    hide button "Script..."
    hide button "Debug..."
    put "thrown error" & cr into field "Error Message"
  end if
  repeat with i = the number of lines in ee down to 1
    get item 1 of line i of ee
    put line it of field "Messages" into em
    if em is "Object Name:" then
      put item 4 of line i of ee into tei
      put the long name of tei into teo
    else
      put em & cr before field "Error Message"
      if item 2 of line i of ee is not 0 then
        put item 2 of line i of ee into ter
        put item 3 of line i of ee into tec
      end if
      put tei & cr before ei
      put teo & cr before eo
      put ter & cr before er
      put tec & cr before ec
      put item 4 of line i of ee & cr before et
    end if
  end repeat
  delete last char of field "Error Message"
  seterror 1
  set the hilitedLines of field 1 to 1
end refresh

on openCard
  set the hilitedLines of field 1 to 1
end openCard
on openStack
end openStack
on preOpenStack
end preOpenStack
on openBackground
end openBackground
on preOpenBackground
end preOpenBackground

on seterror which
  if line which of eo contains quote & "Message Field"  & quote\
      or "mctools.mc" is not in the frontscripts \
      or word 1 of the mainStacks is not "Home" then
    hide button "Script..."
    hide button "Debug..."
  else
    show button "Script..."
    show button "Debug..."
  end if
  put line which of eo into field "Object"
  put line which of er into field "Line"
  put line which of ec into field "Column"
  put line which of et into field "Bad Token"
  set the errorobject of me to line which of ei
end seterror
              errorobject   executionerror         
               
                     
    	Messages   @       
 
|         e /Handler: Running low on memory, script aborted  (recursionLimit: Recursion limit reached   abs: error in source expression  accept: bad expression  &aclip: playLoudness is not an integer  !acos: error in source expression  acos: domain error  add: error in matrix operation  -add: destination has a bad format (numeric?)   add: error in source expression  add: can't set destination  add: can't add array to scalar  )aliasReference: error in file expression  %Operators and: error in left operand  &Operators and: error in right operand  (Operators bitAnd: error in left operand  )Operators bitAnd: error in right operand  $annuity: error in period expression  "annuity: error in rate expression  %answer: error in question expression  %answer: error in response expression  "answer: error in title expression  split: error in expression  (arrowKey: error in direction expression  arrowKey: not a direction  !asin: error in source expression  asin: domain error  "ask: error in question expression  ask: error in reply expression  ask: error in title expression  !atan2: error in first expression  "atan2: error in second expression  atan2: domain error  !atan: error in source expression  atan: domain error  $average: error in source expression  )base64Decode: error in source expression  )base64Encode: error in source expression  "baseConvert: bad destination base  (baseConvert: error in source expression  baseConvert: bad source base  'baseConvert: can't convert this number  (baseConvert: destination is not base 10  beep: error in expression  ,binaryDecode: destination is not a variable  )binaryDecode: invalid data for parameter  $binaryDecode: not enough parameters  )binaryDecode: error in source expression  )binaryEncode: invalid data for parameter  $binaryEncode: not enough parameters  )binaryEncode: error in source expression  !Button: bad accelerator modifier  !Button: family is not an integer  %Button: menuButton is not an integer  &Button: menuHistory is not an integer  $Button: menuLines is not an integer  #Button: mnemonic is not an integer  %cancel: message id is not an integer  &charToNum: error in source expression  choose: error in expression  choose: not a tool  &Chunk: error in background expression   Chunk: error in card expression   Chunk: error in character range  *Chunk: container is not a button or field  !Chunk: error in chunk expression  Chunk: error in item range  Chunk: error in line range  "Chunk: error in object expression  %Chunk: error in range end expression  'Chunk: error in range start expression  !Chunk: error in stack expression  Chunk: error in text string  Chunk: can't separate tokens  Chunk: can't separate words  Chunk: can't delete object  Chunk: can't find object  #Chunk: can't get object attributes  0Chunk: can't get value of destination container  Chunk: can't get number  Chunk: can't get source string  Chunk: can't get substring  Chunk: can't find substring  Chunk: can't set attributes  ,Chunk: can't store to destination container  Chunk: can't set as a number  Chunk: can't find background  Chunk: can't find card  Chunk: no such object  Chunk: can't set property  Chunk: can't find stack  Chunk: no target found  +Chunk: can't select object that isn't open  !Chunk: source is not a container  'Chunk: can't find object to store into  'Chunk: can't get source from container  &Chunk: destination is not a container  click: script aborted  )click: expression is not a button number  !click: error in point expression  !click: expression is not a point  click: stack is not open   clone: error in name expression  clone: can't clone this object  clone: stack is locked  "clone: can't find object to clone   close: error in name expression  close: can't find stack  #color: error setting selectedColor  "compact: can't find stack to save  compact: object is not a stack  &compound: error in periods expression  #compound: error in rate expression  %compress: error in source expression  ,compress: error occurred during compression  $Operators &&: error in left operand  %Operators &&: error in right operand  #Operators &: error in left operand  $Operators &: error in right operand  *Operators contains: error in left operand  +Operators contains: error in right operand  #convert: can't read from container  convert: can't set container  !copy: invalid destination object  $copy: can't find destination object  copy: can't copy source object  copy: can't find source object  "copy: stack is password protected   cos: error in source expression  cos: domain error  5create: error in bad parent or background expression  !create: error in name expression  &create: error in file name expression  %create: stack is locked (cantModify)   crop: error in image expression  crop: object is not an image  $crop: error in rectangle expression  $crop: expression is not a rectangle  cut: can't find or copy object  'decompress: error in source expression  *decompress: string is not compressed data  'decompress: error during decompression  -delete: error in file or url name expression  delete: can't find object  disable: can't find object  ,Stack: stack has not been given a file name  "divide: error in matrix operation  0divide: destination has a bad format (numeric?)  #divide: error in source expression  divide: can't set destination  %divide: can't divide scalar by array  divide: range error (overflow)  divide: divide by zero  )Operators div: error in matrix operation  %Operators div: error in left operand  &Operators div: error in right operand  -Operators div: can't divide scalar by matrix  &Operators div: range error (overflow)  Operators div: divide by zero  do: aborted  do: error in source expression  do: error in statement  do: error in expression  !do: error in language expression  0do: unexpected end of line in source expression  do: can't find command  do: not a command  do: license limit exceeded  doMenu: error in expression  "doMenu: don't know this menu item  drag: script aborted  drag: bad "button" number  drag: bad end point expression  drag: end point is not a point  !drag: bad start point expression  !drag: start point is not a point  &driverNames: error in type expression  !drives: error in type expression  edit: can't find object  $encrypt: error in source expression  Operators =: error in operand  "exp10: error in source expression  exp10: domain error  !exp1: error in source expression  exp1: domain error  !exp2: error in source expression  exp2: domain error  5export: error in file (or mask file) name expression  'export: can't open file (or mask file)  5export: can't write to file, mask file, or container  -export: no image selected, or image not open  (export: selected object is not an image  $Expression: error in numeric factor  #Expression: error in string factor   exp: error in source expression  exp: domain error  &extents: error in variable expression  Factor: error in left operand  Factor: error in right operand  Field: bad text attributes  %Field: hilitedLine is not an integer  (Field: scrollbarWidth is not an integer  Field: shift is not an integer  *Field: tabstops is not a positive integer  2files: no permission to list files or directories  filter: bad source string  filter: bad pattern string  filter: can't set destination  find: bad source string  flip: can't find image  flip: object is not an image  flushEvents: bad event type  focus: not a valid control  $fontNames: error in type expression  fontSizes: bad font name  fontStyles: bad font name  fontStyles: bad font size  0format: bad format string or parameter mismatch  $Function: error in function handler  %Function: error in source expression  !Function: source is not a number  Function: is not a number  get: error in expression  get: can't set destination  %globalLoc: coordinate is not a point  #go: error in background expression  go: error in card expression  go: error in stack expression  go: error in window expression  *go: can't attach menu to this object type  go: can't find destination  grab: can't find object  graphic: not an integer   Operators >=: error in operands  Operators >: error in operands  Group: backSize is not a point  'Group: hilitedButton is not an integer  Group: bad object type  %Operators (): error in right operand  Handler: aborted  Handler: error in statement  'Handler: error in parameter expression  %Handler: not a valid parameter index  !hasMemory: bad amount expression  (hide: error in visual effect expression  hide: can't find object  (hostAddress: error in socket expression  /hostAddressToName: error in address expression  #hostName: error in name expression  ,hostNameToAddress: error in name expression  if-then: aborted  'if-then: error in condition expression  if-then: error in statement  Image: bad pixmap id  !Image: hotspot is not an integer  Image: id is not an integer  .Image: id is already in use by another object  $Image: image must be open to set id  #Image: hotSpot x is not an integer  #Image: hotSpot y is not an integer  import: error in expression  .import: can't open file, mask file or display  .import: can't read file, mask file or display  1import: destination stack is locked (cantModify)  insert: can't find object  insert: license limit exceeded   intersect: two objects required  $Operators is: error in left operand  %Operators is: error in right operand  %Operators is: can't compare operands  6Operators is: left operand of 'within' is not a point  ;Operators is: right operand of 'within' is not a rectangle  %isNumber: error in source expression  "isoToMac: error source expression  #Operators ,: error in left operand  $Operators ,: error in right operand  "keys: parameter is not a variable  kill: no such process  kill: bad number  (launch: error in application expression  #length: error in source expression   Operators <=: error in operands  Operators <: error in operands   ln1: error in source expression  ln1: domain error  ln: error in source expression  ln: domain error  load: error in url expression  "load: error in message expression  $localLoc: coordinate is not a point  "log10: error in source expression  log10: domain error  !log2: error in source expression  log2: domain error  'longFilePath: error in file expression  "macToIso: error source expression  mark: bad card expression  mark: error in find expression  +matchChunk: can't set destination variable  %matchChunk: bad or missing parameter  (matchChunk: error in pattern expression  'matchChunk: error in source expression  (matrix: range error in matrix operation  +matrixMultiply: error in source expression  ,matrixMultiply: can't multiply these arrays   max: error in source expression  *MCISendString: error in source expression  &MD5digest: error in source expression  #median: error in source expression  "merge: error in source expression  .Operators -: can't subtract array from scalar  #Operators -: error in left operand  $Operators -: error in right operand  7Operators -: range error (overflow) in array operation  $Operators -: range error (overflow)   min: error in source expression  )Operators mod: error in matrix operation  %Operators mod: error in left operand  &Operators mod: error in right operand  -Operators mod: can't divide scalar by matrix  &Operators mod: range error (overflow)  Operators mod: divide by zero  "mouse: error in source expression  move: script aborted  move: can't find object  move: bad end point expression  move: bad duration expression  move: duration is not a number  move: end point is not a point  !move: bad start point expression  !move: start point is not a point  $multiply: error in matrix operation  2multiply: destination has a bad format (numeric?)  %multiply: error in source expression   multiply: can't set destination  )multiply: can't multiply scalar by array  !multiply: range error (overflow)   Operators <>: error in operands  &Operators not: error in right operand  )Operators bitNot: error in right operand  &numToChar: error in source expression  !Object: bad textAlign expression  Object: unknown color  Object: error in colors  =Object: can't set layer (card not open, or control in group)  Object: not a textStyle  6Object: stack locked, or object's script is executing  +Object: object does not have this property  !Object: height is not an integer   Object: layer is not an integer  !Object: margin is not an integer  /Object: value is not a boolean (true or false)  
Object Name:  #Object: property is not an integer  "Object: coordinate is not a point  )Object: rectangle does not have 4 points  Object: no Home stack  &Object: pixel value is not an integer  !Object: pixmap is not an integer  /Object: can't set script while it is executing   Object: can't set this property  %Object: textheight is not an integer  #Object: textsize is not an integer  )offset: error in start offset expression  !offset: error in part expression  "offset: error in whole expression  "open: error in message expression  open: error in name expression  /open: no permission to open files or processes  $Operators or: error in left operand  %Operators or: error in right operand  'Operators bitOr: error in left operand  (Operators bitOr: error in right operand  'Operators /: error in matrix operation  #Operators /: error in left operand  $Operators /: error in right operand  +Operators /: can't divide scalar by matrix  $Operators /: range error (overflow)  Operators /: divide by zero  param: error in expression  param: bad parameter index  "param: error in source expression  param: is not a number  $paste: stack is locked (cantModify)  (peerAddress: error in socket expression  =place: group is not in this stack or is already on this card  place: can't find group  place: can't find card  place: source is not a group  !place: destination is not a card  $play: can't get sound or movie name  play: bad movie location  play: bad movie options  #Operators +: error in left operand  $Operators +: error in right operand  $Operators +: range error (overflow)  pop: can't set destination  post: can't get source  post: can't get destination  pow: error in left operand  pow: error in right operand  pow: range error (overflow)  ,print: can't get 'from' or 'to' coordinates  !print: can't get number of cards  print: can't get rectangle  print: error printing  'print: error writing file (disk full?)  print: coordinate not a point  %print: expression is not a rectangle  print: not a card  .print: card or stack must be open to print it  print: no card specified  arcAngle: not an integer  blinkRate: not a number  penColor: bad color  "colormap: bad color name or value  )Object: error counting objects as number  'Object: error counting objects as text  dragSpeed: not a number  effectRate: not a number  extendKey: not a number  Property: bad array expression  gridSize: not an integer  idleRate: not a number  lineSize: not an integer  moveSpeed: not a number  multiSpace: not a number  polySides: not an integer  repeatDelay: not a number  repeatRate: not a number  !doubleClickDelta: not an integer  doubleClickTime: not a number  roundRadius: not an integer  slices: not an integer  startAngle: not an integer  traceDelay: not a number  traceStack: not a stack name  print: bad property value  syncRate: not a number  tooltipDelay: not a number  typeRate: not a number  userLevel: not an integer  beep: not an integer  brush: not an integer  brush: can't find image  #brushPattern: not a valid image id  brushPattern: can't find image  "Object: no object to set property  "Object: can't set object property  cursor: not an integer  cursor: can't find image  5Property: value is not a boolean ("true" or "false")   Property: value is not a number  defaultStack: can't find stack  !defaultMenuBar: can't find group  $Object: does not have this property  #Object: property is not an integer  !penPattern: not a valid image id  penPattern: can't find image  'randomSeed: property is not an integer  socketTimeout: not a number  "umask: property is not an integer  push: object is not a card  push: can't find card  put: error in expression  put: can't set destination   put: can't put into destination  *queryRegistry: error in source expression  #random: error in source expression  read: aborted  read: error in 'at' expression  $read: error in condition expression   read: error in count expression  read: error reading  read: count is not an integer  "read: error in 'until' expression  read: file is not open   read: error in 'for' expression  read: process is not open  !record: error in file expression  -recordCompression: type must be 4 characters  'recordInput: type must be 4 characters  remove: can't find object  remove: object is not a group  remove: object is not a card  #rename: error in source expression  (rename: error in destination expression  repeat: aborted  ,repeat: error in 'for' condition expression  repeat: error in statement  .repeat: error in 'until' condition expression  .repeat: error in 'while' condition expression  1repeat: error in 'with' end condition expression  3repeat: error in 'with' start condition expression  2repeat: error in 'with' step condition expression  &repeat: error setting 'with' variable  replace: can't set container  %replace: error in pattern expression  )replace: error in replacement expression  'replace: error in container expression  replaceText: bad parameter  replaceText: bad source string  #reply: error in keyword expression  #reply: error in message expression  %request: error in keyword expression  %request: error in message expression  %request: error in program expression  'request: no permission to request that  "getResources: error in expression  (getResources: no permission to get that  return: error in expression   revert: can't revert Home stack  #rotate: error in object expression  (rotate: object is not an editable image  "rotate: error in angle expression  +round: error in source or digit expression  $save: error in file name expression  save: saving disabled  save: can't find stack to save  save: object is not a stack  $seek: error in file name expression  !seek: error in offset expression  seek: file is not open  select: can't select target  3selectedChunk: error in button or field expression  &selectedButton: bad family expression  -selectedButton: bad parent object expression  )send: error in message handler execution  "send: error in message expression  send: error in 'in' expression  "send: error in program expression  send: bad target expression  !send: no permission to send that   set: error in source expression  set: can't set property  2setRegistry: no permission to get or set registry  (setRegistry: error in source expression  shell: aborted  shell: can't run shell command  "shell: error in source expression  %shell: no permission to run commands  (shortFilePath: error in file expression  (show: error in visual effect expression  #show: error in location expression  *show: error in number of cards expression  )show: location is not in proper x,y form  show: can't find object   sin: error in source expression  sin: domain error   sort: can't find object to sort  sort: error sorting  sort: can't find field  ,specialFolderPath: error in type expression  !sqrt: error in source expression  sqrt: domain error  Stack: bad decoration  4Stack: invalid id (must be greater than current id)  Stack: invalid key  Stack: bad substack name  ,Stack: can't set mainStack (has substacks?)  "Stack: deskIcon is not an integer  #Stack: userLevel is not an integer  Stack: size is not an integer  #Stack: stack is password protected  Stack: can't find mainStack   Stack: stack is not a mainStack  *Stack: error in external function handler  start: can't find object  start: stack is locked  !start: expression is not a group  start: license limit exceeded  $Handler: error in source expression  Handler: can't find handler  stdDev: error in expression  stop: error in expression  stop: target is not a group  $subtract: error in matrix operation  2subtract: destination has a bad format (numeric?)  %subtract: error in source expression   subtract: can't set destination  +subtract: can't subtract array from scalar  subwindow: error in expression  &subwindow: can't find stack or button   sum: error in source expression  &switch: error in condition expression  !switch: error in case expression  switch: error in statement  !textHeightSum: can't find object   tan: error in source expression  tan: domain error  "there: error in source expression  "throw: error in source expression  'Operators *: error in matrix operation  #Operators *: error in left operand  $Operators *: error in right operand  $Operators *: range error (overflow)  $toLower: error in source expression  %topStack: error in source expression  $toUpper: error in source expression  $transpose: source is not a variable  &transpose: can't transpose this array  "trunc: error in source expression  try: error in statement  type: script aborted  type: bad string expression  ungroup: can't find group  ungroup: target is not a group  (uniDecode: error in language expression  &uniDecode: error in source expression  (uniEncode: error in language expression  &uniEncode: error in source expression   unload: error in url expression  *unlock: expression is not a visual effect  &urlDecode: error in source expression  &urlEncode: error in source expression  #urlStatus: error in url expression  "value: error in source expression  "value: error executing expression  value: can't find object  Array: bad index expression  Chunk: source is not a number  !Chunk: source is not a character  visual: bad effect expression  wait: aborted  wait: error in expression  !wait: expression is not a number  within: can't find control  within: not a point  write: error in expression  (Operators bitXor: error in left operand  )Operators bitXor: error in right operand      
 Ignore p fon mouseUp
  close this stack
  set the traceAbort to true
  set the traceReturn to true
end mouseUp
        0 | D                 	   e 
    
Perror Field  	                  0 H       
      	          8 <         e Object:     
Script... p7on mouseUp
  get the long id of the errorobject of this card
  set the history[it] of stack "Script Editor" to \
      format("char %d of line %d of field \"Editor Field\"", field "Column", field "Line")
  editScript it
  close this stack
  set the traceAbort to true
  set the traceReturn to true
end mouseUp
         | O                 	   e 
    Object  	         @ 8 $        e      Help p on mouseUp
  help
end mouseUp
        | D                 	   e     	Debug... p on mouseUp
  MCdebugScript the long id of the errorobject of this card, empty, field "Line", field "Column"
  close this stack
end mouseUp
       $ | P                 	   e 
    Error Message  )pon mouseDoubleUp which
  if which is 3 and there is a file "eetext" then
    set the cursor to watch
    open file "eetext"
    read from file "eetext" until eof
    put it into field "Messages"
    close file "eetext"
    beep 1
  else
    local term
    put item 1 of the clickText into term
    if there is a card term of stack "MetaTalk Reference"
    then go to card term of stack "MetaTalk Reference"
  end if
end mouseDoubleUp

on mouseUp
  seterror the hilitedlines of me
end mouseUp
          (               	    `    @  	  & 
    
Bad Token  	        N \          e  
      	          \          e Processing Token: 
      	         ` \ @         e Column: 
    Line  	         0 \ 0         e 0 
   
   	          \ ,         e Line: 
    Column  	          \ '         e 0     
Script Error      l l l      7              U 
Helvetica   U 
helvetica    e Script Error Card   	pjon preOpenCard
  put 0 into field "Line"
  put 0 into field "Column"
  lock screen
  repeat with i = the number of lines in the scripterror of me down to 1
    get item 1 of line i of the scripterror of me
    put line it of field "Messages" & return before field "Error Message"
    if (item 2 of line i of the scripterror of me) is not 0 then
      put item 2 of line i of the scripterror of me into field "Line"
      put item 3 of line i of the scripterror of me into field "Column"
      put item 4 of line i of the scripterror of me into field "Bad Token"
    end if
    if item 4 of line i of the scripterror of me is not empty
    then put item 4 of line i of the scripterror of me into field "Bad Token"
  end repeat
  put item 4 of last line of the scripterror of me into field "Object"
  unlock screen
end preOpenCard

on closeStack
  put empty into field "Error Message"
  put empty into field "Object"
  put empty into field "Bad Token"
 set the scripterror of me to empty
end closeStack

on returnKey
  send "mouseUp" to button "OK"
end returnKey

on returnInField
  send "mouseUp" to button "OK"
end returnInField
              scripterror      
      
                           
    	Messages   @       
 
|         e 
Object Name:  set: license limit exceeded  abs: bad parameter  accept: bad expression  acos: bad parameter  add: bad destination  add: bad expression  add: missing 'to'  aliasReference: bad expression  annuity: bad parameter  answer: bad question  answer: bad response  answer: bad title  split: bad variable  split: missing 'with'  split: bad expression  #arrowKey: bad direction expression  asin: bad parameter  ask: bad question  ask: bad reply  ask: bad title  atan2: bad parameter  atan: bad parameter  average: bad parameter  base64Decode: bad parameter  base64Encode: bad parameter  baseConvert: bad parameter  binaryDecode: bad expression  binaryEncode: bad expression  cancel: bad message expression  charToNum: bad parameter  choose: bad expression  choose: no tool specified  Chunk: token is not a chunk  Chunk: bad destination   Chunk: bad non-chunk expression  0Chunk: bad chunk order (must be small to large)  Chunk: bad preposition  Chunk: bad range  Chunk: bad stack reference  Chunk: missing chunk  Chunk: bad expression   Chunk: bad range end expression  CChunk: can't create a variable with that name (explicitVariables?)  click: bad "button" expression  click: bad location expression  click: missing 'at'  clone: bad name expression  clone: bad target expression  close: bad stack expression  close: bad stack name  close: no stack type  #compact: error in stack expression  compound: bad parameter  compress: bad parameter   constant: error in value string  constant: missing value string  "convert: 'and' in the wrong place   convert: no container specified  convert: no format supplied  convert: not a valid format  convert: missing 'to'  (copy: bad destination object expression  cos: bad parameter  *create: bad background or card expression  &create: error in file name expression  create: can't create this type  create: not an object type  create: no file name supplied  ,create: no alias or directory name supplied  create: no object type  crop: bad image expression  crop: bad rect expression  decompress: bad parameter  define: bad object expression  define: invalid property name  delete: bad file expression   delete: bad variable expression  disable: no control specified  divide: bad destination  divide: bad expression  divide: missing 'by'  do: bad expression  do: bad language expression  doMenu: bad expression  drag: bad "button" expression  "drag: bad end location expression  $drag: bad start location expression  drag: missing 'from'  drag: missing 'to'  $driverNames: bad in type expression  drives: bad in type expression  edit: missing 'of'  edit: missing 'script'  edit: no object specified  encrypt: bad parameter  !exit: bad destination expression   exit: no destination expression  exp10: bad parameter  exp1: bad parameter  exp2: bad parameter  export: bad file name  export: bad mask file name  +export: bad image or image type expression  'export: missing file name or container  export: missing 'mask'  export: missing 'to'   export: no image type specified  Expression: bad chunk  Expression: bad function  Expression: bad property  #Expression: double binary operator  Expression: no binary operator  Expression: missing factor  4Expression: missing left operand to binary operator  Expression: missing ')'  Expression: bad factor  Expression: unquoted literal  &Expression: missing ')' before factor  exp: bad parameter  extents: bad parameter  Function: bad parameter  Function: missing 'of'  Function: missing '('  Function: missing ')'  !Function: separator is not a ','  filter: bad container  filter: bad pattern expression  filter: expected "with"  find: bad field expression  find: bad string expression  find: no string expression  flip: bad image expression  flip: missing direction  'flushEvents: bad event type expression  focus: bad object expression  fontNames: bad type expression   fontSizes: bad font name string  ,fontStyle: bad font name or size expression  format: bad format string  Function: bad form   Function: bad object expression  Function: bad parameter  %Function: can't modify this function  'Function: missing function or property  "Function: can't modify this token  get: bad expression  "global: not a valid variable name   globalLoc: bad point expression  go: bad destination chunk  go: bad chunk expression  -go: bad chunk order (must be small to large)  go: bad destination type  go: bad destination expression  go: bad direct destination   go: bad window expression  #go: preposition in the wrong place  go: duplicate chunk  go: no destination specified  go: missing id  go: no window mode specified  grab: bad object expression  (Handler: bad character between handlers  Handler: no end of line  Handler: error in handler  Handler: error in command  (Handler: end doesn't match handler name   Handler: unexpected end of line  1Handler: bad handler name (may be reserved word)  $Handler: not a valid parameter name  .Handler: unexpected end of line in parameters  3Handler: error in variable or constant declaration  Handler: bad command  (Handler: missing handler name after end  Handler: no name specified  Handler: not a command  !hasMemory: bad amount expression  (hide: error in visual effect expression  (hide: error in target object expression  (hostAddress: error in socket expression  /hostAddressToName: error in address expression  #hostName: error in name expression  ,hostNameToAddress: error in name expression  if: bad condition  if: unexpected end of line  if: error in command  &if: garbage where a command should be  if: not a command  if: missing 'then'  if: missing 'end if'  !import: bad file or display name  import: bad mask file name  import: bad image type  %import: missing file or display name  import: missing 'from'  import: missing 'mask'   import: no image type specified  !insert: bad object specification  insert: expected 'into'  insert: missing 'script'  #insert: expected 'front' or 'back'  $intersect: two objects are required  is: bad chunk type  is: bad validation type  is: missing validation type  is: no right operand  isNumber: bad expression   isoToMac: bad source expression  keys: bad variable name  kill: bad process name  kill: no process  (launch: error in application expression  length: bad parameter  ln: bad parameter  ln1: bad parameter  load: error in url expression  "load: error in message expression  &local: error in initialization string  -local: not a valid variable or constant name  1local: name shadows another variable or constant  localLoc: bad point expression  !lock: no target object specified   lock: not a valid target object  log10: bad parameter  log2: bad parameter  "longFilePath: bad file expression   macToIso: bad source expression  mark: bad 'field' expression  &mark: bad 'finding' string expression  mark: bad 'where' expression  mark: missing 'by' or 'where'  mark: missing 'cards'  mark: missing 'finding'  mark: missing 'finding' string  mark: expected 'by' or 'where'  mark: expected 'cards'  matchChunk: bad parameter  matrixMultiply: bad parameter  max: bad parameter  %MCISendString: bad source expression  !MD5digest: bad source expression  median: bad source expression  me: unexpected 'the'  merge: bad source expression  min: bad parameter  mouse: bad parameter  move: bad object expression  "move: bad end location expression  $move: bad start location expression  'move: expected 'messages' or 'waiting'  move: missing 'to'  multiply: bad destination  multiply: bad expression  multiply: missing 'by'  next: missing 'repeat'  next: token is not 'repeat'  numToChar: bad parameter  offset: bad parameter  "open: error in message expression  open: bad mode  open: bad file name  'open: type must be 'file' or 'process'  open: no mode specified  open: no type specified  param: bad expression  param: bad parameter  $Script: garbage character in script  "Script: missing '"' after literal  ,pass: mismatched or missing message to pass   pause: bad clip name expression  (peerAddress: error in socket expression  !place: bad background expression  place: bad card expression  play: bad clip name expression  play: bad location expression  play: bad options expression  play: bad tempo expression  play: bad stack expression  pop: bad card expression  $pop: preposition in the wrong place  pop: no card specified  post: bad source expression  post: missing 'to'  !post: bad destination expression  print: bad target card  print: bad 'from' expression   print: bad rectangle expression  print: missing 'to'  print: bad 'to' expression  !Properties: bad chunk expression  'Properties: bad array index expression  'Properties: can't modify this property  Properties: missing 'of'  !Properties: missing 'of' or 'in'  Properties: no such property  $Properties: token is not a property  Properties: expecting 'of'  #Properties: expecting 'of' or 'in'  push: bad expression  put: bad chunk  put: bad expression  5put: preposition must be 'before', 'into' or 'after'  (queryRegistry: bad parameter expression  random: bad parameter  read: bad 'at' expression  read: bad condition  read: bad message expression  read: bad file name expression  6read: bad source type (should be 'file' or 'process')  )read: no termination condition specified  read: missing 'from'   read: bad termination condition  0read: missing source type ('file' or 'process')  $record: missing 'file' or file name  remove: bad object expression  remove: expected 'from'  #remove: expected 'front' or 'back'  rename: bad expression  repeat: error in command  "repeat: bad termination condition  -repeat: unexpected end of line in condition	  repeat: missing condition  repeat: unexpected end of line  !repeat: error in 'for' condition  $repeat: garbage in repeat condition  repeat: not a command  "repeat: bad 'with' end expression  $repeat: bad 'with' start expression  #repeat: bad 'with' step expression  repeat: bad 'with' variable  "repeat: missing 'to' after 'down'  repeat: missing '='  repeat: missing 'in'  *repeat: garbage where a command should be  repeat: expecting '='  repeat: expecting 'to'  repeat: missing 'to'   repeat: missing 'with' variable  repeat: missing 'end repeat'  "replace: bad container expression  replace: bad expression  replaceText: bad parameter  #reply: error in message expression  #reply: error in keyword expression  %request: error in message expression  %request: error in program expression  request: no 'type' expression  ;request: type must be class, ID, sender, returnID, or data  6reset: missing 'paint', 'cursors', or template object  getResources: bad parameter  return: error in expression  "rotate: error in image expression  "rotate: error in angle expression  round: bad parameter   save: error in stack expression  $save: error in file name expression  .seek: bad mode (should be 'to' or 'relative')  seek: bad file name expression  seek: expected 'file'  seek: bad offset expression  seek: missing 'in'  #seek: no mode ('to' or 'relative')  seek: missing 'file'  select: missing target chunk  select: missing 'of'  select: bad target chunk  !selectedButton: missing 'family'  $selectedButton: bad card expression   send: bad message or expression   send: bad event type expression  -send: bad target chunk or program expression  set: error in expression  set: no property specified  set: missing 'the'  set: missing 'to'  &setRegistry: bad parameter expression  shell: bad parameter  #shortFilePath: bad file expression  %show: error visual effect expression  #show: error in location expression  !show: error in object expression  sin: bad parameter  sort: bad expression  !sort: error in object expression  sort: no object specified  'specialFolderPath: bad type expression  sqrt: bad parameter  !start: error in chunk expression  3start: bad action (should be 'editing' or 'using')  2start: no action specified ('editing' or 'using')  (Commands: not a valid object expression  Commands: bad 'in' expression  Commands: not a modifier key  Commands: bad parameter  Commands: bad parameters  Commands: missing ','   Commands: missing modifier key   Commands: expected 'and'  Commands: expected ','  stdDev: bad parameters   stop: error in chunk expression  >stop: bad action (must be editing, moving, playing, or using)  =stop: no action (must be editing, moving, playing, or using)  subtract: bad destination  subtract: bad expression  subtract: missing 'from'  Stack: bad stack expression  sum: bad parameter  switch: bad 'case' condition  switch: bad condition  switch: error in command  *switch: garbage where a command should be  switch: not a command  switch: missing 'end switch'  tan: bad parameter  %Operators there: bad file expression  Operators there: missing 'is'  %Operators there: no object specified  throw: bad error expression  toLower: bad parameter  topStack: bad parameter  toUpper: bad parameter  "transpose: bad variable parameter  trunc: bad parameter  try: error in command  'try: garbage where a command should be  try: not a command  try: missing 'end try'  type: bad string expression  ungroup: bad group expression  uniDecode: bad parameter  uniEncode: bad parameter  unload: bad url expression  unlock: not a visual effect  =unlock: no type specified ('screen', 'recent' or 'messages')  >unlock: bad type specified ('screen', 'recent' or 'messages')  urlDecode: bad parameter  urlEncode: bad parameter  urlStatus: bad url expression  value: bad parameter  value: bad object expression  Array: bad index  Array: missing ']'  $visual: double directions specified   visual: double effect specified  visual: expected visual name  visual: missing visual name  visual: not a visual name  $wait: error in condition expression  wait: no duration expression  within: bad object expression  within: bad point expression  write: bad 'at' expression  "write: error in source expression  write: bad file name  5write: bad destination (should be 'file or process')  write: missing 'to'  4write: no destination (should be 'file or process')      
 OK p +on mouseUp
  close this stack
end mouseUp
        8 | d                 	   e 
    
Perror Field  	                  0 H       
      	          < <         e Object: 
   
   	          ` ,         e Line: 
    Line  	         0 ` <         e 48 
      	         l ` D         e Column: 
    Column  	          ` D         e 1     Help p on mouseUp
  help
end mouseUp
       | | d                 	   e 
    Object  	         @ < $        e  
      	          ` X         e Bad Token: 
    
Bad Token  	        L `          e  
    Error Message  )p on mouseUp which
  if which is 3 and there is a file "petext" then
    set the cursor to watch
    open file "petext"
    read from file "petext" until eof
    put it into field "Messages"
    close file "petext"
    beep 1
  end if
end mouseUp
          ,                   	`       	  *   
 Magnify          14                 h Magnifier Card   	P on closeStack
  set the width of this stack to 256
  set the height of this stack to 256
end closeStack

on resizeStack
  set the rect of magnifier 1 to 0,0,the width of this stack,the height of this stack
end resizeStack
                    
Magnifier                  ~ Icons                          W 
Helvetica    	Icon 301   	@              -   	Icon 301   	P on openCard
end openCard
               .   	Icon 301   	P on openCard
end openCard
               /   	Icon 301   	P on openCard
end openCard
               0   	Icon 301   	P on openCard
end openCard
               1   	Icon 301   	P on openCard
end openCard
               2   	Icon 301   	P on openCard
end openCard
               3    	Icon 301   	P on openCard
end openCard
               4   	Icon 301   	P on openCard
end openCard
               5   	Icon 301   	P on openCard
end openCard
               6   	Icon 301   	P on openCard
end openCard
               7   	Icon 301   	P on openCard
end openCard
               8  
 	Icon 301   	P on openCard
end openCard
               9   	Icon 301   	P on openCard
end openCard
               :   	Icon 301   	P on openCard
end openCard
               ;   	Icon 301   	P on openCard
end openCard
               <   	Icon 301   	P on openCard
end openCard
               =   	Icon 301   	P on openCard
end openCard
               >   	Icon 301   	P on openCard
end openCard
               ?   	Icon 301   	P on openCard
end openCard
               @   	Icon 301   	P on openCard
end openCard
               A   	Icon 301   	P on openCard
end openCard
               B   	Icon 301   	P on openCard
end openCard
               C    	Icon 301   	P on openCard
end openCard
               D  " 	Icon 301   	P on openCard
end openCard
               E  $ 	Icon 301   	P on openCard
end openCard
               F  ' 	Icon 301   	P on openCard
end openCard
               G  ) 	Icon 301   	P on openCard
end openCard
               H  + 	Icon 301   	P on openCard
end openCard
               I  - 	Icon 301   	P on openCard
end openCard
               J  / 	Icon 301   	P on openCard
end openCard
               K  1 	Icon 301   	P on openCard
end openCard
               L  3 	Icon 301   	P on openCard
end openCard
               M  5 	Icon 301   	P on openCard
end openCard
               N      	@              O      	@              P      	@              Q      	@              R      	@              S      	@              T      	@              U      	@              V      	@              W      	@              X      	@              Y      	@              Z      	@              [      	@              \      	@              ]  @    	@              ^  B    	@              _  H    	@              `  F    	@              a      	@              b      	@              c      	@              d      	@              e      	@              f      	@              g      	@              h      	@              i      	@              j      	@              k      	@              l      	@              m      	@              n      	@              o       	@              p  -    	@              q      	@              r  )    	@              s      	@              t      	@              u      	@              v      	@              w      	@              x      	@              y      	@              z      	@              {  :    	@              |  <    	@              }  4    	@              ~  6    	@                8    	@                    	@                    	@                T    	@                V    	@                X    	@                    	@                    	@                
    	@                    	@                    	@                    	@                a    	@                g    	@                i    	@                k    	@                m    	@                o    	@                q    	@                s    	@                u    	@                w    	@                y    	@                {    	@                }    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                	    	@                    	@                
    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                !    	@                #    	@                %    	@                '    	@                )    	@                +    	@                -    	@                /    	@                1    	@                3    	@                5    	@                7    	@                9    	@                ;    	@                =    	@                ?    	@                A    	@                C    	@                E    	@                G    	@                I    	@                K    	@                M    	@                 O    	@                Q    	@                S    	@                U    	@                W    	@                Y    	@                [    	@                ]    	@                _    	@              	  a    	@              
  c    	@                e    	@                g    	@              
  i    	@                k    	@                m    	@                o    	@                q    	@                s    	@                u    	@                w    	@                y    	@                {    	@                }    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                     	@              !      	@              "      	@              #      	@              $      	@              %      	@              &      	@              '      	@              (      	@              )      	@              *      	@              +      	@              ,      	@              -      	@              .      	@              /      	@              0      	@              1      	@              2      	@              3      	@              4      	@              5      	@              6      	@              7      	@              8      	@              9      	@              :      	@              ;      	@              <      	@              =      	@              >      	@              ?      	@              @      	@              A      	@              B      	@              C      	@              D      	@              E      	@              F      	@              G      	@              H      	@              I      	@              J      	@              K      	@              L      	@              M      	@              N      	@              O      	@              P      	@              Q      	@              R      	@              S      	@              T      	@              U      	@              V      	@              W      	@              X      	@              -      	@              .      	@              /      	@              0      	@              1  	    	@              2      	@              3  
    	@              4      	@              5      	@              6      	@              7      	@              8      	@              9      	@              :      	@              ;      	@              <      	@              =  !    	@              >  #    	@              ?  %    	@              @  '    	@              A  )    	@              B  +    	@              C  -    	@              D  /    	@              E  1    	@              F  3    	@              G  5    	@              H  7    	@              I  9    	@              J  ;    	@              K  =    	@              L  ?    	@              M  A    	@              N  C    	@              O  E    	@              P  G    	@              Q  I    	@              R  K    	@              S  M    	@              T  O    	@              U  Q    	@              V  S    	@              W  U    	@              X  W    	@              Y  Y    	@              Z  [    	@              [  ]    	@              \  _    	@              ]  a    	@              ^  c    	@              _  e    	@              `  g    	@              a  i    	@              b  k    	@              c  m    	@              d  o    	@              e  q    	@              f  s    	@              g  u    	@              h  w    	@              i  y    	@              j  {    	@              k  }    	@              l      	@              m      	@              n      	@              o      	@              p      	@              q      	@              r      	@              s      	@              t      	@              u      	@              v      	@              w      	@              x      	@              y      	@              z      	@              {      	@              |      	@              }      	@              ~      	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                	    	@                    	@                
    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                !    	@                #    	@                %    	@                '    	@                )    	@                +    	@                -    	@                /    	@                1    	@                3    	@                5    	@                7    	@                9    	@                ;    	@                =    	@                ?    	@                A    	@                C    	@                E    	@                G    	@                I    	@                K    	@                M    	@                O    	@                Q    	@                S    	@                U    	@                W    	@                Y    	@                [    	@                ]    	@                _    	@                a    	@                c    	@                n    	@                p    	@                r    	@                t    	@                v    	@                x    	@                z    	@                |    	@                L    	@              Y  N    	@              Z  P    	@              [  R    	@              \  \    	@              ]  ^    	@              ^  h    	@              _  j    	@              `      	@              !  D    	@              "      	@              #  >    	@              $  !    	@              %  #    	@              &  %    	@              '  '    	@              (  /    	@              )  1    	@              *  Z    	@              +  +    	@              ,  - i301  	D                0 0       f   0 ( $ " !    @          <  @ &@ .  90    ؃ p    W                 ` p      g   0 8 < > ? ? ? ? ? ? ? ? ? ? ? 9     p     . i302  	D                0 0       i         ^ 4U   ` 0            _         ê  ?             k              ?              icon 1   	d                0 0       <                8   ` ` ` ` ` ` ` ` ` `    K  ` ` ` ` ` ` ` ` ` `     / i303  	D   ffffff             0 0       8               4 @             F               0 i304  	D              0 0       {  0 0 0 0 0 00 0 0 0 0 0 0 0 0 00 0 0 0    {  0 0 0 0 0 00 0 0 0 0 0 0 0 0 00 0 0 0     1 i305  	D              0 0       z ? ! # 'Ȃ / ?     / / / / / / / /     ? / 'Ȃ # ! ?    z ? ! # 'Ȃ / ?     / / / / / / / /     ? / 'Ȃ # ! ?     2 i306  	D         uu  ݂  ||      {{         0 0       w      `  @         @ @ @       @ @               @        R                        W    @                0        h                    @ @          ?               @ @     l      @ @ @ @ @ @  @     @ @  "             @ @ @  @      B   @ `   @ @         p    s   	`NP
$-PIA@IA@MA@%C@%FDI$HI$hD(2DHdHx	q! A  @A@@p     3 i307  	D              0 0       Y                                   Y                                    4 i308  	D           ݂  Ҵ     0 0       m       @      @      8 $ B  A  Ƃ    ?    O      ?  	              < > | 8     q     ?         ? ?        ?     5 i309  	D           Ҵ             0 0       n           0@ H@      Ă 	       @ ?    7               " 0 x |   | 8       
 @ 
R e 
U    v         ? ?              ?     6 i310  	D           ݂  ޳  pp     0 0       n        @ @     B   $ 
H 
H  P     @ @ ?    =      ? ?    ~ <     (  @ P ؂   `      #      ? ?    y    ? ?               ? ?   ?     7 i311  	D   EE                 0 0       + P  !   B   P      d     @ ?     # "  # "  "  # "  "  #       ?    L                    p P  !   B   P @ ? ? ? ? ? ? ? ? ? ? ? ? ? ? ? ?     8 i312  	D                      0 0       l  ؃   Ă ނ  >q     @ A@ ``     0 p    0 8   8     ^  8    < 8> > O?  ">߀ > ?     `  ǂ  p     T p                       n  ؃    w    0??       9 i313  	D                0 0       Q  0    @ @         @ @   0     G  ?    ?     Q  ?    ?      : i314  	D                0 0       n                @ @ 0       `  @ @       ~    j   
      ?           ~    q           ?        ~     ; i315  	D                0 0       S      @              @         L   ?          ?      V  ? ?           ? ?      < i316  	D                0 0       <              &             <      = i317  	D                0 0       Z      @ @                  @  @      V    ? ?          ? ?     [       ? ?      ? ?         > i318  	D                0 0       Q ? @              @ ?    > ?             ?    Q ?      ?     ? i319  	D                0 0       ] R @ A@ A@ B@ B@ DD @H @H @P @P @H @H @D @DB@ B@ A@ A @     X   :             _  J               @ i320  	D                0 0       d   
 
   #   @ @   @ @   #   
 
      R       ? ?   ? ?          b       ? ?       ? ?           A i321  	D                0 0       d ` ` P P H H Ă         ă H H P P ` `    R     0 0 8         8 0 0        b ` ` p p x x           x x p p ` `     B i322  	D                0 0       \ W   A  A  !  !     	  	      	  	     !  !  A  A        X      "          \ W                C i323  	D                0 0       e           ` `  `          T                   h                    D i324  	D                0 0       S            ` `  `     L                   V                    E i325  	D                0 0       S  `  `  `              L                   V                    F i326  	D                0 0       j       `  `  `              Y                    m                     G i327  	D                0 0       f              `  `       U                     e                      H i328  	D     ffffff             0 0       S  8 `    %       B  "    
     0     _   8 p p   q 9   p x ?     W        p @ H @ D @ B @ A @ @@ @            c  ?   6 σ? ?  ?       I i329  	D     ffffff             0 0       Q                       a                       U                        u                            J i330  	D    ffffff             0 0       b     0          ` `              b             x            \              p    @ @ @     {     ? > < <     ~                 K i331  	D     ffffff             0 0       `                           k                         ` @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @  @ @ @                                   L i332  	D     ffffff             0 0       ]                       _   ` ` a c c a ` ` ` ` ` a c o `      b    	  ! ! A    A ! !  	        i      闂   ǂ ᇂ ᇂ ㇂ G '  ׂ         M i333  	D                     0 0       Z   ? ?   	      @   A    0      @         *  > | x          j   ? ?   	      ?               N i334  	D                0 0       V  @     D "   @     D "        I    p 8       p 8        V      | >       | >         Q i337  	D               1 1       |?  /( 
/  ?"*"*"?"**"?"**"?"**"?"*"*"?       ՂUՂU݃ UU݃ UU݃ UU݃ ]]݃    ????????????????????????????????    R i338  	D               1 1       ?     ?    ̂  ? ?   ~ ?8x? @??33g?? ??3g3?? @??g33?? ???    ??    S i339  	D               1 1       ~  < GE	EGM` ` $e$$$$$		$$ %$ ? %$ %$ ?    x ??& ?  ;; ;; ;; ; 
l;l0 l lll l l l l l     ? ? ? ? ?     T i340  	D               1 1       D    * ? A/A  A/A  A/A  A?     @ @*@ >@_    >          b i354  	D                ff       1 1       c 	  E2@gH"H3ϒ`H$8 8 cGGG c8 8((F`	"_EL I"@          8 .0  ? 0    6    p 8 8 8 p       j 	  E2@gH"#H3O????/G	"_EL I"@      c i355  	D                ff33                 1 1        = 2    	 	
   " B ! "  
   @ 2rʐ#J~20	E	 2 J J 2     ?  s a a s  ? > > 8  s a a    ̂  9     ?̂   ?̄    6       0 0   0 0    P    < |     ?           9  ` ` ` ` ` ` ` ` `             %  
 
@  
x 
                           d i356  	D          DDDDDD          DD     1 1       ?@           @6 ? 6 6 7 7  x p    ` 0 0 0 0    = ?x <sd L dL dL dL d Lsx <?    E  `3333 `          P       
     ?          :؂ :؂ :؁    ?? > > ? ?        ?   ? ? ? ?     e i357  	D               1 1         0     @ @ @ @ @ @ @  `                     s  ?                     ?                      g i359  	D               1 1       ?`  * 1  	 	 	 		 	
	@	 	 	 	 	 	 	 	  1 3` ?` 
@ O    ?x *rfnnnnnnnnooooooogsx ? 	?0    1??    i i361  	D      ww               1 1          ` 0  0 `    ` 0 0 `   ` 0   0 `   ` 0  0 `            0 ` 6 ????? ? |> <  p p      h    ? |~ x> p  > |                     ?   ??   ?          j i362  	D            ww         1 1       7 ~ *  @    |   	   <   @  ~     / ~ "  @              @  	~     ' ~       À ~     7 ~ *          ~      m i365  	D              ww           1 1       s  	   @ @                            _    ?                      > p p p p p p p p p p p p    t    ?                         r i370  	D                           1 1       s                       S !                !                      Q    ` 0   0 ` ` 0   0 `      F  ?~@|ysgO Ogsy|?~@     s      w i375  	D               1 1       f   0@ D          b  F  `  `  
`  `   x    ^   8 >  ? ?   
 ~| 
 G 
 _ 
 _  _  ^     e   ? J                    x     y i377  	D               1 1       f   6@ D  6 0h d b   b  F  `  `  
`  `   x    _  	 9  ϐ O | 
| ( 
 f| 
 G 
 _ 
 _  _  ^     e   ? J                    x     z i378  	D          33      ww     1 1       F        C D D D C           C     < ; ; ; <        (     p 8       f    ? ?      ? ?      p 8         i385  	D                      ww     1 1        ??0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ??    [ s            `  ` `             s    _ c 
<x<x
<x<xc    M Ç Ç    x< p p p x<    Ç Ç     ?????????????????????????      i386  	D                33     1 1       n  ` `         .    b b b b b f         ` ` ` `    M            	 
      n  ` `         .                   i390  	D      ww               1 1       j                              l  @         @ <     < @         @     r         "                   z         *                      l i364  	D              ww       1 1       j   `           
   @       a   `                 1  Gx    X       
  ?8    h    ?     n i366  	D                    ww     1 1       f K                                      >            @ @ !      C                 ^                    ?      f K                     ?       o i367  	D              ww           1 1       Z  
  " C             C "  
     P    < ~     ~ <                 \    >     >        p i368  	D              ww           1 1       X            @     @             O @ ` p x        x p ` @               Z                   t i372  	D               1 1       f   0@ D             b  F  `  `  
`  `   x    ^   ? >      
 ~| 
 G 
 _ 
 _  _  ^     e   ? J                    x     x i376  	D               1 1       g   0@ à ?   t r   8 8b  F  `  `  
`  `   x    ^   <@ >`  1 1   
ǜ ~| 
 G 
 _ 
 _  _  ^     e   ? J                    x     v i374  	D               1 1       g   0@ à ?       8 8b  F  `  `  
`  `   x    ^   <@ >`      
ǜ ~| 
 G 
 _ 
 _  _  ^     e   ? J                    x     u i373  	D               1 1       f   0@ D        8 8  b  F  `  `  
`  `   x    ^   ? >      
 ~| 
 G 
 _ 
 _  _  ^     e   ? J                    x      i393  	D      ww               1 1       z   $ B  " B B   	" 
B 
B 
B 
B 	"   B B "  B $      l  @         @ <     < @         @     r         "                   t   ' C B # C C 	#
C
C
C
C	#C C #  C '        i391  	D      ww               1 1       j          " " B B B B " "             l  @         @ <     < @         @     r         "                   z         * # # C C C C # #               i392  	D      ww               1 1       p      " B B   " B B B B "   B B "         l  @         @ <     < @         @     r         "                   z      # C C * #CCCC#   C C #           i394  	D      ww               1 1        D  $ B  " 	B 
B  $ )" *B *B *B *B )" $  
B 	B "  B $  D    l  @         @ <     < @         @     r         "                   n G Z ' C  # 	C 
C $)#*C*C*C*C)#$
C 	C #  C '  G     h i360  	D             1 1               ? ? ? ? ?                              ? ? ? ? ?                       O i335  	D              33             1 1                       Ǆ W+(           ^ _ p _ p _ p _ p _ p _ p _ X        :      aa    
 0 0    
      `               Ǆ??    P i336  	D            33             1 1       k    $                     ?    c  ${{{{{{{{{       
      
      A ?????????     Z i346  	D               1 1         @ C
 C @a A


 a aÃ              ? < <b ?   >f   ~    > > =><>=< < < p=< p= | | p< p<                        [ i347  	D               1 1         @ @ C@ C@ @@@ @C@C@1C @@ C @ C@ G D  |@ aCaCcCC}&C= CC
@          ? < <c ? ? ?<<? < < < 8 ;  x?x<sx<3<< <<><>?   > >                       V i342  	D               1 1                                y                          ?             W i343  	D               1 1       m?       @!|  D  D#f  F/f  F/f  F/f  F#f  F/F  F/f  F/f  F/f  F  F?F F
    ?    { d    {          8     	? ? ?????????????????????????
 ? ?     k i363  	D                     1 1       T      @ @     ?      @  \     J   0 @ @          
       @p     B   ? p      
 p       Y   ?        X i344  	D               1 1       t  4 C C ` g 1 cbf0
3|
M
Cm~`
s y ߸ o`        f  <  >  p  vqf`=y@	_ Nh@!f 	   @  	       <                  f i358  	D         black  white    1 1         0     @ @ @ @ @ @ @  `                     s  ?                     ?                      { i379  	D ?         33        wwwwww                 1 1       {      @         @       @  I &    p  @    ^     0 h Ђ  @  
  4 h ؂  ` @       Z    @         @              # @ `  ؃ d &         +        8 ( 0        8 p       > |                ? ? < 0     \ i348  	D          33     1 1       e                       \      f       U i341  	D               1 1       I      
          E @@
@             Y i345  	D               1 1       n    @ @ @ G@ G@ G@ @ @ @]y@ @ @ @ `    e ???8 ?8 ?8 ???????
?~|    b ??     ] i349  	D                ww  33     1 1       \ W  $  "  "  "  "        
  
  
  
  
  
  
  
  
  
  
     T O                                      ~@ ~@ ~@ ~@    0 +              \ W                           i395  	D                           1 1                                             ?    |||ccc +_O>~s    L +    s s s s s s s8@ @ @ @ @ @ @ @    4 *@     6 b @  b V      ^??????????    ! i801  	D                       ! ! @ @        ? ~ ?      ?    ?          ?  ~ ~  ?            !  ! ?  !  !    !  ! ? ! !                (   (                        _     ?             ?    |   |   |   |   |   |   |   |   | p  | p  | p                 l    {  {  {  {  {  {  {  {  {  {     [           І І          9      ?        ?        ?                                     % i805  	D                               ! ! @ @    8 | | | 8                     > > >       )                8             ?   ?   ~  >              p y    ?  >     c 8 | | | 8     >  >  >                8             ?   ?   ~  >              p y    ?  >       & i806  	D                               ! ! @ @    8 | | | 8                  )                8             ?   ?   ~  >              p y    ?  >      !           W 8 | | |  8                   8             ?   ?   ~  >              p y    ?  >       ' i807  	D                               ! ! @ @                         )                8             ?   ?   ~  >              p y    ?  >        8 | | | 8     ^                 8  |  |  |  8     8             ?   ?   ~  >              p y    ?  >       ( i808  	D                               ! ! @ @    8 | | | 8                 )                8             ?   ?   ~  >              p y    ?  >         > > >      Y 8 | | | 8           >  >  >         8             ?   ?   ~  >              p y    ?  >       ) i809  	D            wwwwww      DDDDDD     ! ! @ @  *     І І І І Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ Ȇ І І І І І І        ? < x8 x8 x< x x 8 8 < <<       |                                   t         0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0                 
   @        p 8 < <    >                                      p 8 < <   ? < x8 x8 x< x x 8 8 < <<        * i810  	D                DDDDDD     ! ! @ @  U        $  $  D  D  D     @ @ @          @ @  D B! " D D 	H          ? < x8 x8 x< x x 8 8 < <<       ò          8  8  8  x  x               x 8 <  8 8 0 ` `     
   @        p 8 < <    g        <  <  |  |  |                 | ~? > | | x        p 8 < <   ? < x8 x8 x< x x 8 8 < <<        q i369  	D          33             1 1       z   ! ! ! !    0    ,! !x !D !B  3  !   0` 0      
       y         p 0 7     	      8   0 0  Ӄ 3 s     `  `    
         ? ?       ?    ?? ??????      s i371  	D          33  33    ff  33     1 1             ?  q```%`p0?>?                ] #  ?      ?        G  {   `   0   @ p        j         p 8 ? ? ? ?p x |       , i812  	D  wwwwww            3333     ! ! @ @                                        ? ? ?   |    [    ?       ?             ?     ?   ?           /     ?  ?         ?           	    ?       ?      ?                 ~           ?        
    # i803  	D                    DDDDDD     ! ! @ @  t        ?  ?    J?0d0d0d0d0d0d0d?         (   P             xxx  p  p  p   p@  p@  p@  	 p  x``x``x 
 p``xp``xpx  pxpxpx           	 p     	 p                                    o  7? ? ? ? ? ? ?           D                  %        ?  ?     ~ i382  	D                DDDDDD     1 1                          @  |>  w c c c w  |>    :                         ` 0                          ` 0 |>  w c c c w  |>      i383  	D                DDDDDD     1 1        @ ` ` P
 P
 H H H D" $ &d H X Ђ     @  |>  w c c c w  |>    A     0 0 0 8   0     @ @           ` 0     @ ` ` p p x x x |> < >| x x         ` 0 |>  w c c c w  |>      i384  	D             0 0       R                    R                     | i380  	D          ff         1 1       H P    s $ @ 
      A #         p  `    6         | >      H p     ?        ?       } i381  	D          ff         1 1        $ B  C &@  	 ( D   @  @        @  @        _ ?       < ~ <     q  @  Ђ  | ~ ?       ~ ?       p       < ~   ?        ?        ?        ?      $ i804  	D                  ff33  ffff  3333  33ff  ff33  ffff  3333    33ff           ! ! @ @   " !"  !" 3 !" 13 !" 13 !" 13 !" 13 " 13 " 3 !" 13 "3 " 13  13AEFEEIE	eXDGETVH 13QVTXDTtDTVTdIDU 13AIEFUEIDEeD 13QTFETDETtTV 13AE 3   QT AE QT QZT	TDItXDTET AEFeDGDEGEuDXGE  AD AG QX AE QXTtDEFTFEIEGET AdEIETEGTdTHG QT  QX AE  ATETDETDIGXTXE QDUtTZTUTDGEGT QT AI AD qu AD QDeEeHETDUT qTTdT
DETDGIt AH QU AD QV AE  TtDE\TdTHETDE    QEITDEIeEtDeEXVT  A
GDVTtTXEтQIEITDeETтQTDTтADuEт  UD   ATFUDEYD    AEGT
GTDG    QTThTEeEX    AGdETFTHE    QXTtEGET    AdEIE
dTHG    QTFE
UHUFT      
    ^ i350  	D                       1 1            8 ? p    x?x p :H	(O8H	(O8/ ? `?     b   ?    	              *                  ?   ?    _ i351  	D               1 1       f 
p8?> @ @ @ @^=)R%)R%^= @ A A! A! Aa A! A!   [      >BZ֭Z֭Bބ    # ?    " i802  	D               ! ! @ @  s    ? ? ? ? ???? 0 0  0 B3?3?3303330333033303303303 303 3?3?0 30 30303000 0 0 0< 0< 0 0 0 0 0  B        8 9    ??ς?ςB0  0  3<3<3<3<0 0 ?? 0  0 ς3<ς3<3<3<ς0 ς0 ς?ς?ς???ς?ς?ς?ς?ς    P    ? ?   ??    a i353  	D               1 1       Q     ?   @ Nr Nr Nr @ A A A     * ? 1 1 1 ? >| >| >|    Q     ?                ` i352  	D               1 1          ?   ?@ @ OOOOOO@ @ @@@@@@@   M ??080808080808????????????????       ?   ?    Y i601  	D          ̙             ) ) 0 0    ~   @ @   @             @  @  ?         i ~        |     ? ? ?      $     0 0       @                  ~                ?         Z i602  	D          ̙             ) ) 0 0    ~      @ 0 @  @ @` @ A @ @ @ @ @ @ @ p         i ~     ?w ? ? >G ? ? ? ? ? ?       $              @                  ~     ?                    [ i603  	D                     ) ) 0 0   ? @  @      *  *  *   @  @              H    x    	  
        @                          @   @            @  @     ?   y ? ?   o G G DG DG DG DG DG DG DG DG D @              ?                             ? ?     ê               ? p                   ^ ?                                           ? ?     \ i604  	D               + + , ,  K        #     	       | v|  |  |  |  | |  | 3|   ?6   9    ?            ?          I       0  0 Ѓ  p ?` ~Ѓ 0 G       I  !  ɀ      ?  p  p                                                             i387  	D               1 1       \ ?"??   *    p p       d ?     i388  	D               1 1       6 ?     { = } ~        @ @     7 ?      ?          i389  	D             1 1       u                   `00`      u                   `00`       + i811  	D               ! ! @ @  Ή   ?            .  p   a  ` $ a@?<  ?< ? ? e?  ?? 	? 	? ? ? ? ? 	? 	??  ? V? ?< ?<   a  `Àa   p              ?          | > ?? gy      ?~p  <8  <8 > x     >   ?  ? ?      gp ?8 < |      Ή   ?            %        ??????? ? ? ? ? ? ? ? ??????   %                ?       ] i605  	D  	              UUUUUU  ffff  ff3333    ff33    ff       - - ( (    !   "   " !" " 	!" !" # !" "$13$!"$AD3AD$DD13DADAD3ADDD13DAD3D"13"D!"3!"D"13"ADQRVR3!%e%DU13UADQU3QUDU13UAQU1QUU!U"QUabUvQUqwUwQUqwUwQUqwUwQU!qwUwahQUqwUwQUqwUwQUqwUwQq                                               ^ i606  	D  	                    33    33    ff3333  ff33  ff33       , , ( (  S                            "  2C$ 23CD "  3CD$  U%  3CD"    U%  3CD$ R% "U%  3CD$ U% RU%  3CD$ U% RU%  3CD$  U% RU  3D$ PU% ReU  3D	$ Re% UeU%  3D$ RfURUfVU% "3D$ UfUUefVU% 23CD$ efUw'3CD$w23D$wxwxww'3CDrwxwxw'3CD4D$wxww23CD3CDrwxw'3CD43D$wxwxw23CD43C$w'3CD3$w'"wxwwwxwwxwwwxwwwxwxwxwwxw        i396  	D               0 0       e  0@  0@  P@  P@  @             @ @      P P 0 0    Z ? ?  ?  ? `? `?     ` `        g  0 0 p p      p p 0 0      i397  	D ?                                      0 0       v  # @ @`@ A b  b  	0 
    `       	   $ B       (      `          3 @  @  @              ?   # |Ȃ w
 c߀ 7  }  @      6    @ `         8             {  ' @ `@  b` b 8 0 ނ   ?  	 8  $ B         i398  	D                       0 0         6 1#    8  A  `0O< `>0     8 p  ` ` ` `     p    8 (                 (    x      0   8  0             <        6 1#      A  `0O `0     ? # ````  p      i399  	D                     0 0        0 0     `a?G@ 	H%K??''#   ?       @                  0 0     `a?G@ 	H%K''#   ?        i400  	D                         0 0       B     8                            T y 6                y     |     8       J y                y       i401  	D ?                                  0 0        ? 
 x < >  	  7 | >   x >   pa8`< > > 
| ?    J P *                   {  T ^|   `  0 
8`|  px x   8  @    q   D`8      0 	   d       d _       p    Q Ђ  Ԃ  Ԃ  Ђ    P      `    :    (  (  ( P P (   @     U ? ????       i402  	D                     0 0         8 | # +0``8 @0̂:10!A! "&<8(2`cc*AvxX p`   8        ` 2        >  <      "p   	?        q    @ @   ? 1  3  "_    
    >    p           ????????         i403  	D                           0 0        <  & +l  ͬ {@  Ղ B     @  @  ^  q                  C  `   
( 	@  A *  ~     玂 [     f               <  > ?                               i404  	D                         0 0        
 @p`0 0!rCBDQFaƄb1D3Vwp>   p (00AGa	F?,0x   <  |      q -   s8< 8;`00`|``X`@` x p g?q4>  p  0 ` ?     N   @ 0@   `     
               "  # s # ! (          D 8       ???~~~?3??0x   ?          i405  	D                       0 0         
7`oooow;  p;l4?   ;܂ 8      N       0 @ x 8 0 0 
 ?       [ x ~ a       #Ă ` ˂ p           ` p p p      
??   ?         i406  	D                 0 0       {  |=   9 E U E ] C A      @@@  > >    h  s c ] A A "@ <0 ` `  x w w / 
 
   	Ѓ     u  F   * :     p | ~   O K    * o 1 `      y                >      i407  	D                     0 0       w  ( $ $#   RJ S!"D$A((	$ 	rN	"D@` @Ҁ  @         _        ͳ , W         =@ 0
 @ @    \    8 
x x0   
@ @@ ?                  8 < <? ????߀  @          i408  	D               0 0       m   "  ? ?      ? ?       
       m   "  ? ?      ? ?         i409  	D                               0 0       "     8 8      P     x | 4 > ? > | x        6                     f     8 8   
                   i410  	D                                       0 0          & &     Ȃ  2 I  	   + K 
           @    F               @ @      * @   P      ` @    F   P   @   0 x z p @ @   Ѓ       *     4     0 8 8         	        ? ? ? ? Ȃ  >   	                @      i411  	D                                       0 0         ! ! !" !" "  .@ @
 		  H @PDp  $  $ -  (pP H @ @ 	 	 
 
                    8 @   
            9       
 <           T       C D N  N  |     ]         #   p <0 8 0 0     
	 " 	  N         ? ? ?> ?> >  #  %             i412  	D                                       0 0       y  <FM\0      t  58 H  P	$8pF @ @ @          `       k  8 HM,9'3
w;2`    a!  	Z 6 o=  x 3ނ |        G 
0p
` l̀	  ! p   6 $
 H                      
      +    0 ` `? p ;       <~ςwp
      	  ?     i413  	D                                     0 0       5  ?      |     F   !   p@`     `   7       C ` 8 *P 
 qt,XH0 0 !H n (       ` p p `    ^    A0 `
~?80  A @x@@      9   ? ?~?>~|>~|>~|>   "           s  ?    ?     i414  	D                             0 0              7??Y; ʷ ꯂ 诂  }ނ ?     U  > * * " 6 >    @ " "`!` 5HPP               M ` p 8 8                     7???      i415  	D                         0 0          ?;n E8
U(U$U$U
D	yOH@PpP	H0
 0    
(4T 	AH @@@
@@p@ @    @  D@   P P
 P U@ 
QE@ *U@ EQ@ * U * U  U  U  U      @  @   P 
 T T U
@ T@ P@

EQ(*   EQ  U " P     8 (
 (
 (
 (
     	U@     i416  	D                             0 0       . `0 @ @@  0    &   @  @     " `0080`0     `@ `      @     - (????      i417  	D                             0 0       T < w_ 
 <    #  ?     U     
 ~ >p  @    `  ~       ~ x  ? ܭ              
    i <  ??         i418  	D               0 0       x ̃ V < xLtq`00c%+Q !`!  rb1	0 
8 A	 A`        @ p ` ?    { 0 X Rf  }0;8<d :  O 
 
 v~  ? ?     x   < x|?      ?      i419  	D                       0 0       o    ,h  1 !	 A@   	 Ap@@ 	 1 ς ,h P      i    0 ΂  
 ~   F~ ~  x=  v ΂ 0        @ 8 @     }    ?       ? Ђ        i420  	D                                             0 0          p    `   `	0   @@@  
 @DC@ @ X,$0 `   ?             `       R X >Ҧ ـnp387g<yg<yG<}O<}O<}O9G8' p0       g  -X I&     `Æ`0800008  d8#Ã      1           p    =    0 p8      @  @ P     {        ??  ?      i421  	D                 0 0         p      0  @<@<@<<<   @ @	@ 0       p         ??????       z   ????        i422  	D                 0 0         p      0  @<@<@<<<     @ @ @  0       p         ??????       z   ????        i423  	D                 0 0         p      0  @<@<@<<<     @ @@` 00     p         ???~~?|??
       z   ????        i424  	D                       0 0         p      0  @<@<@<<<  񂀂@@`@8 0     p         ???~~p????              z   ????        i425  	D                               0 0       1  8       0     m      `@ @@@@@ @ @ @ @ @ @           @    f      1 ;܂ ? ? ? 3̂ 3̂   x       4   p x p   0 0       2   p <  < x?     8               p<??<x?     i426  	D               0 0           ܂ n { @ @ o ~    ? ,L?d@#` ? ? ? ? ;    ; 3 f     9                             ~    ? ,L?d# ? ? ? ? ?    ; 3 f       i427  	D                           0 0              u ڀi     Y i     m w@Y          E CtB_r%Er	qB?KrCp wvUT    4 : 4  ` : ` 4 ` *     <         i428  	D                   0 0                ֿ  h       ` } u `     BBB?B?B)@>BBdB?B!BBCCC         i429  	D                     0 0        @ @ @ @ @    :  8r(R8r | 8s(R 8r   |               0
 |                      ??   j  H  H      9cǍk׭cǍAcǌ k׬ cǌ  A     Q??     i430  	D                 0 0       l0            2                | >@x{@x @x{@8{ 2CCCCCC B!B!   b ?  ? ? x ?ǀx < < < < < < @ ބ         i431  	D                                 0 0       xD        	        	   	  	  	  qわ ?<c   x D\?"@?_ \?@?f^^^^"^_ \?@?\?_2 "B!>B!B!" `   j # ?   # ? ! ! ! ! !     >       = = =  @ @     @               i432  	D                                                            0 0                       0       2       0          03113 
3DC4U11343 03DC4fS5s7w3D403fc6s7wCD0
3fc61CDBD03fc613D4343#"3D3#)3D33#)3DID3 3#)3DID3 0#)3D3 0#"3DID3:3D3:3D4D4DTD33D4D4D33D4D4D3        i433  	D                             0 0        
 P0
   @ `                             @ 
 P0
     }                                   x p >| . fg`z}nzl6xxx  . xxxt6nvyyfx@   >| p           a a  & (0 ɂ  Q ! Y               	 p? ???????? 
p?      i434  	D                   0 0                  i435  	D                 0 0        r     @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @     t 6      ? ? ? ? ? ? ? 6      ? ? ? ? ? ? ?         i436  	D                         0 0       i R` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` `     Y               ppppp    ^ """""*vvvvvvv"""""    Z ppppp                    }       i437  	D                             0 0        @ AAAA_AAAAAAA_AAAAAAA_AAAA@      ?>>>>  >>>>>>>  >>>>>>>  >>>>?    s                              * 8 | | | 8 8 | | | 8    * 8 | | | 8 8 | | | 8          i438  	D                             0 0       h  `XAA? 
 
  
 ? 
 
  
 ? 
 
   
   ?    Y  > >    @ @ @ @@     | | | | |    b      | | | | |    @ @ @ @         a  @ @ @ @ @ @      | | | | |              | ???????????????? ? ? ?      i439  	D                     0 0       p ? x s> 	bq fq"D@&@D MI3c'gOfX̓ȇ  @ @ @ [  9		  @ 0a   r     q  N   3;f32N' 6l d mIY3l S7x S6 Q> Y H l $     ?     5  < <      | | <     
 ?    ??    "  ?   ?   ~       i440  	D                             0 0       I  U P ah<	-JMd "J h  7 ,  `  @ `    R  %.@ /( tݵ</ x  @  }  k >  p    `   # L P   @ 	 ɀ D $  @ @ @        Y   3 / _̂ 9 1 g n0 ~8 ~  ? ? ? ~ >      0            ?  ? ?    ~xp | <              i441  	D                     0 0         ` 0    0
 @0$ 0    pgs@L`@C       @        ` 。    @    w   ?  ?  ?  "            0 `     
         ?  ??       。    @      i442  	D                   0 0         p  @ 	 
  @@@       @ @ @	 !   ` @ p          )`p??? !????xp       z   ????        i443  	D                     0 0       ,                      PpP             	     Q U U Q    ~? | x p x|~>~~> >  ~ >         M . * * .          : * * :    f                         i444  	D                             0 0       } ? @ @ j?        @ 	@v@@@@@@@@@@@@@        ? ?    oۂ G G oـ  
              
     o @ ` ` ` ` `   0 x p ` ` ` ` ` ` ` ` ` ` ` `            8p 8p      C ? ? ? ? ? ? ? ? ? ? ? ? ?     ?   ?               i445  	D ?                                    0 0       l P Ȃ Ă   @ n  Ȃ    0 @ x  	   
 @ `    A 
       p    - 
      3 D D H p    6 8 x      V  `      2 b  
  `"I F 1  $~vф    1  ߂       p      L  @ @ @ @         8           (  pn   Ȃ    2 >~̃      i446  	D                     0 0                       @  @            	         r    @    n    ?       8 @ } `      K  ^   w\ x      瀂 /   >         	 `   /         Ђ   ?   p       i447  	D                           0 0           @ 0  0    0  0   
    @C  @ @ @ @ @ 0`@   0d x 0b         G      ?    ?         q    p      
>  |    ?   < |           >   ? ? ? ? ?   H x 0`    -  ?   Ϙ    Ϝ              ? ? $  ?? ??         i448  	D                                       0 0       4    ? ? ? ?       0 x         x    *              @    7               3              9 `       ?       L  0        @ @ A @ @ a1  @    }  x ???,OGA @ @ a1  @      i449  	D ?                                      0 0       y         " " " >       ??0011   &            B                    2                0 p p p p p          + > > > >` >` >` `      f     > > > >            i450  	D                                           0 0       A           8 8 0 0 0    B 0 p `                ?     8 0 ` `           E         8 p         ;    `       0   ` @    =  @ ? *`                 | ?    . 8 8            9     ? ? ?    ?               ? ? ? ? ?   ? *          ?      i451  	D                 0 0         @   @       	 @  x  	J @  J J 	  A 	J @x         @  @       ?  ?B93s wx~w~??????>~x~? ?  ?     W     7 x   1y y 1  1 y y 1       z   ????        i452  	D                     0 0          jOC@@x>@|<@<x@x@x@@?  ?@x@x@x@<@<>@|@x@CO      q                                 z   %x>|<<xxx%xxx<<>|x        i453  	D                             0 0            @       8            @          a @ @ ` P 0P  P  H 0H hD $D $@ B B D H P         D                     @            `        U  8@ 0`    0  x0    "@            i454  	D               0 0             ?      >  >  ~ ?   p  `     c    ? ~ x      ?        z   ????        i455  	D                             0 0       {    ?"4" "T?#"#>#"%# >UT#" #>U`#@ "U #* ?" " " ?    y    @      @       @ @  D@     i 1       +  ]  ]  ] ?] #]UPWU@Z jU                                      | @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @  0    P        i456  	D ?                                      0 0                                        <    `  ~ | x p @  |     ~ /    8_~O}c{$gx > ~|    ^ 8 @ 	 
             `    @       c @ `         0        <             P      ` 8 x   0   0    X0           i457  	D                           0 0        @ @ @ @ @ @ @ @ _@ @ @ @ @ @ @ _@ @ @ @ @ @ @ @ ?    s ??7X`:Z=]:Z7X`?   ?7X:W`=W`:W`7X?   ?8W`7Z7]7Z8W`??    F                     E                    ?      i458  	D                               0 0       ~8`q`89; $;98`q`89; $;98`q`89; ;98`   yDB(B B(BDH$H@ @@ @H$HDB(B B(BDH$H@ @@ @H$HDB(B B(BDH$H@ @@ @H$HDB(B   1 1@Dl8l@D1 1@Dl8l@D1 1@Dl8l@D1   5  (   (   (           i459  	D                                                                              0 0      
!@UD@Pvp 	$	(J JW	#,yRSGZ@ƪzt3#̒p35\Y*y9zwzJD{AzvQ9UxZ
~SƚtgZYK|Y	Z[:8y,z*R J4:9iVZ V@kZ*	wYڂzW諻c5ƱFP3̞HDd*8 BDJȐZ @ʪxZw% zZ1%YU6(1X8.K"biP쪊ܠUWUyDPKT1ʂw*Y9W3sP,cyj	Y4: AaƉp)
\}sIZ\ 9	Xk	V
ZTSYkf Z]媳)DAgV:4S:@ȉ3sJq D ~
     GԮ￸     i460  	D                                                                            0 0       "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev "3CTev        i461  	D   
                                                                     0 0       !"03@DPU`f !"03@DPU`f !"03@DPU`f !"03@DPU`f !"03@DPU`f   qw  qw  qw  qw  qw    PU@D PU@D PU@D PU@D PU@D   pw 03 pw 03 pw 03 pw 03 pw 03   QU `f " QU `f " QU `f " QU `f " QU `f "  "    }}}}}` }}}}}` }}}}}` }}}}}`       i462  	D                                                                              0 0        " 3@D U`f  " 3@D U`f  " 3@D U`f w 	 ̂ w 	 ̂ w 	 ̲ 
  3 " 
  3 " 
  3 " PU D f PU D f PU D f 
`f 3 
 
`f 3 
 
`f 3 
         i463  	D                           0 0       9&fd   ($ $ $ ( ($ $ $ ( ($ $ $ ( ($ $ $ ( ($ $ $ ( ($ $ $ (  &fd9    
                          UP    { UP       ?          
    h U?      k    	 x |  | @< 0< <           ?    9????????????????9     i464  	D   	                                             0 0      Y   1 BDE 13 BDE  BDE@ V BDTDT EDE FDT e BDE  BT Q0 BET QU BD QU B QU 1U 1 U 3 U 3  3 03 03 U03 U0 QU QU U 13U 3Uf3Uw	 3 vwx  p   ww        i465  	D                                                                0 0      `  !"!"!" !"!3D%!"v7CT "!fw3D"""Thv7CT !"!	Dfw3D%"	IThv7C !	Dfw3$	IThv7 !	wDfw#"	vIThv !"
!awDf!"vIT !"!awD!"v" !"!aw!"" !! !v&!b !v&!b !R !%!!P[[         i466  	D                                 0 0                     !             	 ?   X v~ 8    4 
x ?~ sa@@?a               ` w  `          i467  	D                                           0 0                                    ?   a 
*QVPUP=
upwzpppsɰ2I
"A "    + 
QU
 UPDP B                  @             < p p           6@Ͷ`ݾp          ?     i468  	D                                   0 0               N    `  $"! P  @      `           @  	   8   w h @   _ h  H                    <UT$*UT$    t Y?   @  @ 0 @ p @  @ @UT@Ҩ@P@ @ @@ @p @ @ @P @ @ @ @ @ 	
jUTUT    1 ? ?     T  P             A     ?                                ????     i469  	D                                         0 0           @          @ 0 2  x< p 0 `   `   `̂ F    `>? D  # 1   `8 8        
` 7    Ђ y   p p 0 ? k _h   p ; ; s܂  o  ܉        @                      5     p  @    ?         ?   ? ?          ? ?      i470  	D                         0 0       c  ? K~  @?@@p81@a   `    l       @      @  @   ㎂ ނ ނ ނ ނ ㎂      l      S8  0 ` p 0 `  `  `  `  `  `  `  p 0 1 d 9 H   
                 v     6??????           i471  	D             0 0       k @ H   8 8 8 8 8 8 9   | >܂ o   `        k @ H   8 8 8 8 8 8 9   | >܂ o   `          i472  	D               0 0         >                                | 0 >               ? ?               0 >      ? ?                 i473  	D               0 0       |             ? ? ? ?                  L ? 
 ?    ?    >                  ? ? ??  ?    ?    ?       i474  	D               0 0       |                                  B          < 0                                     i475  	D               0 0                                  |                                            i476  	D                       0 0        
 @  @  @  @  @  @  @ " U * T 
 T 
 P  P  @  @       @  @  @  @  @  @  @  QU * T * T 
 P 
 P  @  @      {                  @ @                 n               @ @                               
       ? ?               i477  	D                       0 0       &    0    0 @       0        D  @ 
    U*U
U  @ 
 @     E @  @ * U U*U U@ * @  @    L    ?  ??  ?         i478  	D                       0 0       '   0     0      D  @  T   U@UTU@  T  @     D   P   U UTUP U  P        0     0     L                 i479  	D                       0 0       z                @ @                     @  @  P  P  T 
 T 
 U * U  P  P  P  P  P  P  P     @ @  P  P  T  T 
 U 
 U ( P  P  P  P  P  P  P     n                                             ? ?   
                     i480  	D                   0 0       "                
  " " " " " " " " " " "     @      ?        z   
               ?       @        ? ? ? ? ? ? ? ? ? ? ? ?      ?          i481  	D                   0 0       ;       @         @    q    	  ! A      > ?    >      T     > ~    ~ >        x     ?    ??    >        i482  	D                   0 0       &   @       @     ~ 0 X     @       
 @       @      j   h      7ww
p ` @ / o              p       ?              i483  	D                   0 0       R         @                   @          @ @    ? " " " " " " " " " " ! # ' /      @       ?      
                         ?  ?? ? ? ? ? ? ? ? ? ? ? ? ? ? ? ?      i484  	D                 0 0       m            @   ?   Ђ       X ` ` ` ` ` ` ` ` ` `      p 8        J                   @    s                ?          i485  	D                 0 0       a       / _    ?          X       @          p 8        &        @      k      ?     ?          i486  	D                 0 0       ] @ ` P h t   } @  | x p ` @    [                        &         @      k @ `                   i487  	D                 0 0       n  @  Ђ   ?  @               \       @      ` ` ` ` ` ` ` ` ` `     N  @                      s      ?                    i488  	D                 0 0         
 P ? ? * UT     
    A UT *    ?  ?      U 
  ? ?      ?  ?        i489  	D                 0 0       h     > ~ .      ?       ~ >        l                  q 9                   > ~  ?     ?           i490  	D                 0 0       <         UT       UT    UT     UP    L              UT      i491  	D                 0 0       }     @    g  ? ? ? ~ | | x x p p p        a       
8  @  8	 `
 @            @ @    -    @ x     `                  ? ?    ~         @ @      i492  	D                 0 0       e    @ @  @ p @   @ @ @  @ @ @ @ @ @@@ # |A >       +      0 `       Q        ?     ?         l     ?     ?         i493  	D                 0 0       d )    >  |  8               	  > |         ,  @   ` 0        Q    '          ?        j %                       i494  	D                 0 0       g    > |A #@@ @ @ @ @ !@  @ @ @   @ p @  @ @  @     +    ` 0  
       R     ?     ?         n    ?     ?          i495  	D                 0 0       e   p  | >  @  p   @                   $        `    Q @                  l   p                 i496  	D                               0 0       "             
 x      U  (~ 3~p0 ~>     K   `   <   0        <     J 0         
0`?    y 	????      i497  	D ?                                0 0         0  8@` 	 0 0 H"D$$ $@$ $ $ $" D H 	 ` 8@  0      
 T 
 @   @             (    @  @  P * P    e P   @      @                   @    k 
   @                  @   @ (  
    9   p          @      Y  ~ ? G G  ~>   ~        ?  ????????  ?       i498  	D                     0 0          
 B!< x8  8xP <r( p 
  A   `p Pr 0x  <8 
8< x!
      l  > B  
`?_
`  >            @        ????        i499  	D ?                                0 0               0  0 A@@
 
0P`PPÇP P P P

 @@A0   O       @     ` @           0      @ @               @ @    0     V  > n ,   ǀ<8?? ς ΂ n >     9       @ @ @              @ @                ?             i500  	D                       0 0         0 'Ȃ X4 
 * DE B A @ @ 
 
 X4 ĝ X4 WԂ Q Q Q Q Q S T T T S P H$ 'Ȃ        0   A @      @ A   0 'Ȃ                         0 0     t   Ђ 9 <8 .h ? ?          `      `      L    @           
 	 
         ?                           ?        i501  	D                 0 0          $ D$ $ $ $ $ $ $ $$ $ $ $	$ $ $ $$ $ $( 0   @    ~  X X*XXXXXX|XXX=X>XX
XXXX
XP@     V  )   @                           |      i502  	D                 0 0       x   8   wS? x 1;    ` @``` ` `  8`    c   r.`B   `! A  A AN  G     b     
Ђ = 
=t }  ?ނ _ ^~ } ~ >x > >~ >| > @         8  ????      i503  	D                       0 0         
 
 @ 0$`HEDJ 4 X    A  !   @	 @ @@@@ @ @          @  `     y    00 @ > @
`  ~      @ @   
`
   `   0                   0   `   `     A               @   @          0<x}|?????        i504  	D                       0 0       Ap  p  p   ?  1 	 &$$ L&@HpHHK:xHH4pL&@$&$ 1  ?   p  p  p     *  *  *         @         8 ` @      (  *  *     c  , p  { 
 	S  _Y74{ŀ7~ـ 	s 
v {  x         @       !         ????             i505  	D                       0 0       ` M \ , ,,, , , , , , , , ,?, , , \    Q L//<.;`.8d/</</</<..//(P/(@P//    ]                     ??    + 
      
       ??      i506  	D                               0 0       { p` ` ` ` ```` ` ` ` ab bb
b
b
b
b
b~~~
 
         o @<xy~  < |}}}
}|1 { w o      	 ?    F        `         @ ;                               {            i507  	D                           0 0       7                p  p P X H l `l ` 0 8    @ ` ?
`  `        r? p0 p 0 0 p 0 x ?x ?x    S N?   >  c .1 ' 7 sy8@`|>0?    I    8  >    @@@@ @ @                           i508  	D                                           0 0                t @    OAA`Q1:\
z^ z_   @  @ @     % e %          @ @    S @ @ @                  @ @    #   
 P 
 P   @    5   @   @ @          	 
 P                       ?           ?  ?        i509  	D         0 0                     ?   Âǂς߂     ?  }                   ?   Âǂς߂     ?  }       i510  	D                             0 0       q  / p  H ! K ! DA DA B ` @  q   h  0  `  @     p  ` A &     g  ) 0  0  ; , ;  = l ^ ?| y g  !w   9 n{ ߏ |    <     _             `     p @  
              @             t   p  x ? { ?        o
   
 ?  >       i511  	D                     0 0       [ 
       @ >     !$I)	  @   P %   x|>xpac @`    !   ? ? ?      A    	?ς      i512  	D                                             0 0       U   ~ " C    4|p0!@ ?    x 
        < x @    =       @ * E    @    @          E` *      <  080    ? B A @    < 8 @     ~      ?    x        ~ p~    [  	  ? ?       i513  	D                                                                              0 0      W     !2"# 1B$DB$ 0#DCD4D2 5CDFDdD4S 3BFtvwgGd$3 
PfDvwvwgwgDf 
Pfwvwvwgwgwf 
Pfwhwf 
P 
P 
 Y Y R% P  Z 	R%  ͺ] R%  Ղ] R%  ] "U" "  D JT P P  U     ?        ?              i514  	D                                       0 0         `   H@$@					
		
P0 @@@?
    Q   p 0   0     ` ` ` ` ` @ `    i  @R` 
/o@ gg?g?g?g      m    )                         @                   @      @     
 @``         @???     i515  	D                               0 0       
>  { <xx<w?   X   @   @   @       @        @          @                             0 ( H$ " !  ,h@                      Ђ 6؂ v܂   O   @ @ 
         @         i516  	D ?                                0 0       & 0  6 
  	     "    0  m      	  d` $&    , 8    
mI     ?    	 $@    9   ?       i517  	D               0 0       0      __     p    0      __      i518  	D                       0 0       ( 	         (       P     ( 	         i519  	D                         0 0       ^            $$?|*B*B?	$$    <                    H     " B  @ (   xx << xx    +    
         e   $  : z <@ *    ????      i520  	D ?                                0 0       =% B  `  [0  n @ Q A        z % P `   d   A  $ H  @         @             z @    @  > ? ?  @  ?       ?       @    ( " Q   p   $ , ,     /    @     (       t  2 A @ @     @       @       @  4 D D Ȃ       % w` `         > l H   ?        ?           	 i521  	D                                       0 0       ~   B     0 4    `  @ ` 
     c   @ 0 ( @      d    0 @    
  
  	  T  `         @ 	     e   B    `A        @       H H  B        3      	   适 @      b    @               ??  ? 
 ( @     @    [   Ђ   0      @	  a  @  4 D D Ȃ       .     @     (          4 0pq;(  @?@? ????
*
C        
 i522  	D                       0 0       n   Z   @ !  &  8  (  &  !  @      0 ` )    &s  G #  3` )          @        (            $ |     ?      L B @    ?   @   8P ! q s@         n   Z  ? ? ? ? ? ?  ? ? ? ? ?  ? ? ? ? ?          i523  	D                               0 0       { 
 L Â `    T@       0 ` (  &  !  @      0 ` )    &s  G #  3` )          @        3 0 o<  ~w  	               -    0 
        L B @    ?   @   8P ! q s@         }     P ? ? ? ? ?  ? ? ? ? ?  ? ? ? ? ?          i524  	D                     0 0       e  0     ?  *             ?    )  $  І  ؂  D @         c  0     ? 2 $   D @   ?     
 i525  	D ?                                      0 0       r  0        @ @           @  @ @ @ @     q  @ @  @ @                     `     i ?  ? y @B  3? ! @ `~  ?     4  `             & < & :x ^Ȃ ^ ,  X    +     @     =    u ?   ??   ?      i526  	D             0 0           ` <  |0      |?@? x 
   > ~ ~ <   
         ` <  |0      |?@? x 
   > ~ ~ <   
       i527  	D             0 0       v     8    @  8 8@ @D D D     8 8 #""   v     8    @  8 8@ @D D D     8 8 #""     i528  	D               0 0       ` Uqqqqqqqqqqqq!B!B!B!B!B!B!B!B!B    Y Tqqqqqqqqqqqq{{{{{{{{{    `       i529  	D                     0 0          @ "& Q  DƂ "   @     D "   a    t@     A A A "           p 8     A @ @p 8       w    | & . >                   # q  | >       | >  	     w    g o  >      i530  	D                       0 0       }    
    @ @      1 A A   (1 H` |( Hc("0Ha0  @ 80       |  ` `  ?     ?     ̂   <  ̂ < ̂  ?l ̃      < p     p `      p `    k  < <0 p Ђ  3p Ђ  p Ђ  p  Ђ  x ?         p   ? qa 	 ?         i531  	D                     0 0        0    8 ` ` @` @  A  F  Ĉ      @  	      q  ` @ @   @ G @ G @     q                 @     @       ?   _ @       ?     |             ?8?8?     0   : 0 ` p @` @ A F ď     	          ?     i532  	D                                     0 0       { ? `    Ȃ 0  ΂  F G a !   ! p` q  s<  0     `          a  8 x `                ?p 5Ђ 0 `      4  @     
  @                P    J 0            J     @     ` @       { ?      0    ~   *? ?   q s       ?         i533  	D                 0 0       m  `  `      @ @ @ @ @       @     >     S      ? ? ? ? ?           A ` p p x 8 8 8 8 <          o      ? ?          >       i534  	D                 0 0       r >   <  '            @, ^ 
  Q        c  
@    h 
 
p   ?  ? ?҂  WP Ϯ          0     |        ? ? ?              i535  	D                 0 0       
 @$@<< < < <䐂 $ < <<@< @< $ $ << < < <䐂 $ < < < < < $ $ <    ߷ڷo?Ã 5?oڷ޷ /?Ã &? ??      	    ` `   	   ! ! `~`  !  	    ` `   	       ``       ??     i536  	D ?                              0 0        ? 1` 8  fU\  DL  U\  U\  U\  U\  U\  U\ *                       [    UP  D@  UP  UP  UP  UP  UP * P    v   	 3030                         l x   @h    x @ h  x  h  x  h  x  h  x  h  }x    f                             K                   W ? ? ?  ?                i537  	D   	                                               0 0         "" ""  " " " 03 " 03D3 "3CD3 " "03D3 " P 03D43 P " 3   " 3cf3S 3f63 U " cf63QU " 3f3U0 3PU0 " 3w3U0 " 0sw73 3 0sw73 "03w383 "3s783 !0383 "33 "!03 Q03 "U" ""  "" " "     -O                      i538  	D                             0 0       w  ? O 	0x   7` pp	q	qqqqppp` p?       * @    ` ` ` =     # 0 ` p p p       <                 @       F  4?{xwxwx[x[x~??     F  ?  0y      i539  	D ?                              0 0              A @E0GEC@GA $ wt$GG`h03 @h @   		0
      w        @   @    @  `   @    ? @  @      Y  0  ( #Ă 
"D"D`#Ă0(P
G0DD G (P 0 `  P     d @   
P ( (@
P (P@  (S  @   8 P  ܀   =      @                 ? ?  ????		0       i540  	D                       0 0          _	QUXU UZPw ]UXq@  Ȃ  	   
 : g   
  	?x<    ; 	 UP @ @      @      @          ^ 
 pU@ *   0 @ @  	   (  . N       q}}}q        ? g     x<      i541  	D                                     0 0       f          P@8               @  x    {  A ]      0& G$F $G$6<0  _	 
P P  }  ` `        N :   @ @ @ @ @ @ @ ̂     2  2 0   Z     Q   
    
P 	
@     	 P  @ @ @     K "   "           @    @ @ @  @ @ @    &             (     0                ??              i542  	D               0 0       [ ? ?            @  " > A     E  , ~?  >    ^ !????????   > >        i543  	D                 0 0       f !?x'x'x'<C?=;;KKKKKOgG|G|G|G|    J    @                       4 8 0 0 0 0 0  0  0  0  0  0     m !???????!       i544  	D                 0 0         0  9   _  0 p  a 3    @  @ `0  A   @    @   w         ?0 x    ! @ @ ?      ` 8        B @ ` p 8 < > ?    x|           %            ?       ! i545  	D                 0 0       @  Ђ * P 
 P * J   N@ '   H $    o   	 @           p  p     @   P * 5X * X    0 @    Ȃ    3 @ @ @ x H P H 0 H  H            C     @       0 @               ? ? ? ? ?     ?      7     x x p x 8 x  x             " i546  	D                 0 0       ~ @            T  PV @
  , T  \  O '   p        v  Ђ   :  :  &/ U  ?  Q A   `
 ?  w w         
        ? ? ? ? ? ?     p ?          # i547  	D                 0 0       e    P       @  8  
   @*  ` ! 
      l `   \ 2   @ 8 , ƃ   x <` 0    !   0@     6 @       @      @    j    | >          ? >      ?      $ i548  	D                 0 0          (   `  	   H @ H @ 	@~>><@ @ @ @ @@  G @ A         a      @           8 < < < < < < <       8 
 ``


  À} |~   8 ? >|        ?  ?????????     ? ?      % i549  	D                 0 0          0 @  @ @         	  	  !	  	    @ @ @ "   A  	  @ @     @     D     @        @ 
      P `  @    @    
  	  @   
        0 @  @ @     q  1  	  	  !	  	    @ @ @   ǂ    @ @     @      & i550  	D                           0 0          G5 * "]Dp v                  \   p " D      @          
 @  T     S    8 p        8 p   ?      B         ?    ` U@    (    0            ? ? >|     #      p >0 |    ?          ' i551  	D               0 0       j          %    "  D    /    @ !  c  	  $ ( H P 0    V  UT      p    ߂ 
      0      l        %      ? ? ?     < 8 x p 0     ( i552  	D                 0 0          
 Z| !!!#$A$A$A$CB*G;HHHH|   @ @          !< @              0!T`  @     `  >^  0        a 
@     À À À À                    .|?.?>  p `       ) i553  	D                       0 0             @          UT  @ @ @ @ @ @ @  <x              =      ? <x <x 8 <x > ?                             UT          <        * i554  	D                       0 0             @         @ @ @ @ @ @ @  <x             ?     =      ? > <x 8 <x <x ?                                    <            + i555  	D ?                                0 0       \̓݂Mݵ;{s    p p 0         ~ !      @  @      @     U (   / _ ( .xP T 9@
 2 @    T         
    ?>  *UGU
W?L <  ?~ /Â A   @ 0   x 
 ?   X / U p        @    ? @ 0 
T  @     U UP T            C?Â(p?@ ?A  U    , i556  	D                 0 0       \       ?      g                         ~ | |     0            y       ?          - i557  	D ?                              0 0       }   p L [K |< G @x9 @ @ u @  @  @  @  @  @ @9 @ @ @ @ = @  @  @  @  0          w  "  
     
 .U 
 UB 
 UB 
 T 
D T* 
T T( 
 UB 
 UB  UB  @     t 
 P  * RP  * * P * UB * UB * U@ *  T *T T * T * UB * UB 
 UB 
 @       |  x     h                              (   *                 ?               ?        . i558  	D ?                                  0 0        |  x ?$ CD 	1b~$!",!D4!-U!!!!!!!!!!!!!!!"$(㌴0>    p   < x( S @ N  ;Ȃ  w w wP v wP v wP V WP V wP v wP v wP v vP t p@    z   ( P  P  @                              ނ ނ ނ ^ ނ ނ ނ ނ ނ ނ ނ ނ ނ ނ ނ ނ ނ ނ ނ ܂ ؂ Ђ     V @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @    *              = |   ?  ?	>    / i559  	D                               0 0            +    	  	      ? ! ! - % )@%
%%`-P
!P!0!(!(!!!?
?
!
!    v                                 u p p p p pP pP P Pp P p @P @pP Pp  p  Pp Pp p p p p p p p p p    j                              J                                    @`pp088     0 i560  	D                       0 0       d [     x    r 
ʤ  *  *  *  *  +  *  /@  *!=   * < @ (         Q            @             M   x@ @@ @u@ )5@@@   T  P      3     @   
    =    t  ?  ????????? ? ?         1 i561  	D ?                                  0 0       }  8`                         i  /:%j?+?%j?+U!jUSjzǚ  @    n  @ d ! e A d A e Ae Ad !e Ad !T`  8a      %   @ @ @ @              [                         B  ?        2 i562  	D                               0 0         @   `      (  $ " @! '`@` P`h	8H
c	Y0P)p
6  B` !  
 `     Q          ?  π  p 0     j       @   ~ 	 0  ? @  `    ~       1    p   @  p        9   @       r  9               ? ???   ?         3 i563  	D                       0 0       n  h $  X   P @(   
  @#d\&?h  Bf8 !8  L 0 @ C ̃ p    7  x * >  π<0 | |3 >     b 0    h0 4  
0 L  @x #     0    O ? < 0    /    s@p 9 ǂ | 0       v  x    ?   ?       p     4 i564  	D                               0 0         ? 3 0 0 0 0                8 0 0 p p ` ` `      e   3xpH gg?yg0|phypyx`0    q f?3C3	C3    { 
 `0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
03?    H    ` ` ` `               ? ?        5 i565  	D                       0 0       }  s `  H @ ` ` ` ` ` ` ` p p hhÈdk     D        h  / + . @/+.U/+U./U#U/ /U#<w8      x 8    A   @    @   @    @           ~ ~              |         6 i566  	D                       0 0       q %    	  
 
 
 
 
 	 M@@  -  h m      H  (        d   :  lB C C    d I $@   w 7       P    @ @   @        @             8 8                 ?       7 i567  	D                                                 0 0        ?                                                      ?      H x hHP_P    y  3 	                                         %        
 	       @     ?????????????????????????????    8 i568  	D                 0 0       x 8 D G    "    O ]- 9      0 0P `! @ ` @      
       k 8 8    t  
 ] @           
        Y " "     > ~   
   ? ?  _σ      ~ 8 |      ?  ???        9 i569  	D               0 0       ~ u    (D᐀D!) 	 	9    @ @ !   ~ ux {`ooo|o`xw{>w{g{W[X?]߿]c | }        : i570  	D                                           0 0       v                                              D D (                        a      ` `  oo                        | 8 8                       ???    ; i571  	D             0 0       }  σσ?  3;   }  @ @ @   ` 0           0 `    ̂  Ă         < i572  	D             0 0       | 8    @ @ @  @ @  @ @      `        `      `  8     | 8    @ @ @  @ @  @ @      `        `      `  8      = i573  	D                             0 0                                         Jxs~w}w~w|ww;wWwo>wo>wW^w;wwwwg
??~_}c|     x                                 k          @ @ @ @                @        L    %    D(<@$@($D=     p        > i574  	D                     0 0       L@ ՃU @ ՂUQ @ U @ E @ TEQ @ ՃU !BcƄ    J            ` `          < ` `         B $       @    i@ ՃU @ ՂUW    @` uU    Lcw]  BLW]W @ ՃU !BcƄ     ? i575  	D                                         0 0       x ^   0 @ 
 @  `  @ @ @@@		D@"!I @ aL  q8 >         .  ?  ?         @       >          A @             ` @ @         !  ? ;        "     6 n      "             ^   ?         >         @ i576  	D                                                 0 0       q  0 ȃ @ 	           @   0     *              " p | | x x p ` @    2 0             .       ? ?     . 
 T 
 T  P  P     1 T 
 T  P  P  P      0 !              ~  ?    ?      A i577  	D                                     0 0       v     V   | p? `? ` ` ` `  `  `  `  `  `  `  d ? | ? | ? ~                     @ @        H D D 
B ~ @ @ @    <       [           @     @ @ @ @ @ @    @                   1       p 0 8 8 <     5 * U     : 
 U  U                     B i578  	D                                                            0 0      ^      " " " 0  D3" D3" D3" @0  D3" 	DU3  
DU`vw @P`fvw DUfw DUifw DUifw @P fv DUi DU 9 93 3 3
 03 03               C i579  	D                           0 0         x   0     0             0       ?     Z  ? K ?0x
?    + @ F       0      F       0       ` @ @ @          ????????  ?      D i580  	D                               0 0       o ?   8 p   9 ! 9 !܂ !` 0    0 `   ~     S   8csoscsos#  } >    B   @ @                  * ! ! A A   @      ?    b ? ??          E i581  	D ?                                0 0           9      J             @ @ @            @ @ @ @ @ 
@ @p A B D @H  P ` ` P H D B A @ @ @  @ @ @ @ @ @     ??#????>=.~;77/?~(>1>;=>?????????    !  ? 0                
          F i582  	D                       0 0       | ?@   
⍶bb 
"bb 
"bb 
"6Sbb 
"bb "b   @ ?    r ?p ` ` ` ` ` ` ``"`A`A`g p` ` ` ` ` `     r                     ?    H 	I$I$"I$I$ I$ I$ I
I$I$I$    q ??     G i583  	D                                       0 0       }  *??W+>=W/:85W8*9_9*99*8C<8+??.??>?P>>>=P>:>5P>*?X?*p*?W   h        @             @                  D      @             @     @   "          @          (  @          @          @     @     ~  @ @  "@ @ @  @ @ @  @ @ "A  A A A  A A @            *            >                {  ????????????????????????????    H i584  	D                             0 0       G5g>}?~g?   ~       E    0@   0         
    0      G |        @  `    0      <     6  0 ` 0       p    8     ) `                I i585  	D                                                                            0 0      c  " 3D " 3D " 3D " 3D " 3D PU`f wPU`f wPU`f wPU`f wPU`f w        03Ђ݄ f
03Ђ݄ f
03Ђ݄ f
03Ђ݄ f
03Ђ݄ f
    ߆߂ @ 
@  @    J i586  	D                         0 0          @    @                         UPT@T@  *T@*U@*U@*U@*U@*U@*U@*U@*U@* U@     UP*T@ *   T@*T@*U@*U@*U@*U@*U@*U@*U@*U@ U@    c                           r @ @   @  @                           K i587  	D                             0 0       `   
 " B             S UT*UPUTjj5PUXZ, !hW**UPUT*jUTT*UTUT**UT*UTUT*    V *TUP
*P@B*!TUP ( (UPUT**UPT**UTUT*U
T**UTUT*UT            0               V     L i588  	D                             0 0       6  " A    @ <              @     @                      s *U@Yup?> *UT*UT*UT*UT*UPUT**UTUT*UT*UT*UT*    o U AT@
 @ UT*UT*UT*UT*UTUT**UPUT*UT*UT*UT*UT    
        " A  ?    M i589  	D                   0 0       {  ƀ 9 @ @ @ 0K@ @3 @ @ @ @ @ @ @ @ @ @ @ @   0         v   Q  Q 
  D  D  D  D  D  D  D  D@  D  @    m D F S  K ".  .; n; n; n; n; n; n ; n ; l 0 @      ǀ     ?             N i590  	D                   0 0       m   
ah fY&`*` 
 	      ` 0`    0 ` c , 0    c  
 DP +ePGUP*~UP	UPʪ UPJUP  U  UP 
       [  "  4P PP* UP
 *UP UP
UP 
U@  UT 
 U@ 
     v   x      < 0     O i591  	D                         0 0           ( @@@ I@ )@ )@ @ @? 0 (* (ւ '*  T    0 @ Â d          U * A * A *    j * U U " U  U  UB  UB  Ԃ ( Ԃ    ? <   x     $  P    
 U@  U@     )  D $ $             ? ? ? ? ? ? ? ?             P i592  	D                 0 0       }x ?       '    '       '    '    ' 8  g  `      ~     |       w r  ?               | ~A         }                                 q ? ? ? ? ? ? ? ? ? ? ? ? ? ?     Q i593  	D                 0 0       }x ?    / ( 
 (
 (<
 (~
 (r
 (%
 (` (C (!
 (
 8
 f

 ` *` Z Z     ~      |       x /              <   A  ~A           ~  1       q q     @ 1                 y ? ? ? ? ? ? ? ? ? ? ? ? ? ?     R i594  	D                 0 0         @ 0 0 p  f i i    Fp 0 f ` c  `            ~      |          Ă     A                       j 	        A  ~     A              Ă  ?          ? ~       S i595  	D                       0 0       {  ( D   ( @   D "  A D"
*T  P  @              s  8 |  ׂ  u   > w w , A  A   ~          C    ( P  @                   8 |       ?       T i596  	D                       0 0         1 @ r               @      (h(¨ŨʨؠP@@A B  D  H  P  `        ?     @      Ѓ   @        ?            @       P   p      /Ђ _ ? > < 8 1 #  '@ / ? > < 8 0       @ @ @ @      ?        ?             U i597  	D                       0 0         1 C@ P  	       @  @ @A B @D   P  `     }   8 p    @      ȃ ( H       - [           @       P   p      # C # # # # # ' ? ? ? > < 8 0      "              ?        ?             V i598  	D                 0 0         `  a?@0a  	@p8@p8@@	@@tTDHDHI HI L $ $$$  p?      q  p8   
   p   p ? 1 1 3     Ƀ Ƀ Ƀ Ƀ y     o @     8G p>  ; @ D+ D; ; $6 $6 "6 v l l l | px              
        W i599  	D                 0 0       vs   `    @         @ G D @ @ @ @     @ G D @ @ @@@          ?                           { @                               ?         X i600  	D                 0 0       v   `    @         @ G D @ @ @ @      @   4 T @5 F           ?                 Ȃ      8        @                  ? #  # c           ?            - i813  	D                     0 0          @ `   X l # {  _ /     !A                ȁ  Ɔ l <     |  ?  O '  I  @  Ѓ     @        ߃  7 { 9     f      
    > ~ ~ ~ ~ ~ ~ ~ ~ ~ | x p ` @                                       ?      . i814  	D                 0 0        @       !   @ ` P hT I@P(JʂJ
  K *        z @       ?  /  
# A  O  ׂ  p  0   p 0     c      0?          ~ | x p ` @     @       ?       ?         / i815  	D                         0 0          @      @      @   ?                             ?          . ;    
UT
 UT
 UT
 P
UP

UP
 P
UP    } @         @                           @  @  D  D  D@ UP
 UT
 UT
 UP
UP
 P
UP
UP
                   ?   ??????????????????    0 i816  	D                         0 0       ^             p      N UP* UT* UT* UP*T P*UP* 
UP*T P*UP    Q *UT* UT* UT*UP* UP*T P*UP* UP*    O                               U      1 i817  	D                         0 0       S 6  8 & " " B D D DD D DD D p      S UT *UT* UT*UT *(T *(UT* 
(UT*(T P* UP    S * UT*UT* UT *UT* (UT*(T *(UP*  UP*     O                          8 0 0    M       2 i818  	D                     0 0         
  
 
 
 
  
  
  
  
 
  
 
 
  
      P p P p P p P p P p P p P P p P p P p P p P p P p P     {                                  D	C A      
    3 i819  	D                     0 0       x  
  @( @   @  (  @
   
  @( @   @  (  @
      `  @   ? ?     @  @   ? ?     @    i   o0 `    @ o       ]0 `    @ ]        : 
    ,  
          ????     4 i820  	D                       0 0                                    0  `   x     ~<~K~~~<~ ~  ~      |x                             p   ~<     Dm VU E D    ?       ~<     5 i821  	D                       0 0                                    0  `   x     ~~kw|~w<~w|~~ ~  ~      |x                             p   ~<     >T4    ?       ~<     6 i822  	D                                     0 0        0 P  @ 2 z  (P``	@		 	@~a B@ < 0 0@ 0 0 0B 0 0 0P 0?Ѓ      G   @         @      
  (    Y    
        
            a ` ǂ + { z x_ x s `~` ' _     ? 	@      O   
  
  
  
  
  
  
         : @ @ @ @ | @  @  @  ?     &           @ `     x 0 p    ~       7 i823  	D                             0 0       }   E `  @ A `@
@ X @ [ " b@ ` ? B "        d Q*:^?y_ߟ?_`?@_y?l_? | | | <          
 P      
 . ^     ? ~ >         8 i824  	D                                     0 0       ~ -
 ` -    0  0  (  (  $ $ " `      P   /   t  @  ,< HP      C? !          _    L ` BI                 
      R 	$ @ @ @ @ @ @ @ @  @   @ @ _ @ @    $  
 UP 
 UP  UT     j @            q n /?  
      @ U@ 
 UP  UP  UT  0 p p p X (     2    @         @     
             ??  _     9 i825  	D ?                                0 0        l m m      @ @      F  @                           /    r 0 !$ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @    l H                                 |                        =  UT  U U U@  U@ * UP    g               +              ? 
 U  U U@  U@  U	P * ?     	l ? ?  8             /     : i826  	D ?                                0 0       z    ` R       p P   p P   p P   p P   pP   p` Q &      x    U  U 
 U 
 U 
 U 
 U 
 U 
 U 
 T 
 @ 
      t   * T  T 
 T 
 T 
 T 
 T 
 T 
 T 
 P 
  
     *         0     W       ?        8 ؃      ;     @   p   |                   ?????????     ; i827  	D ?                              0 0        @       D  @ @  1  	 M >) A18 "  
  0 P   @ @             f @    ܂  w ?t  @;   
_  
U  
W    ;     D "   @            @ 
  @     _ @      
  @* T  T  P  
 @  
 UD 
 UP    W   
  * T  T  T 
 P * @ 
U 
 UD      @       ????
        < i828  	D                   0 0                            @@~    } n ; n ;n;n;` ;n;` ;n;` ;n;n;n:;l.n8;:    [  D@  DDD DD DD DDDDD@D    &    ~     = i829  	D                   0 0       ~                  @@~    L DDD DD DD DDDDD@D    n ;n;n;` ;n;` ;n;` ;n;n;n:;l.n8;:     ~     > i830  	D                 0 0       n   8 H@ @@ @@x@@"w""x @D D #@ @  ?    d   ? +  ?  >h ? `  @8  `` 0 0 0 ` ?     P `     ` ?           0 `    {   ?   
| | ??     ? i831  	D ?                              0 0       @ @ @ @A 
OP?P@`@j
@    ?   ?           { **** *            U  UT(*@T @T@T
 P*   @* *	
UT**     UTUTUT PUR  ?UT kꂪWUTo_PT~}_Tzu@VkT ^j>T |j UjUWԈ     P  '      @*         A     @ i832  	D                                   0 0        *    
0?H@ 8@j
@    ?   ?          z 
 UT  UT  P 0  U  UT(*@T @T@T
 P*   @* *	
UT**     ` ` ` ` ` `      
            gǿ ?UT kꂪWUTo_PT~}_Tzu@VkT ^j>T |j UjUWԄ     
P  '     @*    <?    A i833  	D   	                                               0 0      +        !  "  "! 0 " 
3 ! 03       A    A  PV qw`e  PV `Xe PV  `e              ?    ?   ?       @     B i834  	D                                     0 0             @    B             @    >@    @@ ( @          k  	    < x                     # ?   ?     
 0     
 
            ?           ~       ?      ?    ?      C i835  	D   	                                             0 0              # 03C  3CT  3CU 	0T  U       a   a r    	a p r   p pr (  q               ?    ??   ?           D i836  	D                                     0 0       e UP                    @    & UP  P  P  UP     l                             
      i ?                                    ?    X     DpDpDpDpDpDpD@0D@0D@0            UP       ????????????????????     E i837  	D                       0 0        ` `````` ```` ```` ```` ```` 
```` `               ? ?    # D D D D    |D        F i838  	D ?                              0 0       p   z j Z z   IRJ IRJ wIRJ PWrJ     $ @ @ @ @     S ? ? ? ? @ I$$@ I$$@ I$$I$I$$    4     $$ $$ $$            mW    
      b     G i839  	D                           0 0        ?` ߂찂 4  4tԢ   
4tԢ   <4|tԢ 4߂` ?    u   @ F1J
RLcHBHBD!@ F01JPRL`cH@BH@BD !@ F1JRLcHBHBD!@       R 	`  	 `	`  	 `	~`=  	< ~`    ? @1! @01 ! @1!    y ??     H i840  	D                                         0 0       b < B !$ D H <  0D  @ @@@@@@@ @ @ 0     <  8 0         F     X \ < D | E +  7      9 @ Ђ ? ? } j ;@ n : T 0     8  `  ?Ȃ > ? P =  )@  @    >    @ 6  t $ ނ         g < ~ ?< | x   ??????     I i841  	D                 0 0              
 @ @        B !       ` 0 `          a   
 
   p x  ނ     ~ 
                              
         J i842  	D                                       0 0       -         @ @         U     QP * T " T  T " T * UT  UP *    B 8  (?P s*gU@"@  @ @"T ? ?       @ (     J @  X ,  
    !+  + V@ UT!*p<    +      ? ? ?      c          @???
??<     K i843  	D                       0 0          8 s 308s ΄ AE((((((((((((((E@     j  0 0  ?0  @8NzhNzhHh@
hBJhBzh@hH
hNJhBJh@
hHhNzhNzh8    f   0  @ @               @ ?     H     
 
    
             ??????????????    L i844  	D                     0 0       w          T 8  8 T                    @  ؃ l 6  
 L !     @h   i` % 
؂ 
  8 
 ʂ m   a  @    v 0      b !  @      4      ă b 1   @      v         A  @     @    @         @          p   ~ ?         |   } ?                 M i845  	D                     0 0       ~  0 @ B  0  @@@@@@@@@@@@@      " " >  <0x ` 0 `    U  ?  2>             p p      ?   < ?   > > >  <0x ` 0 `     N i846  	D               0 0       u p֭֭֭֭֭֭֭֭֭֭֭E֭֭֭E֭֭֭֭֭֭֭֭֭P
TM * * @     @ @ @ @    u p֭֭֭֭֭֭֭֭֭֭֭E֭֭֭E֭֭֭֭֭֭֭֭֭P
TM ; ; @     O i847  	D               0 0       _      `   ` 0 x x x 0          j         p p p   p x p s | `                  `   `   p p> | >x x 0  pxps|`         P i848  	D             0 0               0 |   o o ĝ c ĝ o o /   ? ?                     0 |   o o ĝ c ĝ o o /   ? ?              Q i849  	D             0 0               0 ~ ~ ~ ~ n n n ĝ o o /                         0 ~ ~ ~ ~ n n n ĝ o o /                  R i850  	D             0 0       `1>\??7731ϙ377_```````
`   `1>\??7731ϙ377_```````
`    S i851  	D             0 0       } xGOOOOOOOOϏϏ    } xGOOOOOOOOϏϏ     T i852  	D               0 0            ?#B                       Z 	{B!                   ~         ?B!                   ~     U i853  	D                                                 0 0           2s D !BB!B!  !B-uz3x!PB @ @ @ @ @ @ @ @ @ 
@ !@ !@   a     .  p            ,       x | <     &    < < | x      ( ` 8 <          (        `    .        @   Q 
    .       @  A "          ???3!B          
           V i854  	D                 0 0        p    " F  ! B( DP H 	Q@     Ђ 	0  $ H    @     !      | p   ܂  p  = ; 7 . l   @     0 `           :      @                p       ?    	      0  < x      ? ?       W i855  	D                 0 0          ` H   < 4 ( 0 ( 4        @  O    @  	    $  H 0 /   @      x     x p ׃ σ ׂ ˂     ?              Q   x p   0 `       0 `           3           ?       ? ? ? ? ? ?       X i856  	D                 0 0          @     C L  Q # 	D D %R B  @W(/ ܢ <D !r !q 0  (@ $  	" Ă H P     v     <p k8 8 p  @ s  = j 8 P  !@ À           l @ @    8 p  !     8 p  	 c    8           ?        ?     ? ? ? ? ?           Y i857  	D                 0 0       w  
 
 
 	B L Db " QF (  
, X   A` 	@@	%@%$e H  < !@ >(  G   !     b   x  \  @ 8 p     > |    À       h            @   :    0X p  ǂ       |      '        ?    ? ? ? ?ǂ ? ?      Z i858  	D                 0 0                @    B @      H `P '  /  /  /T  -  *
  $
  
@ 
 S              ?   ߂ >  
  `   o 7   	   
 @      u      0 `       0   @ @ @ @ @     ,             ?      7     ? ? ? ? ? ? ?           [ i859  	D               0 0                 @    	  *  @!  @!  @!  @!  @!  @A  @  ? @          @   0 `         ( h ؂ . `  ߎ          =       < y   ̂  0 ` <    H   8  x   ! # # #/ #/ #/ #/ #/ #O # # @   ? ?@       ?     \ i860  	D               0 0                 ` @ `         0 0 ` `     @ @    , ` ` `     @ @                        0 0 ` `     @ @     ] i861  	D                                     0 0         @   0 ( d F E  	@ 3    x  6 % ΀ @ 0 P ( B !  @        1   @ 
  
    P     $  @ 
 @ 
           ( P  @    3      p    0 p     ]  @  @  @ 
   @  QP ( P 
(   @     U  @  @ 
 @   
  * @ 
 P  P  P                   ?        ?          ^ i862  	D ?                                0 0        D       @@@ @   
                 m @                           @ @ @ @                   ;                   D             _ i863  	D                                                          0 0      ĕ  !32" 13" 132  !3"   12 A  1#"  Q 132 T P !3"  U 12 aTt !Q !#" AU 1 12  !3# 1#"FE 13# 132Tet !3# 13"VE 13# !32Tet !3# 12"VE 13# !#2Tet !3# 12"VE 13# 1#2Tet 
 !3"VE   12Tet   1#"VE   132Tet  13"VE U 132Tet U 13"VE  !32"Tet        ? ? ? k? ?<?<?~?~????     ` i864  	D                       0 0       y                                 `                            o ~ | ~ x ~ | ~ Uw | ~ p ~ | ~ x ~ | ~ p ~ | ~     ~    p                            a i865  	D                 0 0          P H $ R  @ 	  "@ A `    
  @ ( A  ԃ  p        @    _   0    @     < X  `     < X   P     N    @  P  
  ( P  @   
   p       p x < ~     ?        ?             @     b i866  	D                               0 0         G@ .                t           ` ` ` ` ` ` ` ` ` `          t           ` ` ` ` ` ` ` ` ` `          t           ` ` ` ` ` ` ` ` ` `               c i867  	D                                                          0 0      Õ  !32" 13" 132  !3"   12 A  1#"  Q 132 T P !3"  U 12 aTt !Q !#" AU 1 12  !3# 1#"FE 13# 132Tet !3# 13"VE 13# !32Tet !3# 12"VE 13# !#2Tet !3# 12"VE 13# 1#2Tet  !3"VE U  12Tet U  1#"VE U  132Tet  13"VE U 132Tet U 13"VE  !32"Tet        ? ? ? k? ?<?<?~?~????     d i868  	D                                     0 0       xw{K} ~| | ~ ~ | | | x x p p 0     H      (                 s    >   0   > K 0   >   8  >  8  > 8         N        
              @                             ? ?          e i869  	D               0 0            $H ( ( + ,h )( * * * * * * * * * * * * . ( ( ( ( ( ( ( '  @       ` 0     Ђ P P P P P P P P P P P P @ @ @ @ @ @ @ @          <x 8 8 ; ? ? > > > > > > > > > > > > > 8 8 8 8 8 8 8 ?       f i870  	D                   0 0           	 H ( `( p ( P ( P ( P ( P( P( P( P( P( P( P( P( P( P( P( P( P( P( P( P P P P @      ` 0                       0      8 8 <        x 8 8 Zp 8 P 8 P 8 P 8 P8 P8 P?P8 P8 P8 P8 P8 P8 P?P8 P8 P8 P8 P8 P P?P P @     g i871  	D                                           0 0       = %/'8T*]T*UT-t-Մ? ?$"    ? -?Ǟ O @.?B"@B"@"@"@b"@b"@"@Â"@&"A"?J   k  " " "     ` `< `< `x a c g N < x 
`  m      <HOH"G"x          @ wn              `               ? ???????????? >???>?~?~??????>?>?>?    h i872  	D                     0 0       G      9 E E@ 
E?9{        r  P 
 T * U8*U *yT 
 P  (
 T*UmUm*UT* T 
 @    ? @ 
 T 
 DU * D 
 T 
 @    4  
 T*UD*	UT*
 T 
 @    n    ? ?{?   ? *
?*?   @     i i873  	D                                     0 0          `      @ @ @ @@  A A B @               0     j    u^ ꫂ U 
P@   P h. 0 8   
 
     C 
 T * W  _ J W 7 [Ԃ -  	              %    @ @ @ @ @                        ? ?                 j i874  	D                 0 0       `  H $       x ?   ˂  @ 	` 	`          & O 0 
> |        4 @                 J      t 4     ?   ؂  `    `  x <       x ?             ?           k i875  	D                             0 0        0 @     HH  8 @       (    
 
@A#P"@PPx 
Ԃ  ?  B @$ @(       
 P ( P   @      ! @ * T   @       y     /       y>@    ` @    @  ? ?        < <       ?       ?      )??   ? ?        l i876  	D                     0 0       ]   8 )   2B @ @ @  @  0  L  a> |  	       B    
 
 ?     ?`        g    + `     @ @        _  ? !? @                m i877  	D ?                            0 0       C     0 p x x       N       p  @ @  D           @@? b $ J, p l $ B 2|      L   
  +    P    `                 B  
   ?   l ` 6 
         `     0 @0 @8 x |  |      ?  ?         n i878  	D               0 0                                      s @ @ @ @ @ @ @ @ @ @ @ @  ? @ @ @ @ @ @ @ @ @ @ @ @                   ?                  o i879  	D               0 0              ?     ?     p i880  	D               0 0         8 8| |>   > | >      > | >   > | |8 8     n    0 `       0      0 `             8 8| |>   ? | >      ? | >  ?  |> >       q i881  	D               0 0       Z                   9   0 `   ?   0 `     i         ?             r i882  	D               0 0       &        ?      0 ?      s i883  	D                           0 0       c                       2 ` Ƃ ؃     ؂ Ƃ `    I & 8   ?  ? 8 &     @  @    Y `x  >  wx`}x}          t i884  	D                     0 0       c                       D      #           u i885  	D                               0 0       c                       Y  x ` @ @ ` x      A   ?  ??  ?      *    8 Ȃ  p      @   0            v i886  	D                     0 0       c                       S 

    V    ~ ~ x |> l6 f B ` p x ~ ~             w i887  	D                     0 0       c                       D       N p p p p p p p  p p p p p p p p          x i888  	D                     0 0       c                       @      O x x x x x x x  x x x x x x x          y i889  	D                           0 0       c                       \                      \                      \                            z i890  	D                       0 0       J                  (     #           { i891  	D ?                                    0 0       c                       \ U@ * U@ * U@ * U@ * U@ * U@ * U@ * U@ * U@ *    \ * U@ * U@ * U@ * U@ * U@ * U@ * U@ * U@ * U@    \                      \ T  T  T  T  T  T  T  T  T     \  T  T  T  T  T  T  T  T  T          | i892  	D                           0 0       c                       / UT * UT * UT * UT * UT    M *UT *UT *UT *UT *        B                   } i893  	D                           0 0       c                       V @00@ a      !   `    K 0@L@2@L
AbF@Y f   &d [ "DC @d@&@    A ??A?p|>|8>~ ~ 
 |8>x<
`???          ~ i894  	D                     0 0       c                       Z ~|yyyyy|~    +   
  
               i895  	D                     0 0       c                       Q :??????????    H                         i896  	D                       0 0       c                       D       N p p p p p p p  p p p p p p p p           i897  	D ?                                  0 0       c                       F  `   L     %  }|| ||        
  8     (    @       U 8             i898  	D                           0 0       c                       #     #     #            i899  	D                               0 0       c                       Y      ` ~` } } | } } ~@ `        L G     
      + < 
        0 |   D      D   |     8 ( 8             i900  	D                           0 0       c                       D ` Ƃ ؃   @   @Ƃ `   @  @    * & 8   ? ?   8 &    W `x    x`{           i901  	D                           0 0       c                       D       J P P P P P P P   P P P P P P P P    L                                              i902  	D                           0 0       c                       #     #     #            i903  	D ?                                  0 0       _                    Y          `            Z     8       8          \                        @  @     
              i904  	D                     0 0       c                       S 2??    >     ? ? ? ?               i905  	D                           0 0       c                       \                      \                      \                             i906  	D                     0 0       T   * 
U_|*U@ * U_*   p p 0    d                p   0 ` `      *  U@  U@  U@  U@    7   >    ?  `    m   ? x x 8       i907  	D                     0 0       | x  `      p 0 q q q ဂ     8 x @~ <  1 Ƃ 1      v           @ 0               <      j              @ $   ?   $ D@        V        @  @     C@ " P (      x  |      v 6 w w w  7    '   ?  W  w 7 
 7          i908  	D                     0 0        0                                               Ђ                     c    ?                      j     @     8              8 >p      0    c  ?       i909  	D                         0 0       8     8                 @      @ ` ` `                @ i~     -         0                                 o       i910  	D               0 0       O   ` ` @ $         { 
   Ă 
     Q   > 8~  ~ ~ ~ ~@~?~> r                 d   ` ` @ $  > 	~  ~1 ~ ~ ~~?~> ~ < Ă        i911  	D                                     0 0       ` 1      ( (     "@  ? ?        a x    |             x ` ?       5 , A~ A>  < Q A8 Q< >c>             &   @  @ @  @     "       "    !            { 1       ?( ? ?            i912  	D                         0 0         p  @        @ @ @         @ @ @          @ p      
 ΂ / /  ]  8 ?8 ?8?|	?~?~? ? |? | xǀ      z  Ax0 Ѐpx `    0     p       < 8 8     z   ????        i913  	D                         0 0                      @ @ @ @    6      a @B  b R ) 
? O  g 8       @     ? ?Ђ ? ?Ђ      *  =@-P?@  G     c @  @   @   P             	  
@  	P          ? ? ? ?           ?   8      i914  	D                 0 0         @ 	   $H H$   	 A@	 $H$
H$H	 @C 	  H$ $H  	  @        
`  7؂ o >  |}>
`7o_o7
`~|}{  o 7؂  
`           ?    ??   ?          i915  	D                 0 0         @ 	   $H H$   	 @@	   `$ pH x$
H x$ pH `	  @@ 	  H$ $H  	  @        
`  7؂ o >  
`7o _ o 7
`  o 7؂  
`           ?    ??   ?          i916  	D                 0 0         @ 	   $H H$   	 C@	 $H$
H$H	 @A 	  H$ $H  	  @        
`  7؂ o > { |}~
`7o_o7
`>|}  o 7؂  
`           ?    ??   ?          i917  	D                 0 0         @ 	   $H H$   	 @@	   $ H< $
H< $ H 	  @@ 	  H$ $H  	  @        
`  7؂ o >  
`7o_ o7
`  o 7؂  
`           ?    ??   ?          i918  	D                 0 0         @ 	   $H H$   	 @@	  $?H?$88
8 H8 $8 H8 	8 @@ 	  H$ $H  	  @        
`  7؂ o >  
`7o_o7
`  o 7؂  
`           ?    ??   ?          i919  	D                 0 0         @ 	   $H H$   I @@	  $ H $
H $ H 	 @@ 	  H$ $H  	  @        
`  7؂ o >߶  ~

`7o_o?7
`c  o 7؂  
`           ?    ??   ?          i920  	D                 0 0         @ 	   $H H$   	 O@	 $?H?$??
0H0$H	
 @X4 i  H$ $H  	  @        
`  7؂ o >  o
`7o_o7
`s˂ ߖ o 7؂  
`           ?    ??   ?          i921  	D             0 0         p  @'/___     ___/'@ p       p    @   0       @ OOOOO@         0   @  p         ????        i922  	D             0 0       t  ?          ?              t  ?     ?       i923  	D             0 0          ?2x@s32fs32fs2fq2fx2f|s2~32~32~s32~s32~xs~?      6 y͘͘"͘͘͘̀ ̀̀̀y       ??        i924  	D                               0 0         "5T +X  "j X + "T X  (, X       
  (        ( T (        (  (           (  
    *            *            4                ?         ?         i925  	D                               0 0         "5T +X  "h* X  "T +X  * X       
  (        (  	(           (  (        ( P 
    *            4              *              ?         ?         i926  	D                               0 0         "4 X  "h* X + "UV +X  * X       (           (  (        (  *  (        ( P 
    4              *            *              ?         ?         i927  	D                     0 0        @ @ "JAR@"H B@"HB@"HB@"JB@ @ @ @ @ @ @ H @ "@ BES@ "@ B$^@     x ??"5?{7߼?{7?{7?{5?? ??*7vl7vl7vL2$o\:o:o8/\=ۯL=ۡl=ۡl?    ) $RRS$P$P$^           i928  	D                     0 0        @ @ @ 
@ @ @@ @  @ @ @A" NB@ @ @ @ @ @ H @ "@ BES@ "@ B$^@     v ??*1:6:7]7][7]K7]k7]k6]c0s1s? ??*7l7vl7vL2$o\:o:o8/\=ۯL=ۡl=ۡl?    P $	"@@@@@@	"@@ $	RRS$P$P$^           i929  	D                 0 0                                         V~~~~~>~~>>>~~~>    g        ?  o x ?    9 8 1 q c s         i930  	D                     0 0                                         f||||ddddddd?`?` ` ` `pppxxxx    w ` ` l l l l l l l l l` |                      i931  	D                   0 0                                                                                        i932  	D             0 0       cǃǃ8x_?ǂ   c p    p p 8 8   L     	 @ 8 p ?          i933  	D                     0 0          
 ^ x? <; y p p| >    |p >p x 8 <         r  ?  $ ?`0~ 
8|8~8 8`    ?     8     @   ` @?    z   ????        i934  	D             0 0       s           > <8 x| p     ?    8      ? p         y           ? ?             i935  	D             0 0       m        p 8 8 < < |> |>   
    9               p           ? ?           i936  	D                     0 0         p  @        @ @ @         @ @ @          @ p        ???&??? ~        ? ?   ~ ~ ~                     z   ????        i937  	D                 0 0         7p    ???*@@@ ?  @      w      ? ?        )?????          ????        i938  	D                 0 0            ?????F????????????????      x        ? ?             ? ? ?             ????        i939  	D                 0 0         p @ <  @@@@@ @   @ p     ~  L ?????? ~     z   ????        i940  	D                 0 0          ^ 	
P
P
P
P
P
P
P
P
P
P@@@@@        z ` ` ` ` R` ` ` ` `( `( `( `( `( `( `( `( `( `8 `  `  `  `  ` @ `  ` ` @    ~  b?g'??         i941  	D                 0 0           :@@  	##CC  
AA !ဂ        ` ` ` @ ` @ ` `  ` ` ` ` ` 
`$ `  `" ` 
 ` ! `@` `@
` ` @a 	a @ b  ` c` @      >???g7>>~?~>??  ?         i942  	D                 0 0          "  @@  2!#GO q  AA !ဂ       ` ` `  ` `@ ` `  ` ` ` ` ` )` ` ` `  `A `@ ` `a 0 a `@b  b  d ` g@      &?639 } `~~>??  ?         i943  	D                 0 0          L      p p ??    A  0p
         ` ` ` ` ` ` ` ` ` ` 	`  ` ` ` ` ` ` ` ` 0` ` @`  ` 0 `  ` ` @      I`#0xÂ??         i944  	D                 0 0           "ᄂ ! ! ! ! ! "!        ` ` ` ` ` ` ` ` ` ` cb b b b b ` "c` ` ` ` ` `  ` ` @      &&?         i945  	D                 0 0          
    0 @@a@@ 0  
         | ` ` 	`  `  ` `  `G ` `  `  `@ )`@ b@f@0`@ `  `  `  `  `H0 ` ` @` 	`  `  ` @      R~x<?????0|?~?         i946  	D                 0 0             	 @      @          z ` ` ` ` ` 
` ` `  `@ 9`@ ` ` @`@`@`@`@` `@` 
 ` : ` d ` ` ` ` ` @      N3
??~~> > > > > ~? ~ ?         i947  	D                 0 0             #O??O#         z ` ` ` ` ` 
` ` `  `@ 9`@ ` ` @`@`@`@`@` `@` 
 ` : ` d ` ` ` ` ` @      "3
  ~@~ > > > ">@ >@ ~  ~ ?         i948  	D                 0 0              >0#O__O#0           y ` ` ` ` ` ` 
` ` `  1`  `@ `@ `@ `@ `@
 ` 
 `  `t ` `0 ` ` ` ` ` ` @      ?g	      ??         i949  	D               0 0       M  0 # O _      _ O # 0     C  p 0   ` @ @ @ `   0 p     M   ?          ?        i950  	D                     0 0       ]          
? ?` ?             M  0   @ @      @ @   0     C  p 0   ` @ @ @ `   0 p     g       ?    
 `     ?            i951  	D                 0 0           ! F1 H	 H	 H	 H	 H	 H	 0	 	 0	x	(0H 9( X  X  X  X  P  @     y   < 8 0 0 0 0 0 0               ?  0 ` Ѓ  P P P P @        ? ~? x x x x x x 0        i952  	D                 0 0       |    ! F1 H	 H	 H	 H	 H	H	(0H 9( X  X  X  X  P  @     h   < 8 0 0 0 0 0            ?  0 ` Ѓ  P P P P @        ? ~? x x x x       i953  	D                 0 0         0 # Ld  
 
 
 
 
 
  0 C 6  >o@w@~@>@2@>@~@w܀o>  GĂ 0       p 0 ` @ @  @     <x ~ >   #g̀	 #   a 80      @              ? |         ?       ?       i954  	D                 0 0         0 # Ld  
 
 
 
   Æ 6  >o@w@~@>@2@>@~@w܀o>  GĂ 0       p 0 ` @ @ @ @ @ O <x ~ >   #g̀	 #   a 80      @              ? |              ?       i955  	D                                                                0 0           " "!"  "!! "!"" "" !"2 !"@D"2@UE"@eW"H)" @uV"H" @eW"H)@uVH@eWH! @uV"H!3 @egH" @uvH" @egW"H" @uvV"H!2 @eg%H  @H" @D  PU  U  @D4 @DK @DtwG @D PU        ?    ?           i956  	D                                         0 0       '    A  A  A A          <                              1  @   @  @        '    @            >      @    
      
                              i957  	D                 0 0       X   	 
 ( 
 ( 
 ( 
 ( 
 ( 
 ( 
 ( 
 ( 	           	@    @    ? C        Z C  0           0   0     < x     - @ @ @ @ @ @        X                 @  @    ?           i958  	D   	                                               0 0      j   " 23DTU& 23CDUe& 23DTUf& 2CDUef& 2DTUf	& BDUef' BDTUfv' BDUefw' BTUfvw' BUefw	' RUfvw( RUefw( RUfvw( Refw( Rfvw( "  U     !  !     ??   ?     i959  	D ?                                    0 0       )       @  	      `      S   
 ` 	 0 p @ 
!  8 8 < >D /$4 'l # 1 D ~ = J0 `  e 7      @  P  T  U  U   @ ( @ 
 @ 
 H J ( 

   P B @ R )      z   P  T  U 
 U@ *  J  @ 
 @ 
 @ 	  * H    @  	      /     `  p  P 0             6 `     @       4? ?? ? ? ? ? ?        ?       i960  	D                                                      0 0       "3 03"34 Pc3"3C Ue3"34D PU56#3CD 3U6#34D3 03SUc#3CD43 p3Ue!3D3 w	3S5!3CD43 w3U6!34D3 x7Sc!3C437e3C3 "3 3"C403D0303D0
03C40"	03 3!"0343Vs03C4365s 3DC3cU3w 3	CD43aS53w 03D31VU3 03CD43216U53 3DC321cU3 @D4321cSU DC3"3VU @43"36 0C3"3 3"    p   ????        i961  	D   
                                               0 0       !23 @!23 PU4!23 SU423c 03UE236f p3SE23cf w3U136f6 7S413cf63 753f63 	 "3 3f3 )"2f03 9`f3 03`f	 03f0#"	 03 3!" 03c63Ss 03	cfcF5s 033f6AU3w 030cf	3#aT5303`f63#aTU3cff
c3#aFU50c3`6	3#FU3c3`3#a03c303#03c3 03c3f63c3 c3 3 c3 c3 03    l    ?        i962  	D                 0 0       K 4' . <cX\c"^B      = .   `     `	A 	    0     G 0  ?q'ny#x!_p >x_ @     7 ???     i963  	D                 0 0       }   c . '@ N  
ba""3Ǐ)⢂"(
3hP)@	J 
N 9   R -      l   c 
7 0 p` 0'``<<8p  c> 1   p ` ?      [          @@   @   
J 1   @ !           ?  ???      ?        i964  	D ?                              0 0         " *@ 
Q @   3(   AD( "$"D (P@  8@  @I * # -  %yI$A("	"|`)     =  ?        p  8 p       h       p >8 |    ߃   ?         b T       ? o ǀ c 6 T     @  0! P H P`    "      >     )  0  0 `   p 0      ? ~ ????โ   ~? -  7o3]y       i965  	D                 0 0        D D T T D D D D D D D D D D DĀ   ĂDDDDDDD@D?     p 8p :p +p +p ;p ;p ;p ;p ;p ;p ;p ;p ;p ;p ;p ; ;ammmma? ?   P     "??     i966  	D                           0 0        8 x x H H H x x x x x x x x x x x | >~ } ~} ~} ~} ~} ~} ~ ~ ~    g     $  $  4                                  v                    0    b             ??     i967  	D                 0 0        =U<$%U$<=U<=U<=U<=U<<> |?????%? > > > >>                           8     !  1       \  U U  U  U  U              ?>??>??>??>??>??>?> ~?????????????      i968  	D                 0 0        < < < < 8 <)y    #     x         )  `             `               ??   :????     i969  	D                 0 0       x? P ( P ( P ( SaU U U U?UP (UP (]P (EP (EP (EP (E (DP (DP (DP ($_@ @ CB(a( Ba( Ba( "(     r 
/ / / , * * * * L**"::::/;;;    <  <  <   А    g   ` `                   	      ?    ?   ?         i970  	D                                         0 0       h                  @(    r              @ A B A H TP b0 0 0 0     ~< " B 8 ! >                ` ` ` ` ` ` ` ` ` ` `   ?| )~ ?~ "< ?~ ? ?|x< T @T AT }T 
T     ~            "              
 
 p    9                 ` `      J ? > < > 7 #                @   @     p      i971  	D                             0 0       } @ @ @O@ @ @O@ @ @ @ @ @   ~             4 ?? 0  ? ? 0  ? 1 1      3        ??    
      < < < < < < < < < <  = =        < < < < < <  < < <  ==       i972  	D                             0 0       } @ @ @O@ @ @O@ @ @ @ @ @   ~             * ?? 0  ? ? 0  ? 1 1    3        ??    #            < < , < < , < < , <  = 5k =       < < < < < <  < < <  ===       i973  	D ?                                  0 0       U       &x r> 
 
 
      F @          @ @ @ @ @ @      0 @ ` p x <<     ۰     	           @    S      ?       i974  	D                       0 0       W      8 D @ @q@$@$D$8q$     
O>HO>H    
 00    S  8 D @ @q@$@$D$8q$      i975  	D                       0 0       K      4 d " 0 $` L0`J     < ~ > }  ߾@|~   @ 0      J    
    @* @R   F   0 `       UP    Z   ?      i976  	D                 0 0           " @  g0                    @@ *?U              	$  	$  	$  	$                 ]        l l l l                 " @ f g0                    ?ꫀ?U      i977  	D                 0 0        @ ?  x H ( ( ( <K x?8`gg @' g' I' Q' "w $x'  	,O y'  uT r y$ <H   
̂ 
( *   j          @  @     `  ` @    
H ( *       ` 0    0 K    " _ 6/ .  X  h 0  
 
 
   @      ?      	 ?     ? ?        ?  
̪*( *     i978  	D                           0 0           :           "     ڂ  ڂ  ڂ  ڂ               W   @ @ @ @ @ @  @  @  @  @       ? ; .؂ 5 ? ?    /  I$  I$  I$  I$         :؂                                  i979  	D                 0 0       l -?  	s >$
I)$ T@    p         P    [ V? Y~~^ * @{PmPڠ+P_j@ P        [        P  P  P 
 P * U@ * T ( @      u ? ?    p      i980  	D                 0 0        @          P@   DP   4    @  @         H   $ `   	@  y      ^    ; }p      _ ?     @  y  x    8  @    ` 0           @                    ?            i981  	D                 0 0       z        R@   H 2H   A  D ( @  @    `   H@ $  	
  h      ]  
  7` o x  }   o ?  @     h  `    9  @    ` 0  @                          ?            i982  	D                 0 0               
 U@ P      UP URҕUrҔ TR     f       U@    ` j` ` j` ,j` ,k`     W    U                ?   Y         U@Up 8   ?     i983  	D                 0 0        	  UT! eH @ (  Q  	ED  %Q B" QS(QTL	EQ0`!DH*U & ATL " Q0 ` D )   L 8    }   2 i HӀ @ M   
5H z <P g S@MT 
5T j 3p i sU > W  T  Ѓ  p           @  P  ( @ 
     0      @        0 `            	  UT?        ?  ?   ?       | 8      i984  	D                 0 0       I  ` ( P H H  D  D D D D D D  
  "  ";"5@"3?  "# "  "  "  "  "  # $ 	 (       z *  7 w w w w w9 w w9 w Hwwwwpe]hJ$ h $ ̨ d       UT     q    (  r(  b( B @   
 @?  J F   
  
 
  UR       ?         ? ? ? ? ? ? ? ? ? ?       i985  	D                 0 0         " D@  " D@D( D 	F!C	!	B!#CA! EB#
	D" ) I(HA   }  ; w ;w|o_}?}M~}|w?_}ow;<nzV:|=~_ow     H       <  x     <  x       	0  p 0     +  ?  ?     i986  	D                 0 0          @ $  H  & 0($BADc"$ADR "(D/H*	(PJb@R *  @ 
     @     t    7` u 0   |>89p}pO>'O p Be  5 @ 
        `   @      @  P@ (8 p@ 
               ?    ǂ?6? ?       @       i987  	D                 0 0       q  @ G @ @ _ @ [ ]	_M'5@ m̀ Y QB DH P `    g ? 8 ? ?  J ? $ ? B? *0?` ? @ 
CCC__    N    
  2 &#  <  ;  7  .   8?    c         ??      i988  	D ?                              0 0       #       	   @ @    ' @ O   ?                            5  U@   U   U  T   UT *    5 U@   @ 
  
  *  * UT    x   0 0 ` `                        6          )       ? ?    ??????????     i989  	D ?                                  0 0       v    ?          @ O              ?    g     0     0   s?O̚     2               
  0 0     ` `     0    D        ????      i990  	D                         0 0              @  080!J02$0#0"10"10 0 0 R R R          {  U  U  U@ * T@ ʀ T@  UD@  U@           A UT  U  UT  ED@   D@   UD@  U@                 
  U@             i991  	D                     - 0       k   # @pB@A !A "@"ΐD 
HD D $D $D +$D $D 
D"H"@!@A pA  @@     f   ` `8 08 8 8 8 8 8 8 0``     a p  0 0 0         ' 0 @0 0 p0        s   ??ǂ?x| > > /> > ~?~??      _ i607 	 D                                       0 0       u  `              y  x   @              `       g     I       0?0?>80`pp   ǂ      < <                                        8 8    ~                   ` i608 	 D          ࠠ                         0 0                ? ~           < < < x x x x x x x  x    
          ?       > | |                   i     ?         > < < | x x x x x  x    _      ? ~                 E        > < | x x x x  x    8  ?                      ?  ???         	D        ``    ``    Ș``  Ș  0000``     0 0        
  6
7o$$$$$ | | |  "         _          @ @ @ @ @ @ @ @ @ @ @ @ @ @ @      @                             @        @  @      o   	  	  	  I  I  I  I  I  I! @" 5        @  0     i   @ @ @ @ @ @ @           ?             @        ??          	D   
          Ș  @@@@@@  Ș``          ````      0000``     0 0       23" P" P" PB$" `w PB" `
q	 PB" vw
 PB" `qwh	P"" pwP" qwP" qwhP"
 WUWUWUwhP" whP" whP" WUWUWwhP" whP" whP" WUWUw	hP"BD whP" whP" WUuUuUwhP" wP" wP" `wh	P"D vh P" `f	 P" P" P" P D PU           	D   
          Ș  @@@@@@  Ș``          ````      0000``     0 0       23" P" P" PB$" `w PB" `
q	 PB" vw
 PB" `qwh	P"" pwP" qwP" qwUuwhP" wWuwUwhP" wWuwUwhP" wUwhP" wWuwhP" wUwhP" wWuwhP" wWuw	hP"BD whP" wWuwhP" wWuwhP" wP" wP" `wh	P"D vh P" `f	 P" P" P" P D PU           	D                  Ș``  @@@@@@  PPPPPP     0 0          @ `   0    0   a C Â  
@`  0  0 `@      X  @    H   @    @    @   @       |        0 0 8 ,8 ,< \< \> > ? |? |?????    j                 @ @              : @         @     ?      @ @     
 ?              ? ?     ??        	D  xx            xx||xx       0 0              @     @ @ @         @ @ @        @        |    B?>????>?      e                   8 x   ` ?     P @  > | | ?     ? | | >  @    ~    ??  ?          	D  xx||xx                       0 0                 @ @        @ @     < x    <     8     H      @  @ @  @              }    ??????&??????????       @    C                 p @                  @             `        ??  ?    x 8          	D  xx||xx                       0 0                 @ @        @ @     < x    <     8     [        (    @  $   @                |    *?????       @    p @                  @             `    D   0 < <                 ??  ?    x 8          	D  xx||                  xx||xx     0 0       z         @ @                 @ @     @            ? ?  p p (x x | | ~ ~   ???    K   @           @             @ @                    @  @                  |   0             ` ` 0 0                  ? ?       ???     
Icon Chooser   on openCard
  set the hilitedButton of group 2 to 0
end openCard

on mouseUp
  local otype, tbut, newicon
  if the selectedObject is empty
  then exit to MetaCard
  get the name of the selectedObject
  if the number of words in it is 3 and word 2 of it is not "id"
  then put word 2 of it into otype
  else put word 1 of it into otype
  if otype is not "stack" and otype is not "button"
  then exit to MetaCard
  put the hilitedButton of group 2 into tbut
  if tbut is 0 then
    if  there is a group 3
    then put the hilitedButton of group 3 into tbut
    if tbut is 0
    then exit to MetaCard
    else put the icon of button tbut of group 3 into newicon
  else put the icon of button tbut of group 2 into newicon
  if otype is "stack" or the targetprop of this stack is "icon" then
    if there is a field "icon" of stack "properties"
    then put newicon into field "icon" of stack "properties"
    set the icon of the selectedObject to newicon
  else
    if there is a field "hiliteIcon" of stack "properties"
    then put newicon into field "hiliteIcon" of stack "properties"
    set the hiliteIcon of the selectedObject to the icon of button tbut of group 2
  end if
  close this stack
end mouseUp
       t   targetprop  icon             U 
Helvetica   U 
Helvetica    
card id 1001   	@          t    %   
card id 1001   	@          t       
card id 1001   	@          t      1    	@          t          	@          t      3    	@          t    4      	P jon openCard
  set the hilitedButton of group 2 to 0
  set the hilitedButton of group 3 to 0
end openCard
           t        w 
card id 1001   	@          t    x    % Page 1              H  ( Icon Bd         ( (              -            	     8 Icon Bd       ,  ( (              .            	     : Icon Bd       T  ( (              /            	     ; Icon Bd       |  ( (              0            	     < Icon Bd         ( (              1            	     = Icon Bd         ( (              2            	     @ Icon Bd         ( (              3            	     A Icon Bd        ( (              4            	      Icon Bd      D  ( (              5            	      Icon Bd      l  ( (              6            	      Icon Bd        , ( (              7            	      Icon Bd       , , ( (              8            	      Icon Bd       T , ( (              9            	      Icon Bd       | , ( (              :            	      Icon Bd        , ( (              ;            	       Icon Bd        , ( (              <            	     ! Icon Bd        , ( (              =            	     " Icon Bd       , ( (              >            	     # Icon Bd      D , ( (              ?            	     $ Icon Bd      l , ( (              @            	     % Icon Bd        T ( (              A            	     & Icon Bd       , T ( (              B            	     ' Icon Bd       T T ( (              C            	     ( Icon Bd       | T ( (              D            	     ) Icon Bd        T ( (              E            	     * Icon Bd        T ( (              F            	     + Icon Bd        T ( (              G            	     , Icon Bd       T ( (              H            	     - Icon Bd      D T ( (              I            	     . Icon Bd      l T ( (              J            	     / Icon Bd        | ( (              K            	     0 Icon Bd       , | ( (              L            	     1 Icon Bd       T | ( (              M            	     2 Icon Bd       | | ( (              N            	     3 Icon Bd        | ( (              O            	     4 Icon Bd        | ( (              P            	     5 Icon Bd        | ( (              Q            	     6 Icon Bd       | ( (              R            	     7 Icon Bd      D | ( (              S            	     8 Icon Bd      l | ( (              T            	     9 Icon Bd         ( (              U            	     : Icon Bd       ,  ( (              V            	     ; Icon Bd       T  ( (              W            	     < Icon Bd       |  ( (              X            	     = Icon Bd         ( (              Y            	     > Icon Bd         ( (              Z            	     ? Icon Bd         ( (              [            	     @ Icon Bd        ( (              \            	     A Icon Bd      D  ( (              ]            	     B Icon Bd      l  ( (              ^            	     u Icon Bd         ( (              _            	     v Icon Bd       ,  ( (              `            	     w Icon Bd       T  ( (              a            	     x Icon Bd       |  ( (              b            	     y Icon Bd         ( (              c            	     z Icon Bd         ( (              d            	     { Icon Bd         ( (              e            	     | Icon Bd        ( (              f            	     } Icon Bd      D  ( (              g            	     ~ Icon Bd      l  ( (              h            	      Icon Bd         ( (              i            	      Icon Bd       ,  ( (              j            	      Icon Bd       T  ( (              k            	      Icon Bd       |  ( (              l            	      Icon Bd         ( (              m            	      Icon Bd         ( (              n            	      Icon Bd         ( (              o            	      Icon Bd        ( (              p            	      Icon Bd      D  ( (              q            	      Icon Bd      l  ( (              r            	      Icon Bd        ( (              s            	      Icon Bd       , ( (              t            	      Icon Bd       T ( (              u            	      Icon Bd       | ( (              v            	      Icon Bd        ( (              w            	      Icon Bd        ( (              x            	      Icon Bd        ( (              y            	      Icon Bd       ( (              z            	      Icon Bd      D ( (              {            	      Icon Bd      l ( (              |            	     x My Icons 1   "on mouseUp which
  if which is 3 and word 1 of the name of the target is "button" then
    local tcard
    put the icon of the target into tcard
    if tcard > 650 then
      go to card tcard - 650 of stack "My Icons"
      palette "Paint Tools"
    end if
  else pass mouseUp
end mouseUp
        0 XH   ( Icon Bd       4 \ ( (                          	  w   8 Icon Bd       \ \ ( (                          	  w   : Icon Bd        \ ( (                          	  w   ; Icon Bd        \ ( (                          	  w   < Icon Bd        \ ( (                          	  w   = Icon Bd        \ ( (                          	  w   @ Icon Bd      $ \ ( (                          	  w   A Icon Bd      L \ ( (                          	  w   D Icon Bd       4  ( (                          	  w   E Icon Bd       \  ( (                          	  w   G Icon Bd         ( (                          	  w   H Icon Bd         ( (                          	  w   J Icon Bd         ( (                          	  w   K Icon Bd         ( (                          	  w   L Icon Bd      $  ( (                          	  w   M Icon Bd      L  ( (                          	  w   N Icon Bd       4  ( (                          	  w   O Icon Bd       \  ( (                          	  w   Q Icon Bd         ( (                          	  w   R Icon Bd         ( (                          	  w   S Icon Bd         ( (                          	  w   T Icon Bd         ( (                          	  w   X Icon Bd      $  ( (                          	  w   Y Icon Bd      L  ( (                          	  w   Z Icon Bd       4  ( (                          	  w   [ Icon Bd       \  ( (                          	  w   _ Icon Bd         ( (                          	  w   a Icon Bd         ( (                          	  w   b Icon Bd         ( (                          	  w   c Icon Bd         ( (                          	  w   d Icon Bd      $  ( (                          	  w   e Icon Bd      L  ( (                          	  w 
     H          T   (           	My Icons    fortyeights           2 6< 8   Icon Bd       6 : 0 0              Y            	      Icon Bd       j : 0 0              Z            	      Icon Bd        : 0 0              [            	      Icon Bd        : 0 0              \            	      Icon Bd       : 0 0              ]            	      Icon Bd      : : 0 0              ^            	      Page 2              H   Icon Bd         ( (              }            	      Icon Bd       ,  ( (              ~            	      Icon Bd       T  ( (                          	      Icon Bd       |  ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd        ( (                          	      Icon Bd      D  ( (                          	      Icon Bd      l  ( (                          	      Icon Bd        , ( (                          	      Icon Bd       , , ( (                          	      Icon Bd       T , ( (                          	      Icon Bd       | , ( (                          	      Icon Bd        , ( (                          	      Icon Bd        , ( (                          	      Icon Bd        , ( (                          	      Icon Bd       , ( (                          	      Icon Bd      D , ( (                          	      Icon Bd      l , ( (                          	      Icon Bd        T ( (                          	      Icon Bd       , T ( (                          	      Icon Bd       T T ( (                          	      Icon Bd       | T ( (                          	      Icon Bd        T ( (                          	      Icon Bd        T ( (                          	      Icon Bd        T ( (                          	      Icon Bd       T ( (                          	      Icon Bd      D T ( (                          	      Icon Bd      l T ( (                          	      Icon Bd        | ( (                          	      Icon Bd       , | ( (                          	      Icon Bd       T | ( (                          	      Icon Bd       | | ( (                          	      Icon Bd        | ( (                          	      Icon Bd        | ( (                          	      Icon Bd        | ( (                          	      Icon Bd       | ( (                          	      Icon Bd      D | ( (                          	      Icon Bd      l | ( (                          	      Icon Bd         ( (                          	      Icon Bd       ,  ( (                          	      Icon Bd       T  ( (                          	      Icon Bd       |  ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd        ( (                          	      Icon Bd      D  ( (                          	      Icon Bd      l  ( (                          	      Icon Bd         ( (                          	      Icon Bd       ,  ( (                          	      Icon Bd       T  ( (                          	      Icon Bd       |  ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd        ( (                          	      Icon Bd      D  ( (                          	      Icon Bd      l  ( (                          	      Icon Bd         ( (                          	      Icon Bd       ,  ( (                          	      Icon Bd       T  ( (                          	      Icon Bd       |  ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd        ( (                          	      Icon Bd      D  ( (                          	      Icon Bd      l  ( (                          	      Icon Bd        ( (                          	      Icon Bd       , ( (                          	      Icon Bd       T ( (                          	      Icon Bd       | ( (                          	      Icon Bd        ( (                          	      Icon Bd        ( (                          	      Icon Bd        ( (                          	      Icon Bd       ( (                          	      Icon Bd      D ( (                          	      Icon Bd      l ( (                          	      Page 3              H   Icon Bd         ( (                          	      Icon Bd       ,  ( (                          	      Icon Bd       T  ( (                          	      Icon Bd       |  ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd        ( (                          	      Icon Bd      D  ( (                          	      Icon Bd      l  ( (                          	      Icon Bd        , ( (                          	      Icon Bd       , , ( (                          	      Icon Bd       T , ( (                          	      Icon Bd       | , ( (                          	      Icon Bd        , ( (                          	      Icon Bd        , ( (                          	      Icon Bd        , ( (                          	      Icon Bd       , ( (                          	      Icon Bd      D , ( (                          	      Icon Bd      l , ( (                          	      Icon Bd        T ( (                          	       Icon Bd       , T ( (                          	      Icon Bd       T T ( (                          	      Icon Bd       | T ( (                          	      Icon Bd        T ( (                          	      Icon Bd        T ( (                          	      Icon Bd        T ( (                          	      Icon Bd       T ( (                          	      Icon Bd      D T ( (                          	      Icon Bd      l T ( (                          	     	 Icon Bd        | ( (                          	     
 Icon Bd       , | ( (                          	      Icon Bd       T | ( (                          	      Icon Bd       | | ( (                          	     
 Icon Bd        | ( (                          	      Icon Bd        | ( (                          	      Icon Bd        | ( (                          	      Icon Bd       | ( (                          	      Icon Bd      D | ( (                          	      Icon Bd      l | ( (                          	      Icon Bd         ( (                          	      Icon Bd       ,  ( (                          	      Icon Bd       T  ( (                          	      Icon Bd       |  ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd         ( (                          	      Icon Bd        ( (                          	      Icon Bd      D  ( (                          	      Icon Bd      l  ( (                          	      Icon Bd         ( (                          	      Icon Bd       ,  ( (                           	      Icon Bd       T  ( (                          	       Icon Bd       |  ( (                          	     ! Icon Bd         ( (                          	     " Icon Bd         ( (                          	     # Icon Bd         ( (                          	     $ Icon Bd        ( (                          	     % Icon Bd      D  ( (                          	     & Icon Bd      l  ( (                          	     ' Icon Bd         ( (              	            	     ( Icon Bd       ,  ( (              
            	     ) Icon Bd       T  ( (                          	     * Icon Bd       |  ( (                          	     + Icon Bd         ( (              
            	     , Icon Bd         ( (                          	     - Icon Bd         ( (                          	     . Icon Bd        ( (                          	     / Icon Bd      D  ( (                          	     0 Icon Bd      l  ( (                          	     1 Icon Bd        ( (                          	     2 Icon Bd       , ( (                          	     3 Icon Bd       T ( (                          	     4 Icon Bd       | ( (                          	     5 Icon Bd        ( (                          	     6 Icon Bd        ( (                          	     7 Icon Bd        ( (                          	     8 Icon Bd       ( (                          	     9 Icon Bd      D ( (                          	     : Icon Bd      l ( (                          	      Page 4              H   Icon Bd         ( (                          	  1    Icon Bd       ,  ( (                          	  1    Icon Bd       T  ( (                          	  1    Icon Bd       |  ( (                           	  1    Icon Bd         ( (              !            	  1    Icon Bd         ( (              "            	  1    Icon Bd         ( (              #            	  1    Icon Bd        ( (              $            	  1    Icon Bd      D  ( (              %            	  1    Icon Bd      l  ( (              &            	  1    Icon Bd        , ( (              '            	  1    Icon Bd       , , ( (              (            	  1    Icon Bd       T , ( (              )            	  1    Icon Bd       | , ( (              *            	  1    Icon Bd        , ( (              +            	  1    Icon Bd        , ( (              ,            	  1    Icon Bd        , ( (              -            	  1    Icon Bd       , ( (              .            	  1    Icon Bd      D , ( (              /            	  1    Icon Bd      l , ( (              0            	  1    Icon Bd        T ( (              1            	  1    Icon Bd       , T ( (              2            	  1    Icon Bd       T T ( (              3            	  1    Icon Bd       | T ( (              4            	  1    Icon Bd        T ( (              5            	  1    Icon Bd        T ( (              6            	  1    Icon Bd        T ( (              7            	  1    Icon Bd       T ( (              8            	  1    Icon Bd      D T ( (              9            	  1    Icon Bd      l T ( (              :            	  1    Icon Bd        | ( (              ;            	  1    Icon Bd       , | ( (              <            	  1    Icon Bd       T | ( (              =            	  1    Icon Bd       | | ( (              >            	  1    Icon Bd        | ( (              ?            	  1    Icon Bd        | ( (              @            	  1    Icon Bd        | ( (              A            	  1    Icon Bd       | ( (              B            	  1    Icon Bd      D | ( (              C            	  1    Icon Bd      l | ( (              D            	  1    Icon Bd         ( (              E            	  1    Icon Bd       ,  ( (              F            	  1    Icon Bd       T  ( (              G            	  1    Icon Bd       |  ( (              H            	  1    Icon Bd         ( (              I            	  1    Icon Bd         ( (              J            	  1    Icon Bd         ( (              K            	  1    Icon Bd        ( (              L            	  1    Icon Bd      D  ( (              M            	  1    Icon Bd      l  ( (              N            	  1    Icon Bd         ( (              O            	  1    Icon Bd       ,  ( (              P            	  1    Icon Bd       T  ( (              Q            	  1    Icon Bd       |  ( (              R            	  1    Icon Bd         ( (              S            	  1    Icon Bd         ( (              T            	  1    Icon Bd         ( (              U            	  1    Icon Bd        ( (              V            	  1    Icon Bd      D  ( (              W            	  1    Icon Bd      l  ( (              X            	  1    Icon Bd         ( (              -            	  1    Icon Bd       ,  ( (              .            	  1    Icon Bd       T  ( (              /            	  1    Icon Bd       |  ( (              0            	  1    Icon Bd         ( (              1            	  1    Icon Bd         ( (              2            	  1    Icon Bd         ( (              3            	  1    Icon Bd        ( (              4            	  1    Icon Bd      D  ( (              5            	  1    Icon Bd      l  ( (              6            	  1    Icon Bd        ( (              7            	  1    Icon Bd       , ( (              8            	  1    Icon Bd       T ( (              9            	  1    Icon Bd       | ( (              :            	  1    Icon Bd        ( (              ;            	  1    Icon Bd        ( (              <            	  1    Icon Bd        ( (              =            	  1    Icon Bd       ( (              >            	  1    Icon Bd      D ( (              ?            	  1    Icon Bd      l ( (              @            	  1    Page 5              H   Icon Bd         ( (              A            	      Icon Bd       ,  ( (              B            	      Icon Bd       T  ( (              C            	      Icon Bd       |  ( (              D            	      Icon Bd         ( (              E            	      Icon Bd         ( (              F            	      Icon Bd         ( (              G            	      Icon Bd        ( (              H            	      Icon Bd      D  ( (              I            	      Icon Bd      l  ( (              J            	      Icon Bd        , ( (              K            	      Icon Bd       , , ( (              L            	      Icon Bd       T , ( (              M            	      Icon Bd       | , ( (              N            	      Icon Bd        , ( (              O            	      Icon Bd        , ( (              P            	      Icon Bd        , ( (              Q            	      Icon Bd       , ( (              R            	      Icon Bd      D , ( (              S            	      Icon Bd      l , ( (              T            	      Icon Bd        T ( (              U            	      Icon Bd       , T ( (              V            	      Icon Bd       T T ( (              W            	      Icon Bd       | T ( (              X            	      Icon Bd        T ( (              Y            	      Icon Bd        T ( (              Z            	      Icon Bd        T ( (              [            	      Icon Bd       T ( (              \            	      Icon Bd      D T ( (              ]            	      Icon Bd      l T ( (              ^            	      Icon Bd        | ( (              _            	       Icon Bd       , | ( (              `            	      Icon Bd       T | ( (              a            	      Icon Bd       | | ( (              b            	      Icon Bd        | ( (              c            	      Icon Bd        | ( (              d            	      Icon Bd        | ( (              e            	      Icon Bd       | ( (              f            	      Icon Bd      D | ( (              g            	      Icon Bd      l | ( (              h            	     	 Icon Bd         ( (              i            	     
 Icon Bd       ,  ( (              j            	      Icon Bd       T  ( (              k            	      Icon Bd       |  ( (              l            	     
 Icon Bd         ( (              m            	      Icon Bd         ( (              n            	      Icon Bd         ( (              o            	      Icon Bd        ( (              p            	      Icon Bd      D  ( (              q            	      Icon Bd      l  ( (              r            	      Icon Bd         ( (              s            	      Icon Bd       ,  ( (              t            	      Icon Bd       T  ( (              u            	      Icon Bd       |  ( (              v            	      Icon Bd         ( (              w            	      Icon Bd         ( (              x            	      Icon Bd         ( (              y            	      Icon Bd        ( (              z            	      Icon Bd      D  ( (              {            	      Icon Bd      l  ( (              |            	      Icon Bd         ( (              }            	      Icon Bd       ,  ( (              ~            	      Icon Bd       T  ( (                          	       Icon Bd       |  ( (                          	     ! Icon Bd         ( (                          	     " Icon Bd         ( (                          	     # Icon Bd         ( (                          	     $ Icon Bd        ( (                          	     % Icon Bd      D  ( (                          	     & Icon Bd      l  ( (                          	     ' Icon Bd        ( (                          	     ( Icon Bd       , ( (                          	     ) Icon Bd       T ( (                          	     * Icon Bd       | ( (                          	     + Icon Bd        ( (                          	     , Icon Bd        ( (                          	     - Icon Bd        ( (                          	     . Icon Bd       ( (                          	     / Icon Bd      D ( (                          	     0 Icon Bd      l ( (                          	     4 Page 6              H  5 Icon Bd         ( (                          	  3   6 Icon Bd       ,  ( (                          	  3   7 Icon Bd       T  ( (                          	  3   8 Icon Bd       |  ( (                          	  3   9 Icon Bd         ( (                          	  3   : Icon Bd         ( (                          	  3   ; Icon Bd         ( (                          	  3   < Icon Bd        ( (                          	  3   = Icon Bd      D  ( (                          	  3   > Icon Bd      l  ( (                          	  3   ? Icon Bd        , ( (                          	  3   @ Icon Bd       , , ( (                          	  3   A Icon Bd       T , ( (                          	  3   B Icon Bd       | , ( (                          	  3   C Icon Bd        , ( (                          	  3   D Icon Bd        , ( (                          	  3   E Icon Bd        , ( (                          	  3   F Icon Bd       , ( (                          	  3   G Icon Bd      D , ( (                          	  3   H Icon Bd      l , ( (                          	  3   I Icon Bd        T ( (                          	  3   J Icon Bd       , T ( (                          	  3   K Icon Bd       T T ( (                          	  3   L Icon Bd       | T ( (                          	  3   M Icon Bd        T ( (                          	  3   N Icon Bd        T ( (                          	  3   O Icon Bd        T ( (                          	  3   P Icon Bd       T ( (                          	  3   Q Icon Bd      D T ( (                          	  3   R Icon Bd      l T ( (                          	  3   S Icon Bd        | ( (                          	  3   T Icon Bd       , | ( (                          	  3   U Icon Bd       T | ( (                          	  3   V Icon Bd       | | ( (                          	  3   W Icon Bd        | ( (                          	  3   X Icon Bd        | ( (                          	  3   Y Icon Bd        | ( (                          	  3   Z Icon Bd       | ( (                          	  3   [ Icon Bd      D | ( (                          	  3   \ Icon Bd      l | ( (                          	  3   ] Icon Bd         ( (                          	  3   ^ Icon Bd       ,  ( (                          	  3   _ Icon Bd       T  ( (                          	  3   ` Icon Bd       |  ( (                          	  3   a Icon Bd         ( (                          	  3   b Icon Bd         ( (                          	  3   c Icon Bd         ( (                          	  3   d Icon Bd        ( (                          	  3   e Icon Bd      D  ( (                          	  3   f Icon Bd      l  ( (                          	  3   g Icon Bd         ( (                          	  3   h Icon Bd       ,  ( (                          	  3   i Icon Bd       T  ( (                          	  3   j Icon Bd       |  ( (                          	  3   k Icon Bd         ( (                          	  3   l Icon Bd         ( (                          	  3   m Icon Bd         ( (                          	  3   n Icon Bd        ( (                          	  3   o Icon Bd      D  ( (                          	  3   p Icon Bd      l  ( (                          	  3   q Icon Bd         ( (                          	  3   r Icon Bd       ,  ( (                          	  3   s Icon Bd       T  ( (                          	  3   t Icon Bd       |  ( (                          	  3   u Icon Bd         ( (                          	  3   v Icon Bd         ( (                          	  3   w Icon Bd         ( (                          	  3   x Icon Bd        ( (                          	  3   y Icon Bd      D  ( (                          	  3   z Icon Bd      l  ( (                          	  3   { Icon Bd        ( (                          	  3   | Icon Bd       , ( (                          	  3   } Icon Bd       T ( (                          	  3   ~ Icon Bd       | ( (                          	  3    Icon Bd        ( (                          	  3    Icon Bd        ( (                          	  3    Icon Bd        ( (                          	  3    Icon Bd       ( (                          	  3    Icon Bd      D ( (                          	  3    Icon Bd      l ( (                          	  3    Common   )        H (   Prev Bp *on mouseUp
  go to prev card
end mouseUp
        L                  @            	  3 	   	  w 	   	   	   	  1 	      Next Bp *on mouseUp
  go to next card
end mouseUp
       lL                  A            	  3 	   	  w 	   	   	   	  1 	     n Clear Icon Dp on mouseUp
  if the selectedObject is empty
  then exit to MetaCard
  set the icon of the selectedObject to 0
  close this stack
end mouseUp
        L T          	  3 	   	  w 	   	   	   	  1 	      sixtyfours            b    Icon Bd       "  B B              !            	      Icon Bd       h  B B              "            	      Icon Bd         B B              #            	      Icon Bd         B B              $            	      Icon Bd      :  B B              %            	      Icon Bd       "  B B              &            	      Icon Bd       h  B B              )            	      Icon Bd         B B              *            	      Icon Bd         B B              +            	      Icon Bd      :  B B              ,            	      
Navigator          m   D               	Nav card   	P ion preOpenCard
  set the label of button "Stack Name" to the short name of the topstack
end preOpenCard
             D                       First Bw fon mouseUp
  set the defaultStack to the label of button "Stack Name"
  go to first card
end mouseUp
           $ $ Go to First Card               ?            	      Prev Bw eon mouseUp
  set the defaultStack to the label of button "Stack Name"
  go to prev card
end mouseUp
       $   $ $ Go to Prev Card               @            	      Next Bw eon mouseUp
  set the defaultStack to the label of button "Stack Name"
  go to next card
end mouseUp
       H   $ $ Go to Next Card               A            	      Last Bw eon mouseUp
  set the defaultStack to the label of button "Stack Name"
  go to last card
end mouseUp
       l   $ $ Go to Last Card               B            	      Start Bw ^on mouseUp
  set the defaultStack to the label of button "Stack Name"
  go start
end mouseUp
          $ $ Go to First Viewed               F            	      Back Bw _on mouseUp
  set the defaultStack to the label of button "Stack Name"
  go back 1
end mouseUp
          $ $ Go Back               E            	      Forward Bw bon mouseUp
  set the defaultStack to the label of button "Stack Name"
  go forward 1
end mouseUp
          $ $ Go Forward               D            	      Finish Bw _on mouseUp
  set the defaultStack to the label of button "Stack Name"
  go finish
end mouseUp
          $ $ Go to Last Viewed               C            	   
   Find            ( D            
In stack:    Stack Name 4)e       D (   
Navigator      MC Stack Menu        	      Find           nT                
Find Card   	P3on preOpenCard
  set the label of button "Stack Name" to the short name of the topStack
end preOpenCard

on MCFind
  local thilited, tstring
  set the cursor to watch
  put the hilitedButton of group 1 into thilited
  put field "Find" into tstring
  set the caseSensitive to the hilite of button "case sensitive"
  set the defaultStack to the label of button "Stack Name"
  if thilited is 1
  then find tstring
  else if thilited is 2
  then find whole tstring
  if the result is "not found"
  then beep 1
end MCFind

on returnInField
  MCFind
end returnInField
           T                  Type           "     partial words  D        & h         	     whole words  D       n & j         	      Find Dp !on mouseUp
  MCFind
end mouseUp
        > b T         	      Help Dp on mouseUp
  help
end mouseUp
         b T         	   
   Find  )`        D           
              @ D            
In stack:    Stack Name 4)e       H @   Dialog Box Help      MC Stack Menu        	      case sensitive  D        ( x         	      File Selector         l         Save          U 
Helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica    File Selector Card   	Pon help
  go to card "File Selector" of stack "Dialog Box Help" as modeless
end help

on refresh
  local filterstring, fnames
  set the cursor to watch
  lock screen
  set the itemDelimiter to "/"
  if the number of items in field "Directory" > 1 and the last char of field "Directory" is not "/"
  then put the last item of field "Directory" into filterstring
  if filterstring is empty then put "*" into filterstring
  put the directory into field "Directory"
  if the last char of field "Directory" is not "/"
  then put "/" after field "Directory"
  put filterstring after field "Directory"
  put the directories into field "Directories"
  if field "Directories" is empty
  then put ".." into field "Directories"
  else sort field "Directories"
  if the visible of field "Files" then
    put the files into fnames
    filter fnames with filterstring
    put fnames into field "Files"
    sort field "Files"
    local dirwidth, filewidth, cwidth
    put max(48, the formattedWidth of field "Directories") into dirwidth
    put max(48, the formattedWidth of field "Files") into filewidth
    put max(the formattedWidth of field "Directory" + 16, dirwidth + filewidth + 24, 250) into cwidth
    set the width of field "Directories" to dirwidth
    set the width of field "Files" to filewidth
    set the left of field "Files" to the right of field "Directories" + 8
    set the left of field "Flabel" to max(the right of field "Dlabel", the left of field "Files" - 8)
  else
    set the width of field "Directories" to 304
    put 320 into cwidth
  end if
  set the width of this stack to cwidth
  local twidth, perspace, toffset
  repeat with i = 1 to the number of buttons
    add the width of button i to twidth
  end repeat
  put (cwidth - twidth) / 5 into perspace
  put perspace into toffset
  repeat with i = 1 to the number of buttons
    set the left of button i to round(toffset)
    add the width of button i + perspace to toffset
  end repeat
  set the width of field "Directory" to cwidth - 16
  set the width of field "Selection" to cwidth - 32
  set the scroll of field "Directories" to 0
  unlock screen
end refresh

on returnKey
  send "mouseUp" to button id 1013
end returnKey

on escapeKey
  send "mouseUp" to button id 1014
end escapeKey

# command, title, prompt, filter, response
on preOpenCard
  set the itemDelimiter to numToChar(0)
  if item 2 of the dialogData is empty then
    if word 1 of item 1 of the dialogData is "answer" then
      if word 2 of item 1 of the dialogData is "folder"
      then set the title of this stack to "Choose Directory"
      else set the title of this stack to "Open"
    else set the title of this stack to "Save"
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field "Prompt"
  put the directory & "/" & item 4 of the dialogData into field "Directory"
  put item 5 of the dialogData into field "Selection"
  if word 2 of item 1 of the dialogData is "folder" then
    hide field "Files"
    hide field "Flabel"
    set the name of button id 1013 to "Choose"
  else
    show field "Files"
    show field "Flabel"
    if word 1 of item 1 of the dialogData is "answer"
    then set the name of button id 1013 to "Open"
    else set the name of button id 1013 to "Save"
  end if
  refresh
end preOpenCard

on closeStack
  put empty into field "Directory"
  put empty into field "Directories"
  put empty into field "Files"
  put empty into field "Selection"
  put empty into field "Prompt"
  set the dialogData to empty
end closeStack

on resizeStack
  local cheight
  put the height of this card into cheight
  repeat with i = 1 to 4
    set the bottom of button i to cheight - 12
  end repeat
  set the bottom of field "Selection" to the top of button 1 - 12
  set the bottom of field "Prompt" to the top of field "Selection" - 2
  set the height of field "Directories" to the top of field "Prompt" - 4 - the top of field "Directories"
  set the height of field "Files" to the top of field "Prompt" - 4 - the top of field "Files"
end resizeStack
           l                        
   Directories )pon mouseUp
  if not the visible of field "Files" then put the selectedText of me into field "Selection"
end mouseUp

on mouseDoubleUp
  local olddir
  put the directory into olddir
  set the directory to olddir & "/" & the clickText
  if the result is not empty then
    answer "Can't set to that directory."
    set the directory to olddir
  else refresh
  if not the visible of field "Files" then put empty into field "Selection"
end mouseDoubleUp
         T                   )`       s U  
   Files )p on mouseUp
  put the clickText into field "Selection"
end mouseUp

on mouseDoubleUp
  send "mouseUp" to button id 1013
end mouseDoubleUp

on rawKeyUp
  put the selectedText of me into field "Selection"
end rawKeyUp
         T                   )`      O U  
   Dlabel           < \            
Directories: 
   Flabel           < 0            Files: 
   Prompt          @             
   
Directory ipon closeField
  local olddir, newdir
  put the directory into olddir
  put me into newdir
  if newdir contains "/" then
    repeat until the last char of newdir is "/"
      delete last char of newdir
    end repeat
  end if
  set the directory to newdir
  if the result is not empty then
    answer "Can't set to that directory."
    set the directory to olddir
    put olddir into me
  else refresh
end closeField

on openField
  select after last char of me
end openField
         \                Save Dpon mouseUp
  local fname
  put field "Selection" into fname
  if the visible of field "Files" then
    repeat for each char c in fname
      if c is in " :?*<>\()[]{}|'`" & quote & tab then
        answer "Invalid file name character" && quote & c & quote && "in" & cr & fname
        exit to MetaCard
      end if
    end repeat
  end if
  if char 1 of fname is not "/" then
    if fname is empty
    then put the directory into fname
    else
      put "/" before fname
      if the directory is not "/"
      then put the directory before fname
    end if
  end if
  if the short name of me is "Save" then
    get fname
    set the itemDelimiter to "/"
    delete last item of it
    if there is no directory it then
      answer error "Directory" && it && "does not exist."
      exit to MetaCard
    else
      if there is a file fname then
        answer question "File" && fname && "exists.  Overwrite?"  with "Yes" or "No"
        if it is not "Yes" then exit to MetaCard
      end if
    end if
  end if
  if the short name of me is "Open" and there is no file fname then
    answer error "File" && fname && "does not exist."
    exit to MetaCard
  end if
  close this stack
  set the dialogData to fname
end mouseUp
        ] <        	      Cancel Dp +on mouseUp
  close this stack
end mouseUp
        ] :        	      Help Dp on mouseUp
  help
end mouseUp
       "] ,        	   
               P            
File Filter: 
   
Selection ip Gon returnInField
  send "mouseUp" to button id 1013
end returnInField
        5L                Filter D`       x] 4        	      Cursors          a               U 
Helvetica       	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                 	    	@                 
    	@                     	@                     	@                     	@                     	@                     	@                   c5   	D               0 0       d    Ă Nw     @A@``   0 p 08 8     ^  8    < 8> > O?  ">߀ > ?     `  ǂ  p     j     w    0??         c11   	D               0 0       [  
  5 [       @   A   H 0      J   
 $ p       > | x       [    ?        ?              c12   	D               0 0       Y >    
   ?  0 @   A          .       > | x p    Y >    
       ?              c16  	D               8 8     K  ! A A        ? 0     2   > > ~ ~          B
D? 
P 
   ?B           c17   	D               8 8     I 0   p x< ~    ~ x< p   0     <                A?P 
   ?B         c18   	D               8 8     K 0 ?        A A !      2       ~ ~ > >      B
D? 
P 
   ?B         c19   	D               8 8     K  ? _ O      O _ ?      -   0 x< | ~ | x< 0      B
D? 
P 
   ?B         c20   	D               8 8     K  ! A A        ? 0     2   > > ~ ~          B
D? 
P 
   ?B         c21   	D               8 8     I 0   p x< ~    ~ x< p   0     <                B
D? 
P 
   ?B         c22   	D               8 8     K 0 ?        A A !      2       ~ ~ > >      B
D? 
P 
   ?B         c23   	D               8 8     K  ? _ O      O _ ?      -   0 x< | ~ | x< 0      B
D? 
P 
   ?B         c1   	D               8 8     B         @     	     7 @ ` p x | ~   | l L      J   ` p X p E 0E     E       c8   	D               8 8     J 	 	 	 	 	 	 踂  * 
 ` 0       G       @ gP wԂ ?         C   5  %%%%?      c24   	D               8 8     A              	     D @ ` p x |A ~A A  |A lA LA A A     C H    P 
AA AAAA        c25   	D               8 8     I      > >  6  6 6 > 	>     D @ ` p x |A ~A I ɂ |] lI LI A A     B H    P          c26  	D               8 8     N@    p @ @     @ @ p    @    F                 C @hu @ @        c27  	D               8 8     H  @ @ 2L RJ y @ @ y RJ 2L @ @     >    ! a   a !       > @h3us @ s3@        c25   	D               8 8     P  8< p x     Â `f `6 p <8      >  0  2 ) $ "D !$  H       D @?x>h|f  @ǂ pp~|<?@      2 Brushes          k                    	@               e      	@               f      	@               g      	@               h      	@               i      	@               j      	@               k      	@               l      	@               m      	@               n      	@               o      	@               p      	@               q  
    	@               r      	@               s      	@               t      	@               u      	@               v      	@               w      	@               x      	@               y      	@               z      	@               {  !    	@               |  #    	@               }  %    	@               ~  '    	@                 )    	@                 +    	@                 -    	@                 /    	@                 1    	@                     	@                     	@                     	@                 	    	@                  e b101   	D                0 0                                    }            f b102   	D                0 0       d                      X                     d       g b103   	D                0 0       C  @ @ @ @ @ @ @ @ @ @ @     9 ? ? ? ? ? ? ? ? ? ? ?    C                   h b104   	D                0 0       %                         %             i b105   	D                0 0         0    @                             @   0       ?    ?       ?  ????????  ?       j b106   	D                0 0       Y     @            @        L   ?           ?      Y   ?        ?        k b107   	D                0 0       >                4              >                  l b108   	D                0 0       %                      %             m b109   	D                0 0          " D     @   " D     @   " D     @   "      t   8 p       8 p       8 p              > |       > |       > |       >        n b110   	D                0 0       [  @   @   " D     @   " D    @    N       8 p       8 p  @    [       > |       > |    @      o b111   	D                0 0       1   $ H    @  	      '   0 `         1   < x             p b112   	D                0 0       $  ( P  @           @       $  8 p            b133   	D                0 0       >      B                A   @     @         @    d    @     B  @                @       b134   	D                0 0       ,    @       @    .   @              H     @  @            @       b135   	D                0 0                          +                 b136   	D                0 0       
       
 @       @         q b113   	D                0 0       z  
   @     D "   @     D "   @     D (     l       p 8       p 8       p 8     z         | >       | >       | 8       r b114   	D                0 0       V @    D "   @     D "   @      I @  p 8       p 8         V @    | >       | >           s b115   	D                0 0       5  $  	  @    H $      +       ` 0      5  <       x <        t b116   	D                0 0       $  
   @  P           @      $       p        u b117   	D                0 0         @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @                                                                     v b118   	D                0 0       f  @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @     \                      f                          w b119   	D                0 0       H                  2                H                    x b120   	D                0 0       *                      *              y b121   	D                0 0        ?    ?          ????      z b122   	D                0 0         @ @                { b123   	D                0 0         @      ?             | b124   	D                0 0                            } b125   	D                0 0           @              &        @        ~ b126   	D                0 0          @    
             @       b127   	D                0 0       
                       b128   	D             0 0                    b129   	D                0 0                                    b130   	D                0 0                         b131   	D                0 0                 @        @             b132   	D                0 0                           p Brush Chooser         `~                
Brushes Card   	Pzon preOpenCard
  if the tool is "eraser tool"
  then set the hilitedButton of group 1 to the eraser
  else if the tool is "spray tool"
          then set the hilitedButton of group 1 to the spray
          else set the hilitedButton of group 1 to the brush
end preOpenCard

on mouseUp
  if the target contains "button" and the hilite of the target then
    if the tool is "eraser tool"
    then set the eraser to the number of the target
    else if the tool is "spray tool"
           then set the spray to the number of the target
           else set the brush to the number of the target
    close this stack
  end if
end mouseUp
           ~   %  % Icons            d   ( Icon Bd                         e            	     8 Icon Bd        :                 f            	     : Icon Bd        b                 g            	     ; Icon Bd                         h            	     < Icon Bd       :                  i            	     = Icon Bd       : :                 j            	     @ Icon Bd       : b                 k            	     A Icon Bd       :                  l            	     D Icon Bd       b                  m            	     E Icon Bd       b :                 n            	     G Icon Bd       b b                 o            	     H Icon Bd       b                  p            	     J Icon Bd                         q            	     K Icon Bd        :                 r            	     L Icon Bd        b                 s            	     M Icon Bd                         t            	     N Icon Bd                         u            	     O Icon Bd        :                 v            	     Q Icon Bd        b                 w            	     R Icon Bd                         x            	     S Icon Bd                         y            	     T Icon Bd        :                 z            	     X Icon Bd        b                 {            	     Y Icon Bd                         |            	     Z Icon Bd                        }            	     [ Icon Bd       :                 ~            	     _ Icon Bd       b                             	     a Icon Bd                                    	    b Icon Bd      *                              	     c Icon Bd      * :                             	     d Icon Bd      * b                             	     e Icon Bd      *                              	     j Icon Bd      R                              	     k Icon Bd      R :                             	     l Icon Bd      R b                             	     m Icon Bd      R                              	      Pattern Chooser            P               
Pattern Card   	Pon preOpenCard
  set the hilitedButton of background 1 to the brushPattern
  set the icon of button "Brush or Pen" to 309
end preOpenCard

on mouseUp
  local tid
  put the number of the target into tid
  if tid > 31
  then add 19 to tid
  add 64 to tid
  if the icon of button "Brush or Pen" is 308
  then set the penPattern to tid
  else set the brushPattern to tid
end mouseUp

on mouseDoubleUp
  local tcard
  put the icon of the target - 250 into tcard
  go to card tcard of stack "My Patterns"
end mouseDoubleUp
            P  %  X  % Icons               P  8 browse Bd                                       	     \ browse Bd                                      	     ] browse Bd                                       	     ^ browse Bd       0                               	     _ browse Bd       @                               	     ` browse Bd       P                               	     a browse Bd       `                               	     b browse Bd       p                               	     c browse Bd                                      	     d browse Bd                                      	     e browse Bd                                      	     f browse Bd                                      	     g browse Bd                                      	     h browse Bd                                      	     i browse Bd                                      	     j browse Bd                                      	     k browse Bd                                     	     l browse Bd       0                              	     m browse Bd       H                              	     n browse Bd       `                              	     o browse Bd       x                              	     p browse Bd                                     	     q browse Bd                                     	     r browse Bd                                     	     s browse Bd                                     	     t browse Bd         ( ( (                           	     u browse Bd       ( ( ( (                           	     v browse Bd       P ( ( (                           	     w browse Bd       x ( ( (                           	     x browse Bd        ( ( (                           	     y browse Bd        ( ( (                           	     z browse Bd      (                               	     { browse Bd      8                               	     | browse Bd      H                               	     } browse Bd      X                               	     ~ browse Bd      h                               	      browse Bd      x                               	      browse Bd                                    	      browse Bd                                    	      browse Bd                                    	      browse Bd                                    	      browse Bd                                    	      browse Bd                                    	      browse Bd                                    	      browse Bd                                    	      browse Bd                        	            	      browse Bd      (                 
            	      browse Bd      @                             	      browse Bd      X                             	      browse Bd      p                 
            	      browse Bd                                   	      browse Bd                                   	      browse Bd                                   	      browse Bd                                   	      browse Bd                                   	      browse Bd                                    	      browse Bd      ( ( ( (                          	      browse Bd      P ( ( (                          	      browse Bd      x ( ( (                          	      browse Bd       ( ( (                          	      browse Bd       ( ( (                          	      browse Bd       ( ( (                          	     X 
Brush or Pen Bson mouseUp
  set the hilite of me to false
  if the icon of me is 308 then
    set the icon of me to 309
    set the hilitedButton of group 1 to the brushPattern
  else
    set the icon of me to 308
    set the hilitedButton of group 1 to the penPattern
  end if
end mouseUp
          ( (              5            	     / Paint Tools   on changeTool
  set the hilitedButton of group 1 to \
      itemOffset(word 1 of the tool, "select,pencil,brush,eraser,spray,bucket,dropper,line,polygon,curve,rectangle,oval,rounded,regular")
end changeTool
       y?                Paint Tools Card   	Pon preOpenCard
  if word 1 of the tool is in "pointer browse button field scrollbar image graphic"
  then set the hilitedButton of group 1 to 0
  set the hilite of button "filled" to the filled
  set the hilite of button "centered" to the centered
  set the hilite of button "roundEnds" to the roundEnds
  set the thumbPos of scrollbar "Line Size" to the lineSize
  set the thumbPos of scrollbar "Poly Sides" to the polySides
end preOpenCard
           ?             
      -  .  /   filled  D =on mouseUp
  set the filled to the hilite of me
end mouseUp
        X  \         	      	centered  D ?on mouseUp
  set the centered to the hilite of me
end mouseUp
        X 0 \         	   
  
           D  R            polySides: 
             D  H            
lineSize:    
roundEnds  D @on mouseUp
  set the roundEnds to the hilite of me
end mouseUp
        X P \         	      
Line Size  q Mon scrollbarDrag
  set the lineSize to the thumbPos of me
end scrollbarDrag
         p  $  2 1  64          Poly Sides  q Non scrollbarDrag
  set the polySides to the thumbPos of me
end scrollbarDrag
           $i#O 3  32          Icons    |on mouseUp
  if word 1 of the name of the target is "button"
  then choose (the short name of the target) tool
end mouseUp
        H    select Bd                            3            	      pencil Bd                            4            	       brush Bt <on mouseDoubleUp
  modal "Brush Chooser"
end mouseDoubleUp
                             5            	     ! eraser Bt <on mouseDoubleUp
  modal "Brush Chooser"
end mouseDoubleUp
                             6            	     " 
spray can Bt <on mouseDoubleUp
  modal "Brush Chooser"
end mouseDoubleUp
          @                  7            	     # bucket Bd         @                  8            	     $ dropper Bd         `                  M            	     % line Bd         `                  N            	     * polygon Bd                           =            	     ' curve Bd                           :            	     ) 
rectangle Bd                           <            	     & oval Bd                           9            	     + round rectangle Bd                           >            	     ( regular polygon Bd                           ;            	     - Patterns... Ep 4on mouseUp
  palette "Pattern Chooser"
end mouseUp
          T         	       . 
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
         0 T         	       / Help Ep on mouseUp
  help
end mouseUp
         T T         	        Stack Password          0 h                  	P >on closeCard
  put empty into field "Password"
end closeCard
            h             Cancel Dp +on mouseUp
  close this stack
end mouseUp
        j : 8         	      Help Dp on mouseUp
  help
end mouseUp
         : 8         	      OK Lp on mouseUp
  if word 1 of the selectedObject is "stack"
  then set the password of the selectedObject to field "Password"
  close this stack
end mouseUp
         : 8         	   
               P            
Password: 
   	Password  i`       V 
               Stack Passkey          R  h                  	P >on closeCard
  put empty into field "Password"
end closeCard
             h             Cancel Dp +on mouseUp
  close this stack
end mouseUp
        j : 8         	      Help Dp on mouseUp
  help
end mouseUp
         : 8         	      OK LpVon mouseUp
  if word 1 of the selectedObject is "stack"  then
    try
      set the passkey of the selectedObject to field "Password"
    catch errno
      answer error "Passkey doesn't match password!"
    end try
    if the passkey of the selectedObject is the password of the selectedObject
    then close this stack
  end if
end mouseUp
         : 8         	   
               l            Old Password: 
   	Password  i`       n 
               Stack Files         VH          x          	Pon resizeStack
  local twidth, tloc
  set the width of field 1 to the width of this stack - 16
  set the height of field 1 to\
      the height of this stack - the height of button 1- 56
  set the left of field 1 to 8
  set the top of field 1 to 40
  put the width of this stack into twidth
  set the width of button 1 to twidth - the left of button 1 - 8
  put 64,the height of this stack - 20 into tloc
  set the loc of button 2 to tloc
  put twidth div 2 into item 1 of tloc
  set the loc of button 3 to tloc
  put twidth - 64 into item 1 of tloc
  set the loc of button 4 to tloc
end resizeStack

on refresh
  local sf
  put the stackfiles of stack (the label of button 1) into sf
  delete last char of sf
  put sf into field 1
end refresh

on preOpenCard
  refresh
end preOpenCard
           H             
     p on mouseUp
end mouseUp
         (8                   )`      , (     OK Dp qon mouseUp
  set the stackfiles of stack (the label of button 1) to field 1 & cr
  close this stack
end mouseUp
          D         	      Cancel Dp +on mouseUp
  close this stack
end mouseUp
          D         	      Help Dp on mouseUp
  help
end mouseUp
          D         	   
               8            Stack:    Stack Name 4)u "on mouseUp
  refresh
end mouseUp
        D    Home      MC Main Stack Menu        	      Saving         9  p                    	pon preOpenStack
  put "Saving stack" && the short name of the topStack into field 1
  if the mainStack of the topStack is not the short name of the topStack then
    put "as a substack of stack" into line 2 of field 1
    put the mainStack of the topStack into line 3 of field 1
    put "into file" & return & the effective fileName of the topStack into line 4 of field 1
  else
    put "as a mainStack" into line 2 of field 1
    put "into file" & return & the effective fileName of the topStack into line 3 of field 1
  end if
  set the width of field 1 to the formattedWidth of field 1 + 8
  set the height of field 1 to the formattedHeight of field 1
  set the left of field 1 to 0
  set the top of field 1 to 0
  set the width of this stack to the right of field 1
  set the height of this stack to the height of field 1
  set the loc of this stack to the loc of the topStack
end preOpenStack
     @       p  
   field id 1005               p         Saving stack Message Box  as a substack of stack  MetaCard Menu Bar  
into file  /home/raney/mc/mctools.mc    	Patterns          T	                |    	@                 ~    	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                 '    	@                 )    	@                 +    	@                 -    	@                 /    	@                 1    	@                 3    	@                 5    	@                 7    	@                 9    	@                 O    	@                 Q    	@                 S    	@                 U    	@                 W    	@                 Y    	@                 i    	@                 k    	@                 m    	@                 o    	@                 q    	@                 s    	@                 u    	@                 w    	@                 y    	@                   icon 1   	D  qƞy     q           < <       ǃ ǃ          8 8       p p p    %              icon 1   ID  }               < <          ˃        B    0 ` r       @       %              icon 1   	D           q     < <                       %              icon 1   	D  }               < <       =  ߃ W             H     B   @     %              icon 1   	D  eee  ]uy     < <                  ~ ~ F F ~ ~    %              icon 1   	D     q               < <            ǃ             
  0    %              icon 1   	D  8\  }    }     q     < <        Ã      T T       *   J B     @       < $ $ <    %              icon 1   	D        qƞy     < <       Ã     Ã      < Z f f Z <    %              icon 1   	D       q     < <                 g g ~ ~ c c    %              icon 1   	D          }     < <     Ã ~   Ã ~     <      <     %              icon 1   	D             < <        ۃ Ã Ã        f $ < < f f    %              icon 1   	D     q  }     < <                 } E E E }      %              icon 1   ID  eee  }    Lڎ8     < <     Ã   Ã     < B     ~ <     < | L L |    
 0 0    %              icon 1   	D  qƞy     q             < <        B ǃ  ˃          8 | 4 b      @      %              icon 1   	D  qƞy     q             8 8     N   	   1    3 O        :     4 ̂  
    
 x    B  8 ) >` ʂ 
  ~ 8x (̂ 8 2^ M          E                      icon 1   	D     q  }       8 8     J    d     0 3  ) K ʂ     O p A @   .؂   ΂ L > }  5     6 @  @ H        @     E                      icon 1   	D  ]uy               8 8     L  ? ߂                :         	  P  :  n>     @    @     E                      icon 1   	D           q  }               8 8     O     
   ǂ    Â       B |~ T }   z  ( >F <B AF A$ X    2  < ` p @  8 ( 68 6                         E                      icon 1   	D  }     q  qƞy     8 8     M    7 G  w g  㧂 ﯂  /      6  H Ȃ 
  
 X P x Ђ      0 , & 2     E                      icon 1   	D     q  8\     8 8     O ' 7  { y 8 y= t 7݂ ;   ς      K p ؂ 0Ȃ f E E   b " NĂ c   0     F                      icon 1   	D  8\             8 8     H߂   g 鯂 ߂ я k s   c `      ?     P   .p , ` ? 2 2     E                      icon 1   	D  }        8\     8 8     G      /  /           %             @     E                      icon 1   	D        }  qƞy  }     q    ]uy  LLL     8 8     "    T T T    < 	 	                  y y y             V V V              E                      icon 1   	D  eee               8 8     N	 E d- dm Mm  {  pς ` 痂 g  &  p    D         H ` H` b h     G     2 6 ?         @     E                      icon 1   	D     q               0 0       	 
Rb v | ,\ =?/'?}?3?} @?{ ;v  #7 e O yd A ~  = = )       @               @     	  ` ,wg	>9sG/  A`	o O  }`@  BT         icon 1   	D  }        qƞy  eee  ]uy     q  }     0 0         
 NnnnnnnnnͿ    @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ p     l                         0    U L                                          C  @ @ @ @ @ @ @ @ @ @ @ `0    *                         icon 1   	D  	      }    LLL  }  ]uy    8\  qƞy     0 0          !03 A "0 3 1 A   0  R0 3 f@ R 0 3f Rp3 3 pf " 0 3pva "p 	v ' 36 "  0 R   f@ 0 30h@ 0  `@   3fD "  0 %" p !R  " fd@ 	!"@ 	" `H "d @ @`A @A @A D@A A A@A D A DA          icon 1   	D  	  LLL  ]uy          eee         q       0 0      W  "   "!" @@"  
1" " " 0 "  "   C " "@ R 0@	@"    @ @2 P  	 D "$P @ @ @ # E0  @fB  $4@"@ 
 ` B C @ $@ "&`@@ @ "  "@@ " @D@ " dD dC cC fC fC d3 d3 63 4C wuWUw	U xwxwWxwgwxw
xwuxwwvhwwwgxwxwwxwxwww         icon 1   	D       q        Lڎ8  }     0 0       kσ?  ?            ?      0 @        F ){ s{@{ 칰==Ͻ}۽{۹{ۻ;;03`w@v x    N    B B B B F @ D @ @ Ȃ       C 8   @  0         @` @@@@@ @ @	           icon 1   	D          }     0 0       ߂ׂ
T /?>=?? ?N    ?   p  ( 
x x   1 ? /  `    D 2 C b   @  @  @  ` `     0  a          	bfp3.pnm   	D            wwwwww     9 9     7              } } } } } }    / }   } }   } }     E                      
bfp15.pnm   	D               9 9     @                   @U U U U U U U U U U U U U U U U    @                      
bfp14.pnm   	D               9 9     L                   8 | | | |   | | | |     D                      
bfp10.pnm   	D            33                    33     1 1       w
߂wgw߿	~$w߻wߛ(w}7}   8 " D       @                8 ~      " b b        3    " D     @ ` `     @    @     D "         B    	       D     @      9 " D     @           -     D "   | ` `          
bfp19.pnm   	D ?             33  ff33  ff33           ) ) 0 0   ? ??     ?     ?  ?  ?߂  ?  ?  8      ?                                     ? ?     ?        @ @@          @    `    @  @  @   @`  @  G   8   `                   @     @             @  `  ?@ @        @          B    @ @  `@0   @@   8 ~  >| >| s q@ g G O _ _   Ä x >| x q ?# G :\ p 1_ # g o 2L :\     @ @   ` 0    @      t        `  @  @         `  @  @          @     @ ! 0   
0    @        p  A       
D #D Ȇ 	  	  @      @    	      @   @   A  (       P
 $ $  A`  Q
 "Ć ( 
Р E@ P )  	    @                                                                
bfp21.pnm   	D                ff          33         1 1       z7   ` ; `       w !!11Y4Y4MdMd MdMdY4411!	!_     _!	!118I$YdEDMDMdMdY4Y411!!    j &&22|22&&     6&:2|22&&                              
bfp17.pnm   	D                        33       ) ) 0 0  	   B B B $$$ $$$ BBB                            B B B $$  $$$ BBB                            B B B $$$ $$$ BBB      f<f<f< $ $ $       $ $ $ <f<f<f    <f<f<f    <f<f<f    <f<f<f    <f<f<f    <f<f<f    <f<f<f    <f<b<f    <f<f<f $ $ $      $ $ $ f<f<f<    f<f<f<    f<f<f<    f<f<f<    f<f<f<    f<f<f<    f<f<f<    f<f<f<    f<f<f< $ $ $       $ $ $ <f<f<f      Â   Â 灂   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã 灂 Â     Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Ã   Â   Â 灂   Ã                                                                                < < < < < < < < < < < < < < < < < < < < < < < <    < < < < < < < < < < < < < < < < < < < < < < < <                                                             	bfp1.pnm   	D               1 1       K                            K         	fp10.pnm   	D               1 1       !l~ێmn>ƪml|Ff>լjHkY$ZԒֲH$dwkRHZ%֤Gw kZ ւw h [w    !$UI$qUNU$UI89UGU$UIUFU$qUM.UKU*SyVRTX+mQ)MbJVDRm6")[lDJmR"D) KR "D /         pat0   	D       < <                        pat1   	D               < <        ߃         
              pat2   	D               < <      "  "     w  ݃  w  ݃            pat3   	D               < <        " "   " "     w w ݃ ݃ w w ݃ ݃           pat4   	D               < <        "    "      w U ݃ U w U ݃ U           pat5   	D               < <      ̃  3  ̃  3      3 U ̃ U 3 U ̃ U           pat6   	D               < <                   U D U  U D U           pat7   	D               < <                   D D   D D            pat8   	D               < <                  D  D            pat9   	D               < <                 
             pat10   	D               < <         ߃                 @           pat11   	D             < <                        pat12   	D               < <      ݃ w ݃ w ݃ w ݃ w     "  "  "  "            pat13   	D               < <       ݃  w  ݃  w      " D   " D            pat14   	D               < <      σ ^   ? g       0  
                pat15   	D               < <          σ Ƀ 9 ?      l c  0 6 ƃ            pat16   	D               < <             U  U  U  U            pat17   	D               < <       w ݃ w  w ݃ w     U  "  U  "            pat18   	D               < <       U " U  U " U     w  ݃  w  ݃            pat19   	D               < <      ݃ w ݃ w ݃ w ݃ w     "  "  "  "            pat20   	D               < <                             pat21   	D               < <       U  U  U  U     U  U  U  U            pat22   	D               < <      ރ ? σ          !  0                pat23   	D               < <        
    
                        pat24   	D               < <        "   P " P     w  ݃  w  ݃            pat25   	D               < <        ߃ ߃  p             P              pat26   	D               < <      ̓ . w    w      2 у  \ b @             pat27   	D               < <      ݃ ߃ P ߃ ݃        "      "              pat28   	D               < <      ȃ &   1 J  #     7 ك n o ΃  k ܃           pat29   	D               < <        W ؃  P u         ' P   r           pat30   	D               < <         ׃    }      (             pat31   	D               < <                    ߃              pat32   	D               < <        ݃    U      "             pat33   	D               < <                                  pat34   	D               < <              p     w      ߃            pat35   	D               < <       ߃ ߃ ߇                           pat36   	D               < <        > \  Ń  у     w    w :  .           pat37   	D               < <                  = = = =             pat38   	D               < <      u           u               pat39   	D               < <       ׃  A  A  ׃      ( }  }   (           pat40   	D               < <                                pat41   	D               < <         8 x           ǃ             pat42   	D               < <      ݃  w   w  ݃     "   D D   "           pat43   	D               < <       o    o       	  `  	  `            pat44   	D               < <         U    U     D   D            pat45   	D               < <          
      u U                 pat46   	D               < <                                    pat47   	D               < <       w  ݃  w  ݃       D "   D "           pat48   	D               < <                           pat49   	D               < <       ߃           @                   pat50   	D               < <       ߃              @                pat51   	D               < <       p 8            ǃ    | >           pat52   	D               < <        ǃ   > |        8 p               pat53   	D               < <      ̃ f 3  ̃ f 3      3  ̃ f 3  ̃ f           pat54   	D               < <      ̃  3 f ̃  3 f     3 f ̃  3 f ̃            pat55   	D               < <                 
             pat56   	D               < <                   @  @           pat57   	D               < <                  U  U            pat58   	D               < <       x 8 x      >   ǃ               pat59   	D               < <         P          w w w  ߃   w           pat60   	D               < <      ̃ ̃ 3 3 ̃ ̃ 3 3     3 3 ̃ ̃ 3 3 ̃ ̃           pat61   	D               < <                 @ @ U @           pat62   	D               < <        o     o     ` `  	   	            icon 1   	D                     < <                   J L `        "                     pat62   	D               < <        o     o     ` `  	   	           Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
       [S v   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica   U 
helvetica       	PRon preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  put word 2 of item 1 of the dialogData into dtype
  if dtype is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
    case "Appearance Manager"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" or the lookAndFeel is "Appearance Manager" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
           S v  z                
     @        C 2           Have you backed up mctools.mc?  ^This will transfer the new libUrl script and customProperties to your current "liburl" stack.   z icon BP on mouseUp
end mouseUp
         
 ( (              H           	      Cancel D`        H M        	      OK D`       H 5        	      Yes D`       6 9        	      z D`        4 '        	      y D`        4 '        	      x D`       i 4 '        	      w D`         4 )        	     a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
       @    macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica   U 
helvetica       	PJon doresize
  local twidth, iwidth, bwidth
  put the width of this stack into twidth
  if the visible of button 1
  then put 48 into bwidth
  else put 16 into bwidth
  set the width of field 1 to twidth - (bwidth + 16)
  set the left of field 1 to bwidth
  set the width of field 2 to twidth - (bwidth + 16)
  set the left of field 2 to bwidth
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth, dtype, foffset
  set the itemDelimiter to numToChar(0)
  put word 2 of item 1 of the dialogData into dtype
  set the fieldmode of me to dtype
  if dtype is "plain" or dtype is "password" or dtype is "clear" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
    case "Appearance Manager"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    set the itemDelimiter to comma
    set the icon of button 1 to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + foffset + 24,\
      the formattedWidth of field 2 + foffset + 24, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is "password" or the fieldmode of me is "clear" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" \
      and (the fieldmode of me is "password" or the fieldmode of me is "clear") then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is "password" or the fieldmode of me is "clear"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is "password" or the fieldmode of me is "clear"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is "password" or the fieldmode of me is "clear"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
                              \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  default
    get field 2
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
        B \ 4         	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
         \ <         	   
  _  `        (              
  `   
!`       b 8 |             a New Button @@         $ (        	       Edit Backgrounds           o\M             U 
helvetica       	PQlocal bgids

on buildlist
  local tbg, bgnum, gids
  lock screen
  put the groupNames of this card of the topStack into field "Groups"
  put the groupIds of this card of the topStack into gids
  put the backgroundNames of the topStack into tbg
  put 1 into bgnum
  put empty into bgids
  repeat for each line l in the backgroundIds of the topStack
    if l is among the lines of gids
    then delete line bgnum of tbg
    else
      add 1 to bgnum
      put l & cr after bgids
    end if
  end repeat
  put tbg into field "Backgrounds"
  put empty into field "Create"
  set the disabled of button "Edit" to field "Groups" is empty
  set the disabled of button "Remove" to field "Groups" is empty
  set the disabled of button "Properties..." to field "Groups" is empty
  set the disabled of button "Place" to field "Backgrounds" is empty
  unlock screen
end buildlist

function getbgid which
  return line which of bgids
end getbgid
on preOpenCard
  buildlist
end preOpenCard

on openCard
  if field "Groups" is not empty
  then select line 1 of field "Groups"
end openCard

on returnKey
  if the selectedField is empty
  then exit to MetaCard
  if the short name of the selectedField is "Groups"
  then send "mouseUp" to button "Edit"
  else if the short name of the selectedField is "Backgrounds"
  then send "mouseUp" to button "Properties..."
end returnKey
           \M                              
   Groups  )p on mouseDoubleUp
  send "mouseUp" to button "Edit"
end mouseDoubleUp

on returnKey
  send "mouseUp" to button "Edit"
end returnKey
           P           Common       9`          N
   Backgrounds  )p on mouseDoubleUp
  send "mouseUp" to button "Place"
end mouseDoubleUp

on returnKey
  send "mouseUp" to button "Place"
end returnKey
           P           
MCPayment  
ISContact  CWCPayment  
MCLicense  CWCLicense  CWCPricing  
MCPricing       )`          N   Edit DpPon mouseUp
  get the hilitedLines of field "Groups"
  close this stack
  if it is empty
  then exit to MetaCard
  set the defaultStack to the topStack
  get line it of the groupIds of this card
  if the HCAddressing of this stack
  then start editing background id it
  else start editing group id it
  choose pointer tool
end mouseUp
           \         	      Remove Dpon mouseUp
  get the hilitedLines of field "Groups"
  #  close this stack
  if it is empty
  then exit to MetaCard
  set the defaultStack to the topStack
  get line it of the groupIds of this card
  if the HCAddressing of this stack
  then remove background id it from this card
  else remove group id it from this card
  set the defaultStack to "Edit Backgrounds"
  buildlist
end mouseUp
         < \         	      Place Dpon mouseUp
  get the hilitedLines of field "Backgrounds"
  #  close this stack
  if it is empty
  then exit to MetaCard
  set the defaultStack to the topStack
  place background id getbgid(it) onto this card
  set the defaultStack to "Edit Backgrounds"
  buildlist
end mouseUp
          X          	      Create Dp on mouseUp
  local bgname
  put field "Create" into bgname
  close this stack
  set the defaultStack to the topStack
  create background bgname
  start editing background bgname
end mouseUp
          X          	   
   Create  ip on returnInField
  if me is not empty
  then send "mouseUp" to button "Create"
end returnInField

on keyUp
  set the disabled of button "Create" to me is empty
end keyUp
                          Edit @g        T          	      Edit @g        xT          	   
              T            Stack Backgrounds 
              T            Card Groups    Edit @g        T          	      Done Dp +on mouseUp
  close this stack
end mouseUp
        F* H         	      Help Dp on mouseUp
  help
end mouseUp
        * H         	      Properties... Dpon mouseUp
  get the hilitedLines of field "Groups"
  if it is empty
  then exit to MetaCard
  close this stack
  set the defaultStack to the topStack
  get line it of the groupIds of this card
  select group id it
  choose pointer tool
  newTool
  palette "Properties"
end mouseUp
         X \         	      MainStack Option          K n   retval  Yes                  	P!on mouseUp
  if word 1 of the target is "button" then
    close this stack
    set the retval of this stack to the short name of the target
  end if
end mouseUp

on preOpenStack
  local bwidth, twidth, iwidth
  put "Stack" && the short name of the topStack &&\
      "is not a mainStack." into line 1 of field 1
  put 0 into bwidth
  repeat with i = 2 to 5
    add the width of button i to bwidth
  end repeat
  put max(the formattedWidth of field 1 + 64, bwidth) into twidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  put (twidth - bwidth) div 5 into iwidth
  put iwidth into twidth
  repeat with i = 2 to 5
    set the left of button i to twidth
    add the width of button i + iwidth to twidth
  end repeat
end preOpenStack
           K n                B on mouseUp
  help
end mouseUp
          $ $              J            	   
   field id 1005  +        0  4         &Stack Message Box is not a mainStack.  Should it be made one?    Yes D`        F 8         	      No D`       ^ F 8         	      Cancel L`        F 8         	      Help Dp on mouseUp
  help
end mouseUp
         F 8         	      MC Stack Menu          d                   U 
helvetica       	pon preOpenStack
  local snames, nnames
  put the openStacks into snames
  delete line 1 of snames
  put min(the number of lines in snames, 7) into nnames
  set the height of this stack to nnames * 24 + 4
  repeat with i = 1 to 7
    set the name of button i to line i of snames
    set the visible of button i to i <= nnames
  end repeat
  if the lookAndFeel is "Windows 95"
  then set the backColor of me to "white"
  else set the backColor of me to empty
end preOpenStack
                              MetaCard Menu Bar Ti@                  	      Dialog Box Help Ti@        2          	      Concepts & Techniques Ti@        b          	      Find Ti@                  	       Ta@                  	      Home Ti@        z          	      Help Directory Ti@        J          	      Duplicate Stack Name         i0 e               
card id 1001   	P 
           0 e         Question Icon B          $ $              K            	      OK Lp +on mouseUp
  close this stack
end mouseUp
        R :          	   
   field id 1005  	        $  $         &A stack with this name already exists    	Importer   on returnKey
  send "mouseUp" to button "Import"
end returnKey

on returnInField
  send "mouseUp" to button "Import"
end returnInField

on preOpenStack
  set the label of button "Stack Name" to the short name of the topStack
  if the lookAndFeel is "Macintosh" or the lookAndFeel is "Appearance Manager"
  then set the textSize of button 1 to "12"
  else set the textSize of button 1 to empty
end preOpenStack
       k              U 
Helvetica   U 
Helvetica   U 
Helvetica   U 
helvetica   U 
helvetica    	Snapshot   	p on returnKey
  send "mouseUp" to button "Take Snapshot"
end returnKey

on returnInField
  send "mouseUp" to button "Take Snapshot"
end returnInField
                r  y  z  {  |  u Image   	`                 |  \      h EPS   	`                 |    g 
AudioClip   	`               |       
VideoClip   	@               |      r Take Snapshot Lp xon mouseUp
  close this stack
  set the defaultStack to the label of button "Stack Name"
  import snapshot
end mouseUp
          v         	   
  y   	           d          To take a snapshot, either just click on the window you want to capture, or click and drag out the area you want to capture.  Press the control key if you want to include the window border. Press the escape key to cancel the snapshot.   z Help Dp on mouseUp
  help
end mouseUp
       t  <         	     { Cancel Dp +on mouseUp
  close this stack
end mouseUp
          L         	     \ Import Lpon mouseUp
  local fname, fileonly
  put field "File Name" into fname
  close this stack
  put the hilite of button "Link Only" into fileonly
  set the defaultStack to the label of button "Stack Name"
  lock screen
  if fileonly then
    create image
    set the filename of the last image to fname
  else import paint from file fname
  set the loc of the last image to the loc of this card
  unlock screen
end mouseUp
          J         	  u    Import Lp on mouseUp
  local fname
  put field "File Name" into fname
  close this stack
  set the defaultStack to the label of button "Stack Name"
  import eps from file fname
end mouseUp
          J         	  h    Import Lp on mouseUp
  local fname
  put field "File Name" into fname
  close this stack
  set the defaultStack to the label of button "Stack Name"
  import audioClip from file fname
end mouseUp
          J         	  g    Import Lp on mouseUp
  local fname
  put field "File Name" into fname
  close this stack
  set the defaultStack to the label of button "Stack Name"
  import videoClip from file fname
end mouseUp
          J         	      tabs   )             New Button }    4on menuPick which
  go to card which
end menuPick

             'Snapshot
Image
EPS
AudioClip
VideoClip        	       | Stack Chooser   )         l    k Stack Name 4	e       x p@  	Importer      MC Stack Menu        	   	  u 	  g 	   	  h 
  m Find           p h            Put into stack:    
Link Only @E        $ l         	       Set Directory @E      D $ p         	       Common  )        
 &       w Cancel Dp +on mouseUp
  close this stack
end mouseUp
          L         	  u 	  g 	   	  h   ] Help Dp on mouseUp
  help
end mouseUp
       t  <         	  u 	  g 	   	  h   q 
Select... Dpon mouseUp
  local sfname, toffset
  answer file "Select file to import:"
  if there is a button "Set Directory" and the hilite of button "Set Directory" then
    put the effective fileName of stack (the label of button "Stack Name") into sfname
    set the itemDelimiter to "/"
    delete last item of sfname
    set the directory to sfname
    put "/" after sfname
    if the platform is "Win32" and char 1 of it is char 1 of sfname \
        or the platform is not "Win32" and item 2 of it is item 2 of sfname then
      repeat while char 1 of it is char 1 of sfname
        delete char 1 of it
        delete char 1 of sfname
      end repeat
      put offset("/", sfname) into toffset
      repeat while toffset is not 0
        put "../" before it
        delete char 1 to toffset of sfname
        put offset("/", sfname) into toffset
      end repeat
    end if
  end if
  put it into field "File Name"
end mouseUp
       x D @         	  u 	  g 	   	  h 
  n Find           , D            From file: 
  p 
File Name  i`        D\                Color Chooser   
}local oldhilite

on refresh
  local s1, s2, hb, c
  put the number of button "Foreground" into s1
  put the number of button "Foregroundcolor" into s2
  set the backcolor of button "Pencolor" to the penColor
  set the backcolor of button "Brushcolor" to the brushColor
  put the hilitedButtonName of group "Index" into hb
  if hb is not "answer" then
    if the selectedObject is empty then
      set the label button "ink" to " "
      put empty into c
      if hb is not "Pen" and hb is not "Brush"
      then set the hilitedButtonName of group "Index" to "Pen"
      repeat with i = s1 to s1 + 7
        disable button i
      end repeat
    else
      set the label button "ink" to the ink of the selectedObject
      put the colors of the selobj into c
      repeat with i = s1 to s1 + 7
        enable button i
        set the label of button i to empty
      end repeat
      if hb is "Pen" or hb is "Brush"
      then set the hilitedButtonName of group "Index" to "Foreground"
      if word 1 of the name of the selobj is "graphic" then
        set the label of button s1 to "Line"
        set the label of button (s1 + 1) to "Fill"
        set the label of button (s1 + 2) to "Marker"
        set the label of button (s1 + 3) to "Marker Fill"
      end if
    end if
    repeat with i = s2 to s2 + 8
      set the backcolor of button i to line i - s2 + 1 of c
    end repeat
  end if
  send "resetcontrols" to group the selectedText of button "Chooser Type"
end refresh

on preOpenStack
  if the lookAndFeel is "Macintosh" or the lookAndFeel is "Appearance Manager"
  then set the textsize of button 1 to 10
  else set the textsize of button 1 to empty
  set the itemDelimiter to numToChar(0)
  if item 1 of the dialogData is "answer color" then
    set the width of me to 224
    set the height of me to 288
    set the width of button 1 to 212
    put the hilitedButtonName of group "Index" into oldhilite
    set the hilitedButtonName of group "Index" to "answer"
    if item 3 of the dialogData is empty
    then set the backcolor of button "answerColor" to the penColor
    else set the backcolor of button "answerColor" to item 3 of the dialogData
    hide group "Patches"
    hide group "Index"
    set the dialogData to empty
  else
    set the width of me to 456
    set the height of me to 242
    if the lookAndFeel is "Appearance Manager" and char 1 of the systemVersion is 1
    then set the width of button 1 to 208
    else set the width of button 1 to 444
    show group "Patches"
    show group "Index"
  end if
  refresh
end preOpenStack

on closeStack
  if oldhilite is not empty then set the hilitedButtonName of group "Index" to oldhilite
end closeStack
  @     ?              U 
Helvetica   U 
Helvetica  
 U 
Helvetica  
 U 
helvetica   U 
helvetica       	PIon setcolor which
  local cindex, setstring
  put the short name of button (the hilitedButton of group "Index")\
      of group "Index" into cindex
  put "color" after cindex
  set the backColor of button cindex to which
  if cindex is "PenColor"
  then set the penColor to which
  else if cindex is "BrushColor"
  then set the brushColor to which
  else if the selectedObject is not empty then
    repeat for each line l in the selectedObjects
      put format("set the %s of %s to \"%s\"\n", cindex, l, which) after setstring
    end repeat
    do setstring
  end if
end setcolor

function getcolor nameOK
  local cindex
  put the short name of button (the hilitedButton of group "Index")\
      of group "Index" into cindex
  put "color" after cindex
  if nameOK or the number of items in the backColor of button cindex is 3
  then return the backColor of button cindex
  else
    get the effective backPixel of button cindex
    set the backColor of button cindex to empty
    set the backPixel of button cindex to it
    return the effective backColor of button cindex
  end if
end getcolor
                                       
Chooser Type =   on menuPick newgroup, oldgroup
  hide group oldgroup
  send "resetcontrols" to group newgroup
  show group newgroup
end menuPick
  @           Palette
Name
RGB
HSV        	        Palette   ) aon resetControls
  set the selectedColor of colorPalette 1 to getcolor(false)
end resetControls
              
 
Color map   	p ;on mouseUp
  setcolor the selectedColor of me
end mouseUp
   ||        $     Name   ! on resetControls
  put getcolor(true) into field "Color Name"
  get the short name of button (the hilitedButton of group "Index") of group "Index"
  set the disabled of button "Clear" to it is "Pen" or it is "Brush"
end resetControls
  @       $  
   Color Name  ip 8on closefield
  setcolor the text of me
end closefield
  @       (           0,0,0 
  + Color Names  )p [on mouseUp
  get the clickText
  setcolor it
  put it into field "Color Name"
end mouseUp
         L             
AliceBlue  
AntiqueWhite  AntiqueWhite1  AntiqueWhite2  AntiqueWhite3  AntiqueWhite4  Aquamarine  Aquamarine1  Aquamarine2  Aquamarine3  Aquamarine4  Azure  Azure1  Azure2  Azure3  Azure4  Beige  Bisque  Bisque1  Bisque2  Bisque3  Bisque4  Black  BlanchedAlmond  Blue  Blue1  Blue2  Blue3  Blue4  BlueViolet  Brown  Brown1  Brown2  Brown3  Brown4  
Burlywood  Burlywood1  Burlywood2  Burlywood3  Burlywood4  
CadetBlue  CadetBlue1  CadetBlue2  CadetBlue3  CadetBlue4  Chartreuse  Chartreuse1  Chartreuse2  Chartreuse3  Chartreuse4  
Chocolate  Chocolate1  Chocolate2  Chocolate3  Chocolate4  Coral  Coral1  Coral2  Coral3  Coral4  	CornSilk  
CornSilk1  
CornSilk2  
CornSilk3  
CornSilk4  CornflowerBlue  Cyan  Cyan1  Cyan2  Cyan3  Cyan4  	DarkBlue  	DarkCyan  DarkGoldenrod  DarkGoldenrod1  DarkGoldenrod2  DarkGoldenrod3  DarkGoldenrod4  	DarkGray  
DarkGreen  
DarkKhaki  DarkMagenta  DarkOliveGreen  DarkOliveGreen1  DarkOliveGreen2  DarkOliveGreen3  DarkOliveGreen4  DarkOrange  DarkOrange1  DarkOrange2  DarkOrange3  DarkOrange4  DarkOrchid  DarkOrchid1  DarkOrchid2  DarkOrchid3  DarkOrchid4  DarkRed  DarkSalmon  
DarkSeaGreen  DarkSeaGreen1  DarkSeaGreen2  DarkSeaGreen3  DarkSeaGreen4  DarkSlateBlue  DarkSlateGray  DarkSlateGray1  DarkSlateGray2  DarkSlateGray3  DarkSlateGray4  DarkTurquoise  DarkViolet  	DeepPink  
DeepPink1  
DeepPink2  
DeepPink3  
DeepPink4  DeepSkyBlue  
DeepSkyBlue1  
DeepSkyBlue2  
DeepSkyBlue3  
DeepSkyBlue4  DimGray  DodgerBlue  DodgerBlue1  DodgerBlue2  DodgerBlue3  DodgerBlue4  
Firebrick  Firebrick1  Firebrick2  Firebrick3  Firebrick4  FloralWhite  ForestGreen  
Gainsboro  GhostWhite  Gold  Gold1  Gold2  Gold3  Gold4  
Goldenrod  Goldenrod1  Goldenrod2  Goldenrod3  Goldenrod4  Gray  Gray0  Gray0  Gray1  Gray10  Gray100  Gray11  Gray12  Gray13  Gray14  Gray15  Gray16  Gray17  Gray18  Gray19  Gray2  Gray20  Gray21  Gray22  Gray23  Gray24  Gray25  Gray26  Gray27  Gray28  Gray29  Gray3  Gray30  Gray31  Gray32  Gray33  Gray34  Gray35  Gray36  Gray37  Gray38  Gray39  Gray4  Gray40  Gray41  Gray42  Gray43  Gray44  Gray45  Gray46  Gray47  Gray48  Gray49  Gray5  Gray50  Gray51  Gray52  Gray53  Gray54  Gray55  Gray56  Gray57  Gray58  Gray59  Gray6  Gray60  Gray61  Gray62  Gray63  Gray64  Gray65  Gray66  Gray67  Gray68  Gray69  Gray7  Gray70  Gray71  Gray72  Gray73  Gray74  Gray75  Gray76  Gray77  Gray78  Gray79  Gray8  Gray80  Gray81  Gray82  Gray83  Gray84  Gray85  Gray86  Gray87  Gray88  Gray89  Gray9  Gray90  Gray91  Gray92  Gray93  Gray94  Gray95  Gray96  Gray97  Gray98  Gray99  Green  Green1  Green2  Green3  Green4  GreenYellow  	Honeydew  
Honeydew1  
Honeydew2  
Honeydew3  
Honeydew4  HotPink  	HotPink1  	HotPink2  	HotPink3  	HotPink4  
IndianRed  IndianRed1  IndianRed2  IndianRed3  IndianRed4  Ivory  Ivory1  Ivory2  Ivory3  Ivory4  Khaki  Khaki1  Khaki2  Khaki3  Khaki4  	Lavender  LavenderBlush  LavenderBlush1  LavenderBlush2  LavenderBlush3  LavenderBlush4  
LawnGreen  
LemonChiffon  LemonChiffon1  LemonChiffon2  LemonChiffon3  LemonChiffon4  
LightBlue  LightBlue1  LightBlue2  LightBlue3  LightBlue4  LightCoral  
LightCyan  LightCyan1  LightCyan2  LightCyan3  LightCyan4  LightGoldenrod  LightGoldenrod1  LightGoldenrod2  LightGoldenrod3  LightGoldenrod4  LightGoldenrodYellow  
LightGray  LightGreen  
LightPink  LightPink1  LightPink2  LightPink3  LightPink4  LightSalmon  
LightSalmon1  
LightSalmon2  
LightSalmon3  
LightSalmon4  LightSeaGreen  
LightSkyBlue  LightSkyBlue1  LightSkyBlue2  LightSkyBlue3  LightSkyBlue4  LightSlateBlue  LightSlateGray  LightSteelBlue  LightSteelBlue1  LightSteelBlue2  LightSteelBlue3  LightSteelBlue4  LightYellow  
LightYellow1  
LightYellow2  
LightYellow3  
LightYellow4  
LimeGreen  Linen  Magenta  	Magenta1  	Magenta2  	Magenta3  	Magenta4  Maroon  Maroon1  Maroon2  Maroon3  Maroon4  MediumAquamarine  MediumBlue  MediumForestGreen  MediumGoldenrod  
MediumOrchid  MediumOrchid1  MediumOrchid2  MediumOrchid3  MediumOrchid4  
MediumPurple  MediumPurple1  MediumPurple2  MediumPurple3  MediumPurple4  MediumSeaGreen  MediumSlateBlue  MediumSpringGreen  MediumTurquoise  MediumVioletRed  
MidnightBlue  
MintCream  
MistyRose  MistyRose1  MistyRose2  MistyRose3  MistyRose4  	Moccasin  NavajoWhite  
NavajoWhite1  
NavajoWhite2  
NavajoWhite3  
NavajoWhite4  Navy  	NavyBlue  OldLace  
OliveDrab  OliveDrab1  OliveDrab2  OliveDrab3  OliveDrab4  Orange  Orange1  Orange2  Orange3  Orange4  
OrangeRed  OrangeRed1  OrangeRed2  OrangeRed3  OrangeRed4  Orchid  Orchid1  Orchid2  Orchid3  Orchid4  PaleGoldenrod  
PaleGreen  PaleGreen1  PaleGreen2  PaleGreen3  PaleGreen4  PaleTurquoise  PaleTurquoise1  PaleTurquoise2  PaleTurquoise3  PaleTurquoise4  PaleVioletRed  PaleVioletRed1  PaleVioletRed2  PaleVioletRed3  PaleVioletRed4  PapayaWhip  
PeachPuff  PeachPuff1  PeachPuff2  PeachPuff3  PeachPuff4  Peru  Pink  Pink1  Pink2  Pink3  Pink4  Plum  Plum1  Plum2  Plum3  Plum4  PowderBlue  Purple  Purple1  Purple2  Purple3  Purple4  Red  Red1  Red2  Red3  Red4  
RosyBrown  RosyBrown1  RosyBrown2  RosyBrown3  RosyBrown4  
RoyalBlue  RoyalBlue1  RoyalBlue2  RoyalBlue3  RoyalBlue4  SaddleBrown  Salmon  Salmon1  Salmon2  Salmon3  Salmon4  SandyBrown  	SeaGreen  
SeaGreen1  
SeaGreen2  
SeaGreen3  
SeaGreen4  	Seashell  
Seashell1  
Seashell2  
Seashell3  
Seashell4  Sienna  Sienna1  Sienna2  Sienna3  Sienna4  SkyBlue  	SkyBlue1  	SkyBlue2  	SkyBlue3  	SkyBlue4  
SlateBlue  SlateBlue1  SlateBlue2  SlateBlue3  SlateBlue4  
SlateGray  SlateGray1  SlateGray2  SlateGray3  SlateGray4  Snow  Snow1  Snow2  Snow3  Snow4  SpringGreen  
SpringGreen1  
SpringGreen2  
SpringGreen3  
SpringGreen4  
SteelBlue  SteelBlue1  SteelBlue2  SteelBlue3  SteelBlue4  Tan  Tan1  Tan2  Tan3  Tan4  Thistle  	Thistle1  	Thistle2  	Thistle3  	Thistle4  Tomato  Tomato1  Tomato2  Tomato3  Tomato4  Transparent  
Turquoise  Turquoise1  Turquoise2  Turquoise3  Turquoise4  Violet  
VioletRed  VioletRed1  VioletRed2  VioletRed3  VioletRed4  Wheat  Wheat1  Wheat2  Wheat3  Wheat4  White  WhiteSmoke  Yellow  Yellow1  Yellow2  Yellow3  Yellow4  YellowGreen       )`        M     Clear Ep Mon mouseUp
  setcolor empty
  put empty into field "Color Name"
end mouseUp
         ( 0         	        RGB   !#on scrollbarDrag
  local newcolor
  put the thumbPos of scrollbar "R", the thumbPos of scrollbar "G", the thumbPos of scrollbar "B" into newcolor
  setcolor newcolor
end scrollbarDrag

on resetcontrols
  local pcolor
  put getcolor(false) into pcolor
  if the number of items in pcolor is not 3
  then put "0,0,0" into pcolor
  lock messages
  set the thumbPos of scrollbar "R" to item 1 of pcolor
  set the thumbPos of scrollbar "G" to item 2 of pcolor
  set the thumbPos of scrollbar "B" to item 3 of pcolor
  unlock messages
end resetcontrols
  @       0  
   LabelR  )         B             R:   2 R  a       $ 4  $  (k   0  255         3 G  a       $ h  $  (k   0  255         4 B  a       $   $  (k   0  255       
   LabelG  )         v             G: 
   LabelB  )                      B:    HSV   !on scrollbarDrag
  setcolor HSVtoRGB(the thumbPos of scrollbar "H", the thumbPos of scrollbar "S", the thumbPos of scrollbar "V")
end scrollbarDrag

function RGBtoHSV r, g, b
  local maxv, minv, diff, s, rc, gc, bc, h
  set the numberFormat to "0.###############"
  put r / 255 into r
  put g / 255 into g
  put b / 255 into b
  put max(r,g,b) into maxv
  put min(r,g,b) into minv
  put maxv - minv into diff
  if maxv <> 0 and diff <> 0 then
    put diff / maxv into s
    put (maxv - r) / diff into rc
    put (maxv - g) / diff into gc
    put (maxv - b) / diff into bc
    if r = maxv then put bc - gc into h
    else if g = maxv then put 2 + rc - bc into h
  else if b = maxv then put 4 + gc - rc into h
  multiply h by 60
  if h < 0 then
    add 360 to h
  end if
else
  put 0 into s
  put 0 into h
end if
return round(h),round(s * 100),round(maxv * 100)
end RGBtoHSV

function HSVtoRGB h, s, v
  local rgb, i, f, p, q, t
  set the numberFormat to "0.###############"
  divide s by 100
  divide v by 100
  if s is 0 then put v,v,v into rgb
  else
    divide h by 60
    put trunc(h) into i
    put h - i into f
    put v * (1 - s) into p
    put v * (1 - s * f) into q
    put v * (1 - s * (1- f)) into t
    if i is 0 then put v,t,p into rgb
    if i is 1 then put q,v,p into rgb
    if i is 2 then put p,v,t into rgb
    if i is 3 then put p,q,v into rgb
    if i is 4 then put t,p,v into rgb
    if i is 5 then put v,p,q into rgb
  end if
  return round(item 1 of rgb * 255), round(item 2 of rgb * 255), round(item 3 of rgb * 255)
end HSVtoRGB

on resetcontrols
  local pcolor
  put getcolor(false) into pcolor
  if the number of items in pcolor is not 3
  then put "0,0,0" into pcolor
  put RGBtoHSV(item 1 of pcolor, item 2 of pcolor, item 3 of pcolor) into pcolor
  lock messages
  set the thumbPos of scrollbar "H" to item 1 of pcolor
  set the thumbPos of scrollbar "S" to item 2 of pcolor
  set the thumbPos of scrollbar "V" to item 3 of pcolor
  unlock messages
end resetcontrols
  @       0     H  a       $ 4  $Um/[     359          S  a       $ h  $/h     100          V  a       $   $ې/h     100       
   LabelH  )         B             H: 
   LabelS  )         v             S: 
   LabelV  )        
              V: 
    	@         (            ink:    ink 	u on menuPick which
  if the selectedObject is empty then exit menuPick
  set the ink of the selectedObject to which
end menuPick
       0    srcCopy    clear
srcAnd
srcAndReverse
srcCopy
notSrcAnd
noop
srcXor
srcOr
notSrcOrReverse
notSrcXor
reverse
srcOrReverse
notSrcCopy
notSrcOr
notSrcOrReverse
set
-
srcBic
notSrcBic
blend
addpin
addOver
subPin
transparent
addMax
subOver
adMin        	        Index    bon mouseUp
  send "resetcontrols" to group the selectedText of button "Chooser Type"
end mouseUp
  @       ,    e Foreground  E        0 d         	       f Background  E        P d         	       g Hilite  E        p d         	       h Border  E         d         	      i Top  E      x 0 L         	       j Bottom  E      x P L         	       k Shadow  E      x p L         	       l Focus  E      x  L         	       c Pen  E         d         	       d Brush  E      x  L         	        answer  E        h         	        OK Lp on mouseUp
  if not the visible of group "Patches" then # answer color mode
    set the dialogData to the backColor of button "answerColor"
    close this stack
  end if
end mouseUp
          4         	      Cancel Dp +on mouseUp
  close this stack
end mouseUp
          <         	      Patches  i         ,    z 	Pencolor Ag                         	       { Brushcolor Ag      `            	       | Foregroundcolor Ag        0           	       } Backgroundcolor Ag        P           	       ~ Hilitecolor Ag        p           	        Bordercolor Ag                   	        	Topcolor Ag      ` 0           	        Bottomcolor Ag      ` P           	        Shadowcolor Ag      ` p           	        Focuscolor Ag      `            	        answerColor Ag             d            	       * Graphic Markers           H               Graphic Markers Card   	Plocal targetgraphic

on setprops
  lock screen
  select targetgraphic
  set the markerPoints of the selectedObject to field "Points"
  set the markerLineSize of the selectedObject to field "Line Size"
  set the markerFilled of the selectedObject to the hilite of button "Marker Filled"
  set the markerDrawn of the selectedObject to the hilite of button "Marker Drawn"
  unlock screen
  close this stack
end setprops

on mouseUp
  if word 1 of the target is "graphic" then
    put the markerPoints of the target into field "Points"
    set the markerPoints of graphic "Example" to field "Points"
    send "setone" to scrollbar "Scale"
    set the hilite of button "Marker Drawn" to true
  end if
end mouseUp

on preOpenCard
  if word 1 of of the selectedObject is not "graphic"
  then exit to MetaCard
  put the long id of the selectedObject into targetgraphic
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "Name"
  else put empty into field "Name"
  put the short id of the selectedObject into field "Id"
  put markerPoints of the selectedObject into field "Points"
  set the markerPoints of graphic "Example" to the markerPoints of the selectedObject
  put the markerLineSize of the selectedObject into field "Line Size"
  set the thumbPos of scrollbar "Line Size" to field "Line Size" * 1800
  set the markerLineSize of graphic "Example" to field "Line Size"
  set the hilite of button "Marker Drawn" to the markerDrawn of the selectedObject
  set the hilite of button "Marker Filled" to the markerFilled of the selectedObject
  send "setone" to scrollbar "Scale"
end preOpenCard
           H    
    '    (    
                      #  $  %    &  )  *
            D                Id: 
   Id  	       d  <             1003    OK Mp #on mouseUp
  setprops
end mouseUp
        " L         	        Cancel Ep :on mouseUp
  select empty
  close this stack
end mouseUp
         L         	        Help Ep on mouseUp
  help
end mouseUp
       6 L         	     
  
 Name          x                
               l             Graphic Name:   
   	  ff             < 4                  L D     	  33          4                  D     	         < \                   L l     	  rr     h 4                        x D   Example  	       B                         R 
   Points  )`      " N l          0,-12  12,0  0,12  -12,0  0,-12       	`      z N  
             , <             Points:   # 
Line Size   ip on scrollbarDrag
  put round(the thumbpos of me / 1800) into field "Line Size"
  set the markerLineSize of graphic "Example" to field "Line Size"
end scrollbarDrag
         N  
  $ 
Line Size                        4 
  %            , D            
lineSize: 
   Scale            0             1.00 
              , 8             Scale:    Scale   ip}local savepoints

on setone
  set the numberFormat to 0.00
  set the thumbpos of me to 13200
  put the thumbpos of me / 14700 + 0.1 into field "Scale"
  set the numberFormat to 0.######
end setone

on mouseDown
  put field "Points" into savepoints
  pass mouseDown
end mouseDown

on scrollbarDrag
  local scalefactor, newpoints, tline
  set the numberFormat to 0.00
  put the thumbpos of me / 14700 + 0.1 into scalefactor
  put scalefactor into field "Scale"
  put empty into newpoints
  set the numberFormat to 0.######
  repeat with i = 1 to the number of lines in savepoints
    put line i of savepoints into tline
    if tline is not empty
    then put round(item 1 of tline * scalefactor),\
          round(item 2 of tline * scalefactor) into line i of newpoints
  end repeat
  put newpoints into field "Points"
  set the markerPoints of graphic "Example" to newpoints
end scrollbarDrag
         N  3	  & Clear Ep 8on mouseUp
  put empty into field "points"
end mouseUp
       "  p         	       '   	              \                          l  (   	       h \         !      	 
          
  	 	  
          
 	          x l  ) 
Marker Drawn @E         t         	      * Marker Filled @E         t         	        Page Setup           ] hX             U 
Helvetica    Print Setup Card   	P3function cn fieldname
  if field fieldname is not a number or field fieldname < 0 then
    beep 1
    select text of field fieldname
    return true
  end if
  return false
end cn

on setprops
  local pwidth, pheight, swidth, sheight, pscale
  if cn("Top") or cn("Bottom") or cn("Left") or cn("Right")
  then exit to MetaCard
  send "setMargins" to group "Units"
  if cn("Scale")
  then exit to MetaCard
  if the printRotated then
    put item 1 of the the printPaperSize into pheight
    put item 2 of the the printPaperSize into pwidth
  else
    put item 1 of the the printPaperSize into pwidth
    put item 2 of the the printPaperSize into pheight
  end if
  subtract item 1 of the printMargins + item 3 of the printMargins from pwidth
  subtract item 2 of the printMargins + item 4 of the printMargins from pheight
  put the width of stack (the short name of button id 1109) into swidth
  put the height of stack (the short name of button id 1109) into sheight
  if the hilite of button "Pack Horizontally" then
    subtract (field "Scale" - 1) * item 2 of the printGutters from pwidth
    put pwidth / (swidth * field "Scale") into pscale
    if sheight * pscale > pheight
    then set the printScale to pheight / sheight
    else set the printScale to pscale
  else
    subtract (field "Scale" - 1) * item 1 of the printGutters from pheight
    put pheight / (sheight * field "Scale") into pscale
    if swidth * pscale > pwidth
    then set the printScale to pwidth / swidth
    else set the printScale to pscale
  end if
  set the printCardBorders to the hilite of button "Print Card Borders"
  set the printColors to the hilite of button "Color"
  close this stack
end setprops

on preOpenCard
  local sname, c
  put the short name of the topStack into sname
  set the name of button id 1109 to sname
  send "loadMargins" to group "Units"
  send "resetMargins" to group "Units"
  set the hilite of button "Print Card Borders" to the printCardBorders
  set the hilite of button "Color" to the printColors
  set the hilite of button "Black and White" to not the printColors
end preOpenCard
           hX  V  S  T  {  o            U  Y  Z  ~   OK Mp #on mouseUp
  setprops
end mouseUp
        $1 J         	        Cancel Ep +on mouseUp
  close this stack
end mouseUp
        0 L         	        Help Ep on mouseUp
  help
end mouseUp
        0 L         	     
  S Scale  i`       , (          1   T    ip on scrollbarLineInc
  if cn("Scale")
  then exit to MetaCard
  if field "Scale" > 1 then subtract 1 from field "Scale"
end scrollbarLineInc

on scrollbarLineDec
  if cn("Scale")
  then exit to MetaCard
  add 1 to field "Scale"
end scrollbarLineDec
       D *   Z	  U Page Setup 4	e       <   Page Setup      MC Stack Menu        	   
  Y             8            Stack: 
  Z Cards           ,             Cards per row:   V Packing            &  8  W Pack Horizontally  E Don mouseUp
    put "Cards per row:" into field "Cards"
end mouseUp
        
 *          	      X Pack Vertically  E Eon mouseUp
  put "Cards per column:" into field "Cards"
end mouseUp
        
 B x         	       { Print Card Borders @E        L          	       o Margins  )0(on scrollbarLineInc
  if cn("Top") or cn("Bottom") or cn("Left") or cn("Right")
  then exit to MetaCard
  if the hilite of button "Points"
  then subtract 1 from field (the short name of the target)
  else subtract 0.1 from field (the short name of the target)
end scrollbarLineInc

on scrollbarLineDec
  if cn("Top") or cn("Bottom") or cn("Left") or cn("Right")
  then exit to MetaCard
  if the hilite of button "Points"
  then add 1 to field (the short name of the target)
  else add 0.1 to field (the short name of the target)
end scrollbarLineDec
         ^Z   ^ Units   >local pmargins, pgutters

on loadMargins
  put the printMargins into pmargins
  put the printGutters into pgutters
end loadMargins

on resetMargins
  local factor
  put 1 into factor
  if the hilite of button "inches" then put 72 into factor
  if the hilite of button "cms" then put 72/2.54 into factor
  put item 1 of pmargins / factor into field "Left"
  put item 2 of pmargins / factor into field "Top"
  put item 3 of pmargins / factor into field "Right"
  put item 4 of pmargins / factor into field "Bottom"
  put item 1 of pgutters / factor into field "Row"
  put item 2 of pgutters / factor into field "Column"
end resetMargins

on getMargins
  local factor, lmargin, tmargin, rmargin, bmargin, rgutter, cgutter
  put 1 into factor
  if the hilitedButton of group "Units" is 1
  then put 72 into factor
  if the hilitedButton of group "Units" is 2
  then put 72/2.54 into factor
  put round(field "Left" * factor) into lmargin
  put round(field "Top" * factor) into tmargin
  put round(field "Right" * factor) into rmargin
  put round(field "Bottom" * factor) into bmargin
  put lmargin, tmargin, rmargin, bmargin into pmargins
  put round(field "Row" * factor) into rgutter
  put round(field "Column" * factor) into cgutter
  put rgutter,cgutter into pgutters
end getMargins

on setMargins
  getMargins
  set the printMargins to pmargins
  set the printGutters to pgutters
end setMargins

on focusIn
  getMargins
end focusIn

on mouseUp
  local bname
  put the short name of the target into bname
  if bname is "inches" or bname is "cms" or bname is "points" then resetMargins
end mouseUp
        Z r     ` inches  E       ^ v L         	      _ cms  E        v 8         	       a points  E        v D         	     
  b             \            Top: 
  \ Top  i`       j  ,            1   ] Top   i`           H	
  c             [            Bottom: 
  f Bottom  i`       j  ,            1   i Bottom   i`           	
  u             \            Row Gutter: 
  v Row  i`       j  ,            0.5   x Row   i`           l	
  d             l            Left: 
  g Left  i`        ,            1   j Left   i`      J      	
  e             l            Right: 
  h Right  i`        ,            1   k Right   i`      J      	
  w             l            Column Gutter: 
  y Column  i`        ,            0.5   z Column   i`      J      	
  |            t 8            Units: 
  ~            <            Output:    Printer... Ep on mouseUp
  if the platform is "Win32" or the platform is "MacOS"
  then answer printer
  else modeless "Printer Chooser"
end mouseUp
        D         	        Output           >     Color  E       B @         	       Black and White  E                 	        Stack Components    on openCard
  send "refresh" to this card
end openCard

on preOpenStack
  set the label of button "Stack Name" to the short name of the topStack
end preOpenStack
       m              U 
Helvetica   U 
helvetica   h    	pon refresh
  local sname, ncards, cnames
  put the label of button "Stack Name" into sname
  switch the selectedText of button "Type"
  case "Substacks"
    put the substacks of stack sname into cnames
    sort lines of cnames
    put cnames into field "List"
    break
  case "Audio Clips"
    put empty into field "List"
    repeat with i = 1 to the number of audioClips in stack sname
      put the short name of audioClip i of stack sname into line i of field "List"
    end repeat
    break
  case "Video Clips"
    put empty into field "List"
    repeat with i = 1 to the number of videoClips in stack sname
      put the short name of videoClip i of stack sname into line i of field "List"
    end repeat
    break
  case "Cards"
    put the cardNames of stack sname into field "List"
    break
  case "Externals"
    put the externals of stack sname into field "List"
    break
  end switch
end refresh

on doit
  local otype
  put the selectedText of button "Type" into otype
  switch otype
  case "Substacks"
    send "mouseUp" to button "Toplevel"
    break
  case "Audio Clips"
  case "Video Clips"
    send "mouseUp" to button "Play"
    break
  case "Cards"
    send "mouseUp" to button "Go"
    break
  case "Externals"
    send "mouseUp" to button "Add"
    break
  end switch
end doit
                      |        
   List  )p +on mouseDoubleUp
  doit
end mouseDoubleUp
         L p                  	`       M  n   Stack Name 4)}    Pon mouseUp
  set the cursor to watch
  send "refresh" to this card
end mouseUp
        < x  Stack Components      MC Stack Menu        	  h 
   Find            4            Stack:    Type u con menuPick newgroup, oldgroup
  hide group oldgroup
  show group newgroup
  refresh
end menuPick
         ,    2Substacks
Audio Clips
Video Clips
Cards
Externals        	       | Audio Clips   !        V      Play Dp on mouseUp
  local cname
  put the selectedText of field "List" into cname
  if cname is not empty then
    set the defaultStack to the label of button "Stack Name"
    play cname
  end if
end mouseUp
        Z  X         	  h    Delete Dp on mouseUp
  local cname
  put the selectedText of field "List" into cname
  if cname is not empty
  then delete audioClip cname of stack the label of button "Stack Name"
  refresh
end mouseUp
         X         	  h    Video Clips   a        V      Play Dp on mouseUp
  local cname
  put the selectedText of field "List" into cname
  if cname is not empty
  then play videoClip cname of stack the label of button "Stack Name"
end mouseUp
        Z  X         	  h    Delete Dp on mouseUp
  local cname
  put the selectedText of field "List" into cname
  if cname is not empty
  then delete videoClip cname of stack the label of button "Stack Name"
  refresh
end mouseUp
         X         	  h    
Externals   a        V      Add... Dpon mouseUp
  local f
  if the platform is "Win32"
  then put "*.dll" into f
  else put "*" into f
  answer file "Choose an external:" with "external" with filter f
  if it is not empty then
    set the itemDelimiter to "/"
    if field "List" is not empty
    then put return after field "List"
    put the last item of it after field "List"
    set the externals of stack the label of button "Stack Name" to field "List"
  end if
end mouseUp
        Z  X         	  h    Delete Dp on mouseUp
  delete line (word 2 of the selectedLine of field "List") of field "List"
  set the externals of stack the label of button "Stack Name" to field "List"
  refresh
end mouseUp
         X         	  h    
Substacks   i        V      	Toplevel Dp on mouseUp
  local cname
  put the selectedText of field "List" into cname
  if cname is not empty then
    set the defaultStack to the label of button "Stack Name"
    toplevel cname
  end if
end mouseUp
        Z  X         	  h 	   	  u 	   	  g    Delete Dp0on mouseUp
  local cname
  put the selectedText of field "List" into cname
  if cname is not empty then
    answer "Delete stack" && cname &&"?" with "OK" or "Cancel"
    if it is "OK" then
      delete stack cname of stack the label of button "Stack Name"
      refresh
    end if
  end if
end mouseUp
         X         	  h 	   	  u 	   	  g    Cards   a        $ d (   Go Dp on mouseUp
  get the hilitedLines of field "List"
  if it is not empty
  then go to card it of stack the label of button "Stack Name"
end mouseUp
        (  X         	  h    first Cpion mouseUp
  local selcard
  get the hilitedLines of field "List"
  if it is empty
  then exit mouseUp
  set the number of card it of stack (the label of button "Stack Name") to 1
  put line it of field "List" into selcard
  delete line it of field "List"
  put selcard &cr before line 1 of field "List"
  set the hilitedLines of field "List" to 1
end mouseUp
         $   Move to first               F             	        up Cpon mouseUp
  local selcard
  get the hilitedLines of field "List"
  if it is empty or it is 1
  then exit mouseUp
  set the number of card it of stack (the label of button "Stack Name") to it - 1
  put line it of field "List" into selcard
  delete line it of field "List"
  put selcard & cr before line it - 1 of field "List"
  set the hilitedLines of field "List" to it - 1
end mouseUp
         $   Move up               E             	        down Cpon mouseUp
  local selcard
  get the hilitedLines of field "List"
  if it is empty or it is the number of lines in field "List"
  then exit mouseUp
  set the number of card it of stack (the label of button "Stack Name") to it + 1
  put line it of field "List" into selcard
  delete line it of field "List"
  put cr & selcard after line it of field "List"
  set the hilitedLines of field "List" to it + 1
end mouseUp
         $   
Move down               D             	        last Cpon mouseUp
  local selcard
  get the hilitedLines of field "List"
  if it is empty
  then exit mouseUp
  set the number of card it of stack (the label of button "Stack Name")\
      to the number of lines in field "List"
  put line it of field "List" into selcard
  delete line it of field "List"
  put cr & selcard after field "List"
  set the hilitedLines of field "List" to the number of lines in field "List"
end mouseUp
         $   
Move to last               C             	        Delete Dpon mouseUp
  local cname, cid
  put the selectedText of field "List" into cname
  if there is a card cname of stack the label of button "Stack Name"
  then delete card cname of stack the label of button "Stack Name"
  else if word 1 to 2 of cname is "card id" then
           put word 3 of cname into cid
           if there is a card id cid of stack the label of button "Stack Name"
           then delete card id cid of stack the label of button "Stack Name"
         end if
  refresh
end mouseUp
       ,  X         	  h    HyperCard Import Status                          U Courier       	Pon preOpenCard
  put the HCImportStat into field 1
end preOpenCard

on resizeStack
  set the rect of field 1 to 8,8,the width of this stack - 8,the height of this stack - 48
  set the loc of button 1 to the width of this stack div 2, the height of this stack -24
end resizeStack
                
     	h                              	`            OK Ep Don mouseUp
  put empty into field 1
  close this stack
end mouseUp
          \         	        MC Main Stack Menu          }>  P           P P          	pon preOpenStack
  local snames, nnames
  if the short name of the topStack is not in the mainStacks
  then put the short name of the topStack & return into snames
  put the mainStacks after snames
  put min(the number of lines in snames, 7) into nnames
  set the height of this stack to nnames * 24 + 8
  repeat with i = 1 to 7
    set the name of button i to line i of snames
    set the visible of button i to i <= nnames
  end repeat
end preOpenStack
             P                 MetaCard Menu Bar Ti@                  	      Message Filter Ti@        4          	       Ta@        d          	      Home Ti@                  	       Ta@                  	       Ta@        |          	       Ta@        L          	       Edit PostScript            black    white   M                   e Editor Card   	P!local targetobject

on escapeKey
end escapeKey

on setprops
  set the postscript of targetobject to field "Editor Field"
end setprops

on resizeStack
  local cwidth, cheight, nb, twidth, ispace, tpos, halfwidth
  put the width of me into cwidth
  put the height of me into cheight
  set the width of field "Editor Field" to cwidth - 8
  set the left of field "Editor Field" to 4
  set the height of field "Editor Field" to cheight - 56
  set the top of field "Editor Field" to 8
  put the number of buttons into nb
  put 0 into twidth
  repeat with i = 1 to nb
     add the width of button i to twidth
  end repeat
  if (twidth < cwidth)
  then put (cwidth - twidth) div (nb + 1) into ispace
  else put 0 into ispace
  put 0,(cheight - 24) into tpos
  repeat with i = 1 to nb
    put (the width of button i) div 2 into halfwidth
    add ispace + halfwidth to item 1 of tpos
    set the loc of button i to tpos
    add halfwidth to item 1 of tpos
  end repeat
end resizeStack

on preOpenCard
  put empty into targetobject
  if the selobj is not empty and word 1 of the name of the selobj is "EPS" then
    put the long id of the selobj into targetobject
    put the postscript of the the selobj into field "Editor Field"
  end if
end preOpenCard 

on closeCard
  put empty into field "Editor Field"
end closeCard
                          
    
Editor Field  )p 8on tabKey
  put "  " into the selectedChunk
end tabKey
                 
l        e         	`       
 X       	a       b     OK Dp 6on mouseUp
  setprops
  close this stack
end mouseUp
        ( A         	   e     Cancel Dp ,on mouseUp
   close this stack
end mouseUp
         A         	   e    
 Help Dp on mouseUp
  help
end mouseUp
       f A         	   e     
Import... Dpon mouseUp
  local fname
  answer file "PostScript file to import:"
  if it is not empty then
    put it into fname
    open file fname for read
    read from file fname until eof
    put it into field "Editor Field"
    close file fname
  end if
end mouseUp
         A         	   e    Audio            a                  	P on openCard
  set the thumbPos of scrollbar 1 to the playLoudness
  set the hilitedButtonName of group "dest" to the playDestination
end openCard
            a             q Zon mouseUp
  set the playLoudness to the thumbPos of me
  play "glissant.au"
end mouseUp
        H   $+   0  100       
               D            Volume: 
              < \            
Destination:    dest    fon mouseUp
  set the playDestination to the hilitedButtonName of me
  play "glissant.au"
end mouseUp
        \ 8     	internal @E       ` < P         	       	external @E        < T         	        glissant.au   	`         ggggg\[3M[L;[O>SK=:oERcʼ`v<GH<gUJ9U;>Xغ=BJ7WZrW<M==z;>H5Mb¼l^7H;;Է>6D5Ju]3>;5ڲ?6@3DJɳȽn99=1G[o\=[52VķSI>5N_gBD8:{UIEJ7F[ɾf<J>8mwkE=I5@]˻>IC6b|WR;N89Q@FN4SNnk<Z>9[Zq@>R7KO̾Wů(.:5XodFZW':<CW>/0NPH:Q9ϩ9503.)ǵHOK:).;5_½{<2I8.ANO?ꭸ:<5.)*kO5*+P7.]¶[F/?5/h[Mô'.>+)1ջܫ\%.L79Խ64KC'4C/m>&.0(=Ȯ>O -:5<ί3<F/!0B5ZϯkE'-`,$Iˬ<b"2.-Bʮ-B9&%;B:<٭:EU%6/)̪=T#F,,ͧN(J8$D?UNT.No6&8.'CJA#G%'/7"=63jO.+)9^+(>ƺB&L í/7$b./௟H,b",YN-24M4 +H!﫝G9$~()G)T.7-G=C)&2:$$A.%M%(įR2M//*ϵP7%-E.$)Fa)&@⧸,e2&$XA0DH#<H"O?V+S@ǫZ@XO)ٷ<,!nJ)3+ҠF+B~C349P:*&ƨ=D1.- :++#F)̼/4U˻%0FU'DBR&.I5,R#̱̞."/돜,8馮/I>(&6$46
Б/
'(O]*.
W͏ ɗ!ª?ۤگ"$.&@8'[4$#$#0'/p

B/+W1)#-旋7
F"?0)$9"#-	
G(BP.+].
"
9#*4#	)ˬ_
&&v
K̚9*#/-?F?
cJUU<Qɞ*('0<".,.6H?
$, N[d+!ő%/-0!ʕW1-0/(=#ϯ7X
)ҥ+$#K-IUE-=ݏ
!,=ɭk< d(,/4޼Šd&J1-5E/>->*)I"CHoGʹS@P2:];51.("0)7B<E_
ľ$+˟Y .lƚZ058㼢
%R%'A?).it, ,#Y!"#J#,q":<Ĺ)0)$8-'!Eٯ'1U,P ,# X7:ddA*"".V/.?K6Nk*8G*:q0Me,.ū©,#-D4%B<1$yGȚ+FhE=&.7FƶG.aT&5-!^98..9?,-((#)11Eǟ1 +V<b)/
6+0&EM*Bat.0@J'+d!ʞU8 !<7H:|7%+<&'ZI%$Fƣ::.F,ښ-3')%,"-
X>"*ǟ62W(Pܗ97/0))hJ-,X3=
+*٭+<>1/B.##1ɨ48$ٮ'+
:a'.1*ؘ2,/#
6,ԍں0'AK)
r9Ц47*K<5՝B(9߭
䩜D> ,=u	##&&,
"	$"GI*&&0"O(Eʈ%ȎI )
Q*:Z	 T0<|;ġ6#)!
 :&u#$OOH9
L܄0I܋2ĕ	_	 	ܳt8)Ք0+D .%$-.婢#*$67	j	A($œ>dKz-
-'
')N(&2P*!*-E5*3$
Iͣ#F;"$+
$.

#/))-HL%4R
Ę(%$I*--"
@

$50ǚ-W
2&zș 2=L&73	*G4+F`(V-);%"0,"):QS9M-Ў"
	0)9Б *HC/-*/*+^!47#B?ǜ@dW##Ė3."',!'P"%9溟!#): !+!'Kë
J)/ڎ---?$3	B=?Χ"/B48$O(Ɣ(.&!>"
#++r	"-B%0 .
2$.O^--"")+$6dQD=
SM!+,
34!$M?î	KfI',%0.k̍,7'.#@
0(
4!D*!!+%G%?Ҋ'IR1).O#0%F
U3  *5< 6(.ϓ,*j)E9W%˒<
$
c!17=98&4௎
=Y
-$3U1(ͤ/0-6.X,&-*'6K8+@-4&LǨ+ ,/IeV@!.$)[P8++ٟ=##(5_E+-=D#㥘+!^N-"4"$W+(D$H+#Y8.=$+Աۦ=*/r}.N8}"'.%2ؤ_S*!G>[oK&,:9< 
*#޼)װ0=#-),1گ85>+˪,5,)\˙#R	$)&7"5OM -Gu+1(!2!)-+/N[.J0'Yڪ/ <ӺKCWWIOL*#ZX&$.)vǟ@)u?!N>>F(-7.4-?9S).7D:1!1wɢ·!&*>-NeӽE<7E'(7(1-6 4;0@P.˦)';*&!.䯟'(.f-L)OFϟ#?#7D?""՟%!(#ZѡD7F?/.CS7/#(,)IK5,ݻ2++;bRם*$#M-౻Ю6>,ȹ,D*+˟'3LƼ60'/+i;.=B]4=;Ʈl>&) (ҫ&,/0S0+,35[?-ǻ?8$"dڥL8/)ȟִ'_A)=Ѹ7"<4V$)-$͸2?0 F'\Ϥ Z )62-Ω>G-?>?HG-#-YDkJ;H>uQ2,a(<HI1%$K4.)??lԻ?T7eaZPH6K-F§]$($0 &7ƦSZ #0-¨;/,P|H.+67gB<=$3=.c.*:-L9AT><4/030ϧ9/&-@LA8M>6H6p8}˻@H)%+4ȫW$()%ǿϭeH?@(OF:ٺ.P,3ˮI&+%/M61&'^7¯R@ /3aS.9AѢE'(",_QE+++Xϵ=&->UX^5IP1/0MzAR'2v?ϽC<2m2WZ.x"_O=)3D(8-/rx@C4>m/J4.ʪ+8#C.L$(j8@++9?,4/Y6469E=16%">H=Z4(IJZö80d8εȮM:<&:GȮ5),0Rڶ>@.;EhWl<Kĳ+/.$\;?.7@>ʴM[*hNA<72:θ;;.3@MӹD7J.8ȯX>467ǳ_UB+E8EjH-*'-9%%(;澱>N)8M3<E/A߮DX*#1.D0B,LN=̴^Z39H?2=>:ҾNR>7L7vSt9L2;_D9=?Bk7A:=s[6:9*AAδB?*-6<ضML;g@H?AMCŻ۹@25&8vʦ4@/.oEͱKj.S8_Ϯo?>"6Ez.<&.VA㼷6B,L+McT)O0\EG4+qGK+.=?ƽA2'F-ͻ-Q4C\?G߽9SN9R2b*@?,O3.>F9Yy7G\IM;.PCŬN7?)DV_;=C|7Olg;@9xPL79VO+60+O_>A%1.4Ϋ4-05mDK_>W>;>0O\j0]7B=C5Vh9EB4==5տ<v0*=/έHX-}1>9@6/9ȷKCJH/N2?谹Z7>?1^4Om,<40FH4@W6]_=UB;O:eTQ1J6Lje6~HVS<y6<FMºEM/,??˴V=1<5QVK=24CB̼ӾGFN5jQ>GDJl\C8I7CLSͼd7:4:˾yz=3<H̶LMK7OGVdDHD?VM^IpgM]|<UKGJM<;A.`OչQ3P.7]FĺF>3>2ʹJ6G;۶@WO0hʵWM6y3QfOdź?94_9ƹAQ8.JGʹ=D?/I8}J/N80CO@=O9Qܼ@T:lIO[A;tEܻMES0FI}E4>G=}ԼWE=M;xfDMU9YCDPC]SnJ[ISKi@L84XK980@VϿDI<7GOkL>8Kli>8;?^OAD;E`XI?>>\L><7@fɿI>;6G½D8>?\N>D?Xh~dkMPG[NrBR9HMY?I5:TCIONDgKPGOU=[mGU/OHS὿>c<@fF;_A;H>A5/T>ǶT:?+>=V޶=k,;M7ʸIo85N;NhP8eFXWJ2e=_Oj/=;=iD:;]:cJ]?=V=kXG3>7Y|6]D?LIGLaQ<UFCJJ<9dL̾WG@6OBIW3BIGBL;>[JKA;:AP_M;5A>}̿pD8UDeAE9>SjTD23:=r<;:4ROBNCXmhW<KDEO?>>HF?EGmLJS>a|]tiUE\J]IS=GZY{XCHJEkYLNj[yAFA<nտvGA7>DPT@=EEnkUDDYXWI?>NFOI7>FLSL:;IFaLB?EEzI=ECYW<IBGJ@H?kvkLtI^gyoSNIiTLO=GKOVAET?mYWZVJRUMGY@nbzbMbAZZNpLgBHO}GQL?SbJS<[RbIL:CSSJ[=?VBLZMCJORGN>Zb{GO;EXL_~HCODmmMBsHdlhZh@fLN_YEOOElVLKgJslVVMJqMURUYFTyZbQrB[dOwO[MOqS{gU^RY}X{e^JYJMUkTJL=WV_O[GK^N]WHNi[RZHK^U\n^D~WctV[DYm\UXHHZ[WrJH[K|\VD[DZ\YDTQJa]MOdJl[a|XYmOqjTo`HRdojrGvhQiuSnPZ[zmKmTKT}_TcYLWhT[PfKeg]akNmHVVhR[PQZk[RWMgkjYZGfY]W[MVg[zzNdTNo[}[VOG`Vh[WNVV]\mMUaS`yTRlO~|cowkS~X`zgnl{Smbb{_gSc\[g}WrT\V_SdYP]d\_U[Tabhe[mV]ien~fYxWra{orSZWV~aYY[OnsieWUNchujUVMY]^S^QPoU_[WN^Xiz\YOT[[kdSZY]{g|SYfWqgu[SaSb|o[a\^vg^[^gimg[[]_[jg_[b[n\b[ipggg][[ekg_[c[hngg^[_ylf[[[a~ogYX[^wvg[[[]pj[[[^u\[[\gg   @   Main Stack           ?"T                   	P on preOpenCard
  put the short name of the topStack into field "Stack Name"
  set the label of button "Stack Name" to the mainStack of the topStack
end preOpenCard
           T         
         Help Dp on mouseUp
  help
end mouseUp
         \ H         	   
   Find                        Set the mainStack of stack:    Stack Name 4)e       4 8  MetaCard Menu Bar      MC Main Stack Menu        	   
   Find           8 $            To: 
  
 Stack Name           (            Message Filter    Cancel Dp +on mouseUp
  close this stack
end mouseUp
         \ L         	      OK Mpon mouseUp
  local oldstack, newstack
  if the mainStack of stack (field "Stack Name") is not the label of button "Stack Name" then
    set the cursor to watch
    put the mainStack of stack (field "Stack Name") into oldstack
    put the label of button "Stack Name" into newstack
    set the mainStack of stack (field "Stack Name") to newstack
    save stack oldstack
    if the fileName of stack newstack is empty then
      ask "What file do you want to save this stack in?" with MCfixpath(the label of button "Stack Name")
      if it is empty
      then exit to MetaCard
      set the fileName of stack the label of button "Stack Name" to it
    end if
    save stack newstack
  end if
  close this stack
end mouseUp
          \ H         	        MC Toplevel Menu           8           8 8          	pon preOpenStack
  local snames, nnames
  get the openStacks
  put empty into snames
  repeat for each line l in it
    if the mode of stack l < 3 then put l & return after snames
  end repeat
  put min(the number of lines in snames, 7) into nnames
  set the height of this stack to nnames * 24 + 8
  repeat with i = 1 to 7
    set the name of button i to line i of snames
    set the visible of button i to i <= nnames
  end repeat
end preOpenStack
             8                 Stack 938569097 Ti@                  	       Ta@        4          	       Ta@        d          	      Script Profiler Ti@                  	       Ta@                  	       Ta@        |          	       Ta@        L          	      Custom Properties         	d        @      U 
Helvetica   U 
helvetica       	P
local objectid, newvalues, curcps, origcps

on getvalue which
  if which is empty then exit getvalue
  if keys(newvalues) contains which
  then put newvalues[which] into field "Value"
  else
    set the customPropertySet of objectid to curcps
    put the which of objectid into field "Value"
    set the customPropertySet of objectid to origcps
  end if
end getvalue

on editprop
  get the hilitedLines of field "Properties"
  if it is not empty and the selectedField is not empty and the short name of the selectedField is "Value"
  then put field "Value" into newvalues[line it of field "Properties"]
end editprop

on deleteprop
  get the hilitedLines of field "Properties"
  if it is not empty
  then delete variable newvalues[line it of field "Properties"]
end deleteprop

on setprops
  set the customPropertySet of objectid to curcps
  set the customKeys of objectid to field "Properties"
  repeat for each line l in keys(newvalues)
    set the l of objectid to newvalues[l]
  end repeat
  set the customPropertySet of objectid to origcps
  put empty into newvalues
end setprops

on getprops
  put the label of button "CPS" into curcps
  set the customPropertySet of objectid to curcps
  put the customKeys of objectid into field "Properties"
  set the customPropertySet of objectid to origcps
  sort field "Properties"
  put empty into field "Value"
end getprops

on preOpenCard
  local tprops
  put empty into newvalues
  put empty into objectid
  if the selectedObject is empty then exit to MetaCard
  put the long name of the selobj into field "Object Name"
  put the long id of the selobj into objectid
  put cr & the customPropertySets of the selobj into tprops
  put tprops into button "CPS"
  put the customPropertySet of the selobj into origcps
  lock messages
  set the menuhistory of button "CPS" to lineOffset(origcps, tprops)
  unlock messages
  getprops
end preOpenCard

on resizeStack
  local cwidth, cheight, bnames, cspace, tpos
  put the width of me into cwidth
  put the height of me into cheight
  set the width of field "Object Name" to cwidth - 8
  set the width of field "Properties" to cwidth div 3
  set the height of field "Properties" to the height of me - 92
  set the height of field "Value" to cheight - 160
  set the width of field "Value" to cwidth - the right of field "Properties" - 16
  set the left of field "Value" to the right of field "Properties" + 8
  set the left of field "CPS Label" to the left of field "Value"
  set the width of button "CPS" to the right of field "Value" - the right of field "CPS Label"
  set the left of button "CPS" to the right of field "CPS Label"
  put "OK,Cancel,Help" into bnames
  put cwidth into cspace
  repeat for each item i in bnames
    subtract the width of button i from cspace
  end repeat
  put cspace div (the number of items in bnames + 1) into cspace
  put cspace into tpos
  repeat for each item i in bnames
    set the left of button i to tpos
    set the bottom of button i to cheight - 12
    add cspace + the width of button i to tpos
  end repeat
  
  put "New Property...,Delete" into bnames
  subtract the left of field "Value" from cwidth
  repeat for each item i in bnames
    subtract the width of button i from cwidth
  end repeat
  put cwidth div (the number of items in bnames + 1) into cspace
  put cspace + the left of field "Value" into tpos
  repeat for each item i in bnames
    set the left of button i to tpos
    add cspace + the width of button i to tpos
  end repeat
end resizeStack
           d                    
   Object Name            (           @button "New Button" of card id 1002 of stack "Stack 1025219878" 
   Properties )p on getentry
  local cline
  put the hilitedLines of me into cline
  getvalue line cline of me, cline
end getentry

on mouseUp
  getentry
end mouseUp

on arrowKey
  getentry
end arrowKey

on focusIn
  getentry
end focusIn
         $                 	`        %        	a       	 |    OK Ep Aon mouseUp
  editprop
  setprops
  close this stack
end mouseUp
        ?< <         	        Help Ep on mouseUp
  help
end mouseUp
       5< @         	     
   Value )p )on closeField
  editprop
end closeField
         h                 	`       i     Cancel Ep non mouseUp
  put empty into field "Properties"
  put empty into field "Value"
  close this stack
end mouseUp
        < <         	        New Property... Epon mouseUp
  ask "New property name:"
  if it is not empty then
    if char 1 of it is a number or it contains space or it contains tab then
      answer "A custom property name must start with a letter"
      exit to MetaCard
    end if
    if field "Properties" is not empty
    then put return before it
    put it after field "Properties"
    set the hilitedLines of field "Properties" to the number of lines in field "Properties"
    put empty into field "Value"
    select before char 1 of field "Value"
  end if
end mouseUp
         @ t         	        Delete Epuon mouseUp
  local l
  put the hilitedLines of field "Properties" into l
  if l is not empty then
    deleteprop
    put empty into field "Value"
    delete line l of field "Properties"
    if field "Properties" is not empty then
      set the hilitedLines of field "Properties" to max(l - 1, 1)
      send "getentry" to field "Properties"
    end if
  end if
end mouseUp
       Q @ D         	     
   
CPS Label 	                      Custom Property Set:    CPS 	u Don menuPick newvalue
  editprop
  setprops
  getprops
end menuPick
       9  t      
        	        0 Script Editor    on openCard
  
end openCard
       U W4    debuggingScript   debuggingHandler  mouseUphistory  char 1 to 0 of field 5
tracemode                  U 
helvetica    U Courier  
 U Courier   U symbol   U Symbol    e Editor Card   	PB4local doneOpen
local handlerlines, notdoingclose
local tokencolors

on startDebug t, h, l, p
  get the debuggingScript of stack "Script Editor"
  if it is not empty and it is not the long id of me
  then send "stopDebug" to it
  set the debuggingScript of stack "Script Editor" to the long id of me
  set the debuggingHandler of stack "Script Editor" to h
  set the listBehavior of field "Editor Field" to true
  set the autoHilite of field "Editor Field" to false
  set the hilitedLines of field "Editor Field" to l
  disable button "File"
  disable button "Edit"
  disable button "Go"
  disable button "Tools"
end startDebug

on stopDebug
  if the debuggingScript of stack "Script Editor" is not the long id of me
  then exit stopDebug
  get the hilitedLines of field "Editor Field"
  set the debuggingScript of stack "Script Editor" to empty
  set the autoHilite of field "Editor Field" to true
  set the listBehavior of field "Editor Field" to false
  set the lockText of field "Editor Field" to false
  if the mode of this stack is not 0
  then select after line it of field "Editor Field"
  enable button "File"
  enable button "Edit"
  enable button "Go"
  enable button "Tools"
end stopDebug

on colorizeline which
  local s, curword, nwords
  put line which of field "Editor Field" into s
  put 1 into curword
  repeat for each word w in s
    if char 1 of w is "#" or char 1 to 2 of w is "--" then
      put the number of words in s into nwords
      set the textColor of word curword to nwords of line which of field "Editor Field" to "DarkOrchid4"
      exit repeat
    end if
    set the textColor of word curword of line which of field "Editor Field" to tokencolors[w]
    add 1 to curword
  end repeat
end colorizeline

on formatline
  local oldline, oldchar, fw, startline, endline, maxline, newdata, firstline, newchars
  put word 2 of the selectedLine into oldline
  put oldline into startline
  get field "Editor Field"
  if word 1 of line oldline of it is empty
  then put -1 into oldchar
  else
    put word 2 of the selectedChunk into oldchar
    subtract the number of chars in line 1 to oldline - 1 of it from oldchar
  end if
  put "XXXXXXX" into fw
  repeat while startline > 1 and comma & fw & comma is not in ",on,function,getprop,setprop,"
    subtract 1 from startline
    put word 1 of line startline of it into fw
  end repeat
  put oldline into endline
  put the number of lines in it into maxline
  put "XXXXXXX" into fw
  repeat while endline < maxline and comma & fw & comma is not in ",on,function,getprop,setprop,"
    add 1 to endline
    put word 1 of line endline of it into fw
  end repeat
  if endline < maxline then subtract 1 from endline
  put reformatscript(startline, endline) into newdata
  get line startline to endline of it
  subtract 1 from startline
  subtract startline from endline
  repeat with i = 1 to endline
    if line i of it is not line i of newdata then
      put length(line i of newdata) - length(line i of it) into newchars
      put i into endline
      repeat until line endline of it is line endline of newdata
        add 1 to endline
      end repeat
      if line endline of it is empty then subtract 1 from endline
      put line i to endline of newdata into line i + startline to endline + startline of field "Editor Field"
      if the docolor of me then
        repeat until i > endline
          colorizeline startline + i
          add 1 to i
        end repeat
      end if
      exit repeat
    end if
  end repeat
  if oldchar is -1
  then select after line oldline of field "Editor Field"
  else select before char oldchar + newchars - 1 of line oldline of field "Editor Field"
end formatline

function reformatscript startline, endline
  local spaces, nspaces, fw, lw, continuation, gotthen, curline, newl, newdata
  put "                              " into spaces  put 0 into nspaces
  get line startline to endline of field "Editor Field"
  put it into newdata
  put false into continuation
  put true into gotthen
  put 1 into curline
  repeat for each line l in it
    put token 1 of l into fw
    if char 1 of fw is "#" or char 1 to 2 of fw is "--"
    then put l into line curline of newdata
    else
      put token -1 of l into lw
      if (fw is "end" or fw is "case" or fw is "default" or fw is "catch" or fw is "finally" or (fw is "else" and gotthen)) and nspaces > 0
      then subtract 2 from nspaces
      put char 1 to nspaces of spaces & word 1 to -1 of l into newl
      if newl is not l then put newl into line curline of newdata
      if the last char of l is "\" then
        if not continuation then
          put true into continuation
          add 4 to nspaces
          if word 1 of L is among the items of "on,function,getProp,setProp" then put 2 into nspaces
          else if word 1 of L is among the items of "repeat,case,switch,default,try,catch,finally" then add 2 to nspaces
        end if
      else
        put true into gotthen
        if continuation then
          put false into continuation
          subtract 4 from nspaces
        end if
        switch lw
        case "then"
        case "else"
          add 2 to nspaces
          break
        default
          switch fw
          case "if"
            if " else " is not in l
            then put false into gotthen
            break
          case "then"
            put false into gotthen
            break
          case "else"
            if token 2 of l is among the items of "if,repeat,switch,try"
            then put false into gotthen
            break
          case "repeat"
          case "case"
          case "switch"
          case "default"
          case "try"
          case "catch"
          case "finally"
            add 2 to nspaces
            break
          case "on"
          case "function"
          case "getprop"
          case "setprop"
            put 2 into nspaces
            break
          end switch
          break
        end switch
      end if
    end if
    add 1 to curline
  end repeat
  return newdata
end reformatscript

on runexternal whichline
  local ename, fname, dummy
  put the preferences["external editor"] of stack "Home" into ename
  put tempname() into fname
  open file fname for write
  write field "Editor Field" & cr to file fname
  close file fname
  put "See External Editor..." into field "Editor Field"
  set the cursor to watch
  if whichline is empty then put 1 into whichline
  put shell(ename && "+" & whichline && fname) into dummy
  open file fname for read
  read from file fname until eof
  if the last char of it is cr then delete last char of it
  put it into field "Editor Field"
  close file fname
  delete file fname
  select after line whichline of field "Editor Field"
  put setscript(true) into fname
end runexternal

on errorDialog which
  if line (item 1 of which) of field "Messages" of stack "Execution Error" contains "limit" then
    answer "Script length limit exceeded.  The MetaCard Starter Kit" \
        & cr & "only allows creating scripts with" && item 1 of the scriptLimits && "statements." \
        & cr & "Please see Licensing... in the Help menu for details."
  else
    set the executionerror of card 1 of stack "Execution Error" to which
    set the errorobject of card 1 of stack "Execution Error" to the long id of the target
    modeless "Execution Error"
    send "refresh" to card 1 of stack "Execution Error"
  end if
end errorDialog

function setscript doclose
  local ef, tline, tcol, savedscript, perror
  get the long id of me
  put "field" && quote & "Editor Field" & quote & "of " before it
  put it into ef
  get the scriptObject of me
  if it is empty \
      or (the number of lines in ef is 3 and line 2 of ef is "  "\
      and the script of it is empty) then
    if doclose then
      close this stack
      set the scriptObject of me to empty
      return true
    end if
  end if
  put the script of it into savedscript
  set the script of it to the text of ef
  put the result into perror
  if perror is not empty then
    set the script of it to savedscript
    set the scripterror of card 1 of stack "Script Error" to perror
    modal "Script Error"
    put field "Line" of stack "Script Error" into tline
    put field "Column" of stack "Script Error" into tcol
    if the preferences["use external editor"] of stack "Home"
    then runexternal tline
    else select before character tcol of line tline of ef
    return false
  else
    if doclose then
      close this stack
      if the openStacks contains "Execution Error"
      then close stack "Execution Error"
    end if
    if it is not empty
    then send "removeSelectedObject it" to field "Object Names" of stack "Script Errors"
    return true
  end if
end setscript

on resizeStack
  local cwidth, cheight
  put the width of me into cwidth
  put the height of me into cheight
  set the width of button "Menu Bar" to cwidth - 8
  set the right of button "Help" to cwidth - 8
  set the left of button "Menu Bar" to 4
  set the width of field "Editing Object" to cwidth
  set the width of field "Editor Field" to cwidth - 32
  set the height of field "Breakpoints Field" to cheight - 70
  set the height of field "Editor Field" to cheight - 70
end resizeStack

on openField force
  put true into notdoingclose
  if force is not empty and doneOpen
  then exit openField
  get the scriptObject of me
  if the history[it] of stack "Script Editor" is not empty
  then do "select after" && the history[it] of stack "Script Editor"
  put true into doneOpen
  send "setstart" && word 4 of the selectedChunk to stack "Script Find"
end openField

on mouseUp
  set history[the scriptObject of me] of stack "Script Editor" to empty
end mouseUp

on preOpenStack
  set the cursor to watch
  put false into doneOpen
  set the textFont of field "Editor Field" to the scriptTextFont
  set the textSize of field "Editor Field" to the scriptTextSize
  set the textSize of field "Breakpoints Field" to the scriptTextSize
  try
    switch
    case the errorObject of me is not empty and the scriptObject of me is empty
      get the errorObject of me
      set the scriptObject of me to it
      set the errorObject of me to empty
      put "Error Object:" && the long name of it into field "Editing Object"
      put the script of it into field "Editor Field"
      break
    case the scriptObject of me is not empty
      get the scriptObject of me
      put "Editing Object:" && the long name of it into field "Editing Object"
      put the script of it into field "Editor Field"
      break
    default
      exit preOpenStack
    end switch
  catch errornum
    answer error "Script is not available because stack is" & cr & "password protected or object can't be found."
    set the scriptObject of me to empty
    close this stack
    exit to MetaCard
  end try
  local otype, hnames
  get the scriptObject of me
  if word 2 of it is "id" or char 1 of word 2 of it is quote
  then put word 1 of it into otype
  else put word 2 of it into otype
  if field "Editor Field" is empty then
    local hname
    put "mouseUp" into hname
    if otype is "scrollbar" then put "scrollbarDrag" into hname
    if otype is "card" then put "openCard" into hname
    put "on" && hname & return & "  " & return & "end" && hname into field "Editor Field"
    set the history[it] of stack "Script Editor" to "line 2 of field 5"
    put 1 into handlerlines[hname]
  end if
  get the number of lines in field "Editor Field"
  setupbreakpoints it
  put reformatscript(1, it) into field "Editor Field"
  if the preferences["use external editor"] of stack "Home" then runexternal
  else if the docolor of me then colorizescript
  if the emacsKeyBindings then
    put "&Paste/Y" into line 4 of button "Edit"
    put "Select A&ll" into line 5 of button "Edit"
    put "&Find..." into line 1 of button "Tools"
  else
    put "&Paste/V" into line 4 of button "Edit"
    put "Select A&ll/A" into line 5 of button "Edit"
    put "&Find.../F" into line 1 of button "Tools"
  end if
end preOpenStack

on closeStack
  if the debuggingScript of stack "Script Editor" is the long id of me then
    stopDebug
    set the traceAbort to true
    set the traceReturn to true
  end if
  send "stopsearch" to field "Editor Field"
  put empty into field "Editing Object"
  put empty into field "Editor Field"
  close stack "Script Find"
end closeStack

on closeField
  savehistory
end closeField

on exitField
  if the selectedField is not empty then savehistory
end exitField

on enterInField
  set the history[the scriptObject of me] of stack "Script Editor" to the selectedChunk
  if the commandKey is down
  then setscript(false)
  else
    put false into notdoingclose
    get setscript(true)
  end if
end enterInField

on returnInField
  if the debuggingScript of stack "Script Editor" is the long id of me
  then send "menupick" && quote & "Step Over" & quote to button "Debug"
  else pass returnInField
end returnInField

on gethandlers
  local hnames
  put "Line..." & cr & "--" into hnames
  local hline
  put 1 into hline
  put empty into handlerlines
  repeat for each line l in field "Editor Field"
    if  word 1 of l is among the items of "on,function,getprop,setprop" then
      put cr & word 2 of l after hnames
      put hline into handlerlines[word 2 of l]
    end if
    add 1 to hline
  end repeat
  put cr & "--" after hnames
  get the customKeys of stack "Script Editor"
  sort it
  repeat for each line l in it
    delete char 1 to 8 of l
    delete last char of l
    if exists(l) then put cr & the name of l after hnames
  end repeat
  put hnames into button "Go"
end gethandlers

on gohandler which
  if the number of words in which > 1 then
    if setscript(false) then
      repeat for each line l in the customKeys of stack "Script Editor"
        delete char 1 to 8 of l
        delete last char of l
        if exists(l) and the name of l is which then
          if MCfindSE(l) then exit gohandler
          exitField
          set the scriptObject of me to l
          preOpenStack
          put false into doneOpen
          openField
          exit gohandler
        end if
      end repeat
    end if
  else select after line handlerlines[which] of field "Editor Field"
end gohandler

on setupbreakpoints nl
  put empty into field "Breakpoints Field"
  put empty into line nl + 3 of field "Breakpoints Field"
  repeat for each line l in the breakpoints
    if item 1 of l is the scriptObject of me
    then put numToChar(183) into line (item 2 of l) of field "Breakpoints Field"
  end repeat
end setupbreakpoints

on colorizescript
  if tokencolors["if"] is empty then setupcolors
  local s
  put field "Editor Field" into s
  put s into field "Editor Field"
  go to card 2
  local curword
  put 1 into curword
  repeat for each word w in s
    if tokencolors[w] is not empty
    then set the textColor of word curword of field "Editor Field" of card 1 to tokencolors[w]
    add 1 to curword
  end repeat
  local oldline, cline, curline, nwords
  put min(lineoffset("#", s), lineoffset("--", s)) into oldline
  put 0 into cline
  repeat while oldline is not 0
    add oldline to cline
    put line cline of s into curline
    put the number of words in curline into nwords
    repeat with curword = 1 to nwords
      if char 1 of word curword of curline is "#" or char 1 to 2 of word curword of curline is "--" then
        set the textColor of word curword to nwords of line cline of field "Editor Field" of card 1 to "DarkOrchid4"
        exit repeat
      end if
    end repeat
    put min(lineoffset("#", s, cline), lineoffset("--", s, cline)) into oldline
  end repeat
  go to card 1
  unlock screen
end colorizescript

on setupcolors
  repeat for each word w in the commandNames
    put "blue" into tokencolors[w]
  end repeat
  repeat for each word w in "if then else repeat for with while on end switch case getprop setprop"
    put "Brown" into tokencolors[w]
  end repeat
  repeat for each word w in the functionNames
    put "DarkOrange" into tokencolors[w]
  end repeat
  repeat for each word w in the propertyNames
    put "red" into tokencolors[w]
  end repeat
end setupcolors

on savehistory
  if notdoingclose and the short name of the selectedField is "Editor Field" then
    set the history[the scriptObject of me] of stack "Script Editor" to the selectedChunk
    put false into notdoingclose
  end if
end savehistory

function closeCheck
  get the scriptObject of me
  if it is empty or there is no it or the script of it is field "Editor Field" & cr \
      or the number of lines in field "Editor Field" is 3 \
      and line 2 of field "Editor Field" is "  " then return true
  answer "Save changes?" with "Yes" or "No" or "Cancel"
  switch it
  case "Yes"
    savehistory
    return setscript(true)
  case "No"
    return true
  default
    return false
  end switch
end closeCheck

on closeStackRequest
  if closeCheck() then pass closeStackRequest
end closeStackRequest
          4      history    1card id 1001 of stack "/home/raney/mc/mchome.mc"  char 508 to 511 of field 1      -   )   +   .      /      !   "   0      &    	@          X
   ! Prompt                  ( P            Search for: 
   " Buffer                P (            setscri     	Menu Bar A'        ,           	        - File  UHlocal oldprompt

on restorePrompt
  put oldprompt into field "Editing Object"
end restorePrompt

on saveFile fname
  put field "Editing Object" into oldprompt
  put "Saving to file" && fname into field "Editing Object"
  send "restorePrompt" to me in 2 seconds
  put field "Editor Field" into url ("file:" & fname)
end saveFile

on menuPick which
  switch which
  case "Save Script"
    get the savedfilenames[the scriptObject of this card] of stack "Script Editor"
    if it is not empty then
      saveFile it
      exit menuPick
    end if
  case "Save Script As..."
    ask file "Save script as:"
    if it is empty then exit menuPick
    saveFile it
    break
  case "Print Script"
    start using stack "Print Field"
    printfield field "Editing Object" & tab & tab & "<%pagenumber%>",\
        field "Editor Field", "<%the time%> <%the date%>", the long id of field "Editor Field"
    stop using stack "Print Field"
    break
  case "Close Script"
    if closeCheck()
    then close this stack
    break
  case "Apply Script"
    get setscript(false)
    break
  end switch
end menuPick
          $    N&Save Script
Save Script &As...
&Print Script
&Close Script/W
App&ly Script/L      	        ) Edit  Uon menuPick which
  local startchar, endchar, nchars, doit, tscroll
  switch which
  case "Undo"
    undo
    break
  case "Cut"
    cut
    break
  case "Copy"
    copy
    break
  case "Paste"
    if the clipboard is "text" then paste
    break
  case "Select All"
    if the selectedField is not empty then
      if the lockText of the selectedField then exit to MetaCard
      select text of the selectedField
    end if
    break
  default
    if the selectedChunk is empty
    then exit menuPick
    put the scroll of field "Editor Field" into tscroll
    put word 2 of the selectedChunk into startchar
    put word 4 of the selectedChunk into endchar
    select before field "Editor Field"
    get field "Editor Field"
    repeat until char startchar of it is empty or char startchar of it is return
      subtract 1 from startchar
    end repeat
    add 1 to startchar
    get char startchar to endchar of field "Editor Field"
    put true into doit
    repeat with i = 1 to the number of characters in it
      if char i of it is return
      then put true into doit
      else
        if which is "Comment Selection" then
          if doit and char i of it is not space then
            put "# " before char i + startchar + nchars - 1 of field "Editor Field"
            put false into doit
            add 2 to nchars
          end if
        end if
      else
        if doit and char i of it is "#" then
          delete char i + startchar - nchars - 1 of field "Editor Field"
          if char i + startchar - nchars - 1 of field "Editor Field" is space then
            delete char i + startchar - nchars - 1 of field "Editor Field"
            add 2 to nchars
          else add 1 to nchars
          put false into doit
        end if
      end if
    end repeat
    select before char startchar of field "Editor Field"
    set the scroll of field "Editor Field" to tscroll
    break
  end switch
end menuPick
        0  $    c&Undo/Z
Cu&t/X
&Copy/C
&Paste/Y
Select A&ll
-
Comment &Selection
Unco&mment Selection
-
Set Marker      	        . Debug  Uon mouseDown
  local doenable, mi
  if the tracemode of stack "Script Editor" is "Trace"
  then put "Stop Trace/T" into line 5 of me
  else put "Trace/T" into line 5 of me
  put the debuggingScript of stack "Script Editor" is not empty into doenable
  repeat with i = 1 to 5
    set the enabled of line i of me to doenable
  end repeat
  set the enabled of line 13 of me to not doenable
  delete line 14 to -1 of me
  if not doenable then
    repeat for each line l in field "Editor Field"
      if word 1 of l is "on" then put cr & tab & word 2 of l after mi
    end repeat
    put mi after me
  end if
end mouseDown

on menuPick which
  set the itemDelimiter to "|"
  switch item 1 of which
  case "Abort"
    stopDebug
    set the traceStack to empty
    set the traceAbort to true
    set the traceReturn to true
    break
  case "Run"
    stopDebug
    set the traceStack to empty
    set the traceReturn to true
    break
  case "Step Into"
  case "Step Over"
  case "Trace"
    set the traceStack to MCtargetstack(the scriptObject of this card)
    set the tracemode of stack "Script Editor" to which
    set the traceReturn to true
    break
  case "Stop Trace"
    MCcancelTR
    break
  case "Clear all breakpoints"
    set the breakpoints to empty
    setupbreakpoints the number of lines of field "Editor Field"
    break
  case "Send Message"
    send item 2 of which to the scriptObject of this card
    break
  default
    palette which
    break
  end switch
end menuPick
        t  8    Abort/.
Run/R
Step Into/I
Step Over/M
Trace/T
-
Clear all breakpoints
-
Variable Watcher
Message Watcher
Execution Contexts
-
Send Message      	         Tools  UIon mouseDown
  if the docolor of this card
  then hilite menuItem 9 of me
  else unhilite menuItem 9 of me
  if the explicitVars
  then hilite menuItem 10 of me
  else unhilite menuItem 10 of me
  if the platform is "MacOS" or the platform is "Win32"
  then disable menuItem 8 of me
  else enable menuItem 8 of me
end mouseDown

on menuPick which
  local t
  switch which
  case "Find..."
    send "doFind" && word 2 of the name of this stack to stack "Script Find"
    break
  case "Find Again"
    send "mouseUp" to button "Find Next" of stack "Script Find"
    break
  case "Replace..."
    send "doReplace" && word 2 of the name of this stack to stack "Script Find"
    break
  case "Replace Again"
    send "mouseUp" to button "Replace" of stack "Script Find"
    break
  case "Lookup Selection..."
    send "lookupterm the selectedText" to field "Editor Field"
    break
  case "Run External Editor..."
    if the selectedLine is empty
    then runexternal 0
    else runexternal word 2 of the selectedLine
    break
  case "Colorize Script"
    set the docolor of this card to not the docolor of this card
    if the docolor of this card
    then colorizescript
    else put field "Editor Field" into field "Editor Field"
    break
  case "Explicit Variables"
    set the explicitVars to not the explicitVars
    break
  end switch
end menuPick
         0    docolor  true   Find.../F
Find Again/G
-
Replace...
Replace Again/T
-
Lookup Selection...
Run External Editor...
!nColorize Script
!cExplicit Variables      	        + Go  U on mouseDown
  gethandlers
end mouseDown

on menuPick which
  if which is "Line..." then
    ask "Go to line:"
    if it is a number then
      select before line it of field "editor field"
    end if
  else gohandler which
end menuPick
        T       pLine...
--
init
errorDialog
returnInField
prevline
nextline
commandKeyDown
controlKeyDown
handleKey
arrowKey
--      	     
   0 Breakpoints Field 	x  on mouseUp
  local cl
  put word 2 of the clickLine into cl
  if line cl of field "Editor Field" is empty then exit mouseUp
  get the breakpoints
  if line cl of me is empty then
    put numToChar(183) & cr into the clickLine
    put cr & the scriptObject of this card, cl after it
  else
    put cr into the clickLine
    delete line lineOffset(the scriptObject of this card & comma & cl, it) of it
  end if
  set the breakpoints to it
end mouseUp
               @                                                                                                                                                                                                / Help  U on menuPick which
  switch which
  case "Editing..."
    go to card "Script Editor" of stack "Dialog Box Help"
    break
  case "Debugging..."
    go to card "Script Debugger" of stack "Dialog Box Help"
    break
  end switch
end menuPick
        0    docolor  true   Editing...
Debugging...      	     
    
Editor Field )p|local tmarkchar
local searchmark, searching, lastsearch
local cx

on rawKeyUp
  if the docolor of this card
  then colorizeline word 2 of the selectedLine of me
  send "setstart" && word 4 of the selectedChunk to stack "Script Find"
end rawKeyUp

on doselect
  local foundpos
  put offset(field "Buffer", me, tmarkchar) into foundpos
  if foundpos is 0
  then beep 1
  else select before char foundpos + tmarkchar + length(field "Buffer") of me
end doselect

on stopsearch
  hide field "Prompt"
  put field "Buffer" into lastsearch
  hide field "Buffer"
  show field "Editing Object"
  put false into searching
end stopsearch

on optionKeyDown which
  if searching then
    put which after field "Buffer"
    doselect
  else pass optionKeyDown
end optionKeyDown

on keyDown which
  switch
  case searching
    put which after field "Buffer"
    doselect
    break
  case cx
    switch which
    case "["
      select before char 1 of me
      break
    case "]"
      select after last char of me
      break
    end switch
    put false into cx
    break
  default
    pass keyDown
    break
  end switch
end keyDown

on backSpaceKey
  if searching then
    delete last char of field "Buffer"
    doselect
  else pass backSpaceKey
end backSpaceKey

on deleteKey
  if searching then
    delete last char of field "Buffer"
    doselect
  else pass deleteKey
end deleteKey

on tabKey
  stopsearch
  formatline
end tabKey

on selectionChanged
  stopsearch
  send "setstart" && word 4 of the selectedChunk to stack "Script Find"
end selectionChanged

on escapeKey
  if the commandKey is "down"
  then close this stack
  else stopsearch
end escapeKey

on arrowKey
  stopsearch
  pass arrowKey
end arrowKey

on returnInField
  if searching then
    stopsearch
    put word 2 of the selectedChunk into tmarkchar
  else pass returnInField
end returnInField

on commandKeyDown which
  local wassearching
  put searching into wassearching
  if which is "65507" or which is "65509" then put empty into which
  if which is not empty and which is not "s" and which is not "f" then stopsearch
  switch which
  case "["
    select before char 1 of me
    break
  case "]"
    select after last char of me
    break
  case ""
    break
  case " "
    put word 2 of the selectedChunk into tmarkchar
    break
  case "g"
    if wassearching
    then select before char searchmark of me
    else pass commandKeyDown
    break
  case "s"
    if wassearching then
      if field "Buffer" is empty
      then put lastsearch into field "Buffer"
      else put word 2 of the selectedChunk into tmarkchar
      doselect
    else
      hide field "Editing Object"
      show field "Prompt"
      put empty into field "Buffer"
      show field "Buffer"
      put word 2 of the selectedChunk into tmarkchar
      put tmarkchar into searchmark
      put true into searching
    end if
    break
  case "w"
    if the emacsKeyBindings
    then cut char tmarkchar to (word 2 of the selectedChunk) of field "Editor Field"
    else pass commandKeyDown
    break
  case "x"
    if the emacsKeyBindings
    then put true into cx
    else pass commandKeyDown
  default
    put false into cx
    pass commandKeyDown
    break
  end switch
end commandKeyDown

on lookupterm which
  if which is among the items of "then,else,end" then put "if" into which
  if which is among the items of "with,while,for,until" then put "repeat" into which
  if which is among the items of "case,default,break" then put "switch" into which
  if which is among the items of "catch,finally" then put "try" into which
  if there is a card which of stack "MetaTalk Reference"
  then go to card which of stack "MetaTalk Reference"
  else beep 1
end lookupterm

on mouseUp
  if the commandKey is "down" and the optionKey is "down" then
    savehistory
    close this stack
  else lookupterm the clickText
end mouseUp

on scrollbarDrag which
  set the scroll of field "Breakpoints Field" to the scroll of me
end scrollbarDrag
              @  @                   	`       A        	a        
    Editing Object                 (4                Script Profiler   on openCard
  
end openCard
       L5t        @     W 
Helvetica   U 
Helvetica   U 
helvetica       	PQlocal currentobject
local oldscript
local lasttime, lastpoint
local profilelines, profiletimes

on trace handlername, l, p
  local newtime
  put the milliseconds into newtime
  add 1 to profilelines[lastpoint]
  add newtime - lasttime to profiletimes[lastpoint]
  put the long id of the target, l into lastpoint
  put the milliseconds into lasttime
  set traceReturn to true
end trace

on traceDone
  local newtime
  put the milliseconds into newtime
  add 1 to profilelines[lastpoint]
  add newtime - lasttime to profiletimes[lastpoint]
  put 0 into lastpoint
  set the defaultStack to "Script Profiler"
  getscript
  set traceReturn to true
end traceDone

on getscript
  local s, pt, nlines, dl, dt, bp
  put the script of currentobject into s
  put keys(profilelines) into pt
  if pt contains currentobject then
    set the cursor to watch
    lock screen
    set the leftmargin of field "Script" to 120
    put the number of lines in the script of currentobject into nlines
    set the endValue of scrollbar "psb" to nlines + 1
    set the thumbPos of scrollbar "psb" to 0
    set the thumbSize of scrollbar "psb" to the height of field "Lines"\
        div the effective textHeight of field "Lines"
    send "scrollbarDrag" to scrollbar "psb"
    put empty into line nlines + 1 of dl
    put empty into line nlines + 1 of dt
    repeat for each line l in pt
      if item 1 of l is currentobject then
        put profilelines[l] into line (item 2 of l) of dl
        put profiletimes[l] into line (item 2 of l) of dt
      end if
    end repeat
    local startline, cline, total
    put empty into startline
    put 1 into cline
    put 0 into total
    repeat for each line l in s
      if word 1 of l is "on" or word 1 of l is "function" then
        if startline is not empty
        then put total into line startline of dt
        put cline into startline
        put 0 into total
      end if
      add line cline of dt to total
      add 1 to cline
    end repeat
    if startline is not empty
    then put total into line startline of dt
    put dl into field "Lines"
    put dt into field "Times"
    show group "Profile"
    unlock screen
  else
    set the leftmargin of field "Script" to 8
    hide group "Profile"
    put empty into button "Message"
    repeat for each line l in s
      if word 1 of l is "on" or word 1 of l is "function"
      then put word 2 of l & return after button "Message"
    end repeat
    set the menuHistory of button "Message" to 1
  end if
  put s into field "Script"
end getscript

on suspendStack
  if currentobject is not empty
  then put the script of currentobject into oldscript
end suspendStack

on resumeStack
  if currentobject is not empty and the script of currentobject is not oldscript
  then getscript
end resumeStack

on mouseUp
  local tname, bp, targetname
  put the short name of the target into tname
  switch tname
  case "Edit Script..."
    if the label of button "Send Message" is not empty then
      answer format("Can't edit script while it is executing.\nPress \"Run\" to continue.")
      exit to MetaCard
    end if
    edit script of currentobject
    break
  case "Start Profile"
    if the label of the target is "Stop Profile" then
      set the label of button "Start Profile" to empty
      remove script of me from front
      set the traceStack to empty
    else
      set the label of button "Start Profile" to "Stop Profile"
      set the traceStack to the label of button "Stack Name"
      insert script of me into front
    end if
    break
  case "Send Message"
    if the label of the target is empty then
      put the label of button "Object Name" into targetname
      if word 1 of the label of button "Object Name" is not "stack"
      then put " of stack" && quote & the label button "Stack Name" & quote after targetname
      send the label of button "Message" to targetname
    end if
    break
  default
    pass mouseUp
  end switch
end mouseUp

on setobj oname
  put oname into currentobject
  getscript
end setobj

on clearprofile
  put empty into profilelines
  put empty into profiletimes
  set the label of button "Start Profile" to empty
end clearprofile

on preOpenStack
  if the long id of the target is not the long id of me then exit preOpenStack
  local oname
  choose browse tool
  send "newTool" to stack "MetaCard Menu Bar"
  if the short name of the topStack is "Script Profiler" then
    put empty into field "Script"
    exit to MetaCard
  end if
  if the openStacks contains "Execution Error" then
    put field "Object" of stack "Execution Error" into currentobject
    put word 1 to 2 of currentobject into oname
    put the long id of currentobject into currentobject
    setbp field "Line" of stack "Execution Error"
    setobj currentobject
    set the label of button "Stack Name" to the short name of the traceStack
    send "getsibs" to button "Object Name"
    set the label of button "Object Name" to oname
  else
    set the label of button "Stack Name" to the short name of the topStack
    send "refresh" to button "Object Name"
  end if
end preOpenStack

on closeStack
  if the label of button "Start Profile" is "Stop Profile" then
    set the label of button "Start Profile" to empty
    remove script of me from front
    set the traceStack to empty
  end if
  put empty into field "Script"
end closeStack

on resizeStack
  if the long id of the target is not the long id of me then exit resizeStack
  local tvscroll, tsscroll
  local cwidth, bwidth, bnames, cheight, inc, bpos, newheight
  put the scroll of field "Script" into tsscroll
  put the width of this stack into cwidth
  set the width of field "Script" to cwidth - 16
  set the right of scrollbar "psb" to the right of field "Script" - 2
  set the right of button "Start Profile" to cwidth - 8
  set the right of button "Help" to the left of button "Start Profile" - 16
  set the right of button "Clear Profile" to cwidth - 8
  set the width of button "Stack Name" to the left of button "Start Profile" - the left of button "Stack Name" - 16
  set the width of button "Object Name" to the left of button "Start Profile" - the left of button "Object Name" - 16
  set the width of button "Message" to the left of button "Start Profile" - the left of button "Message" - 16
  set the right of button "Edit Script..." to cwidth - 8
  put 0 into bwidth
  put "Help,Send Message,Edit Script...,Done" into bnames
  repeat for each item i in bnames
    add the width of button i to bwidth
  end repeat
  put the height of this stack into cheight
  put max(0, (cwidth - bwidth) div (the number of items in bnames + 1)) into inc
  put inc into bpos
  repeat for each item i in bnames
    set the left of button i to bpos
    add the width of button i + inc to bpos
    set the bottom of button i to cheight - 12
  end repeat
  put the top of button "Help" - the bottom of field "Script Label" - 16 into newheight
  set the height of field "Script" to newheight
  set the height of field "Lines" to newheight
  set the height of field "Times" to newheight
  set the height of scrollbar "psb" to newheight
  set the scroll of field "Script" to tsscroll
  set the scroll of field "Lines" to tsscroll
  set the scroll of field "Times" to tsscroll
end resizeStack
           5t                             
  
               8            Stack:   
 Profile   !        `3 
   Lines 
`         0          5    5  5  5      5  5   
   Times 
`       4  D          17    1  2  1      2  10     	 psb Ip on scrollbarDrag v
  lock screen
  multiply v by the effective textHeight of field "Lines"
  set the scroll of field "Lines" to v
  set the scroll of field "Times" to v
  set the scroll of field "Script" to v
  unlock screen
end scrollbarDrag
             0  10       
             x d <            Script: 
     @         d <            	# calls: 
  
   @       < d <            Time:    Stack Name 4)u Con menuPick
  send "refresh" to button "Object Name"
end menuPick
        <   Dialog Box Help      MC Toplevel Menu        	   	      Start Profile E`        \        	     
              ( <            Object:    Object Name )uon getsibs
  local objs
  set the defaultStack to the label of button "Stack Name"
  put the name of this stack & return & the name of this card into objs
  repeat with i = 1 to the number of controls on this card
    if the number of lines in script of control i > 2
    then put return & the name of control i after objs
  end repeat
  set the defaultStack to "Script Profiler"
  put objs into me
end getsibs

on refresh
  getsibs
  set the label of me to line 2 of me
  setobj the long id of this card of stack the label of button "Stack Name"
end refresh

on menuPick which
  set the defaultStack to the label of button "Stack Name"
  get the long id of which
  set the defaultStack to "Script Profiler"
  setobj it
end menuPick
        @ ,  card "Script Debugger"        ?stack "Dialog Box Help"
card "Script Debugger"
group "Dialogs"        	   	      Clear Profile Ep 3on mouseUp
  clearprofile
  getscript
end mouseUp
        , \        	     
              H P            	Message:    Message 4)u on menuPick which
  set the scroll of field "Script" to (lineOffset("on" && which, field "Script") - 1) * the effective textHeight of field "Script"
end menuPick
        T Lm               	   	   
   
Script Label           d <            Script: 
   Script 	`        %                 	`            Help Ep Ron mouseUp
  go to card "Script Profiler" of stack "Dialog Box Help"
end mouseUp
        5L -         	        
Send Message E`       L r        	         Done Ep +on mouseUp
  close this stack
end mouseUp
       L 2        	        Edit Script... E`      >L Z        	        Control Browser          W        P      U 
Helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica       	PClocal cardid

on preOpenCard
  set the label of button "Stack Name" to the short name of the topStack
  refresh
end preOpenCard

on closeCard
  put empty into field "Controls"
end closeCard

on enablecontrols
  repeat for each item i in "Edit Script...,Visible"
    enable button i
  end repeat
  if the visible of the selobj
  then set the label of button "Visible" to "Hide"
  else set the label of button "Visible" to "Show"
  if char 1 of line (the hilitedLine of field "Controls") of field "Controls" is not space then
    enable button "Raise"
    enable button "Lower"
  end if
end enablecontrols

on disablecontrols
  repeat for each item i in "Edit Script...,Raise,Lower,Visible"
    disable button i
  end repeat
end disablecontrols

on refresh
  local l, pad, cname, groupcontrols, isvis, nopw, nlines
  lock screen
  set the defaultStack to the label of button "Stack Name"
  put empty into l
  put empty into pad
  put 0 into groupcontrols
  put the passkey of this stack is empty into nopw
  repeat with i = 1 to the number of controls
    if the visible of control i then put empty into isvis else put "+" into isvis
    if nopw then put the number of lines in the script of control i into nlines
    if nlines is 0 then put empty into nlines
    put pad & line 1 of the name of control i into cname
    if the length of cname > 30
    then put "..." into char 28 to -1 of cname
    put cname & tab & nlines & tab & isvis & return after l
    if word 1 of the name of control i is "group" then
      if pad is empty
      then put the number of layers in control i into groupcontrols
      else
        subtract the number of layers in control i from the last item of groupcontrols
        put comma & the number of layers in control i after groupcontrols
      end if
      put "  " after pad
    end if
    if pad is not empty then
      repeat while pad is not empty and last item of groupcontrols <= 0
        delete last item of groupcontrols
        delete char 1 to 2 of pad
      end repeat
      if pad is not empty then subtract 1 from last item of groupcontrols
    end if
  end repeat
  delete last char of l
  put the id of this card into cardid
  set the defaultStack to the owner of me
  set the defaultStack to "Control Browser"
  put l into field "Controls"
  if the selObj is not empty
  then get the name of the selObj
  else get empty
  if it is empty or word 1 of it is "stack" \
      or (word 1 of it is "card" and (word 2 of it is "id" or char 1 of word 2 of it is quote)) then
    disablecontrols
    set the hilitedLine of field "Controls" to empty
  else
    set the hilitedLine of field "Controls" to the layer of the selobj
    enablecontrols
  else
  end if
  unlock screen
end refresh

on checkStack
  if the the label of button "Stack Name" is not among the lines of the openstacks then
    set the label of button "Stack Name" to the short name of the topStack
    put 0 into cardid
  end if
  set the defaultStack to the label of button "Stack Name"
  if the id of this card is not cardid then
    set the defaultStack to the owner of me
    refresh
  end if
  set the defaultStack to "Control Browser"
end checkStack

on mouseEnter
  checkStack
end mouseEnter

on resizeStack
  local cwidth, cheight, bnames, bwidth, inc, bpos
  put the width of this stack into cwidth
  put the height of this stack into cheight
  set the width of button "Stack Name" to cwidth - 64
  set the width of field "Controls" to cwidth - 16
  set the height of field "Controls" to cheight - 120
  set the right of field "Script" to cwidth div 4 * 3
  set the left of field "Hidden" to cwidth - 96
  set the tabstops of field "Controls" to the left of field "Script", the left of field "Hidden"
  put "Edit Script...,Raise,Lower,Visible,Help" into bnames
  repeat for each item i in bnames
    add the width of button i to bwidth
  end repeat
  put max(0, (cwidth - bwidth) div (the number of items in bnames + 1)) into inc
  put inc into bpos
  repeat for each item i in bnames
    set the left of button i to bpos
    add the width of button i + inc to bpos
    set the bottom of button i to cheight - 12
  end repeat
end resizeStack
           W                      
   	Controls )ron mouseUp
  refreshme
end mouseUp

on focusIn
  refreshme
end focusIn

on rawKeyUp
  refreshme
end rawKeyUp

on refreshme
  local cline
  get the scroll of me
  lock screen
  checkStack
  put hilitedLines of me into cline
  if cline is empty then exit refreshme
  if the number of items of cline > 1 then
    put item 2 of cline into cline
    set the hilitedLines of me to cline
  end if
  set the disabled of button "Raise" to char 1 of line cline of me is space
  set the disabled of button "Lower" to char 1 of line cline of me is space
  if the tool is not "pointer tool" then
    choose pointer tool
    send "newTool" to stack "MetaCard Menu Bar"
  end if
  set the defaultStack to the label of button "Stack Name"
  select control cline
  set the defaultStack to "Control Browser"
  enablecontrols
  set the scroll of me to it
  unlock screen
end refreshme

on mouseDoubleUp
  palette "Properties"
end mouseDoubleUp
         @         6          	`      x A  
               4            Stack:    Stack Name t)u "on mouseUp
  refresh
end mouseUp
        < V  Variable Watcher  MC Stack Menu        	   	   
              ( @            	Control:    Edit Script... Ep 4on mouseUp
  edit script of the selobj
end mouseUp
        / `         	        Raise Ep _on mouseUp
  set the layer of the selobj to the layer of the selobj + 1
  refresh
end mouseUp
        / 8         	        Lower Ep _on mouseUp
  set the layer of the selobj to the layer of the selobj - 1
  refresh
end mouseUp
        / <         	        Visible ep on mouseUp
  set the visible of the selobj to not the visible of the selobj
  if the visible of the selobj
  then set the label of me to "Hide"
  else set the label of me to "Show"
  refresh
end mouseUp
       / 0  Show         	     
   Script  @        ( a            Script Lines: 
   Hidden  @      6 ( @            Hidden:    Help Ep on mouseUp
  help
end mouseUp
       T/ 0         	        Properties  blocal onames

on refresh
 # exit refresh
  local ctype
  put the selectedObjects into onames
  switch
  case onames is empty
    go to last card
    break
  case the number of lines in onames > 1
    if the short name of this card is not "Layout"
    then go to card "Layout"
    break
  default
    put onames into ctype
    if word 1 of ctype is among the items of "card,bkgnd"\
        and word 2 of ctype is among the items of "field,button,image,player,scrollbar,graphic"
    then delete word 1 of ctype
    lock messages
    lock screen
    go to card (word 1 of ctype && "properties")
    if the lookAndFeel is "Macintosh" or the lookAndFeel is "Appearance Manager"
    then set the textsize of button 1 to 10
    else set the textsize of button 1 to empty
    send "getprops" to this card
    set the title of me to the short name of this card
    unlock screen
    unlock messages
  end switch
end refresh

function additem oitem, nitem
  if oitem is empty
  then return nitem
  else return oitem & comma & nitem
end additem

function unformat string
  local soffset
  put offset(return, string) into soffset
  repeat while soffset is not 0
    put "\n" into char soffset of string
    put offset(return, string) into soffset
  end repeat
  return string
end unformat

on preOpenStack
  refresh
end preOpenStack

on openCard
  if there is a field 1 then select text of field 1
end openCard

on closeCard
  local nfields
  put the number of fields of this card into nfields
  repeat with i = 1 to nfields
    if not the lockText of field i
    then put empty into field i
  end repeat
end closeCard

on doublechars @string, dchar
  local toffset, newoffset
  put 0 into toffset
  repeat forever
    put offset(dchar, string, toffset) into newoffset
    if newoffset is 0
    then exit repeat
    add newoffset to toffset
    put dchar after char toffset of string
    add 1 to toffset
  end repeat
end doublechars

on setproperty p, v
  local newvalue, setstring
  if onames is not empty then
    if p is "label" then
      doublechars v, "%"
      put format(v) into newvalue
    else put v into newvalue
    repeat for each line l in onames
      put format("set the %s of %s to newvalue\n", p, l) after setstring
    end repeat
    do setstring
    put the selectedObjects into onames
  end if
end setproperty

on closeField
  setproperty the short name of the target, the text of the target
end closeField

on mouseUp
  if word 1 of the name of the target is "button"
  then setproperty the short name of the target, the hilite of the target
end mouseUp

on menuPick v
  setproperty the short name of the target, v
end menuPick

on setbutton which, v
  set the hilite of button which to v
  setproperty which, v
end setbutton

on settextalign which
  setproperty "textAlign", which
  send "refresh" to stack "Font Chooser"
end settextalign

on scrollbarDrag newpos
  if word 1 of the name of the target is "scrollbar"
  then setproperty the short name of the target, newpos
end scrollbarDrag

on help
  local cname
  put word 1 of the short name of this card && the selectedText of button 1 into cname
  go to card cname of stack "Dialog Box Help"
end help
        )          Stack Properties      U    W 
Helvetica   U false   U 	terminal   W 	terminal   W 	terminal   W 	terminal   W 	terminal  U 
Helvetica  U 
Helvetica   U 
Helvetica   U 
Helvetica  
 U 
Helvetica   U 
Helvetica   U 
helvetica   U 
helvetica  
 U    U   
 U 
helvetica   U symbol    Button Properties   	PZon getprops
  if word 1 of the selObj is not "button" and word 2 of the selObj is not "button"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "Name"
  else put empty into field "name"
  put the layer of the selectedObject into field "layer"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  put the mnemonic of the selectedObject into field "mnemonic"
  put unformat(the label of the selectedObject) into field "label"
  set the hilite of button "showName" to the showName of the selectedObject
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "threeD" to the threeD of the selectedObject
  set the hilite of button "opaque" to the opaque of the selectedObject
  set the hilite of button "default" to the default of the selectedObject
  set the hilite of button "disabled" to the disabled of the selectedObject
  if the icon of the selectedObject is 0
  then put empty into field "icon"
  else put the icon of the selectedObject into field "icon"
  if the hiliteIcon of the selectedObject is 0
  then put empty into field "hiliteIcon"
  else put the hiliteIcon of the selectedObject into field "hiliteIcon"
  if the style of the selectedObject is "menu"
  then set the hilitedButtonName of group "Style" to the menuMode of the selectedObject
  else set the hilitedButtonName of group "Style" to the style of the selectedObject
  set the hilite of button "traversalOn" to the traversalOn of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilite of button "sharedHilite" to the sharedHilite of the selectedObject
  set the hilite of button "autoHilite" to the autoHilite of the selectedObject
  set the hilite of button "hiliteBorder" to the hiliteBorder of the selectedObject
  set the hilite of button "hiliteFill" to the hiliteFill of the selectedObject
  set the hilite of button "autoArm" to the autoArm of the selectedObject
  set the hilite of button "armBorder" to the armBorder of the selectedObject
  set the hilite of button "armFill" to the armFill of the selectedObject
  put the menuMouseButton of the selectedObject into field "menuMouseButton"
  put the toolTip of the selectedObject into field "toolTip"
  put the accelKey of the selectedObject into field "accelKey"
  put the accelText of the selectedObject into field "accelText"
  local mods
  put the accelMods of the selectedObject into mods
  set the hilite of button "Control" to mods contains "control"
  set the hilite of button "Alt" to mods contains "alt"
  set the hilite of button "Shift" to mods contains "shift"
  put the rightMargin of the selectedObject into field "rightMargin"
  put the menuName of the selectedObject into field "menuName"
  set the thumbpos of sb "borderWidth" to the borderWidth of the selectedObject
  set the thumbpos of sb "shadowOffset" to the shadowOffset of the selectedObject
  put the text of the selectedObject into field "text"
end getprops
                ?  T  =         Field Properties   	P
on getprops
  if word 1 of the selObj is not "field" and word 2 of the selObj is not "field"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  put the layer of the selectedObject into field "layer"
  put the text of the selectedObject into field "text"
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "threeD" to the threeD of the selectedObject
  set the hilite of button "opaque" to the opaque of the selectedObject
  set the hilite of button "dontWrap" to the dontWrap of the selectedObject
  set the hilite of button "showLines" to the showLines of the selectedObject
  set the hilite of button "fixedLineHeight" to the fixedLineHeight of the selectedObject
  set the hilite of button "hScrollbar" to the hScrollbar of the selectedObject
  set the hilitedButtonName of group "Style" to the style of the selectedObject
  put the margins of the selobj into field "margins"
  put the firstIndent of the selobj into field "firstIndent"
  put the tabStops of the selobj into field "tabStops"
  set the hilite of button "hGrid" to the hGrid of the selectedObject
  set the hilite of button "vGrid" to the vGrid of the selectedObject
  set the hilite of button "traversalOn" to the traversalOn of the selectedObject
  set the hilite of button "lockText" to the lockText of the selectedObject
  set the hilite of button "autoHilite" to the autoHilite of the selectedObject
  set the hilite of button "autoTab" to the autoTab of the selectedObject
  set the hilite of button "listBehavior" to the listBehavior of the selectedObject
  set the hilite of button "multipleHilites" to the multipleHilites of the selectedObject
  set the hilite of button "noncontiguousHilites" to the noncontiguousHilites of the selectedObject
  set the hilite of button "toggleHilites" to the toggleHilites of the selectedObject
  set the hilite of button "threeDHilite" to the threeDHilite of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilite of button "dontSearch" to the dontSearch of the selectedObject
  set the hilite of button "sharedText" to the sharedText of the selectedObject
  put the toolTip of the selectedObject into field "toolTip"
  set the thumbpos of sb "borderWidth" to the borderWidth of the selectedObject
  set the thumbpos of sb "shadowOffset" to the shadowOffset of the selectedObject
end getprops
                  <        ? Image Properties   	Pon getprops
  if word 1 of the selObj is not "image" and word 2 of the selObj is not "image"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  put the size of the selectedObject into field "size"
  put the layer of the selectedObject into field "layer"
  put the fileName of the selectedObject into field "fileName"
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "threeD" to the threeD of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilite of button "traversalOn" to the traversalOn of the selectedObject
  set the hilite of button "alwaysBuffer" to the alwaysBuffer of the selectedObject
  put the width of the selobj into field "width"
  put the height of the selobj into field "height"
  put the hotSpot of the selobj into field "hotSpot"
  put the tooltip of the selobj into field "tooltip"
end getprops
              >  k        u Scrollbar Properties   	P on getprops
  if word 1 of the selObj is not "scrollbar" and word 2 of the selObj is not "scrollbar"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  put the layer of the selectedObject into field "layer"
  put the thumbSize of the selectedObject into field "thumbSize"
  put the thumbPosition of the selectedObject into field "thumbPosition"
  put the startValue of the selectedObject into field "startValue"
  put the endValue of the selectedObject into field "endValue"
  put the lineIncrement of the selectedObject into field "lineIncrement"
  put the pageIncrement of the selectedObject into field "pageIncrement"
  set the hilite of button "showValue" to the showValue of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilitedButtonName of group "style" to the style of the selectedObject
  put the numberFormat of the selectedObject into field "numberFormat"
  put the tooltip of the selectedObject into field "tooltip"
end getprops
              t           Graphic Properties   )P	uon resetextras
  local gnames, gstyle
  put "polygon,oval,roundRect,regular" into gnames
  put the hilitedButtonName of group "Style" into gstyle
  repeat for each item i in gnames
    if i is gstyle
    then show group (i && "Extras")
    else hide group (i && "Extras")
  end repeat
end resetextras

on getprops
  if word 1 of the selObj is not "graphic" and word 2 of the selObj is not "graphic"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put unformat(the label of the selectedObject) into field "label"
  put the layer of the selectedObject into field "layer"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  set the hilite of button "traversalOn" to the traversalOn of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilite of button "showName" to the showName of the selectedObject
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "threeD" to the threeD of the selectedObject
  set the hilite of button "filled" to the filled of the selectedObject
  set the hilite of button "startArrow" to the startArrow of the selectedObject
  set the hilite of button "endArrow" to the endArrow of the selectedObject
  set the hilite of button "roundEnds" to the roundEnds of the selectedObject
  set the thumbPos of sb "lineSize" to the lineSize of the selectedObject
  set the hilitedButtonName of group "style" to the style of the selectedObject
  if the hilite of button "relativePoints"
  then put the relativePoints of the selectedObject into field "points"
  else put the points of the selectedObject into field "points"
  set the hilite of button "dontResize" to the dontResize of the selectedObject
  set the thumbPos of sb "startAngle" to the startAngle of the selectedObject
  set the thumbPos of sb "arcAngle" to the arcAngle of the selectedObject
  set the thumbPos of sb "roundRadius" to the roundRadius of the selectedObject
  set the thumbPos of sb "polySides" to the polySides of the selectedObject
  set the thumbPos of sb "angle" to the angle of the selectedObject
  put the tooltip of the selectedObject into field "tooltip"
  resetextras
end getprops
                         Player Properties   )PRon getprops
  if word 1 of the selObj is not "player" and word 2 of the selObj is not "player"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the layer of the selectedObject into field "layer"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  put the filename of the selectedObject into field "fileName"
  put the tooltip of the selectedObject into field "toolTip"
  set the hilite of button "traversalOn" to the traversalOn of the selectedObject
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilite of button "alwaysBuffer" to the alwaysBuffer of the selectedObject
  set the hilite of button "showController" to the showController of the selectedObject
  set the hilite of button "showBadge" to the showBadge of the selectedObject
end getprops
                             Group Properties   	PLon getprops
  if word 1 of the selObj is not "group"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the layer of the selectedObject into field "layer"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  put the label of the selectedObject into field "label"
  set the hilite of button "showName" to the showName of the selectedObject
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "threeD" to the threeD of the selectedObject
  set the hilite of button "opaque" to the opaque of the selectedObject
  set the hilite of button "traversalOn" to the traversalOn of the selectedObject
  set the hilite of button "lockLocation" to the lockLocation of the selectedObject
  set the hilite of button "tabGroupBehavior" to the tabGroupBehavior of the selectedObject
  set the hilite of button "dontSearch" to the dontSearch of the selectedObject
  set the hilite of button "cantDelete" to the cantDelete of the selectedObject
  set the hilite of button "disabled" to the disabled of the selectedObject
  set the hilite of button "hScrollbar" to the hscrollbar of the selectedObject
  set the hilite of button "vScrollbar" to the vscrollbar of the selectedObject
  set the hilite of button "backgroundBehavior" to the backgroundBehavior of the selectedObject
  put the margins of the selectedObject into field "margins"
end getprops
                ;      , Card Properties   	Pon getprops
  if word 1 of the selObj is not "card"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the number of the selectedObject into field "number"
  put the short id of the selectedObject into field "id"
  set the hilite of button "showBorder" to the showBorder of the selectedObject
  set the hilite of button "threeD" to the threeD of the selectedObject
  set the hilite of button "dontSearch" to the dontSearch of the selectedObject
  set the hilite of button "cantDelete" to the cantDelete of the selectedObject
end getprops
              +  -      P Stack Properties   	Ppon setpass
  if the passkey of the selectedObject is the password of the selectedObject
  then set the label of button "Password" to "Password..."
  else set the label of button "Password" to "Passkey..."
end setpass

on getprops
  if word 1 of the selObj is not "stack"
  then exit to MetaCard
  if the name of the selectedObject is not the abbrev id of the selectedObject
  then put the short name of the selectedObject into field "name"
  else put empty into field "name"
  put the title of the selectedObject into field "title"
  put the menubar of the selectedObject into field "menubar"
  if the platform is "MacOS" then
    set the hilite of button "editMenus" to the editMenus of the selectedObject
    show button "editMenus"
  else hide button "editMenus"
  put the width of the selectedObject into field "width"
  put the height of the selectedObject into field "height"
  put the maxWidth of the selectedObject into field "maxWidth"
  put the maxHeight of the selectedObject into field "maxHeight"
  put the minWidth of the selectedObject into field "minWidth"
  put the minHeight of the selectedObject into field "minHeight"
  set the hilite of button "cantModify" to the cantModify of the selectedObject
  set the hilite of button "resizable" to the resizable of the selectedObject
  set the hilite of button "alwaysBuffer" to the alwaysBuffer of the selectedObject
  set the hilite of button "wmPlace" to the wmPlace of the selectedObject
  set the hilite of button "destroyStack" to the destroyStack of the selectedObject
  set the hilite of button "destroyWindow" to the destroyWindow of the selectedObject
  setpass
end getprops
              O  f  g    ~ Layout   	Pon mouseUp
end mouseUp
on menuPick
end menuPick

on preOpenCard
  disable button "Undo"
  pass preOpenCard
end preOpenCard

local nsaved,savednames,savedrects,savedlayers

on savelayout
  put the selectedObjects into savednames
  put the number of lines in savednames into nsaved
  if nsaved < 2 then exit to MetaCard
  enable button "Undo"
  get line 1 of savednames
  repeat with i = 1 to nsaved
    get line i of savednames
    put the rect of it into savedrects[i]
    put the layer of it into savedlayers[i]
  end repeat
end savelayout

on undolayout
  repeat with i = nsaved down to 1
    get line i of savednames
    set the rect of it to savedrects[i]
    set the layer of it to savedlayers[i]
  end repeat
  disable button "Undo"
end undolayout
                 !  "  %        $    '  (  )  *                   No Control Selected   	@              Button Properties  }   yon menuPick newtab, oldtab
  hide group ("B" & oldtab)
  show group ("B" & newtab)
end menuPick

on mouseUp
end mouseUp
             -Name
Appearance
Behavior
Accelerators
Extras        	        Field Properties  } 
  yon menuPick newtab, oldtab
  hide group ("F" & oldtab)
  show group ("F" & newtab)
end menuPick

on mouseUp
end mouseUp
              Name
Appearance
Behavior
Extras        	       > Image Properties  } 
  yon menuPick newtab, oldtab
  hide group ("I" & oldtab)
  show group ("I" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Extras        	       t Scrollbar Properties  u yon menuPick newtab, oldtab
  hide group ("S" & oldtab)
  show group ("S" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Appearance
Extras        	        Graphic Properties  u yon menuPick newtab, oldtab
  hide group ("G" & oldtab)
  show group ("G" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Appearance
Extras        	        Group Properties  }   on menuPick newtab, oldtab
  hide group ("Group" & oldtab)
  show group ("Group" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Properties        	        Relayer Dp# This script relayers objects in the order they
# were selected.  The first object is used as the
# base, so you may want to set its layer first.
on mouseUp
  local onames, nnames, startcontrol, skiplayers
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  put line 1 of onames into startcontrol
  put -1 into skiplayers
  repeat with i = 2 to nnames
    get line i of onames
    set the layer of it to the layer of startcontrol + i + skiplayers
    if word 1 of it is "group"
    then add the number of layers of it - 1 to skiplayers
  end repeat
end mouseUp
          P        	  ~    
Align Top Dp# This script aligns the tops of a set of selected
# objects to the top of the first object selected.
on mouseUp
  local onames, nnames, ycoord
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  put the top of it into ycoord
  repeat with i = 1 to nnames
    get line i of onames
    set the top of it to ycoord
  end repeat
end mouseUp
         < X        	  ~    
Align Middle Dp# This script aligns the middles of a set of selected
# objects to the middles of the first object selected
# If button 2 was pressed, center on the card.
on mouseUp which
  local onames, nnames, ycoord, cname
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  if which is 1
  then put the top of it + the height of it div 2 into ycoord
  else 
    put word 5 to (the number of words in it) of it into cname
    put the height of cname div 2 into ycoord
  end if
  repeat with i = 1 to nnames
    get line i of onames
    set the top of it to ycoord - the height of it div 2
  end repeat
end mouseUp
        l < d        	  ~    
Align Bottom Dp# This script aligns the bottoms of a set of selected
# objects to the center of the first object selected.
on mouseUp
  local onames, nnames, ycoord
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  put the bottom of it into ycoord
  repeat with i = 1 to nnames
    get line i of onames
    set the bottom of it to ycoord
  end repeat
end mouseUp
         < d        	  ~     Align Left Dp# This script aligns the lefts of a set of selected
# objects to the left of the first object selected.
on mouseUp
  local onames, nnames, xcoord
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  put the left of it into xcoord
  repeat with i = 1 to nnames
    get line i of onames
    set the left of it to xcoord
  end repeat
end mouseUp
          X        	  ~   ! 
Align Center Dp# This script aligns the centers of a set of selected
# objects to the center of the first object selected.
# If button 2 was pressed, center on the card.
on mouseUp which
  local onames, nnames, cname, xcoord
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  if which is 1
  then put the left of it + the width of it div 2 into xcoord
  else 
    put word 5 to (the number of words in it) of it into cname
    put the width of cname div 2 into xcoord
  end if
  repeat with i = 1 to nnames
    get line i of onames
    set the left of it to xcoord - the width of it div 2
  end repeat
end mouseUp
        l  d        	  ~   " Align Right Dp# This script aligns the rights of a set of selected
# objects to the right of the first object selected.
on mouseUp
  local onames, nnames, xcoord
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  put the right of it into xcoord
  repeat with i = 1 to nnames
    get line i of onames
    set the right of it to xcoord
  end repeat
end mouseUp
          d        	  ~   $ Same Height Dp# This script sets the height of a set of selected
# objects to the height of the first object selected.
on mouseUp
  local onames, nnames, fheight
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  put the height of it into fheight
  repeat with i = 1 to nnames
    get line i of onames
    set the height of it to fheight
  end repeat
end mouseUp
       D < h        	  ~   % Same Width Dp# This script sets the width of a set of selected
# objects to the width of the first object selected.
on mouseUp
  local onames, nnames, fwidth
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  if nnames < 2
  then exit to MetaCard
  get line 1 of onames
  put the width of it into fwidth
  repeat with i = 1 to nnames
    get line i of onames
    set the width of it to fwidth
  end repeat
end mouseUp
       C  h        	  ~   ' Vertically Dp# This script distributes the space between
# a set of selected objects in equal intervals
# between the first and last objects selected.
# Note that the first and last objects selected
# must be the top and bottom objects.
# If mouse button two is pressed, the objects
# will be distributed across the height of the card.
on mouseUp
  local onames, nnames, theight, starty, endy
  local perspace, toffset, cname, cheight
  local bottomobj, topobj
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  put 0 into theight
  switch the menuHistory of button "Distribution Method"
  case 1
    if nnames < 3
    then exit to MetaCard
    repeat with i = 2 to nnames -1
      get line i of onames
      add the height of it to theight
    end repeat
    get line 1 of onames
    put the bottom of it into starty
    get line nnames of onames
    put the top of it into endy
    put (endy - starty - theight) / (nnames -1) into perspace
    put starty + perspace into toffset
    repeat with i = 2 to nnames -1
      get line i of onames
      set the top of it to round(toffset)
      add the height of it + perspace to toffset
    end repeat
     break
  case 2
    if nnames < 1
    then exit to MetaCard
    repeat with i = 1 to nnames
      get line i of onames
      add the height of it to theight
    end repeat
    get line 1 of onames
    put word 5 to (the number of words in it) of it into cname
    put the height of cname into cheight
    put (cheight - theight) / (nnames + 1) into perspace
    put perspace into toffset
    repeat with i = 1 to nnames
      get line i of onames
      set the top of it to round(toffset)
      add the height of it + perspace to toffset
    end repeat
    break
  case 3
    if nnames < 2
    then exit to MetaCard
    repeat with i = 2 to nnames
      put line i of onames into bottomobj
      put line (i - 1) of onames into topobj
      set the top of bottomobj to the bottom of topobj
    end repeat
  end switch
end mouseUp
         | T        	  ~   ( 
Horizontally Dp# This script distributes the space between
# a set of selected objects in equal intervals
# between the first and last objects selected.
# Note that the first and last objects selected
# must be the left and right objects.
# If mouse button two is pressed, the objects
# will be distributed across the width of the card.
on mouseUp
  local onames, nnames, twidth, startx, endx
  local perspace, toffset, cname, cwidth
  local leftobj, rightobj
  savelayout
  put the selectedObjects into onames
  put the number of lines in onames into nnames
  put 0 into twidth
  switch the menuHistory of button "Distribution Method"
  case 1
    if nnames < 3
    then exit to MetaCard
    repeat with i = 2 to nnames -1
      get line i of onames
      add the width of it to twidth
    end repeat
    get line 1 of onames
    put the right of it into startx
    get line nnames of onames
    put the left of it into endx
    put (endx - startx - twidth) / (nnames -1) into perspace
    put startx + perspace into toffset
    repeat with i = 2 to nnames -1
      get line i of onames
      set the left of it to round(toffset)
      add the width of it + perspace to toffset
    end repeat
    break
  case 2
    if nnames < 1
    then exit to MetaCard
    repeat with i = 1 to nnames
      get line i of onames
      add the width of it to twidth
    end repeat
    get line 1 of onames
    put word 5 to (the number of words in it) of it into cname
    put the width of cname into cwidth
    put (cwidth - twidth) / (nnames + 1) into perspace
    put perspace into toffset
    repeat with i = 1 to nnames
      get line i of onames
      set the left of it to round(toffset)
      add the width of it + perspace to toffset
    end repeat
    break
  case 3
    if nnames < 2
    then exit to MetaCard
    repeat with i = 2 to nnames
      put line i of onames into leftobj
      put line (i - 1) of onames into rightobj
      set the left of leftobj to the right of rightobj
    end repeat
    break
  end switch
end mouseUp
       D | `        	  ~   ) Font... Dp 1on mouseUp
  palette "Font Chooser"
end mouseUp
        l  @        	  ~   * 
Colors... Dp 2on mouseUp
  palette "Color Chooser"
end mouseUp
          L        	  ~   + Card Properties  u on menuPick newtab, oldtab
  hide group ("Card" & oldtab)
  show group ("Card" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Properties        	       O Stack Properties  }   on menuPick newtab, oldtab
  hide group ("Stack" & oldtab)
  show group ("Stack" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Properties        	        CardProperties   a        @      M            D $ x p  > showBorder  e       H ( p  Show Border         	       ? threeD  e       H D p  3D         	      E cantDelete  e       H ` p  
Can't Delete         	       D dontSearch  e       H | p  
Don't Search         	       I 
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
         0 H         	       J Font... Ep 1on mouseUp
  palette "Font Chooser"
end mouseUp
         P H         	       K 
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
         p H         	       N Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
                   	        GAppearance   !                          t    	showName  e          l  
Show Name         	        showBorder  e        8 l  Show Border         	        threeD  e        P l  3D         	       Filled  E        h l         	        startArrow  e         l  Start Arrow         	        	endArrow  e         l  
End Arrow         	        
roundEnds  e         l  Round Ends         	    
               D            
lineSize:    	lineSize  `        4 , ,
   0  63          Font... Ep 1on mouseUp
  palette "Font Chooser"
end mouseUp
         H T         	        
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
         h T         	        Markers... Ep 2on mouseUp
  modal "Graphic Markers"
end mouseUp
          T         	        Style  0 Zon mouseUp
  resetextras
  setproperty "style", the short name of the target
end mouseUp
       <  p    Polygon  E      B 2 d         	        Curve  E      B J d         	        
Rectangle  E      B b d         	        Oval  E      B z d         	        
roundRect  e      B  d  Round Rect         	        Regular  E      B  d         	        
BBehavior   !                           V   traversalOn  e        $ t  
Traversal On         	       
lockLocation  e        B t  Lock Location         	        
sharedHilite  e        ^ t  Shared Hilite         	       autoHilite  e        & t  Auto Hilite         	      . 
hiliteBorder  d        B t  Hilite Border         	    / hiliteFill  d        ^ t  Hilite Fill         	    + autoArm  d      0 & t  	Auto Arm         	     - 
armBorder  d      0 B t  Arm Border         	    , armFill  d      0 ^ t  	Arm Fill         	      
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
         | T         	     
  # menuMouseButton  i`      | x $           
   toolTip  i`       \ D           
             x d            
Menu Button: 
               D            
Tool Tip:   T BAccelerators   !         " 
  1            0 |            Accelerator Key: 
  2 	accelKey  i`        0 0             8 Accelerator Modifiers  0Won mouseUp
  local styles
  put empty into styles
  if the hilite of button "Control"
  then put additem(styles, "control") into styles
  if the hilite of button "Alt"
  then put additem(styles, "alt") into styles
  if the hilite of button "Shift"
  then put additem(styles, "shift") into styles
  setproperty "accelMods", styles
end mouseUp
         &  .  9 Control  D        : L         	     : Alt  D      . : 0         	     ; Shift  D      f : <         	   
  5            ` |            Accelerator Text: 
  6 
accelText  i`        `            
  3           ` d            Right Margin: 
  4 rightMargin  i`       ` (           
  (             `            Menu Name: 
  ) 	menuName  i`       h               < Toplevel... Ep don mouseUp
  if there is a stack (field "menuName")
  then toplevel (field "menuName")
end mouseUp
       T  T         	     
              d             Distribution Method:    Distribution Method  e        |   Across Card    (First to Last Selected
Across Card
Abut        	     
              d P            Distribute:     A`        `         	         A`                 	       < FExtras   !         ,  
  4            < l            Border Width:   5 borderWidth  a       | 0  $O 0  32       
  7            l l            Shadow Offset:   6 
shadowOffset  a       | `  $' 0  64         8 Custom Properties... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
        D           	           D    eeeeee                   ? < B             8          2 < ~  Ã Ã           1                 X n =P < m ~ P  P 〾 πm  8 > Z <  <  8 ( <  <  <           Help Dp Ion mouseUp
  go to card "Layout" of stack "Dialog Box Help"
end mouseUp
       $  <        	  ~    Undo Dp %on mouseUp
  undolayout
end mouseUp
       l  @        	  ~    New Button A`    @    ,         	        help  )                     help C on mouseUp
  help
end mouseUp
                                     	        regular Extras   !on setgprops
  set the startAngle of the selectedObject to the thumbPos of scrollbar "Start Angle"
  set the arcAngle of the selectedObject to the thumbPos of scrollbar "Arc Angle"
  pass setgprops
end setgprops

on resetGroups
  if the hilite of button "Oval"
  then show me
  else hide me
  if word 1 of gettarget() is "graphic" then
    set the thumbPos of scrollbar "Start Angle" to the startAngle of gettarget()
    set the thumbPos of scrollbar "Arc Angle" to the arcAngle of gettarget()
  end if
  pass resetGroups
end resetGroups
         $ \   
polySides  a       t ($ $  #O 3  32          angle  a       t X( $*  
 0  360       
              4 l            Polygon Sides: 
             < d 8            Angle:    roundRect Extras   !{on setgprops
  set the roundRadius of the selectedObject to the thumbPos of scrollbar "Round Radius"
  pass setgprops
end setgprops

on resetGroups
  if the hilite of button "Round Rect"
  then show me
  else hide me
  if word 1 of gettarget() is "graphic"
  then set the thumbPos of scrollbar "Round Radius" to the roundRadius of gettarget()
  pass resetGroups
end resetGroups
         < ,   roundRadius  a       p @0 $;+  ' 0  64       
              L h            Round Radius:    oval Extras   !on setgprops
  set the startAngle of the selectedObject to the thumbPos of scrollbar "Start Angle"
  set the arcAngle of the selectedObject to the thumbPos of scrollbar "Arc Angle"
  pass setgprops
end setgprops

on resetGroups
  if the hilite of button "Oval"
  then show me
  else hide me
  if word 1 of gettarget() is "graphic" then
    set the thumbPos of scrollbar "Start Angle" to the startAngle of gettarget()
    set the thumbPos of scrollbar "Arc Angle" to the arcAngle of gettarget()
  end if
  pass resetGroups
end resetGroups
         $ X   startAngle  a       ` (@ $*  = 0  360          	arcAngle  a       ` T@ $*  = 0  360       
              4 T            startAngle: 
              ` L            
arcAngle:    
FBehavior   !         $   1             ( p  ' traversalOn  e aon mouseUp
  if the hilite of me
  then setbutton "autoHilite", true
  pass mouseUp
end mouseUp
         , p  
Traversal On         	       ( 	lockText  e Won mouseUp
  setbutton "traversalOn", not the hilite of me
  pass mouseUp
end mouseUp
         H p  
Lock Text         	      % autoHilite  e on mouseUp
  setbutton "lockText", true
  setbutton "sharedText", true
  if not the hilite of me then setbutton "listBehavior", false
  pass mouseUp
end mouseUp
         d p  Auto Hilite         	       autoTab  e         p  	Auto Tab         	       } 
listBehavior  e on mouseUp
  if the hilite of me then
    setbutton "dontWrap", true
    setbutton "lockText", true
    setbutton "sharedText", true
    setbutton "autoHilite", true
  end if
  pass mouseUp
end mouseUp
         ,   List Behavior         	       - multipleHilites  d        H   Multiple Hilites         	     0 noncontiguousHilites  d        d   Noncontiguous Hilites         	     + toggleHilites  d           Toggle Hilites         	     ) 
threeDHilite  d      8 , t  
3D Hilite         	      
lockLocation  e      8 H t  Lock Location         	      , dontSearch  d      8 d t  
Don't Search         	     & sharedText  e Don mouseUp
  setbutton "lockText", true
  pass mouseUp
end mouseUp
       8  t  Shared Text         	      " 
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
          @         	     
  .           X  D            
Tool Tip: 
  / toolTip  i`                     k IExtras   !        
     S showBorder  e        $ x  Show Border         	       T threeD  e        < x  3D         	      V 
lockLocation  e        T x  Lock Location         	       n traversalOn  e        l x  
Traversal On         	     
  h Width  i`        ( 4         ?  
  j Height  i`        P 4         ?  
  m hotSpot  i`        x L         ?  
   tooltip  i`       R           ?    r 
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
       F ( L         	       b 
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
       F P L         	       s Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
       2 x t         	       | Paint Tools... Ep 0on mouseUp
  palette "Paint Tools"
end mouseUp
       2  t         	     
  g            ( :            Width: 
  i            P :            Height: 
  l            x L            
Hot Spot: 
               D            
Tool tip:    
alwaysBuffer  e         x  Always Buffer         	       SExtras   !        $ $s 
             l ( t            Number Format: 
             8 \ D            
Tool tip: 
   
numberFormat  `        ( p             
   tooltip  i`       | \          u     
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
        (  L         	        
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
          X         	        Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
                  	        GExtras   !           @   regular Extras   !           \   
polySides  a       x $$ $  #O 3  32          angle  a       x T( $  *  
 0  360       
              0 l            Polygon Sides: 
             @ ` 8            Angle:    roundRect Extras   !         8 ,   roundRadius  a       t <0 $;+  ' 0  64       
              H h            Round Radius:    polygon Extras  $           Points 
   Points  )p on closeField
  if the hilite of button "relativePoints"
  then setproperty "relativePoints", me
  else setproperty "points", me
end closeField
         0 l                 	`        1     dontResize @e       V   
Don't Resize         	        relativePoints @e on mouseUp
  if word 1 of the selobj is not "graphic"
  then exit to MetaCard
  if the hilite of me
  then put the relativePoints of the selobj into field "points"
  else put the points of the selobj into field "points"
end mouseUp
        :   Relative to topLeft         	       oval Extras   !           X   startAngle  a       d $@ $  *  = 0  360          	arcAngle  a       d P@ $*  = 0  360       
              0 T            startAngle: 
              \ L            
arcAngle:    
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
          L         	        Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
                   	        
PlayerExtras   !          |    traversalOn  e 
          $   
Traversal On         	       showBorder  e        <   Show Border         	       
lockLocation  e        T   Lock Location         	        
alwaysBuffer  e        l   Always Buffer         	        showController  e           Show Controller         	        Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
        ( x         	        
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
         ( P         	        
showBadge  e           Show Badge         	       ? BExtras   !          
  W                        Button (Menu) Contents:    borderWidth  a       p $  $O 0  32          
shadowOffset  a       p T  $' 0  64       
   icon  i`       X  @              
Choose... Ep hon mouseUp
  palette "Icon Chooser"
  set the targetprop of stack "icon chooser" to "icon"
end mouseUp
          P         	     
   hiliteIcon  i`       X  @              
Choose... Ep non mouseUp
  palette "Icon Chooser"
  set the targetprop of stack "icon chooser" to "hiliteIcon"
end mouseUp
          P         	     
  U text )p on openField
end openField

#on closeField
  if the selectedObject is empty
  then exit to MetaCard
  set the text of the selectedObject to me
end closeField
        4  d              V    	`       5  b   Custom Properties... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
                  	     
              0 h            Border Width: 
              ` h            Shadow Offset: 
               P            Icon: 
               P            
Hilite Icon:    GroupProperties   a                              	showName  e        $ v  
Show Name         	        showBorder  e        < v  Show Border         	        threeD  e        T v  3D         	       Opaque  EC        l v         	        traversalOn  e         v  
Traversal On         	        
lockLocation  e         v  Lock Location         	       tabGroupBehavior  e        $ t  
Tab Group         	        dontSearch  e        < t  
Don't Search         	        cantDelete  e        T t  
Can't Delete         	        	Disabled  E        l t         	        hScrollbar  e         t  Horizontal SB         	        vScrollbar  e         t  Vertical SB         	        backgroundBehavior  e      T        Background Behavior         	       
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
       4 $ t         	         Font... Ep 1on mouseUp
  palette "Font Chooser"
end mouseUp
       4 D t         	       	 
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
       4 d t         	        Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
       4  t         	       
 Edit Ep Qon mouseUp
  start editing the selectedObject
  choose pointer tool
end mouseUp
       4  t         	        SAppearance   !          
              , x            Thumb Size: 
              P x            Thumb Position: 
  |           $ t \            
Start Value: 
  ~           $  \            End Value: 
              D x            Line Increment: 
                x            Page Increment: 
   
thumbSize  `        , 8             
   thumbPosition  `        P 8             
  } startValue  `        t 8             
   	endValue  `         8             
   pageIncrement  `      l   8             
   lineIncrement  `      l D 8               y Style  0 on mouseUp
  setproperty "style", the short name of the target
  setbutton "traversalOn", the short name of the target is not "progress"
end mouseUp
         d d ^  { 
Scrollbar @E        x X         	      z Scale @E         X         	        	Progress @E         X         	        
showValue @e      8 h t  Show Value         	        
lockLocation @e      8  t  Lock Location         	       Opaque @E      8  t         	       traversalOn @e      8  t  
Traversal On         	        FAppearance   !                              showBorder  e          l  Show Border         	       threeD  e        8 l  3D         	       Opaque  e        P l  Opaque         	       	dontWrap  e        h l  Don't Wrap         	       
showLines  e         l  Show Lines         	        fixedLineHeight  e           Fixed Line Height         	       hScrollbar  e           Horizontal Scrollbar         	    
                D            	Margins: 
   Margins  i`          L           
               \            First Indent: 
   firstIndent  i`      x   4           
              D L            
Tabstops: 
    	tabStops  i`        D               hGrid  E        h @         	        vGrid  E        h @         	       ~ Show as Label Epon mouseUp
  set the style of the selectedObject to "rectangle"
  set the hilitedButtonName of group "Style" to "Rectangle"
  setbutton "lockText", true
  setbutton "sharedText", true
  setbutton "dontWrap", true
  setbutton "showBorder", false
  setbutton "opaque", false
  setbutton "traversalOn", false
  setbutton "listBehavior", false
  setbutton "autoHilite", false
end mouseUp
          |         	        Font... Ep 1on mouseUp
  palette "Font Chooser"
end mouseUp
          <         	        
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
          H         	        Style  p Von mouseUp
  setproperty "style", the short name of the target
  refresh
end mouseUp
       D d h ^   
Rectangle  E      J x \         	        Shadow  E      J  \         	       
 
Scrolling  E      J  \         	      g StackProperties   a            j cantModify  e          l  
Can't Modify         	      h 
resizable  e        < \  
Resizable         	      i 
cantAbort  e        X h  Can't Abort         	       k wmPlace  e        t   Manual Placement         	       y 
destroyStack  e           Destroy Stack On Close         	       z destroyWindow  e           Destroy Window On Close         	        
alwaysBuffer  e          t  Always Buffer         	      l 
Script... Ep ?on mouseUp
  editScript the long id of the selobj
end mouseUp
         H H         	       m Font... Ep 1on mouseUp
  palette "Font Chooser"
end mouseUp
         h H         	       n 
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
          H         	       q Icon... Ep 1on mouseUp
  palette "Icon Chooser"
end mouseUp
          H         	       s Components... Ep 5on mouseUp
  palette "Stack Components"
end mouseUp
       4 * t         	       r 	Password ep on mouseUp
  if the passkey of the selObj is the password of the selObj
  then modal "Stack Password"
  else modal "Stack Passkey"
  setpass
end mouseUp

       4 H t  Password...         	        Stack Files... Ep .on mouseUp
  modal "Stack Files"
end mouseUp
       4 h t         	       o Custom Props... Ep 4on mouseUp
  modal "Custom Properties"
end mouseUp
       4  t         	       p Main Stack... Ep -on mouseUp
  modal "Main Stack"
end mouseUp
       4  t         	        BAppearance   !                          t    	showName  e          l  
Show Name         	       showBorder  e        8 l  Show Border         	       showHilite  e        P l  Show Hilite         	         threeD  e        h l  3D         	       Opaque  E         l         	       Default  e         l  Default         	        	Disabled  e         l  	Disabled         	        
Colors... Ep 2on mouseUp
  palette "Color Chooser"
end mouseUp
         ( D         	        Font... Ep 1on mouseUp
  palette "Font Chooser"
end mouseUp
         H D         	        
Make
Divider Epon mouseUp
  if the width of the selobj > the height of the selobj
  then set the height of the selobj to 2
  else set the width of the selobj to 2
  set the hilitedButtonName of group "Style" to the "Rectangle"
  setproperty "style","rectangle"
end mouseUp
         h D (        	        Make
Menu Item Epon mouseUp
  setproperty "style", "standard"
  setbutton "showBorder", false
  setbutton "opaque", true
  setbutton "traversalOn", true
  setbutton "autoArm", true
  setbutton "autoHilite", false
  setbutton "armBorder", true
  settextalign "left"
end mouseUp
        |  T (        	       	 Style  pon mouseUp
  local tname
  put the short name of the target into tname
  switch tname
  case "CheckBox"
  case "RadioButton"
    setproperty "style", tname
    setbutton "showBorder", false
    setbutton "opaque", false
    setbutton "hiliteBorder", false
    setbutton "armBorder", false
    setbutton "autoHilite", true
    settextalign "left"
    set the menumode of the selobj to empty
    break
  case "Pulldown"
  case "Popup"
  case "Option"
  case "ComboBox"
  case "Tabbed"
    setproperty "style", "menu"
    set the menumode of the selobj to tname
    setbutton "armBorder", false
    setbutton "autoArm", false
    setbutton "autoHilite", false
    settextalign "left"
    setbutton "traversalOn", false
    setbutton "opaque", true
    switch tname
    case "Tabbed"
      setbutton "showName", false
      setbutton "showBorder", true
      break
    case "ComboBox"
      setbutton "traversalOn", true
      setbutton "showBorder", true
      break
    case "Option"
      setbutton "showBorder", true
      break
    default
      setbutton "showBorder", false
    end switch
    break
  case "Cascade"
    setproperty "style", "menu"
    set the menumode of the selobj to tname
    setbutton "showBorder", false
    setbutton "opaque", true
    setbutton "traversalOn", true
    setbutton "autoArm", true
    setbutton "autoHilite", false
    setbutton "armBorder", true
    settextalign "left"
    break
  default
    setproperty "style", tname
    setbutton "showBorder", true
    setbutton "opaque", true
    setbutton "hiliteBorder", true
    settextalign "center"
    set the menumode of the selobj to empty
  end switch
  refresh
end mouseUp
         "         RadioButton  E        4 h         	       
 	CheckBox  E        L h         	        Shadow  E        d h         	        
RoundRect  E        | h         	       
 
Rectangle  E         h         	        	Standard  E         h         	       	Pulldown  D      H 4 `         	     ! Popup  D      H L `         	     " Cascade  D      H d `         	       Option  D      H | `         	     = 	ComboBox  D     H  `    	combobox  falsef  false        	     > Tabbed  D      H  `         	     f 
StackName   )           
  X            D \            
Stack Title: 
  R            $ \            Stack Name: 
  S name  ip3local notwarned
on openField
  put true into notwarned
  pass openField
end openField

on closeField
  if there is a stack field "Name" and notwarned then
    modal "Duplicate Stack Name"
    select the text of me
    put false into notwarned
    exit to MetaCard
  end if
  pass closeField
end closeField
        h $@         P  
  Y Title  i`       h D@         P  
   menubar  i`       h d          P     
editMenus @e      D h d  Edit Menus          	     
  c width  i`       D  6         P  
  d height  i`       D  4         P  
  [ 	MaxWidth  i`         4         P  
  \ 
MaxHeight  i`         4         P  
  ` 	MinWidth  i`      t  4         P  
  a 
MinHeight  i`      t  4         P  
  Z             X            Max Width: 
  ]             X            Max Height: 
  ^             T            Min Width: 
  _             T            Min Height: 
  b             8            Width: 
  e             8            Height: 
              d \            
Menu Bar:   = BName   )         $ 
              ( d            
Button Name: 
   Name  i`       p (8           
              ` 8            Layer: 
   Layer  i`       D ` $           
             t ` D            Number: 
   Number  	         ` 0          1 
              `              Id: 
   Id  	         ` H          1003 
  $          0 ` T            
Mnemonic: 
  % 	Mnemonic  i`       ` $           
               4            Label: 
   Label  i`       @ h              FName   )        
 $ 
              ( Z            Field Name: 
   Name  i`       h (D           
              L 8            Layer: 
   Layer  i`       F L $           
              L D            Number: 
   Number  	         L (          3 
            H L              Id: 
   Id  	       ` L D          1003 
              l L            
Contents: 
   text )p on openField
end openField

on closeField
  if the selectedObject is empty
  then exit to MetaCard
  set the text of the selectedObject to me
end closeField
        ^ pP T        8          	`       q  R  2 
Import... Epon mouseUp
  answer file "Choose a file to import..."
  if it is not empty then
    set the cursor to watch
    local fname
    put it into fname
    open file fname for read
    if the result is not empty then
      answer "Can't open file" && fname
      exit to MetaCard
    end if
    read from file fname until eof
    put it into field "text"
    close file fname
    set the text of the selectedObject to field "text"
  end if
end mouseUp
          F         	        IName   i         $ 
              ( h            Image Name: 
   name  i`       t (4         ?  
              ` 8            Layer: 
   layer  i`       D ` ,         ?  
             x ` B            Number: 
              `              Id: 
   id           ` D            27 
               T            File Name: 
   	fileName  i`       `           ?     
Select... Ep on mouseUp
  answer file "Select image file to display:"
  if it is not empty then
    put it into field "fileName"
    setproperty "fileName", it
end if
end mouseUp
       d  H         	     
   number  	         ` 2         ? 1 
            < ` ,            Size: 
   size         d ` D            62    SName   )         $ \
  A            ( t            Scrollbar Name: 
  B Name  i`        ((         u  
  C            ` 4            Layer: 
  D Layer  i`       @ ` ,         u  
  E            ` B            Number: 
  F Number  	         ` 6         u 1 
  M          4 `              Id: 
  w id  	       P ` L         u 1033    GName   )         $ 
               @            
Tool tip: 
              ( p            Graphic Name: 
   Name  i`       | (,           
   Label  i`       D Pd           
   Layer  i`       D x 0           
   tooltip  i`       L                
lockLocation  e      4  x  Lock Location         	     
              x 8            Layer:    traversalOn  e      4  x  
Traversal On         	     
              x B            Number: 
   Number  	         x 6          1 
            < x              Id: 
   id  	       T x X          1013 
              P 8            Label:    PlayerName   i         $ 
              ( d            
Player Name: 
   Name  i`       p (8           
   Layer  i`       D P 0           
              P 8            Layer: 
              P B            Number: 
   Number  	         P 6          1 
            < P              Id: 
   id  	       X P P          1013 
              x P            File Name: 
               D            
Tool tip: 
   tooltip  i`       L \           
   	fileName  i`       \ x               
Select... Ep on mouseUp
  answer file "Select image file to display:"
  if it is not empty then
    put it into field "fileName"
    setproperty "fileName", it
end if
end mouseUp
       ` x H         	       ; 
GroupName   i         $ 
            < ` H            	Margins: 
  /            ( d            Group Name: 
  0 Name  i`       p (8           
  1            ` 4            Layer: 
  2 Layer  i`       @ ` $           
  3           r ` F            Number: 
   margins  i`       ` $           
  4 Number  	         ` "          1 
  5            `              Id: 
  6 Id  	         ` H          1003 
  9             4            Label: 
  : Label  i`       @ h             - 	CardName   i         , \
              0 \            Card Name: 
   name  i`       h 0@         ,  
              h D            Number: 
   Number  	        H h 6         , 1 
            @ h              Id: 
   id  	       X h P         , 1001    EPS Properties  u on menuPick newtab, oldtab
  hide group ("Player" & oldtab)
  show group ("Player" & newtab)
end menuPick

on mouseUp
end mouseUp
             Name
Extras        	        
Font Chooser   local curobj, initted

on refresh
  --  exit refresh
  if the mode of me is 0
  then exit refresh
  if the selobj is empty then
    if the number of this card is not 2 then go to card 2
    exit refresh
  end if
  if the long id of the selobj is curobj then exit refresh
  put the long id of the selobj into curobj
  if the number of this card is not 1 then go to card 1
  local tfont, tsize, tstyle, fsizes
  set the hilitedButtonName of group "Alignment" to the textAlign of the selobj
  put the textFont of the selobj into tfont
  put the textSize of the selobj into tsize
  put the textStyle of the selobj into tstyle
  if tfont is empty then put "none" into tfont
  set the label of button "textFont" to tfont
  put fontSizes(tfont) into fsizes
  sort fsizes numeric
  if word 1 of fsizes is 0
  then put format("8\n10\n12\n14\n18\n20\n24\n34") into button "textSize"
  else put fsizes into button "textSize"
  set the label of button "textSize" to the textSize of the selobj
  put the textHeight of the selobj into field "textHeight"
  put the textStyle of the selectedObject into tstyle
  set the hilite of button "Bold" to tstyle contains "bold"
  set the hilite of button "Italic" to tstyle contains "italic"
  set the enabled of button "Bold" to fontStyles(tfont, tsize) contains "bold"
  set the enabled of button "Italic" to fontStyles(tfont, tsize) contains "italic"
end refresh

on setproperty p, v
  local setstring
  if the selectedObject is not empty then
    if v is "none" then put empty into v
    repeat for each line l in the selectedObjects
      put format("set the %s of %s to \"%s\"\n", p, l, v) after setstring
      if p is "textSize"
      then put format("set the textheight of %s to %s\n", l, v * 4 / 3) after setstring
    end repeat
    do setstring
    refresh
  end if
end setproperty

on closeField
  if the selobj is empty
  then exit to MetaCard
  setproperty the short name of the target, the text of the target
end closeField

on mouseUp
  if the selobj is empty
  then exit to MetaCard
  switch the short name of the owner of the target
  case "Alignment"
    set the textAlign of the selobj to the short name of the target
    break
  case "Style"
    switch the hilite of button "Bold" && the hilite of button "Italic"
    case "true true"
      set the textStyle of the selobj to "bold,italic"
      break
    case "true false"
      set the textStyle of the selobj to "bold"
      break
    case "false true"
      set the textStyle of the selobj to "italic"
      break
    default
      set the textStyle of the selobj to empty
      break
    end switch
  end switch
end mouseUp

on menuPick which
  if the selobj is empty
  then exit to MetaCard
  setproperty the short name of the target, which
  put empty into curobj
  refresh
end menuPick

on preOpenStack
  go to card 1
  if initted is empty then
    local fnames
    put the fontnames & return & "none" into fnames
    sort fnames
    put fnames into button "textFont"
    refresh
    put true into initted
  end if
  refresh
end preOpenStack

on closeCard
  put empty into curobj
end closeCard
       \ r             U 
Helvetica    FC Card   	@          \ r                      	@          \ r
     
        \  <          Name: 
     
        \ , <          Size: 
     
        \ P <          Height: 
   textHeight  i`        P 0          13    	textSize  +e        , D  10    8
10
12
14
18
24 
      	        	textFont  +e           
helvetica    charter
clean
courier
fangsong ti
fixed
gothic
helvetica
lucida
lucidabright
lucidatypewriter
mincho
new century schoolbook
nil
none
open look cursor
open look glyph
song ti
symbol
terminal
times
utopia 
      	        
Alignment  0 on mouseUp
  if the short name of the target is in "Left Center Right"
  then setproperty "textAlign", the short name of the target
end mouseUp
          T ^   Left  E         H         	        Center  E        4 H         	       Right  E        L H         	        
textStyle  $0:on mouseUp
  if the id of the owner of the target is not the id of me then pass mouseUp
  local styles
  if the hilite of button "Bold"
  then put additem(styles, "bold") into styles
  if the hilite of button "Italic"
  then put additem(styles, "italic") into styles
  setproperty "textStyle", styles
end mouseUp
         & F F Style    Bold  D       : :         	      Italic  D       R :         	     # Preferences                         U 
Helvetica   U 
helvetica   U 
helvetica       	Pon closeStack
  save stack "Home"
end closeStack

on preOpenCard
  local notunix
  put the platform is "Win32" or the platform is "MacOS" into notunix
  set the hilitedButtonName of group "lnf" to the lookAndFeel
  set the hilite of button "grid" to the grid
  set the thumbPos of scrollbar "Grid Size" to the gridSize
  set the hilite of button "selectGroupedControls" to the selectGroupedControls
  set the hilite of button "centered" to the centered
  if the selectionMode is "intersect"
  then set the menuHistory of button "selectionMode" to 1
  else set the menuHistory of button "selectionMode" to 2
  set the label of button "selectionHandleColor" to the selectionHandleColor
  set the hilite of button "systemFileSelector" to the systemFileSelector
  set the visible of button "systemFileSelector" to notunix
  set the hilite of button "pointerFocus" to the pointerFocus
  set the visible of button "pointerFocus" to not notunix
  set the hilite of button "raisePalettes" to the raisePalettes
  set the hilite of button "raiseMenus" to the raiseMenus
  set the hilite of button "emacsKeyBindings" to the emacsKeyBindings
  set the itemDelimiter to colon
  put item 1 of the httpProxy into field "httpproxyhost"
  if item 2 of the httpProxy is empty
  then put 80 into field "httpproxyport"
  else put item 2 of the httpProxy into field "httpproxyport"
  if notunix then
    get button "Preferences"
    if last line of it is "External Editor" then
      delete last line of it
      put it into button "Preferences"
    end if
  else
    if the preferences["external editor"] of stack "Home" is not empty then
      put the preferences["external editor"] of stack "Home" into field "external editor"
      set the hilite of button "use external editor" to true
    else
      put "/usr/bin/X11/xterm -geom 80x30 -e vi" into field "external editor"
      set the hilite of button "use external editor" to false
    end if
  end if
end preOpenCard

on menuPick which
  setproperty the short name of the target, which
end menuPick

on setproperty p, v
  local c
  put format("set the %s to \"%s\"\n", p, v) into c
  put format("set the preferences[\"%s\"] of stack \"Home\" to \"%s\"", p, v) after c
  do c
end setproperty
                         Preferences  +u Eon menuPick new, old
  hide group old
  show group new
end menuPick
         |    .Layout
Look and Feel
Proxies
External Editor
        	        External Editor   !          $ b
             $ ( "           'Command to run external script editor: 
   external editor  p ]on closeField
  set the preferences["external editor"] of stack "Home" to me
end closeField
        $ J             %/usr/bin/X11/xterm -geom 80x30 -e vi    use external editor @e on mouseUp
  set the preferences["use external editor"] of stack "Home" to the hilite of me
  if the hilite of me
  then set the preferences["external editor"] of stack "Home" to field "external editor"
end mouseUp
        & r   Go directly to external editor         	        Look and Feel   a          d p   systemFileSelector @e Mon mouseUp
  setproperty "systemFileSelector", the hilite of me
end mouseUp
         ,   Use system file selector          	       
pointerFocus @e Gon mouseUp
  setproperty "pointerFocus", the hilite of me
end mouseUp
         (   Accept pointer focus          	       raisePalettes @e Hon mouseUp
  setproperty "raisePalettes", the hilite of me
end mouseUp
         @   Raise palettes above windows          	        raiseMenus @e Eon mouseUp
  setproperty "raiseMenus", the hilite of me
end mouseUp
         X   Raise menu windows          	        emacsKeyBindings @e on mouseUp
  setproperty "emacsKeyBindings", the hilite of me
  send "doinit" to group "MetaCard Menu Bar" of stack "MetaCard Menu Bar"
end mouseUp
         p   Use Emacs Key Bindings          	       lnf   on mouseUp
  local smodes
  get the openStacks
  lock messages
  repeat for each line l in it
    put the mode of stack l into smodes[l]
    close stack l
  end repeat
  setproperty "lookAndFeel", the hilitedButtonName of me
  wait 100 milliseconds
  repeat with l = the number of lines in it down to 1
    do "go to stack" && quote & line l of it  & quote && "as" && smodes[line l of it]
  end repeat
  unlock messages
  set the backColor of stack "Home" to empty
  if the lookAndFeel is "Macintosh"  or the lookAndFeel is "Appearance Manager"
  then set the bottomColor of stack "Home" to "172,172,172"
  else set the bottomColor of stack "Home" to "128,128,128"
end mouseUp
         $ x h   Motif `D        ( p          	  	        Windows 95 `D        @ p          	   	        
Macintosh `D        X p          	   	       # Appearance Manager `d        p p  
OS Native          	   	        Proxies   a         4 D
     	@        8             HTTP proxy host: 
    	@        \             HTTP proxy port: 
   httpproxyhost  ip on closeField
  if me is empty then
    put empty into field "httpproxyport"
    setproperty "httpProxy", empty
  else setproperty "httpProxy", me & colon & field "httpproxyport"
end closeField
         8            
   httpproxyport  ip on closeField
  if me is empty
  then setproperty "httpproxy", empty
  else
    if me is not an integer
    then answer "Proxy port must be an integer"
    else setproperty "httpproxy", field "httpproxyhost" & colon & me
  end if
end closeField
         \ 4          80    Layout   i        
 p z   grid  D ?on mouseUp
  setproperty "grid", the hilite of me
end mouseUp
         & 8         	  
             N $ T            Grid Size:    
Grid Size  q Qon scrollbarDrag
  setproperty "gridSize", the thumbPos of me
end scrollbarDrag
            $933  s 2  64         ! Selections  i         @h R
              T h            Mode:    selectGroupedControls  d Pon mouseUp
  setproperty "selectGroupedControls", the hilite of me
end mouseUp
         T   Grouped Controls         	      selectionMode 	e       T X  
Intersect    Intersect
Surround        	     
              t h            Handle Color:    selectionHandleColor 	e       t X  0,0,0    #Black
White
Red
Green
Blue
Yellow
        	       " 	centered  d Pon mouseUp
  setproperty "selectGroupedControls", the hilite of me
end mouseUp
         t   Resize From Center         	      MC SelectedObject Menu   Bon preOpenStack
end preOpenStack

on resizeStack
end resizeStack
       vU v                  U 
Helvetica       	p son help
  go to card "Tools Menu" of stack "Dialog Box Help" as modeless
end help

on preOpenCard
end preOpenCard
            v                  Cut TiP 1on mouseUp
  cut the selectedObject
end mouseUp
         8 r        	      Edit Script... TiP <on mouseUp
  edit script of the selectedObject
end mouseUp
          r        	      Properties.... TiP /on mouseUp
  palette "Properties"
end mouseUp
          r        	      File Separator 1 @g        4 r          	      
Send mouseUp TiP Aon mouseUp
  send "mouseUp 2" to the selectedObject
end mouseUp
         n r        	      Copy TiP 2on mouseUp
  copy the selectedObject
end mouseUp
         P r        	      File Separator 1 @g        j r          	      Script Errors          ~         , d     U 
Helvetica   U 
helvetica   U 
helvetica       	Pon resizeStack
  set the width of field 1 to the width of me - 8
  set the height of field 1 to the height of me - 56
  set the bottom of button 1 to the height of me - 12
  set the bottom of button 2 to the height of me - 12
  set the right of button 2 to the width of me - 32
end resizeStack

on refresh which
  repeat for each line l in which
    if item 1 of l is 1 and item 4 of l is not in field "Object Names"
    then put return & item 4 of l after field "Object Names"
  end repeat
  if line 1 of field "Object Names" is empty
  then delete line 1 of field "Object Names"
end refresh

on openStack
  set the hilitedLines of field "Object Names" to 1
end openStack

on closeStack
  put empty into field "Object Names"
end closeStack
                  
   
Object Names )pon mouseDoubleUp
  send "mouseUp" to button "Script..."
end mouseDoubleUp

on removeSelectedObject which
  repeat with i = 1 to the number of lines in me
    if line i of me is which then
      put the hilitedLines of me into which
      delete line i of me
      if me is empty then close this stack
      set the hilitedLines of me to which - 1
      exit repeat
    end if
  end repeat
end removeSelectedObject
          e                  	`         c   
Script... Dp Ton mouseUp
  editScript the selectedText of field "Object Names", true
end mouseUp
        $ u h          	   	        Help Dp on mouseUp
  help
end mouseUp
      I u h    rigth  344         	   	        Printer Chooser          nl6                   	Pon preOpenCard
  set the hilite of button "Portrait" to not the printRotated
  set the hilite of button "Landscape" to the printRotated
  switch the printPaperSize
  case "612,1008"
    set hilitedButtonName of group "Paper Size" to "Legal"
    break
  case "595,842"
    set hilitedButtonName of group "Paper Size" to "A4"
    break
    default:
    set hilitedButtonName of group "Paper Size" to "Letter"
  end switch
  put the printCommand into field "Command"
end preOpenCard

on returnInField
  setprops
end returnInField

on returnKey
  setprops
end returnKey

on setprops
  set the printRotated to the hilite of button "Landscape"
  if the hilite of button "Letter" then set the printPaperSize to "612,792"
  if the hilite of button "Legal" then set the printPaperSize to "612,1008"
  if the hilite of button "A4" then set the printPaperSize to "595,842"
  if the printCommand is not field "Command" then
    set the printCommand to field "Command"
    if line 1 of the mainStacks is "Home" then
      set the preferences["printCommand"] of stack "Home" to field "Command"
      save stack "Home"
    end if
  end if
  close this stack
end setprops
           6                   
              ( `            Paper Size: 
   Command  i`       X H           mv %s $HOME/mc/mc.ps 
              H T            	Command: 
               `            
Orientation:    Orientation           d      	Portrait  E       h  L         	       
Landscape  E         d         	        Paper Size           d (     Letter  E       h , @         	       Legal  E        , @         	        A4  E        , 0         	        OK Mp #on mouseUp
  setprops
end mouseUp
         t L         	        Cancel Ep +on mouseUp
  close this stack
end mouseUp
        x t L         	        Help Ep on mouseUp
  help
end mouseUp
         t L         	        Standalone Builder          T              U 
Helvetica   U 
helvetica   U 
helvetica       	Pon preOpenCard
  switch the platform
  case "MacOS"
    show group "Creator"
    set the itemDelimiter to "."
    if item 1 of the systemversion >= 10
    then put "MetaCard.app" into field "Engine"
    else put "MetaCardPPC" into field "Engine"
    break
  case "Win32"
    hide group "Creator"
    put "mc.exe" into field "Engine"
    break
  default
    hide group "Creator"
    put "mc" into field "Engine"
    break
  end switch
end preOpenCard

on openCard
  set the customKeys of me to empty
end openCard
          T                                  
    	           `            Stack name:    
Select... Epon mouseUp
  if the platform is "MacOS"
  then answer file "Select stack to build standalone from:" with filter "MSTKRSTK"
  else answer file "Select stack to build standalone from:" with filter "*.mc"
  if it is not empty then put it into field "Source"
end mouseUp
         @          	     
   Source  i`                    
    	          <             MetaCard engine: 
   Engine  i`        T           mc    Build EpLon mouseUp
  local SourceFile, EngineFile, AppIconFile, DocIconFile, DestFile, tExtension
  local AppIconData, DocIconData, eOffset, EngineSize
  local foffset, toffset, newvalue, saveftype, not68K
  put true into not68K
  set the cursor to watch
  put field "Source" into SourceFile
  put field "Engine" into EngineFile
  put field "AppIcon" of stack "Version Info" into AppIconFile
  put field "DocIcon" of stack "Version Info" into DocIconFile
  put field "Destination" into DestFile
  if char -4 of Enginefile is "." then
    put char -4 to -1 of Enginefile into tExtension
    if char -4 to -1 of DestFile is not tExtension then
      answer error "Standalone must have a" && tExtension && "extension."
      exit to MetaCard
    end if
    if tExtension is ".app" then
      get shell("cp -R" && quote & EngineFile & quote && quote & DestFile & quote)
      if it is not empty then
        answer error "Error copying engine file."
        exit to MetaCard
      end if
      put "/Contents/MacOS/MetaCard" after EngineFile
      put "/Contents/MacOS/MetaCard" after DestFile
    end if
  end if
  set the caseSensitive to true
  if AppIconFile is not empty then
    open file AppIconFile for binary read
    if the result is not empty then
      answer "Can't open application icon file."
      exit to MetaCard
    end if
    read from file AppIconFile at 23 until eof
    put it into AppIconData
    close file AppIconFile
    if the length of AppIconData is not the length of the mcappicon of me then
      answer "Icon is the wrong size (must be" && the length of the mcappicon of me + 22 && "bytes)"
      exit to MetaCard
    end if
  end if
  if DocIconFile is not empty then
    open file DocIconFile for binary read
    if the result is not empty then
      answer "Can't open document icon file."
      exit to MetaCard
    end if
    read from file DocIconFile at 23 until eof
    put it into DocIconData
    close file DocIconFile
    if the length of DocIconData is not the length of the mcappicon of me then
      answer "Icon is the wrong size (must be" && the length of the mcdocicon of me + 22 && "bytes)"
      exit to MetaCard
    end if
  end if
  open file EngineFile for binary read
  if the result is not empty then
    answer "Can't open engine."
    exit to MetaCard
  end if
  read from file EngineFile until eof
  close file EngineFile
  put the length of it into EngineSize
  put numToChar(0) after EngineSize
  put the fileType into saveftype
  set the fileType to field "Creator" & "APPL"
  open file DestFile for binary write
  if the result is not empty then
    answer "Can't open destination file" && DestFile
    set the fileType to saveftype
    exit to MetaCard
  end if
  if the platform is "MacOS" then
    put empty into url ("resfile:" & DestFile)
    get getresources(EngineFile)
    repeat for each line l in it
      if item 1 of l is "BNDL" and item 2 of l is 129
      then put copyresource(EngineFile, DestFile, "BNDL", 129, 128) into newvalue
      else put copyresource(EngineFile, DestFile, item 1 of l, item 2 of l, item 2 of l) into newvalue
    end repeat
    get getresources(SourceFile)
    repeat for each line l in it
      put copyresource(SourceFile, DestFile, item 1 of l, item 2 of l, item 2 of l) into newvalue
    end repeat
    get url ("resfile:" & DestFile)
    put offset("ZYZYZYZY", it) into eOffset -- finds the tag in engine
    if eOffset is not 0 then
      add 8 to eOffset
      if char eOffset of it is not "X" then
        answer "File" && EngineFile && "is already a standalone" with "Exit"
        set the fileType to saveftype
        exit to MetaCard
      end if
      put EngineSize into char eOffset to (eOffset + the length of EngineSize - 1) of it
      put false into not68K
      put it into url ("resfile:" & DestFile)
    end if
    get url ("binfile:" & EngineFile)
  end if
  set the fileType to saveftype
  put offset("ZYZYZYZY", it) into eOffset -- finds the tag in engine
  if eOffset is not 0 then
    add 8 to eOffset
    if char eOffset of it is not "X" then
      answer "File" && EngineFile && "is already a standalone" with "Exit"
      exit to MetaCard
    end if
    put EngineSize into char eOffset to (eOffset + the length of EngineSize - 1) of it
    if AppIconData is not empty then
      put offset(the mcappicon of me, it) into eOffset -- finds the old icon in engine
      if eOffset is 0 then
        answer "File" && EngineFile && "is not a MetaCard Win32 engine."
        exit to MetaCard
      end if
      put AppIconData into char eOffset to (eOffset + the length of AppIconData - 1) of it
    end if
    if DocIconData is not empty then
      put offset(the mcdocicon of me, it) into eOffset -- finds the old icon in engine
      if eOffset is 0 then
        answer "File" && EngineFile && "is not a MetaCard Win32 engine."
        exit to MetaCard
      end if
      put DocIconData into char eOffset to (eOffset + the length of DocIconData - 1) of it
    end if
    if the customKeys["resource_values"] of this card is not empty then
      put offset(uniEncode("040904b0"), it) into foffset
      if foffset is not 0 then
        repeat for each item i in the resource_names of card 1 of stack "Version Info"
          put offset(uniEncode(i), it, foffset) into toffset
          if toffset is 0 then
            answer "Can't find resource string" && i with "abort"
            exit to MetaCard
          end if
          add (length(i) + 1) * 2 + foffset to toffset
          if length(i) mod 2 is 1 then add 2 to toffset
          put uniEncode(the resource_values[i] of this card) into newvalue
          put newvalue into char toffset to toffset + length(newvalue) - 1 of it
        end repeat
      end if
    end if
  else
    if not68K then
      answer "File" && EngineFile && "is not a MetaCard engine."
      exit to MetaCard
    else get empty
  end if
  open file DestFile for binary write
  if the result is not empty then
    answer "Can't open destination file" && DestFile
    exit to MetaCard
  end if
  write it to file DestFile -- write engine with offset to standalone file
  if the result is not empty then
    answer "Error writing to file" && DestFile
    close file DestFile
    delete file DestFile
    exit to MetaCard
  end if
  open file SourceFile for binary read
  if the result is not empty then
    answer "Can't open stack file" && SourceFile
    close file DestFile
    delete file DestFile
    exit to MetaCard
  end if
  read from file SourceFile until eof
  write it to file DestFile
  close file SourceFile
  close file DestFile
  if the platform is not "Win32" and the platform is not "MacOS"
  then get shell("chmod a+x" && DestFile)
  close this stack
end mouseUp
         H    
mcappicon (       @                                                                                                     wwww           ww          {        p   p    p       p      w     ׻  	    }׻    w}׻   ~}׻    }׻    }׻    }׻     }׻     }׻      }׻     }׻       }{     }wp     }wwww  	   }p              }w        www                   ~p          wp           wwww                          ?                   ?             < ~  
mcdocicon (       @                                                                                                          ww    {        w    ׻    w׻    ׻    ׻    ׻    ׻    ׻    {    ww    }    ww    ~    ww                                                                                                                                	        Cancel Ep +on mouseUp
  close this stack
end mouseUp
          H          	        Help Ep on mouseUp
  help
end mouseUp
          I          	     
    	          t             Standalone file name: 
   Destination  i`                        
Select... EpCon mouseUp
  if the platform is "MacOS"
  then answer file "Select engine to build standalone from:" with filter "APPL"
  else answer file "Select engine to build standalone from:" with filter "*"
  if the last char of it is "/" then delete last char of it
  if it is not empty then put it into field "Engine"
end mouseUp
        T @          	        Set Windows Version Info... Ep /on mouseUp
  modal "Version Info"
end mouseUp
                    	        
Select... Ep son mouseUp
  ask file "Name of standalone:"
  if it is not empty then put it into field "Destination"
end mouseUp
         @          	        Creator   a           
  	 Creator  i`       D  <          MSTD 
  
 clabel 	           D            	Creator:    
Menu Builder           O|             U 
Helvetica   U 
helvetica       	Pon preOpenCard
  set the label of button "Stack Name" to the short name of the topstack
end preOpenCard

on closeCard
  put empty into field "menuItems"
  disable button "menuedit"
  disable button "menudelete"
  disable button "itemedit"
  disable button "itemdelete"
end closeCard
           O|                                      
    	@         `            Stack Name:    Stack Name ee       d    Stack 1037674896  MC stack menu        	     
   
menuNames  )pon mouseUp
  put the mItems[the selectedText of me] of me into field "menuItems"
  disable button "itemedit"
  disable button "itemdelete"
  if the hilitedLines of me is not empty then
    enable button "menuedit"
    enable button "menudelete"
  end if
end mouseUp
        D  p   mItems  Cu&t/X
&Copy/C
&Paste/V
undo       mItems    &Edit  Cu&t/X
&Copy/C
&Paste/V&File  &Open.../O
-
&Quit/Q&Help  &Help...
-
&About...     &File  &Edit  &Help       	`        E  n   Add... Ep5on mouseUp
  ask "Enter new menu:"
  if it is not empty then
    if line 1 of field "menuNames" is not empty
    then put return & it after field "menuNames"
    else put it into field "menuNames"
    set the hilitedLines of field "menuNames" to the number of lines in field "menuNames"
  end if
end mouseUp
        D @          	        menudelete epAon mouseUp
  local l
  put (item 1 of the hilitedLines of field "menuNames") into l
  delete line l of field "menuNames"
  -- set the hilited line to the line after the deleted line
  if l is 1
  then set the hilitedLInes of field "menuNames" to l
  else set the hilitedLInes of field "menuNames" to (l - 1)
end mouseUp
        | @  Delete          	     
   
menuItems  )p on mouseUp
  if the hilitedLines of me is not empty then
    enable button "itemedit"
    enable button "itemdelete"
  end if
end mouseUp
           x                  	`          v   Add... Epon mouseUp
  ask "New menu item:"
  if it is not empty then
    if line 1 of field "menuItems" is empty
    then put it into field "menuItems"
    else put return & it after field "menuItems"
    set the hilitedLines of field "menuItems" to the number of lines in field "menuItems"
    enable button "itemedit"
    enable button "itemdelete"
    set the mItems[the selectedText of field "menuNames"] of field "menuNames" to field "menuItems"
  end if
end mouseUp
         @          	        itemdelete epon mouseUp
  local l
  put (item 1 of the hilitedLines of field "menuItems") into l
  delete line l of field "menuItems"
  -- set hilited line to the line after the line been deleted
  if l is 1
  then set the hilitedLines of field "menuItems" to l
  else set the hilitedLines of field "menuItems" to (l - 1)
  set the mItems[the selectedText of field "menuNames"] of field "menuNames" to field "menuItems"
end mouseUp
        @  Delete          	     
    	@        , D            Menus: 
    	          d            Menu Items:    Build Epon mouseUp
  local sourceStack, l, bName, menuScript
  local userMenus, whichMnemonic, nextX
  
  -- create a menu group
  put field "menuNames" into userMenus
  put the label of button "Stack Name" into sourceStack
  set the defaultStack to sourceStack
  create group "menuGroup"
  set the traversalOn of group "menuGroup" to false
  set the backgroundBehavior of group "menuGroup" to true
  -- create a button to be the background of menus
  create button "menuButton" in group "menuGroup"
  set the lockLoc of button "menuButton" of group "menuGroup" to true
  set the opaque of button "menuButton" of group "menuGroup" to false
  set the showBorder of button "menuButton" of group "menuGroup" to true
  set the showName of button "menuButton" of group "menuGroup" to false
  set the traversalOn of button "menuButton" of group "menuGroup" to false
  set the autoHilite of button "menuButton" of group "menuGroup" to false
  set the height of button "menuButton" of group "menuGroup" to the formattedHeight of button "menuButton" of group "menuGroup" + 8
  set the width of button "menuButton" of group "menuGroup" to the width of this card - 8
  set the topLeft of button "menuButton" of group "menuGroup" to 4, 4
  put 8 into nextX
  repeat for each line l in userMenus  -- for each menu specified
    put offset("&", l) into whichMnemonic
    if whichMnemonic > 0 then
      delete char whichMnemonic of l
      -- create each menu
      create button l in group "menuGroup"
      set the mnemonic of button l of group "menuGroup" to whichMnemonic
    else create button l in group "menuGroup"
    set the lockLoc of button l of group "menuGroup" to true
    set the showBorder of button l of group "menuGroup" to false
    set the width of button l of group "menuGroup" to the formattedWidth of button l of group "menuGroup" + 8
    set the height of button l of group "menuGroup" to the formattedHeight of button l of group "menuGroup"
    set the topLeft of button l of group "menuGroup" to (nextX, 8)
    add (the formattedWidth of button l of group "menuGroup"  + 10) to nextX
    -- set some properties to make the button behave as a menu
    set the style of button l of group "menuGroup" to "menu"
    set the menuMode of button l of group "menuGroup" to "pulldown"
    set the opaque of button l of group "menuGroup" to true
    set the autoHilite of button l of group "menuGroup" to true
    set the hiliteBorder of button l of group "menuGroup" to true
    set the armBorder of button l of group "menuGroup" to true
    set the traversalOn of button l of group "menuGroup" to false
    set the showBorder of button l of group "menuGroup" to false
    
    -- create menu items
    put l into bName  -- save a copy of the menu name
    if whichMnemonic > 0 then  put "&" after char (whichMnemonic -1) of l  -- restore the menu name with the "&"
    put the mItems[l] of field "menuNames" of stack "Menu Builder" into button bName of group "menuGroup"
    
    -- create script for menu
    put "on menuPick which" & return into menuScript    -- menu script template
    put "  switch which" & return after menuScript
    repeat for each line s in the mItems[l] of field "menuNames" of stack "Menu Builder"
      if char 1 of s is not "-" then
        local toff
        put offset("&", s) into toff
        if toff is not 0 then delete char toff of s
        put offset("/", s) into toff
        if toff is not 0 then delete char toff to toff + 1 of s
        if char 1 of s is "(" then delete char 1 of s
        if char 1 of s is "!" then delete char 1 to 2 of s
        put "  case" && quote & s & quote & return after menuScript
        put "  break" & return after menuScript
      end if
    end repeat
    put "  end switch" & return after menuScript
    put "end menuPick" & return after menuScript
    set the script of button bName of group "menuGroup" to menuScript
    put empty into menuScript -- reset it to empty
  end repeat   -- for each menu specified
  
  --  Move the last button to far right edge if it is a "Help" button
  if bName is "Help"
  then set the Right of button bName of group "menuGroup" to the width of this card -  8
  
  -- Attatch a geometry management script to group "menuGroup"
  put "on resizeStack " & return into menuScript
  put "set the lockLocation of me to true" & return after menuScript
  put "set the width of me to the width of this card" & return after menuScript
  put "set the width of button" && quote & "menuButton" & quote && "of me to the width of me - 6" & return after menuScript
  put "set the left of button" && quote & "menuButton" & quote && "of me to 4"  & return after menuScript
  if bName is "Help" then
    put "set the right of button" && quote & bName & quote && "of me to the width of me - 6" & return after menuScript
  end if
  put "pass resizeStack" & return & "end resizeStack" after menuScript
  try
    set the script of group "menuGroup" to menuScript
  catch err
    answer "Can't set script of group (Starter Kit limits exceeded)"
  end try
  set the lockLoc of group "menuGroup" to true
  -- Remind user to save stack with new menu created
  set the menubar of this stack to "menuGroup"
  close stack "Menu Builder"
  answer "A menu was created in stack" && sourceStack & "." & return & "Please save the stack before closing it."
end mouseUp
        T L          	        Cancel Ep +on mouseUp
  close this stack
end mouseUp
        T L          	        Help Ep on mouseUp
  help
end mouseUp
        T L          	        mup Cp`on mouseUp
  local l, tmpLine
  put word 2 of the selectedLine of field "menuNames" into l
  if l > 1 then
    put line (l - 1) of field "menuNames" into tmpLine
    delete line (l  - 1) of field "menuNames"
    put return & tmpLine after line (l - 1) of field "menuNames"
    set the hilitedLines of field "menuNames" to (l - 1)
  end if
end mouseUp
                         E             	        mdown Cpon mouseUp
  local l, tmpLine
  put word 2 of the selectedLine of field "menuNames" into l
  if l is not empty and l < the number of lines in field "menuNames"  then
    put line l of field "menuNames" into tmpLine
    delete line l of field "menuNames"
    put return & tmpLine after line l of field "menuNames"
    set the hilitedLines of field "menuNames" to (l + 1)
  end if
end mouseUp
       $                  D             	        iup Cpon mouseUp
  local l, tmpLine
  put word 2 of the selectedLine of field "menuItems" into l
  if l > 1 then
    put line (l - 1) of field "menuItems" into tmpLine
    delete line (l  - 1) of field "menuItems"
    put return & tmpLine after line (l - 1) of field "menuItems"
    set the hilitedLines of field "menuItems" to (l - 1)
    set the mItems[the selectedText of field "menuNames"] of field "menuNames" to field "menuItems"
  end if
end mouseUp
       (                 E             	        idown Cpon mouseUp
  local l, tmpLine
  put word 2 of the selectedLine of field "menuItems" into l
  if l is not empty and l < the number of lines in field "menuItems"  then
    put line l of field "menuItems" into tmpLine
    delete line l of field "menuItems"
    put return & tmpLine after line l of field "menuItems"
    set the hilitedLines of field "menuItems" to (l + 1)
    set the mItems[the selectedText of field "menuNames"] of field "menuNames" to field "menuItems"
  end if
end mouseUp
       $(                 D             	        	menuedit eplon mouseUp
  local oldname, l
  put the selectedText of field "menuNames" into oldname
  ask "Edit menu:" with oldname
  if it is not empty then
    set the mItems[it] of field "menuNames" to the mItems[oldname] of field "menuNames"
    put (item 1 of the hilitedLines of field "menuNames") into l
    put it into line l of field "menuNames"
  end if
end mouseUp
        ` @  Edit...          	        	itemedit epXon mouseUp
  ask "Edit menu item" with the selectedText of field "menuItems"
  if it is not empty then
    local l
    put (item 1 of the hilitedLines of field "menuItems") into l
    put it into line l of field "menuItems"
  end if
  set the mItems[the selectedText of field "menuNames"] of field "menuNames" to field "menuItems"
end mouseUp
         @  Edit...          	        Script Find 
\local startchar, didfind, targeteditor
on doFind which
  put which into targeteditor
  set the height of me to 100
  hide group "replace group"
  set the title of me to "Find"
  palette me
end doFind

on doReplace which
  put which into targeteditor
  set the height of me to 142
  show group "replace group"
  set the title of me to "Replace"
  palette me
end doReplace

function findNext doselect
  modeless stack targetEditor
  local tterminators, ocs, toffset, notfound, ochar
  put false into didfind
  put quote & ",. <>:;$&[]\|()*^%#@!" & cr into tterminators
  set the caseSensitive to the hilite of button "Match case"
  put true into notfound
  repeat while notfound
    put offset(field "Find Text", field "Editor Field" of stack targeteditor, startchar) into toffset
    if toffset is 0 and startchar is not 0 then
      put offset(field "Find Text", field "Editor Field" of stack targeteditor) into toffset
      if toffset >= startchar then put 0 into toffset
      put 0 into startchar
    end if
    add toffset to startchar
    if toffset is 0 or startchar is ochar then return false
    if ochar is empty then put startchar into ochar
    if the hilite of button "Match whole words only" then
      if char (startchar - 1) of field "Editor Field" of stack targeteditor is in tterminators \
          and char (startchar + the length of field "Find Text") of field "Editor Field" of stack targeteditor \
          is in tterminators then
        put false into notfound
      end if
    else put false into notfound
  end repeat
  if doselect then
    lock messages
    select char startchar to (startchar + the length of field "Find Text" - 1)\
        of field "Editor Field" of stack targeteditor
    set the history[the scriptObject of card 1 of stack targeteditor] of stack "Script Editor" to the selectedChunk
    palette me
    unlock messages
  end if
  put true into didfind
  return true
end findNext

on replaceit
  local endchar
  if didfind then
    put startchar + the length of field "Find Text" - 1 into endchar
    put field "Replace Text" into char startchar to endchar of field "Editor Field" of stack targeteditor
    add the length of field "Replace Text" - 1 to startchar
  end if
end replaceit

on replaceall
  local firstone
  set the cursor to watch
  lock screen
  put 0 into startchar
  repeat while findNext(false)
    if firstone is empty
    then put startchar + the length of field "Replace Text" into firstone
    else if startchar < firstone then exit repeat
    replaceit
  end repeat
  unlock screen
end replaceall

on setstart which
  put false into didfind
  put which into startchar
end setstart
        i`U          Replace      U 
Helvetica   U 
helvetica    script find card   	P Kon returnInField
  send "mouseUp" to button "Find Next"
end returnInField
           U               
    	@          X            
Find String: 
   
Find Text  )`       h                
Find Next Ep >on mouseUp
  if not findNext(true)
  then beep 1
end mouseUp
          X          	        Match whole words only @E        D           	        Match case @E        , l          	        Done Ep +on mouseUp
  close this stack
end mouseUp
         4 X          	        replace group   i        TX <
    	@         h h            Replace With: 
   
Replace Text  )`       h h               Replace Ep Jon mouseUp
  replaceit
  if not findNext(true)
  then beep 1
end mouseUp
         X X          	        Replace All Ep %on mouseUp
  replaceall
end mouseUp
         t X          	        MetaCard Version          j              U New Century Schoolbook   U New Century Schoolbook   U New Century Schoolbook   U New Century Schoolbook   U 
helvetica       	P on openCard
  put the version into last word of line 1 of field 1
end openCard

on mouseUp
  modeless "Licensing MetaCard"
end mouseUp

on returnKey
  close this stack
end returnKey
                       Question Icon B         $ $ $              I            	      OK Lp +on mouseUp
  close this stack
end mouseUp
        @  D         	   
               (             MetaCard 2.5B2  &Copyright  2003 MetaCard Corporation  All Rights Reserved    UNIX video played through 
        XAnim 2.70.6.4 
         Copyright  1997  Mark Podlipec 
          Licensing Information... Dp Kon mouseUp
  close this stack
  modeless "Licensing MetaCard"
end mouseUp
                   	      Download Stack   local stime, cancelled

on mouseUp
  if the short name of the target is "Cancel"
  then put true into cancelled
end mouseUp

on updateme href
  local stat, nk
  if cancelled then
    unload url href
    close me
    exit to MetaCard
  end if
  put urlStatus(href) into stat
  if stat contains "error" or stat contains "not found" then
    close me
    answer "Error downloading URL" && href  & cr \
        & "Check network connection and proxy setup in Preferences."
    unload url href
    exit to MetaCard
  end if
  if stat contains "cached" then
    put "Done" into field "progress"
    set the thumbpos of sb 1 to the endValue of sb 1
    wait 500 milliseconds
    close me
    if word 1 of url href is "#!/bin/sh"
    then go url href
    else answer "URL" && href  && "is not a stack."
    unload url href
    exit to MetaCard
  end if
  if item 1 of stat is "loading" then
    put item 2 of stat div 1024 into nk
    put nk & "K/" & item 3 of stat div 1024 & "K  "\
        & nk * 10 div (the long seconds - stime) / 10 & "K/sec" into field "progress"
    set the endValue of sb 1 to item 3 of stat
    set the thumbpos of sb 1 to item 2 of stat
  end if
  send "updateme" && quote & href & quote to me in 500 milliseconds
end updateme

on preOpenStack
  local fwidth
  put the formattedWidth of field "url" into fwidth
  set the width of field "url" to fwidth
  set the width of sb 1 to fwidth - 16
  set the width of me to the right of field "url" + 8
end preOpenStack

on downloadNgo href
  put false into cancelled
  load href
  put "Loading url" && href  into field "url"
  put empty into field "progress"
  set the thumbPos of sb 1 to 0
  send "updateme" && quote & href & quote to me in 1 second
  put the long seconds into stime
  modal me
end downloadNgo
       q u                  	@          q u            Ia        ,Q          2655       
   url 	@        a            4Loading url http://www.metacard.com/stacks/tools.mc 
   	progress 	@       X L             Done    Cancel E`        P D          	        
Version Info          *pL:             U 
helvetica       	P on keyDown
  if the number of characters in the selectedField < the length_limit of the selectedField
  then pass keyDown
  else beep 1
end keyDown
          L:   resource_names  Comments,CompanyName,FileDescription,FileVersion,InternalName,LegalCopyright,LegalTrademarks,OriginalFilename,PrivateBuild,ProductName,ProductVersion,SpecialBuildEdit  Card Properties...                                                       	  
          
    	@         t            
Comments: 
   	Comments  i`      x      
length_limit  40               
    	@                     
CompanyName: 
   CompanyName  i`           
length_limit  40               
    	@        ( t            FileDescription: 
   FileDescription  i`      x (     
length_limit  40               
    	@        (             
FileVersion: 
   FileVersion  i`      (     
length_limit  10               
    	@        H t            InternalName: 
   
InternalName  i`      x H     
length_limit  10               
    	@        h t            LegalCopyright: 
   LegalCopyright  i`      x h     
length_limit  60               
    	@        h             LegalTrademarks: 
   LegalTrademarks  i`      h     
length_limit  60               
    	@        H             OriginalFilename: 
   OriginalFilename  i`      H     
length_limit  12               
    	@         t            PrivateBuild: 
   
PrivateBuild  i`      x      
length_limit  20               
    	@         t            
ProductName: 
   ProductName  i`      x      
length_limit  20               
     	@                     ProductVersion: 
   ProductVersion  i`           
length_limit  10               
    	@                     SpecialBuild: 
   
SpecialBuild  i`           
length_limit  20                  OK Ep0on mouseUp
  repeat for each item i in the resource_names of this card
    if field i is not empty then
      get format("%*s", -(the length_limit of field i), field i)
      set the resource_values[i] of card 1 of stack "Standalone Builder" to it
    end if
  end repeat
  close this stack
end mouseUp
        b P          	        Cancel Ep +on mouseUp
  close this stack
end mouseUp
       	 P          	        Help Ep on mouseUp
  help
end mouseUp
        P          	     
    	@                     Application icon file: 
   AppIcon  i`       d    
length_limit  256            	 
Select... Ep on mouseUp
  answer file "Select application icon:" with filter "*.ico"
  if it is not empty then put it into field "AppIcon"
end mouseUp
         @          	     
  
  	@                     Document icon file: 
   DocIcon  i`       d    
length_limit  256             
Select... Ep on mouseUp
  answer file "Select document icon:" with filter "*.ico"
  if it is not empty then put it into field "DocIcon"
end mouseUp
         @          	        Tools  Ron preOpenCard
  changeTool
end preOpenCard

on changeTool
  get word 1 of the tool
  if it is "graphic"
  then get the style of the templateGraphic
  set the hilitedButton of group "icons" to \
      itemOffset(it, "browse,pointer,button,field,scrollbar,image,player,line,polygon,curve,rectangle,oval,roundrect,regular")
end changeTool
       0 H    resizeable  false                U 
Helvetica       	P on openStack
  insert script of button "MenuButton" of stack "MetaCard Menu Bar" into front
  insert script of button "newobj" of stack "MetaCard Menu Bar" into back
  newTool
end openStack
            H      Icons   on mouseUp
  local ostacks, nstacks
  put the openStacks into ostacks
  if "My Icons" is not in ostacks and "My Patterns" is not in ostacks then
    put the number of lines in ostacks into nstacks
    repeat with i = 1 to nstacks
      if the mode of stack (line i of ostacks) is 5 then
        beep 1
        newtool
        exit to MetaCard
      end if
    end repeat
  end if
  if word 1 of the name of the target is "button" then
    if the short name of the target is in "pointer browse button field scrollbar image player"
    then choose (the short name of the target) tool
    else
      set the style of the templateGraphic to the short name of the target
      set the points of the templateGraphic to empty
      set the markerPoints of the templateGraphic to empty
      choose graphic tool
    end if
    send "changeTool" to stack "Paint Tools"
    send "changeTool" to stack "MetaCard Menu Bar"
  end if
end mouseUp

on newTool
end newTool
          P   browse Bt~on mouseUp which
  if which is 3 then
    set the customKeys of stack "Home" to empty
    set the mcvendor of stack "Home" to the "MetaCard Corporation"
    set the mcversion of stack "MetaCard Menu Bar" to the version
    set the mcversion of stack "Help Directory" to the version
    put empty into field "File Name" of card 2 of stack "Importer"
    put empty into field "Find" of stack "Find"
    put empty into field "Find Text" of stack "Script Find"
    put empty into field "Replace Text" of stack "Script Find"
    put empty into field "Name" of stack "Order Forms"
    put empty into field "Organization" of stack "Order Forms"
    put empty into field "Licenses" of card 1 of stack "Order Forms"
    put empty into field "Key" of card 1 of stack "Order Forms"
    toplevel "Script Editor"
    set the width of stack "Script Editor" to 600
    set the height of stack "Script Editor" to 450
    close stack "Script Editor"
    choose browse tool
    go "Properties"
    repeat with i = 1 to the number of cards in this stack
      go to card i
      click at 7,7
    end repeat
    close stack "Properties"
  else pass mouseUp
end mouseUp
          $ $ Browse tool               .            	     pointer Bd      $  $ $ Select controls               -            	      button Bd        ( $ $ Button tool               /            	      field Bd      $ ( $ $ Field tool               0            	      
scrollbar Bd        L $ $ Scrollbar tool               1            	      image Bd      $ L $ $ Image tool               _            	      player Bd        p $ $ Player tool                           	      line Bd      $ p $ $ Graphic tool (line)               N            	      polygon Bd         $ $ Graphic tool (polygon)               =            	      curve Bd      $  $ $ Graphic tool (curve)               :            	      
rectangle Bd         $ $ Graphic tool (rectangle)               <            	      oval Bd      $  $ $ Graphic tool (oval)               9            	      
roundrect Bd         $ $ Graphic tool (round rect)               >            	      regular Bd      $  $ $ Graphic tool (regular polygon)               ;            	      Resource Mover                            W 
Helvetica   U 
Helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica   U 
helvetica       	Pon openCard
  put the mainstacks into button "stackname"
  set the label of button "stackname" to the short name of the topstack
end openCard


function getSourceStack
local sourceStack
put the label of button "stackname" into sourceStack
if the mainstack of stack sourceStack is not sourceStack then
  answer "Stack" && quote & sourceStack & quote && "is not a main stack."
  return empty
else
  return sourceStack
end if
end getSourceStack
                         
    	@                     Main stack name:    
stackname e          Resource Mover    Home
MetaCard Menu Bar        	        Start Move Eplocal iconList

on checkStack
  local cCount, bCount
  put the number of cards into cCount
  repeat with c = 1 to cCount
    put the number of buttons of card c into bCount
    repeat with b = 1 to bCount
      if the icon of button b of card c is not 0
      then put the icon of button b of card c & return after iconList
      if the hiliteIcon of button b of card c is not 0
      then put the hiliteIcon of button b of card c & return after iconList
    end repeat
  end repeat
end checkStack

on copyStack bname, deststack
  if the hilite of button bname then
    if there is a stack bname of stack deststack then exit copyStack   # exit, if resource already exists
    set the visible of stack bname of stack "MetaCard Menu Bar" to false
    clone stack bname of stack "MetaCard Menu Bar"
    close stack ("copy of" && bname)
    set the visible of stack bname of stack "MetaCard Menu Bar" to true
    set the visible of stack ("copy of" && bname) to true
    set the mainstack of stack ("copy of"  && bname) to deststack
    set the name of stack ("copy of" && bname) to bname
  end if
end copyStack

on mouseUp
  local sourceStack, sCount, posoffset, newstuff
  send "mouseUp" to button "Delete Resources"
  put the motifIcons of stack "Answer Dialog" & cr \
      & the macintoshIcons of stack "Answer Dialog" & cr \
      & the windows95Icons of stack "Answer Dialog" & cr into iconList
  replace comma with return in iconList
  put empty into sourceStack
  set the cursor to watch
  lock screen
  lock messages
  
  put getSourceStack() into sourceStack
  if sourceStack is empty then exit to MetaCard
  
  # find icons used in script only
  if the hilite of button "Icons Set In Scripts:" then
    get field "iconlist"
    replace comma with space in it
    repeat for each word w in it
      put w & return after iconList
    end repeat
  end if
  
  # go through main and sub stacks to search for MetaCard icons
  if the hilite of button "MetaCard Icons" then
    set the defaultStack to sourceStack
    checkStack
    repeat for each line l in the substacks of stack sourceStack
      set the defaultStack to sourceStack
      set the defaultStack to l
      checkStack
    end repeat
  end if
  
  # Initialize variables
  local noDupIconList, mcIconList, myIconList, count
  repeat for each line l in iconList
    if l is not among the lines of noDupIconList
    then put l & return after noDupIconList
  end repeat
  
  # build a list of icon IDs in the MetaCard "Icons" stack
  put the number of cards in stack "Icons" into count
  repeat with i = 1 to count
    put the id of image 1 of card i  of stack "Icons" & return after mcIconList # one card per image
  end repeat
  
  # build a list of icon IDs in the  "My Icons" stack
  put the number of cards in stack "My Icons" into count
  repeat with i = 1 to count
    put the id of image 1 of card i  of stack "My Icons" & return after myIconList
  end repeat
  
  if noDupIconList is not empty then
    set the width of the templateStack to 128
    set the height of the templateStack to 128
    create stack "Moved Icons" in stack sourceStack
    set the defaultStack to "Moved Icons"
    local cardCount, which
    put the number of lines in noDupIconList into count
    put 1 into cardCount
    repeat with i = 1 to count
      put lineOffset(line i of noDupIconList, mcIconList) into which
      if which > 0 then
        copy image 1 of card which of stack "Icons"
        create card  -- create a new card in "Moved Icons" stack
        add 1 to cardCount
        paste
        set the id of image 1 of card cardCount of stack "Moved Icons" to line i of noDupIconList
      else
        put lineOffset(line i of noDupIconList, myIconList) into which
        if which > 0 then
          copy image 1 of card which of stack "My Icons"
          create card
          add 1 to cardCount
          paste
          set the id of image 1 of card cardCount to line i of noDupIconList
        end if
      end if
    end repeat
    delete card 1   #delete the first card of the stack which is empty
    close stack "Moved Icons" of stack sourceStack
  end if
  # now let's go back to the Resource Mover stack, and see if other resources need to be moved
  set the defaultStack to "Resource Mover"
  repeat for each item i in "Ask Dialog,Answer Dialog,Message Box,Execution Error,Cursors,File Selector,Page Setup,Printer Chooser,Navigator,Find,Brushes,libURL"
    copyStack i, sourceStack
  end repeat
  unlock screen
  unlock messages
  if the hilite of button "Execution Error" or the hilite of button "libURL" then
    answer "The" && quote & "Execution Error" & quote && "and libURL stacks must be" \
        & cr & "added to the message passing hierarchy to function" \
        & cr & "correctly.  Who should add the" && quote & "start using" & quote \
        & cr & "commands to the script of card 1 of this stack?" with "Do it for me" or "I'll do it myself"
    if it is "Do it for me" then
      if the hilite of button "Execution Error"
      then put "  start using" && quote & "Execution Error" & quote & cr into newstuff
      if the hilite of button "libURL"
      then put "  start using" && quote & "libURL" & quote &cr after newstuff
      get the script of card 1 of stack sourceStack
      put lineOffset("on preOpenStack", it) into posoffset
      if posoffset is 0 then
        put "on preOpenStack" & cr before newstuff
        put "end preOpenStack" & cr & cr after newstuff
      end if
      add 1 to posoffset
      put newstuff before line posoffset of it
      set the script of card 1 of stack sourceStack to it
    end if
  end if
  close this stack
  answer "All resources have been moved." & cr & "Please be sure to save stack"  && sourceStack
end mouseUp
          d          	        Cancel Ep +on mouseUp
  close this stack
end mouseUp
       
  G          	        Help Ep on mouseUp
  help
end mouseUp
       `  G          	        Resources to move           ,    Ask Dialog @E        @           	       Answer Dialog @E        \           	      	 Message Box @E        x           	       Execution Error @E                   	       Cursors @E        @           	       File Selector @E        \           	        Page Setup @E        x           	        Printer Chooser @E                   	        
Navigator @E      $ @           	        Find @E      $ \           	        MetaCard Icons @E      $ x           	      
 Brushes @e      $    Paint Brushes          	        libURL @e           URL access library (libURL)          	       Icons Set In Scripts: @E don mouseUp
  if the hilite of me then show field "iconlist" else hide field "iconlist"
end mouseUp
                    	     
   	iconlist  !`                       Delete Resources Epon mouseUp which
  set the cursor to watch
  local stkList, sourceStack
  
  #verify the stack who's resources are to be deleted
  put empty into sourceStack
  put getSourceStack() into sourceStack
  if sourceStack is empty then exit to MetaCard
  
  repeat for each item i in "Moved Icons,Ask Dialog,Answer Dialog,Message Box,Execution Error,Cursors, File Selector,Page Setup,Printer Chooser,Navigator,Find,Brushes,libURL"
    if there is a stack i of stack sourceStack
    then delete stack i of stack sourceStack
  end repeat
  if which is 1 then
    answer "All resources have been deleted." & cr & "Please be sure to save stack"  && the label of button "stackname"
    close this stack
  end if
end mouseUp
        }            	        
Reload Stack           reloadname  gtestreloadfile  /home/raney/mc/gtestx.mc                 U 
Helvetica       	PUon preOpenCard
  put "A stack with the name" && quote & the reloadname of this stack & quote\
      && "has already been loaded.  Prior to loading" && the reloadfile of this stack\
      & ", do you want to save the current stack or purge it?" into field "prompt"
end preOpenCard

on closeCard
  put empty into field "prompt"
end closeCard
                            B on mouseUp
  help
end mouseUp
          $ $              J            	   
   prompt  	        0 L R             Save Dp7on mouseUp
  close this stack
  get the reloadname of this stack
  if the filename of stack it is empty then
    send "menuPick" && quote & "Save as..." & quote\
        to button "File" of stack "MetaCard Menu Bar"
  else save stack it
  delete stack it
  go to stack the reloadfile of this stack
end mouseUp
        ! _ <         	      Purge Dp on mouseUp
  close this stack
  get the reloadname of this stack
  delete stack it
  go to stack the reloadfile of this stack
end mouseUp
        | _ <         	      Cancel Lp +on mouseUp
  close this stack
end mouseUp
         _ <         	      Help Dp on mouseUp
  help
end mouseUp
       1 _ <         	     f Character Chooser    w        Black   ffffff      white       	darkgray        pcmap 
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
palegreen
yellow2
yellow2
yellow2
yellow2
yellow2
































































































yellow2
yellow2
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
salmon
palegreen
palegreen
yellow2
yellow2
yellow2
yellow2
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
salmon
palegreen
palegreen
yellow2
yellow2
palegreen
lightblue3
 lightblue3


 lightblue3
lightblue3
palevioletred1
lightblue3
 lightblue3

lightblue3
 lightblue3
 lightblue3
palevioletred1
lightblue3
lightblue3
lightblue3

palevioletred1
palevioletred1
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
lightblue3
 lightblue3
palevioletred1
palevioletred1
palevioletred1
 lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
 lightblue3
lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
 lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
palevioletred1
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
lightblue3
 lightblue3
 lightblue3
palevioletred1
 lightblue3
 lightblue3
lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
palevioletred1
palevioletred1
lightblue3
unimap 
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
salmon
yellow2
yellow2
yellow2
yellow2
yellow2
































































































yellow2
yellow2
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
yellow2
yellow2
yellow2
yellow2
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
salmon
yellow2
yellow2
salmon
lightblue3
 lightblue3


 lightblue3
lightblue3
palevioletred1
lightblue3
 lightblue3

lightblue3
 lightblue3
 lightblue3
palevioletred1
lightblue3
lightblue3
lightblue3

palevioletred1
palevioletred1
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
lightblue3
 lightblue3
palevioletred1
palevioletred1
palevioletred1
 lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
 lightblue3
lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
 lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
palevioletred1
palevioletred1
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
lightblue3
 lightblue3
 lightblue3
palevioletred1
 lightblue3
 lightblue3
lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
 lightblue3
palevioletred1
palevioletred1
lightblue3
macmap 
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
palegreen
palegreen
palegreen
yellow2
yellow2
palegreen
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
yellow2
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
































































































lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
lightblue3
 lightblue3
lightblue3
palegreen
 lightblue3


 lightblue3
palegreen
 lightblue3
lightblue3
 lightblue3

palegreen
 lightblue3
 lightblue3
salmon
lightblue3
lightblue3
salmon

salmon
salmon
lightblue3
lightblue3
salmon
salmon
salmon
salmon
salmon
 lightblue3
 lightblue3
salmon
 lightblue3
 lightblue3
lightblue3
lightblue3
lightblue3
salmon
palegreen
salmon
salmon
 lightblue3
 lightblue3
palegreen
 lightblue3
lightblue3
lightblue3
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
palegreen
lightblue3
salmon
 lightblue3
palegreen
salmon
lightblue3
palegreen
palegreen
salmon
salmon
palegreen
lightblue3
palegreen
palegreen
palegreen
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
 lightblue3
lightblue3
 lightblue3
 lightblue3
salmon
 lightblue3
 lightblue3
lightblue3
 lightblue3
salmon
palegreen
palegreen
 lightblue3
salmon
salmon
salmon
 lightblue3
salmon
salmon
salmon                 U 
Helvetica   U Arial   U Charter   U 
Helvetica   U Clean   U Courier   U Monaco   U Arial Black   U Chicago   U none   U Athens   U new century schoolbook   U mincho   U fixed   U symbol  
 U 
Helvetica       	Plocal initted
on preOpenCard
  if initted then exit preOpenCard
  put true into initted
  switch the platform
  case "Win32"
    get the pcmap of this stack
    set label of btn "showmap" to "show mac characters"
    put "Mac only" into fld "hiddencharacterkey"
    break
  case "MacOS"
    get the macmap of this stack
    set label of btn "showmap" to "show windows characters"
    put "Windows only" into fld "hiddencharacterkey"
    break
  default
    get the unimap of this stack
    set label of btn "showmap" to "show mac characters"
    put "Mac only" into fld "hiddencharacterkey"
    break
  end switch
  local fnames
  put the fontnames & return & "none" into fnames
  sort fnames
  put fnames into button "fonts"
  set the label of button "fonts" to "none"
  set the textFont of group "tcharacters" to empty
  set the textFont of field "number" to empty
  repeat with a  = 128 to 255
    set backgroundcolor of btn (a - 127) of grp "tcharacters" to line (a + 1) of it
    set the name of button (a - 127) of grp "tcharacters" to numtochar(a)
  end repeat
  repeat with a = 1 to 128
    set backgroundcolor of btn a of grp "uppertcharacters" to line a of it
    set name of button a of grp "uppertcharacters" to numtochar(a - 1)
  end repeat
end preOpenCard

on mouseEnter
  if  word 1 of the target is "button"
  then put charToNum(the short name of the target) into field "number"
  else put empty into field "number"
end mouseEnter

on mouseUp
  local oldnum, newfont, c, f
  if word 1 of the target is "button" then
    if the label of button "fonts" is not "none"
    then put the label of button "fonts" into newfont
    if the selectedChunk is not empty then
      put word 2 of the selectedChunk into c
      put the long id of the selectedField into f
      put the short name of the target into the selectedChunk
      set the textFont of char c of f to newfont
    else
      put charToNum(the short name of the target) into oldnum
      put the short name of the target into field "number"
      set the textFont of line 1 of field "number" to newfont
      select the text of field "number"
      copy
      select empty
      put oldnum into field "number"
    end if
  end if
  set hscroll of fld "copytext" to (formattedwidth of fld "copytext")
end mouseUp
              Edit  Card Properties...  R      \                              _  b  c        e  f
   number  	`        -              fonts 	U on menuPick which
  if which is "none" then put empty into which
  set the textfont of group "tcharacters" to which
set the textfont of group "uppertcharacters" to which 
end menuPick
            symbol   alexandria
arial
arioso
avantgarde
bitstream charter
bookman
bookman l
century schoolbook
century schoolbook l
chancery l
charter
chevara
chevaraoutline
clean
clearlyu
clearlyu alternate glyphs
clearlyu arabic extra
clearlyu ligature
clearlyu pua
conga
console
courier
courier new
cursor
dingbats
dublin
fangsong ti
fixed
gatsby
gazelle
good city modern
goth
gothic
gothic l
helmet
helmetcondensed
helvetic
helvetica
kochi gothic
kochi mincho
ledfixed
lucida
lucidabright
lucidatypewriter
lucidux mono
lucidux sans
lucidux serif
meath
micro extend
mincho
moulin rouge
new century schoolbook
newspaper
nil
nimbus mono
nimbus mono l
nimbus roman
nimbus roman no9 l
nimbus sans
nimbus sans condensed
nimbus sans l
none
open look cursor
open look glyph
palatino
palladio
palladio l
prelude
song ti
standard symbols
standard symbols l
starbats
starmath
symbol
terminal
times
times new roman
timmons
utopia
verdana
zapf chancery
zapf dingbats  J      	     
    	       h  e            
Char number: 
    	 yon mouseUp
  repeat with i = 1 to the number of buttons
   set the textfont of button i to empty
end repeat
end mouseUp
          0            Font:    help Ep on mouseUp
  help
end mouseUp
       h P          	         e`       J            	        this  A
g    k  salmon    
P           	     
    	         !O j            Platform Specific    is  A
g      lightblue3    P           	     
    	         O             Moved in other platforms    the  A
g   x   palevioletred1   <P           	     
    	        SO C            	Win/Unix    secret  A
g  y  g  
palegreen   P           	     
    	        O C            Mac/Win    tcharacters i           "            S  Dg   yellow2     "       transversalon  falseEdit  Object Properties...
tranversalon  false
transveralon  falsefont  Clean         	   	       T  Dg   yellow2     "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       U  Dg  ዋkk salmon   @ "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       V  Dg  ዋkk salmon   ` "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       W  Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       X  Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       Y  Dg         black ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       Z  Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       [  Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       \  Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       ]  Dg  ዋkk salmon  @ "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       ^  Dg  ዋkk salmon  ` "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       _  Dg  ዋkk salmon   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       `  Dg   yellow2   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       a  Dg   yellow2   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       b  Dg   yellow2   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       c  Dg   yellow2     B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       d  Dg  ዋkk salmon     B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       e  Dg  ዋkk salmon   @ B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       f  Dg  ዋkk salmon   ` B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       g  Dg  ዋkk salmon    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       h  Dg  ዋkk salmon    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       i  Dg  ዋkk salmon    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       j  Dg  ዋkk salmon    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       k  Dg  ዋkk salmon    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       l  Dg  ዋkk salmon    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       m  Dg  ዋkk salmon  @ B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       n  Dg  ዋkk salmon  ` B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       o  Dg  ዋkk salmon   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       p  Dg   yellow2   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       q  Dg   yellow2   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       r  Dg  ዋkk salmon   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       s  Dg   lightblue3     b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       t  Dg    lightblue3     b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       u  Dg      @ b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       v  Dg      ` b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       w  Dg    lightblue3    b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       x  Dg   lightblue3    b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       y  Dg  xx palevioletred1    b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       z  Dg   lightblue3    b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       {  Dg    lightblue3    b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       |  Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       }  Dg   lightblue3  @ b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	       ~  Dg    lightblue3  ` b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3   b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1   b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1   @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1   `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3  @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3  `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3  @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3  `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   @       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3  @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3  `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3  @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3  `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3           transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3   @       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3   `       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3          transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3  @       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3  `       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg    lightblue3         transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1         transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg  xx palevioletred1         transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	         Dg   lightblue3         transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	   	     
   	Copytext  )`       '                         copy Ep Hon mouseup
select text of fld "copytext"
copy
select empty
end mouseup
       ' L          	     
    	         '             Characters to copy:    uppertcharacters a            "              Dg        "       transversalon  falseEdit  Object Properties...
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon     "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon   @ "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon   ` "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg         black ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      	 Dg  ዋkk salmon    "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      
 Dg  ዋkk salmon  @ "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon  ` "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      
 Dg  ዋkk salmon   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   "       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2     B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2     B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   @ B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   ` B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2    B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg  ዋkk salmon  @ B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2  ` B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       Dg   yellow2   B       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	        Dg        b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      ! Dg        b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      " Dg      @ b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      # Dg      ` b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      $ Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      % Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      & Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      ' Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      ( Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      ) Dg       b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      * Dg     @ b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      + Dg     ` b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      , Dg      b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       - Dg      b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      . Dg      b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      / Dg      b       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      0 Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      1 Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      2 Dg      @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      3 Dg      `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      4 Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      5 Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     	 6 Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     
 7 Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      8 Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      9 Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     
 : Dg     @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      ; Dg     `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      < Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      = Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      > Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      ? Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      @ Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      A Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      B Dg      @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      C Dg      `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      D Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      E Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      F Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      G Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      H Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      I Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      J Dg     @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      K Dg     `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	      L Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	       M Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     ! N Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     " O Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     # P Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     $ Q Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     % R Dg      @       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     & S Dg      `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     ' T Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     ( U Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     ) V Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     * W Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     + X Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     , Y Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     - Z Dg     @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     . [ Dg     `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     / \ Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     0 ] Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     1 ^ Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     2 _ Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     3 ` Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     4 a Dg               transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     5 b Dg      @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     6 c Dg      `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     7 d Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     8 e Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     9 f Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     : g Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     ; h Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     < i Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     = j Dg     @        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     > k Dg     `        transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     ? l Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     @ m Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     A n Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     B o Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     C p Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     D q Dg              transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     E r Dg      @       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     F s Dg      `       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     G t Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     H u Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     I v Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     J w Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     K x Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     L y Dg             transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     M z Dg     @       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     N { Dg     `       transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     O | Dg            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     P } Dg            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     Q ~ Dg            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     R  Dg            transversalon  false
tranversalon  false
transveralon  falsefont  Clean         	     \ 
thewinmap  @        $ @  'GIF89a@      !    ,    @  ڋ޼H扦ʶL
ĢL*̦	JԪ۬3]N{IeO'EXD7w藡x@Ha	9y9$c*HYj׺aQK;j*I+0K	:,r[Qf˓g͐=-.UR쌫>V}zYIJk+/	zQN;|Y1[&0MR=D+OH41d%#õ|	32kڼ3Ν<{	4СD=4ҥL:}
5ԩTZ5֭\z
6رd˚=6ڵlۺ}7ܲ4ڽ7/Gl[%Au?11[ՙyƾ%SYQbSmg.Xث&-tfbDI=x\䓓&Y9U-={ڻO=ś?>ۻ?ۿ?  ;        _ Showmap epon mousedown
  get the platform
  if visible of grp "uppertcharacters" is true then
    if it is "macos" and visible of grp "uppertcharacters" is true then show image "thewinmap"
    else show image "themacmap"
  else if it is not "macos" then show image "macmap2"
end mousedown

on mouserelease
  get the platform
  if visible of group "uppertcharacters" is true then
    if it is "macos" then hide image "thewinmap"
    else hide image "themacmap"
  else if it is not "macos" then hide image "macmap2"
end mouserelease
on mouseUP
  get the platform
  if visible of group "uppertcharacters" is true then
    if it is "macos" then hide image "thewinmap"
    else hide image "themacmap"
  else if it is not "macos" then hide image "macmap2"
end mouseUP
        h   show mac characters          	       b message A
g      Yellow2    
i           	     
  c hiddencharacterkey 	         !h s            	Mac only   e macmap2  @         "  B  GIF89a B      !    ,     B  ڋ޼H扦ʶL
)L&%J*j-2U2\NC5{`ewXzwg66H7(('hyi0IgYjzZ	)ZI404j{k ښ$;Ky{l	k4,l
w-TL6}>]>O/Ы~OO@<_
qSc+Hkat&1ő$O`LocCu?Td`ə4CDk-7СX1$P 7$
5JcܔDt˗c
V9<Jװlե1)Vl7o"@?
r+><dڻ;ơmǔ+k9)7{:ѤK>:լ[~
;lFgv]Թw&\r*q]$_Hϣ[1Y{Q2tWzE?B[h|%_pE&#(h` v5H{YV! yvHda$|܈+E~/7ciUy2c"]	&(cNJ"@>IKzVZ~pe[~ك`Ifffjɦ  ;        f 
themacmap  @         "  @  mGIF89a @         !    ,     @  ڋ޼H扦ʶL
ĢL*̦	JԪjnH d	|l5-62ӇG&r8IY)	)`	fPz:I:zJڊ+gk@;|k| V\<Mmq-Э]. :~$ʹ.??I_Nz0 ~"	<pAM:|1ĉ+Z1ƍ;z2ȑ$K<2ʕ,[|	3̙4kڼ3i:{Nspw63z,{%e S+W
HbEpvPT٦5\5]i廷[1z]E1aÅ$;iq9Y.G_'{#Wg}3pgh0j`r9E9/~eٳv>_䁗;`ϡm/a&
f8jX١Y~汧]aG݁uv[s1!PUA!nQhK(>St
`|,BXiL݆9b"ۆm@"=Q"1'^8:re'dF%Xw&2QR昦d61~Xu<%i&b10]R觗rhI䏕٦h~
H梆~h͍駃I'f荦ا	9-&z!ڹcy
i:Psd6β'LmN+:uwl	v+2c*ԺJ)x-]+0ۮ`p
ښ
)}Uq
0k}+[XPR9Kvoz:bo\qZn:rM3Q|4
5C t\;k/bRH}i'pJ5M}ۭd:U8T||'v>]Ec>8xcMxww^{MޏVOߎ{{|O|  ;        R    i |on mouseup
  if hilitedbutton of me is 1
  then show grp "uppertcharacters"
  else hide grp "uppertcharacters"
end mouseup
          &  S ASCII @D         F          	   	       T ISO @D       K  7          	  	         Ag    @               	        Print Field  constant po = 36
local pagenumber #holds pagenumber between handlers
on PrintField HeaderText,BodyText,FooterText,SourceFieldID
  local TActualPageWidth #width of page subtracting right and left print margins
  local TPrintMargins #margins stored in array for script simplification
  local TPageWidth,TPageHeight #height and width of the page
  local TScrolling,TPageLine,TScrollList #scroll values for text height calculations
  lock messages
  
  --General Initialization
  if the optionKey is down
  then open printing with dialog
  else open printing
  put item 1 of the printmargins into TPrintMargins["left"]
  put item 2 of the printmargins into TPrintMargins["top"]
  put item 3 of the printmargins into TPrintMargins["right"]
  put item 4 of the printmargins into TPrintMargins["bottom"]
  put item 1 of the printpapersize into TPageWidth
  put item 2 of the printpapersize into TPageHeight
  put 0 into TScrolling
  put 0 into TPageLine
  put 1 into pagenumber
  put TPageWidth -TPrintMargins["right"]-TPrintMargins["left"] into TActualPageWidth
  # prepare template for invisible stacks the width of the page.
  set the backgroundcolor of the templatestack to "white"
  set the visible of the templatestack to false
  set the width of  the templatestack to TActualPageWidth
  set the formatForPrinting of the templatestack to true
  # prepare template for fields in these stacks
  set the width of the templatefield to TActualPageWidth
  # the following three properties are set so that text height calculations are correct.
  set the borderwidth of the templatefield to 0
  set the margins of the templatefield to 6
  set the showborder of the templatefield to true
  set the opaque of the templatefield to false
  set the fixedlineheight of the templatefield to false
  set the lockloc of the templatefield to true
  set the tabstops of the templatefield to the tabstops of SourceFieldID
  # Header and Footer initialization
  if headertext is not empty then
    create stack "PFHEADER"
    set the defaultstack to "PFHEADER"
    PFSetFont SourceFieldID
    get PFCreateHeaderandFooter(headertext)
    # if size of header or footer is greater then current margins will allow, then
    # increase top or bottom margins.
    if it > TPrintMargins["top"] then put it into TPrintMargins["top"]
  end if
  if footertext is not empty then
    create stack "PFFOOTER"
    set the defaultstack to "PFFOOTER"
    PFSetFont SourceFieldID
    get PFCreateHeaderandFooter(footertext)
    if it>TPrintMargins["bottom"] then put it into TPrintMargins["bottom"]
  end if
  
  --Body initialization
  set height of the templatestack to TPageHeight - TPrintMargins["bottom"] - TPrintMargins["top"]
  create stack "PFBODY"
  set the defaultstack to "PFBODY"
  PFSetFont SourceFieldID
  create field
  set the rect of field 1 to rect of this card
  PFSetText bodytext
  put the pageheights of field 1 into TScrollList
  
  --Printing Cycle
  # headers and footers are split up into three fields by tab items
  set the itemdelimiter to tab
  repeat forever
    If headertext is not empty then
      set the defaultstack to "PFHEADER"
      PFSetText headertext
      put item 3 of field 1 into field 3
      put item 2 of field 1 into field 2
      put item 1 of field 1 into field 1
      print this card into TPrintMargins["left"],po,TPageWidth-TPrintMargins["right"],po+the height of stack "PFHEADER"
    end if
    If footertext is not empty then
      set the defaultstack to "PFFOOTER"
      PFSetText footertext
      put item 3 of field 1 into field 3
      put item 2 of field 1 into field 2
      put item 1 of field 1 into field 1
      print this card into TPrintMargins["left"],TPageHeight-po-height of stack "PFFOOTER",TPageWidth-TPrintMargins["right"],TpageHeight-po
    end if
    add 1 to TPageLine
    add 1 to pagenumber
    set the defaultstack to "PFBODY"
    set the height of fld 1 to line tpageline of TScrollList
    set the scroll of fld 1 to TScrolling
    add line TPageLine of TScrollList to TScrolling
    print this card into TPrintMargins["left"],TPrintMargins["top"],TPageWidth-TPrintMargins["right"],TPageHeight - TPrintMargins["bottom"]
    if TPageLine is the number of lines of TScrollList then exit repeat
    print break
  end repeat
  -----------------------------------------------Clean up
  close printing
  if headertext is not empty then delete stack "PFHEADER"
  if footertext is not empty then delete stack "PFFOOTER"
  delete stack "PFBODY"
  reset the templatestack
  reset the templatefield
end PrintField

on PFSetText thetext
  local ExpressionStart, ExpressionEnd
  if "<p>" is in thetext or matchChunk(thetext, "<(.+>.+</.+)>") is true then set the htmltext of field 1 to thetext
  else put thetext into field 1
  repeat until matchChunk(field 1, "<%(.[^<]*)%>", ExpressionStart, ExpressionEnd) is false
    put value(char ExpressionStart to ExpressionEnd of field 1) into char ExpressionStart-2 to ExpressionEnd+2 of field 1
  end repeat
end PFSetText

# Need to set the font after the stack is created to prevent inheritance of
# non-formatForPrinting fonts from Home stack
on PFSetFont SourceFieldID
  if SourceFieldID is not empty \
      and (the effective textFont of SourceFieldID is not "Helvetica" or the effective textSize of SourceFieldID is not 14) then
    set the textFont of this stack to the effective textFont of SourceFieldID
    set the textSize of this stack to the effective textSize of SourceFieldID
    set the textStyle of this stack to the effective textStyle of SourceFieldID
  else set the textSize of this stack to 12
end PFSetFont

function PFCreateHeaderandFooter thetext
  create field
  PFSetText thetext
  set the height of this stack to the formattedheight of field 1
  create field
  create field
  get rect of this card
  set the rect of field 1 to it
  set the rect of field 2 to it
  set the rect of field 3 to it
  set the textalign of field 1 to left
  set the textalign of field 2 to "center"
  set the textalign of field 3 to right
  return height of this stack+po
end PFCreateHeaderandFooter
  u        Black ffffff   white    	darkgray    i             U 
Helvetica   W 
Helvetica   W 
Helvetica  @W 
Helvetica   U 
Helvetica   W 
Helvetica   U 
Helvetica  W 
Helvetica  W 
Helvetica   W 
Helvetica   W 
Helvetica   U 
Helvetica   U Marlett  U 
Helvetica   U 
Helvetica   U 
Helvetica  
 U 
Helvetica   W Times New Roman  U 
Helvetica   U Future   U 
Helvetica   U Courier   U 
helvetica       	Pon preopenstack
  set the label of button "Stack Name" to the short name of the topStack
  put returnfields(selectedText of btn "the fields") into field "field names"
end preopenstack

function returnfields fieldtype
  local thefields, olddefault
  put the short name of the defaultStack into olddefault
  set defaultStack to label of btn "Stack Name"
  if fieldtype is "card" then
    repeat with i = 1 to the number of card fields
      put short name of cd fld i into line i of thefields
    end repeat
  else
    repeat with i =1 to the number of background fields
      put short name of bg fld i into line i of thefields
    end repeat
  end if
  set the defaultstack to olddefault
  return thefields
end returnfields
           i                          
   Footer 9h          LP 7            
                   `        5
   Header 9h          L P 7                       `         5   New Button Cpon mouseUp
  get last word of the selectedfield
  if it is 2 or it is 3 then put "<%the time%>" after the selectedchunk
  else
    put "<%the time%>" after field "header"
    enable field "header"
    hilite btn "header"
    focus field "header"
  end if
end mouseUp
        0 ( Insert time                            	        New Button Cpon mouseUp
  get last word of the selectedfield
  if it is 2 or it is 3 then put "<%the date%>" after the selectedchunk
  else
    put "<%the date%>" after field "header"
    enable field "header"
    hilite btn "header"
    focus field "header"
  end if
end mouseUp
        0 ) Insert date                            	        New Button Cpon mouseUp
  get last word of the selectedfield
  if it is 2 or it is 3 then put "<%pagenumber%>" after the selectedchunk
  else
    put "<%pagenumber%>" after field "header"
    enable field "header"
    hilite btn "header"
    focus field "header"
  end if
end mouseUp
       0 ( Insert page number               W             	        Header @E on mouseUp
  if the hilite of me is "true" then
    enable field "header"
    focus on field 2
  else disable field "header"
end mouseUp
          D          	        Footer @E on mouseUp
  if the hilite of me is "true" then 
enable field "footer"
focus on field 3
  else disable field "footer"
end mouseUp
         D          	     
   field names  )`        D p           field names  Header  Footer        	`       E  n   the fields 	u hon menupick
  put returnfields(selectedtext of btn "the fields") into field "field names"
end menupick
         (    Card
Background
        	        stack name e)u fon mouseUp
  put returnfields(selectedtext of btn "the fields") into field "field names"
end mouseUp
        X t  Print Field  MC Stack Menu        	        Print Epon mouseUp
  local htext,btext,ftext
  if selectedtext of fld "field names" is empty then
    answer "Please choose a field to print"
    exit mouseup
  end if
  get the hilitedLines of field "field names"
  if the selectedText of btn "the fields" is "Card"
  then get the long id of card field it of stack (the label of btn "stack name")
  else get the long id of background field it of stack (the label of btn "stack name")
  put the htmltext of it into btext
  if enabled of field "header" is true then put field "header" into htext
  if enabled of field "footer" is true then put field "footer" into ftext
  printField htext,btext,ftext,it
end mouseUp
        XH h          	        Help Ep on mouseUp
  help
end mouseUp
       H h          	     
    	          X            
Print Stack:   c libURL    w        Black      white       R5%Q   	cVersion  1.0.10cDefaultHeader  'METHOD --- HTTP/1.1
Host: 
User-Agent: customHTTPHeaders    ##libUrl v1.0.10
---------------------------------------------------------------------
##shared locals
local lvCount,lvBlockingUrl,lvBlockBypass, lvLogField, lvTickle
local lvJumpOut ##used by libUrlResetAll to make sure "wait for messages" loops exit cleanly

local laLoadReq,laLoadedUrls,laStatus,laUrl,laLength,laData
local laAction,laUrlLoadStatus,laUrlErrorStatus,laLoadQ, laLoadingUrls
local laUser,laPasswd,laAuth,laBytes,laLongFileName,laHost
local laMessg,laPostData,laTemp
local laCancelled,lvStatusCallback
local laFile,laReadBytes,laWriteBytes
local laConnectHost, laConnectID, laSocketUser

local lvSocketToken, lvSocketOpenStart, lvSocketOpenMessageID ##for socket opening

---------------------------------------------------------------------
##http locals
local laConn,laCode,laChunk,laRhHeader, laHaveHeader, laNeedChunk
local laStatusCode, laStatusMessage
local laLineNum,laTmpData
local laHttpDataDone
local laCurrentHttpHeaders
-----------------------------------------------------------------------
##ftp locals
local lvFtpMode, lvFtpStopTime, lvDataPortCount, lvFtpListCommand
local laFtpDataDone
local laControlXDataMap ##control sockets keyed by data sockets
local laHome,lvNeedDir
local laControlXLocalMap,laTransPasvIP,laTransActvIP,laMode
local laStopUnit, laStopSec
local laFTPCommandStatus
local lvFtpCommandSocket ##socket used by libUrlFtpCommand
local laUrlByFile ##used by libUrlUploadFile to track which files go to which url

#######Engine Calls#############################################
#######  load url  #############################################
------------------------------------------------
on loadUrl x,y
  put false into lvJumpOut
  put ulStripUrl(x) into newUrl
  if lvCount is empty then
    put "6923" into lvCount
  end if
  switch
  case newUrl is among the lines of  the keys of laLoadingUrls
    ##don't allow loads if the same url is waiting to load
    return "error  URL is currently loading" ##with empty
    break
  case newUrl is not among the lines of  the keys of laLoadedUrls OR laUrlLoadStatus[newUrl] is not "cached"
    put the long id of the target &","& item 2 of the params into laMessg[newUrl]
    put true into laLoadReq[newUrl]
    put 1 into laLoadingUrls[newUrl] #for tracking
    put "getData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    put empty into laUrlLoadStatus[newUrl]
    put empty into laLoadedUrls[newUrl]
    
    ulGetFormat newUrl,lvCount
    if laUrlLoadStatus[newUrl] is "error" and not laCancelled[newurl] then
      ulSendMessage newUrl ##send message now only if error occurred befoe block point
      return "error"
      ----------------------
    else if laCancelled[newUrl] then
      ##user cancelled after starting but before blocking point
      delete local laLoadedUrls[newUrl]
      delete local laUrlLoadStatus[newUrl]
      delete local laUrlErrorStatus[newUrl]
      delete local laStatus[newUrl]
      delete local laCancelled[newUrl]
      delete local laCurrentHttpHeaders[newUrl]
    else
      return empty
    end if
    -----------------------
    break
  case newUrl is among the lines of  the keys of laLoadedUrls and laUrlLoadStatus[newUrl] is "cached" #url is in cache
    
    put the long id of the target &","& item 2 of the params into laMessg[newUrl]
    ulSendMessage newUrl ##send message
    return empty
  end switch
end loadUrl

#############unload url############

on unloadUrl pUrl
  put ulStripUrl(pUrl) into pUrl
  ##need to check if it is loading or in loadQ
  if pUrl is among the lines of keys(laLoadingUrls) then
    delete local laLoadingUrls[pUrl]
    ulCancelRequest pUrl ##stop any current downloads
    delete local laData[pUrl] ##in case download hasn't started
    return empty
  else if pUrl is among the lines of keys(laUrlLoadStatus) then
    delete local laLoadedUrls[pUrl]
    delete local laUrlLoadStatus[pUrl]
    delete local laUrlErrorStatus[pUrl]
    delete local laStatus[pUrl]
    return empty
  else ##not loaded
    return "can't find url"
  end if
end unloadUrl

############# get url ############

on getUrl x
  put false into lvJumpOut
  put ulStripUrl(x) into newUrl
  if newUrl is among the lines of the keys of laLoadedUrls and laUrlLoadStatus[newUrl] is "cached" then
    if "2.4.1" is in the version then
      return  empty  with  laLoadedUrls[newUrl]
    else
      return  empty  with cachedUrl laLoadedUrls[newUrl]
    end if
  end if
  if newUrl is among the lines of keys(laLoadingUrls) then
    return "error  URL is currently loading" with empty
  end if
  if lvBlockingUrl is empty or lvBlockBypass is true then
    put newUrl into lvBlockingUrl
    if lvCount is empty then
      put "6923" into lvCount
    end if
    
    put empty into laUrlErrorStatus[newUrl]
    put "getData" into laAction[newUrl]
    put empty into laData[newUrl]
    ulGetFormat newUrl,lvCount # convert url to components
    
    ##final clean up here
    delete local laStatus[newUrl]
    put laUrlErrorStatus[newUrl] into tRetResult
    delete local  laUrlErrorStatus[newUrl]
    if "2.4.1" is in the version then
      ##for mc 2.4.1 engine only
      put laData[newUrl] into tRetData ##swap data before deleting laData
      delete local laData[newUrl]
      put empty into lvBlockingUrl ##clear
      return tRetResult  with tRetData
    else
      put empty into lvBlockingUrl ##clear
      return tRetResult with url laData[newUrl]
    end if
  else ##blocked by previous request
    return "error Previous request not completed" with empty
  end if
end getUrl

############### post Url ###################

on postUrl y,x
  put false into lvJumpOut
  put ulStripUrl(x) into newUrl
  if newUrl is among the lines of keys(laLoadingUrls) then
    return "error  URL is currently loading" with empty
  end if
  if lvBlockingUrl is empty  or lvBlockBypass is true then
    put newUrl into lvBlockingUrl
    if lvCount is empty then
      put "6923" into lvCount
    end if
    put y into laPostData[newUrl]
    put "postData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    put empty into laData[newUrl]
    ulGetFormat newUrl,lvCount # convert url to components
    
    ----------------------------------
    ##final clean up here
    delete local laStatus[newUrl]
    put laUrlErrorStatus[newUrl] into tRetResult
    delete local  laUrlErrorStatus[newUrl]
    if "2.4.1" is in the version then
      ##for mc 2.4.1 engine only
      put laData[newUrl] into tRetData
      delete local laData[newUrl]
      put empty into lvBlockingUrl ##clear
      return tRetResult  with tRetData
    else
      put empty into lvBlockingUrl ##clear
      return tRetResult with url laData[newUrl]
    end if
    -----------------------------------
  else ##blocked by previous request
    put "error Previous request not completed" into tRetResult
    return tRetResult with empty
  end if
end postUrl

############### put x into url ################

on putUrl y,x
  put false into lvJumpOut
  put ulStripUrl(x) into newUrl
  if newUrl is among the lines of keys(laLoadingUrls) then
    return "error  URL is currently loading" with empty
  end if
  if lvBlockingUrl is empty  or lvBlockBypass is true then
    put newUrl into lvBlockingUrl
    if lvCount is empty then
      put "6923" into lvCount
    end if
    put y into laPostData[newUrl]
    put "putData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    put empty into laData[newUrl]
    ulGetFormat newUrl,lvCount # convert url to components
    ----------------------------------
    ##final clean up here
    delete local laStatus[newUrl]
    put laUrlErrorStatus[newUrl] into tRetResult
    delete local  laUrlErrorStatus[newUrl]
    if "2.4.1" is in the version then
      ##for mc 2.4.1 engine only
      put laData[newUrl] into tRetData
      delete local laData[newUrl]
      put empty into lvBlockingUrl ##clear
      return tRetResult  with tRetData
    else
      put empty into lvBlockingUrl ##clear
      return tRetResult with url laData[newUrl]
    end if
    -----------------------------------
    
  else ##blocked by previous request
    put "error Previous request not completed" into tRetResult
    return tRetResult with empty
  end if
end putUrl

###############delete url########################

on deleteUrl x
  put false into lvJumpOut
  put ulStripUrl(x) into newUrl
  if newUrl is among the lines of keys(laLoadingUrls) then
    return "error  URL is currently loading" with empty
  end if
  if lvBlockingUrl is empty  or lvBlockBypass is true then
    put newUrl into lvBlockingUrl
    if lvCount is empty then
      put "6923" into lvCount
    end if
    
    put "deleteData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    ulGetFormat newUrl,lvCount # convert url to components
    
    ----------------------------------
    ##final clean up here
    delete local laStatus[newUrl]
    put laUrlErrorStatus[newUrl] into tRetResult
    delete local  laUrlErrorStatus[newUrl]
    if "2.4.1" is in the version then
      ##for mc 2.4.1 engine only
      put laData[newUrl] into tRetData
      delete local laData[newUrl]
      put empty into lvBlockingUrl ##clear
      return tRetResult  with tRetData
    else
      put empty into lvBlockingUrl ##clear
      return tRetResult with url laData[newUrl]
    end if
    -----------------------------------
    
  else ##blocked by previous request
    put "error Previous request not completed" into tRetResult
    return tRetResult with empty
  end if
end deleteUrl

######## cachedUrls ################################################
on getCachedUrls
  #ensure url has "cached" status
  #there may be urls with data but with "error" status
  #for example, with a 404 error, the "courtesy page" may appear in the data
  put keys(laUrlLoadStatus) into tLoadedKeys
  repeat for each line tKey in tLoadedKeys
    if laUrlLoadStatus[tKey] is "cached" then
      put tKey & cr after tRes
    end if
  end repeat
  if char -1 of tRes is cr then delete char -1 of tRes
  return tRes
end getCachedUrls

######## UrlStatus ###################################################
on getUrlStatus x #x is url
  put ulStripUrl(x) into x
  return laUrlLoadStatus[x]
end getUrlStatus

####################breaks down the url into components####################
on ulGetFormat pUrl,pCount
  local tPre,tUser,tPass,tHost,tPort,tFileName
  
  switch
    ##http with authorization name and password ( port specified)
  case  matchText (pUrl, "^(http)://(.+):(.+)@(.[^/]+)(:.[^/]+)(/.*)",tPre,tUser,tPass,tHost,tPort,tFileName)  is true ##with auth and special port
    break
    
    ##http with authorization name and password (no port specified)
  case  matchText (pUrl, "^(http)://(.+):(.+)@(.[^/]+)(/.*)",tPre,tUser,tPass,tHost,tFileName)  is true
    break
    
    ##http ( port specified)
  case  matchText (pUrl, "^(http)://(.[^/]+)(:.[^/]+)(/.*)",tPre,tHost,tPort,tFileName) is true
    break
    
    ##http ( port specified) no filename
  case  matchText (pUrl, "^(http)://(.[^/]+)(:.[^/]+)()",tPre,tHost,tPort,tFileName) is true
    break
    
    ##http ( no port specified)
  case  matchText (pUrl, "^(http)://(.[^/]+)(/.*)",tPre,tHost,tFileName) is true
    break
    
    ##http ( no port specified) no file
  case  matchText (pUrl, "^(http)://(.[^/]+)()",tPre,tHost,tFileName) is true #+#
    break
    
    ##ftp  with authorization name and password (port specified)
  case  matchText (pUrl, "^(ftp)://(.+):(.+)@(.[^/]+)(:.[^/]+)(/.*)",tPre,tUser,tPass,tHost,tPort,tFileName)  is true
    break
    
    ##ftp  with authorization name and password (no port specified)
  case  matchText (pUrl, "^(ftp)://(.+):(.+)@(.[^/]+)(/.*)",tPre,tUser,tPass,tHost,tFileName)  is true
    break
    
    ##ftp without name and password (port specified)
  case matchText (pUrl,"^(ftp)://(.[^/]+)(:.[^/]+)(/.*)",tPre, tHost,tPort,tFileName) is true
    break
    
    ##ftp without name and password (no port specified)
  case matchText (pUrl,"^(ftp)://(.[^/]+)(/.*)",tPre, tHost,tFileName) is true
    break
    
  default
    put "invalid URL: " & quote & pUrl & quote into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "error" into laUrlLoadStatus[pUrl]
    exit "ulGetFormat"
  end switch
  
  ##set connection IP
  switch tPre
  case "http"
    if the httpProxy <> empty then
      put the httpproxy into tIPAddress
      replace "http://" with "" in tIPAddress ##not sure if this is possible but just in case
      if tPort <> empty then
        put tPort into tUrlPort ##save this for setting laFilename below
      else
        put ":80" into tUrlPort
      end if
      #get the proxy port
      put the itemdel into tSavedDel
      set the itemdel to ":"
      if the number of items of tIPAddress > 1 and item -1 of tIPAddress is a number then
        put ":" &  item -1 of tIPAddress into tPort
        delete item -1 of tIPAddress #remove port for now
      else
        put ":80" into tPort
      end if
      set the itemDel to tSavedDel
    else if tPort <> empty then
      put tHost  into tIPAddress
    else
      put tHost  into tIPAddress
      put ":80" into tPort
    end if
    
    put tIPAddress into tTempIPAddress
    replace "." with empty in tTempIPAddress
    replace ":" with empty in tTempIPAddress
    
    if tTempIPAddress  is not a number then
      get hostNameToAddress(tIPAddress)
      if the result is empty then
        put line 1 of it & tPort into tConnectHost
      else
        put true into tBadAddress
      end if
    else
      put tIPAddress & tPort into tConnectHost
    end if
    break
    
  case "ftp"
    
    put tHost into tTempHost
    if tPort is empty then put ":21" into tPort
    replace "." with empty in tTempHost
    replace ":" with empty in tTempHost
    if tTempHost  is not a number then
      get hostnameToAddress(tHost)
      if the result is empty then
        put line 1 of it & tPort into tConnectHost
      else
        put true into tBadAddress
      end if
    else
      put tHost & tPort into tConnectHost
    end if
    if tUser is empty then
      put "anonymous" into tUser
      put "guest" into tPass
    end if
    
    break
  default
    put "invalid URL: " & quote & pUrl & quote into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "error" into laUrlLoadStatus[pUrl]
    exit "ulGetFormat"
    break
  end switch
  
  if tBadAddress then
    put "invalid host address" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then
      put "error" into laUrlLoadStatus[pUrl]
      delete local laLoadingUrls[pUrl]
    end if
    ##need better clean up here
    exit "ulGetFormat"
  end if
  
  ##dc 080702
  ##need to keep separate reference for ftp IPs by user
  ## in case we need to connect to two accounts simultaneously
  ##so just keep user + host ref for all  urls
  ##so laConnectHost has format host:port|user
  put tConnectHost &  "|" & tUser into laConnectHost[pUrl]
  
  if tUser is not empty then put urlDecode(tUser) into laUser[pUrl]
  if tPass is not empty  then
    put urlDecode(tPass) into laPasswd[pUrl]
    put "true" into laAuth[pUrl]
  end if
  put tHost into laHost[pUrl]
  if tFileName is empty then put "/" into tFileName
  if tPre = "http" and the httpProxy <> empty then
    ----changed for 1.0.10 Remove username:password from url when sending request through a proxy
    put "http://" & tHost & tUrlPort & tFilename into laLongFileName[pUrl]
    ## put pUrl into laLongFileName[pUrl] ##must request full url when using http proxy
  else
    put tFileName into laLongFileName[pUrl]
  end if
  put "booked" into laUrlErrorStatus[pUrl]
  if tPre is "http" then
    ##store current state of httpHeaders ad use when request is actually processed
    put the httpHeaders into laCurrentHttpHeaders[pUrl]
    ulHttpRequest pUrl
  else
    ulFtpRequest pUrl
  end if
end ulGetFormat

#################choose http method####################

#on ulHttpRequest x
on ulHttpRequest pUrl
  switch
  case laAction[pUrl] is "getData"
    if(laLoadReq[pUrl]) is true then
      ulHttpLoad pUrl
    else
      ulGetHttp pUrl
    end if
    break
  case laAction[pUrl] is "sendData"
    ulPutHttp pUrl
    break
  case laAction[pUrl] is "deleteData"
    ulDeleteHttp pUrl
    break
  case laAction[pUrl] is "putData"
    ulPutHttp pUrl
    break
  case laAction[pUrl] is "postData"
    ulPostHttp pUrl
  end switch
end ulHttpRequest
--------------------------------------------------
##set up queue for http load requests
on ulHttpLoad pUrl
  put laConnectHost[pUrl] into tIP
  put keys(laLoadQ) into tLoadingKeys
  if tIP is among the lines of tLoadingKeys then
    put true into tHaveConnection
  else
    put false into tHaveConnection
  end if
  put pUrl & cr after  laLoadQ[tIP]
  put "queued" into laUrlLoadStatus[pUrl]
  
  if not tHaveConnection then
    ulNextHttpLoadRequest tIP
  end if
end ulHttpLoad
------------------------------------------------
##dispatch next load request
on ulNextHttpLoadRequest pIP
  put line 1 of laLoadQ[pIP] into tUrl
  if tUrl <> empty then
    if tUrl = lvBlockingUrl then ##the same URL is being requested in a blocking call
      repeat until lvBlockingUrl <> tUrl
        if lvJumpOut then exit to top
        wait for messages
      end repeat
    end if
    ##in case url was "unloaded" during any wait, check that it's still in the queue
    if tUrl is among the lines of keys(laLoadingUrls) then
      delete line 1 of laLoadQ[pIP] ##added in 1.0.8r4
      ulGetHttp tUrl
    else
      ##modified dc 00202 Delete current rquest if not in laLoadingUrls
      -----------------------------------
      ## CLEAN UP POINT if user cancelled while in queue
      delete line 1 of laLoadQ[pIP] ##delete this item
      ulCleanUpHttpLocals tUrl
      delete local laLoadReq[tUrl] ##added dc 210702
      delete local laLoadedUrls[tUrl]##added dc 210702
      delete local laMessg[tUrl]##added dc 210702
      
      delete local laUrlErrorStatus[tUrl]
      delete local laUrlLoadStatus[tUrl]
      delete local laCancelled[tUrl]
      if the number of lines of laLoadQ[pIP] = 0 then
        delete local laLoadQ[pIP]
        delete local laConnectID[pIP]
      else
        ##use send to ensure this thread  finishes before next request
        send "ulNextHttpLoadRequest" && quote & pIP & quote to me in 1 milliseconds
      end if
      ------------------------------
    end if
  end if
end ulNextHttpLoadRequest

##############method GET#########################

on ulGetHttp pUrl
  try
    put empty into laStatus[pUrl] ##set wait flag here
    put "started" into laUrlErrorStatus[pUrl]
    put ulWhichSocket(pUrl) into tSocket
    
    put pUrl into laUrl[tSocket] #ref the url to the used socket##KEY REFERENCE
    if tSocket is not among the lines of the openSockets then
      ulStartTickle ##safeguard routine
      get ulOpenSocket(tSocket)
      if not it then throw it ##error opening socket
    end if
    
    put "contacted" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "contacted" into laUrlLoadStatus[pUrl]
    ulSendCallback pUrl,"contacted"  ##CALLBACK FEATURE
    
    put ulBuildHttpRequest(pUrl) into tRequest
    ulLogit  tRequest & cr ##LOG
    write tRequest & crlf  to socket tSocket  with message "ulStartRead"
    ---------------------
    if the result is not empty then
      throw the result  #early exit
    end if
    --------------------------
    ##blocking point "get url"
    #If we got here by "load url" then we don't block, otherwise we do
    
    if laLoadReq[pUrl] is empty then
      repeat while laStatus[pUrl] is empty
        if lvJumpOut then exit to top
        wait for messages
      end repeat
    end if
  catch pErr ##clean up point
    ulHttpEarlyCleanUp tSocket,pUrl,pErr
    exit ulGetHttp
  end try
end ulGetHttp
----------------------------------
on ulHttpEarlyCleanUp x, pUrl, pErr
  put "error" && pErr into laUrlErrorStatus[pUrl]
  if laLoadReq[pUrl] then put "error" into laUrlLoadStatus[pUrl]
  put false into laStatus[pUrl] ##to unblock waits
  put laLoadReq[pUrl] into tLoadReq ##holder
  put laConnectHost[pUrl] into tConnectHost
  ulCleanUpHttp x
  if tLoadReq then
    ulSendMessage pUrl ##added 091002
    ##use send to ensure this thread finishes before next request starts
    send "ulNextHttpLoadRequest" && quote & tConnectHost & quote to me in 1 milliseconds
  end if
end ulHttpEarlyCleanUp
----------------------------------------------------------
on ulStartRead x,y
  if laUrl[x] <> empty then ##carry on
    -----------------------------------
    ##set the httpHeaders to empty ##commented out in 1.0.8r4
    put "requested" into laUrlErrorStatus[laUrl[x]]
    if laLoadReq[laUrl[x]] then put "requested" into laUrlLoadStatus[laUrl[x]]
    ulSendCallback laUrl[x],"requested"  ##CALLBACK FEATURE
    if laLoadReq[laUrl[x]] then
      put empty into laLoadedUrls[laUrl[x]]
    else
      put empty into  laData[laUrl[x]]
    end if
    put empty into laTmpData[laUrl[x]]
    put empty into laTemp[laUrl[x]]
    
    read from socket x  with message "ulReadmore"
    --------------------------------
    if the result <> empty then
      put "error" && the result into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
      put false into laStatus[laUrl[x]] ##to unblock wait
    end if
    ----------------------------------
    ##The wait in the getHttp handler allows "load" requests to pass
    ## we wait here for ALL requests so we can clean up
    ---------------------------------------
    repeat while laStatus[laUrl[x]] is empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
    ----------------------------------------
    ## CLEAN UP POINT
    if laStatus[laUrl[x]] is false then
      close socket x ##if user unloaded
    else if laConn[laUrl[x]] is "close" then
      close socket x ##if user unloaded
    end if
    ulHttpLateCleanUp x
  end if
  
end ulStartRead
---------------------------------------
on ulHttpLateCleanUp x
  if laFile[laUrl[x]] <> empty then
    close file laFile[laUrl[x]] ##close here??
  end if
  
  put laLoadReq[laUrl[x]] into tLoadReq ##holder
  put laUrl[x] into tUrlHolder #so we can delete in cleanUp
  put laConnectHost[laUrl[x]] into tConnectHost #holder so we can delete in clean up
  ulCleanUpHttp x
  if tLoadReq and laCancelled[tUrlHolder] then
    delete local laLoadedUrls[tUrlHolder]
    delete local laUrlLoadStatus[tUrlHolder]
    delete local laUrlErrorStatus[tUrlHolder]
    delete local laStatus[tUrlHolder]
  end if
  if not laCancelled[tUrlHolder] then
    ulSendMessage tUrlHolder
  else
    delete local laMessg[tUrlHolder]
  end if
  delete local laFile[tUrlHolder]
  delete local laCancelled[tUrlHolder]
  if tLoadReq then
    ##use send to ensure current request finishes completely
    send "ulNextHttpLoadRequest" && quote & tConnectHost & quote to me in 1 milliseconds
  end if
  
end ulHttpLateCleanUp
------------------------------------------------------------------
on ulReadmore x,y
  #separate the header from body
  
  put false into laHaveHeader[laUrl[x]]
  put y after laTmpData[laUrl[x]]
  put y after laTemp[laUrl[x]]
  
  put lineOffset(crlf & crlf, laTmpData[laUrl[x]]) into tHeaderOffSet ##proper header structure
  
  ##added to catch irregularly formed headers 1.0.7b1
  if tHeaderOffset is 0 then ##for irregularly formed headers
    put lineOffset(cr & crlf, laTmpData[laUrl[x]]) into tHeaderOffSet
    if tHeaderOffset is 0 then
      put lineOffset(cr & cr, laTmpData[laUrl[x]]) into tHeaderOffSet
    end if
  end if
  
  if tHeaderOffSet is not 0 then#1
    put tHeaderOffSet into laLineNum[laUrl[x]]
    put line 1 to laLineNum[laUrl[x]] of laTmpData[laUrl[x]] into laRhHeader[laUrl[x]]
    repeat
      ##be sure we have a header
      if char 1 to 4 of laRhHeader[laUrl[x]] = "HTTP" then exit repeat
      delete line 1 of laRhHeader[laUrl[x]]
      if laRhHeader[laUrl[x]] is empty then ##we don't have a header
        put "error" && "No header received" into laUrlErrorStatus[laUrl[x]]
        if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
        put false into laStatus[laUrl[x]] ##to unblock wait
        exit "ulReadmore"
      end if
    end repeat
    put length (laRhHeader[laUrl[x]]) into hLen
    switch
    case word 2 of line 1 of laRhHeader[laUrl[x]] is  "100"
      ##Is this handled right??
      delete line 1 to laLineNum[laUrl[x]]+1 of laTmpData[laUrl[x]]
      delete line 1 to laLineNum[laUrl[x]]+1 of laTemp[laUrl[x]]
      
      get lineOffset(crlf & crlf, laTmpData[laUrl[x]])
      if it is not "0" then
        put it into laLineNum[laUrl[x]]
        put line 1 to laLineNum[laUrl[x]] of laTmpData[laUrl[x]] into laRhHeader[laUrl[x]]
        ulDoProcess x,y
      else
        read from socket x  with message "ulReadmore"
      end if
      break
    case word 2 of line 1 of laRhHeader[laUrl[x]] is  not "100"
      ulDoProcess x,y
    end switch
  else#1
    if laStatus[laUrl[x]] is empty then
      read from socket x  with message "ulReadmore"
      ##how often should we do this reading for a header??
      ------------------------------------
      if the result <> empty then
        put "error" && the result into laUrlErrorStatus[laUrl[x]]
        if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
        put false into laStatus[laUrl[x]] ##to unblock wait below
      end if
      ------------------------------------
    end if
  end if#1
end ulReadmore
-------------------------------------------
on ulDoProcess x,y
  
  #handles reading data depending on whether transfer method is streamed, chunked or "until socket closes"
  
  if not laHaveHeader[laUrl[x]] then ##pick up header first time only
    ulLogIt laRhHeader[laUrl[x]] & cr & cr --LOG
    set the lastRhHeaders of me to laRhHeader[laUrl[x]] ##set property
    put lineOffset("Location:",laRhHeader[laUrl[x]]) into tLocLine
    put lineOffset("Content-Length:",laRhHeader[laUrl[x]]) into tLenLine
    put lineOffset("Content-Type:",laRhHeader[laUrl[x]]) into tContentLine
    put lineOffset("Transfer-Encoding:",laRhHeader[laUrl[x]]) into tCodeLine
    put lineOffset("Connection:",laRhHeader[laUrl[x]]) into tConnectionLine
    put lineOffset("Proxy-Connection:",laRhHeader[laUrl[x]]) into ptConnLine
    
    #get status code
    put word 2 of line 1 of laRhHeader[laUrl[x]] into laStatusCode[laUrl[x]]
    #get status message for error results
    put word 2 to -1 of line 1 of laRhHeader[laUrl[x]] into laStatusMessage[laUrl[x]]
    
    if laStatusCode[laUrl[x]] is not a number then ##no point hanging around
      put "error" && "Unable to resolve server response." into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
      put false into laStatus[laUrl[x]] ##to unblock wait
      exit "ulDoProcess"
    end if
    
    if tConnectionLine is not "0" then
      put last word of line tConnectionLine of laRhHeader[laUrl[x]] into laConn[laUrl[x]]
    end if
    if ptConnLine is not "0" then
      put last word of line tConnectionLine of laRhHeader[laUrl[x]] into laConn[laUrl[x]]
    end if
    if tLenLine is not "0" and last word of (line tLenLine of laRhHeader[laUrl[x]]) is a number then
      put last word of (line tLenLine of laRhHeader[laUrl[x]]) into laLength[laUrl[x]]
    else
      put empty into laLength[laUrl[x]]
      put empty into laHttpDataDone[laUrl[x]] ##flag for detecting end of download
    end if
    if tCodeLine <> "0" then
      put last word of line tCodeLine of laRhHeader[laUrl[x]] into laCode[laUrl[x]]
    end if
    delete line 1 to laLineNum[laUrl[x]]+1 in laTmpData[laUrl[x]]
    put true into laHaveHeader[laUrl[x]]
    
  else
    put y after laTmpData[laUrl[x]]
  end if
  -------------------------------------
  switch
  case laStatusCode[laUrl[x]] is among the items of "301,302"
    #we are redirected to a different url
    
    if tLocLine is not empty then
      put last word of (line tLocLine of laRhHeader[laUrl[x]]) into tNewLoc
      --------------------------------
      put true into lvBlockBypass ##to allow another blocking call
      get url tNewLoc
      if the result is empty then
        ulStoreData laUrl[x],it
        
        put empty into laUrlErrorStatus[laUrl[x]]
        if laFile[laUrl[x]] is empty then
          put "cached" into tStatus
        else
          put "downloaded" into tStatus
        end if
        if laLoadReq[laUrl[x]] is "true" then put tStatus into laUrlLoadStatus[laUrl[x]]
        ulSendCallback laUrl[x],"downloaded"  ##CALLBACK FEATURE
      else
        put "error" && "Redirect failed" && tNewLoc into laUrlErrorStatus[laUrl[x]]
        if laLoadReq[laUrl[x]] is "true" then
          put "error" into laUrlLoadStatus[laUrl[x]]
          put empty into laLoadedUrls[laUrl[x]]
        else
          put empty into laData[laUrl[x]]
        end if
      end if
      put false into lvBlockBypass##to disallow another blocking call
      -----------------------
      put true into laStatus[laUrl[x]]
    end if
    break
    
    ##normal case
  case laLength[laUrl[x]] is not empty
    
    put  laTmpData[laUrl[x]] into tData
    ulStoreData laUrl[x],tData
    put length(tData) into laReadBytes[laUrl[x]]
    if laStatus[laUrl[x]]  is empty then ulDoProcessLength x
    
    break
    #### chunked ######################################
  case laCode[laUrl[x]] is "chunked"
    put true into laNeedChunk[laUrl[x]]
    put empty into laReadBytes[laUrl[x]]
    ulDoProcessChunked x
    break
    ##########No length header  ##typically from CGI request
    #Handle both cases together
  case laLength[laUrl[x]] is empty and laConn[laUrl[x]] is "close"
  case laLength[laUrl[x]] is empty and laConn[laUrl[x]] is empty
    put laTmpData[laUrl[x]] into tData
    ulStoreData laUrl[x],tData
    put length(tData) into laReadBytes[laUrl[x]]
    put empty into laTmpData[laUrl[x]] ##clear buffer
    ulDoProcessNoLength x
    break
  end switch
end ulDoProcess
------------------------------------------------------------------
on ulDoProcessLength x,y
  ##normal http case
  if y <> empty then
    ulStoreData laUrl[x],y
    add length(y) to laReadBytes[laUrl[x]]
  end if
  
  if laReadBytes[laUrl[x]] >= laLength[laUrl[x]] then
    put "true" into laStatus[laUrl[x]]
    
    if char 1 of laStatusCode[laUrl[x]] = 2 then ##in 200 range--OK
      if laFile[laUrl[x]] is empty then
        put "cached" into tStatus
      else
        put "downloaded" into tStatus
      end if
      put empty into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] is "true" then put tStatus into laUrlLoadStatus[laUrl[x]]
      ulSendCallback laUrl[x],"downloaded"  ##CALLBACK FEATURE
    else
      put "error" && laStatusMessage[laUrl[x]] into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] is "true" then
        put "error" into laUrlLoadStatus[laUrl[x]]
      end if
    end if
    
    delete local laHaveHeader[laUrl[x]]
    --------------------------
  else ##need more data
    put "loading," & laReadBytes[laUrl[x]] & "," & laLength[laUrl[x]] into tStatus
    put tStatus  into laUrlErrorStatus[laUrl[x]]
    if laLoadReq[laUrl[x]] then put tStatus  into laUrlLoadStatus[laUrl[x]]
    ulSendCallback laUrl[x],tStatus  ##CALLBACK FEATURE
    if laStatus[laUrl[x]] is empty then
      read from socket x  with message "ulDoProcessLength"
      ---------------------
      if the result <> empty then
        put "error" && the result into laUrlErrorStatus[laUrl[x]]
        put false into laStatus[laUrl[x]] ##to unblock waits above
        if laLoadReq[laUrl[x]] then
          put "error" into laUrlLoadStatus[laUrl[x]]
          put empty into laLoadedUrls[laUrl[x]] ##empty any data here
        else
          put empty into laData[laUrl[x]] ##empty any data here
        end if
      end if
      exit "ulDoProcessLength"
      ------------------------------
    end if
  end if
  
end ulDoProcessLength
------------------------------------------------------------
on ulDoProcessChunked x,y
  if y <> empty then
    put y after laTmpData[laUrl[x]]
  end if
  
  repeat while  laStatus[laUrl[x]] is empty
    if laNeedChunk[laUrl[x]] then
      get the number of chars of line 1 of laTmpData[laUrl[x]]
      if not ((char it of laTmpData[laUrl[x]] is numtochar(13)) and\
          (char it+1 of laTmpData[laUrl[x]] is numtochar(10))) then
        read from socket x with message "ulDoProcessChunked"
        ---------------------
        if the result <> empty then
          put "error" && the result into laUrlErrorStatus[laUrl[x]]
          put false into laStatus[laUrl[x]] ##to unblock wait above
          if laLoadReq[laUrl[x]] then
            put "error" into laUrlLoadStatus[laUrl[x]]
            put empty into laLoadedUrls[laUrl[x]] ##empty any data here
          else
            put empty into laData[laUrl[x]] ##empty any data here
          end if
        end if
        exit "ulDoProcessChunked"
      end if
      
      put offset(numtochar(13), laTmpData[laUrl[x]]) into wOffset[laUrl[x]]
      ----get chunk size value (store in laChunk)
      put char 1 to wOffset[laUrl[x]]-1 of laTmpData[laUrl[x]] into tRead[laUrl[x]]
      set the itemDel to ";"
      put item 1 of tRead[laUrl[x]] into tRead[laUrl[x]] ##remove any chunk extension
      set the itemdel to comma
      replace space with empty in tRead[laUrl[x]]
      
      put baseConvert(tRead[laUrl[x]],16,10) into laChunk[laUrl[x]]
      ---------
      delete char 1 to wOffset[laUrl[x]]+1 of laTmpData[laUrl[x]]
      if tRead[laUrl[x]] is "0" then ##completed
        delete local laNeedChunk[laUrl[x]]
        delete local laHaveHeader[laUrl[x]]
        put "true" into laStatus[laUrl[x]] ##to break out of wait
        if char 1 of laStatusCode[laUrl[x]] = 2 then ##in 200 range --OK
          if laFile[laUrl[x]] is empty then
            put "cached" into tStatus
          else
            put "downloaded" into tStatus
          end if
          put empty into laUrlErrorStatus[laUrl[x]]
          if laLoadReq[laUrl[x]] is "true" then put tStatus into laUrlLoadStatus[laUrl[x]]
          ulSendCallback laUrl[x],"downloaded"  ##CALLBACK FEATURE
        else
          put "error" && laStatusMessage[laUrl[x]] into laUrlErrorStatus[laUrl[x]]
          if laLoadReq[laUrl[x]] is "true" then
            put "error" into laUrlLoadStatus[laUrl[x]]
          end if
        end if
        exit "ulDoProcessChunked"
      end if
    end if
    
    switch
    case length(laTmpData[laUrl[x]])=laChunk[laUrl[x]] + 2
      put char 1 to laChunk[laUrl[x]] of laTmpData[laUrl[x]] into tData
      ulStoreData laUrl[x],tData
      add length(tData) to laReadBytes[laUrl[x]]
      put "loading," & laReadBytes[laUrl[x]] & "," into tStatus
      put tStatus  into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then put tStatus  into laUrlLoadStatus[laUrl[x]]
      ulSendCallback laUrl[x],tStatus  ##CALLBACK FEATURE
      delete char 1 to laChunk[laUrl[x]] + 2 of laTmpData[laUrl[x]]
      put true into laNeedChunk[laUrl[x]]
      if laStatus[laUrl[x]] is empty then
        read from socket x with message "ulDoProcessChunked"
        ---------------------
        if the result <> empty then
          put "error" && the result into laUrlErrorStatus[laUrl[x]]
          put false into laStatus[laUrl[x]] ##to unblock wait above
          if laLoadReq[laUrl[x]] then
            put "error" into laUrlLoadStatus[laUrl[x]]
            put empty into laLoadedUrls[laUrl[x]] ##empty any data here
          else
            put empty into laData[laUrl[x]] ##empty any data here
          end if
        end if
        exit "ulDoProcessChunked"
        -----------------------
      end if
      break
    case length(laTmpData[laUrl[x]])>laChunk[laUrl[x]] + 2
      put char 1 to laChunk[laUrl[x]] of laTmpData[laUrl[x]] into tData
      ulStoreData laUrl[x],tData
      add length(tData) to laReadBytes[laUrl[x]]
      put "loading," & laReadBytes[laUrl[x]] & "," into tStatus
      put tStatus  into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then put tStatus  into laUrlLoadStatus[laUrl[x]]
      ulSendCallback laUrl[x],tStatus  ##CALLBACK FEATURE
      delete char 1 to laChunk[laUrl[x]] + 2 of laTmpData[laUrl[x]]
      put true into laNeedChunk[laUrl[x]]
      next repeat
      break
    case length(laTmpData[laUrl[x]]) < laChunk[laUrl[x]] + 2
      put false into laNeedChunk[laUrl[x]]
      if laStatus[laUrl[x]] is empty then
        read from socket x  with message "ulDoProcessChunked"
        ---------------------------
        if the result <> empty then
          put "error" && the result into laUrlErrorStatus[laUrl[x]]
          put false into laStatus[laUrl[x]] ##to unblock wait above
          if laLoadReq[laUrl[x]] then
            put "error" into laUrlLoadStatus[laUrl[x]]
            put empty into laLoadedUrls[laUrl[x]] ##empty any data here
          else
            put empty into laData[laUrl[x]] ##empty any data here
          end if
        end if
        ----------------------------
      end if
      exit "ulDoProcessChunked"
    end switch
  end repeat
end ulDoProcessChunked
---------------------------------------
on ulDoProcessNoLength x,y
  if y <> empty then
    ulStoreData laUrl[x],y
    add length(y) to laReadBytes[laUrl[x]]
  end if
  
  if x is among the lines of the openSockets then ##test for closure here
    
    if laStatus[laUrl[x]] is empty and laHttpDataDone[laUrl[x]] is empty then
      read from socket x  with message "ulDoProcessNoLength"
      ----------------------------------------
      if the result <> empty then
        put the result into tResult
        if tResult is not "socket is not open" then
          put "error" && the result into laUrlErrorStatus[laUrl[x]]
          put false into laStatus[laUrl[x]] ##to unblock wait
          if laLoadReq[laUrl[x]] then
            put "error" into laUrlLoadStatus[laUrl[x]]##not likely
            put empty into laLoadedUrls[laUrl[x]] ##empty any data here
          else
            put empty into laData[laUrl[x]] ##empty any data here
          end if
        else ##assume that we've got all the data ##treat as "completed" as below
          put "true" into laStatus[laUrl[x]]
          if char 1 of laStatusCode[laUrl[x]] = 2 then
            if laFile[laUrl[x]] is empty then
              put "cached" into tStatus
            else
              put "downloaded" into tStatus
            end if
            put empty into laUrlErrorStatus[laUrl[x]]
            if  laLoadReq[laUrl[x]] is "true" then put tStatus into laUrlLoadStatus[laUrl[x]]
            ulSendCallback laUrl[x],"downloaded"  ##CALLBACK FEATURE
          else
            put "error" && laStatusMessage[laUrl[x]] into laUrlErrorStatus[laUrl[x]]
            if  laLoadReq[laUrl[x]] is "true" then put "error" into laUrlLoadStatus[laUrl[x]]
          end if
          delete local laHaveHeader[laUrl[x]]
        end if
      end if
      ---------------------------------------------
    end if
  else ##completed
    put "true" into laStatus[laUrl[x]]
    if char 1 of laStatusCode[laUrl[x]] = 2 then
      if laFile[laUrl[x]] is empty then
        put "cached" into tStatus
      else
        put "downloaded" into tStatus
      end if
      put empty into laUrlErrorStatus[laUrl[x]]
      if  laLoadReq[laUrl[x]] is "true" then put tStatus into laUrlLoadStatus[laUrl[x]]
      ulSendCallback laUrl[x],"downloaded"  ##CALLBACK FEATURE
    else
      put "error" && laStatusMessage[laUrl[x]] into laUrlErrorStatus[laUrl[x]]
      if  laLoadReq[laUrl[x]] is "true" then put "error" into laUrlLoadStatus[laUrl[x]]
    end if
    delete local laHaveHeader[laUrl[x]]
  end if
end ulDoProcessNoLength
##################HTTP DELETE###############################

on ulDeleteHttp pUrl
  try
    put empty into laStatus[pUrl]
    put ulWhichSocket(pUrl) into tSocket
    put pUrl into laUrl[tSocket] #ref the url to the used socket
    if tSocket is not among the lines of the openSockets then
      ulStartTickle ##safeguard routine
      get ulOpenSocket(tSocket)
      if not it then throw it ##error opening socket
    end if
    put "contacted" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "contacted" into laUrlLoadStatus[pUrl]
    ulSendCallback pUrl,"contacted"  ##CALLBACK FEATURE
    put ulBuildHttpRequest(pUrl) into tRequest
    ulLogit  tRequest & cr ##LOG
    write tRequest & crlf  to socket tSocket
    if  the result is not empty then
      throw the result
    end if
    put "requested" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "requested" into laUrlLoadStatus[pUrl]
    ulSendCallback pUrl,"requested"  ##CALLBACK FEATURE
    read from socket tSocket   until crlf & crlf  with message "ulReadMore"
    if  the result is not empty then throw the result
    
    repeat while laStatus[pUrl] is empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
    -------------------------------------
    ulHttpLateCleanUp tSocket
    ---------------------------
  catch pErr
    ulHttpEarlyCleanUp tSocket,pUrl,pErr
    exit ulDeleteHttp
  end try
end ulDeleteHttp

########################HTTP POST#########################

on ulPostHttp pUrl
  try
    put empty into laStatus[pUrl] ##set wait flag here
    put ulWhichSocket(pUrl) into tSocket
    put pUrl into laUrl[tSocket] #ref the url to the used socket
    
    if tSocket is not among the lines of the openSockets then
      ulStartTickle ##safeguard routine
      get ulOpenSocket(tSocket)
      if not it then throw it ##error opening socket
    end if
    put "contacted" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "contacted" into laUrlLoadStatus[pUrl]
    ulSendCallback pUrl,"contacted"  ##CALLBACK FEATURE
    put ulBuildHttpRequest(pUrl) into tRequest
    put empty into  laData[pUrl]
    put empty into laTmpData[pUrl]
    ulLogit tRequest  & cr #LOG
    write tRequest  & crlf   to socket tSocket with message "ulWriteSome"
    --------------------------
    if the result is not empty then
      throw the result
    end if
    --------------------------
    
    ## blocking point
    repeat while laStatus[pUrl] is empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
    ##added for 1.0.8.b4 , was previously in ulWriteSome which wasn't good
    ulHttpLateCleanUp tSocket
  catch pErr
    ulHttpEarlyCleanUp tSocket,pUrl,pErr
    exit ulPostHttp
  end try
end ulPostHttp
-----------------------------------------------------
on ulWriteSome x
  if laUrl[x] <> empty then ##in case an error was encountered when writing
    
    if the length of laPostData[laUrl[x]] <= 4096 then ##don't forget to get tBytes
      write laPostData[laUrl[x]] & crlf  to socket x
      put "requested" into laUrlErrorStatus[laUrl[x]]
      read from socket x  with message "ulReadmore"
      ----------------------------------
      if the result <> empty then
        put "error" && the result into laUrlErrorStatus[laUrl[x]]
        if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
        put false into laStatus[laUrl[x]] ##to unblock wait above
      end if
      ----------------------------------
      repeat while laStatus[laUrl[x]] is empty
        if lvJumpOut then exit to top
        wait for messages
      end repeat
    else
      put char 1 to 4096 of laPostData[laUrl[x]] into tChunk ##laChunk[laUrl[x]]
      delete char 1 to 4096 in laPostData[laUrl[x]]
      write tChunk to socket x with message "ulWriteSome"
    end if
    
  end if
end ulWriteSome


###################HTTP PUT##########################

on ulPutHttp pUrl
  try
    put empty into laStatus[pUrl]##flag
    put ulWhichSocket(pUrl) into tSocket
    put pUrl into laUrl[tSocket] #ref the url to the used socket
    if tSocket is not among the lines of the openSockets then
      ulStartTickle ##safeguard routine
      get ulOpenSocket(tSocket)
      if not it then throw it ##error opening socket
    end if
    put "contacted" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "contacted" into laUrlLoadStatus[pUrl]
    ulSendCallback pUrl,"contacted"  ##CALLBACK FEATURE
    put ulBuildHttpRequest(pUrl) into tRequest
    ulLogit  tRequest & cr ##LOG
    
    ##just the same as ulPostHttp from this point
    write tRequest  & crlf   to socket tSocket with message "ulWriteSome"
    ---------------------------
    if the result is not empty then
      throw the result
    end if
    --------------------------
    
    ##top blocking point
    repeat while laStatus[pUrl] is empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
    ##added for 1.0.8.b4 , was previously in ulWriteSome which wasn't good
    ulHttpLateCleanUp tSocket
  catch pErr
    ulHttpEarlyCleanUp tSocket,pUrl,pErr
    exit ulPutHttp
  end try
end ulPutHttp
--------------------------------------------
function ulWhichSocket pUrl
  ##build socket ref including Connection ID number
  ## re-use sockets for blocking requests if open
  ##load request sequences will always use same socket
  ##new sequence gets new socket
  put laConnectHost[pUrl] into tConnectHost
  set the itemDel to "|"
  if loadReq[pUrl] then
    if laConnectID[tConnectHost] <> empty then
      put  laConnectID[tConnectHost] into tConnID
    else
      add 1 to lvCount
      put  lvCount into tConnID
      put lvCount into laConnectID[tConnectHost]
    end if
  else ##blocking request
    
    put empty into tConnID
    put char 1 to 4 of pUrl is "ftp:" into tIsFtp
    repeat for each line i in the openSockets
      if tIsFtp then
        ##makes sure we have the same username before re-using an  FTP socket
        if laSocketUser[i] <> laUser[pUrl] then
          next repeat
        end if
      end if
      if item 1 of tConnectHost is item 1 of i and i is not among the lines of keys(laUrl) then #OK to use
        put last item of i into tConnID
        exit repeat
      end if
    end repeat
    if tConnID is empty then ##need new socket ref
      add 1 to lvCount
      put lvCount into tConnID
    end if
  end if
  ##swap out user name for connection ID
  put item 1 of tConnectHost & "|" & tConnID into tSocket
  if laUser[pUrl] <> empty then
    ##for ftp sockets, we need to keep reference to user name
    put laUser[pUrl] into laSocketUser[tSocket] ## here or when connection is made??
  end if
  set the itemDel to comma
  return tSocket
end ulWhichSocket

---------------------------------------------
function ulBuildHttpRequest pUrl
  ##build the httpRequest including
  ##request line and basic headers
  
  if the customHTTPHeaders of me <> empty then#a
    
    put the customHTTPHeaders of me into tRequest
    set the customHTTPHeaders of me to empty
  else
    ##get template
    put the cDefaultHeader of me into tRequest
    ##get method
    put laAction[pUrl] into tAction
    switch tAction
    case "getData"
      put "GET" into tMethod
      break
    case  "deleteData"
      put "DELETE" into tMethod
      break
    case "putData"
      put "PUT" into tMethod
      break
    case "postData"
      put "POST" into tMethod
      break
    end switch
    
    replace "METHOD" with tMethod in tRequest
    ----------------------------
    ##fill in url resource
    put  laLongFileName[pUrl] into word 2 of line 1 of tRequest
    ## fill in host
    put  laHost[pUrl]  after line 2 of tRequest
    ## fill in User-Agent
    if "rev" is in the short name of me then
      put "Revolution" into tAgent
    else
      put "Metacard" into tAgent
    end if
    put tAgent && "(" & the platform & ")" after line 3 of tRequest
    if tMethod is among the items of "PUT,POST" then
      put cr & "Content-Length:" && length(laPostdata[pUrl]) after tRequest
      put cr & "Content-Type:  application/x-www-form-urlencoded" after tRequest
    end if
    if laAuth[pUrl] is not empty then
      put base64Encode(laUser[pUrl] & ":" & laPasswd[pUrl]) into tLogin
      put cr & "Authorization: Basic" && tLogin after tRequest
    end if
    
    ##customize according to httpHeaders
    ## if the httpHeaders  is not empty then
    if laCurrentHttpHeaders[pUrl] is not empty then
      ##repeat for each line tHeader in the httpHeaders
      repeat for each line tHeader in laCurrentHttpHeaders[pUrl]
        put lineOffset((word 1 of tHeader),tRequest) into tHeaderLine
        if tHeaderLine is not 0 then
          ##replace header value
          put tHeader into line tHeaderLine of tRequest
        else
          ##add new field
          put cr & tHeader after tRequest
        end if
      end repeat
    end if
    
  end if
  ##set the lastHTTPHeaders##
  set the lastHTTPHeaders of me to tRequest
  ##separate lines with crlf in header
  repeat for each line i in tRequest
    put  i & crlf after tRequest2
  end repeat
  return tRequest2
  
end ulBuildHttpRequest
###################################################
################ FTP LOGIN####################
########################################
on ulFtpRequest pUrl
  if laLoadReq[pUrl] then
    ulFtpLoad pUrl
  else if laAction[pUrl] = "postdata" then ##don't handle this
    put "error Post command not handled for FTP" into laUrlErrorStatus[pUrl]
    ulCleanUpFtpLocals pUrl
    
    exit "ulFtpRequest"
  else
    ulFtpSocket pUrl
  end if
end ulFtpRequest
-----------------------------
##set up queue for http load requests
on ulFtpLoad pUrl
  
  put laConnectHost[pUrl] into tIP
  put keys(laLoadQ) into tLoadingKeys
  if tIP is among the lines of tLoadingKeys then
    put true into tHaveConnection
  else
    put false into tHaveConnection
  end if
  put pUrl & cr after  laLoadQ[tIP]
  put "queued" into laUrlLoadStatus[pUrl]
  
  if not tHaveConnection then
    ulNextFtpLoadRequest tIP
  end if
  
end ulFtpLoad
------------------------------------------------
##dispatch next request
on ulNextFtpLoadRequest pIP
  put line 1 of laLoadQ[pIP] into tUrl
  if tUrl <> empty then
    if tUrl = lvBlockingUrl then ##the same URL is being requested in a blocking call
      repeat until lvBlockingUrl <> tUrl
        if lvJumpOut then exit to top
        wait for messages
      end repeat
    end if
    
    ##in case url was "unloaded" during any wait, check that it's still in the queue
    if tUrl is among the lines of keys(laLoadingUrls) then
      delete line 1 of laLoadQ[pIP] ##delete this item ##added for 1.0.8r4
      ulFtpSocket tUrl
    else
      ##Delete current rquest if not in laLoadingUrls
      -----------------------------------
      ## CLEAN UP POINT if user cancelled while in queue
      delete line 1 of laLoadQ[pIP] ##delete this item
      ulCleanUpFtpLocals tUrl
      delete local laLoadReq[tUrl] ##added dc 210702
      delete local laLoadedUrls[tUrl]##added dc 210702
      delete local laMessg[tUrl]##added dc 210702
      delete local laUrlErrorStatus[tUrl]
      delete local laUrlLoadStatus[tUrl]
      delete local laCancelled[tUrl]
      if the number of lines of laLoadQ[pIP] = 0 then
        delete local laLoadQ[pIP]
        delete local laConnectID[pIP]
      else
        ##use send .. in
        send "ulNextFtpLoadRequest" && quote & pIP & quote to me in 1 milliseconds
      end if
      ----------------------------------
    end if
  end if
end ulNextFtpLoadRequest

-------ulFtpSocket------------------------------------------------------
-------Establishes connection for all ftp calls-------------------
on ulFtpSocket pUrl
  put empty into laStatus[pUrl] ##set main wait flag here
  put ulWhichSocket(pUrl) into tSocket
  put pUrl into laUrl[tSocket] ##reference the url to the used socket
  put "0" into laStopUnit[tSocket]
  put "0" into laStopSec[tSocket]
  
  if tSocket is not among the lines of the openSockets then
    ulStartTickle ##safeguard routine
    get ulOpenSocket(tSocket)
    if not it then
      ulFtpEarlyExit tSocket,pUrl,it
      exit ulFtpSocket
    end if
    ------------------------get server response (220)
    put ulFtpWaitResponse(tSocket) into tReply
    if not ulFtpGoodReply(tReply, "connect") then
      ulFtpEarlyExit tSocket,pUrl,tReply
      exit "ulFtpSocket"
    end if
    ---------------
    put "connecting" into laUrlErrorStatus[pUrl]
    if laLoadReq[pUrl] then put "connecting" into laUrlLoadStatus[pUrl]
    ulSendCallback pUrl,"connecting"  ##CALLBACK FEATURE
    ---------------
    put "USER " & laUser[pUrl] into tCmd
    put ulFtpCommand(tCmd,tSocket) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      ulFtpEarlyExit tSocket,pUrl,tReply
      exit  "ulFtpSocket"
    end if
    ----------------------
    put  "PASS " & laPasswd[pUrl] into tCmd
    put ulFtpCommand(tCmd,tSocket) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      ulFtpEarlyExit tSocket,pUrl,tReply
      exit  "ulFtpSocket"
    end if
    
  end if
  ----------------------------
  write "PWD"  & crlf to socket tSocket with message "ulFtpStartPoint" ##BRANCH TO ALLOW NON BLOCKING load
  if the result <> empty then
    put the result into tErr
    ulFtpEarlyExit tSocket,pUrl,tErr
    exit ulFtpSocket
  end if
  ----------------------------------------
  ##let non-blocking requests exit
  put pUrl into tUrlHolder ##so we can delete laUrl and  in ulFtpStartPoint on return
  if laLoadReq[tUrlHolder] is empty then
    repeat until laStatus[tUrlHolder] is not empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
  end if
end ulFtpSocket
--------------------------------------------
on ulFtpEarlyExit pSocket,pUrl,pErr
  ####
  ##clean up when exiting before first blocking point
  ####
  put laConnectHost[pUrl] into tConnectHost
  replace "ftpErr," with empty in pErr
  put "error" &&  pErr into laUrlErrorStatus[pUrl]
  if laLoadReq[pUrl] then put "error" into laUrlLoadStatus[pUrl]
  put false into laStatus[pUrl]
  close socket pSocket
  delete local laSocketUser[pSocket]
  delete local laStopUnit[pSocket]
  delete local laStopSec[pSocket]
  
  put laLoadReq[pUrl] into tLoadReq ##holder
  ulCleanUpFtp pSocket
  if tLoadReq then
    ulSendMessage pUrl ##added 091002
    send "ulNextFtpLoadRequest" && quote & tConnectHost & quote to me in 1 milliseconds
  end if
end ulFtpEarlyExit
--------------------------
on ulFtpSetError x, pErr
  replace "ftpErr," with empty in pErr
  put "error " && pErr into laUrlErrorStatus[laUrl[x]]
  if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
  put false into laStatus[laUrl[x]] ##set flag to get past waits
end ulFtpSetError

-------ulFtpStartPoint------------------------------------------------------
-------Continues after load calls have passed on-------------------
on ulFtpStartPoint x
  set the itemdel to "|"
  put item -1 of x into tNum
  set the itemdel to comma
  put ulFtpWaitResponse(x) into tReply
  replace "ftpErr," with empty in tReply
  if not ulFtpGoodReply(tReply, "PWD") then ##command sent in ftpSocket
    ulFtpSetError x,tReply
    close socket x
    delete local laSocketUser[x]
  else
    ##051202 next 5 lines repair bug introduced in 1.0.8a1
    ## and ensure home directory is only set once per session
    ##otherwise CWD calls put us out of kilter
    if laHome[laUrl[x]] is empty then
      set the itemDel to quote
      put item 2 of tReply into laHome[laUrl[x]]
      set the itemDel to comma
    end if
    
    put "connected" into laUrlErrorStatus[laUrl[x]]
    if laLoadReq[laUrl[x]] then put "connected" into laUrlLoadStatus[laUrl[x]]
    ulSendCallback laUrl[x],"connected"  ##CALLBACK FEATURE
    switch
    case laAction[laUrl[x]] is "getData"
      ulFtpGet x,tNum
      break
    case laAction[laUrl[x]] is "putData"
      ulFtpSend x,tNum
      break
    case laAction[laUrl[x]] is "deleteData"
      ulFtpDelete x
      break
    default
      put false into laStatus[laUrl[x]]
      put "error Command not handled" into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
    end switch
  end if
  ##block ALL requests here until everything finished
  ##load requests already got past in ulFtpSocket
  repeat while laStatus[laUrl[x]] is empty
    if lvJumpOut then exit to top
    wait for messages
  end repeat
  
  ## CLEAN UP POINT
  -------------------------------------
  ##Pass message here on return
  put laUrlLoadStatus[laUrl[x]] into tLoadStatus
  
  -------------------------------------
  #start timer routine for closing ftp connection
  if laStopUnit[x] = 0 then
    put "1" into laStopUnit[x]
    send "ulFtpStopWatch " & x to me in 50 milliseconds
  end if
  ##do cleanup here
  ##first close file if necessary
  if laFile[laUrl[x]] <> empty then
    if laUrlByFile[laFile[laUrl[x]]] = laUrl[x] then ##hasn't been opened by new request
      close file laFile[laUrl[x]] ##close here??
      delete local laUrlByFile[laFile[laUrl[x]]]
    else
      seek to 0 in file laFile[laUrl[x]] ##reset position for subsequent reads
    end if
  end if
  delete local laFile[laUrl[x]]
  put laLoadReq[laUrl[x]] into tLoadReq ##holder
  put laUrl[x] into tUrlHolder #so we can delete in cleanUp
  put laConnectHost[laUrl[x]] into tConnectHost #holder so we can delete in clean up
  ulCleanUpFtp x
  
  if tLoadReq and laCancelled[tUrlHolder] then
    delete local laLoadedUrls[tUrlHolder]
    delete local laUrlLoadStatus[tUrlHolder]
    delete local laUrlErrorStatus[tUrlHolder]
    delete local laStatus[tUrlHolder]
  end if
  if not laCancelled[tUrlHolder] then
    ulSendMessage tUrlHolder
  else
    delete local laMessg[tUrlHolder]
  end if
  
  delete local laCancelled[tUrlHolder]
  #change dc 210702
  if tLoadReq then
    send "ulNextFtpLoadRequest" && quote & tConnectHost & quote to me in 1 milliseconds
  end if
  
end ulFtpStartPoint


#####################FTP GET##################


on ulFtpGet x,z
  if lvFtpMode is "active" then
    put "active" into laMode[laUrl[x]]
  else
    put "passive" into laMode[laUrl[x]]
  end if
  
  put "contacted" into laUrlErrorStatus[laUrl[x]]
  if laLoadReq[laUrl[x]] then put "contacted" into laUrlLoadStatus[laUrl[x]]
  ulSendCallback laUrl[x],"contacted"  ##CALLBACK FEATURE
  -----TYPE--------------------
  put "TYPE I" into tCmd
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    ulFtpSetError x,tReply
    close socket x
    delete local laSocketUser[x]
    exit "ulFtpGet"
  end if
  ----------------------
  ##sort out file path
  if laHome[laUrl[x]] is not "/" then ##otherwise laFileName should already be OK
    if laHome[laUrl[x]] is not char 1 to length(laHome[laUrl[x]]) of laLongFileName[laUrl[x]] then
      put laHome[laUrl[x]] before laLongFileName[laUrl[x]]
    end if
  end if
  
  ##SIZE get file size or CWD if a directory
  put empty into laLength[laUrl[x]] ##set up
  if last char of laLongFileName[laUrl[x]] is not "/" then ##file not directory
    put "SIZE " & laLongFileName[laUrl[x]]  into tCmd
    put false into tNeedCWDReset
    put ulFtpCommand(tCmd,x) into tReply
    ## 191002 changed following; can't use 550 response from SIZE command to assume file can't be transferred
    ##  if item 1 of tReply is "ftpErr" or word 1 of tReply is 550 then
    if item 1 of tReply is "ftpErr"  then
      ulFtpSetError x,tReply
      close socket x
      delete local laSocketUser[x]
      exit "ulFtpGet"
    end if
    if word 1 of tReply = 213 then ##good reply
      get word 2 of tReply
      if it is an integer then
        put  it  into laLength[laUrl[x]]
      end if
    end if
    
  else ##need directory listing so we must CWD before getting listing
    
    put laLongFileName[laUrl[x]] into tTempPath
    if the length of tTempPath >1 then
      ##remove final forward slash
      delete last char of tTempPath
    end if
    put "CWD " & tTempPath into tCmd
    put true into tNeedCWDReset
    
    put ulFtpCommand(tCmd,x) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      ulFtpSetError x,tReply
      close socket x
      delete local laSocketUser[x]
      exit "ulFtpGet"
    end if
  end if
  --------------------------------------
  if laMode[laUrl[x]] is "active" then
    ulTransferActive x
  else
    ulTransferPassive x
  end if
  
  if laStatus[laUrl[x]] <> empty then ##failed to set up data connection
    close socket x
    delete local laSocketUser[x]
    exit ulFtpGet
  end if
  ----------------------------------------------------
  ##prepare for reading data
  put empty into laFtpDataDone[laUrl[x]] ##flag for checking transfer is over
  put empty into laReadBytes[laUrl[x]]
  if laLoadReq[laUrl[x]] then
    put empty into laLoadedurls[laUrl[x]]
  else
    put empty into laData[laUrl[x]]
  end if
  -----RETR or LIST-------------------
  if last char of laLongFileName[laUrl[x]] is not "/" then
    put "RETR " & laLongFileName[laUrl[x]] into tCmd
  else ##need directory listing
    if lvFtpListCommand = "NLST" then
      put "NLST" into tCmd
    else
      put "LIST" into tCmd
    end if
  end if
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    ulFtpSetError x,tReply
    exit "ulFtpGet"
  else
    put "requested" into laUrlErrorStatus[laUrl[x]]
    if laLoadReq[laUrl[x]] then put "requested" into laUrlLoadStatus[laUrl[x]]
    ulSendCallback laUrl[x],"requested"  ##CALLBACK FEATURE
  end if
  -------------------------------------
  
  ##blocking point ACTIVE??
  if laMode[laUrl[x]] is "active" then
    repeat while  laFtpDataDone[laUrl[x]] is empty and laStatus[laUrl[x]] is empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
  end if
  
  ##blocking point PASSIVE??
  if laMode[laUrl[x]] is not "active" then
    read from socket laTransPasvIP[laUrl[x]]  with message "ulGetData"
    repeat while  laFtpDataDone[laUrl[x]] is empty and laStatus[laUrl[x]] is empty
      if lvJumpOut then exit to top
      wait for messages
    end repeat
  end if
  
  if laStatus[laUrl[x]] is not empty then ##error occurred
    if  laUrlErrorStatus[laUrl[x]] is empty then
      put "error" into laUrlErrorStatus[laUrl[x]]
    end if
    if laLoadReq[laUrl[x]] then
      put "error" into laUrlLoadStatus[laUrl[x]]
      delete local laLoadedUrls[laUrl[x]] ##clear data
    else
      delete local laData[laUrl[x]] ##clear data
    end if
    close socket x
    delete local laSocketUser[x]
  else
    #now check for 226 completion
    put ulFtpWaitResponse(x) into tReply
    if word 1 of tReply <> 226 then
      replace "ftperr," with empty in tReply
      put "error" && tReply into laUrlErrorStatus[laUrl[x]]
      put empty into laData[laUrl[x]] ##clear data
      if laLoadReq[laUrl[x]] then
        put "error" into laUrlLoadStatus[laUrl[x]]
        delete local laLoadedurls[laUrl[x]] ##don't need anymore
      end if
      close socket x
      delete local laSocketUser[x]
    else ##download successful
      if tNeedCWDReset then
        ##051202 reset current directory to original
        put "CWD " & laHome[laUrl[x]] into tCmd
        put ulFtpCommand(tCmd,x) into tReply
        if not ulFtpGoodReply(tReply, tCmd) then
          ulFtpSetError x,tReply
          close socket x
          delete local laSocketUser[x]
          exit "ulFtpGet"
        end if
      end if
      
      put empty into laUrlErrorStatus[laUrl[x]]
      if laFile[laUrl[x]] is empty then
        put "cached" into tStatus
      else
        put "downloaded" into tStatus
      end if
      if laLoadReq[laUrl[x]] then put tStatus into laUrlLoadStatus[laUrl[x]]
      ulSendCallback laUrl[x],"downloaded"  ##CALLBACK FEATURE
      
      
    end if
    put true into laStatus[laUrl[x]] ##break wait
  end if
end ulFtpGet
############get data port from ftp server-answer to PASV##############

on ulTransferPassive x
  set the itemDel to "|"
  put last item of x into y
  set the itemDel to comma
  
  put "PASV"  into tCmd
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    ulFtpSetError x,tReply
    exit "ulTransferPassive"
  end if
  
  if last char of tReply is "." then delete last char of tReply
  replace ")" with empty in tReply
  set the itemDel to "("
  put item 2 of tReply  into n1
  set itemDel to ","
  put item 1 to 4 of n1 into  transPasvIP
  replace "," with "." in transPasvIP
  put (item -2 of n1)*256  into a1
  put item  -1 of n1 into a2
  put a1+a2  into tPort
  
  put transPasvIP  & ":" & tPort & "|" & y into laTransPasvIP[laUrl[x]]
  get ulOpenSocket(laTransPasvIP[laUrl[x]])
  if not it then
    put "error Couldn't open passive transfer connection" into tErr
    ulFtpSetError x,tErr
    exit "ulTransferPassive"
  end if
  put x into laControlXDataMap[laTransPasvIP[laUrl[x]]] ##
end ulTransferPassive
------------------------------------------
####################Send port to server for Active transfer and listen for data###############
on ulTransferActive x
  if lvDataPortCount is empty or lvDataPortCount >= 65535  then
    ##put 49152 into lvDataPortCount
    put 6923 into lvDataPortCount
  else
    add 1 to lvDataPortCount
  end if
  set the itemDel to "|"
  put last item of x into y
  set the itemDel to comma
  
  put x into laControlXLocalMap[lvDataPortCount]
  put hostAddress(x) into thisIP
  replace "." with "," in thisIP
  
  put lvDataPortCount into laTransActvIP[x]
  if laAction[laUrl[x]] is "putData"  then
    accept connections on port  laTransActvIP[x]  with message "ulPortMessageSend"
  else
    accept connections on port  laTransActvIP[x]  with message "ulPortMessageGet"
  end if
  if the result <> empty then
    put "error Couldn't open transfer port" into tErr
    ulFtpSetError x,tErr
    exit "ulTransferActive"
  end if
  
  put  laTransActvIP[x] div 256 into i1
  put  laTransActvIP[x]  mod 256 into i2
  
  put "PORT " & thisIP & "," & i1&","& i2  into tCmd
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    ulFtpSetError x,tReply
    exit "ulTransferActive"
  end if
end ulTransferActive
------------------------------------------
on ulPortMessageGet x,y
  ##active transfer message received
  put laControlXLocalMap[y] into tControlSock
  put tControlSock into laControlXDataMap[x]
  if x is among the lines of the openSockets then
    read from socket x with message "ulGetData"
    if the result <> empty then
      put the result into tReply
      ulFtpSetError tControlSock,tReply
    end if
  end if
end ulPortMessageGet

#################the ftp download routine##################
on ulGetData x,y
  put laControlXDataMap[x] into mSock
  ulStoreData laUrl[mSock],y
  add length(y) to laReadBytes[laUrl[mSock]]
  put "loading," & laReadBytes[laUrl[mSock]] & "," & laLength[laUrl[mSock]]  into tStatusString
  put tStatusString into laUrlErrorStatus[laUrl[mSock]]
  if laLoadReq[laUrl[mSock]] then put tStatusString into laUrlLoadStatus[laUrl[mSock]]
  ulSendCallback laUrl[mSock],tStatusString  ##CALLBACK FEATURE
  if x is among the lines of the openSockets then
    read from socket x with message "ulGetData"
    if the result <> empty then
      put false into laStatus[laUrl[mSock]]
    end if
  end if
end ulGetData

##############FTP PUT #########################

on ulFtpSend x,z
  if lvFtpMode is "active" then
    put "active" into laMode[laUrl[x]]
  else
    put "passive" into laMode[laUrl[x]]
  end if
  
  set the itemDel to "|";put last item of z into y
  set the itemDel to comma
  put "contacted" into laUrlErrorStatus[laUrl[x]]
  if laLoadReq[laUrl[x]] then put "contacted" into laUrlLoadStatus[laUrl[x]]
  ulSendCallback laUrl[x],"contacted"  ##CALLBACK FEATURE
  ----------------------------------------------------------------------
  ##sort out file path
  if laHome[laUrl[x]] is not "/" then ##otherwise laFileName should already be OK
    if laHome[laUrl[x]] is not char 1 to length(laHome[laUrl[x]]) of laLongFileName[laUrl[x]] then
      put laHome[laUrl[x]] before laLongFileName[laUrl[x]]
    end if
  end if
  
  ## check for valid filename
  if last char of laLongFileName[laUrl[x]] is  "/" or laLongFileName[laUrl[x]] is empty then
    put "File not specified" into tErr
    ulFtpSetError x,tErr
    exit "ulFtpSend"
  end if
  
  ### CWD to directory if it exists
  put false into tNeedCWDReset
  set the itemDel to "/"
  put laLongFileName[laUrl[x]] into tTempPath
  put empty into item -1 of tTempPath
  if tTempPath <> laHome[laUrl[x]] then
    delete char -1 of tTempPath
    put "CWD " & tTempPath into tCmd
    put true into tNeedCWDReset
    
    put ulFtpCommand(tCmd,x) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      ulMakeDirectory x,tTempPath,1 ##1 = first try
      if the result <> empty then
        ulFtpSetError x,the result
        exit "ulFtpSend"
      end if
    end if
  end if
  
  if tNeedCWDReset then ##RESET working directory
    
    put "CWD " & laHome[laUrl[x]] into tCmd
    put ulFtpCommand(tCmd,x) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      ulFtpSetError x,tReply
      close socket x
      delete local laSocketUser[x]
      exit "ulFtpSend"
    end if
  end if
  
  ----------------------------------------------------------------------
  put "TYPE I" into tCmd
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    ulFtpSetError x,tReply
    exit "ulFtpSend"
  end if
  
  if laFile[laUrl[x]] is empty then
    put length(laPostData[laUrl[x]]) into laLength[laUrl[x]]
  else
    put ulFileLength(laFile[laUrl[x]]) into laLength[laUrl[x]]
  end if
  put empty into laWriteBytes[laUrl[x]]
  put empty into laFtpDataDone[laUrl[x]] ##used below to control exit from ulFtpSend
  if laMode[laUrl[x]] is "active" then
    ulTransferActive x
  else
    ulTransferPassive x
  end if
  if laStatus[laUrl[x]] is not empty then ##couldn't make data connection
    exit "ulFtpSend"
  end if
  
  put "STOR "  & laLongFileName[laUrl[x]] into tCmd
  
  
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    ulFtpSetError x,tReply
    exit "ulFtpSend"
  end if
  put "requested" into laUrlErrorStatus[laUrl[x]]
  if laLoadReq[laUrl[x]] then put "requested" into laUrlLoadStatus[laUrl[x]]
  ulSendCallback laUrl[x],"requested"  ##CALLBACK FEATURE
  
  ##Block here while sending data
  if laMode[laUrl[x]] is not "active" then ulSendDataP x
  repeat while laFtpDataDone[laUrl[x]] is empty and laStatus[laUrl[x]] is empty##waiting for write to complete
    if lvJumpOut then exit to top
    wait for messages
  end repeat
  if laStatus[laUrl[x]] <> empty then ##error occurred
    if  laUrlErrorStatus[laUrl[x]] is empty then
      put "error" into laUrlErrorStatus[laUrl[x]]
    end if
    put empty into laData[laUrl[x]] ##clear data
    if laLoadReq[laUrl[x]] then
      put "error" into laUrlLoadStatus[laUrl[x]]
      delete local laData[laUrl[x]] ##clear data
    end if
    close socket x
    delete local laSocketUser[x]
  else
    ##look for 226 response
    put ulFtpWaitResponse(x) into tReply
    if word 1 of tReply <> 226 then
      replace "ftperr," with empty in tReply
      put "error" && tReply into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then
        put "error" into laUrlLoadStatus[laUrl[x]]
        delete local laData[laUrl[x]] ##clear data
      end if
      close socket x
      delete local laSocketUser[x]
    else
      put empty into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then
        put "uploaded" into laUrlLoadStatus[laUrl[x]]
        delete local laData[laUrl[x]] ##clear data
      end if
      ulSendCallback laUrl[x],"uploaded"  ##CALLBACK FEATURE
    end if
    put true into laStatus[laUrl[x]]
  end if
  
end ulFtpSend
--------------------------------------------
on ulMakeDirectory x, pDir
  
  -- first we CWD to the parent directory
  set the itemDel to "/"
  put pDir into tTempPath
  delete item -1 of tTempPath ##parent directory
  if tTempPath is empty then put "/" into tTempPath  ## root directory
  put empty into lvNeedDir
  
  put "CWD " & tTempPath into tCmd
  
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    if tTempPath = laHome[laUrl[x]] then
      return "error Unable to create directory path"
    else
      ulMakeDirectory x,tTempPath
      if the result <> empty then
        return the result
      end if
    end if
  end if
  
  put "MKD " & pDir into tCmd
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    return "error Unable to create directory path"
  else  ##now CWD to the created directory
    put "CWD " & pDir into tCmd
    put ulFtpCommand(tCmd,x) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      return tReply
    else
      return empty
    end if
  end if
  
end ulMakeDirectory

############ACTIVE UPLOAD############
on ulPortMessageSend x,y
  ##active transfer message received
  put laControlXLocalMap[y] into tControlSock
  put tControlSock into laControlXDataMap[x]
  put ulNextData(laUrl[tControlSock]) into nData
  
  if nData <> empty then
    add length(nData) to laWriteBytes[laUrl[tControlSock]]
    put "uploading, " & laWriteBytes[laUrl[tControlSock]] & "," & laLength[laUrl[tControlSock]] into tStatusString
    put tStatusString into laUrlErrorStatus[laUrl[tControlSock]]
    
    write nData to  socket x  with  message "ulWriteMoreA"
    if the result <> empty then
      put "error" && the result into laUrlErrorStatus[laUrl[tControlSock]]
      if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[tControlSock]]
      put false into laStatus[laUrl[tControlSock]]
    end if
  else
    put false into laStatus[laUrl[tControlSock]]
  end if
  
end ulPortMessageSend
-------------------------------------------

on ulWriteMoreA x
  put laControlXDataMap[x] into tId
  
  put ulNextData(laUrl[tId]) into nData
  if nData <> empty then
    add length(nData) to laWriteBytes[laUrl[tId]]
    put "uploading," & laWriteBytes[laUrl[tId]] & "," & laLength[laUrl[tId]] into tStatusString
    put tStatusString into laUrlErrorStatus[laUrl[tId]]
    if laLoadReq[laUrl[tId]] then put tStatusString into laUrlLoadStatus[laUrl[tId]]
    ulSendCallback laUrl[tId],tStatusString  ##CALLBACK FEATURE
    write nData to  socket x  with message "ulWriteMoreA"
    if the result <> empty then
      put false into laStatus[laUrl[tId]]
    end if
  else
    put true into laFtpDataDone[laUrl[tId]]
    
    put empty into laUrlErrorStatus[laUrl[tId]]
    close socket x
    close socket laTransActvIP[tID]  ##local port
    delete local laControlXDataMap[x]
  end if
  
end ulWriteMoreA

##########PASSIVE UPLOAD############

on ulSendDataP x
  put ulNextData(laUrl[x]) into nData
  if nData <> empty then
    add length(nData) to laWriteBytes[laUrl[x]]
    put "uploading," &  laWriteBytes[laUrl[x]] & "," & laLength[laUrl[x]] into tStatusString
    put tStatusString into laUrlErrorStatus[laUrl[x]]
    write nData to  socket laTransPasvIP[laUrl[x]]  with  message "ulWriteMoreP"
    if the result <> empty then
      put false into laStatus[laUrl[x]]
    end if
  else
    put false into laStatus[laUrl[x]]
  end if
end ulSendDataP
---------------------------------------------------------------------
on ulWriteMoreP x
  put laControlXDataMap[x] into mSock
  put ulNextData(laUrl[mSock]) into nData
  if nData <> empty then
    add length(nData) to laWriteBytes[laUrl[mSock]]
    put "uploading, " & laWriteBytes[laUrl[mSock]] & "," & laLength[laUrl[mSock]]  into tStatusString
    put tStatusString into laUrlErrorStatus[laUrl[mSock]]
    if laLoadReq[laUrl[mSock]] then put tStatusString into laUrlLoadStatus[laUrl[mSock]]
    ulSendCallback laUrl[mSock],tStatusString  ##CALLBACK FEATURE
    if laStatus[laUrl[mSock]] is empty then
      write nData to  socket x  with message "ulWriteMoreP"
    end if
    if the result <> empty then
      put false into laStatus[laUrl[mSock]]
    end if
  else
    close socket x ##close data socket here
    delete local laControlXDataMap[x]
    put empty into laUrlErrorStatus[laUrl[mSock]]
    put true into laFtpDataDone[laUrl[mSock]] #set flag before closing socket
    
  end if
end ulWriteMoreP

####################FTP DELETE################

on ulFtpDelete x
  ###########make sure we use the full path
  ##sort out file path
  if laHome[laUrl[x]] is not "/" then ##otherwise laFileName should already be OK
    if laHome[laUrl[x]] is not char 1 to length(laHome[laUrl[x]]) of laLongFileName[laUrl[x]] then
      put laHome[laUrl[x]] before laLongFileName[laUrl[x]]
    end if
  end if
  
  if last char of laLongFileName[laUrl[x]] is "/" then
    #delete directory
    put "RMD "  &  laLongFileName[laUrl[x]] into tCmd
    put "directory" into mType
  else
    #delete file
    put "DELE "  &  laLongFileName[laUrl[x]] into tCmd
    put "file" into mType
  end if
  
  put ulFtpCommand(tCmd,x) into tReply
  if not ulFtpGoodReply(tReply, tCmd) then
    replace "ftpErr," with empty in tReply
    put "error" && tReply into laUrlErrorStatus[laUrl[x]]
  else
    put empty into laUrlErrorStatus[laUrl[x]]
  end if
  put true into laStatus[laUrl[x]]
end ulFtpDelete

#########################################################
on socketClosed x
  ulLogIt "CLOSED" && x & cr##LOG
  delete local laSocketUser[x] ##reference for allocating sockets for FTP logons
  ##need to check whether ftp data port or not
  if x is among the lines of keys(lvSocketToken) then ##trying to open a socket
    put "socket closed" into lvSocketToken[x]
    
  else  if x is lvFtpCommandSocket then ##handling libUrlFtpCommand
    if x is among the lines of keys(laFTPCommandStatus) then ##may be waiting for a server reply
      put "socket closed" into laFTPCommandStatus[x] ##unblock waits
    end if
  else if x is among the lines of keys(laUrl) then ##http or ftp control socket
    ## check for two situations here
    ## first is a premature close on a socket when we know the data length
    ## second is for cases when we don't know the data length
    ## a normal close when we  know the data length isn't handled here
    if laLength[laUrl[x]] > laReadBytes[laUrl[x]] then ##fixed dc 250103
      put "Socket closed before end of file" into laUrlErrorStatus[laUrl[x]]
      if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
      put "false" into laStatus[laUrl[x]] ##unblock waits
      if x is among the lines of keys(laFTPCommandStatus) then ##may be waiting for a server reply
        put "socket closed" into laFTPCommandStatus[x] ##unblock waits
      end if
    else if laLength[laUrl[x]] is empty and char 1 to 4 of laUrl[x] is "http" then ##when we don't have a length
      if  laStatus[laUrl[x]] is empty then ##assume download completed
        put empty into laUrlErrorStatus[laUrl[x]]
      end if
      put true into  laStatus[laUrl[x]] ##unblock waits
      put "true" into  laHttpDataDone[laUrl[x]] ##unblock waits
    end if
    
  else if x is among the lines of keys(laControlXDataMap)then##must be ftp remote data socket
    put laControlXDataMap[x] into tControlSocket
    put true into laFtpDataDone[laUrl[tControlSocket]]
    if laTransActvIP[tControlSocket] is among the lines of the openSockets then
      close socket laTransActvIP[tControlSocket] ##local data port during active transfers
    end if
    delete local laControlXDataMap[x]
    
  end if
end socketClosed
-------------------------------------------
##SocketTimeout defaults to 10000 milliseconds.
##To change that one can set the "socketTimeoutInterval" to a different value.

on socketTimeout x
  ulLogit "socket timeout" && x & cr ##LOG
  ##need to check whether data port or not
  if x is among the lines of keys(lvSocketToken) then ##trying to open a socket
    put "socket timeout" into lvSocketToken[x]
    delete local laSocketUser[x]
  else if x is lvFtpCommandSocket then ##handling libUrlFtpCommand
    if x is among the lines of keys(laFTPCommandStatus) then ##may be waiting for a server reply
      put "socket timeout" into laFTPCommandStatus[x] ##unblock waits
    end if
  else if x is among the lines of keys(laUrl) then ##http or ftp control socket
    if laLoadReq[laUrl[x]] then put "timeout" into laUrlLoadStatus[laUrl[x]]
    put "socket timeout" && x into laUrlErrorStatus[laUrl[x]]
    put "false" into laStatus[laUrl[x]] ##unblock waits
    if x is among the lines of keys(laFTPCommandStatus) then ##may be waiting for a server reply
      put "socket timeout" into laFTPCommandStatus[x] ##unblock waits
    end if
    close socket x
    delete local laSocketUser[x]
  else if x is among the lines of keys(laControlXDataMap)then##must be ftp remote data socket
    put laControlXDataMap[x] into tControlSocket
    put false into laStatus[laUrl[tControlSocket]] ##unblock waits
    put "socket timeout" into laFTPCommandStatus[tControlSocket]
    if laLoadReq[laUrl[x]] then put "timeout" into laUrlLoadStatus[laUrl[tControlSocket]]
    put "socket timeout" && x into laUrlErrorStatus[laUrl[tControlSocket]]
  else if x is a number then##local port for active ftp transfer
    put laControlXLocalMap[x] into tControlSocket
    if tControlSocket <> empty then
      put false into laStatus[laUrl[tControlSocket]] ##unblock waits
      put "socket timeout" into laFTPCommandStatus[tControlSocket]
      if laLoadReq[laUrl[tControlSocket]] then put "timeout" into laUrlLoadStatus[laUrl[tControlSocket]]
      put "socket timeout" && x into laUrlErrorStatus[laUrl[tControlSocket]]
    end if
  end if
  
end socketTimeout
--------------------------------------------
on socketError x, pErr
  ulLogit "socket error" && x & cr & pErr & cr ##LOG
  ##need to check whether data port or not
  if pErr is empty then put "unknown error" into pErr
  if x is among the lines of keys(lvSocketToken) then ##trying to open a socket
    put pErr into lvSocketToken[x]
    
  else  if x is lvFtpCommandSocket then ##handling libUrlFtpCommand
    if x is among the lines of keys(laFTPCommandStatus) then ##may be waiting for a server reply
      put "socket error" into laFTPCommandStatus[x] ##unblock waits
    end if
  else if x is among the lines of keys(laUrl) then ##http or ftp control socket
    if laLoadReq[laUrl[x]] then put "error" into laUrlLoadStatus[laUrl[x]]
    put "error" && pErr into laUrlErrorStatus[laUrl[x]]
    put "false" into laStatus[laUrl[x]] ##unblock waits
    if x is among the lines of keys(laFTPCommandStatus) then ##may be waiting for a server reply
      put pErr into laFTPCommandStatus[x] ##unblock waits
    end if
  else if x is among the lines of keys(laControlXDataMap)then##must be ftp passive data socket
    put laControlXDataMap[x] into tControlSocket
    put false into laStatus[laUrl[tControlSocket]] ##unblock waits
    put pErr into laFTPCommandStatus[tControlSocket]
    if laLoadReq[laUrl[tControlSocket]] then put "error" into laUrlLoadStatus[laUrl[tControlSocket]]
    put "error" && pErr into laUrlErrorStatus[laUrl[tControlSocket]]
    
  else if x is a number then##local port for active ftp transfer
    put laControlXLocalMap[x] into tControlSocket
    if tControlSocket <> empty then
      put false into laStatus[laUrl[tControlSocket]] ##unblock waits
      put pErr into laFTPCommandStatus[tControlSocket]
      if laLoadReq[laUrl[tControlSocket]] then put "error" into laUrlLoadStatus[laUrl[tControlSocket]]
      put "error" && pErr into laUrlErrorStatus[laUrl[tControlSocket]]
    end if
    
  end if
end socketError
----------------------------------------------
on libUrlResetAll
  if there is a stack "libUrl" then put empty into fld "log1" of stack "libURL"
  repeat for each line i in the openSockets
    close socket i
  end repeat
  ulDeleteLocals
  put true into lvJumpOut
  send "ulDeleteLocals" to me in 5 milliseconds
end libUrlResetAll
--------------------------------------------
on ulDeleteLocals
  repeat for each item e in line 3 of the localNames
    get "delete" && "local" && e
    do it
  end repeat
end ulDeleteLocals
----------------------------------------------
on resetAll
  ## included for compatibility with previous versions
  ##ibUrlResetAll should be used instead
  libUrlResetAll
end resetAll
-----------------------------------------------
on ulFtpStopWatch x
  if x is among the lines of the OpenSockets then
    if lvFtpStopTime is empty or lvFtpStopTime is not a number then
      put 15 into lvFtpStopTime
    end if
    switch
    case laStopSec[x] >= lvFtpStopTime
      delete local laStopSec[x]
      delete local laStopUnit[x]
      put  "QUIT" into tCmd
      get ulFtpCommand(tCmd,x)
      delete local laFtpCommandStatus[x]
      # write "QUIT" & CRLF to socket x ##tidy finish
      close socket x
      delete local laSocketUser[x]
      break
    case  laStopUnit[x]=1
      add laStopUnit[x] to laStopSec[x]
      send "ulFtpStopWatch " & x to me in 1 sec
      break
    case laStopUnit[x] = 0
      break
    end switch
  else
    delete local laStopSec[x]
    delete local laStopUnit[x]
  end if
end ulFtpStopWatch
----------------------------------------------
on libUrlFtpUpload pData,pUrl,pMessage
  put false into lvJumpOut
  put ulStripUrl(pUrl) into newUrl
  if char 1 to 3 of newUrl <> "ftp" then
    return "invalid url"
  end if
  if lvCount is empty then
    put "6923" into lvCount
  else
    #add 1 to lvCount
  end if
  switch
  case newUrl is among the lines of  the keys of laLoadingUrls
    ##don't allow loads if the same url is waiting to load
    return "error  URL is currently loading" with empty
    break
  default
    put pData into laPostData[newUrl]
    if pMessage <> empty then
      put the long id of the target &","& pMessage into laMessg[newUrl]
    end if
    put true into laLoadReq[newUrl]
    put 1 into laLoadingUrls[newUrl] #for tracking
    put "putData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    put empty into laUrlLoadStatus[newUrl]
    put empty into laData[newUrl]
    ulGetFormat newUrl,lvCount
    if laUrlLoadStatus[newUrl] is "error" and not laCancelled[newUrl] then
      ulSendMessage newUrl ##send message now only if error occurred
      return "error"
    else if laCancelled[newUrl] then
      ##user cancelled after starting but before blocking point
      delete local laLoadedUrls[newUrl]
      delete local laUrlLoadStatus[newUrl]
      delete local laUrlErrorStatus[newUrl]
      delete local laStatus[newUrl]
      delete local laCancelled[newUrl]
      
    else
      return empty
    end if
    break
  end switch
end libUrlFtpUpload
----------------------------------------------
on libUrlFtpUploadFile pFile,pUrl,pMessage
  put false into lvJumpOut
  put ulStripUrl(pUrl) into newUrl
  if char 1 to 3 of newUrl <> "ftp" then
    return "invalid url"
  end if
  open file pFile for binary read
  if the result is not empty then
    return the result
  end if
  put newUrl into laUrlByFile[pFile]
  
  if lvCount is empty then
    put "6923" into lvCount
  else
    #add 1 to lvCount
  end if
  switch
  case newUrl is among the lines of  the keys of laLoadingUrls
    ##don't allow loads if the same url is waiting to load
    return "error  URL is currently loading" with empty
    break
    #case newUrl is not among the lines of  the keys of laLoadedUrls OR laUrlLoadStatus[newUrl] is not "cached"
  default
    
    if pMessage <> empty then
      put the long id of the target &","& pMessage into laMessg[newUrl]
    end if
    put true into laLoadReq[newUrl]
    put pFile into laFile[newUrl]
    put 1 into laLoadingUrls[newUrl] #for tracking
    put "putData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    put empty into laUrlLoadStatus[newUrl]
    #put empty into laData[newUrl]
    ulGetFormat newUrl,lvCount
    if laUrlLoadStatus[newUrl] is "error" and not laCancelled[newUrl] then
      ulSendMessage newUrl ##send message now only if error occurred
      return "error"
    else if laCancelled[newUrl] then
      ##user cancelled after starting but before blocking point
      delete local laLoadedUrls[newUrl]
      delete local laUrlLoadStatus[newUrl]
      delete local laUrlErrorStatus[newUrl]
      delete local laStatus[newUrl]
      delete local laCancelled[newUrl]
      
    else
      return empty
    end if
    break
  end switch
end libUrlFtpUploadFile

-----------------------------------------------
on libUrlDownloadToFile pUrl,pFile,pMessage
  put false into lvJumpOut
  put ulStripUrl(pUrl) into newUrl
  open file pFile for binary write
  if the result is not empty then
    return the result
  end if
  if lvCount is empty then
    put "6923" into lvCount
  else
    #add 1 to lvCount
  end if
  switch
  case newUrl is among the lines of  the keys of laLoadingUrls
    ##don't allow loads if the same url is waiting to load
    return "error  URL is currently loading" with empty
    break
    #case newUrl is not among the lines of  the keys of laLoadedUrls OR laUrlLoadStatus[newUrl] is not "cached"
  default
    if pMessage <> empty then
      put the long id of the target &","& pMessage into laMessg[newUrl]
    end if
    put true into laLoadReq[newUrl]
    put pFile into laFile[newUrl]
    put 1 into laLoadingUrls[newUrl] #for tracking
    put "getData" into laAction[newUrl]
    put empty into laUrlErrorStatus[newUrl]
    put empty into laUrlLoadStatus[newUrl]
    
    ulGetFormat newUrl,lvCount
    
    if laUrlLoadStatus[newUrl] is "error" and not laCancelled[newUrl] then
      ulSendMessage newUrl ##send message now only if error occurred
      return "error"
    else if laCancelled[newUrl] then
      ##user cancelled after starting but before blocking point
      delete local laLoadedUrls[newUrl]
      delete local laUrlLoadStatus[newUrl]
      delete local laUrlErrorStatus[newUrl]
      delete local laStatus[newUrl]
      delete local laCancelled[newUrl]
      
    else
      return empty
    end if
    break
  end switch
end libUrlDownloadToFile

-----------------------------------------------
function libUrlErrorData pUrl
  return laUrlErrorStatus[pUrl]
end libUrlErrorData
-----------------------------------------------
on libUrlSetFtpMode pMode
  ##default to passive
  if pMode is "active" or pMode is "a" then
    put "active" into lvFtpMode
  else
    put "passive" into lvFtpMode
  end if
end libUrlSetFtpMode

----------------------------
on libUrlSetFtpListCommand pCommand
  if pCommand is "NLST" then
    put "NLST" into lvFtpListCommand
  else
    put "LIST" into lvFtpListCommand
  end if
end libUrlSetFtpListCommand
-----------------------------
function libUrlVersion
  return the cVersion of me
end libUrlVersion
------------------------------
on libUrlSetLogField pField
  if word 1 of pField is "field" then
    put pField into tField
  else
    if pField is a number then
      put "field" && pField into tField
    else
      if word 1 of pField is "id" then
        put "field" && pField into tField
      else
        put "field" && quote & pField & quote into tField
      end if
    end if
  end if
  if exists(tField) then
    put the long ID of tField into tField##standardise
    put tField into lvLogField
  else
    put empty into lvLogField
  end if
end libUrlSetLogField
---------------------------
on libUrlSetStatusCallback pMessage,pObject
  ##pObject must be a long ID
  if pMessage <> empty and exists(pObject)  then
    put pMessage & comma & pObject into lvStatusCallback
  else
    put empty into lvStatusCallback
  end if
end libUrlSetStatusCallback
---------------------------
function libUrlLastHttpHeaders
  return the lastHttpHeaders of me
end libUrlLastHttpHeaders
--------------------------
on libUrlSetCustomHttpHeaders pHeaders
  set the customHTTPHeaders of me to pHeaders
end libUrlSetCustomHttpHeaders
---------------------------
function libUrlLastRhHeaders
  return the lastRhHeaders of me
end libUrlLastRhHeaders
----------------------------
on libUrlSetFtpStopTime pSecs
  if pSecs is empty or pSecs < 1 or pSecs is not a number then
    put 15 into lvFtpStopTime
  else
    put pSecs into lvFtpStopTime
  end if
end libUrlSetFtpStopTime
---------------------------
on ulSendMessage pUrl
  ##send any requested message on completion
  if laMessg[pUrl] is not empty then
    if item 2 of laMessg[pUrl] is not quote & "" & quote  then
      put item 1 of laMessg[pUrl] into xmessg
      put item 2 of laMessg[pUrl] into omessg
      replace quote with empty in omessg
      send omessg && quote & pUrl & quote & "," & laUrlLoadStatus[pUrl]  to xmessg in 0 milliseconds
    end if
  end if
  delete local laMessg[pUrl]
end ulSendMessage
----------------------------
on ulSendCallback pUrl, pStatus
  if lvStatusCallback is empty then exit ulSendCallback
  put item 1 of lvStatusCallback into tMessage
  put item 2 of lvStatusCallback into tObject
  if exists(tObject) then
    #put laUrlErrorStatus[pUrl] into tStatus
    send tMessage &&  quote & pUrl & quote & comma & quote & pStatus & quote to tObject in 0 milliseconds
  end if
end ulSendCallback
-----------------------------
function ulFileLength pFile
  if there is a file pFile then
    put the directory into tSavedDir
    put pFile into tDir
    set the itemDel to "/"
    put item -1 of pFile into tFileName
    delete item -1 of tDir
    set the directory to tDir
    put the detailed files into tFileData
    set the directory to tSavedDir
    set the itemDel to comma
    split tFileData by cr and ","
    return item 1 of tFileData[urlEncode(tFileName)]
  else
    return "no file"
  end if
end ulFileLength
------------------------------
on ulLogIt pMessage
  if exists(lvLogField) then
    put "put pMessage after fld" && word 2 to -1 of lvLogField into tExp
    do tExp
  end if
end ulLogIt
-------------------------------
on ulStartTickle
  ## safeguard against possible hangs in "wait for messages" loops
  if lvTickle is empty then
    put true into lvTickle
    send "ulTickleMe" to me in 1 seconds
  end if
end ulStartTickle
--------------------------
on ulTickleMe
  ## safeguard against possible hangs in "wait for messages" loops
  if the openSockets <> empty then
    send "ulTickleMe" to me in 1 seconds
  else
    put empty into lvTickle
  end if
end ulTickleMe
---------------------------
function isIPNumber pHost
  replace "." with empty in pHost
  replace ":" with empty in pHost
  replace "|" with empty in pHost
  return pHost is a number
end isIPNumber
----------------------------
on ulCleanUpHttp x #x is socket
  put laLoadReq[laUrl[x]] into tlLoadReq ##holder
  put laConnectHost[laUrl[x]] into tConnectHost
  ulCleanUpHttpLocals laUrl[x] ## remove url referenced locals
  delete local laLoadReq[laUrl[x]] ##OK here??
  ##delete socket referenced locals
  
  put laUrl[x] into tempUrl
  delete local laUrl[x]
  
  --prepare for next request
  if tlLoadReq then
    delete local laLoadingUrls[tempUrl]
    ## delete line 1 of laLoadQ[tConnectHost] ##commented out for 1.0.8r4 -- now done in ulNextHttpLoadRequest
    if the number of lines of laLoadQ[tConnectHost] = 0 then
      delete local laLoadQ[tConnectHost] ##important
      delete local laConnectID[tConnectHost]
    end if
  end if
end ulCleanUpHttp
-------------------------
on ulCleanUpHttpLocals pUrl
  ##crude clean up
  delete local laLength[pUrl]
  delete local laConnectHost[pUrl]
  delete local laAuth[pUrl]
  delete local laUser[pUrl]
  delete local laPasswd[pUrl]
  delete local laHost[pUrl]
  delete local laLongFileName[pUrl]
  delete local laLineNum[pUrl]
  delete local laTmpData[pUrl]
  delete local laTemp[pUrl]
  delete local laAction[pUrl]
  delete local laConn[pUrl]
  delete local laRhHeader[pUrl]
  delete local laNeedChunk[pUrl]
  delete local laStatusCode[pUrl]
  delete local laStatusMessage[pUrl]
  delete local laCode[pUrl]
  delete local laChunk[pUrl]
  delete local laHaveHeader[pUrl]
  delete local laHttpDataDone[pUrl]
  delete local laPostData[pUrl]
  delete local laReadBytes[pUrl]
  delete local laCurrentHttpHeaders[pUrl]
end ulCleanUpHttpLocals
------------------------------
on ulCleanUpFtp x
  put laLoadReq[laUrl[x]] into tlLoadReq ##holder
  put laConnectHost[laUrl[x]] into tConnectHost #holder
  ulCleanUpFtpLocals laUrl[x] ## remove url referenced locals
  delete local laLoadReq[laUrl[x]] ##OK here??
  
  ##close any data ports ##should be closed already, but if error occurred
  if laTransPasvIP[laUrl[x]] is among the lines of the openSockets then
    close socket laTransPasvIP[laUrl[x]]
  end if
  if laTransActvIP[x] is among the lines of the openSockets then ##local port
    close socket laTransActvIP[x]
  end if
  
  delete local  laControlXLocalMap[laTransActvIP[x]]
  delete local  laControlXDataMap[laTransPasvIP[laUrl[x]]]
  delete local laTransPasvIP[laUrl[x]]
  delete local  laTransActvIP[x]
  
  ##delete socket referenced locals
  
  put laUrl[x] into tempUrl
  delete local laUrl[x]
  delete local laFtpCommandStatus[x]
  
  --prepare for next request
  if tlLoadReq then
    delete local laLoadingUrls[tempUrl]
    -- delete line 1 of laLoadQ[tConnectHost] ##commented out for 1.0.8r4 -- now done in ulNextFtpLoadRequest
    if the number of lines of laLoadQ[tConnectHost] = 0 then
      delete local laLoadQ[tConnectHost] ##important
      delete local laConnectID[tConnectHost]
      
    end if
  end if
end ulCleanUpFtp
------------------------------
on ulCleanUpFtpLocals pUrl
  ##clean up locals
  delete local laConnectHost[pUrl]
  delete local laLength[pUrl]
  delete local laAuth[pUrl]
  delete local laUser[pUrl]
  delete local laPasswd[pUrl]
  delete local laHost[pUrl]
  delete local laLongFileName[pUrl]
  delete local laAction[pUrl]
  delete local laHome[pUrl]
  delete local laFtpDataDone[pUrl]
  delete local laMode[pUrl]
  delete local laPostData[pUrl]
  delete local laReadBytes[pUrl]
  delete local laWriteBytes[pUrl]
end ulCleanUpFtpLocals
------------------------------
on ulCancelRequest pUrl
  put true into laCancelled[pUrl]
  put "error cancelled" into tError
  ulStopRequest pUrl,tError
  
end ulCancelRequest
-----------------------------
on ulStopRequest pUrl, pErrMessage
  put keys(laUrl) into tSocketKeys##test
  repeat for each line tKey in tSocketKeys
    if laUrl[tKey] = pUrl then
      put tKey into tItsSocket
      exit repeat
    end if
  end repeat
  if tItsSocket is among the lines of the openSockets then
    put false into laStatus[pUrl] ##should cause everything to wind up cleanly
    put pErrMessage into laUrlErrorStatus[pUrl]
    put empty into laData[pUrl]
  end if
  if laLoadReq[pUrl] then
    put "error" into laUrlLoadStatus[pUrl]
    delete local laData[pUrl]
  end if
  
end ulStopRequest

-----------------------------
on ulStoreData pUrl,@pData
  if laFile[pUrl] <> empty then
    write pData to file laFile[pUrl]
    if the result is not empty then
      put "error" && the result into tErr
      ulStopRequest pUrl,tErr
    end if
  else if laLoadReq[pUrl] <> empty then
    put pData after laLoadedUrls[pUrl]
  else
    put pData after laData[pUrl]
  end if
end ulStoredata
-----------------------------
function ulNextData pUrl
  if laFile[pUrl] is empty then
    put char 1 to 4096 of laPostdata[pUrl] into tData
    delete char 1 to 4096 of laPostData[pUrl]
  else
    read from file laFile[pUrl] for 4096
    if the result <> empty and the result <> "eof" then
      put "error" && the result into tErr
      ulStopRequest pUrl,tErr
    else
      put it into tData
    end if
  end if
  return tData
end ulNextData
------------------------------
function ulStripUrl pUrl
  ## clean out any whitespace before and after url
  put space & tab & cr into tString
  repeat while char 1 of pUrl is in tString
    delete char 1 of pUrl
  end repeat
  repeat while char -1 of pUrl is in tString
    delete char -1 of pUrl
  end repeat
  return pUrl
end ulStripUrl
--------------------------------
function ul_TraceLocals ##DEBUG ROUTINE, used in development
  repeat for each item e in line 3 of the localNames
    put e & cr after tRetVal
    put "put keys(" & e & ") & cr after tRetVal" into tDoString
    do tDoString
  end repeat
  return tRetVal
end ul_TraceLocals
--------------------------------
function ulFtpCommand pCommandString, pSocket
  ##executes ftp commands
  ##returns the response from the server (or ftpErr if error occurs)
  if pSocket is not among the lines of the openSockets then
    return "ftpErr, socket not open"
  end if
  if pCommandString is empty then
    return "ftpErr, no command to send"
  end if
  put empty into laFTPCommandStatus[pSocket]
  write pCommandString & CRLF to socket pSocket
  if the result <> empty then return "ftpErr," & the result
  read from socket pSocket  for 1 line with message "ulGetFtpReply"
  if the result <> empty then return "ftpErr," & the result
  repeat while laFTPCommandStatus[pSocket] is empty
    if lvJumpOut then exit to top
    wait for messages
  end repeat
  return laFTPCommandStatus[pSocket]
end ulFTPCommand
------------------------------------
function ulFtpWaitResponse pSocket
  ##used for collecting server responses
  ##that are not in response to a direct command
  ##for example when opening a connection to the server, and when transfers complete
  put empty into laFTPCommandStatus[pSocket]
  read from socket pSocket  for 1 line with message "ulGetFtpReply"
  repeat while laFTPCommandStatus[pSocket] is empty
    if lvJumpOut then exit to top
    wait for messages
  end repeat
  return laFTPCommandStatus[pSocket]
end ulFtpWaitResponse
------------------------------------
on ulGetFtpReply pSocket,pReply
  ##reads data from the command port
  ##generally called by ulFTPCommand, but also by ulFtpWaitResponse
  ulLogIt pReply##LOG
  put line -1 of pReply into tReply ##should only be one line
  get char 1 to 3 of tReply
  if it is an integer and it >= 100 then
    put it into tReplyNum
    if char 4 of tReply <> "-" then
      put tReply into laFTPCommandStatus[pSocket]
      
    else
      read from socket pSocket for 1 line with message "ulGetFtpReply"
      if the result <> empty then
        put "ftpErr," & the result into laFTPCommandStatus[pSocket]
        
      end if
    end if
  else
    read from socket pSocket for 1 line with message "ulGetFtpReply"
    if the result <> empty then
      put "ftpErr," & the result into laFTPCommandStatus[pSocket]
      
    end if
  end if
end ulGetFtpReply
---------------------------------
function ulFtpGoodReply pReply, pCommand
  ##compares a reply code against a predetermined list
  ##of "good" reply codes for a particular command
  if item 1 of pReply is "ftpErr" then return false
  put the cFtpGoodCodes[word 1 of pCommand] of me into tGoodCodes
  if word 1 of pReply is among the items of tGoodCodes then
    return true
  else
    return false
  end if
end ulFtpGoodReply
-------------------------------------
function libUrlFtpCommand pCommand, pHost, pUser, pPass
  local tHost,tPort
  put false into lvJumpOut
  if lvCount is empty then
    put "6923" into lvCount
  end if
  
  ##separate host and port
  put "([^:]*)(.*)" into tRegEx
  if not matchText(pHost,tRegEx,tHost,tPort) then return "error Invalid host address"
  
  put tHost into tTempHost
  if tPort is empty then put ":21" into tPort
  
  ##get IP address
  replace "." with empty in tTempHost
  replace ":" with empty in tTempHost
  if tTempHost  is not a number then
    get hostnameToAddress(tHost)
    if the result is empty then
      
      put line 1 of it & tPort into tConnectHost
    else
      return "error" && the result
    end if
  else
    put tHost & tPort into tConnectHost
  end if
  
  ##set anonymous user if needed
  if pUser is empty then
    put "anonymous" into pUser
    put "guest" into pPass
  end if
  ##make dummy url to use other parts of libUrl
  put "ftp:" & pCommand into tDummyUrl
  ## make laUser and laPasswd entries
  put pUser into laUser[tDummyUrl]
  put pPass into laPasswd[tDummyUrl]
  ##make laConnectHost entry so we can use ulWhichSocket
  ##laConnectHost has format host:port|user
  put tConnectHost & "|" & pUser into laConnectHost[tDummyUrl]
  ##do we have an open socket for this user/host combination?
  put ulWhichSocket(tDummyUrl) into tSocket
  put tSocket into lvFtpCommandSocket
  ##don't need any more
  delete local laUser[tDummyUrl]
  delete local laPasswd[tDummyUrl]
  delete local laConnectHost[tDummyUrl]
  
  put ulFtpLogon(tSocket, pUser,pPass) into tLogonReply
  if tLogonReply is empty then
    put ulFtpCommand(pCommand, tSocket) into tFtpReply
    if laStopUnit[tSocket] = 0 then
      put "1" into laStopUnit[tSocket]
      send "ulFtpStopWatch " & tSocket to me in 50 milliseconds
    end if
    delete local lvFtpCommandSocket
    return tFtpReply
  else
    delete local lvFtpCommandSocket
    return tLogonReply
  end if
end libUrlFtpCommand
---------------------------

function ulFtpLogon pSocket, pUser, pPass
  put "0" into laStopUnit[pSocket]
  put "0" into laStopSec[pSocket]
  ulStartTickle ##safeguard routine
  if pSocket is not among the lines of the openSockets then
    get ulOpenSocket(pSocket)
    if not it then return it ##error opening socket
    ------------------------get server response (220)
    put ulFtpWaitResponse(pSocket) into tReply
    if not ulFtpGoodReply(tReply, "connect") then
      return tReply
    end if
    ---------------
    put "USER " & pUser into tCmd
    put ulFtpCommand(tCmd,pSocket) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      return tReply
    end if
    ----------------------
    put  "PASS " & pPass into tCmd
    put ulFtpCommand(tCmd,pSocket) into tReply
    if not ulFtpGoodReply(tReply, tCmd) then
      return tReply
    end if
  end if
  return empty
end ulFtpLogon
------------------------------
###########################################
######socket opening routines##################
###########################################
---------------------------------------------------------------
function ulOpenSocket x
  put empty into lvSocketToken[x]
  put the milliseconds into lvSocketOpenStart[x]
  open socket to x with message "ulGotSocket"
  if the result is not empty then
    return the result
  end if
  send "ulSocketTimeout" && x to me in 500 milliseconds
  put the result into lvSocketOpenMessageID[x]
  
  repeat until lvSocketToken[x] is not empty
    if lvJumpOut then exit to top
    wait for messages
  end repeat
  cancel lvSocketOpenMessageID[x]
  delete local lvSocketOpenStart[x]
  delete local lvSocketOpenMessageID[x]
  put lvSocketToken[x] into tSocketToken ##swap out so we can delete persistent local
  delete local lvSocketToken[x]
  if not tSocketToken then
    if x is among the lines of the openSockets then
      close socket x
    end if
  end if
  return tSocketToken
end ulOpenSocket
-------------------------------------------------
on ulGotSocket x
  put true into lvSocketToken[x]
end ulGotSocket
------------------------------------------------
on ulSocketTimeout x
  if the milliseconds - lvSocketOpenStart[x] > the socketTimeoutInterval then
    put "timeout" into lvSocketToken[x]
  else
    send "ulSocketTimeout" && x to me in 500 milliseconds
    put the result into lvSocketOpenMessageID[x]
  end if
end ulSocketTimeout
              '  U   @U 
Helvetica   U 
Helvetica  @U    W   @W    U Arial   W Arial   U    U    W   @U   @U   @W    W   @U    U    U Arial   W Arial   U 
Helvetica  
 U   
 W   U   AU    U arial  
 U arial   U arial  
@U    U Geneva   U Geneva  @U Geneva  @W Geneva   U 
helvetica   U 
helvetica   W 
helvetica   U 
helvetica   W 
helvetica   W 
helvetica  U 
helvetica  cFtpGoodCodes    PASV  227SIZE  213PWD  257LIST  125,150MKD  257PORT  200CWD  250transferComplete  226STOR  125,150NLST  125,150Connect  220DELE  250RMD  250MODE  200USER  230,331TYPE  200QUIT  221ABOR  225,226RETR  125,150PASS  230,202      	P on resizeStack
  get the rect of this card
  add 8 to item 1 of it
  add 48 to item 2 of it
  subtract 8 from item 3 of it
  subtract 8 from item 4 of it
  set the rect of field 1 to it
  set the right of button 2 to item 3 of it
end resizeStack
           %Q      `  a    	P on preOpenCard
  resizeStack
end preOpenCard

on resizeStack
  get the rect of this card
  add 8 to item 1 of it
  add 8 to item 2 of it
  subtract 8 from item 3 of it
  subtract 8 from item 4 of it
  set the rect of field 1 to it
end resizeStack
           %Q  b   Reset Ep #on mouseUp
  resetAll
end mouseUp
                    @          	     
   log1  )j           0            \    	`       1   [    	a       	4    ` Help Ep "on mouseUp
  go next
end mouseUp
          @          	     
  b   	p "on mouseUp
  go next
end mouseUp
         A       a 	 	 		    
			LibUrl 		 
   "      		  LibUrl is the script library used by Revolution and Metacard to implement the Transcript/Metatalk commands and functions that use HTTP and FTP urls. 
       o
    o 

     y  nIt is used when the following Transcript/Metatalk commands and functions are called with HTTP or FTP urls: 		  -     load url <url> [with message <message>]       unload url <url>       get url <url>       put <data> into url <url>       post <data> to url <url>       delete url <url>       the cachedUrls       urlStatus(<url>) 		  ?It also recognizes and implements the following properties: 		       the httpheaders       the httpProxy  		  qIn addition, the library contains a few handlers and functions that can be called directly from your scripts: 		  1     libUrlFtpUpload <data>, <url> [, <message>]       libUrlErrorData(<url>)       libUrlSetFtpMode <mode>       libUrlResetAll  %     libUrlSetFtpStopTime  <seconds>       libUrlSetLogField <field>       libUrlVersion()    		    			Notes:  
   "   
   +load url <url> [with message <message>] 		 
   $   *   		  load downloads the url and places it into a cache. The cached data will then be used in subsequent references to that url instead of it being downloaded again. Be sure to unload the url (using unload url) when you no longer need it. 		 
   %   
      
   %  

        The optional message parameter will cause that message to be called when the download completes (or when an error occurs). Two parameters are passed to the message: the url and its urlStatus. The message should be in the same script as the load command.        on mouseUp  ;       put "http://www.xx.com/images/mykids.jpg" into tUrl  -       load url tUrl with message "loadDone"       end mouseUp         on loadDone pUrl, pStatus  #       if pStatus is "cached" then  -         put url pUrl into image 1 of card 1         else  "         answer "Download failed"         end if       end loadDone     		  wload is a "non-blocking" command. This means the url will load in the background while the script continues to run. 		 
   %   
      r HThis allows you to monitor downloads, for example with a progress bar.  
       2
    2 
     9        on mouseUp  A        put "http://www.xxxxxx.com/images/mykids2.jpg" into tUrl          load url tUrl          showStatus        end mouseUp          on showStatus  A        put "http://www.xxxxxx.com/images/mykids2.jpg" into tUrl  )        put urlStatus(tUrl) into tStatus  *        put tStatus ##show in message box  I        if tStatus is not among the items of "cached,error,timeout" then  5          send "showStatus" to me in 50 milliseconds          end if        end showStatus       		  3See below for more information about urlStatus. 		 Note that because the load url command is now executed in a script, you must be careful not to include any "wait" commands in your script before the load has completed. "wait" will stop all scripts running, including libUrl. The following script will not work:  
      
   %  
    %  
       
      
       
    %  K      on mouseUp 
    %   
       
       A        put "http://www.xxxxxx.com/images/mykids2.jpg" into tUrl          load url tUrl  5        wait until urlStatus(tUrl) is "cached" ##BAD 
       
  @       ,       end mouseUp  		    unload url <url> 		 
   $      		  unload removes a previously loaded url from the cache and thus frees up memory. You should unload urls when you no longer need them. 		 
   %   
         get url <url>  
   $    		 /get url downloads the url or, if the url is cached from a previous load command, retrieves it from the cache. If it completes successfully, the downloaded data will be in the variable it , and the result function will return empty. If an error occurs, the result function will return an error message.  
   %   
       
   %  
      
    %  

       1
    %  #
   % 
    %% 	      on mouseUp 
        
      
 @        put "http://www.xxxxxx.com/images/mykids.jpg" into tUrl          get url tUrl  $        if the result is empty then            put it into image 1  
        else            answer the result          end if         end mouseUp    		 
Typically the error message will consist of the word "error" followed by a string containing more information about the error. Where appropriate, the error string will be the string returned by the http or ftp server including the server response code. For example:  			  error 404 File not found 		   Note that the variable  it  will not always be empty when an error occurs. Http servers typically return an "error page" for certain errors (401, 404, etc.) libUrl will try to download such data as well, and return it in the it variable. Because of this, you should always check the result function after a  get url  command. You can't assume that because it is not empty no error occurred. 		 
      
   %  
      
   %  
      4
   % 

    ! 
   %3 	
    < (
   %d 
    f # 			 get url is a "blocking" command. This means that the script lines following the get command will not continue until get url completes. However, because of the nature of libUrl, it doesn't block other scripts or user actions. If the get url command is in a button, the user could feasibly click the button again before the first mouseUp has completed. Or he or she may click another button that gets another url. In cases when a url is currently downloading from a get url command, subsequent get url commands will return the error "error Previous request has not completed." Because of this, you may want to disable interface elements while a get url command is completing, or take some other action that is appropriate to your application. 		 
   %   
      m
   % t 
     { m
   %  
      
   % 
     
   % 
     
   % 
     ] ((similar script in a series of buttons) 
      
           global gUrlBlocking      on mouseUp  ?      put "http://www.xxxxxx.com/images/mykids1.jpg" into tUrl  #      if gUrlBlocking is true then  
        beep        else  #        put true into gUrlBlocking          get url tUrl  $        put false into gUrlBlocking  $        if the result is empty then            put it into image 1  
        else            answer the result          end if  
      end if      end mouseUp  		  The same is true for the other "blocking" commands (post, put, delete). Basically only one url can be handled at a time with any of these commands. 		 
      W
   % W 
     Z <   put <data> into url <url> 		 
   $      		 
The put command will save the data to the specified url on an ftp server. If it completes successfully, the result function will return empty. If an error occurs, the result function will return an error message. In the same way as for get url the error message will consist of the word "error" followed by a string containing more information about the error. Where appropriate, the error string will be the string returned by the ftp server including the server response code. For example: 		    error 530 Login incorrect. 
      
   %  
      
   %   Example       on mouseUp  M         put "ftp://dave:evad345@ftp.xxxxxx.com/images/mykids.txt" into tUrl            put field 1 into tData  !         put tData into url tUrl  %         if the result is empty then  &           answer "Upload successful"           else  4           answer "Upload failed" & cr & the result           end if        end mouseUp  		  I*See below about including user names and passwords for authorization 		  NSee get url for information about the "blocking" behavior of this command. 		 
      
   %  
      A   post <data> to url <url> 		 
   $    		 The post command is used to post data to an http server process such as cgi. If it completes successfully, the result function will return empty and the response from the server will be in the variable it. If an error occurs, the result function will return an error message. 		 
      
   %  
      c
   % k 

     u U
   %  
      
   %  

      * NSee get url for information about the "blocking" behavior of this command. 		 
      
   %  
      A    on mouseUp  @       put "http://www.xxxxxx.co.uk/cgi-bin/sendform" into tUrl  ,       put "subject=Post text" into tString  2       put "&to=dave@xxxxxxx.co.uk" after tString  H       put "&message=This is a test message from libUrl." after tString  F       put "&page=http://www.xxxx.co.uk/submitted.html" after tString         put crlf after tString          post tString to url tUrl  #       if the result is empty then           put it into field 1         else           answer the result         end if      end mouseUp       		    delete url <url> 		 
   $    		  delete url will delete the file from an ftp server. If it completes successfully, the result function will return empty. If an error occurs,  the result function will return an error message. 		 
   %   

     
 H
   % R 

     \ 1
   %  
      *   the cachedUrls 		 
   $     <the cachedUrls function returns a list of currently cached urls, one per line. Note that it only includes those urls whose urlStatus is "cached". Urls whose urlStatus is "error", but for which there is cached data (e.g. as a result of a "file not found" error on an http server) will not be included in the list. 		 
   %   
     -   urlStatus(<url>) 		 
   $    		  The urlStatus function returns the status of urls that have previously been referenced with a load url command. It will return one of the following:  
      
   %  	
      
 O
     \ 
    % ^ 	
     g .     queued 
    %   
           contacted      requested  A    loading,x,y (where x = downloaded bytes and y = total bytes)      timeout  
    error      cached  		  The function can be used to monitor files as they download (see load url above for an example), or to check the status of a url after the load has completed. 		 
      @
   % @ 
     H X Note that if you upload data with libUrlFtpUpload (see below), instead of "loading" and "cached", urlStatus will return "uploading" and "uploaded" respectively. 		 
      "
   % " 
     1 r 			Also note that "queued" is a new possible value. This is returned when a load url request has been made, and the url is placed on a queue while previous requests to the same host are completed. 		 
      L
   % L 
     T s   		Library interface 		 
   "      		 The following library routines can be accessed directly from your scripts. More routines may be added from time to time. It's also possible that some of these routines may be incorporated into the Transcript/Metatalk language at some stage, although with different syntax. 		    /libUrlFtpUpload <data>, <url> [, <message>] 		 
   $   .   		 This handler is basically the upload equivalent of the load url command and can be used to upload data to an ftp server. It is a "non-blocking" routine, so your script will continue to execute as the upload takes place in the background which allows the urlStatus to be monitored as the file is uploading. The optional message parameter lets you denote a message that will be called when the upload completes. 		 
      7
   % 7 
     ?]aNote that urlStatus will return "uploading,x, y" and "uploaded" in replace of "loading,x,y" and "cached" when libUrlFtpLoad is used. Also note that urlStatus will continue to return "uploaded" for this url until you unload it with the unload url command. For this reason, you are advided to unload the url when you no longer need to know its status. 		 
      

   % 
 	
      
   %  	
      N
   %  

      k 
  on mouseUp  B      put "ftp://ftp.xxxxxx.com/literature/sadlife.txt" into tUrl        put field 1 into tData  "      libUrlFtpUpload tData, tUrl        showStatus      end mouseUp        on showStatus  B      put "ftp://ftp.xxxxxx.com/literature/sadlife.txt" into tUrl  '      put urlStatus(tUrl) into tStatus  (      put tStatus ##show in message box  I      if tStatus is not among the items of "uploaded,error,timeout" then  2       send "showStatus" to me in 50 milliseconds  
      end if      end showStatus      		    libUrlErrorData(<url>) 		 
   $      		 This function allows you to get further error data about a url whose urlStatus is "error". It will return the same string as the result of a get url command. Typically, this will be the response string returned by an http or ftp server. For example: "404 File not found" 		 
      
   %  
      | @    put "ftp://ftp.xxxxxx.com/literature/sadlife.txt" into tUrl 
       ;
    ;  '    if urlStatus(tUrl) is "error" then         get libUrlErrorData(tUrl)  ;      put "An error occurred" & cr & it into field "error"      end if       		    libUrlSetFtpMode <mode> 		 
   $      		 6This command allows you to switch between passive and active FTP data transfers. <mode> can be either "active" or "passive". Actually, as passive is now the default, anything except "active" will cause the transfer to use passive mode. Any change will persist for the remainder of the session (i.e. until you application exits) or until you issue the command again. When your application starts, passive transfers will be used by default. So if you know you are going to be using active transfers, you should include this command before initiating any transfers. 		 If you don't know the difference between passive and active transfers, don't worry. Nine times out of ten, either will work fine. However, if you find that you are having trouble with ftp transfers, you might want to try switching to see if it makes a difference. 		      libUrlSetFtpMode "active"      		    libUrlResetAll 		 
   $     Warning: Don't use this command lightly. In fact, you should never have to use it at all. It closes all open sockets and clears all variables used by libUrl, including any cached data. It's basically the "panic buton" when things go wrong, so it may be useful in development. 		 
      d
   % d 
     g    "libUrlSetFtpStopTime <seconds> 		 
   $   !   		 This command lets you set the number of seconds that a socket used for an ftp control connection remains open after a transaction completes. <seconds> must be an integer greater than 0. The default value is 15 seconds. If a new request to the same host is made while the socket is open, the connection is re-used. Note that libUrl makes no attempt to keep the connection open, so the server may close the connection first. 		    libUrlSetLogField <field> 		 
   $      		  This command lets you set a field that will collect log data. The field parameter should be the long id of the field you wish to use. 		    libUrlVersion() 		 
   $      This returns the current version of the libUrl library. There is no special significnce to the numbers, but will be useful for reference when reporting any problems or difficulties. 		    Authorization 		 
   $      		  If an http or ftp url requires authorization with a user name and password, these can be included in the url in the following way: 		   <protocol>://<username>:<password>@<host><path>    Examples  B		       http://dave:evad123@www.xxxxxx.com/secrets/thetruth.html  =       ftp://daphne:enhp456@ftp.xxxxxx.com/gossip/really.jpg  
       		  For anonymous ftp, no name or password is required. The library will add the "anonymous" user name and a dummy password automatically. 		  If the user name or password contains non-alphanumeric characters (specifically the ":", "@", "/" , "." or "|" characters if these are allowed), then these should be urlEncoded before being put into the url. 		      put "jim" into tName  $    put "jsmith@abc.com" into tPass  W    put "ftp://" & tName & ":" & urlEncode(tPass) & "@ftp.xxx.com/title.txt" into tUrl      get url tUrl       		    	Acknowledgements 		 
   $    		  gDevelopment of libUrl for use with both Revolution and Metacard is sponsored by Runtime Revolution. 		  The major credit must go to Andu Novac who put together the first versions from scratch. This project would be going nowhere without his efforts, especially in implementing the contents of the various rfc's for ftp and http. 		  ;Thanks also to contributors Reed Martin and John Kuehne 		  PThe library is currently maintained by Dave Cragg (dcragg@lacscentre.co.uk). 		  			February 24, 2002 		 
      
   &  
       
			 		     c    	`       	 ?   Variable Watcher !   `       x !    vcolors  red,darkorange,brown,blue
curscroll  0curline  1               U 
Helvetica  	 U 
Helvetica   U 
helvetica  	 U 
helvetica  
 U 
Helvetica  
 U Arial Black   U Arial Black   U Arial   U 
Helvetica   U Times New Roman   U 
Trebuchet MS   U Verdana   U Times   U Times  
 W 
Helvetica  
 U Lucida Grande   W 
helvetica   U symbol   U Symbol       	P"on preOpenStack
  set the textSize of field 1 to the scriptTextSize
  repeat with i = 2 to the number of fields
    set the textFont of field i to the scriptTextFont
    set the textSize of field i to the scriptTextSize
  end repeat
  refresh
end preOpenStack

on closeStack
  put "" into field "Names"
  put "" into field "Values"
  put "" into field "Contents"
end closeStack

on refresh
  if the mode of this stack is 0 then exit refresh
  lock screen
  put empty into field "Watched"
  put empty into field "Contents"
  if the number of lines in field 1 of stack "Execution Contexts" is 0 then
    get the globals
    replace comma with cr in it
    put it into field "Names"
    set the textColor of char 1 to -1 of field "Names" to item 4 of the vcolors of this stack
    put empty into field "Values"
    repeat for each line l in it
      do "global" && l & "; put char 1 to 100 of line 1 of value(l) & cr after field" && quote & "Values" & quote
    end repeat
    delete last char of field "Values"
  else
    set the curline of this stack to the hilitedLines of field "Names"
    if the curline of this stack is empty then set the curline of this stack to 1
    set the curscroll of this stack to the scroll of field "Names"
    get the hilitedLine of field 1 of stack "Execution Contexts"
    if it is empty then get the number of lines of field 1 of stack "Execution Contexts"
    set the debugContext to line it of field 1 of stack "Execution Contexts"
    debugdo "put the variableNames into field" && quote & "tvnames" & quote
    put empty into field "Names"
    put empty into field "Values"
    put 1 into field "tcline"
    repeat until field "tcline" > 4
      put 1 into field "tcitem"
      repeat until field "tcitem" > the number of items of line (field "tcline") of field "tvnames"
        put item (field "tcitem") of line (field "tcline") of field "tvnames" & cr after field "Names"
        set the textColor of the last line of field "Names" to item (field "tcline") of the vcolors of this stack
        put item (field "tcitem") of line (field "tcline") of field "tvnames" into field "tvname"
        debugdo "put char 1 to 100 of line 1 of" && field "tvname" && "& cr after field" && quote & "Values" & quote
        add 1 to field "tcitem"
      end repeat
      add 1 to field "tcline"
    end repeat
    delete last char of field "Names"
    delete last char of field "Values"
    if line (the curline of this stack) of field "Names" is not empty then
      set the hilitedLines of field "Names" to the curline of this stack
      set the hilitedLines of field "Values" to the curline of this stack
      debugdo "put" && line (the curline of this stack) \
          of field "Names" && "into field" && quote & "Contents" & quote
    end if
    put empty into line (the number of lines in field "Names") of field "Watched"
    put item 2 of the debugContext into field "handler"
    set the debugContext to empty
    get the debuggingScript of stack "Script Editor"
    if it is not empty then
      get the scriptObject of it
      repeat for each line l in the watchedVariables
        if item 1 of l is it and item 2 of l is field "handler"
        then put numToChar(183) into line lineOffset(item 3 of l, field "Names") of field "Watched"
      end repeat
    end if
    set the scroll of field "Names" to the curscroll of this stack
    set the scroll of field "Watched" to the curscroll of this stack
    set the scroll of field "Values" to the curscroll of this stack
  end if
  unlock screen
end refresh

on selectVar theLineNum
  if line theLineNum of field "Names" is empty then exit to top
  if the number of lines in field 1 of stack "Execution Contexts" is 0 then
    get item theLineNum of the globals
    do "global" && it & "; put" && it && "into field" && quote & "Contents" & quote
  else
    get the hilitedLine of field 1 of stack "Execution Contexts"
    if it is empty then get the number of lines of field 1 of stack "Execution Contexts"
    set the debugContext to line it of field 1 of stack "Execution Contexts"
    debugdo "put" && line theLineNum of field "Names" && "into field" \
        && quote & "Contents" & quote
  end if
  set the curline of this stack to theLineNum
  set the hilitedlines of field "Names" to theLineNum
  set the hilitedlines of field "Values" to theLineNum
end selectVar

on setVar
  if the number of lines in field 1 of stack "Execution Contexts" is 0 then
    get the selectedText of field "Names"
    do "global" && it & "; put field" && quote & "Contents" & quote && "into" && it
  else
    get the hilitedLine of field 1 of stack "Execution Contexts"
    if it is empty then get the number of lines of field 1 of stack "Execution Contexts"
    set the debugContext to line it of field 1 of stack "Execution Contexts"
    get the selectedText of field "Names"
    debugdo "put field" && quote & "Contents" & quote && "into" && it
  end if
  get the hilitedLine of field "Names"
  put char 1 to 100 of line 1 of field "Contents" into line it of field "Values"
  set the hilitedLine of field "Values" to it
end setVar

on resizeStack
  local tWidth, tHt, tHalf, tTopHalf
  put the width of this stack into tWidth
  put the height of this stack into tHt
  if the left of grc "vLine" > the width of this cd - 20 then
    put the width of this cd div 2 into tHalf
    set the left of grc "vLine" to tHalf
  else put the left of grc "vLine" into tHalf
  if the top of grc "hLine" > the height of this cd - 20 then
    put the height of this cd div 2 into tTopHalf
    set the top of grc "hLine" to tTopHalf
  else put the top of grc "hLine" into tTopHalf
  
  set the height of field "Watched" to tTopHalf + 1
  set the width of field "Names" to tHalf - 16
  set the height of field "Names" to tTopHalf + 1
  set the width of field "Values" to the width of this cd - tHalf - 4
  set the height of field "Values" to tTopHalf + 1
  set the right of field "Values" to the width of this cd - 4
  
  set the height of field "Contents" to (tHt-the bottom of grc "hLine") - 4
  set the width of field "Contents" to the width of this stack - 8
  set the left of field "Contents" to 4
  set the top of field "Contents" to the bottom of grc "hLine"
  
  set the height of grc "vLine" to the height of field "Names"
  set the top of grc "vLine" to 0
  set the width of grc "hLine" to the width of this cd
  set the left of grc "hLine" to 0
end resizeStack
                                     
   Values )p on scrollbardrag
  set the scroll of fld "Names" to the scroll of me
end scrollbardrag

on mouseDown
  selectVar (word 2 of the clickline)
end mouseDown
      @  ) y                  	`         w
   Names ?)p Bon mouseDown
  selectVar (word 2 of the clickline)
end mouseDown
      @    y            
   	Contents  )p +on enterInField
  setVar
end enterInField
      @  | a                      	`       }  _   vLine   Klocal dragging
on mouseDown
  put true into dragging
end mouseDown

on mouseMove x, y
  if dragging then
    set the left of me to min(max(x, the left of field "Names" + 8),the width of this cd - 32)
    resizeStack
  end if
end mouseMove

on mouseUp
  put false into dragging
  resizeStack
end mouseUp

on mouseRelease
  put false into dragging
  resizeStack
end mouseRelease

on mouseEnter
  set cursor to 28
  lock cursor
end mouseEnter

on mouseLeave
  unlock cursor
end mouseLeave
            y         w   hLine   Klocal dragging
on mouseDown
  put true into dragging
end mouseDown

on mouseMove x, y
  if dragging then
    set the top of me to min(max(y, 42),the height of this cd - 32)
    resizeStack
  end if
end mouseMove

on mouseUp
  put false into dragging
  resizeStack
end mouseUp

on mouseRelease
  put false into dragging
  resizeStack
end mouseRelease

on mouseEnter
  set cursor to 27
  lock cursor
end mouseEnter

on mouseLeave
  unlock cursor
end mouseLeave
          x        z z
   Watched 	x  (on mouseUp
  local debuggingObject, cl, wv, s
  get the debuggingScript of stack "Script Editor"
  if it is empty then exit mouseUp
  put the scriptObject of it into debuggingObject
  put word 2 of the clickLine into cl
  if line cl of field "Names" is empty then exit mouseUp
  put the watchedVariables into wv
  if the clickText is empty then
    get word 2 of the clickLine
    put numToChar(183) & cr into line it of me
    ask "Stop condition:" with line it of field "Names" && " = "
    put cr & debuggingObject & comma & field "handler" & comma & line cl of field "Names" & comma & it after wv
  else
    put cr into the clickLine
    delete line lineOffset(debuggingObject & comma & field "handler" & comma & line cl of field "Names", wv) of wv
  end if
  set the watchedVariables to wv
end mouseUp
                 y            
   tvnames  !`          T           v1          
   tcline  !`        d x          5      
   tcitem  !`         x          1      
   handler  !`         x          mouseUp      
   tvname  !`         x          v1         Execution Contexts    `          n                 U 
helvetica       	P+on preOpenCard
  set the textFont of field 1 to the scriptTextFont
  set the textSize of field 1 to the scriptTextSize
  refresh
end preOpenCard

on refresh
  local l
  get the executionContexts
  repeat while char -11 to -2 of item 1 of it is "mctools.mc"
    delete line 1 of it
  end repeat
  put lineOffset("mctools.mc", it) into l
  delete line l to -1 of it
  put it into field 1
  set the hilitedLines of field 1 to the number of lines in field 1
end refresh

on resizeStack nw, nh
  set the rect of field 1 to 4, 4, nw - 4, nh -4
end resizeStack
            n  
     )p	on mouseUp
  get the selectedText of me
  set the debugContext to it
  editScript item 1 of it, false
  send "startDebug" && item 1 of it, empty, item 3 of it, empty to  card 1 of stack the result
  send "Refresh" to card 1 of stack "Variable Watcher"
end mouseUp
          f                  	`         d   Message Watcher    `        \              U 
helvetica       	P	constant maxmess = 100
local mlist

on recordMessage t, m, o, h
  local ns
  if m is among the lines of the suppressedMessages of me \
      or t is among the lines of the suppressedTypes of me \
      or h is among the lines of the suppressedActions of me \
      or the suppressIDE of me \
      and (char -11 to -2 of o is "mctools.mc" or char -11 to -2 of o is "mchome.mc")
  then exit recordMessage
  get the hilitedLines of field "Messages"
  if the number of lines in mlist > maxmess then
    delete line 1 of mlist
    delete line 1 of field "Messages"
    subtract 1 from it
  end if
  put char 1 to (the number of lines in the executionContexts) - 2 of "              " into ns
  if field "Messages" is empty then
    put t,o after mlist
    put ns & m after field "Messages"
  else
    put cr & t,o after mlist
    put cr & ns & m after field "Messages"
  end if
  if it < 1 then
    put empty into field "Object Name"
    put empty into field "Message Type"
    set the scroll of field "Messages" to 10000000
  else set the hilitedLines of field "Messages" to it
end recordMessage

on selectMessage which
  put item 1 of line which of mlist into field "Message Type"
  put item 2 of line which of mlist into field "Object Name"
end selectMessage

on openCard
  set the messageMessages to true
end openCard

on closeCard
  set the messageMessages to false
  clearMessages
end closeCard

on clearMessages
  put empty into field "Messages"
  put empty into field "Object Name"
  put empty into field "Message Type"
  put empty into mlist
end clearMessages

on resizeStack
  set the width of field "Messages" to the width of this card - 8
  set the height of field "Messages" to the height of this card - 76
  set the top of field "Object Label" to the bottom of field "Messages" + 8
  set the top of field "Object Name" to the bottom of field "Messages" + 8
  set the width of field "Object Name" to the width of this card - the left of field "Object Name" - 8
  set the top of field "Type Label" to the bottom of field "Messages" + 40
  set the top of field "Message Type" to the bottom of field "Messages" + 40
  set the top of button "Clear" to the bottom of field "Messages" + 40
  set the top of button "Suppress..." to the bottom of field "Messages" + 40
  set the right of button "Suppress..." to the right of this card - 8
  set the right of button "Clear" to the left of button "Suppress..." - 8
end resizeStack
             suppressedTypes  getProp
setPropsuppressedResolutions  not handledsuppressedMessages  	mouseMovesuppressIDE  truesuppressedActions  false              
   	Messages )p @on mouseUp
  selectMessage word 2 of the clickLine
end mouseUp
                            	`      v      Suppress... Ep 4on mouseUp
  modal "Suppress Messages"
end mouseUp
       '  `          	     
   
Object Label 	           <            Object: 
   Type Label 	           t            Message Type: 
   Object Name )`       @ G                
   
Message Type  )`       t  d                   Clear Ep (on mouseUp
  clearmessages
end mouseUp
          8          	        Suppress Messages    `        ;B                 U 
helvetica       	P}on preOpenCard
  repeat with i = 1 to the number of buttons
    set the hilite of button i to false
  end repeat
  set the hilite of button "IDE Messages" to the suppressIDE of card 1 of stack "Message Watcher"
  put the suppressedMessages of card 1 of stack "Message Watcher" \
      into field "Suppressed Messages"
  get the the suppressedActions of card 1 of stack "Message Watcher"
  repeat for each line l in it
    set the hilite of button l to true
  end repeat
  get the the suppressedTypes of card 1 of stack "Message Watcher"
  repeat for each line l in it
    set the hilite of button l to true
  end repeat
end preOpenCard
           B                   
Handler Type i         \ p    message @e        p d  	Messages          	        	function @e         d  
Functions          	        getProp @e         d  	GetProps          	       setProp @e         d  	SetProps          	    
   Suppressed Messages  )`        0             
mouseMove       	`      # 1     Add... Ep on mouseUp
  ask question "Message to add?"
  if it is not empty then
    if field "Suppressed Messages" is empty
    then put it into field "Suppressed Messages"
    else put cr & it after field "Suppressed Messages"
  end if
end mouseUp
          <          	        Delete Ep on mouseUp
  get the hilitedLines of field "Suppressed Messages"
  if it is not empty
  then delete line it of field "Suppressed Messages"
end mouseUp
          <          	        OK Mpnon mouseUp
  set the suppressIDE of card 1 of stack "Message Watcher" \
      to the hilite of button "IDE Messages"
  set the suppressedMessages of card 1 of stack "Message Watcher" \
      to field "Suppressed Messages"
  get empty
  repeat with i = 1 to the number of buttons in group "Action"
    if the hilite of button i of group "Action"
    then put the short name of button i of group "Action" & cr after it
  end repeat
  delete last char of it
  set the suppressedActions of card 1 of stack "Message Watcher" to it
  get empty
  repeat with i = 1 to the number of buttons in group "Handler Type"
    if the hilite of button i of group "Handler Type"
    then put the short name of button i of group "Handler Type" & cr after it
  end repeat
  delete last char of it
  set the suppressedTypes of card 1 of stack "Message Watcher" to it
  close this stack
end mouseUp
        A  A          	        Action i          x F   true @e         l  Handled          	        false @e        7 l  Not Handled          	       
IDE Messages @E                   	       Cancel Ep +on mouseUp
  close this stack
end mouseUp
          A          	      