/*
	STCFLRWH.h
	Copyright (C) 2018 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	STandard C library style FiLe, Read and Write myHandles
*/


LOCALFUNC uimr ReadFileRemaining(FILE *f, uimr *v)
{
	tMyErr err;
	long fpos;
	long fpos2;

	if ((fpos = ftell(f)) < 0) {
		err = kMyErrSysUnknown;
	} else
	if (0 != fseek(f, 0L, SEEK_END)) {
		err = kMyErrSysUnknown;
	} else
	if ((fpos2 = ftell(f)) < 0) {
		err = kMyErrSysUnknown;
	} else
	if (0 != fseek(f, fpos, SEEK_SET)) {
		err = kMyErrSysUnknown;
	} else
	{
		err = kMyErr_noErr;
		*v = fpos2 - fpos;
	}

	return ErrReportStack(err, "ReadFileRemaining");
}

LOCALFUNC tMyErr ReadFilePathToNewHand2(char *infile, MyHandle *h0)
{
	tMyErr err;
	FILE *f;
	uimr L;
	MyHandle h;

	if ((f = fopen(infile, "rb")) == nullpr) {
		/* Can't open files */
		err = kMyErrSysUnknown;
	} else
	{
		if (kMyErr_noErr != (err =
			ReadFileRemaining(f, &L)))
		{
			/* fail */
		} else
		if (kMyErr_noErr != (err =
			MyHandleNew_v2(L, &h)))
		{
			/* fail */
		} else
		{
			MyHandleLock(h);

			if (fread(((MyPtr)MyHandleP(h)), 1, L, f) < L) {
				/* error -- read failure or premature eof */
				err = kMyErrSysUnknown;
			} else {
				err = kMyErr_noErr;
			}

			MyHandleUnlock(h);

			if (kMyErr_noErr != err) {
				(void) MyHandleDispose_v2(h);
			} else {
				*h0 = h;
			}
		}

		fclose(f);
	}

	return ErrReportStack(err, "ReadFilePathToNewHand2");
}

LOCALFUNC tMyErr WriteMyHandRngToFile(FILE *f,
	MyHandle h, uimr offsetA, uimr offsetB)
{
	tMyErr err;
	uimr n = offsetB - offsetA;

	MyHandleLock(h);

	if (fwrite(((MyPtr)MyHandleP(h)) + offsetA, 1, n, f) < n) {
		err = kMyErrSysUnknown; /* error -- write failure */
	} else {
		err = kMyErr_noErr;
	}

	MyHandleUnlock(h);

	return ErrReportStack(err, "WriteMyHandRngToFile");
}

LOCALFUNC tMyErr WriteMyHandRngCnvtToFile(FILE *f,
	MyHandle h, uimr offsetA, uimr offsetB)
{
	tMyErr err;
	uimr o_eol;
	uimr o_nexti;
	uimr i = offsetA;

l_retry:
	if (i == offsetB) {
		err = kMyErr_noErr;
	} else
	if (kMyErr_noErr != (err =
		MyHandRngFindFirstLine(h, i, offsetB, &o_eol, &o_nexti)))
	{
		/* fail */
	} else
	if (kMyErr_noErr != (err =
		WriteMyHandRngToFile(f, h, i, o_eol)))
	{
		/* fail */
	} else
	{
		if (o_eol != offsetB) {
			fprintf(f, "\n");
		}

		i = o_nexti;
		goto l_retry;
	}

	return ErrReportStack(err, "WriteMyHandRngCnvtToFile");
}

LOCALFUNC tMyErr WriteHandPathToNewFile(char *outfile,
	MyHandle h, blnr text)
{
	tMyErr err;
	FILE *f;
	uimr L;

	if ((f = fopen(outfile, text ? "w" : "wb")) == nullpr) {
		/* Can't open files */
		err = kMyErrSysUnknown;
	} else
	{
		if (kMyErr_noErr != (err =
			MyHandleGetSize_v2(h, &L)))
		{
			/* fail */
		} else {
			if (text) {
				err = WriteMyHandRngCnvtToFile(f, h, 0, L);
			} else {
				err = WriteMyHandRngToFile(f, h, 0, L);
			}
		}

		fflush(f);
		if (ferror(f)) {
#ifdef ENOSPC
			if (errno == ENOSPC) {
				err = kMyErr_lowdsk;
			} else
#endif
			{
				err = kMyErrSysUnknown;
			}
		}

		fclose(f);

		if (kMyErr_noErr != err) {
			remove(outfile);
		}
	}

	return ErrReportStack(err, "WriteHandPathToNewFile");
}
