#ifdef Have_CFGCMPTL
#include "CFGCMPTL.h"
#endif

#ifndef AlreadyHaveStdIncludes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#endif

#ifndef ForMPWTool
#define ForMPWTool 0
#endif

#define DebugCheck 0

#include "COREDEFS.h"
#if DebugCheck
#include "DBGLGSTC.h"
#endif
#include "POW2UTIL.h"

#if ForMPWTool
#include "IMATHOPT.h"
#else
#define MyMoveBytes(src, dst, n) \
	(void) memmove((void *)(dst), (void *)(src), n)
#endif

#include "STRUTILS.h"
#include "SAVEDERR.h"

#if ForMPWTool
#define HaveTempBuffH 0
#include "MYMEMORY.h"
#else
#include "FHMEMORY.h"
#endif

#include "HANDUTIL.h"


#if ForMPWTool
GLOBALFUNC char * GetTextForSavedSysErr_v2(tMyErr err)
{
#pragma unused(err)

	return "Unknown error";
}

#include "TOOLUTIL.h"
#else
#define CheckAbortRequested() kMyErr_noErr
#endif

LOCALFUNC tMyErr SetSyntaxErrCStr(char *s,
	uimr offsetA, uimr offsetB)
{
	fprintf(stderr, "Syntax error: %s\n", s);
	fprintf(stderr, "Offset Range: %d:%d\n",
		(int)offsetA, (int)offsetB);

	return kMyErrSyntaxErr;
}

#include "MPINTLIB.h"
#include "MD5CHKSB.h"
#include "CRCCHKSM.h"
#include "RDWRSTRM.h"

#include "RWARBINT.h"
#include "PKCOMLIB.h"
#include "PKGNKEYS.h"
#include "PKGRYLIB.h"

#include "STCFLRWH.h"

static tMyErr gry_dispatch_kg(char *random_f,
	char *seckey_f, char *pubkey_f)
{
	tMyErr err;
	MyHandle random_H;
	MyHandle seckey_H;
	MyHandle pubkey_H;

	/*
		If we're not doing anything that uses stdout,
		produce output there, in case user wants to redirect
		it.
	*/

	/*
		Key generation
		Arguments: bitcount, bitcount
	*/

	fprintf(stdout, "\n");
	fprintf(stdout,
		"Generating an RSA key.\n");

	fputs(
		"\nNote that key generation is a lengthy process.\n", stdout);

	if (kMyErr_noErr == (err =
		ReadFilePathToNewHand2(random_f, &random_H)))
	{
		if (kMyErr_noErr == (err =
			gry_dokeygen(random_H, &seckey_H, &pubkey_H)))
		{
			(void) WriteHandPathToNewFile(seckey_f, seckey_H, trueblnr);
			MyHandleDispose_v2(seckey_H);

			(void) WriteHandPathToNewFile(pubkey_f, pubkey_H, trueblnr);
			MyHandleDispose_v2(pubkey_H);
		}

		MyHandleDispose_v2(random_H);
	}

	putc('\n', stdout);

	fputc('\007', stdout);
		/* sound the bell when done with lengthy process */
	fflush(stdout);

	fputs("\007Key generation completed.\n", stdout);

	if (err < 0) {
		fprintf(stdout, "\007Keygen error. ");
	}

	err = (err == -7 ? 0 : err);

	return err;
}

int main(int argc, char *argv[])
{
	int return_val = 1;

#if ForMPWTool
	InitMyMPWtool();
#endif

	if (argc != 4) {
		fprintf(stderr, "wrong number of arguments\n");
	} else {
		tMyErr err = gry_dispatch_kg(argv[1], argv[2], argv[3]);

		if (0 != err) {
			/*
				not "return_val = err;".
				It turns out that anything outside of 0..125
				is not portable.
			*/
		} else {
			return_val = 0;
		}
	}

#if ForMPWTool
	UninitMyMPWtool();
#endif

	return return_val;
}
