/*
	MnvMreg.c

	Copyright (C) 2004 Paul Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

#include "CNFGRAPI.h"
#include "CNFGGLOB.h"

#ifndef UnusedParam
#define UnusedParam(p) (void) p
#endif

#define blnr int
#define trueblnr 1
#define falseblnr 0

#define nullpr ((void *) 0)

#define LOCALVAR static

#define LOCALFUNC static
#define FORWARDFUNC LOCALFUNC

#define LOCALPROC LOCALFUNC void
#define FORWARDPROC FORWARDFUNC void

/*--- basic dialogs ---*/

LOCALPROC MacMsg(char *briefMsg, char *longMsg)
{
	MessageBox(NULL, longMsg, briefMsg, MB_APPLMODAL|MB_OK);
}

/*--- main window ---*/

LOCALVAR HINSTANCE AppInstance;

LOCALFUNC blnr GetAppDir (char* pathName)
/* be sure at least _MAX_PATH long! */
{
	if (GetModuleFileName (AppInstance, pathName, _MAX_PATH) == 0) {
		MacMsg("error", "GetModuleFileName failed");
	} else {
		char *p0 = pathName;
		char *p = nullpr;
		char c;

		while ((c = *p0++) != 0) {
			if (c == '\\') {
				p = p0;
			}
		}
		if (p == nullpr) {
			MacMsg("error", "strrchr failed");
		} else {
			*p = '\0';
			return trueblnr;
		}
	}
	return falseblnr;
}

LOCALFUNC blnr MySetRegKey(HKEY hKeyRoot, char *strRegKey, char *strRegValue)
{
	HKEY RegKey;
	DWORD dwDisposition;
	blnr IsOk = falseblnr;

	if (RegCreateKeyEx(hKeyRoot, strRegKey, 0, NULL,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
		NULL, &RegKey, &dwDisposition) != ERROR_SUCCESS)
	{
		MacMsg("error", "RegCreateKeyEx failed.");
	} else {
		if (RegSetValueEx(RegKey, NULL, 0, REG_SZ,
			(CONST BYTE *)strRegValue, strlen(strRegValue) + sizeof(char))
			!= ERROR_SUCCESS)
		{
			MacMsg("error", "RegSetValueEx failed.");
		} else {
			IsOk = trueblnr;
		}
		if (RegCloseKey(RegKey) != ERROR_SUCCESS) {
			MacMsg("warning", "RegCloseKey failed.");
		}
	}
	return IsOk;
}

LOCALFUNC blnr RegisterShellFileType (char *AppPath, char *strFilterExt,
	char *strFileTypeId, char *strFileTypeName,
	char *strIconId, blnr CanOpen)
{
	char strRegKey[_MAX_PATH];
	char strRegValue[_MAX_PATH + 2]; /* extra room for ","{strIconId} */

	if (! MySetRegKey(HKEY_CLASSES_ROOT, strFileTypeId, strFileTypeName)) {
		return falseblnr;
	}
	if (! MySetRegKey(HKEY_CLASSES_ROOT, strFilterExt, strFileTypeId)) {
		return falseblnr;
	}

	strcpy(strRegKey, strFileTypeId);
	strcat(strRegKey, "\\DefaultIcon");
	strcpy(strRegValue, AppPath);
	strcat(strRegValue, ",");
	strcat(strRegValue, strIconId);
	if (! MySetRegKey(HKEY_CLASSES_ROOT, strRegKey, strRegValue)) {
		return falseblnr;
	}

	if (CanOpen) {
		strcpy(strRegKey, strFileTypeId);
		strcat(strRegKey, "\\shell\\open\\command");
		strcpy(strRegValue, AppPath);
		strcat(strRegValue, " \"%1\"");
		if (! MySetRegKey(HKEY_CLASSES_ROOT, strRegKey, strRegValue)) {
			return falseblnr;
		}
	}
	return trueblnr;
}

LOCALFUNC blnr CheckAppPath(char *AppPath)
{
	HANDLE hExe;        // handle to existing .EXE file 
	blnr IsOk = falseblnr;

	/* hExe = LoadLibrary(AppPath); */
	hExe = LoadLibraryEx(AppPath, NULL, LOAD_LIBRARY_AS_DATAFILE);
	if (hExe == NULL) {
		MacMsg("error", "I can't find 'minivmac.exe'. It should be in the same folder as 'MnvMreg.exe'.");
	} else {
		if ((NULL == FindResource(hExe, MAKEINTRESOURCE(257), RT_GROUP_ICON))
			|| (NULL == FindResource(hExe, MAKEINTRESOURCE(258), RT_GROUP_ICON))
			)
		{
			MacMsg("error", "FindResource failed");
		} else {
			IsOk = trueblnr;
		}
 		if (! FreeLibrary(hExe)) {
			MacMsg("warning", "FreeLibrary failed");
		}
	}
	return IsOk;
}

LOCALFUNC blnr RegisterInRegistry(void)
{
	char AppPath[_MAX_PATH];

	if (GetAppDir(AppPath)) {
		strcat(AppPath, "minivmac.exe");
		/* GetModuleFileName(NULL, AppPath, _MAX_PATH); */
		GetShortPathName(AppPath, AppPath, _MAX_PATH);

		if (CheckAppPath(AppPath))
		if (RegisterShellFileType(AppPath, ".DSK", "minivmac.DSK", "Mini vMac Disk Image", "1", trueblnr))
		if (RegisterShellFileType(AppPath, ".ROM", "minivmac.ROM", "Mini vMac ROM Image", "2", falseblnr))
		{
			return trueblnr;
		}
	}

	return falseblnr;
}

LOCALVAR char *CommandLine;

#if 0
LOCALFUNC blnr ScanCommandLine(void)
{
	char fileName[_MAX_PATH];
	char *filePtr;
	char *p = CommandLine;

	while (*p != 0) {
		if (*p == ' ') {
			p++;
		} else if (*p == '/') {
			p++;
			if (*p == 'l') {
				p++;
				/* SpeedLimit = trueblnr; */
			}
		} else {
			filePtr = fileName;
			if (*p == '\"') {
				p++;
				while (*p != '\"' && *p != 0) {
					*filePtr++ = *p++;
				}
				if (*p == '\"') {
					p++;
				}
			} else {
				while (*p != ' ' && *p != 0) {
					*filePtr++ = *p++;
				}
			}
			*filePtr = (char)0;
			/* (void) Sony_Insert1(fileName); */
		}
	}

	return trueblnr;
}
#endif

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	UnusedParam(hPrevInstance);
	UnusedParam(nCmdShow);
	AppInstance = hInstance;
	CommandLine = lpCmdLine;

	(void) SetCursor(LoadCursor(NULL, IDC_ARROW));

#if 0
	if (ScanCommandLine())
#endif
	if (RegisterInRegistry())
	{
		MacMsg("success", "have installed Mini vMac in registry");
		return trueblnr;
	}

	return(0);
}
