/*
	AAAATOOL.h

	Copyright (c) 2017-present, MacPaw Inc., Paul C. Pratt

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
	MA 02110-1301  USA
*/


#define DebugCheck 0

#include "COREDEFS.h"
#if DebugCheck
#include "DBGLGSTC.h"
#endif
#include "SAVEDERR.h"
#include "RDWRFILE.h"
#include "READBITS.h"
#include "PRFXCODE.h"
#include "STFFIT13.h"
#include "STFFPARS.h"


static tMyErr macBinaryVersionForHeader(void)
{
	tMyErr err;
	ui5r offset;
	ui5r datasize;
	ui4r i;
	ui3b bytes[128];
	ui5r extsize;

	if (kMyErr_noErr != (err = CSFileInReadBytes(128, &bytes))) {
		goto l_exit;
	}

	/* Check zero fill bytes. */
	if (bytes[0] != 0) {
		err = kMyErrParamErr;
		goto l_exit;
	}

	/* Check for a valid name. */
	if ((bytes[1] == 0) || (bytes[1] > 63)) {
		err = kMyErrParamErr;
		goto l_exit;
	}

	for (i = 0; i < bytes[1]; i++) {
		if (bytes[i + 2] == 0) {
			err = kMyErrParamErr;
			goto l_exit;
		}
	}
	/* NSString *newpath = NSstringForBytes(bytes + 2, bytes[1]); */

	/* Check more zero fill bytes. */
	if (bytes[74] != 0) {
		err = kMyErrParamErr;
		goto l_exit;
	}

	if (bytes[82] != 0) {
		err = kMyErrParamErr;
		goto l_exit;
	}

	datasize = CSUInt32BE(bytes + 83);

	/* ui5r rsrcsize = CSUInt32BE(bytes + 87); */

	/* Check for a valid signature. */
	if (CSUInt32BE(bytes + 102) == 0x6D42494E) { /* 'mBIN' */
		/* MacBinary III */
#if DebugCheck
		dbglog_writeln("MacBinary III file, only support II");
#endif
		err = kMyErrParamErr;
		goto l_exit;
	} else {
		/* MacBinary II */
	}

	/* Check more zero fill bytes. */
	for (i = 108; i <= 115; i++) {
		if (bytes[i] != 0) {
			err = kMyErrParamErr;
			goto l_exit;
		}
	}

	extsize = CSUInt16BE(bytes + 120);

#if 0
	/* Check for a valid checksum. */
	if (XADCalculateCRC(0, bytes, 124, XADCRCReverseTable_1021)
		!= XADUnReverseCRC16(CSUInt16BE(bytes + 124)))
	{
		err = kMyErr_crptfl;
		goto l_exit;
	}
#endif

#define BlockSize(size) (((size) + 127) & ~ 127)

	offset = BlockSize(extsize);

	if (! datasize) {
		err = kMyErr_crptfl;
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInSkipBytes(offset))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = stuffit_recognizeFileWithHandle())) {
		goto l_exit;
	}

	err = kMyErr_noErr;


l_exit:
	return ErrReportStack(err, "macBinaryVersionForHeader");
}

static tMyErr XADSimpleUnarchiverRun(char *src_path, char *dst_path)
{
	tMyErr err;

	if (kMyErr_noErr != (err = CSFileInOpen(src_path))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileOutOpen(dst_path))) {
		goto l_exit;
	}

	err = macBinaryVersionForHeader();

l_exit:
	CSFileOutFree();
	CSFileInFree();

	return ErrReportStack(err, "XADSimpleUnarchiverRun");
}

int main(int argc, char **argv)
{
	tMyErr err;

	if (3 != argc) {
		fprintf(stderr, "usage: unar archive_file dst_file\n");
		/* report an error */
		return 1;
	}

	if (kMyErr_noErr != (err =
		XADSimpleUnarchiverRun(argv[1], argv[2])))
	{
		fprintf(stderr, "an error occurred\n");
		return 1;
	}

	return 0;
}
