/*
	COREDEFS.h
	Copyright (C) 2020 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	CORE DEFinitionS
*/

#ifndef ui3b
#ifdef UINT8_MAX
#define ui3b uint8_t
#else
#define ui3b unsigned char
#endif
#endif

#ifndef ui3r
#ifdef UINT_LEAST8_MAX
#define ui3r uint_least8_t
#else
#define ui3r unsigned char
#endif
#endif

#ifndef ui4r
#ifdef UINT_LEAST16_MAX
#define ui4r uint_least16_t
#else
#define ui4r unsigned short int
#endif
#endif

#ifndef ui5r
#ifdef UINT_LEAST32_MAX
#define ui5r uint_least32_t
#else
#define ui5r unsigned long int
#endif
#endif

#ifndef si5r
#ifdef INT_LEAST32_MAX
#define si5r int_least32_t
#else
#define si5r long int
#endif
#endif

/* preferred counting type */

#ifndef uimbl2sz
#define uimbl2sz 5
#endif

#if 5 == uimbl2sz
typedef si5r simr;
typedef ui5r uimr;
#endif

#if 6 == uimbl2sz
typedef si6r simr;
typedef ui6r uimr;
#endif

/* boolean type */

typedef ui3b blnb;
typedef ui3r blnr;
#define trueblnr 1
#define falseblnr 0

/* error type */

typedef ui4r tMyErr;
