/*
	DBGLGSTC.h
	Copyright (C) 2008 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	DeBuGging LoG to Text file using STandard C library
*/

static void dbglog_writeCStr(const char *s)
{
	fprintf(stderr, "%s", s);
}

static void dbglog_writeChar(char v)
{
	fprintf(stderr, "%c", v);
}

static void dbglog_writeHexByte(ui3r v)
{
	fprintf(stderr, "%02X", v);
}

static void dbglog_writeNum(simr v)
{
	fprintf(stderr, "%d", (int)v);
}

static void dbglog_writeReturn(void)
{
	fprintf(stderr, "\n");
}

static void dbglog_writeSpace(void)
{
	fprintf(stderr, " ");
}

static void dbglog_writeln(char *s)
{
	dbglog_writeCStr(s);
	dbglog_writeReturn();
}

static void dbglog_writelnNum(char *s, simr v)
{
	dbglog_writeCStr(s);
	dbglog_writeSpace();
	dbglog_writeNum(v);
	dbglog_writeReturn();
}

static void debug_dump_buffer(char *s, unsigned char *p, uimr n)
{
	uimr i;

	dbglog_writeCStr(s);
	dbglog_writeCStr(" : ");

	for (i = n + 1; 0 != --i; ) {
		dbglog_writeHexByte(*p++);
	}

	dbglog_writeReturn();
}


#define Have_DEBUGLOG 1
