/*
	READBITS.h

	Copyright (c) 2017-present, MacPaw Inc., Paul C. Pratt

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
	MA 02110-1301  USA
*/

/*
	READ BITS
*/


static ui5r csib_bits = 0;
static ui3r csib_numbits = 0;

static tMyErr CSInputBufferAlloc(void)
{
	csib_bits = 0;
	csib_numbits = 0;

	return kMyErr_noErr;
}

static void CSInputBufferFree(void)
{
}


static tMyErr _CSInputFillBitsLE(ui3r numbits)
{
	tMyErr err;

	if (csib_numbits > 24) {
		err = kMyErrParamErr;
	} else {
		ui3r v;

l_retry:
		if (kMyErr_noErr != (err = CSFileInReadByte(&v))) {
			/* fail */
		} else {
			csib_bits |= v << csib_numbits;
			csib_numbits += 8;
			if (numbits > csib_numbits) {
				goto l_retry;
			} else {
				err = kMyErr_noErr;
			}
		}
	}

	return err;
}

static tMyErr CSInputPeekBitStringLE(ui3r numbits, ui5r *x)
{
	tMyErr err;

	if (0 == numbits) {
		*x = 0;
		err = kMyErr_noErr;
	} else
	if ((numbits > csib_numbits)
		&& (kMyErr_noErr != (err = _CSInputFillBitsLE(numbits))))
	{
		/* fail */
	} else
	{
		*x = csib_bits & ((1 << numbits) - 1);
		err = kMyErr_noErr;
	}

	return err;
}

static tMyErr CSInputSkipPeekedBitsLE(ui3r numbits)
{
	tMyErr err;

	if (0 == numbits) {
		err = kMyErr_noErr;
	} else
	if (numbits > csib_numbits) {
		err = kMyErrParamErr;
	} else
	{
		csib_bits >>= numbits;
		csib_numbits -= numbits;
		err = kMyErr_noErr;
	}

	return err;
}


static tMyErr CSInputNextBitStringLE(ui3r numbits, ui5r *x)
{
	tMyErr err;

	if (kMyErr_noErr != (err = CSInputPeekBitStringLE(numbits, x))) {
		/* fail */
	} else
	if (kMyErr_noErr != (err = CSInputSkipPeekedBitsLE(numbits))) {
		/* fail */
	} else
	{
		err = kMyErr_noErr;
	}

	return err;
}


static tMyErr CSInputNextBitLE(ui3r *x)
{
	tMyErr err;
	ui5r v;

	if (kMyErr_noErr != (err = CSInputNextBitStringLE(1, &v))) {
		/* fail */
	} else
	{
		err = kMyErr_noErr;

		*x = v;
	}

	return err;
}
