/*
	STFFPARS.h

	Copyright (c) 2017-present, MacPaw Inc., Paul C. Pratt

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
	MA 02110-1301  USA
*/

/*
	STuFFit PARSer
*/

#define SITFH_COMPRMETHOD    0
	/* xadUINT8 rsrc fork compression method */
#define SITFH_COMPDMETHOD    1
	/* xadUINT8 data fork compression method */
#define SITFH_FNAMESIZE      2 /* xadUINT8 filename size */
#define SITFH_FNAME          3 /* xadUINT8 31 byte filename */
#define SITFH_FNAME_CRC     34 /* xadUINT16 crc of filename + size */

#define SITFH_UNK           36 /* xadUINT16 unknown, always 0x0986? */
#define SITFH_RSRCLONG      38 /* xadUINT32 unknown rsrc fork value */
#define SITFH_DATALONG      42 /* xadUINT32 unknown data fork value */
#define SITFH_DATACHAR      46
	/* xadUINT8 unknown data (yes, data) fork value */
#define SITFH_RSRCCHAR      47 /* xadUINT8 unknown rsrc fork value */
#define SITFH_CHILDCOUNT    48 /* xadUINT16 number of items in dir */
#define SITFH_PREVOFFS      50 /* xadUINT32 offset of previous entry */
#define SITFH_NEXTOFFS      54 /* xadUINT32 offset of next entry */
#define SITFH_PARENTOFFS    58 /* xadUINT32 offset of parent entry */
#define SITFH_CHILDOFFS     62
	/* xadINT32 offset of first child entry, -1 for file entries */

#define SITFH_FTYPE         66 /* xadUINT32 file type */
#define SITFH_CREATOR       70 /* xadUINT32 file creator */
#define SITFH_FNDRFLAGS     74 /* xadUINT16 Finder flags */
#define SITFH_CREATIONDATE  76 /* xadUINT32 creation date */
#define SITFH_MODDATE       80 /* xadUINT32 modification date */
#define SITFH_RSRCLENGTH    84 /* xadUINT32 decompressed rsrc length */
#define SITFH_DATALENGTH    88 /* xadUINT32 decompressed data length */
#define SITFH_COMPRLENGTH   92 /* xadUINT32 compressed rsrc length */
#define SITFH_COMPDLENGTH   96 /* xadUINT32 compressed data length */
#define SITFH_RSRCCRC      100 /* xadUINT16 crc of rsrc fork */
#define SITFH_DATACRC      102 /* xadUINT16 crc of data fork */

#define SITFH_RSRCPAD      104
	/* xadUINT8 rsrc padding bytes for encryption */
#define SITFH_DATAPAD      105
	/* xadUINT8 data padding bytes for encryption */
#define SITFH_DATAUNK1     106
	/* xadUINT8 unknown data value, always 0? */
#define SITFH_DATAUNK2     107
	/* xadUINT8 unknown data value, always 4 for encrypted? */
#define SITFH_RSRCUNK1     108
	/* xadUINT8 unknown rsrc value, always 0? */
#define SITFH_RSRCUNK2     109
	/* xadUINT8 unknown rsrc value, always 4 for encrypted? */

#define SITFH_HDRCRC       110 /* xadUINT16 crc of file header */
#define SIT_FILEHDRSIZE    112

#define StuffItEncryptedFlag 0x80 /* password protected bit */
#define StuffItStartFolder 0x20 /* start of folder */
#define StuffItEndFolder 0x21 /* end of folder */
#define StuffItFolderContainsEncrypted 0x10
	/* folder contains encrypted items bit */
#define StuffItMethodMask (~ StuffItEncryptedFlag)
#define StuffItFolderMask \
	(~ (StuffItEncryptedFlag | StuffItFolderContainsEncrypted))


#if 0
static tMyErr CStringForBytes(ui3b *bytes, uimr length, char **r)
{
	tMyErr err;
	char *charbuf;

	if (NULL == (charbuf = malloc(length + 1))) {
		err = errno2MyErr();
	} else
	{
		uimr i;

		for (i = 0; i < length; ++i) {
			charbuf[i] = ((char *)bytes)[i];
		}

		charbuf[length] = 0;

		*r = charbuf;

		err = kMyErr_noErr;
	}

	return err;
}
#endif

static tMyErr stuffit_recognizeFileWithHandle(void)
{
	tMyErr err;
	ui5r signature;
	ui4r numfiles;
	ui5r totalsize;
	ui5r signature2;
	ui3r version;
	ui3r reserved1;
	ui5r headersize;
	ui4r crc;
	ui3b header[SIT_FILEHDRSIZE];
	ui3r resourcemethod;
	ui3r datamethod;
	ui3r compressionmethod;
	ui3r namelen;
	/* ui5r resourcelength; */
	ui5r resourcecomplen;
	ui5r datalength;
	ui5r datacomplen;
	/* ui4r StuffItCRC16; */
	/* ui3r resourcepadding; */
	/* ui3r datapadding; */

	if (kMyErr_noErr != (err = CSFileInReadUi5BE(&signature))) {
		goto l_exit;
	}

	if (0x53495421 != signature) {
#if DebugCheck
		dbglog_writeln("StuffIt signature wrong");
#endif
		err = kMyErrParamErr;
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadUi4BE(&numfiles))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadUi5BE(&totalsize))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadUi5BE(&signature2))) {
		goto l_exit;
	}

	if (0x724c6175 != signature2)
	{
#if DebugCheck
		dbglog_writeln("StuffIt signature2 wrong");
#endif
		err = kMyErrParamErr;
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadByte(&version))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadByte(&reserved1))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadUi5BE(&headersize))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInReadUi4BE(&crc))) {
		goto l_exit;
	}

	/* if (version == 1) { headersize=22; } */

	if (kMyErr_noErr != (err =
		CSFileInReadBytes(SIT_FILEHDRSIZE, header)))
	{
		goto l_exit;
	}

#if 0
	if(CSUInt16BE(header + SITFH_HDRCRC)
		!= XADCalculateCRC(0, header, 110, XADCRCTable_a001))
	{
		err = kMyErr_crptfl;
		goto l_exit;
	}
#endif

	resourcemethod = header[SITFH_COMPRMETHOD];

	if (((resourcemethod & StuffItFolderMask) == StuffItStartFolder)
		|| ((resourcemethod & StuffItFolderMask) == StuffItEndFolder))
	{
		err = kMyErrParamErr;
		goto l_exit;
	}

	datamethod = header[SITFH_COMPDMETHOD];

	if (((datamethod & StuffItFolderMask) == StuffItStartFolder)
		|| ((datamethod & StuffItFolderMask) == StuffItEndFolder))
	{
		err = kMyErrParamErr;
		goto l_exit;
	}

	if (0 != (datamethod & StuffItEncryptedFlag)) {
		err = kMyErrParamErr;
		goto l_exit;
	}

	compressionmethod = datamethod & StuffItMethodMask;

	if (13 != (compressionmethod & 0x0f)) {
#if DebugCheck
		dbglog_writeln("unsupported compression method");
#endif
		err = kMyErrParamErr;
		goto l_exit;
	}

	namelen = header[SITFH_FNAMESIZE];
	if (namelen > 31) {
		namelen = 31;
	}

#if 0
	char *name = NULL;
	if (kMyErr_noErr != (err =
		CStringForBytes(header + SITFH_FNAME, namelen, &name)))
	{
		goto l_exit;
	}
	if (NULL != name) {
		free(name);
	}
#endif

	/* resourcelength = CSUInt32BE(header + SITFH_RSRCLENGTH); */
	resourcecomplen = CSUInt32BE(header + SITFH_COMPRLENGTH);
	datalength = CSUInt32BE(header + SITFH_DATALENGTH);
	datacomplen = CSUInt32BE(header + SITFH_COMPDLENGTH);

	(void)datacomplen;

	/* StuffItCRC16 = CSUInt16BE(header + SITFH_DATACRC); */

	/* resourcepadding = header[SITFH_RSRCPAD]; */
	/* datapadding = header[SITFH_DATAPAD]; */

	if (datalength == 0) {
#if DebugCheck
		dbglog_writeln("empty file");
#endif
		err = kMyErrParamErr;
		goto l_exit;
	}

	if (kMyErr_noErr != (err = CSFileInSkipBytes(resourcecomplen))) {
		goto l_exit;
	}

	if (kMyErr_noErr != (err = XADStuffIt13ReadAndWrite(datalength))) {
		goto l_exit;
	}

	err = kMyErr_noErr;

l_exit:
	return ErrReportStack(err, "stuffit_recognizeFileWithHandle");
}
