/*
	COREDEFS.h
	Copyright (C) 2018 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	CORE DEFinitionS
*/


#ifndef CommonTypes32
#define CommonTypes32 0
#endif


/* --- integer types, exact size ---- */

/* unsigned integers */

#ifndef HaveRealui3b
#ifdef UINT8_MAX
#define ui3b uint8_t
#define HaveRealui3b 1
#else
typedef unsigned char ui3b;
#if CommonTypes32
#define HaveRealui3b 1
#else
#define HaveRealui3b 0
#endif
#endif
#endif

#ifndef HaveRealui4b
#ifdef UINT16_MAX
#define ui4b uint16_t
#define HaveRealui4b 1
#else
#if CommonTypes32
typedef unsigned short int ui4b;
#define HaveRealui4b 1
#else
struct ui4b {
	ui3b f0;
	ui3b f1;
};
typedef struct ui4b ui4b;
#define HaveRealui4b 0
#endif
#endif
#endif

#ifndef HaveRealui5b
#ifdef UINT32_MAX
#define ui5b uint32_t
#define HaveRealui5b 1
#else
#if CommonTypes32
typedef unsigned long int ui5b;
#define HaveRealui5b 1
#else
struct ui5b {
	ui4b f0;
	ui4b f1;
};
typedef struct ui5b ui5b;
#define HaveRealui5b 0
#endif
#endif
#endif

#ifndef HaveRealui6b
#ifdef UINT64_MAX
#define ui6b uint64_t
#define HaveRealui6b 1
#else
struct ui6b {
	ui5b f0;
	ui5b f1;
};
typedef struct ui6b ui6b;
#define HaveRealui6b 0
#endif
#endif


/* signed integers */

#ifndef HaveRealsi3b
#ifdef INT8_MAX
#define si3b int8_t
#define HaveRealsi3b 1
#else
typedef signed char si3b;
#if CommonTypes32
#define HaveRealsi3b 1
#else
#define HaveRealsi3b 0
#endif
#endif
#endif

#ifndef HaveRealsi4b
#ifdef INT16_MAX
#define si4b int16_t
#define HaveRealsi4b 1
#else
#if CommonTypes32
typedef signed short int si4b;
#define HaveRealsi4b 1
#else
struct si4b {
	ui3b f0;
	si3b f1;
};
typedef struct si4b si4b;
#define HaveRealsi4b 0
#endif
#endif
#endif

#ifndef HaveRealsi5b
#ifdef INT32_MAX
#define si5b int32_t
#define HaveRealsi5b 1
#else
#if CommonTypes32
typedef signed long int si5b;
#define HaveRealsi5b 1
#else
struct si5b {
	ui4b f0;
	si4b f1;
};
typedef struct si5b si5b;
#define HaveRealsi5b 0
#endif
#endif
#endif

#ifndef HaveRealsi6b
#ifdef INT64_MAX
#define si6b int64_t
#define HaveRealsi6b 1
#else
struct si6b {
	ui5b f0;
	si5b f1;
};
typedef struct si6b si6b;
#define HaveRealsi6b 0
#endif
#endif


/* --- integer representation types ---- */

#ifndef HaveRealui3r
#ifdef UINT_LEAST8_MAX
#define ui3r uint_least8_t
#define HaveRealui3r 1
#else
#define ui3r ui3b
#define HaveRealui3r HaveRealui3b
#define ui3beqr 1
#endif
#endif

#ifndef HaveRealui4r
#ifdef UINT_LEAST16_MAX
#define ui4r uint_least16_t
#define HaveRealui4r 1
#else
#define ui4r ui4b
#define HaveRealui4r HaveRealui4b
#define ui4beqr 1
#endif
#endif

#ifndef HaveRealui5r
#ifdef UINT_LEAST32_MAX
#define ui5r uint_least32_t
#define HaveRealui5r 1
#else
#define ui5r ui5b
#define HaveRealui5r HaveRealui5b
#define ui5beqr 1
#endif
#endif

#ifndef HaveRealui6r
#ifdef UINT_LEAST64_MAX
#define ui6r uint_least64_t
#define HaveRealui6r 1
#else
#define ui6r ui6b
#define HaveRealui6r HaveRealui6b
#define ui6beqr 1
#endif
#endif


#ifndef HaveRealsi3r
#ifdef INT_LEAST8_MAX
#define si3r int_least8_t
#define HaveRealsi3r 1
#else
#define si3r si3b
#define HaveRealsi3r HaveRealsi3b
#define si3beqr 1
#endif
#endif

#ifndef HaveRealsi4r
#ifdef INT_LEAST16_MAX
#define si4r int_least16_t
#define HaveRealsi4r 1
#else
#define si4r si4b
#define HaveRealsi4r HaveRealsi4b
#define si4beqr 1
#endif
#endif

#ifndef HaveRealsi5r
#ifdef INT_LEAST32_MAX
#define si5r int_least32_t
#define HaveRealsi5r 1
#else
#define si5r si5b
#define HaveRealsi5r HaveRealsi5b
#define si5beqr 1
#endif
#endif

#ifndef HaveRealsi6r
#ifdef INT_LEAST64_MAX
#define si6r int_least64_t
#define HaveRealsi6r 1
#else
#define si6r si6b
#define HaveRealsi6r HaveRealsi6b
#define si6beqr 1
#endif
#endif


typedef si3b *si3p;
typedef ui3b *ui3p;
typedef si4b *si4p;
typedef ui4b *ui4p;
typedef si5b *si5p;
typedef ui5b *ui5p;

typedef ui5p *ui5h;
typedef ui4p *ui4h;
typedef ui3p *ui3h;


/* preferred counting type */

#ifndef uimbl2sz
#ifdef UINTPTR_MAX
#ifdef UINT64_MAX
#if UINTPTR_MAX == UINT64_MAX
#define uimbl2sz 6
#endif
#endif
#endif
#endif

#ifndef uimbl2sz
#define uimbl2sz 5
#endif

#if 5 == uimbl2sz
typedef si5r simr;
typedef ui5r uimr;
#endif

#if 6 == uimbl2sz
typedef si6r simr;
typedef ui6r uimr;
#endif

typedef ui3b blnb;
typedef ui3r blnr;
#define trueblnr 1
#define falseblnr 0

typedef si4r tMyErr;

typedef unsigned char MyPStr[256];
typedef unsigned char *ps3p;
typedef unsigned char MyCharR;
typedef MyCharR *MyCharPtr;

typedef unsigned char MyByte;
typedef MyByte *MyPtr;

#define nullpr ((void *) 0)

#define DISCARDVAL (void)


#define LOCALFUNC static
#define GLOBALFUNC static
#define EXPORTFUNC static
#define TYPEDEFFUNC typedef

#define LOCALPROC LOCALFUNC void
#define GLOBALPROC GLOBALFUNC void
#define EXPORTPROC EXPORTFUNC void
#define TYPEDEFPROC TYPEDEFFUNC void

#define LOCALVAR static
#define GLOBALVAR static
#define EXPORTVAR static

GLOBALVAR MyPtr pDt;
