/*
	FHMEMORY.h
	Copyright (C) 2007 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	Fake Handle MEMORY management
*/


struct MyHandle_R {
	MyPtr p;
	uimr L;
	uimr checkval;
};
typedef struct MyHandle_R MyHandle_R;
typedef MyHandle_R *MyHandle_P;

#if 0
typedef MyHandle_P MyHandle;
#else
typedef MyPtr *MyHandle;
#endif

#define MyHandleUseGuards 0

#define MyHandle_chkv 0x7F2DD768

#if MyHandleUseGuards

#define MyHandle_guard1_va 0xC7
#define MyHandle_guard1_vb 0xA3
#define MyHandle_guard1_sz 16

#define MyHandle_guard2_v 0x3D
#define MyHandle_guard2_sz 1

#define MyHandle_guards_sz (MyHandle_guard1_sz + MyHandle_guard2_sz)

#endif /* MyHandleUseGuards */

LOCALFUNC tMyErr MyHandleCheck(MyHandle h)
{
	tMyErr err;
	MyPtr p;
	MyHandle_P h0 = (MyHandle_P)h;

	if (nullpr == h0) {
#if DebugCheck
		dbglog_writeln("null handle");
#endif
		err = kMyErrProgramBug;
	} else
	if (MyHandle_chkv != h0->checkval) {
#if DebugCheck
		dbglog_writeln("bad checkval");
#endif
		err = kMyErrProgramBug;
	} else
	if (nullpr == (p = h0->p)) {
#if DebugCheck
		dbglog_writeln("empty handle");
#endif
		err = kMyErrProgramBug;
	} else
	{
#if MyHandleUseGuards
		p -= MyHandle_guard1_sz;

		if (MyHandle_guard1_va != p[0]) {
#if DebugCheck
			dbglog_writeln("guard1 wrong");
#endif
			err = kMyErrProgramBug;
		} else
		if (MyHandle_guard1_vb != p[MyHandle_guard1_sz - 1]) {
#if DebugCheck
			dbglog_writeln("guard1 wrong");
#endif
			err = kMyErrProgramBug;
		} else
		if (MyHandle_guard2_v != p[h0->L + MyHandle_guard1_sz]) {
#if DebugCheck
			dbglog_writeln("guard2 wrong");
#endif
			err = kMyErrProgramBug;
		} else
#endif /* MyHandleUseGuards */
		{
			err = kMyErr_noErr;
		}
	}

	return ErrReportStack(err, "MyHandleCheck");
}

LOCALPROC MyHandleSetUp(MyHandle_P h0, MyPtr p, uimr L)
{
#if MyHandleUseGuards
	p[0] = MyHandle_guard1_va;
	p[MyHandle_guard1_sz - 1] = MyHandle_guard1_vb;
	p[L + MyHandle_guard1_sz] = MyHandle_guard2_v;

	p += MyHandle_guard1_sz;
#endif /* MyHandleUseGuards */
	h0->p = p;
	h0->L = L;
	h0->checkval = MyHandle_chkv;
}

LOCALFUNC tMyErr MyHandleDispose_v2(MyHandle h)
{
	tMyErr err;
	MyHandle_P h0 = (MyHandle_P)h;

	if (kMyErr_noErr != (err = MyHandleCheck(h))) {
		/* fail */
	} else
	{
		MyPtr p = h0->p;

#if MyHandleUseGuards
		p -= MyHandle_guard1_sz;
#endif

		free(p);

		h0->checkval = 0;
		h0->L = 0;
		h0->p = nullpr;

		free(h0);

		err = kMyErr_noErr;
	}

	return ErrReportStack(err, "MyHandleDispose_v2");
}

LOCALFUNC tMyErr MyHandleNew_v2(uimr L, MyHandle *h)
{
	tMyErr err;
	MyPtr p;
	MyHandle_P h0;

	h0 = (MyHandle_P)malloc(sizeof(MyHandle_R));
	if (nullpr == h0) {
#if DebugCheck
		dbglog_writeln("malloc h0 fails");
#endif
		err = kMyErr_lowmem;
	} else {
		p = (MyPtr)malloc(L
#if MyHandleUseGuards
			+ MyHandle_guards_sz
#endif
			);
		if (nullpr == p) {
#if DebugCheck
			dbglog_writeln("malloc L fails");
#endif
			err = kMyErr_lowmem;
		} else {
			MyHandleSetUp(h0, p, L);
			err = kMyErr_noErr;
		}

		if (kMyErr_noErr != err) {
			free(h0);
		} else {
			*h = (MyHandle)h0;
		}
	}

	return ErrReportStack(err, "MyHandleNew_v2");
}

LOCALFUNC tMyErr MyHandleGetSize_v2(MyHandle h, uimr *L)
{
	tMyErr err;
	MyHandle_P h0 = (MyHandle_P)h;

	if (kMyErr_noErr != (err = MyHandleCheck(h))) {
		/* fail */
	} else
	{
		*L = h0->L;

		err = kMyErr_noErr;
	}

	return ErrReportStack(err, "MyHandleGetSize_v2");
}

LOCALFUNC tMyErr MyHandleSetSize_v2(MyHandle h, uimr L)
{
	tMyErr err;
	MyPtr p1;
	MyPtr p2;
	uimr oldL;
	uimr commonL;
	MyHandle_P h0 = (MyHandle_P)h;

	if (kMyErr_noErr != (err = MyHandleCheck(h))) {
		/* fail */
	} else
	{
		p1 = h0->p;
#if MyHandleUseGuards
		p1 -= MyHandle_guard1_sz;
#endif
		p2 = (MyPtr)malloc(L
#if MyHandleUseGuards
			+ MyHandle_guards_sz
#endif
			);

		if (nullpr == p2) {
#if DebugCheck
			dbglog_writeln("malloc L fails");
#endif
			err = kMyErr_lowmem;
		} else {
			oldL = h0->L;
			commonL = (L < oldL) ? L : oldL;

#if MyHandleUseGuards
			commonL += MyHandle_guard1_sz;
#endif
			MyMoveBytes(p1, p2, commonL);
			MyHandleSetUp(h0, p2, L);

			free(p1);

			err = kMyErr_noErr;
		}
	}

	return ErrReportStack(err, "MyHandleSetSize_v2");
}

LOCALPROC MyHandleLock(MyHandle h)
{
	if (kMyErr_noErr != MyHandleCheck(h)) {
#if DebugCheck
		dbglog_writeln("in MyHandleLock");
#endif
	}
}

LOCALPROC MyHandleUnlock(MyHandle h)
{
	if (kMyErr_noErr != MyHandleCheck(h)) {
#if DebugCheck
		dbglog_writeln("in MyHandleUnlock");
#endif
	}
}

LOCALFUNC MyPtr MyHandleP(MyHandle h)
{
	MyHandle_P h0 = (MyHandle_P)h;

	if (kMyErr_noErr != MyHandleCheck(h)) {
#if DebugCheck
		dbglog_writeln("in MyHandleP");
#endif
	}

	return (h0->p);
}

LOCALFUNC MyPtr MyHandleOffsetToPtr(MyHandle h, uimr offset)
{
	MyHandle_P h0 = (MyHandle_P)h;

	if (kMyErr_noErr != MyHandleCheck(h)) {
#if DebugCheck
		dbglog_writeln("in MyHandleOffsetToPtr");
#endif
	}

	return (h0->p) + offset;
}

GLOBALFUNC tMyErr MyMemory_Init_v2(void)
{
	return kMyErr_noErr;
}

GLOBALPROC MyMemory_UnInit(void)
{
}
