/*
	PKCOMLIB.h
*/

/*
	Public Key signatures, COMmon code LIBrary
*/

#define kMyErr_WrongPublicKey 4096
#define kMyErr_BadSignature 4097
#define kMyErr_UndesiredChar 4098

#define equal_buffers(buf1, buf2, count) (! memcmp(buf1, buf2, count))

	/* Zero-fill the byte buffer. */
#define fill0(buffer, count) memset(buffer, 0, count)


/* Check signature in infile for validity. */
LOCALFUNC tMyErr MDfileFromHandle(struct MD5Context *MD, MyHandle inH)
{
	tMyErr err;
	uimr L;

	if (kMyErr_noErr == (err =
		MyHandleGetSize_v2(inH, &L)))
	{
		MyHandleLock(inH);
		MD5Update(MD, (ui3b *)MyHandleP(inH), L);
		MyHandleUnlock(inH);
	}

	return ErrReportStack(err, "MDfileFromHandle");
}

/* Check signature in infile for validity. */
LOCALFUNC tMyErr MDfileFromJustHandle(ui3p md5buf,
	MyHandle inH)
{
	tMyErr err;
	struct MD5Context MD;

	/*
		assuming inH already in canonical form
		(read_gry_signedfile_message)
	*/

	MD5Init(&MD);

	err = MDfileFromHandle(&MD, inH);

	MD5Final(md5buf, &MD);

	return ErrReportStack(err, "MDfileFromJustHandle");
}

LOCALFUNC tMyErr CrcFromJustHandle(MyHandle h, crcword *r)
{
	tMyErr err;
	uimr L;
	crcword crc = crcinitv();

	if (kMyErr_noErr == (err =
		MyHandleGetSize_v2(h, &L)))
	{
		MyHandleLock(h);
		crc = crcbytes((ui3b *)MyHandleP(h), L, crc);
		MyHandleUnlock(h);
	}

	*r = crc;

	return ErrReportStack(err, "CrcFromJustHandle");
}

LOCALPROC MyBytesRotateLeft(ui3p p, uimr n)
{
	ui3r t = *p;

	MyMoveBytes(p + 1, p, n - 1);

	p[n - 1] = t;
}

LOCALFUNC tMyErr MyHandRotateLeft(MyHandle h)
{
	tMyErr err;
	uimr L;

	if (kMyErr_noErr == (err =
		MyHandleGetSize_v2(h, &L)))
	{
		MyHandleLock(h);
		MyBytesRotateLeft((ui3p)MyHandleP(h), L);
		MyHandleUnlock(h);
	}

	return ErrReportStack(err, "MyHandRotateLeft");
}


#ifndef min /* if min macro not already defined */
#define min(a, b) (((a)<  (b)) ? (a) : (b) )
#define max(a, b) (((a) > (b)) ? (a) : (b) )
#endif /* if min macro not already defined */

/* Ask for each key separately if it should be added to the keyring */



LOCALFUNC tMyErr MyHandRngFindLeadingSpace(MyHandle h,
	uimr offsetA, uimr offsetB, uimr *offsetR)
{
	char c;
	uimr i = offsetA;

l_retry:
	if (i < offsetB) {
		c = (char)((*h)[i]);

		if ((' ' == c) || (0x09 == c) || (0x0D == c) || (0x0A == c)) {
			++i;
			goto l_retry;
		}
	}

	*offsetR = i;

	return kMyErr_noErr;
}

LOCALFUNC tMyErr MyHandRngFindTrailingSpace(MyHandle h,
	uimr offsetA, uimr offsetB, uimr *offsetR)
{
	char c;
	uimr i = offsetB;

l_retry:
	if (i > offsetA) {
		c = (char)((*h)[i - 1]);

		if ((' ' == c) || (0x09 == c) || (0x0D == c) || (0x0A == c)) {
			--i;
			goto l_retry;
		}
	}

	*offsetR = i;

	return kMyErr_noErr;
}

LOCALFUNC tMyErr MyHandRngFindFirstLine(MyHandle h,
	uimr offsetA, uimr offsetB, uimr *offsetR1, uimr *offsetR2)
{
	char c;
	uimr i0;
	uimr i = offsetA;

l_retry:
	i0 = i;
	if (i < offsetB) {
		c = (char)((*h)[i]);
		++i;

		if (0x0D == c) {
			/* ok */
		} else
		if (0x0A == c) {
			if (i < offsetB) {
				c = (char)((*h)[i]);
				if (0x0D == c) {
					++i;
				}
			}
		} else
		{
			goto l_retry;
		}
	}

	*offsetR1 = i0;
	*offsetR2 = i;

	return kMyErr_noErr;
}

LOCALFUNC tMyErr MyHandRngFindLastLine(MyHandle h,
	uimr offsetA, uimr offsetB, uimr *offsetR1, uimr *offsetR2)
{
	char c;
	uimr i0;
	uimr i = offsetB;

l_retry:
	i0 = i;
	if (i > offsetA) {
		--i;
		c = (char)((*h)[i]);

		if (0x0D == c) {
			if (i > offsetA) {
				--i;
				c = (char)((*h)[i]);
				if (0x0A != c) {
					++i;
				}
			}
		} else
		if (0x0A == c) {
			/* ok */
		} else
		{
			goto l_retry;
		}
	}

	*offsetR1 = i;
	*offsetR2 = i0;

	return kMyErr_noErr;
}

LOCALFUNC tMyErr MyHandPartEqualPtr(MyHandle h,
	uimr offset, uimr L,
	ui3p p)
{
	tMyErr err;

l_retry:
	if (0 == L) {
		err = kMyErr_noErr;
	} else
	if (*p != (char)((*h)[offset])) {
		err = kMyErrNoMatch;
	} else
	{
		++p;
		++offset;
		--L;
		goto l_retry;
	}

#if DebugCheck
	if ((kMyErr_noErr != err)
		&& (kMyErrNoMatch != err))
	{
		err = ErrReportStack0(err, "MyHandPartEqualPtr");
	}
#endif

	return err;
}

LOCALFUNC tMyErr MyHandRngEqualCStr(MyHandle h,
	uimr offsetA, uimr offsetB,
	char *s)
{
	tMyErr err;
	uimr L = offsetB - offsetA;
	uimr sL = strlen(s);

	if (sL != L) {
		err = kMyErrNoMatch;
	} else {
		err = MyHandPartEqualPtr(h, offsetA, L, (ui3p)s);
	}

#if DebugCheck
	if ((kMyErr_noErr != err)
		&& (kMyErrNoMatch != err))
	{
		err = ErrReportStack0(err, "MyHandRngEqualCStr");
	}
#endif

	return err;
}

LOCALFUNC tMyErr MyHandRngMatchLeading(MyHandle h,
	uimr offsetA, uimr offsetB,
	ui3p p, uimr L,
	uimr *offsetR)
{
	tMyErr err;
	uimr L0 = offsetB - offsetA;

	if (L0 < L) {
		err = kMyErrNoMatch;
	} else
	if (kMyErr_noErr != (err =
		MyHandPartEqualPtr(h, offsetA, L, p)))
	{
		/* fail */
	} else
	{
		err = kMyErr_noErr;

		*offsetR = offsetA + L;
	}

#if DebugCheck
	if ((kMyErr_noErr != err)
		&& (kMyErrNoMatch != err))
	{
		err = ErrReportStack0(err, "MyHandRngMatchLeading");
	}
#endif

	return err;
}

LOCALFUNC tMyErr MyHandRngFindTrailingMatchChar(MyHandle h,
	uimr offsetA, uimr offsetB, char x, uimr *offsetR)
{
	uimr i = offsetB;

l_retry:
	if (i > offsetA) {
		--i;

		if (x == (char)((*h)[i])) {
			goto l_retry;
		} else {
			++i;
		}
	}

	*offsetR = i;

	return kMyErr_noErr;
}

LOCALFUNC tMyErr MyHandRngFindFirstLnRmvSpc(MyHandle h,
	uimr offsetA, uimr offsetB, uimr *offsetR1, uimr *offsetR2)
{
	tMyErr err;
	uimr o1;
	uimr o2;
	uimr o3;

	if (kMyErr_noErr != (err =
		MyHandRngFindFirstLine(h, offsetA, offsetB, &o1, &o2)))
	{
		/* fail */
	} else
	if (kMyErr_noErr != (err =
		MyHandRngFindTrailingMatchChar(h, offsetA, o1, ' ', &o3)))
	{
		/* fail */
	} else
	{
		*offsetR1 = o3;
		*offsetR2 = o2;
	}

	return ErrReportStack(err, "MyHandRngFindFirstLnRmvSpc");
}

LOCALFUNC tMyErr MyHandRngFindLastLnRmvSpc(MyHandle h,
	uimr offsetA, uimr offsetB, uimr *offsetR1, uimr *offsetR2)
{
	tMyErr err;
	uimr o1;
	uimr o2;
	uimr o3;

	if (kMyErr_noErr != (err =
		MyHandRngFindLastLine(h, offsetA, offsetB, &o1, &o2)))
	{
		/* fail */
	} else
	if (kMyErr_noErr != (err =
		MyHandRngFindTrailingMatchChar(h, offsetA, o1, ' ', &o3)))
	{
		/* fail */
	} else
	{
		*offsetR1 = o3;
		*offsetR2 = o2;
	}

	return ErrReportStack(err, "MyHandRngFindLastLnRmvSpc");
}

LOCALFUNC tMyErr MyHandRngFindLastMatchLine(MyHandle h,
	uimr offsetA, uimr offsetB,
	ui3p p, uimr L,
	uimr *offsetR1, uimr *offsetR2)
{
	tMyErr err;
	uimr o7;
	uimr o8;
	uimr i = offsetB;
	uimr i0 = i;

l_retry:
	if (i <= offsetA) {
		err = kMyErrNoMatch;
	} else
	{
		if (kMyErr_noErr != (err =
			MyHandRngFindLastLnRmvSpc(h, offsetA, i, &o7, &o8)))
		{
			/* fail */
		} else
		if (i - o8 != L) {
			i0 = o8;
			i = o7;
			goto l_retry;
		} else
		if (kMyErr_noErr != (err =
			MyHandPartEqualPtr(h, o8, i - o8,
				p)))
		{
			if (kMyErrNoMatch == err) {
				i0 = o8;
				i = o7;
				goto l_retry;
			}
		} else
		{
			*offsetR1 = o7;
			*offsetR2 = i0;
		}
	}

	return ErrReportStack(err, "MyHandRngFindLastMatchLine");
}

LOCALFUNC tMyErr MyHandRngRemoveMatchLeading(MyHandle h,
	uimr offsetA, uimr offsetB,
	ui3p p, uimr L,
	uimr *offsetR)
{
	tMyErr err;

	if (kMyErr_noErr != (err =
		MyHandRngMatchLeading(h, offsetA, offsetB,
			p, L, offsetR)))
	{
		if (kMyErrNoMatch == err) {
			*offsetR = offsetA;
			err = kMyErr_noErr;
		}
	} else {
		/* ok */
	}

	return ErrReportStack(err, "MyHandRngRemoveMatchLeading");
}

LOCALFUNC tMyErr MyHandRngCheckPlainAscii(MyHandle h,
	uimr offsetA, uimr offsetB)
{
	tMyErr err;
	char c;
	uimr i = offsetA;

	for (i = offsetA; i < offsetB; ++i) {
		c = (char)((*h)[i]);

		if ((c >= 127)
			|| ((c < ' ') && ('\015' != c)
				&& ('\011' != c) && ('\012' != c)))
		{
			err = SetSyntaxErrCStr("Not a Plain ASCII character",
				i, i + 1);
			goto l_exit;
		}
	}

	err = kMyErr_noErr;

l_exit:
	return ErrReportStack(err, "MyHandRngCheckPlainAscii");
}

LOCALFUNC tMyErr MyHandFindLeadingTrailingSpace(MyHandle h,
	uimr *offsetA, uimr *offsetB)
{
	tMyErr err;
	uimr L;
	uimr o1;
	uimr o2;

	if (kMyErr_noErr != (err =
		MyHandleGetSize_v2(h, &L)))
	{
		goto l_exit;
	}

	if (kMyErr_noErr != (err =
		MyHandRngCheckPlainAscii(h, 0, L)))
	{
		goto l_exit;
	}

	if (kMyErr_noErr != (err =
		MyHandRngFindLeadingSpace(h, 0, L, &o1)))
	{
		goto l_exit;
	}

	if (kMyErr_noErr != (err =
		MyHandRngFindTrailingSpace(h, o1, L, &o2)))
	{
		goto l_exit;
	}

	*offsetA = o1;
	*offsetB = o2;

l_exit:
	return ErrReportStack(err, "MyHandFindLeadingTrailingSpace");
}

LOCALFUNC tMyErr read_gry_signedfile_message(MyHandle h,
	uimr offsetA, uimr offsetB)
{
	tMyErr err;
	uimr o_eol;
	uimr o_nexti;
	uimr i = offsetA;

l_retry:
	if (i == offsetB) {
		err = kMyErr_noErr;
	} else
	if (kMyErr_noErr != (err =
		MyHandRngFindFirstLnRmvSpc(h, i, offsetB, &o_eol, &o_nexti)))
	{
		/* fail */
	} else
	if ((i != offsetA) && (kMyErr_noErr != (err =
		WriteBuffCharCR())))
	{
		/* fail */
	} else
	if (kMyErr_noErr != (err =
		WriteBuffFromHandRng(h, i, o_eol)))
	{
		/* fail */
	} else
	{
		i = o_nexti;
		goto l_retry;
	}

	return ErrReportStack(err, "read_gry_signedfile_message");
}

LOCALFUNC tMyErr read_gry_signedfile_message_H(MyHandle inH,
	uimr offsetA, uimr offsetB,
	MyHandle *litH)
{
	tMyErr err;

	if (kMyErr_noErr == (err =
		WriteBuffXhndBegin()))
	{
		err = read_gry_signedfile_message(inH, offsetA, offsetB);

		err = WriteBuffXhndEnd(err, litH);
	}

	return ErrReportStack(err, "read_gry_signedfile_message_H");
}



#define AdvanceCharEOF '\000'

LOCALVAR ui3r CurrentChar;

LOCALVAR tMyErr ReadBuffAdvanceErr;

LOCALPROC ReadBuffAdvanceChar(void)
{
	tMyErr err;

	if (ReadBuffEOF()) {
		CurrentChar = AdvanceCharEOF;
	} else
	if (kMyErr_noErr != (err = ReadBuffToByte(&CurrentChar))) {
		/* fail */
		if (kMyErr_noErr == ReadBuffAdvanceErr) {
			ReadBuffAdvanceErr = err;
		}
		CurrentChar = AdvanceCharEOF;
	}
}

#if 0
LOCALPROC ReadBuffUnAdvance(void)
{
	if (AdvanceCharEOF == CurrentChar) {
		/* ok */
	} else {
		ungetc(CurrentChar, ReadBuffFP);
		ReadBuffOffSet -= 1;
	}
}
#endif

LOCALPROC ReadBuffBeginAdvance(void)
{
	ReadBuffAdvanceErr = kMyErr_noErr;

	ReadBuffAdvanceChar();
}

LOCALFUNC blnr CharToHexNib(MyCharR c, ui3r *i)
{
	blnr v;

	if ((c >= '0') && (c <= '9')) {
		*i = c - '0';
		v = trueblnr;
	} else
	if ((c >= 'A') && (c <= 'F')) {
		*i = c - 'A' + 10 ;
		v = trueblnr;
	} else
	if ((c >= 'a') && (c <= 'f')) {
		*i = c - 'a' + 10 ;
		v = trueblnr;
	} else
	{
		v = falseblnr;
	}

	return v;
}

LOCALFUNC tMyErr ReadOneHexNib(ui3r *i)
{
	tMyErr err;
	ui3r c;

l_retry:
	if (AdvanceCharEOF == (c = CurrentChar)) {
		*i = 0xFF;
		err = kMyErr_noErr;
	} else
	if (CharToHexNib(c, i)) {
		ReadBuffAdvanceChar();
		err = kMyErr_noErr;
	} else
	if (('\012' == c)
		|| ('\015' == c)
		|| (' ' == c))
	{
		ReadBuffAdvanceChar();
		goto l_retry;
	} else
	{
		err = kMyErr_failr;
	}

	return ErrReportStack(err, "ReadOneHexNib");
}

/*
	copy file f to file g, for longcount bytes.  Convert to
	canonical form as we go.  f is open in text mode.  Canonical
	form uses crlf's as line separators.
*/
LOCALFUNC tMyErr ConvertHex2Bin(void)
{
	tMyErr err;
	ui3r i0;
	ui3r i1;

l_retry:
	if (kMyErr_noErr != (err = ReadOneHexNib(&i0))) {
		/* fail */
	} else
	if (0xFF == i0) {
		/* eof, ok */
		err = kMyErr_noErr;
	} else
	if (kMyErr_noErr != (err = ReadOneHexNib(&i1))) {
		/* fail */
	} else
	if (0xFF == i1) {
		/* eof, not ok */
		err = kMyErr_eofile;
	} else
	if (kMyErr_noErr != (err =
		WriteBuffFromByte(16 * i0 + i1)))
	{
		/* fail */
	} else
	{
		/* dbglog_writeHexByte(16 * i0 + i1); */
		goto l_retry;
	}

	return ErrReportStack(err, "ConvertHex2Bin");
}

/* Copy srcFile to destFile, converting to canonical text form  */
LOCALFUNC tMyErr ConvertHex2Bin_H(MyHandle srcH, MyHandle *destH)
{
	tMyErr err;

	if (kMyErr_noErr !=
		(err = WriteBuffXhndBegin()))
	{
		/* fail */
	} else {
		if (kMyErr_noErr != (err =
			ReadFromBuffXhndBegin(srcH)))
		{
			/* fail */
		} else {
			ReadBuffBeginAdvance();

			err = ConvertHex2Bin();

			if (kMyErr_noErr != ReadBuffAdvanceErr) {
				err = ReadBuffAdvanceErr;
			}

			err = ReadBuffFromXhndEnd(err);
		}

		err = WriteBuffXhndEnd(err, destH);
	}

	return ErrReportStack(err, "ConvertHex2Bin_H");
}

/*
	Begin ASCII armor routines.
	This converts a binary file into printable ASCII characters, in a
	radix-64 form mostly compatible with the MIME format.
	This makes it easier to send encrypted files over a 7-bit channel.
*/

/*
	Index this array by a 6 bit value to get the character
	corresponding to that value.
*/
LOCALVAR
unsigned char bintoasc[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*
	Index this array by a 7 bit value to get the 6-bit
	binary field corresponding to that value.  Any illegal
	characters return high bit set.
*/
LOCALVAR
unsigned char asctobin[] =
{
	0200, 0200, 0200, 0200, 0200, 0200, 0200, 0200,
	0200, 0200, 0200, 0200, 0200, 0200, 0200, 0200,
	0200, 0200, 0200, 0200, 0200, 0200, 0200, 0200,
	0200, 0200, 0200, 0200, 0200, 0200, 0200, 0200,
	0200, 0200, 0200, 0200, 0200, 0200, 0200, 0200,
	0200, 0200, 0200, 0076, 0200, 0200, 0200, 0077,
	0064, 0065, 0066, 0067, 0070, 0071, 0072, 0073,
	0074, 0075, 0200, 0200, 0200, 0200, 0200, 0200,
	0200, 0000, 0001, 0002, 0003, 0004, 0005, 0006,
	0007, 0010, 0011, 0012, 0013, 0014, 0015, 0016,
	0017, 0020, 0021, 0022, 0023, 0024, 0025, 0026,
	0027, 0030, 0031, 0200, 0200, 0200, 0200, 0200,
	0200, 0032, 0033, 0034, 0035, 0036, 0037, 0040,
	0041, 0042, 0043, 0044, 0045, 0046, 0047, 0050,
	0051, 0052, 0053, 0054, 0055, 0056, 0057, 0060,
	0061, 0062, 0063, 0200, 0200, 0200, 0200, 0200
};


#define PAD '='

/*
	ASCII armor decode routines.
*/
LOCALFUNC tMyErr
darmor_buffer(char *inbuf, char *outbuf, int *outlength)
{
	tMyErr err;
	unsigned char *bp;
	int length;
	unsigned int c1, c2, c3, c4;
	register int j;

	length = 0;
	bp = (unsigned char *) inbuf;

	/* FOUR input characters go into each THREE output charcters */

	while (*bp != '\0') {
		if ((*bp & 0x80) || ((c1 = asctobin[*bp]) & 0x80)) {
			err = kMyErr_UndesiredChar;
			goto l_exit;
		}
		++bp;
		if ((*bp & 0x80) || ((c2 = asctobin[*bp]) & 0x80)) {
			err = kMyErr_UndesiredChar;
			goto l_exit;
		}
		++bp;
		if (*bp == PAD) {
			c3 = c4 = 0;
			length += 1;
			if (0 != (c2 & 15)) {
				err = kMyErr_UndesiredChar;
				goto l_exit;
			}
			if (strcmp((char *) bp, "==") == 0) {
				bp += 2;
			} else if (strcmp((char *) bp, "=3D=3D") == 0) {
				bp += 6;
			} else {
				err = kMyErr_UndesiredChar;
				goto l_exit;
			}
		} else
		if ((*bp & 0x80) || ((c3 = asctobin[*bp]) & 0x80)) {
			err = kMyErr_UndesiredChar;
			goto l_exit;
		} else
		{
			++bp;
			if (*bp == PAD) {
				c4 = 0;
				length += 2;
				if (0 != (c3 & 3)) {
					err = kMyErr_UndesiredChar;
					goto l_exit;
				}
				if (strcmp((char *) bp, "=") == 0) { /* All is well */
					++bp;
				} else if (strcmp((char *) bp, "=3D") == 0) {
					bp += 3;
				} else {
					err = kMyErr_UndesiredChar;
					goto l_exit;
				}
			} else if ((*bp & 0x80) || ((c4 = asctobin[*bp]) & 0x80)) {
				err = kMyErr_UndesiredChar;
				goto l_exit;
			} else {
				length += 3;
				++bp;
			}
		}
		j = (c1 << 2) | (c2 >> 4);
		*outbuf++ = j;
		j = (c2 << 4) | (c3 >> 2);
		*outbuf++ = j;
		j = (c3 << 6) | c4;
		*outbuf++ = j;
	}

	*outlength = length;

	err = kMyErr_noErr; /* normal return */

l_exit:
	return ErrReportStack(err, "darmor_buffer");
}

/*
	ENC is the basic 1 character encoding function to make a
	char printing
*/
#define ENC(c) ((int)bintoasc[((c) & 0x3F)])

/*
	output one group of up to 3 bytes, pointed at by p, on file f.
*/
LOCALFUNC tMyErr
outdec(ui3b *p, uimr count)
{
	ui4r v;
	ui4r x;
	ui3b ca[4];
	ui3b *q = ca;

	v = *p++;
	*q++ = ENC(v >> 2);
	v = (v & 0x03) << 8;
	if (0 != --count) {
		/* v |= *p++; */
		/* seem to be compiler bug, work around */
		x = *p++;
		v |= x;
	}
	*q++ = ENC(v >> 4);
	if (0 == count) {
		*q++ = PAD;
		*q++ = PAD;
	} else {
		v = (v & 0x0F) << 8;
		if (0 != --count) {
			x = *p++;
			v |= x;
		}
		*q++ = ENC(v >> 6);
		if (0 == count) {
			*q++ = PAD;
		} else {
			/* v = (v & 0x3F) << 8; */
			*q++ = ENC(v);
		}
	}

	return WriteBuffFromPtr(ca, 4);
}

/*
	Encode a file in sections.  64 ASCII bytes * 720 lines = 46K,
	recommended max.  Usenet message size is 50K so this leaves a nice
	margin for .signature.  In the interests of orthogonality and
	programmer laziness no check is made for a message containing only
	a few lines (or even just an 'end')  after a section break.
*/
#define LINE_LEN        48L

LOCALFUNC tMyErr
write_armored_line(ui3b *buffer, uimr n)
{
	tMyErr err;

l_retry:
	if (0 == n) {
		err = kMyErr_noErr;
	} else
	if (n < 3) {
		err = outdec(buffer, n);
	} else
	{
		if (kMyErr_noErr == (err =
			outdec(buffer, 3)))
		{
			buffer += 3;
			n -= 3;
			goto l_retry;
		}
	}

	return ErrReportStack(err, "write_armored_line");
}

LOCALFUNC tMyErr
write_armored(void)
{
	tMyErr err;
	uimr length;
	int bytesRead;
	ui3b buffer[LINE_LEN];

l_retry:
	if (kMyErr_noErr != (err =
		ReadBuffRemaining(&length)))
	{
		/* fail */
	} else
	if (0 == length) {
		/* ok */
		err = kMyErr_noErr;
	} else
	{
		bytesRead = (length > LINE_LEN) ? LINE_LEN : length;
		if (kMyErr_noErr != (err =
			ReadBuffToPtr(buffer, bytesRead)))
		{
			/* fail */
		} else {
			if (bytesRead < LINE_LEN) {
				fill0(buffer + bytesRead, LINE_LEN - bytesRead);
			}

			if (kMyErr_noErr != (err =
				write_armored_line(buffer, bytesRead)))
			{
				/* fail */
			} else
			if (kMyErr_noErr != (err =
				WriteBuffCharCR()))
			{
				/* fail */
			} else
			{
				goto l_retry;
			}
		}
	}

	return ErrReportStack(err, "write_armored");
}

LOCALFUNC tMyErr
write_armored_H(MyHandle inH)
{
	tMyErr err;

	if (kMyErr_noErr != (err =
		ReadFromBuffXhndBegin(inH)))
	{
		/* fail */
	} else
	{
		err = write_armored();

		err = ReadBuffFromXhndEnd(err);
	}

	return ErrReportStack(err, "write_armored_H");
}

#if 1
/*
	This limit is advisory only; longer lines are handled
	properly. The only requirement is that this be at least
	as long as the longest delimiter string used by PGP
	(e.g. "-----BEGIN PGP MESSAGE, PART %02d/%02d-----\n")
*/
#define MAX_LINE_SIZE 80
#else
#define MAX_LINE_SIZE 1024
#endif

LOCALFUNC tMyErr ArmorLineDecode(MyHandle h,
	uimr offsetA, uimr offsetB)
{
	tMyErr err;
	uimr L;
	char inbuf[MAX_LINE_SIZE];
	char outbuf[MAX_LINE_SIZE];
	int n;

	if ((L = offsetB - offsetA) >= MAX_LINE_SIZE - 1) {
		err = kMyErrParamErr;
	} else
	{
		MyHandlePartToCStr(h, offsetA, L, inbuf);

		if (kMyErr_noErr != (err =
			darmor_buffer(inbuf, outbuf, &n)))
		{
			/* fail */
		} else
		if (kMyErr_noErr != (err =
			WriteBuffFromPtr((MyPtr)outbuf, n)))
		{
			/* fail */
		} else
		{
			err = kMyErr_noErr;
		}
	}

	return ErrReportStack(err, "ArmorLineDecode");
}

LOCALFUNC tMyErr ArmorFileDecode(MyHandle h,
	uimr offsetA, uimr offsetB)
{
	tMyErr err;
	uimr o_eol;
	uimr o_nexti;
	uimr i = offsetA;

l_retry:
	if (i == offsetB) {
		err = kMyErr_noErr;
	} else
	if (kMyErr_noErr != (err =
		MyHandRngFindFirstLnRmvSpc(h, i, offsetB, &o_eol, &o_nexti)))
	{
		/* fail */
	} else
	if (kMyErr_noErr != (err =
		ArmorLineDecode(h, i, o_eol)))
	{
		/* fail */
	} else
	{
		i = o_nexti;
		goto l_retry;
	}

	return ErrReportStack(err, "ArmorFileDecode");
}

LOCALFUNC tMyErr ArmorFileDecode_H(MyHandle inH,
	uimr offsetA, uimr offsetB,
	MyHandle *outH)
{
	tMyErr err;

	if (kMyErr_noErr == (err =
		WriteBuffXhndBegin()))
	{
		err = ArmorFileDecode(inH, offsetA, offsetB);

		err = WriteBuffXhndEnd(err, outH);
	}

	return ErrReportStack(err, "ArmorFileDecode_H");
}
