/*
	RWARBINT.h
	Copyright (C) 2018 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	Read and Write ARBitrary sized non negative INTegers
*/


LOCALFUNC tMyErr ReadLargeFormatInt_v2(ui3r elsz, uimr *i)
/* should almost never use this */
{
	tMyErr err;
	uimr b;
	uimr n = (1 << (elsz - uimbl2sz)) - 1;

	if (kMyErr_noErr != (err =
		ReadBuffUimLE(i)))
	{
		/* fail */
	} else {
		uimr j = 0;

label_retry:
		if (j == n) {
			err = kMyErr_noErr;
		} else if (kMyErr_noErr != (err =
			ReadBuffUimLE(&b)))
		{
			/* fail */
		} else if (0 != b) {
			err = kMyErr_toomni;
		} else {
			++j;
			goto label_retry;
		}
	}

	return ErrReportStack(err, "ReadLargeFormatInt_v2");
}

LOCALFUNC tMyErr ReadBuffUiElszLE(ui3r elsz, uimr *i)
{
	tMyErr err;

	if (elsz <= 3) {
		/* could get here with degenerate large format integer */
		ui3r b;

		if (kMyErr_noErr != (err =
			ReadBuffToByte(&b)))
		{
			/* fail */
		} else {
			err = kMyErr_noErr;
			*i = b;
		}
	} else
#if uimbl2sz > 4
	if (4 == elsz) {
		ui4r b;

		if (kMyErr_noErr != (err =
			ReadBuffUi4LE(&b)))
		{
			/* fail */
		} else {
			err = kMyErr_noErr;
			*i = b;
		}
	} else
#endif
#if uimbl2sz > 5
	if (5 == elsz) {
		ui5r b;

		if (kMyErr_noErr != (err =
			ReadBuffUi5LE(&b)))
		{
			/* fail */
		} else {
			err = kMyErr_noErr;
			*i = b;
		}
	} else
#endif
	if (uimbl2sz == elsz) {
		if (kMyErr_noErr != (err =
			ReadBuffUimLE(i)))
		{
			/* fail */
		} else {
			err = kMyErr_noErr;
		}
	} else
	{
		err = ReadLargeFormatInt_v2(elsz, i);
	}

	return ErrReportStack(err, "ReadBuffUiElszLE");
}

#define untypenorm 0
#define untypeinf  1
#define untypenan  2

GLOBALFUNC tMyErr ReadShoeArbInt_v2(uimr *i, ui3r *untype)
{
	tMyErr err;
	ui3r v;

	if (kMyErr_noErr != (err =
		ReadBuffToByte(&v)))
	{
		/* fail */
	} else
	if (v < 240) {
		err = kMyErr_noErr;
		*i = v;
		*untype = untypenorm;
	} else
	if ((v -= 240) < 8) {
		ui3r b;

		if (kMyErr_noErr != (err =
			ReadBuffToByte(&b)))
		{
			/* fail */
		} else {
			err = kMyErr_noErr;
			*i = (((uimr)b) << 3) | v;
			*untype = untypenorm;
		}
	} else
	if ((v -= 8) < 5) {
		*untype = untypenorm;
		err = ReadBuffUiElszLE(v + 4, i);
	} else
	if (v == 7) {
		err = kMyErr_noErr;
		*untype = untypenan;
	} else
	if (v == 6) {
		err = kMyErr_noErr;
		*untype = untypeinf;
	} else
	{
		/* recursive case */
		uimr elsz0;
		ui3r elszuntype;

		if (kMyErr_noErr != (err =
			ReadShoeArbInt_v2(&elsz0, &elszuntype)))
		{
			/* fail */
		} else if (elszuntype != untypenorm) {
			err = kMyErr_crptfl;
		} else if (elsz0 > 14) {
			/*
				could use elsz0 < 35, but would prefer
				to avoid taking forever if get here
				by accident
			*/
			/* ShoeLvl1ErrorCode = ShoeL1ErrArbInt87ElszBig; */
			err = kMyErr_crptfl;
		} else {
			err = ReadBuffUiElszLE((ui3r)elsz0, i);
		}
	}

	return ErrReportStack(err, "ReadShoeArbInt_v2");
}

GLOBALFUNC tMyErr ReadArbIntNorm(uimr *i)
{
	tMyErr err;
	ui3r untype;

	if (kMyErr_noErr != (err =
		ReadShoeArbInt_v2(i, &untype)))
	{
		/* fail */
	} else if (untypenorm == untype) {
		err = kMyErr_noErr;
	} else {
		err = kMyErr_crptfl;
	}

	return ErrReportStack(err, "ReadArbIntNorm");
}


GLOBALFUNC tMyErr WriteArbIntNorm_v2(uimr i)
{
	tMyErr err;

	if (i < 240) {
		err = WriteBuffFromByte((ui3r)i);
	} else if (i < 2048) {
		if (kMyErr_noErr != (err =
			WriteBuffFromByte((ui3r)((i & 0x07) + 240))))
		{
			/* fail */
		} else {
			err = WriteBuffFromByte((ui3r)(i >> 3));
		}
	} else
#if uimbl2sz > 4
	if (0 == (i >> 16)) {
		if (kMyErr_noErr != (err =
			WriteBuffFromByte(248)))
		{
			/* fail */
		} else {
			err = WriteBuffUi4LE((ui4r)i);
		}
	} else
#endif
#if uimbl2sz > 5
	if (0 == (i >> 32)) {
		if (kMyErr_noErr != (err =
			WriteBuffFromByte(249)))
		{
			/* fail */
		} else {
			err = WriteBuffUi5LE((ui5r)i);
		}
	} else
#endif
	{
		if (kMyErr_noErr != (err =
			WriteBuffFromByte(248 + (uimbl2sz - 4))))
		{
			/* fail */
		} else {
			err = WriteBuffUimLE((ui5r)i);
		}
	}

	return ErrReportStack(err, "WriteArbIntNorm_v2");
}

GLOBALFUNC tMyErr WriteInfArbInt_v2(void)
{
	tMyErr err;

	err = WriteBuffFromByte(254);

	return ErrReportStack(err, "WriteInfArbInt_v2");
}

GLOBALFUNC tMyErr WriteNanArbInt_v2(void)
{
	tMyErr err;

	err = WriteBuffFromByte(255);

	return ErrReportStack(err, "WriteNanArbInt_v2");
}
