#ifdef Have_CFGCMPTL
#include "CFGCMPTL.h"
#endif

#ifndef AlreadyHaveStdIncludes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#endif

#ifndef ForMPWTool
#ifdef applec
#define ForMPWTool 1
#else
#define ForMPWTool 0
#endif
#endif

#define DebugCheck 0

#include "COREDEFS.h"
#if DebugCheck
#include "DBGLGSTC.h"
#endif
#include "POW2UTIL.h"

#if ForMPWTool
#include "IMATHOPT.h"
#else
#define MyMoveBytes(src, dst, n) \
	(void) memmove((void *)(dst), (void *)(src), n)
#endif

#include "STRUTILS.h"
#include "SAVEDERR.h"

#if ForMPWTool
#define HaveTempBuffH 0
#include "MYMEMORY.h"
#else
#include "FHMEMORY.h"
#endif

#include "HANDUTIL.h"


#if ForMPWTool
GLOBALFUNC char * GetTextForSavedSysErr_v2(tMyErr err)
{
#pragma unused(err)

	return "Unknown error";
}

#include "TOOLUTIL.h"
#else
#define CheckAbortRequested() kMyErr_noErr
#endif

LOCALFUNC tMyErr SetSyntaxErrCStr(char *s,
	uimr offsetA, uimr offsetB)
{
	fprintf(stderr, "Syntax error: %s\n", s);
	fprintf(stderr, "Offset Range: %d:%d\n",
		(int)offsetA, (int)offsetB);

	return kMyErrSyntaxErr;
}

#include "MPINTLIB.h"
#include "MD5CHKSB.h"
#include "CRCCHKSM.h"
#include "RDWRSTRM.h"

#include "RWARBINT.h"
#include "PKCOMLIB.h"
#include "PKGRYLIB.h"

#include "STCFLRWH.h"

static tMyErr gry_dispatch_checksig(char *inputfile, char *pubkey_f)
{
	tMyErr err;
	MyHandle inputH;
	MyHandle keyH;

	if (kMyErr_noErr == (err =
		ReadFilePathToNewHand2(pubkey_f, &keyH)))
	{
		if (kMyErr_noErr == (err =
			ReadFilePathToNewHand2(inputfile, &inputH)))
		{
			err = gry_dispatch_checksig_0(inputH, keyH);

			MyHandleDispose_v2(inputH);
		}

		MyHandleDispose_v2(keyH);
	}

	return err;
}

int main(int argc, char *argv[])
{
	int return_val = 1;

#if ForMPWTool
	InitMyMPWtool();
#endif

	if (argc != 3) {
		fprintf(stderr, "wrong number of arguments\n");
	} else {
		tMyErr err = gry_dispatch_checksig(argv[1], argv[2]);

		if (0 != err) {
			/*
				not "return_val = err;".
				It turns out that anything outside of 0..125
				is not portable.
			*/
		} else {
			return_val = 0;
		}
	}

#if ForMPWTool
	UninitMyMPWtool();
#endif

	return return_val;
}
